/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.security.ltpa;

import com.ibm.WebSphereSecurity.AuthenticationFailedException;
import com.ibm.WebSphereSecurity.AuthenticationNotSupportedException;
import com.ibm.WebSphereSecurity.BasicAuthData;
import com.ibm.WebSphereSecurity.Credential;
import com.ibm.WebSphereSecurity.InvalidTokenException;
import com.ibm.WebSphereSecurity.TokenExpiredException;
import com.ibm.WebSphereSecurity.ValidationFailedException;
import com.ibm.WebSphereSecurity.ValidationNotSupportedException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.security.auth.CredentialMapFailedException;
import com.ibm.ejs.security.auth.CredentialMapNotSupportedException;
import com.ibm.ejs.security.ltpa.LTPAConfig;
import com.ibm.ejs.security.ltpa.LTPACrypto;
import com.ibm.ejs.security.ltpa.LTPADigSignature;
import com.ibm.ejs.security.ltpa.LTPAPrivateKey;
import com.ibm.ejs.security.ltpa.LTPAPublicKey;
import com.ibm.ejs.security.ltpa.LTPAServerBean;
import com.ibm.ejs.security.ltpa.LTPAToken;
import com.ibm.ejs.security.ltpa.LTPATokenizer;
import com.ibm.ejs.security.ltpa.UserData;
import com.ibm.ejs.security.registry.NoSuchEntryException;
import com.ibm.ejs.security.registry.Registry;
import com.ibm.ejs.security.registry.RegistryEntry;
import com.ibm.ejs.security.registry.RegistryEntryHome;
import com.ibm.ejs.security.registry.RegistryErrorException;
import com.ibm.ejs.security.registry.UnsupportedEntryTypeException;
import com.ibm.ejs.security.util.Base64Coder;
import com.ibm.ejs.security.util.Constants;
import com.ibm.ejs.security.util.TypedStringCollection;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.ejb.FinderException;
import javax.ejb.SessionContext;
import javax.rmi.PortableRemoteObject;

public class LTPAServerObject {
    private static final String nullString = new String();
    private static final String[] nullStringArray = new String[0];
    private SessionContext mySessionCtx = null;
    private static Registry userRegistry;
    private static RegistryEntryHome userEntryHome;
    protected static final byte[] nullByteArray;
    private static LTPAPublicKey ltpaPubKey;
    private static LTPAPrivateKey ltpaPrivKey;
    private static long expirationLimit;
    private static byte[] sharedKey;
    private static boolean password2bIncluded;
    private LTPAConfig config = null;
    private static String registryType;
    private static boolean useSecurityNameInCustomRegistry;
    private static final TraceComponent tc;
    static /* synthetic */ Class class$com$ibm$ejs$security$ltpa$LTPAServerObject;
    static /* synthetic */ Class class$com$ibm$ejs$security$registry$RegistryEntry;

    public LTPAServerObject() {
        userRegistry = LTPAServerBean.userRegistry;
        userEntryHome = LTPAServerBean.userEntryHome;
        ltpaPubKey = LTPAServerBean.ltpaPubKey;
        ltpaPrivKey = LTPAServerBean.ltpaPrivKey;
        sharedKey = LTPAServerBean.sharedKey;
        expirationLimit = LTPAServerBean.expirationLimit;
        try {
            registryType = userRegistry.getType();
        }
        catch (RegistryErrorException registryErrorException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        useSecurityNameInCustomRegistry = false;
        if (registryType.equalsIgnoreCase("CUSTOM")) {
            try {
                String string = System.getProperty("com.ibm.ejs.security.customregistry.useSecurityName");
                if (string.equalsIgnoreCase("true")) {
                    useSecurityNameInCustomRegistry = true;
                    Tr.debug((TraceComponent)tc, (String)"com.ibm.ejs.security.customregistry.useSecurityName=true");
                }
            }
            catch (Exception exception) {
                useSecurityNameInCustomRegistry = false;
            }
        }
    }

    public Credential authenticate(BasicAuthData basicAuthData) throws AuthenticationFailedException, AuthenticationNotSupportedException, RemoteException {
        Tr.entry((TraceComponent)tc, (String)"authenticate");
        Credential credential = null;
        if (basicAuthData.userId.equals("")) {
            byte[] byArray = LTPAServerObject.toBytes(basicAuthData.password);
            try {
                credential = this.authenticateLoginToken(byArray);
            }
            catch (InvalidTokenException invalidTokenException) {
                Tr.exit((TraceComponent)tc, (String)"Token authentication failed ", (Object)((Object)invalidTokenException));
                throw new AuthenticationFailedException();
            }
        } else {
            credential = userRegistry.authenticate(basicAuthData);
        }
        try {
            credential = this.createCredential(credential, basicAuthData);
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"Authentication failed in LTPA", (Object)exception);
            throw new AuthenticationFailedException();
        }
        Tr.exit((TraceComponent)tc, (String)"authenticate");
        return credential;
    }

    public Credential authenticateLoginToken(byte[] byArray) throws InvalidTokenException, AuthenticationFailedException, AuthenticationNotSupportedException, RemoteException {
        Tr.entry((TraceComponent)tc, (String)"authenticateLoginToken");
        LTPACrypto lTPACrypto = new LTPACrypto();
        byte[] byArray2 = Base64Coder.base64Decode((byte[])byArray);
        byte[] byArray3 = LTPACrypto.decrypt((byte[])byArray2, (byte[])sharedKey);
        if (byArray3 == null) {
            throw new AuthenticationFailedException();
        }
        String string = null;
        try {
            string = new String(byArray3, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthenticationFailedException();
        }
        String[] stringArray = LTPATokenizer.parseToken((String)string);
        Hashtable hashtable = LTPATokenizer.parseUserData((String)stringArray[0]);
        String string2 = (String)hashtable.get("u");
        String string3 = (String)hashtable.get("p");
        Credential credential = this.authenticate(new BasicAuthData(string2, string3));
        Tr.exit((TraceComponent)tc, (String)"authenticateLoginToken");
        return credential;
    }

    public Credential validate(byte[] byArray) throws InvalidTokenException, TokenExpiredException, ValidationNotSupportedException, ValidationFailedException, RemoteException {
        Tr.entry((TraceComponent)tc, (String)"validate");
        if (byArray == null) {
            Tr.exit((TraceComponent)tc, (String)"validate: LTPA validate failed");
            throw new InvalidTokenException();
        }
        LTPAToken lTPAToken = LTPAToken.getInstance((byte[])byArray, (byte[])sharedKey);
        try {
            if (!lTPAToken.isValid()) {
                Tr.exit((TraceComponent)tc, (String)"validate: token expired");
                throw new TokenExpiredException();
            }
            if (!this.verify((PublicKey)ltpaPubKey, lTPAToken)) {
                Tr.exit((TraceComponent)tc, (String)"validate: token not valid");
                throw new InvalidTokenException();
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Tr.exit((TraceComponent)tc, (String)"validate: LTPA token validation failed", (Object)noSuchAlgorithmException);
            throw new ValidationFailedException();
        }
        Tr.debug((TraceComponent)tc, (String)"validation successful - to create credential");
        try {
            Credential credential = this.createCredential(lTPAToken);
            Tr.exit((TraceComponent)tc, (String)"validate");
            return credential;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"validate: LTPA validation failed", (Object)exception);
            throw new ValidationFailedException();
        }
    }

    private boolean verify(PublicKey publicKey, LTPAToken lTPAToken) throws NoSuchAlgorithmException {
        boolean bl = false;
        String string = lTPAToken.getUserData().toString();
        byte[] byArray = lTPAToken.getSignature();
        byte[] byArray2 = LTPAServerObject.toBytes(string);
        bl = LTPADigSignature.verify((byte[])byArray2, (byte[])byArray, (LTPAPublicKey)ltpaPubKey);
        return bl;
    }

    public byte[] issueLoginToken(BasicAuthData basicAuthData) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"issueLoginToken");
        long l = new Date().getTime();
        UserData userData = new UserData(basicAuthData.userId);
        userData.setAttribute("p", basicAuthData.password);
        String string = userData.toString() + "%" + String.valueOf(l);
        LTPACrypto lTPACrypto = new LTPACrypto();
        byte[] byArray = null;
        try {
            byArray = LTPACrypto.encrypt((byte[])string.getBytes("UTF8"), (byte[])((byte[])sharedKey.clone()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.reportError(unsupportedEncodingException, Constants.nls.getString("security.encoding.notsupp", "Unsupported encoding"));
        }
        if (byArray == null) {
            throw new RemoteException(Constants.nls.getString("security.authn.invalid.data", "Invalid authentication data"));
        }
        Tr.exit((TraceComponent)tc, (String)"issueLoginToken");
        return Base64Coder.base64Encode((byte[])byArray);
    }

    public void setSessionContext(SessionContext sessionContext) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"setSessionContext");
        this.mySessionCtx = sessionContext;
        Tr.exit((TraceComponent)tc, (String)"setSessionContext");
    }

    void sign(LTPAToken lTPAToken) throws NoSuchAlgorithmException {
        byte[] byArray = null;
        String string = lTPAToken.getUserData().toString();
        byte[] byArray2 = LTPAServerObject.toBytes(string);
        byArray = LTPADigSignature.sign((byte[])byArray2, (LTPAPrivateKey)ltpaPrivKey);
        lTPAToken.setSignature(byArray);
    }

    public Credential mapCredential(Credential credential) throws CredentialMapNotSupportedException, CredentialMapFailedException, RemoteException {
        Tr.entry((TraceComponent)tc, (String)"mapCredential");
        Credential credential2 = null;
        try {
            if (credential.accessId.equals("TrustAssociation")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"TrustAssociation id in the Credential");
                }
                credential2 = this.mapTrustAssociationUserCredential(credential);
            } else {
                credential2 = userRegistry.mapCredential(credential);
            }
            credential2 = this.createCredential(credential2, credential);
        }
        catch (Exception exception) {
            String string = Constants.nls.getString("security.ltpa.credmap.failed", "Credential mapping failed") + exception.getMessage();
            Tr.error((TraceComponent)tc, (String)string, (Object)exception);
            throw new CredentialMapFailedException(string);
        }
        Tr.exit((TraceComponent)tc, (String)"mapCredential");
        return credential2;
    }

    protected Credential mapTrustAssociationUserCredential(Credential credential) throws CredentialMapFailedException, RegistryErrorException, RemoteException {
        Credential credential2;
        block14: {
            Tr.entry((TraceComponent)tc, (String)"mapTrustAssociationUserCredential");
            String string = new String(credential.credentialToken);
            Enumeration enumeration = null;
            credential2 = null;
            try {
                String string2 = null;
                RegistryEntry registryEntry = null;
                try {
                    enumeration = userEntryHome.findAllByPattern(string);
                }
                catch (RemoteException remoteException) {
                    this.reportError(remoteException, Constants.nls.getString("security.registry.exception", "Registry exception"));
                }
                catch (FinderException finderException) {
                    this.reportError((Exception)((Object)finderException), Constants.nls.getString("security.registry.userentry.notfound", "User entry is not found in the registry"));
                }
                if (enumeration.hasMoreElements()) {
                    registryEntry = (RegistryEntry)PortableRemoteObject.narrow(enumeration.nextElement(), (Class)(class$com$ibm$ejs$security$registry$RegistryEntry == null ? (class$com$ibm$ejs$security$registry$RegistryEntry = LTPAServerObject.class$("com.ibm.ejs.security.registry.RegistryEntry")) : class$com$ibm$ejs$security$registry$RegistryEntry));
                    try {
                        string2 = registryEntry.getSecurityName();
                    }
                    catch (RemoteException remoteException) {
                        this.reportError(remoteException, Constants.nls.getString("security.registry.exception", "Registry exception"));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found user: ", (Object)string2);
                    }
                    if (enumeration.hasMoreElements()) {
                        CredentialMapFailedException credentialMapFailedException = new CredentialMapFailedException("Multiple users found in the registry.");
                        Tr.exit((TraceComponent)tc, (String)"authenticate", (Object)((Object)credentialMapFailedException));
                        throw credentialMapFailedException;
                    }
                    credential2 = this.createCredential(registryEntry);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Created a credential for " + string2));
                    }
                    break block14;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"User was not found ...");
                }
                CredentialMapFailedException credentialMapFailedException = new CredentialMapFailedException("User not found in regist ry.");
                Tr.exit((TraceComponent)tc, (String)"mapTrustAssociationUserCredential", (Object)((Object)credentialMapFailedException));
                throw credentialMapFailedException;
            }
            catch (RegistryErrorException registryErrorException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("RegistryErrorException thrown when retrieving user " + string));
                }
                throw registryErrorException;
            }
            catch (NoSuchEntryException noSuchEntryException) {
                Tr.exit((TraceComponent)tc, (String)"authenticate", (Object)((Object)noSuchEntryException));
                String string3 = new String(new StringBuffer("User").append(string).append(" not found in LDAP registry."));
                throw new CredentialMapFailedException(string3);
            }
        }
        return credential2;
    }

    protected Credential createCredential(RegistryEntry registryEntry) throws RegistryErrorException, NoSuchEntryException, RemoteException {
        Tr.entry((TraceComponent)tc, (String)"createCredential(RegistryEntry)");
        String[] stringArray = nullStringArray;
        String[] stringArray2 = nullStringArray;
        String string = null;
        try {
            string = registryEntry.getPrivilegeAttributeId();
        }
        catch (UnsupportedEntryTypeException unsupportedEntryTypeException) {
            this.reportError((Exception)((Object)unsupportedEntryTypeException), Constants.nls.getString("security.registry.exception", "Registry exception"));
        }
        catch (RemoteException remoteException) {
            this.reportError(remoteException, Constants.nls.getString("security.registry.exception", "Registry exception"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("accessId : " + string));
        }
        String string2 = "";
        try {
            if (!useSecurityNameInCustomRegistry) {
                string2 = registryEntry.getDisplayName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 == null || string2.length() == 0 || useSecurityNameInCustomRegistry) {
            string2 = registryEntry.getSecurityName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("security name: " + string2));
        }
        TypedStringCollection[] typedStringCollectionArray = null;
        try {
            typedStringCollectionArray = userRegistry.getAssociatedPrivilegeAttributeIds(string);
        }
        catch (RegistryErrorException registryErrorException) {
            this.reportError((Exception)((Object)registryErrorException), Constants.nls.getString("security.registry.exception", "Registry exception"));
        }
        catch (UnsupportedEntryTypeException unsupportedEntryTypeException) {
            this.reportError((Exception)((Object)unsupportedEntryTypeException), Constants.nls.getString("security.registry.exception", "Registry exception"));
        }
        catch (NoSuchEntryException noSuchEntryException) {
            this.reportError((Exception)((Object)noSuchEntryException), Constants.nls.getString("security.registry.exception", "Registry exception"));
        }
        int n = 0;
        while (n < typedStringCollectionArray.length) {
            if (typedStringCollectionArray[n].getType().equals("group")) {
                stringArray = (String[])typedStringCollectionArray[n].getElements();
            } else if (typedStringCollectionArray[n].getType().equals("role")) {
                stringArray2 = (String[])typedStringCollectionArray[n].getElements();
            }
            ++n;
        }
        Credential credential = new Credential(nullByteArray, -1L, string2, string, stringArray, nullString, stringArray2);
        Tr.exit((TraceComponent)tc, (String)"createCredential(RegistryEntry)");
        return credential;
    }

    private void debug(String string) {
        System.out.println("LTPAServerBean: " + string);
    }

    protected Credential createCredential(Credential credential, Object object) throws AuthenticationFailedException, RemoteException {
        String string = credential.accessId;
        if (string == null) {
            Tr.error((TraceComponent)tc, (String)Constants.nls.getString("security.ltpa.credmap.failed.nullaccessid", "Credential mapping failed due to invalid accessid"));
            throw new AuthenticationFailedException();
        }
        if ("LDAP".equalsIgnoreCase(registryType)) {
            string = this.getNormalizeAccessIdOutBound(string);
            Tr.debug((TraceComponent)tc, (String)("accessID (in Ltpa Token):" + string));
        }
        LTPAToken lTPAToken = new LTPAToken(string, expirationLimit + new Date().getTime());
        if (object instanceof BasicAuthData) {
            BasicAuthData basicAuthData = (BasicAuthData)object;
            if (password2bIncluded) {
                lTPAToken.setAttribute("p", basicAuthData.password);
            }
        }
        try {
            this.sign(lTPAToken);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Tr.debug((TraceComponent)tc, (String)"No such algorithm exception", (Object)noSuchAlgorithmException);
            throw new AuthenticationFailedException();
        }
        lTPAToken.encrypt((byte[])sharedKey.clone());
        credential.credentialToken = lTPAToken.getBytes();
        credential.expiration = lTPAToken.getExpiration();
        return credential;
    }

    Credential createCredential(LTPAToken lTPAToken) throws RemoteException {
        String string;
        Tr.entry((TraceComponent)tc, (String)"createCredential");
        String[] stringArray = nullStringArray;
        String[] stringArray2 = nullStringArray;
        RegistryEntry registryEntry = null;
        String string2 = lTPAToken.getAccessID();
        try {
            registryEntry = userEntryHome.findByPrivilegeAttributeId(string2);
        }
        catch (FinderException finderException) {
            this.reportError((Exception)((Object)finderException), Constants.nls.getString("security.registry.userentry.notfound", "User entry is not found in the registry"));
        }
        if ("LDAP".equalsIgnoreCase(registryType)) {
            string = registryEntry.getSecurityName();
            string2 = this.getNormalizedAccessIdInBound(string2, string);
            Tr.debug((TraceComponent)tc, (String)("accessID (in creds):" + string2));
        }
        string = "";
        try {
            if (!useSecurityNameInCustomRegistry) {
                string = registryEntry.getDisplayName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null || string.length() == 0 || useSecurityNameInCustomRegistry) {
            string = registryEntry.getSecurityName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("security name: " + string));
        }
        TypedStringCollection[] typedStringCollectionArray = null;
        try {
            typedStringCollectionArray = userRegistry.getAssociatedPrivilegeAttributeIds(string2);
        }
        catch (RegistryErrorException registryErrorException) {
            this.reportError((Exception)((Object)registryErrorException), Constants.nls.getString("security.registry.exception", "Registry exception"));
        }
        catch (UnsupportedEntryTypeException unsupportedEntryTypeException) {
            this.reportError((Exception)((Object)unsupportedEntryTypeException), Constants.nls.getString("security.registry.exception", "Registry exception"));
        }
        catch (NoSuchEntryException noSuchEntryException) {
            this.reportError((Exception)((Object)noSuchEntryException), Constants.nls.getString("security.registry.exception", "Registry exception"));
        }
        int n = 0;
        while (n < typedStringCollectionArray.length) {
            if (typedStringCollectionArray[n].getType().equals("group")) {
                stringArray = (String[])typedStringCollectionArray[n].getElements();
            } else if (typedStringCollectionArray[n].getType().equals("role")) {
                stringArray2 = (String[])typedStringCollectionArray[n].getElements();
            }
            ++n;
        }
        Credential credential = new Credential(lTPAToken.getBytes(), lTPAToken.getExpiration(), string, string2, stringArray, nullString, stringArray2);
        Tr.exit((TraceComponent)tc, (String)"createCredential for accessId:", (Object)string2);
        return credential;
    }

    public long getExpirationTimeLimit() {
        return expirationLimit;
    }

    private String getNormalizeAccessIdOutBound(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = true;
        int n2 = 32;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (bl) {
                if (c != ' ') {
                    stringBuffer.append(c);
                    bl = false;
                }
            } else {
                if ((c == ',' || c == ';') && n2 != 92) {
                    bl = true;
                }
                stringBuffer.append(c);
            }
            n2 = c;
            ++n3;
        }
        return stringBuffer.toString();
    }

    private String getNormalizedAccessIdInBound(String string, String string2) {
        int n = string.indexOf(47);
        if (n != -1) {
            String string3 = string.substring(0, n + 1);
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
        return string;
    }

    private static byte[] toBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tr.debug((TraceComponent)tc, (String)("to UTF8 bytes =" + unsupportedEncodingException.toString()));
        }
        return byArray;
    }

    private void reportError(Exception exception, String string) throws RemoteException {
        Tr.debug((TraceComponent)tc, (String)string, (Object)exception);
        throw new RemoteException(string, exception);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        nullByteArray = new byte[0];
        password2bIncluded = false;
        registryType = null;
        useSecurityNameInCustomRegistry = false;
        tc = Tr.register((Class)(class$com$ibm$ejs$security$ltpa$LTPAServerObject == null ? (class$com$ibm$ejs$security$ltpa$LTPAServerObject = LTPAServerObject.class$("com.ibm.ejs.security.ltpa.LTPAServerObject")) : class$com$ibm$ejs$security$ltpa$LTPAServerObject));
    }
}

