/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.security.registry;

import com.ibm.WebSphereSecurity.AuthenticationFailedException;
import com.ibm.WebSphereSecurity.AuthenticationNotSupportedException;
import com.ibm.WebSphereSecurity.BasicAuthData;
import com.ibm.WebSphereSecurity.Credential;
import com.ibm.WebSphereSecurity.InvalidTokenException;
import com.ibm.WebSphereSecurity.TokenExpiredException;
import com.ibm.WebSphereSecurity.ValidationFailedException;
import com.ibm.WebSphereSecurity.ValidationNotSupportedException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.security.SecurityContext;
import com.ibm.ejs.security.auth.CredentialMapFailedException;
import com.ibm.ejs.security.auth.CredentialMapNotSupportedException;
import com.ibm.ejs.security.registry.Entry;
import com.ibm.ejs.security.registry.NoSuchEntryException;
import com.ibm.ejs.security.registry.RegistryEntryHome;
import com.ibm.ejs.security.registry.RegistryErrorException;
import com.ibm.ejs.security.registry.RegistryImpl;
import com.ibm.ejs.security.registry.RegistryImplFactory;
import com.ibm.ejs.security.registry.Result;
import com.ibm.ejs.security.registry.UnsupportedEntryTypeException;
import com.ibm.ejs.security.util.Constants;
import com.ibm.ejs.security.util.TypedStringCollection;
import com.ibm.ejs.sm.active.ActiveSecurityConfigConfig;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.exception.ActiveObjectException;
import com.ibm.ejs.sm.server.ManagedServer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class RegistryBean
implements SessionBean {
    private SessionContext ctx = null;
    private static RegistryImplFactory registryFactory;
    private static RegistryImpl registryImpl;
    private static ActiveSecurityConfigConfig activeConfig;
    private static TraceComponent tc;
    static /* synthetic */ Class class$com$ibm$ejs$security$registry$RegistryBean;
    static /* synthetic */ Class class$com$ibm$ejs$security$registry$RegistryEntryHome;

    public static synchronized void configUpdated(ActiveSecurityConfigConfig activeSecurityConfigConfig) throws ActiveObjectException {
        boolean bl = false;
        boolean bl2 = false;
        if (registryFactory != null) {
            bl = !activeConfig.getUserRegistry().equals(activeSecurityConfigConfig.getUserRegistry());
            boolean bl3 = bl2 = !activeConfig.getUserRegistryFactoryClass().equals(activeSecurityConfigConfig.getUserRegistryFactoryClass()) || !((Hashtable)activeConfig.getUserRegistryProperties()).equals(activeSecurityConfigConfig.getUserRegistryProperties());
            if (bl || bl2) {
                registryFactory.remove(activeConfig.getUserRegistry(), activeConfig.getUserRegistryProperties());
            }
        } else {
            bl = true;
            bl2 = true;
        }
        activeConfig = activeSecurityConfigConfig;
        if (bl) {
            try {
                registryFactory = (RegistryImplFactory)Class.forName(activeSecurityConfigConfig.getUserRegistryFactoryClass()).newInstance();
            }
            catch (Exception exception) {
                String string = Constants.nls.getString("security.registry.createerror", "Error creation user registry");
                Tr.error((TraceComponent)tc, (String)string, (Object)exception);
                throw new ActiveObjectException(string);
            }
        }
        if (bl2) {
            try {
                registryImpl = registryFactory.getRegistryImpl(activeSecurityConfigConfig.getUserRegistry(), activeSecurityConfigConfig.getUserRegistryProperties());
            }
            catch (RegistryErrorException registryErrorException) {
                String string = Constants.nls.getString("security.registry.createerror", "Error creation user registry");
                if (!SecurityContext.isSecurityEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)string, (Object)((Object)registryErrorException));
                    Tr.debug((TraceComponent)tc, (String)string, (Object)((Object)registryErrorException));
                }
                Tr.error((TraceComponent)tc, (String)string, (Object)((Object)registryErrorException));
                throw new ActiveObjectException(string);
            }
        }
    }

    public Credential authenticate(BasicAuthData basicAuthData) throws AuthenticationNotSupportedException, AuthenticationFailedException {
        Tr.entry((TraceComponent)tc, (String)"authenticate");
        try {
            Credential credential = RegistryBean.getRegistryImpl().authenticate(basicAuthData);
            Tr.exit((TraceComponent)tc, (String)"authenticate");
            return credential;
        }
        catch (RegistryErrorException registryErrorException) {
            Tr.exit((TraceComponent)tc, (String)"authenticate", (Object)((Object)registryErrorException));
            throw new AuthenticationFailedException();
        }
    }

    public TypedStringCollection[] getAssociatedPrivilegeAttributeIds(String string) throws RegistryErrorException, UnsupportedEntryTypeException, NoSuchEntryException {
        Tr.entry((TraceComponent)tc, (String)"getAssociatedPrivilegeAttributes");
        TypedStringCollection[] typedStringCollectionArray = RegistryBean.getRegistryImpl().getAssociatedPrivilegeAttributeIds(string);
        Tr.exit((TraceComponent)tc, (String)"getAssociatedPrivilegeAttributes");
        return typedStringCollectionArray;
    }

    public RegistryEntryHome getRegistryEntryHome(String string) throws UnsupportedEntryTypeException {
        Tr.entry((TraceComponent)tc, (String)"getRegistryEntryHome", (Object)string);
        RegistryEntryHome registryEntryHome = null;
        try {
            String string2 = string + "RegistryEntryHome";
            Context context = RepositoryObjectImpl.getInitialNamingContext();
            Object object = context.lookup(ManagedServer.getInstance().qualifyRepositoryHomeName(string2));
            registryEntryHome = (RegistryEntryHome)PortableRemoteObject.narrow((Object)object, (Class)(class$com$ibm$ejs$security$registry$RegistryEntryHome == null ? (class$com$ibm$ejs$security$registry$RegistryEntryHome = RegistryBean.class$("com.ibm.ejs.security.registry.RegistryEntryHome")) : class$com$ibm$ejs$security$registry$RegistryEntryHome));
        }
        catch (NamingException namingException) {
            Tr.error((TraceComponent)tc, (String)Constants.nls.getFormattedMessage("security.registry.unsupported.entrytype", new Object[]{string}, "Unsupported entry type {0}"), (Object)namingException);
            throw new UnsupportedEntryTypeException(string);
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)Constants.nls.getString("security.registryentry.createerror", "Error creating registry entry home"), (Object)exception);
            throw new UnsupportedEntryTypeException(exception.toString());
        }
        Tr.exit((TraceComponent)tc, (String)"getRegistryEntryHome");
        return registryEntryHome;
    }

    public String getRealm() throws RegistryErrorException {
        Tr.entry((TraceComponent)tc, (String)"getRealm");
        String string = RegistryBean.getRegistryImpl().getRealm();
        Tr.exit((TraceComponent)tc, (String)"getRealm");
        return string;
    }

    public String[] getSupportedEntryTypes() throws RegistryErrorException {
        Tr.entry((TraceComponent)tc, (String)"getSupportedEntryTypes");
        String[] stringArray = RegistryBean.getRegistryImpl().getSupportedEntryTypes();
        Tr.exit((TraceComponent)tc, (String)"getSupportedEntryTypes");
        return stringArray;
    }

    public String getType() throws RegistryErrorException {
        Tr.entry((TraceComponent)tc, (String)"getType");
        String string = RegistryBean.getRegistryImpl().getType();
        Tr.exit((TraceComponent)tc, (String)"getType");
        return string;
    }

    public Credential mapCredential(Credential credential) throws CredentialMapNotSupportedException, CredentialMapFailedException {
        Tr.entry((TraceComponent)tc, (String)"mapCredential");
        try {
            Credential credential2 = RegistryBean.getRegistryImpl().mapCredential(credential);
            Tr.exit((TraceComponent)tc, (String)"mapCredential");
            return credential2;
        }
        catch (RegistryErrorException registryErrorException) {
            Tr.exit((TraceComponent)tc, (String)"mapCredential", (Object)((Object)registryErrorException));
            throw new CredentialMapFailedException(registryErrorException.getMessage());
        }
    }

    public Credential validate(byte[] byArray) throws InvalidTokenException, TokenExpiredException, ValidationNotSupportedException, ValidationFailedException {
        Tr.entry((TraceComponent)tc, (String)"validate");
        try {
            Credential credential = RegistryBean.getRegistryImpl().validate(byArray);
            Tr.exit((TraceComponent)tc, (String)"validate");
            return credential;
        }
        catch (RegistryErrorException registryErrorException) {
            Tr.exit((TraceComponent)tc, (String)"validate", (Object)((Object)registryErrorException));
            throw new ValidationFailedException();
        }
    }

    public static RegistryImpl getRegistryImpl() {
        return registryImpl;
    }

    public void ejbActivate() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbActivate");
        Tr.exit((TraceComponent)tc, (String)"ejbActivate");
    }

    public void ejbCreate() throws CreateException {
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        Tr.exit((TraceComponent)tc, (String)"ejbCreate");
    }

    public void ejbPassivate() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbPassivate");
        Tr.exit((TraceComponent)tc, (String)"ejbPassivate");
    }

    public void ejbRemove() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public void setSessionContext(SessionContext sessionContext) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"setSessionContext");
        this.ctx = sessionContext;
        Tr.exit((TraceComponent)tc, (String)"setSessionContext");
    }

    public Result getEntries(String string, String string2) throws RegistryErrorException, RemoteException, UnsupportedEntryTypeException {
        Object object;
        ArrayList arrayList = new ArrayList(1001);
        boolean bl = registryImpl.getEntries(string, arrayList, string2);
        ArrayList<Entry> arrayList2 = new ArrayList<Entry>(arrayList.size());
        int n = 0;
        while (n < arrayList.size()) {
            object = null;
            String string3 = null;
            try {
                object = registryImpl.getDisplayName(string, (String)arrayList.get(n));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Entry entry = new Entry((String)arrayList.get(n), (String)object, string3, string);
            arrayList2.add(entry);
            ++n;
        }
        object = new Result();
        object.setList(arrayList2);
        if (bl) {
            object.setHasMore();
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        registryImpl = null;
        tc = Tr.register((Class)(class$com$ibm$ejs$security$registry$RegistryBean == null ? (class$com$ibm$ejs$security$registry$RegistryBean = RegistryBean.class$("com.ibm.ejs.security.registry.RegistryBean")) : class$com$ibm$ejs$security$registry$RegistryBean));
    }
}

