/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.agent;

import com.ibm.ejs.sm.agent.ContainmentPathElem;
import com.ibm.ejs.sm.exception.InvalidContainmentPathException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class ContainmentPath
implements Serializable {
    private Vector contents;
    private static String seperator = "/";

    public ContainmentPath() {
        this.contents = new Vector(1);
    }

    public ContainmentPath(Vector vector) {
        this.contents = vector;
    }

    public ContainmentPath(ContainmentPath containmentPath) {
        this.contents = new Vector(containmentPath.length());
        int n = 0;
        while (n < containmentPath.length()) {
            this.contents.addElement(containmentPath.contents.elementAt(n));
            ++n;
        }
    }

    public void addElement(ContainmentPathElem containmentPathElem) {
        this.contents.addElement(containmentPathElem);
    }

    public ContainmentPath add(ContainmentPath containmentPath) {
        ContainmentPath containmentPath2 = new ContainmentPath(this);
        Enumeration enumeration = containmentPath.enumerate();
        while (enumeration.hasMoreElements()) {
            containmentPath2.addElement((ContainmentPathElem)enumeration.nextElement());
        }
        return containmentPath2;
    }

    public Enumeration enumerate() {
        return this.contents.elements();
    }

    public ContainmentPathElem getRootElement() {
        if (this.contents.size() > 0) {
            return (ContainmentPathElem)this.contents.elementAt(0);
        }
        return null;
    }

    public ContainmentPathElem getLeafElement() {
        if (this.contents.size() > 0) {
            return (ContainmentPathElem)this.contents.elementAt(this.contents.size() - 1);
        }
        return null;
    }

    public ContainmentPathElem getParent() {
        if (this.contents.size() > 1) {
            return (ContainmentPathElem)this.contents.elementAt(this.contents.size() - 2);
        }
        return null;
    }

    public ContainmentPath minusRootElem() {
        int n = this.contents.size();
        if (n == 0) {
            return null;
        }
        Vector vector = new Vector(n - 1);
        int n2 = 0;
        while (n2 < n - 1) {
            vector.addElement(this.contents.elementAt(n2 + 1));
            ++n2;
        }
        return new ContainmentPath(vector);
    }

    public int length() {
        return this.contents.size();
    }

    public String toString() {
        Enumeration enumeration = this.enumerate();
        String string = seperator;
        while (enumeration.hasMoreElements()) {
            string = string + enumeration.nextElement().toString() + seperator;
        }
        return string;
    }

    public static ContainmentPath fromString(String string) throws InvalidContainmentPathException {
        ContainmentPath containmentPath = new ContainmentPath();
        StringTokenizer stringTokenizer = new StringTokenizer(string, seperator);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                ContainmentPathElem containmentPathElem = ContainmentPathElem.fromString(stringTokenizer.nextToken());
                containmentPath.addElement(containmentPathElem);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new InvalidContainmentPathException();
            }
        }
        return containmentPath;
    }
}

