/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.DataSource;
import com.ibm.ejs.sm.beans.DataSourceAttributes;
import com.ibm.ejs.sm.beans.DataSourceConfig;
import com.ibm.ejs.sm.beans.J2EEResourceConfig;
import com.ibm.ejs.sm.beans.J2EEResourcePropertyConfig;
import com.ibm.ejs.sm.beans.JDBCDriver;
import com.ibm.ejs.sm.beans.JDBCDriverAttributes;
import com.ibm.ejs.sm.beans.JDBCDriverBean;
import com.ibm.ejs.sm.beans.JDBCDriverConfig;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.Relation;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.RepositoryObjectName;
import com.ibm.ejs.sm.beans.ResourceBean;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.InvalidDatasourceNameException;
import com.ibm.ejs.sm.exception.InvalidJDBCDriverException;
import com.ibm.ejs.sm.exception.InvalidNameChangeException;
import com.ibm.ejs.sm.exception.InvalidResourceNameException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.RelationOpException;
import com.ibm.ejs.sm.exception.RemoteOpException;
import com.ibm.ejs.sm.exception.RequiredAttributeMissingException;
import com.ibm.ejs.sm.util.ObjectCollection;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import com.ibm.websphere.advanced.cm.factory.DataSourceFactory;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.Referenceable;

public class DataSourceBean
extends ResourceBean
implements EntityBean {
    protected static NLS nls = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$DataSourceBean == null ? (class$com$ibm$ejs$sm$beans$DataSourceBean = DataSourceBean.class$("com.ibm.ejs.sm.beans.DataSourceBean")) : class$com$ibm$ejs$sm$beans$DataSourceBean));
    private static Integer classLock = new Integer(0);
    private static final String tableName = DBMgr.qualifiedTableName((String)"DATASOURCE_TABLE");
    private static final String nameColumnName = "NAME";
    private static final int nameColumnIndex = 3;
    private static final String databaseNameColumnName = "DB_NAME";
    private static final int databaseNameColumnIndex = 4;
    private static final String minPoolSizeColumnName = "MINPOOLSIZE";
    private static final int minPoolSizeColumnIndex = 5;
    private static final String maxPoolSizeColumnName = "MAXPOOLSIZE";
    private static final int maxPoolSizeColumnIndex = 6;
    private static final String connTimeoutColumnName = "CONNTIMEOUT";
    private static final int connTimeoutColumnIndex = 7;
    private static final String idleTimeoutColumnName = "IDLETIMEOUT";
    private static final int idleTimeoutColumnIndex = 8;
    private static final String orphanTimeoutColumnName = "ORPHANTIMEOUT";
    private static final int orphanTimeoutColumnIndex = 9;
    private static final String statementCacheSizeColumnName = "STMTCACHESIZE";
    private static final int statementCacheSizeColumnIndex = 10;
    private static final String defaultUserColumnName = "DEFAULTUSER";
    private static final int defaultUserColumnIndex = 11;
    private static final String defaultPasswordColumnName = "DEFAULTPASSWD";
    private static final int defaultPasswordColumnIndex = 12;
    private static final String disableAutoConnectionCleanupColumnName = "DISABLEAUTOCLEAN";
    private static final int disableAutoConnectionCleanupColumnIndex = 13;
    private static final String jtaEnabledColumnName = "JTAENABLED";
    private static final int jtaEnabledColumnIndex = 14;
    private static final String descriptionColumnName = "DESCRIPTION";
    private static final int descriptionColumnIndex = 15;
    private static final String jndiNameColumnName = "JNDINAME";
    private static final int jndiNameColumnIndex = 16;
    private static final int numColumns = 16;
    protected static final String myInterfaceName = RepositoryObjectImpl.qualifyClassName("DataSource");
    private static final String myClassName = RepositoryObjectImpl.qualifyClassName("DataSourceBean");
    private static boolean tableCreated = false;
    private static Type myTypeObj = null;
    private static Long myTypeId = null;
    private static Class myClass;
    private static final String myHomeName = "DataSourceHome";
    private static final String JNDIPREFIX = "jdbc/";
    private static final String configPropsAttrName;
    private static final int datasourceBeanKeyBase;
    private static final int loadStmtKey;
    private static final int updateStmtKey;
    private static final int deleteStmtKey;
    private static final int insertStmtKey;
    private static final int restrictedFindAllStmtKey;
    private static final int findAllStmtKey;
    private static final int restrictedFindByNameStmtKey;
    private static final int findByNameStmtKey;
    private static final int findByJNDINameStmtKey;
    private static final int restrictedFindByJNDINameStmtKey;
    private static final String updateStmtSql;
    private static final String deleteStmtSql;
    private static final String restrictedFindByNameStmtSql;
    private static final String restrictedFindByJNDINameStmtSql;
    private static final String findByNameStmtSql;
    private static final String findByJNDINameStmtSql;
    private static final String insertStmtSql;
    private String name;
    private String jndiName;
    private String prevJndiName;
    private String databaseName;
    private int minPoolSize;
    private int maxPoolSize;
    private int connTimeout;
    private int idleTimeout;
    private int orphanTimeout;
    private int statementCacheSize;
    private String defaultUser;
    private String defaultPassword;
    private String description;
    private boolean disableAutoConnectionCleanup;
    private boolean jtaEnabled;
    private Properties configProperties;
    private JDBCDriver driver;
    private boolean duringCreate;
    private Referenceable bindingObject;
    private boolean dirty;
    private static Relation driverDataSourceRel;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$DataSourceBean;

    public DataSourceBean() throws RemoteException {
        DataSourceBean.initializeNLS("RepositoryStrings");
        DataSourceBean.initializePersistentStore();
        DataSourceBean.initializeTypeId();
    }

    public void checkForActiveUse() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"checkForActiveUse");
        Tr.exit((TraceComponent)tc, (String)"checkForActiveUse");
    }

    private void checkForUse() throws RemoteException, RemoveException {
    }

    public boolean checkUsabilityOnNode(Node node) throws RemoteException {
        Tr.exit((TraceComponent)tc, (String)"checkUsabilityOnNode:false");
        return false;
    }

    public Long ejbCreate(DataSourceAttributes dataSourceAttributes, JDBCDriver jDBCDriver) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        try {
            jDBCDriver.getFullName();
            this.driver = jDBCDriver;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)" < ejbCreate -- invalid JDBC driver", (Object)exception);
            throw new InvalidJDBCDriverException(nls.getString("dsb.jdbc.exception", "Invalid JDBC driver specified."));
        }
        try {
            this.name = dataSourceAttributes.getName();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)" < ejbCreate -- required attribute missing", (Object)((Object)attributeNotSetException));
            throw new RequiredAttributeMissingException(attributeNotSetException.getMessage());
        }
        try {
            Tr.debug((TraceComponent)tc, (String)("in ejbCreate: " + this));
            this.validateName(this.name);
            if (this.typeId == null) {
                this.typeId = myTypeId;
            }
            this.id = this.create(this.typeId);
            this.addParentRel(this.name, this.driver);
            this.initializeInstanceVariables();
            try {
                this.updateInstanceVariables(dataSourceAttributes, true);
            }
            catch (InvalidNameChangeException invalidNameChangeException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate: -- invalid data source name", (Object)((Object)invalidNameChangeException));
                throw new InvalidDatasourceNameException();
            }
            catch (OpException opException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate: ", (Object)((Object)opException));
                throw new RemoteException(nls.getString("dsb.instance.operation1.exception", "Could not update the instance variables."), opException);
            }
            this.name = this.name;
            Vector<Object> vector = new Vector<Object>(16);
            vector.addElement(Utils.getIdString((Long)this.id));
            vector.addElement(Utils.getIdString((Long)this.typeId));
            vector.addElement(this.name);
            vector.addElement(this.databaseName);
            vector.addElement(new Integer(this.minPoolSize));
            vector.addElement(new Integer(this.maxPoolSize));
            vector.addElement(new Integer(this.connTimeout));
            vector.addElement(new Integer(this.idleTimeout));
            vector.addElement(new Integer(this.orphanTimeout));
            vector.addElement(new Integer(this.statementCacheSize));
            vector.addElement(this.defaultUser);
            vector.addElement(this.defaultPassword);
            vector.addElement(new Integer(Utils.booleanToInt((boolean)this.disableAutoConnectionCleanup)));
            vector.addElement(new Integer(Utils.booleanToInt((boolean)this.jtaEnabled)));
            vector.addElement(this.description);
            vector.addElement(this.getJNDIName());
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("dsb.db.insert0.exception", new Object[]{sQLException.getMessage(), this.id, this.databaseName, this.typeId}, "DataSourceBean insert failed due to {0} for statement with id = {1} DBName = {2} typeId = {3}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbCreate - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)this.id);
        return this.id;
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException, FinderException {
        Enumeration enumeration;
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll");
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll");
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)false, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("dsb.db.select2.exception", new Object[]{sQLException.getMessage(), tableName}, "DataSourceBean findAll failed due to {0} on table {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbFindAll - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)((ObjectCollection)enumeration).getArray());
        return enumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByJNDIName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByJNDIName", (Object)string);
        DBQueryResult dBQueryResult = null;
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByJNDINameStmtKey, (String)findByJNDINameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByJNDINameStmtKey, (String)restrictedFindByJNDINameStmtSql, vector);
                }
                Tr.exit((TraceComponent)tc, (String)"ejbFindByJNDIName");
                l = this.singleFinderEpilogue(dBQueryResult);
                Object var7_8 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("dsb.db.select4.exception", new Object[]{sQLException.getMessage(), string}, "DataSourceBean findByJNDIName failed due to {0} for name {1}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByJNDIName - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    protected Long findByName(String string) throws RemoteException, FinderException {
        return this.ejbFindByName(string, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByName", (Object)string);
        DBQueryResult dBQueryResult = null;
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByNameStmtKey, (String)findByNameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByNameStmtKey, (String)restrictedFindByNameStmtSql, vector);
                }
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName");
                l = this.singleFinderEpilogue(dBQueryResult);
                Object var7_8 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("dsb.db.select4.exception", new Object[]{sQLException.getMessage(), string}, "DataSourceBean findByName failed due to {0} for name {1}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    public void ejbLoad() throws RemoteException {
        block19: {
            Long l = (Long)this.ec.getPrimaryKey();
            Tr.entry((TraceComponent)tc, (String)"ejbLoad", (Object)l);
            DBQueryResult dBQueryResult = null;
            try {
                try {
                    dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                    ResultSet resultSet = dBQueryResult.getResultSet();
                    if (resultSet == null || !resultSet.next()) {
                        RemoteException remoteException = new RemoteException(nls.getFormattedMessage("dsb.db.select0.exception", new Object[]{l, tableName}, "DataSourceBean select failed to find datasource instance {0} in table {1}."), new ObjectNotFoundException());
                        Tr.exit((TraceComponent)tc, (String)"ejbLoad - with no resultSet exception", (Object)remoteException);
                        throw remoteException;
                    }
                    if (this.setId(resultSet, myTypeId)) {
                        super.ejbLoad();
                        this.name = resultSet.getString(3);
                        this.databaseName = resultSet.getString(4);
                        if (this.databaseName == null) {
                            this.databaseName = new String();
                        }
                        this.minPoolSize = resultSet.getInt(5);
                        this.maxPoolSize = resultSet.getInt(6);
                        this.connTimeout = resultSet.getInt(7);
                        this.idleTimeout = resultSet.getInt(8);
                        this.orphanTimeout = resultSet.getInt(9);
                        this.statementCacheSize = resultSet.getInt(10);
                        this.defaultUser = resultSet.getString(11);
                        if (this.defaultUser == null) {
                            this.defaultUser = new String();
                        }
                        this.defaultPassword = resultSet.getString(12);
                        if (this.defaultPassword == null) {
                            this.defaultPassword = new String();
                        }
                        this.disableAutoConnectionCleanup = resultSet.getBoolean(13);
                        this.jtaEnabled = resultSet.getBoolean(14);
                        this.description = resultSet.getString(15);
                        if (this.description == null) {
                            this.description = new String();
                        }
                        this.jndiName = resultSet.getString(16);
                        this.prevJndiName = null;
                        this.getBinaryAttributes();
                        this.duringCreate = false;
                    }
                    this.dirty = false;
                }
                catch (SQLException sQLException) {
                    RemoteException remoteException = new RemoteException(nls.getFormattedMessage("dsb.db.select1.exception", new Object[]{sQLException.getMessage()}, "DataSourceBean select failed due to {0}."), sQLException);
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad - with java.sql.SQLException", (Object)remoteException);
                    throw remoteException;
                }
                Object var6_10 = null;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                DBMgr.doneWithQuery(dBQueryResult);
                throw throwable;
            }
            DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
            try {
                this.driver = (JDBCDriver)this.getContainingObject();
            }
            catch (Exception exception) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("dsb.db.update1.exception", new Object[]{exception.getMessage()}, "DataSourceBean update failed due to {0}."), exception);
                Tr.exit((TraceComponent)tc, (String)"ejbLoad - with Exception", (Object)remoteException);
                throw remoteException;
            }
            if (!this.defaultUser.equals("") || !this.defaultPassword.equals("") || this.databaseName != null && !this.databaseName.trim().equals("")) {
                if (!((Hashtable)this.configProperties).containsKey("user")) {
                    this.configProperties.setProperty("user", this.defaultUser);
                }
                if (!((Hashtable)this.configProperties).containsKey("password")) {
                    this.configProperties.setProperty("password", this.defaultPassword);
                }
                if (this.databaseName != null && !this.databaseName.trim().equals("") && !((Hashtable)this.configProperties).containsKey("databaseName")) {
                    this.configProperties.setProperty("databaseName", this.databaseName);
                }
                try {
                    this.bindingObject = (Referenceable)this.getBindingObject();
                }
                catch (OpException opException) {
                    if (!tc.isEventEnabled()) break block19;
                    Tr.event((TraceComponent)tc, (String)("Unexpected exception getting referenceable: " + (Object)((Object)opException)));
                }
            }
        }
    }

    private void fixupDataSourcePropsAfterPTF2() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fixupDataSourcePropsAfterPTF2");
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("setting user databaseName to: " + this.defaultUser + "; " + this.databaseName));
        }
        if (!((Hashtable)this.configProperties).containsKey("user")) {
            this.configProperties.setProperty("user", this.defaultUser);
        }
        if (!((Hashtable)this.configProperties).containsKey("password")) {
            this.configProperties.setProperty("password", this.defaultPassword);
        }
        if (this.databaseName != null && !this.databaseName.trim().equals("") && !((Hashtable)this.configProperties).containsKey("databaseName")) {
            this.configProperties.setProperty("databaseName", this.databaseName);
        }
        this.defaultUser = "";
        this.defaultPassword = "";
        this.databaseName = "";
        this.dirty = true;
        this.setBinaryAttr(configPropsAttrName, this.configProperties);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fixupDataSourcePropsAfterPTF2");
        }
    }

    public void ejbPostCreate(DataSourceAttributes dataSourceAttributes, JDBCDriver jDBCDriver) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbPostCreate");
        try {
            if (!this.ec.getRollbackOnly()) {
                this.insertIntoNameSpace(this.getJNDIName(), (Referenceable)this.getBindingObject());
            }
        }
        catch (Exception exception) {
            this.ec.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"ejbPostCreate:", (Object)exception);
            throw new RemoteException(nls.getString("dsb.instance.operation1.exception", "An operation exception occurred. "), exception);
        }
        Tr.exit((TraceComponent)tc, (String)"ejbPostCreate");
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        if (this.id == null) {
            this.ejbLoad();
        }
        if (this.narrowRef != null) {
            this.narrowRef.remove();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove");
            return;
        }
        super.ejbRemove();
        Long l = (Long)this.ec.getPrimaryKey();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)l));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
            this.deleteFromNameSpace(this.getJNDIName());
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("dsb.db.delete0.exception", new Object[]{sQLException.getMessage(), l}, "DataSourceBean delete failed due to {0} for primary key {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbRemove - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        catch (RemoteException remoteException) {
            this.ec.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove - with RemoteException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        if (this.narrowRef != null) {
            Tr.exit((TraceComponent)tc, (String)"ejbStore");
            return;
        }
        if (!this.defaultUser.equals("") || !this.defaultPassword.equals("") || this.databaseName != null && !this.databaseName.trim().equals("")) {
            this.fixupDataSourcePropsAfterPTF2();
        }
        this.encodePasswordIfNecessary();
        super.ejbStore();
        if (this.dirty) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("dirty: " + new Boolean(this.dirty)));
            }
            try {
                Vector<Object> vector = new Vector<Object>(16);
                vector.addElement(this.name);
                vector.addElement(this.databaseName);
                vector.addElement(new Integer(this.minPoolSize));
                vector.addElement(new Integer(this.maxPoolSize));
                vector.addElement(new Integer(this.connTimeout));
                vector.addElement(new Integer(this.idleTimeout));
                vector.addElement(new Integer(this.orphanTimeout));
                vector.addElement(new Integer(this.statementCacheSize));
                vector.addElement(this.defaultUser);
                vector.addElement(this.defaultPassword);
                vector.addElement(new Integer(Utils.booleanToInt((boolean)this.disableAutoConnectionCleanup)));
                vector.addElement(new Integer(Utils.booleanToInt((boolean)this.jtaEnabled)));
                vector.addElement(this.description);
                vector.addElement(this.jndiName);
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("dsb.db.update0.exception", new Object[]{sQLException.getMessage(), this.name, this.databaseName, this.id}, "DataSourceBean update failed due to {0} for statement with name = {1} DBName = {2} id = {3}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbStore - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
            if (!this.duringCreate) {
                if (this.prevJndiName != null && !this.prevJndiName.equals("")) {
                    Tr.debug((TraceComponent)tc, (String)("Need to rename in namespace: prevJndiName is " + this.prevJndiName + " jndiName is " + this.getJNDIName()));
                    try {
                        this.renameInNameSpace(this.prevJndiName, this.getJNDIName(), this.bindingObject);
                        this.prevJndiName = null;
                    }
                    catch (Exception exception) {
                        this.ec.setRollbackOnly();
                        RemoteException remoteException = new RemoteException("", exception);
                        Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                        throw remoteException;
                    }
                }
                Tr.debug((TraceComponent)tc, (String)"Need to update binding");
                try {
                    if (this.bindingObject != null) {
                        this.updateInNameSpace(this.getJNDIName(), this.bindingObject);
                    } else {
                        Tr.debug((TraceComponent)tc, (String)"bindingObject is NULL -- do not rebind.");
                    }
                }
                catch (Exception exception) {
                    this.ec.setRollbackOnly();
                    RemoteException remoteException = new RemoteException("", exception);
                    Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                    throw remoteException;
                }
            }
        }
        Tr.exit((TraceComponent)tc, (String)"ejbStore");
    }

    public Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        Attributes attributes2 = null;
        if (this.narrowRef != null) {
            attributes2 = ((DataSource)this.narrowRef).getAttributes(attributes);
        } else {
            this.setVersion(attributes);
            attributes2 = this.readInstanceVariables(attributes);
        }
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return attributes2;
    }

    private void getBinaryAttributes() throws RemoteException {
        this.configProperties = (Properties)this.getBinaryAttr(configPropsAttrName);
        this.decodePasswordIfNecessary();
    }

    private Object getBindingObject() throws RemoteException, OpException {
        Object object;
        Tr.entry((TraceComponent)tc, (String)"getBindingObject");
        JDBCDriverAttributes jDBCDriverAttributes = new JDBCDriverAttributes();
        jDBCDriverAttributes.requestAll();
        jDBCDriverAttributes = (JDBCDriverAttributes)this.driver.getAttributes(jDBCDriverAttributes);
        String string = null;
        try {
            string = jDBCDriverAttributes.getImplClass();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            throw new OpException("getBindingObject: AttributeNotSetException: " + attributeNotSetException.getMessage());
        }
        Properties properties = new Properties();
        properties.setProperty("name", this.name);
        properties.setProperty("dataSourceClassName", string);
        properties.setProperty("description", this.description);
        properties.setProperty("minimumPoolSize", String.valueOf(this.minPoolSize));
        properties.setProperty("maximumPoolSize", String.valueOf(this.maxPoolSize));
        properties.setProperty("connectionTimeout", String.valueOf(this.connTimeout));
        properties.setProperty("idleTimeout", String.valueOf(this.idleTimeout));
        properties.setProperty("orphanTimeout", String.valueOf(this.orphanTimeout));
        properties.setProperty("statementCacheSize", String.valueOf(this.statementCacheSize));
        properties.setProperty("disableAutoConnectionCleanup", String.valueOf(this.disableAutoConnectionCleanup));
        if (!this.defaultUser.equals("") || !this.defaultPassword.equals("") || this.databaseName != null && !this.databaseName.trim().equals("")) {
            this.fixupDataSourcePropsAfterPTF2();
        }
        Enumeration enumeration = ((Hashtable)this.configProperties).keys();
        String string2 = null;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            object = (String)((Hashtable)this.configProperties).get(string2);
            if (object != null && !((String)object).equals("")) {
                if (string2.equals("password")) {
                    object = PasswordUtil.passwordDecode((String)object);
                }
                ((Hashtable)properties).put(string2, object);
                continue;
            }
            Tr.debug((TraceComponent)tc, (String)("not storing property " + string2));
        }
        object = DataSourceFactory.getBindableObject((Properties)properties);
        Tr.exit((TraceComponent)tc, (String)"getBindingObject");
        return object;
    }

    public RepositoryObjectName getFullName() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getFullName");
        RepositoryObjectName repositoryObjectName = this.constructFullName(myHomeName, this.name);
        Tr.exit((TraceComponent)tc, (String)"getFullName");
        return repositoryObjectName;
    }

    public String getJNDIName() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"getJNDIName");
        if (this.jndiName.trim().equals("")) {
            this.jndiName = this.name.startsWith(JNDIPREFIX) ? this.name : JNDIPREFIX + this.name;
        }
        Tr.exit((TraceComponent)tc, (String)"getJNDIName");
        return this.jndiName;
    }

    public J2EEResourceConfig getResourceConfig(Node node) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getResourceConfig");
        J2EEResourceConfig j2EEResourceConfig = this.getResourceConfig();
        JDBCDriverConfig jDBCDriverConfig = (JDBCDriverConfig)j2EEResourceConfig.getProvider();
        jDBCDriverConfig.setClasspath(this.driver.getJarfile(node));
        Tr.exit((TraceComponent)tc, (String)"getResourceConfig");
        return j2EEResourceConfig;
    }

    public J2EEResourceConfig getResourceConfig() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getResourceConfig");
        Long l = (Long)this.driver.getPrimaryKey();
        JDBCDriverAttributes jDBCDriverAttributes = new JDBCDriverAttributes();
        jDBCDriverAttributes.requestAll();
        jDBCDriverAttributes = (JDBCDriverAttributes)this.driver.getAttributes(jDBCDriverAttributes);
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            string = jDBCDriverAttributes.getImplClass();
            string2 = jDBCDriverAttributes.getName();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            throw new OpException("getResourceConfig: AttributeNotSetException: " + attributeNotSetException.getMessage());
        }
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        JDBCDriverConfig jDBCDriverConfig = new JDBCDriverConfig();
        dataSourceConfig.setProvider(jDBCDriverConfig);
        Properties properties = new Properties();
        dataSourceConfig.setJNDIName(this.getJNDIName());
        dataSourceConfig.setName(this.name);
        dataSourceConfig.setDescription(this.description);
        dataSourceConfig.setJtaEnabled(this.jtaEnabled);
        dataSourceConfig.setMinPoolSize(this.minPoolSize);
        dataSourceConfig.setMaxPoolSize(this.maxPoolSize);
        dataSourceConfig.setConnectionTimeout(this.connTimeout);
        dataSourceConfig.setIdleTimeout(this.idleTimeout);
        dataSourceConfig.setOrphanTimeout(this.orphanTimeout);
        dataSourceConfig.setStatementCacheSize(this.statementCacheSize);
        dataSourceConfig.setDisableAutoConnectionCleanup(this.disableAutoConnectionCleanup);
        Enumeration enumeration = ((Hashtable)this.configProperties).keys();
        String string5 = null;
        String string6 = null;
        J2EEResourcePropertyConfig j2EEResourcePropertyConfig = null;
        while (enumeration.hasMoreElements()) {
            string5 = (String)enumeration.nextElement();
            string6 = (String)((Hashtable)this.configProperties).get(string5);
            if (string5.equals(DataSourceFactory.DEFAULT_USER)) {
                dataSourceConfig.setDefaultUser(string6);
            } else if (string5.equals(DataSourceFactory.DEFAULT_PASSWORD)) {
                dataSourceConfig.setDefaultPassword(string6);
            } else if (string5.equals("databaseName")) {
                dataSourceConfig.setDatabaseName(string6);
            }
            j2EEResourcePropertyConfig = new J2EEResourcePropertyConfig();
            j2EEResourcePropertyConfig.setName(string5);
            j2EEResourcePropertyConfig.setValue(string6);
            if (string6 == null || string6.trim().equals("")) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Creating config; NOT storing property " + string5));
                continue;
            }
            ((Hashtable)properties).put(string5, j2EEResourcePropertyConfig);
            if (!tc.isDebugEnabled()) continue;
            if (string6 != null && string6.toLowerCase().indexOf("password") >= 0) {
                string6 = "*****";
            }
            Tr.debug((TraceComponent)tc, (String)("Creating config; storing property " + string5 + " = " + string6));
        }
        dataSourceConfig.setPropertySet(properties);
        jDBCDriverConfig.setDescription(string3);
        jDBCDriverConfig.setName(string2);
        jDBCDriverConfig.setProviderId(l);
        jDBCDriverConfig.setImplementationClassName(string);
        jDBCDriverConfig.setClasspath(string4);
        Tr.exit((TraceComponent)tc, (String)"getResourceConfig");
        return dataSourceConfig;
    }

    public Object[] testConnection() throws RemoteException, OpException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"testConnection");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"testConnection");
        }
        Object[] objectArray = this.driver.testConnection(this.configProperties);
        return objectArray;
    }

    private void initializeInstanceVariables() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeInstanceVariables");
        DataSourceAttributes dataSourceAttributes = (DataSourceAttributes)RepositoryObjectImpl.getDefaults(myTypeObj);
        try {
            this.databaseName = "";
            this.minPoolSize = dataSourceAttributes.getMinPoolSize();
            this.maxPoolSize = dataSourceAttributes.getMaxPoolSize();
            this.connTimeout = dataSourceAttributes.getConnTimeout();
            this.idleTimeout = dataSourceAttributes.getIdleTimeout();
            this.orphanTimeout = dataSourceAttributes.getOrphanTimeout();
            this.statementCacheSize = dataSourceAttributes.getStatementCacheSize();
            this.defaultUser = dataSourceAttributes.getDefaultUser();
            this.defaultPassword = dataSourceAttributes.getDefaultPassword();
            this.disableAutoConnectionCleanup = dataSourceAttributes.getDisableAutoConnectionCleanup();
            this.jtaEnabled = dataSourceAttributes.getJtaEnabled();
            this.description = dataSourceAttributes.getDescription();
            this.jndiName = dataSourceAttributes.getJNDIName();
            this.prevJndiName = null;
            this.configProperties = dataSourceAttributes.getConfigProperties();
            this.setBinaryAttr(configPropsAttrName, this.configProperties);
            this.duringCreate = true;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"intializedInstanceVariables", (Object)exception);
            throw new RemoteException(nls.getString("dsb.instance.operation2.exception", "Could not initialize the instance variables."), exception);
        }
        Tr.exit((TraceComponent)tc, (String)"intializedInstanceVariables");
    }

    protected static void initializeNLS(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeNLS");
        }
        if (nls == null) {
            nls = new NLS(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeNLS");
        }
    }

    private static void initializePersistentStore() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (tableCreated) {
                return;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + nameColumnName + DBMgr.mediumStringColumnSpec + " , " + databaseNameColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + minPoolSizeColumnName + " integer not null " + " , " + maxPoolSizeColumnName + " integer not null " + " , " + connTimeoutColumnName + " integer not null " + " , " + idleTimeoutColumnName + " integer not null " + " , " + orphanTimeoutColumnName + " integer not null " + " , " + statementCacheSizeColumnName + " integer not null " + " , " + defaultUserColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + defaultPasswordColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + disableAutoConnectionCleanupColumnName + " integer not null " + " , " + jtaEnabledColumnName + " integer not null " + " , " + descriptionColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + jndiNameColumnName + DBMgr.mediumStringColumnSpec + " , " + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Integer n2 = classLock;
            synchronized (n2) {
                tableCreated = true;
            }
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("dsb.db.create0.exception", new Object[]{tableName, sQLException.getMessage()}, "DataSourceBean could not create table {0} because of {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"initializePersistentStore - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
    }

    private static void initializeTypeId() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        Integer n = classLock;
        synchronized (n) {
            if (myTypeId != null) {
                return;
            }
        }
        DataSourceAttributes dataSourceAttributes = new DataSourceAttributes();
        dataSourceAttributes.setMinPoolSize(1);
        dataSourceAttributes.setMaxPoolSize(10);
        dataSourceAttributes.setConnTimeout(180);
        dataSourceAttributes.setIdleTimeout(1800);
        dataSourceAttributes.setOrphanTimeout(1800);
        dataSourceAttributes.setStatementCacheSize(100);
        dataSourceAttributes.setDefaultUser("");
        dataSourceAttributes.setDefaultPassword("");
        dataSourceAttributes.setDescription("");
        dataSourceAttributes.setDisableAutoConnectionCleanup(false);
        dataSourceAttributes.setJtaEnabled(false);
        dataSourceAttributes.setConfigProperties(new Properties());
        dataSourceAttributes.setJNDIName("");
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, dataSourceAttributes, false);
        Long l = (Long)type.getPrimaryKey();
        Integer n2 = classLock;
        synchronized (n2) {
            myTypeObj = type;
            myTypeId = l;
        }
        Tr.exit((TraceComponent)tc, (String)"intializeTypeId");
    }

    public void notifyDriverChanges(JDBCDriver jDBCDriver) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"notifyDriverChanges");
        this.updateInNameSpace(this.getJNDIName(), (Referenceable)this.getBindingObject());
        Tr.exit((TraceComponent)tc, (String)"notifyDriverChanges");
    }

    private DataSourceAttributes readInstanceVariables(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"readInstanceVariables");
        DataSourceAttributes dataSourceAttributes = (DataSourceAttributes)attributes;
        dataSourceAttributes.setName(this.name);
        dataSourceAttributes.setFullName(this.getFullName());
        dataSourceAttributes.setDatabaseName(this.databaseName);
        dataSourceAttributes.setMinPoolSize(this.minPoolSize);
        dataSourceAttributes.setMaxPoolSize(this.maxPoolSize);
        dataSourceAttributes.setConnTimeout(this.connTimeout);
        dataSourceAttributes.setIdleTimeout(this.idleTimeout);
        dataSourceAttributes.setOrphanTimeout(this.orphanTimeout);
        dataSourceAttributes.setStatementCacheSize(this.statementCacheSize);
        dataSourceAttributes.setDefaultPassword(this.defaultPassword);
        dataSourceAttributes.setDefaultUser(this.defaultUser);
        dataSourceAttributes.setDisableAutoConnectionCleanup(this.disableAutoConnectionCleanup);
        dataSourceAttributes.setJtaEnabled(this.jtaEnabled);
        dataSourceAttributes.setConfigProperties(this.configProperties);
        dataSourceAttributes.setDescription(this.description);
        dataSourceAttributes.setJNDIName(this.jndiName);
        try {
            JDBCDriver jDBCDriver = (JDBCDriver)this.getContainingObject();
            dataSourceAttributes.setProvider(jDBCDriver);
            JDBCDriverAttributes jDBCDriverAttributes = new JDBCDriverAttributes();
            jDBCDriverAttributes.request(Attributes.name);
            dataSourceAttributes.setParentName(jDBCDriver.getAttributes(jDBCDriverAttributes).getName());
        }
        catch (Exception exception) {
            throw new RemoteOpException(nls.getString("provider.datasource.exception", "Fail to request JDBCDriver name"));
        }
        Tr.exit((TraceComponent)tc, (String)"readInstanceVariables");
        return dataSourceAttributes;
    }

    public void setAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setAttributes");
        if (this.narrowRef != null) {
            ((DataSource)this.narrowRef).setAttributes(attributes);
            return;
        }
        this.checkAndIncrVersion(attributes);
        this.renameIfNec(attributes, DataSourceBean.lookupDriverDataSourceRel(), true);
        this.updateInstanceVariables((DataSourceAttributes)attributes, false);
        Tr.exit((TraceComponent)tc, (String)"setAttributes");
    }

    private void updateInstanceVariables(DataSourceAttributes dataSourceAttributes, boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"updateInstanceVariables");
        this.dirty = true;
        try {
            if (dataSourceAttributes.isSet(Attributes.name)) {
                this.name = dataSourceAttributes.getName();
            }
            if (dataSourceAttributes.isSet(DataSourceAttributes.databaseName)) {
                this.databaseName = dataSourceAttributes.getDatabaseName();
            }
            if (dataSourceAttributes.isSet(DataSourceAttributes.minPoolSize)) {
                this.minPoolSize = dataSourceAttributes.getMinPoolSize();
            }
            if (dataSourceAttributes.isSet(DataSourceAttributes.maxPoolSize)) {
                this.maxPoolSize = dataSourceAttributes.getMaxPoolSize();
            }
            if (dataSourceAttributes.isSet(DataSourceAttributes.connTimeout)) {
                this.connTimeout = dataSourceAttributes.getConnTimeout();
            }
            if (dataSourceAttributes.isSet(DataSourceAttributes.idleTimeout)) {
                this.idleTimeout = dataSourceAttributes.getIdleTimeout();
            }
            if (dataSourceAttributes.isSet(DataSourceAttributes.orphanTimeout)) {
                this.orphanTimeout = dataSourceAttributes.getOrphanTimeout();
            }
            if (dataSourceAttributes.isSet(DataSourceAttributes.statementCacheSize)) {
                this.statementCacheSize = dataSourceAttributes.getStatementCacheSize();
            }
            if (dataSourceAttributes.isSet(DataSourceAttributes.defaultPassword)) {
                this.defaultPassword = dataSourceAttributes.getDefaultPassword();
            }
            if (dataSourceAttributes.isSet(DataSourceAttributes.defaultUser)) {
                this.defaultUser = dataSourceAttributes.getDefaultUser();
            }
            if (dataSourceAttributes.isSet(DataSourceAttributes.disableAutoConnectionCleanup)) {
                this.disableAutoConnectionCleanup = dataSourceAttributes.getDisableAutoConnectionCleanup();
            }
            if (dataSourceAttributes.isSet(DataSourceAttributes.jtaEnabled)) {
                this.jtaEnabled = dataSourceAttributes.getJtaEnabled();
            }
            if (dataSourceAttributes.isSet(DataSourceAttributes.description)) {
                this.description = dataSourceAttributes.getDescription();
            }
            if (dataSourceAttributes.isSet(DataSourceAttributes.jndiName)) {
                String string = dataSourceAttributes.getJNDIName();
                if (!(string = string.trim()).equals("") && !string.equals(this.jndiName)) {
                    this.checkForDuplicateJNDIName(string);
                    if (!bl) {
                        this.prevJndiName = this.jndiName;
                        this.updateModuleBindings(this.prevJndiName, string);
                    }
                    this.jndiName = string;
                }
            }
            if (dataSourceAttributes.isSet(DataSourceAttributes.configProperties)) {
                this.configProperties = dataSourceAttributes.getConfigProperties();
                this.encodePasswordIfNecessary();
                this.setBinaryAttr(configPropsAttrName, this.configProperties);
            }
            this.bindingObject = (Referenceable)this.getBindingObject();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            RemoteOpException remoteOpException = new RemoteOpException(nls.getFormattedMessage("dsb.attribute1.exception", new Object[]{this.name}, "Attribute {0} is not set."), (Throwable)attributeNotSetException);
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables - with AttributeNotSetException", (Object)((Object)attributeNotSetException));
            throw remoteOpException;
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            RemoteOpException remoteOpException = new RemoteOpException(nls.getFormattedMessage("dsb.attribute0.exception", new Object[]{this.name}, "Attribute {0} does not exist."), (Throwable)attributeDoesNotExistException);
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables - with AttributeDoesNotExistException");
            throw remoteOpException;
        }
        Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables");
    }

    private void addParentRel(String string, JDBCDriver jDBCDriver) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"addParentRel");
        DataSourceBean.lookupDriverDataSourceRel();
        try {
            driverDataSourceRel.addUsingKeys((Long)jDBCDriver.getPrimaryKey(), this.id, string);
        }
        catch (RelationOpException relationOpException) {
            this.ec.setRollbackOnly();
            InvalidResourceNameException invalidResourceNameException = new InvalidResourceNameException();
            Tr.exit((TraceComponent)tc, (String)"addParentRel", (Object)invalidResourceNameException);
            throw invalidResourceNameException;
        }
        catch (RemoteException remoteException) {
            Tr.exit((TraceComponent)tc, (String)"addParentRel", (Object)remoteException);
            throw remoteException;
        }
    }

    protected static Relation lookupDriverDataSourceRel() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (driverDataSourceRel != null) {
                Relation relation = driverDataSourceRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.lookupRel(JDBCDriverBean.myInterfaceName, myTypeObj, "jdbcDriverDataSourceRel");
        Integer n2 = classLock;
        synchronized (n2) {
            driverDataSourceRel = relation;
        }
        return driverDataSourceRel;
    }

    private void encodePasswordIfNecessary() {
        String string = this.configProperties.getProperty("password");
        if (string != null && !string.equals("")) {
            this.configProperties.setProperty("password", PasswordUtil.passwordEncode((String)string));
        }
    }

    private void decodePasswordIfNecessary() {
        String string = this.configProperties.getProperty("password");
        if (string != null && !string.equals("")) {
            this.configProperties.setProperty("password", PasswordUtil.passwordDecode((String)string));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        configPropsAttrName = myInterfaceName + ".configProps";
        datasourceBeanKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
        loadStmtKey = datasourceBeanKeyBase + 1;
        updateStmtKey = datasourceBeanKeyBase + 2;
        deleteStmtKey = datasourceBeanKeyBase + 3;
        insertStmtKey = datasourceBeanKeyBase + 4;
        restrictedFindAllStmtKey = datasourceBeanKeyBase + 5;
        findAllStmtKey = datasourceBeanKeyBase + 6;
        restrictedFindByNameStmtKey = datasourceBeanKeyBase + 7;
        findByNameStmtKey = datasourceBeanKeyBase + 8;
        findByJNDINameStmtKey = datasourceBeanKeyBase + 9;
        restrictedFindByJNDINameStmtKey = datasourceBeanKeyBase + 10;
        updateStmtSql = "update " + tableName + " set " + nameColumnName + " = ? , " + databaseNameColumnName + " = ? ," + minPoolSizeColumnName + " = ? ," + maxPoolSizeColumnName + " = ? ," + connTimeoutColumnName + " = ? ," + idleTimeoutColumnName + " = ? ," + orphanTimeoutColumnName + " = ? ," + statementCacheSizeColumnName + " = ? ," + defaultUserColumnName + " = ? ," + defaultPasswordColumnName + " = ? ," + disableAutoConnectionCleanupColumnName + " = ? ," + jtaEnabledColumnName + " = ? ," + descriptionColumnName + " = ? ," + jndiNameColumnName + " = ? " + " where " + "INSTANCE_ID" + " = ?";
        deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " = ?";
        restrictedFindByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " = ? and " + "TYPE_ID" + " = ? ";
        restrictedFindByJNDINameStmtSql = "select * from " + tableName + " where " + jndiNameColumnName + " = ? and " + "TYPE_ID" + " = ? ";
        findByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " =  ?";
        findByJNDINameStmtSql = "select * from " + tableName + " where " + jndiNameColumnName + " =  ?";
        insertStmtSql = "insert into " + tableName + " values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    }
}

