/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.models.base.config.applicationserver.ApplicationServer;
import com.ibm.ejs.models.base.config.applicationserver.Domain;
import com.ibm.ejs.models.base.config.server.CustomService;
import com.ibm.ejs.models.base.config.server.SystemProperty;
import com.ibm.ejs.oa.EJSORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.active.ActiveEJBServerConfig;
import com.ibm.ejs.sm.active.ActiveModuleConfig;
import com.ibm.ejs.sm.active.ActiveObjectConfig;
import com.ibm.ejs.sm.active.ActiveSecurityConfigConfig;
import com.ibm.ejs.sm.active.ActiveServerConfig;
import com.ibm.ejs.sm.agent.AdminAgent;
import com.ibm.ejs.sm.agent.ContainmentPathElem;
import com.ibm.ejs.sm.agent.ParamList;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.BinaryAttrSerialization;
import com.ibm.ejs.sm.beans.CloneOnlyAwareConfig;
import com.ibm.ejs.sm.beans.ContainerCacheConfig;
import com.ibm.ejs.sm.beans.CustomServiceConfig;
import com.ibm.ejs.sm.beans.DataSource;
import com.ibm.ejs.sm.beans.DataSourceConfig;
import com.ibm.ejs.sm.beans.DataSourceHome;
import com.ibm.ejs.sm.beans.EJBServer;
import com.ibm.ejs.sm.beans.EJBServerAttributes;
import com.ibm.ejs.sm.beans.FileBrowserService;
import com.ibm.ejs.sm.beans.FileBrowserServiceHome;
import com.ibm.ejs.sm.beans.J2CResourceAdapterBean;
import com.ibm.ejs.sm.beans.J2EEResourceConfig;
import com.ibm.ejs.sm.beans.J2EEResourceProviderConfig;
import com.ibm.ejs.sm.beans.JVMConfig;
import com.ibm.ejs.sm.beans.LiveRepositoryObject;
import com.ibm.ejs.sm.beans.Module;
import com.ibm.ejs.sm.beans.ModuleAttributes;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.NodeAttributes;
import com.ibm.ejs.sm.beans.ORBConfig;
import com.ibm.ejs.sm.beans.Relation;
import com.ibm.ejs.sm.beans.RelationHome;
import com.ibm.ejs.sm.beans.RepositoryObject;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.RepositoryObjectName;
import com.ibm.ejs.sm.beans.SecurityConfig;
import com.ibm.ejs.sm.beans.SecurityConfigHome;
import com.ibm.ejs.sm.beans.Server;
import com.ibm.ejs.sm.beans.ServerBean;
import com.ibm.ejs.sm.beans.ServerGroup;
import com.ibm.ejs.sm.beans.ServerGroupAttributes;
import com.ibm.ejs.sm.beans.SessionManagerConfig;
import com.ibm.ejs.sm.beans.TransportConfig;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.beans.WebContainerConfig;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.InvalidOltServerConfigException;
import com.ibm.ejs.sm.exception.InvalidServerNameException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.ReconnectFailureException;
import com.ibm.ejs.sm.exception.RelationInstanceNotFoundException;
import com.ibm.ejs.sm.exception.RelationOpException;
import com.ibm.ejs.sm.exception.RemoteOpException;
import com.ibm.ejs.sm.exception.RequiredAttributeMissingException;
import com.ibm.ejs.sm.exception.ResourceProviderNotInstalledException;
import com.ibm.ejs.sm.exception.RunningObjectRemoveException;
import com.ibm.ejs.sm.server.AdminServer;
import com.ibm.ejs.sm.server.ManagedServer;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.act.Act;
import com.ibm.ejs.sm.util.act.ActServerImpl;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import com.ibm.ejs.sm.util.task.AsyncTask;
import com.ibm.etools.emf.notify.AdapterFactory;
import com.ibm.etools.emf.ref.EList;
import com.ibm.etools.emf.ref.Extent;
import com.ibm.etools.emf.resource.Context;
import com.ibm.etools.emf.resource.Resource;
import com.ibm.etools.emf.resource.ResourceSet;
import com.ibm.etools.emf.resource.impl.ResourceSetImpl;
import com.ibm.etools.java.impl.JavaRefFactoryImpl;
import com.ibm.ws.adapters.WebSphereAdapterFactory;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;

public class EJBServerBean
extends ServerBean
implements EntityBean {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$EJBServerBean == null ? (class$com$ibm$ejs$sm$beans$EJBServerBean = EJBServerBean.class$("com.ibm.ejs.sm.beans.EJBServerBean")) : class$com$ibm$ejs$sm$beans$EJBServerBean));
    private static final String PLUGIN_REGEN = "Web Server Plugin Regen Warning: The administrative action just performed may invalidate the Web Server plugin configuration file. Use the Plugin regen operation of the Node to update this file.";
    protected static NLS nls = null;
    private static Integer classLock = new Integer(0);
    private static final String tableName = DBMgr.qualifiedTableName((String)"EJB_SERVER_TABLE");
    private static final String logFileSpecColumnName = "LOG_SPEC";
    private static final int logFileSpecColumnIndex = 3;
    private static final String selectionPolicyColumnName = "SEL_POLICY";
    private static final int selectionPolicyColumnIndex = 4;
    private static final String tranTimeoutColumnName = "TRAN_TIMEOUT";
    private static final int tranTimeoutColumnIndex = 5;
    private static final String tranInactivityTimeoutColumnName = "TRAN_INACT";
    private static final int tranInactivityTimeoutColumnIndex = 6;
    private static final String threadPoolSizeColumnName = "TPOOL_SIZE";
    private static final int threadPoolSizeColumnIndex = 7;
    private static final String debugEnabledColumnName = "DEBUG_ENABLED";
    private static final int debugEnabledColumnIndex = 8;
    private static final String oltEnabledColumnName = "OLT_ENABLED";
    private static final int oltEnabledColumnIndex = 9;
    private static final String securityEnabledColumnName = "SEC_ENABLED";
    private static final int securityEnabledColumnIndex = 10;
    private static final String isACloneColumnName = "IS_A_CLONE";
    private static final int isACloneColumnIndex = 11;
    private static final int numColumns = 11;
    protected static final String myInterfaceName = RepositoryObjectImpl.qualifyClassName("EJBServer");
    private static final String myClassName = RepositoryObjectImpl.qualifyClassName("EJBServerBean");
    protected static final String myHomeName = "EJBServerHome";
    private static boolean tableCreated = false;
    private static Type myTypeObj = null;
    private static Long myTypeId = null;
    private static final String traceSpecAttrName = myInterfaceName + ".traceSpec";
    private static final String traceOutputAttrName = myInterfaceName + ".traceOutput";
    private static final String pmiSpecAttrName = myInterfaceName + ".pmiSpec";
    private static final String agentIORAttrName = myInterfaceName + ".agentIOR";
    private static final String wlmTemplateIORAttrName = myInterfaceName + ".wlmTemplateIOR";
    private static final String sysPropsAttrName = myInterfaceName + ".sysProps";
    private static final String listenerPortAttrName = myInterfaceName + ".listenerPort";
    private static final String oltServerHostAttrName = myInterfaceName + ".oltServerHost";
    private static final String oltServerPortAttrName = myInterfaceName + ".oltServerPort";
    private static final String sourcePathAttrName = myInterfaceName + ".sourcePath";
    private static final String cacheConfigAttrName = myInterfaceName + ".cacheConfig";
    private static final String webContainerConfigAttrName = myInterfaceName + ".webContainerConfig";
    private static final String moduleVisibilityAttrName = myInterfaceName + ".moduleVisibility";
    private static final String useDomainQualifiedUserNamesAttrName = myInterfaceName + ".useDomainQualifiedUserNames";
    private static final String defaultDataSourceAttrName = myInterfaceName + ".defaultDataSource";
    private static final String serverGroupAttrName = myInterfaceName + ".serverGroup";
    private static final String orbConfigAttrName = myInterfaceName + ".orbConfig";
    private static final String jvmConfigAttrName = myInterfaceName + ".jvmConfig";
    private static final String customServiceConfigAttrName = myInterfaceName + ".customServiceConfig";
    private static final String nodeStartStateAttrName = myInterfaceName + ".nodeStartState";
    private static final String defaultTraceSpec = new String();
    private static final String defaultLogFileSpec = new String();
    private static final String defaultTraceOutput = new String();
    private static final String defaultSelectionPolicy = "roundrobinpreferlocal";
    private static final int defaultTranTimeout = 120;
    private static final int defaultTranInactivityTimeout = 60000;
    private static final int defaultThreadPoolSize = 20;
    private static final ContainerCacheConfig defaultCacheConfig = new ContainerCacheConfig();
    private static WebContainerConfig defaultWebContainerConfig = null;
    private static final int defaultModuleVisibility = 3;
    private static Relation ejbServerModuleRel;
    protected static final String ejbServerModuleRelName = "ejbServerModuleRel";
    private static Relation ejbServerResourceRel;
    protected static final String ejbServerResourceRelName = "ejbServerResourceRel";
    private static final int ejbServerBeanKeyBase;
    private static final int loadStmtKey;
    private static final int deleteStmtKey;
    private static final int updateStmtKey;
    private static final int findAllStmtKey;
    private static final int restrictedFindAllStmtKey;
    private static final int insertStmtKey;
    private static final int findAllStandAloneServersKey;
    private static final String findAllStandAloneServersStmtSql;
    private static final String deleteStmtSql;
    private static final String insertStmtSql;
    private static final String updateStmtSql;
    private static final String activeObjectClassName = "ActiveEJBServerProcess";
    private static final String jvmName = "java";
    private static final String debugJvmName = "java";
    private static final String defaultOS400MinJVMHeapSize = "-Xms32m";
    private static final String defaultNetWareMaxJVMHeapSize = "-Xms64m";
    private static final String defaultNetWareJVMVMSize = "";
    private static final String defaultOLTServerHost = "localhost";
    private static final int defaultOLTServerPort = 2102;
    private String traceSpec;
    private String traceOutput;
    private String pmiSpec;
    private String logFileSpec;
    private String selectionPolicy;
    private int tranTimeout;
    private int tranInactivityTimeout;
    private int threadPoolSize;
    private String agentIOR;
    private String wlmTemplateIOR;
    private Properties sysProps;
    private boolean debugEnabled;
    private String sourcePath;
    private boolean oltEnabled;
    private String oltServerHost;
    private int oltServerPort;
    private boolean securityEnabled;
    private boolean isAClone;
    private int listenerPort;
    private boolean dirty;
    private ServerGroup serverGroup = null;
    private String nodeStartState;
    private WebContainerConfig webContainerConfig;
    private ORBConfig orbConfig;
    private JVMConfig jvmConfig;
    private Vector customServiceConfig;
    private boolean initialCustomServicesSet = false;
    private int moduleVisibility;
    private boolean useDomainQualifiedUserNames;
    private String defaultDataSource;
    private ContainerCacheConfig cacheConfig;
    private static final String securityEnabledPropertyName = "com.ibm.ejs.securityEnabled";
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$Module;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$ServerGroup;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$RelationHome;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$EJBServerBean;

    public synchronized Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        if (this.narrowRef != null) {
            return ((Server)this.narrowRef).getAttributes(attributes);
        }
        this.setVersion(attributes);
        super.getAttributes(attributes);
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return this.readInstanceVariables(attributes);
    }

    public synchronized void setAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setAttributes");
        if (this.narrowRef != null) {
            ((Server)this.narrowRef).setAttributes(attributes);
            return;
        }
        this.checkAndIncrVersion(attributes);
        if (this.serverGroup != null) {
            attributes = this.setAttributesForClone(attributes);
        }
        this.updateInstanceVariables((EJBServerAttributes)attributes);
        ((EJBServerAttributes)attributes).setJvm(this.debugEnabled ? "java" : "java");
        attributes.updateVersion(attributes.readVersion() + 1);
        super.setAttributes(attributes);
        Tr.exit((TraceComponent)tc, (String)"setAttributes");
    }

    protected void startPrologue() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"startPrologue");
        if (this.getDesiredState() == 3) {
            return;
        }
        if (this.duplicateHttpTransportPortExists()) {
            String string = nls.getFormattedMessage("ejbs.start1.exception", new Object[]{this.getFullName().getLeafElement().getName()}, "HTTP transport ports are already in use, thus not available for the server \"{0}\"");
            throw new OpException(string);
        }
        Tr.exit((TraceComponent)tc, (String)"startPrologue");
    }

    private boolean duplicateHttpTransportPortExists() throws RemoteException, OpException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"duplicatePortExists");
        }
        Node node = this.getNode();
        if (this.webContainerConfig != null) {
            Vector vector;
            Vector vector2 = this.webContainerConfig.getTransports();
            Vector<String> vector3 = new Vector<String>();
            int n = 0;
            while (n < vector2.size()) {
                int n2 = ((TransportConfig)vector2.elementAt(n)).getPort();
                vector3.addElement(Integer.toString(n2));
                ++n;
            }
            if (vector3.size() > 0 && (vector = node.duplicatePortCheck(vector3, true)).size() > 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"duplicatePortExists");
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"duplicatePortExists");
        }
        return false;
    }

    public RepositoryObjectName getFullName() throws RemoteException, OpException {
        return this.constructFullName(myHomeName, super.getRelativeName());
    }

    public synchronized EJBObject getContainingObject() throws RemoteException, ObjectNotFoundException {
        Node node;
        Relation relation = ServerBean.lookupNodeServerRel();
        try {
            node = (Node)relation.traverse(this.ec.getEJBObject(), true);
        }
        catch (RelationOpException relationOpException) {
            throw new RemoteException(defaultNetWareJVMVMSize, relationOpException);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new RemoteException(defaultNetWareJVMVMSize, objectNotFoundException);
        }
        return node;
    }

    public Enumeration listContainedObjects() throws RemoteException {
        Enumeration enumeration;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"listContainedObjects");
        }
        if (this.serverGroup == null) {
            try {
                enumeration = this.listRelatedObjects(EJBServerBean.lookupServerModuleRel());
            }
            catch (Exception exception) {
                Tr.exit((TraceComponent)tc, (String)"listContainedObjects", (Object)exception);
                throw new RemoteException(defaultNetWareJVMVMSize, exception);
            }
        }
        try {
            RelationHome relationHome = (RelationHome)RepositoryObjectImpl.getHome("RelationHome");
            Relation relation = null;
            try {
                relation = relationHome.findByName("ServerGroupModuleRel", true);
            }
            catch (Exception exception) {
                Tr.event((TraceComponent)tc, (String)"Relation not yet created");
            }
            ServerGroup serverGroup = this.getServerGroup();
            enumeration = relation.list(serverGroup, false);
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"listContainedObjects", (Object)exception);
            throw new RemoteException(defaultNetWareJVMVMSize, exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"listContainedObjects");
        }
        return enumeration;
    }

    protected void startContainedObjects(ActiveObjectConfig activeObjectConfig) throws RemoteException, OpException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startContainedObjects");
        }
        Enumeration enumeration = this.listContainedObjects();
        ArrayList<LiveRepositoryObject> arrayList = new ArrayList<LiveRepositoryObject>();
        LiveRepositoryObject liveRepositoryObject = null;
        ModuleAttributes moduleAttributes = new ModuleAttributes();
        while (enumeration.hasMoreElements()) {
            liveRepositoryObject = (LiveRepositoryObject)enumeration.nextElement();
            try {
                moduleAttributes = (ModuleAttributes)liveRepositoryObject.getAttributes(moduleAttributes);
                if (moduleAttributes.getModuleType().equals(ModuleAttributes.EJB_MODULE)) {
                    if (this.serverGroup == null) {
                        Tr.debug((TraceComponent)tc, (String)("starting EJB Module: " + liveRepositoryObject.getFullName()));
                        activeObjectConfig.addContainedConfig(liveRepositoryObject.startingContainerObject());
                        continue;
                    }
                    Module module = (Module)PortableRemoteObject.narrow((Object)liveRepositoryObject, (Class)(class$com$ibm$ejs$sm$beans$Module == null ? EJBServerBean.class$("com.ibm.ejs.sm.beans.Module") : class$com$ibm$ejs$sm$beans$Module));
                    Tr.debug((TraceComponent)tc, (String)("starting EJB Module: " + module.getFullName()));
                    activeObjectConfig.addContainedConfig(module.startingContainerObject((EJBServer)this.ec.getEJBObject()));
                    continue;
                }
                arrayList.add(liveRepositoryObject);
            }
            catch (AttributeNotSetException attributeNotSetException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n = 0;
        while (n < arrayList.size()) {
            liveRepositoryObject = (LiveRepositoryObject)arrayList.get(n);
            if (this.serverGroup == null) {
                Tr.debug((TraceComponent)tc, (String)("starting Web Module: " + liveRepositoryObject.getFullName()));
                activeObjectConfig.addContainedConfig(liveRepositoryObject.startingContainerObject());
            } else {
                Module module = (Module)PortableRemoteObject.narrow((Object)liveRepositoryObject, (Class)(class$com$ibm$ejs$sm$beans$Module == null ? EJBServerBean.class$("com.ibm.ejs.sm.beans.Module") : class$com$ibm$ejs$sm$beans$Module));
                Tr.debug((TraceComponent)tc, (String)("starting Web Module: " + module.getFullName()));
                activeObjectConfig.addContainedConfig(module.startingContainerObject((EJBServer)this.ec.getEJBObject()));
            }
            ++n;
        }
        this.validateResources((ActiveEJBServerConfig)activeObjectConfig);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startContainedObjects");
        }
    }

    protected void stopContainedObjects() throws RemoteException, OpException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stopContainedObjects");
        }
        Enumeration enumeration = this.listContainedObjects();
        while (enumeration.hasMoreElements()) {
            LiveRepositoryObject liveRepositoryObject = (LiveRepositoryObject)enumeration.nextElement();
            if (this.serverGroup == null) {
                liveRepositoryObject.stoppingContainerObject();
                continue;
            }
            try {
                Module module = (Module)PortableRemoteObject.narrow((Object)liveRepositoryObject, (Class)(class$com$ibm$ejs$sm$beans$Module == null ? EJBServerBean.class$("com.ibm.ejs.sm.beans.Module") : class$com$ibm$ejs$sm$beans$Module));
                module.stoppingContainerObject((EJBServer)this.ec.getEJBObject());
            }
            catch (Exception exception) {
                throw new RemoteOpException("Problem in stoppingContainerObject");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopContainedObjects");
        }
    }

    public ContainmentPathElem getActiveObjectName() throws RemoteException, OpException {
        ContainmentPathElem containmentPathElem = new ContainmentPathElem(this.id, activeObjectClassName, super.getRelativeName(), this.getEpoch());
        return containmentPathElem;
    }

    public ActiveObjectConfig getConfig() throws RemoteException, OpException {
        ActiveEJBServerConfig activeEJBServerConfig;
        block19: {
            Tr.entry((TraceComponent)tc, (String)"getConfig");
            activeEJBServerConfig = new ActiveEJBServerConfig();
            super.initializeConfig((ActiveServerConfig)activeEJBServerConfig);
            activeEJBServerConfig.setTraceSpec(this.traceSpec);
            activeEJBServerConfig.setTraceOutput(this.traceOutput);
            activeEJBServerConfig.setPmiSpec(this.pmiSpec);
            activeEJBServerConfig.setLogFileSpec(this.logFileSpec);
            activeEJBServerConfig.setTranTimeout(this.tranTimeout);
            activeEJBServerConfig.setTranInactivityTimeout(this.tranInactivityTimeout);
            activeEJBServerConfig.setThreadPoolSize(this.threadPoolSize);
            activeEJBServerConfig.setAgentIOR(this.agentIOR);
            activeEJBServerConfig.setWLMTemplateIOR(this.wlmTemplateIOR);
            activeEJBServerConfig.setSystemProperties(this.sysProps);
            activeEJBServerConfig.setDebugEnabled(this.debugEnabled);
            activeEJBServerConfig.setSourcePath(this.sourcePath);
            activeEJBServerConfig.setOLTEnabled(this.oltEnabled);
            activeEJBServerConfig.setOLTServerHost(this.oltServerHost);
            activeEJBServerConfig.setOLTServerPort(this.oltServerPort);
            activeEJBServerConfig.setSecurityEnabled(this.securityEnabled);
            activeEJBServerConfig.setCacheSize(this.cacheConfig.getCacheSize());
            activeEJBServerConfig.setCacheSweepInterval(this.cacheConfig.getCacheSweepInterval());
            if (!this.cacheConfig.getPassivationDirectory().equals(defaultNetWareJVMVMSize)) {
                activeEJBServerConfig.setPassivationDir(this.cacheConfig.getPassivationDirectory());
            }
            DataSourceHome dataSourceHome = (DataSourceHome)RepositoryObjectImpl.getHome("DataSourceHome");
            DataSource dataSource = null;
            Node node = this.getNode();
            activeEJBServerConfig.setWebContainerConfig(this.webContainerConfig);
            Object var5_5 = null;
            SessionManagerConfig sessionManagerConfig = this.webContainerConfig.getSessionManagerConfig();
            String string = sessionManagerConfig.getPersistentDatasourceName();
            if (string != null && !string.equals(defaultNetWareJVMVMSize)) {
                try {
                    dataSource = dataSourceHome.findByName(string, false);
                }
                catch (FinderException finderException) {
                    RemoteException remoteException = new RemoteException(nls.getFormattedMessage("ejbs.no.sessionmanager.ds.found.exception", new Object[]{string}, "The DataSource specified for Web Container Persistent Sessions was not found : (datasource={0})."), finderException);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getConfig", (Object)remoteException);
                    }
                    throw remoteException;
                }
                activeEJBServerConfig.setSessionMgrDataSourceConfig((DataSourceConfig)dataSource.getResourceConfig(node));
            }
            activeEJBServerConfig.setORBConfig(this.orbConfig);
            activeEJBServerConfig.setJVMConfig(this.jvmConfig);
            activeEJBServerConfig.setCustomServiceConfig(this.customServiceConfig);
            activeEJBServerConfig.setModuleVisibility(this.moduleVisibility);
            activeEJBServerConfig.setUseDomainQualifiedUserNames(this.useDomainQualifiedUserNames);
            if (this.defaultDataSource != null && !this.defaultDataSource.equals(defaultNetWareJVMVMSize)) {
                try {
                    dataSource = dataSourceHome.findByName(this.defaultDataSource, false);
                    activeEJBServerConfig.setDefaultDataSourceConfig((DataSourceConfig)dataSource.getResourceConfig(node));
                }
                catch (FinderException finderException) {
                    Tr.warning((TraceComponent)tc, (String)"ERROR: exception in finding DataSource bean object");
                    throw new RemoteOpException("Exception in finding DataSource bean object");
                }
            }
            Properties properties = System.getProperties();
            String string2 = properties.getProperty("path.separator");
            String string3 = null;
            Enumeration enumeration = node.listInstalledResDriverFiles(J2CResourceAdapterBean.myInterfaceName);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    string3 = string3 == null ? (String)enumeration.nextElement() : string3 + string2 + (String)enumeration.nextElement();
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting J2CResourceAdapterPath = " + string3));
            }
            activeEJBServerConfig.setJ2CResourceAdapterPath(string3);
            SecurityConfig securityConfig = null;
            try {
                SecurityConfigHome securityConfigHome = (SecurityConfigHome)RepositoryObjectImpl.getHome("SecurityConfigHome");
                securityConfig = securityConfigHome.find();
            }
            catch (FinderException finderException) {
                Tr.warning((TraceComponent)tc, (String)"ERROR: exception in finding SecurityConfig bean object");
                throw new RemoteOpException("Exception in finding SecurityConfig bean object");
            }
            ActiveSecurityConfigConfig activeSecurityConfigConfig = (ActiveSecurityConfigConfig)securityConfig.getConfig();
            activeEJBServerConfig.setGlobalSecurityConfig(activeSecurityConfigConfig);
            if (this.serverGroup != null) {
                ServerGroupAttributes serverGroupAttributes = new ServerGroupAttributes();
                try {
                    serverGroupAttributes.request(Attributes.name);
                    ServerGroup serverGroup = this.getServerGroup();
                    serverGroupAttributes = (ServerGroupAttributes)serverGroup.getAttributes(serverGroupAttributes);
                }
                catch (AttributeDoesNotExistException attributeDoesNotExistException) {
                }
                catch (OpException opException) {
                    this.ec.setRollbackOnly();
                    throw opException;
                }
                try {
                    activeEJBServerConfig.setModelName(serverGroupAttributes.getName());
                }
                catch (Exception exception) {
                    if (!tc.isEventEnabled()) break block19;
                    Tr.event((TraceComponent)tc, (String)"Problem with settting server group name");
                }
            }
        }
        Tr.exit((TraceComponent)tc, (String)"getConfig");
        return activeEJBServerConfig;
    }

    public void startCompleted(ActiveServerConfig activeServerConfig) throws RemoteException, OpException {
        ServerGroup serverGroup;
        super.startCompleted(activeServerConfig);
        ActiveEJBServerConfig activeEJBServerConfig = (ActiveEJBServerConfig)activeServerConfig;
        this.agentIOR = activeEJBServerConfig.getAgentIOR();
        this.setBinaryAttr(agentIORAttrName, this.agentIOR);
        this.wlmTemplateIOR = activeEJBServerConfig.getWLMTemplateIOR();
        this.setBinaryAttr(wlmTemplateIORAttrName, this.wlmTemplateIOR);
        this.listenerPort = activeEJBServerConfig.getListenerPort();
        this.setBinaryAttr(listenerPortAttrName, new Integer(this.listenerPort));
        ++this.serverInstance;
        if (this.serverGroup != null && (serverGroup = this.getServerGroup()) != null) {
            serverGroup.incrementConfigNo((EJBServer)this.ec.getEJBObject(), this.serverInstance);
        }
        this.dirty = true;
    }

    protected ServerGroup getServerGroup() throws RemoteException, OpException {
        ServerGroup serverGroup = null;
        if (this.serverGroup != null) {
            Relation relation = null;
            try {
                RelationHome relationHome = (RelationHome)RepositoryObjectImpl.getHome("RelationHome");
                relation = relationHome.findByName("ServerGroupServerRel", true);
                Enumeration enumeration = relation.list(this.ec.getEJBObject(), true);
                if (enumeration.hasMoreElements()) {
                    serverGroup = (ServerGroup)PortableRemoteObject.narrow(enumeration.nextElement(), (Class)(class$com$ibm$ejs$sm$beans$ServerGroup == null ? (class$com$ibm$ejs$sm$beans$ServerGroup = EJBServerBean.class$("com.ibm.ejs.sm.beans.ServerGroup")) : class$com$ibm$ejs$sm$beans$ServerGroup));
                }
            }
            catch (Exception exception) {
                throw new RemoteException("Problem in getting ServerGroup");
            }
        }
        return serverGroup;
    }

    public synchronized void stopSelf() throws RemoteException, OpException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stopSelf");
        }
        super.stopSelf();
        ++this.serverInstance;
        Tr.event((TraceComponent)tc, (String)"serverInstance: ", (Object)new Long(this.serverInstance));
        if (this.serverGroup != null) {
            Relation relation = null;
            ServerGroup serverGroup = null;
            try {
                RelationHome relationHome = (RelationHome)RepositoryObjectImpl.getHome("RelationHome");
                relation = relationHome.findByName("ServerGroupServerRel", true);
                Enumeration enumeration = relation.list(this.ec.getEJBObject(), true);
                if (enumeration.hasMoreElements()) {
                    serverGroup = (ServerGroup)PortableRemoteObject.narrow(enumeration.nextElement(), (Class)(class$com$ibm$ejs$sm$beans$ServerGroup == null ? (class$com$ibm$ejs$sm$beans$ServerGroup = EJBServerBean.class$("com.ibm.ejs.sm.beans.ServerGroup")) : class$com$ibm$ejs$sm$beans$ServerGroup));
                }
            }
            catch (Exception exception) {
                throw new RemoteOpException("Problem in getting ServerGroup");
            }
            try {
                if (serverGroup != null) {
                    serverGroup.incrementConfigNo((EJBServer)this.ec.getEJBObject(), this.serverInstance);
                }
            }
            catch (OpException opException) {
                Tr.exit((TraceComponent)tc, (String)"stopSelf - caused operation exception");
                throw new RemoteOpException(nls.getFormattedMessage("serv.db.stop.exception", new Object[]{opException.getMessage()}, "ServerBean stop operation exception {0}."), (Throwable)opException);
            }
            this.dirty = true;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stopSelf");
            }
        }
    }

    public Act reconnect(boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"reconnect");
        if (this.agentIOR.equals(defaultNetWareJVMVMSize)) {
            Tr.warning((TraceComponent)tc, (String)"Failed to reconnect to an EJB server: {0}. No IOR available", (Object)new Object[]{this.getRelativeName()});
            Tr.exit((TraceComponent)tc, (String)"reconnect failure -- no ior recorded ");
            this.markStopped();
            throw new ReconnectFailureException();
        }
        AdminAgent adminAgent = this.getNode().getAdminAgent();
        ActiveEJBServerConfig activeEJBServerConfig = (ActiveEJBServerConfig)this.getStartedConfigTree();
        activeEJBServerConfig.setListenerPort(this.listenerPort);
        super.getRecordedConfig((ActiveServerConfig)activeEJBServerConfig);
        activeEJBServerConfig.setAgentIOR(this.agentIOR);
        ParamList paramList = new ParamList(2);
        paramList.addElement(this.getEpoch());
        paramList.addElement((ActiveObjectConfig)activeEJBServerConfig);
        paramList.addElement(bl);
        Tr.event((TraceComponent)tc, (String)"recorded pid: ", (Object)activeEJBServerConfig.getRecordedPid());
        try {
            adminAgent.invokeActiveObject(activeEJBServerConfig.getName(), "reconnect", paramList);
        }
        catch (Exception exception) {
            Tr.warning((TraceComponent)tc, (String)"Failed to reconnect to a server: {0} {1}", (Object)new Object[]{this.getRelativeName(), exception});
            this.markStopped();
            throw new ReconnectFailureException();
        }
        Tr.exit((TraceComponent)tc, (String)"reconnect");
        return this.reconfirmContainedObjectsStop();
    }

    public boolean getSecurityEnabled() throws RemoteException {
        return this.securityEnabled;
    }

    public EJBServerBean() throws RemoteException {
        EJBServerBean.initializeNLS("RepositoryStrings");
        EJBServerBean.initializePersistentStore();
        EJBServerBean.initializeTypeId();
        EJBServerBean.lookupServerModuleRel();
        EJBServerBean.lookupServerResourceRel();
    }

    protected static void initializeNLS(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeNLS");
        }
        if (nls == null) {
            nls = new NLS(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeNLS");
        }
    }

    public void ejbLoad() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbLoad");
        Long l = (Long)this.ec.getPrimaryKey();
        DBQueryResult dBQueryResult = null;
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (!resultSet.next()) {
                    throw new RemoteException(defaultNetWareJVMVMSize, new ObjectNotFoundException());
                }
                if (this.setId(resultSet, myTypeId)) {
                    super.ejbLoad();
                    this.logFileSpec = resultSet.getString(3);
                    this.logFileSpec = this.logFileSpec == null ? new String() : this.logFileSpec.trim();
                    this.selectionPolicy = resultSet.getString(4);
                    this.tranTimeout = resultSet.getInt(5);
                    this.tranInactivityTimeout = resultSet.getInt(6);
                    this.threadPoolSize = resultSet.getInt(7);
                    this.debugEnabled = Utils.intToBoolean((int)resultSet.getInt(8));
                    this.oltEnabled = Utils.intToBoolean((int)resultSet.getInt(9));
                    this.securityEnabled = Utils.intToBoolean((int)resultSet.getInt(10));
                    this.isAClone = Utils.intToBoolean((int)resultSet.getInt(11));
                    this.getBinaryAttributes();
                }
                Tr.exit((TraceComponent)tc, (String)"ejbLoad");
            }
            catch (SQLException sQLException) {
                Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)sQLException);
                throw new RemoteException(defaultNetWareJVMVMSize, sQLException);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        if (this.narrowRef != null) {
            Tr.exit((TraceComponent)tc, (String)"ejbStore");
            return;
        }
        super.ejbStore();
        if (this.dirty) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("dirty: " + new Boolean(this.dirty)));
            }
            try {
                Vector<Object> vector = new Vector<Object>(11);
                vector.addElement(this.logFileSpec);
                vector.addElement(this.selectionPolicy);
                vector.addElement(new Integer(this.tranTimeout));
                vector.addElement(new Integer(this.tranInactivityTimeout));
                vector.addElement(new Integer(this.threadPoolSize));
                Tr.event((TraceComponent)tc, (String)"ejbStore -- threadPoolSize: ", (Object)new Integer(this.threadPoolSize));
                vector.addElement(new Integer(Utils.booleanToInt((boolean)this.debugEnabled)));
                vector.addElement(new Integer(Utils.booleanToInt((boolean)this.oltEnabled)));
                vector.addElement(new Integer(Utils.booleanToInt((boolean)this.securityEnabled)));
                vector.addElement(new Integer(Utils.booleanToInt((boolean)this.isAClone)));
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)sQLException);
                throw new RemoteException(defaultNetWareJVMVMSize, sQLException);
            }
        }
        Tr.exit((TraceComponent)tc, (String)"ejbStore");
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        Vector<String> vector;
        String string;
        Object object;
        block20: {
            if (this.id == null) {
                this.ejbLoad();
            }
            if (this.narrowRef != null) {
                this.narrowRef.remove();
                return;
            }
            if (this.listInstalledModules().hasMoreElements()) {
                throw new RemoteException("cannot remove this server because there are modules installed on it.\n");
            }
            try {
                if (this.getDesiredState() == 3) {
                    Tr.error((TraceComponent)tc, (String)"liveroi.running.object.remove.error");
                    throw new RunningObjectRemoveException();
                }
            }
            catch (OpException opException) {
                Tr.error((TraceComponent)tc, (String)"liveroi.running.object.remove.error");
                throw new RunningObjectRemoveException();
            }
            if (this.isAClone) {
                Tr.audit((TraceComponent)tc, (String)nls.getFormattedMessage("node.plugin.config.regen", null, PLUGIN_REGEN));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Removing clone from ServerGroup.");
                }
                try {
                    object = RepositoryObjectImpl.getInitialNamingContext();
                    string = ManagedServer.getInstance().qualifyRepositoryHomeName("RelationHome");
                    Tr.debug((TraceComponent)tc, (String)"looking up : ", (Object)string);
                    vector = object.lookup(string);
                    RelationHome relationHome = (RelationHome)PortableRemoteObject.narrow(vector, (Class)(class$com$ibm$ejs$sm$beans$RelationHome == null ? (class$com$ibm$ejs$sm$beans$RelationHome = EJBServerBean.class$("com.ibm.ejs.sm.beans.RelationHome")) : class$com$ibm$ejs$sm$beans$RelationHome));
                    Relation relation = relationHome.findByName("ServerGroupServerRel", true);
                    Enumeration enumeration = relation.list(this.ec.getEJBObject(), true);
                    while (enumeration.hasMoreElements()) {
                        ServerGroup serverGroup = (ServerGroup)enumeration.nextElement();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Removing server from: " + serverGroup.getFullName()));
                        }
                        serverGroup.disassociateClone((EJBServer)this.ec.getEJBObject());
                        relation.delete((EJBObject)serverGroup, this.ec.getEJBObject());
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug((TraceComponent)tc, (String)("Removing clone from ServerGroup failed: " + exception));
                }
            }
        }
        this.removeModuleRels();
        this.removeResourceRels();
        object = null;
        string = this.getRelativeName();
        try {
            object = this.getNode();
        }
        catch (OpException opException) {
            Tr.service((TraceComponent)tc, (String)"failed to get hold of Node bean from EJBServer bean");
        }
        this.serverGroup = null;
        super.ejbRemove();
        try {
            vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)this.id));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            throw new RemoteException(defaultNetWareJVMVMSize, sQLException);
        }
        try {
            if (object != null) {
                this.deleteXAResource((Node)object, string);
            } else {
                Tr.service((TraceComponent)tc, (String)"unable to delete XA Resouces for deleted server because Node bean is null");
            }
        }
        catch (Throwable throwable) {
            Tr.service((TraceComponent)tc, (String)"unable to delete XA Resouces for deleted server");
        }
    }

    public Long ejbCreate(EJBServerAttributes eJBServerAttributes, Node node) throws RemoteException, CreateException {
        String string;
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        try {
            string = eJBServerAttributes.getName();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)" < ejbCreate -- required attribute missing", (Object)((Object)attributeNotSetException));
            throw new RequiredAttributeMissingException(attributeNotSetException.getMessage());
        }
        try {
            if (this.typeId == null) {
                this.typeId = myTypeId;
            }
            Relation relation = ServerBean.lookupNodeServerRel();
            Enumeration enumeration = null;
            enumeration = relation.list((Long)node.getPrimaryKey(), string, false);
            if (enumeration.hasMoreElements()) {
                this.ec.setRollbackOnly();
                InvalidServerNameException invalidServerNameException = new InvalidServerNameException("Name already exists.");
                Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)invalidServerNameException);
                throw invalidServerNameException;
            }
            if (this.debugEnabled) {
                eJBServerAttributes.setJvm("java");
            } else {
                eJBServerAttributes.setJvm("java");
            }
            boolean bl = false;
            try {
                if (eJBServerAttributes.isSet("JVMConfig")) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            EJBServerAttributes eJBServerAttributes2 = (EJBServerAttributes)RepositoryObjectImpl.getDefaults(myTypeObj);
            eJBServerAttributes.copyAttributes(eJBServerAttributes2, 65535L, false);
            try {
                if (!bl) {
                    eJBServerAttributes.unSet("JVMConfig");
                    this.jvmConfig = new JVMConfig(node);
                }
            }
            catch (Exception exception) {
                Tr.warning((TraceComponent)tc, (String)nls.getString("ejbs.update.jvmconfig", "Unable to initialize JVM config while updating instance variables of EJBServerBen"));
            }
            super.ejbCreate(eJBServerAttributes, node);
            this.initializeInstanceVariables();
            this.updateInstanceVariables(eJBServerAttributes);
            Vector<Object> vector = new Vector<Object>(11);
            vector.addElement(Utils.getIdString((Long)this.id));
            vector.addElement(Utils.getIdString((Long)this.typeId));
            vector.addElement(this.logFileSpec);
            vector.addElement(this.selectionPolicy);
            vector.addElement(new Integer(this.tranTimeout));
            vector.addElement(new Integer(this.tranInactivityTimeout));
            vector.addElement(new Integer(this.threadPoolSize));
            vector.addElement(new Integer(Utils.booleanToInt((boolean)this.debugEnabled)));
            vector.addElement(new Integer(Utils.booleanToInt((boolean)this.oltEnabled)));
            vector.addElement(new Integer(Utils.booleanToInt((boolean)this.securityEnabled)));
            vector.addElement(new Integer(Utils.booleanToInt((boolean)this.isAClone)));
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(defaultNetWareJVMVMSize, sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)sQLException);
            throw remoteException;
        }
        if (this.isAClone) {
            Tr.audit((TraceComponent)tc, (String)nls.getFormattedMessage("node.plugin.config.regen", null, PLUGIN_REGEN));
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)this.id);
        return this.id;
    }

    public void ejbPostCreate(EJBServerAttributes eJBServerAttributes, Node node) {
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException, FinderException {
        Enumeration enumeration;
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll");
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)bl, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
        }
        catch (SQLException sQLException) {
            Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)sQLException);
            throw new RemoteException(defaultNetWareJVMVMSize, sQLException);
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFindAll");
        return enumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Enumeration ejbFindAllStandAloneServers() throws RemoteException, FinderException {
        Enumeration enumeration;
        Tr.entry((TraceComponent)tc, (String)"ejbFindAllStandAloneServers");
        DBQueryResult dBQueryResult = null;
        try {
            try {
                Vector<Integer> vector = new Vector<Integer>(1);
                vector.addElement(new Integer(Utils.booleanToInt((boolean)false)));
                dBQueryResult = DBMgr.executePreparedQuery((int)findAllStandAloneServersKey, (String)findAllStandAloneServersStmtSql, vector);
                Tr.exit((TraceComponent)tc, (String)"ejbFindAllStandAloneServers");
                enumeration = this.enumFinderEpilogue(dBQueryResult);
                Object var6_5 = null;
            }
            catch (SQLException sQLException) {
                Tr.exit((TraceComponent)tc, (String)"ejbFindAllStandAloneServers", (Object)sQLException);
                throw new RemoteException(defaultNetWareJVMVMSize, sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return enumeration;
    }

    private static void initializePersistentStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        Integer n = classLock;
        synchronized (n) {
            if (tableCreated) {
                return;
            }
        }
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + logFileSpecColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + selectionPolicyColumnName + DBMgr.mediumStringColumnSpec + " , " + tranTimeoutColumnName + " INTEGER NOT NULL " + " , " + tranInactivityTimeoutColumnName + " INTEGER NOT NULL " + " , " + threadPoolSizeColumnName + " INTEGER NOT NULL " + " , " + debugEnabledColumnName + " INTEGER NOT NULL " + " , " + oltEnabledColumnName + " INTEGER NOT NULL " + " , " + securityEnabledColumnName + " INTEGER NOT NULL " + " , " + isACloneColumnName + " INTEGER NOT NULL " + " , " + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Integer n2 = classLock;
            synchronized (n2) {
                tableCreated = true;
            }
        }
        catch (SQLException sQLException) {
            Tr.exit((TraceComponent)tc, (String)"initializePersistentStore", (Object)sQLException);
            throw new RemoteException(defaultNetWareJVMVMSize, sQLException);
        }
        Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
    }

    private static void initializeTypeId() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        Integer n = classLock;
        synchronized (n) {
            if (myTypeId != null) {
                return;
            }
        }
        EJBServerAttributes eJBServerAttributes = new EJBServerAttributes();
        String[] stringArray = new String[2];
        String string = System.getProperty("os.name");
        stringArray = string.startsWith("OS/400") ? new String[]{defaultOS400MinJVMHeapSize} : new String[]{};
        ServerBean.initializeDefaults(eJBServerAttributes);
        eJBServerAttributes.setJvm("java");
        eJBServerAttributes.setCommandLineArgs(stringArray);
        eJBServerAttributes.setTraceSpec(defaultTraceSpec);
        eJBServerAttributes.setTraceOutput(defaultTraceOutput);
        eJBServerAttributes.setLogFileSpec(defaultLogFileSpec);
        eJBServerAttributes.setSelectionPolicy(defaultSelectionPolicy);
        eJBServerAttributes.setTranTimeout(120);
        eJBServerAttributes.setTranInactivityTimeout(60000);
        eJBServerAttributes.setThreadPoolSize(20);
        eJBServerAttributes.setSystemProperties(new Properties());
        eJBServerAttributes.setDebugEnabled(false);
        eJBServerAttributes.setOLTEnabled(false);
        eJBServerAttributes.setOLTServerHost(defaultOLTServerHost);
        eJBServerAttributes.setOLTServerPort(2102);
        eJBServerAttributes.setSecurityEnabled(false);
        eJBServerAttributes.setIsAClone(false);
        eJBServerAttributes.setCacheConfig(defaultCacheConfig);
        defaultWebContainerConfig = WebContainerConfig.getDefaultWebContainerConfig();
        eJBServerAttributes.setWebContainerConfig(defaultWebContainerConfig);
        eJBServerAttributes.setModuleVisibility(3);
        eJBServerAttributes.setUseDomainQualifiedUserNames(false);
        eJBServerAttributes.setDefaultDataSource(new String());
        eJBServerAttributes.setServerGroup(null);
        eJBServerAttributes.setORBConfig(new ORBConfig());
        eJBServerAttributes.setJVMConfig(new JVMConfig());
        eJBServerAttributes.setCustomServiceConfig(new Vector());
        eJBServerAttributes.setNodeStartState("Current");
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, eJBServerAttributes, false);
        Long l = (Long)type.getPrimaryKey();
        Integer n2 = classLock;
        synchronized (n2) {
            myTypeObj = type;
            myTypeId = l;
        }
        Tr.exit((TraceComponent)tc, (String)"initializeTypeId");
    }

    private static Relation lookupServerResourceRel() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupServerResourceRel");
        }
        Integer n = classLock;
        synchronized (n) {
            if (ejbServerResourceRel != null) {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"lookupServerResourceRel");
                }
                Relation relation = ejbServerResourceRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.createRelIfNeeded(myTypeObj, "Resource", ejbServerResourceRelName, false, false, 2);
        Integer n2 = classLock;
        synchronized (n2) {
            ejbServerResourceRel = relation;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupServerResourceRel");
        }
        return relation;
    }

    private static Relation lookupServerModuleRel() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (ejbServerModuleRel != null) {
                Relation relation = ejbServerModuleRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.createRelIfNeeded(myTypeObj, "Module", ejbServerModuleRelName, false, false, 2);
        Integer n2 = classLock;
        synchronized (n2) {
            ejbServerModuleRel = relation;
        }
        return relation;
    }

    public Enumeration listInstalledModules() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"listInstalledModules");
        Integer n = classLock;
        synchronized (n) {
            if (this.narrowRef != null) {
                Enumeration enumeration = ((EJBServer)this.narrowRef).listInstalledModules();
                return enumeration;
            }
        }
        Relation relation = EJBServerBean.lookupServerModuleRel();
        return relation.list(this.id, false);
    }

    private void initializeInstanceVariables() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeInstanceVariables");
        EJBServerAttributes eJBServerAttributes = (EJBServerAttributes)RepositoryObjectImpl.getDefaults(myTypeObj);
        try {
            String[] stringArray = eJBServerAttributes.getCommandLineArgs();
            if (stringArray.length == 2 && stringArray[1].equals(defaultNetWareJVMVMSize)) {
                eJBServerAttributes.setCommandLineArgs(new String[0]);
            }
            this.traceSpec = eJBServerAttributes.getTraceSpec();
            this.setBinaryAttr(traceSpecAttrName, this.traceSpec);
            this.traceOutput = eJBServerAttributes.getTraceOutput();
            this.setBinaryAttr(traceOutputAttrName, this.traceOutput);
            try {
                this.pmiSpec = eJBServerAttributes.getPmiSpec();
            }
            catch (AttributeNotSetException attributeNotSetException) {
                this.pmiSpec = defaultNetWareJVMVMSize;
            }
            this.setBinaryAttr(pmiSpecAttrName, this.pmiSpec);
            this.logFileSpec = eJBServerAttributes.getLogFileSpec();
            this.selectionPolicy = eJBServerAttributes.getSelectionPolicy();
            this.tranTimeout = eJBServerAttributes.getTranTimeout();
            this.tranInactivityTimeout = eJBServerAttributes.getTranInactivityTimeout();
            this.threadPoolSize = eJBServerAttributes.getThreadPoolSize();
            this.agentIOR = new String();
            this.setBinaryAttr(agentIORAttrName, this.agentIOR);
            this.wlmTemplateIOR = new String();
            this.setBinaryAttr(wlmTemplateIORAttrName, this.wlmTemplateIOR);
            this.sysProps = eJBServerAttributes.getSystemProperties();
            this.setBinaryAttr(sysPropsAttrName, this.sysProps);
            this.debugEnabled = eJBServerAttributes.getDebugEnabled();
            this.sourcePath = defaultNetWareJVMVMSize;
            this.setBinaryAttr(sourcePathAttrName, this.sourcePath);
            this.oltEnabled = eJBServerAttributes.getOLTEnabled();
            try {
                this.oltServerHost = eJBServerAttributes.getOLTServerHost();
            }
            catch (AttributeNotSetException attributeNotSetException) {
                Tr.event((TraceComponent)tc, (String)"OLT Server host using defaults");
                this.oltServerHost = defaultOLTServerHost;
            }
            try {
                this.oltServerPort = eJBServerAttributes.getOLTServerPort();
            }
            catch (AttributeNotSetException attributeNotSetException) {
                Tr.event((TraceComponent)tc, (String)"OLT Server port using defaults");
                this.oltServerPort = 2102;
            }
            this.setBinaryAttr(oltServerHostAttrName, this.oltServerHost);
            this.setBinaryAttr(oltServerPortAttrName, new Integer(this.oltServerPort));
            this.securityEnabled = eJBServerAttributes.getSecurityEnabled();
            this.isAClone = eJBServerAttributes.getIsAClone();
            this.serverGroup = null;
            this.setBinaryAttr(serverGroupAttrName, this.serverGroup);
            this.cacheConfig = eJBServerAttributes.getCacheConfig();
            this.setBinaryAttr(cacheConfigAttrName, this.cacheConfig);
            this.listenerPort = 0;
            this.setBinaryAttr(listenerPortAttrName, new Integer(this.listenerPort));
            this.webContainerConfig = eJBServerAttributes.getWebContainerConfig();
            this.setBinaryAttr(webContainerConfigAttrName, this.webContainerConfig);
            this.moduleVisibility = eJBServerAttributes.getModuleVisibility();
            this.setBinaryAttr(moduleVisibilityAttrName, new Integer(this.moduleVisibility));
            this.useDomainQualifiedUserNames = eJBServerAttributes.getUseDomainQualifiedUserNames();
            Tr.debug((TraceComponent)tc, (String)("useDomainQualifiedUserName in EJBServer is " + this.useDomainQualifiedUserNames));
            this.setBinaryAttr(useDomainQualifiedUserNamesAttrName, new Boolean(this.useDomainQualifiedUserNames));
            this.defaultDataSource = eJBServerAttributes.getDefaultDataSource();
            this.setBinaryAttr(defaultDataSourceAttrName, this.defaultDataSource);
            this.orbConfig = new ORBConfig();
            if (this.jvmConfig == null) {
                this.jvmConfig = new JVMConfig();
            }
            this.customServiceConfig = EJBServerBean.getPreconfiguredCustomServices();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("list of CustomServices : " + this.customServiceConfig.toString()));
            }
            this.initialCustomServicesSet = true;
            this.setBinaryAttr(orbConfigAttrName, this.orbConfig);
            this.setBinaryAttr(jvmConfigAttrName, this.jvmConfig);
            this.setBinaryAttr(customServiceConfigAttrName, this.customServiceConfig);
            this.nodeStartState = eJBServerAttributes.getNodeStartState();
            this.setBinaryAttr(nodeStartStateAttrName, this.nodeStartState);
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"initializeInstanceVariables", (Object)exception);
            throw new RemoteException(defaultNetWareJVMVMSize, exception);
        }
        Tr.exit((TraceComponent)tc, (String)"initializeInstanceVariables");
    }

    private void updateInstanceVariables(EJBServerAttributes eJBServerAttributes) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"updateInstanceVariables");
        this.dirty = true;
        try {
            Object object;
            block55: {
                Object object2;
                String string;
                Object object3;
                boolean bl;
                block57: {
                    Vector vector;
                    Vector vector2;
                    block56: {
                        if (eJBServerAttributes.isSet("TraceSpec")) {
                            this.traceSpec = eJBServerAttributes.getTraceSpec();
                            this.setBinaryAttr(traceSpecAttrName, this.traceSpec);
                        }
                        if (eJBServerAttributes.isSet("TraceOutput")) {
                            this.traceOutput = eJBServerAttributes.getTraceOutput();
                            this.setBinaryAttr(traceOutputAttrName, this.traceOutput);
                        }
                        if (eJBServerAttributes.isSet("PmiSpec")) {
                            this.pmiSpec = eJBServerAttributes.getPmiSpec();
                            this.setBinaryAttr(pmiSpecAttrName, this.pmiSpec);
                        }
                        if (eJBServerAttributes.isSet("LogFileSpec")) {
                            this.logFileSpec = eJBServerAttributes.getLogFileSpec();
                        }
                        if (eJBServerAttributes.isSet("SelectionPolicy")) {
                            this.selectionPolicy = eJBServerAttributes.getSelectionPolicy();
                        }
                        if (eJBServerAttributes.isSet("TranTimeout")) {
                            this.tranTimeout = eJBServerAttributes.getTranTimeout();
                        }
                        if (eJBServerAttributes.isSet("TranInactivityTimeout")) {
                            this.tranInactivityTimeout = eJBServerAttributes.getTranInactivityTimeout();
                        }
                        if (eJBServerAttributes.isSet("ThreadPoolSize")) {
                            this.threadPoolSize = eJBServerAttributes.getThreadPoolSize();
                        }
                        if (eJBServerAttributes.isSet("SystemProperties")) {
                            this.sysProps = eJBServerAttributes.getSystemProperties();
                            this.setBinaryAttr(sysPropsAttrName, this.sysProps);
                        }
                        if (eJBServerAttributes.isSet("DebugEnabled")) {
                            this.debugEnabled = eJBServerAttributes.getDebugEnabled();
                        }
                        if (eJBServerAttributes.isSet("SourcePath")) {
                            this.sourcePath = eJBServerAttributes.getSourcePath();
                            this.setBinaryAttr(sourcePathAttrName, this.sourcePath);
                        }
                        if (eJBServerAttributes.isSet("OLTEnabled")) {
                            this.oltEnabled = eJBServerAttributes.getOLTEnabled();
                            if (this.oltEnabled) {
                                if (!eJBServerAttributes.isSet("OLTServerHost") || !eJBServerAttributes.isSet("OLTServerPort")) {
                                    Tr.event((TraceComponent)tc, (String)"OLT server host/port should be set when OLT is enabled");
                                    InvalidOltServerConfigException invalidOltServerConfigException = new InvalidOltServerConfigException();
                                    Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)invalidOltServerConfigException);
                                    throw new RemoteException(defaultNetWareJVMVMSize, (Throwable)invalidOltServerConfigException);
                                }
                                this.oltServerHost = eJBServerAttributes.getOLTServerHost();
                                this.setBinaryAttr(oltServerHostAttrName, this.oltServerHost);
                                this.oltServerPort = eJBServerAttributes.getOLTServerPort();
                                this.setBinaryAttr(oltServerPortAttrName, new Integer(this.oltServerPort));
                            }
                        }
                        if (eJBServerAttributes.isSet("SecurityEnabled")) {
                            this.securityEnabled = eJBServerAttributes.getSecurityEnabled();
                        }
                        if (eJBServerAttributes.isSet("IsAClone")) {
                            this.isAClone = eJBServerAttributes.getIsAClone();
                        }
                        if (eJBServerAttributes.isSet("ServerGroup")) {
                            this.serverGroup = eJBServerAttributes.getServerGroup();
                            this.setBinaryAttr(serverGroupAttrName, this.serverGroup);
                        }
                        if (eJBServerAttributes.isSet("CacheConfig")) {
                            this.cacheConfig = eJBServerAttributes.getCacheConfig();
                            this.setBinaryAttr(cacheConfigAttrName, this.cacheConfig);
                        }
                        if (!eJBServerAttributes.isSet("WebContainerConfig")) break block55;
                        bl = false;
                        object = eJBServerAttributes.getWebContainerConfig();
                        vector2 = ((WebContainerConfig)object).getTransports();
                        vector = this.webContainerConfig.getTransports();
                        if (vector != null) break block56;
                        if (vector2 == null) break block57;
                        bl = true;
                        break block57;
                    }
                    if (vector2 != null && vector2.size() != vector.size()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"updateInstanceVariables: different Vector sizes");
                        }
                        bl = true;
                    } else if (vector2 != null) {
                        object3 = vector2.elements();
                        string = null;
                        while (object3.hasMoreElements()) {
                            object2 = (TransportConfig)object3.nextElement();
                            if (vector.contains(object2)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"updateInstanceVariables: equals test fails");
                            }
                            bl = true;
                            break;
                        }
                    }
                }
                if (bl) {
                    Tr.audit((TraceComponent)tc, (String)nls.getFormattedMessage("node.plugin.config.regen", null, PLUGIN_REGEN));
                }
                if ((object2 = ((SessionManagerConfig)(object3 = this.webContainerConfig.getSessionManagerConfig())).getPersistentDatasourceName()) == null) {
                    object2 = defaultNetWareJVMVMSize;
                }
                if ((string = ((SessionManagerConfig)(object3 = ((WebContainerConfig)object).getSessionManagerConfig())).getPersistentDatasourceName()) == null) {
                    string = defaultNetWareJVMVMSize;
                }
                if (!string.equals(object2)) {
                    try {
                        if (!((String)object2).equals(defaultNetWareJVMVMSize)) {
                            this.removeResourceRel((String)object2);
                        }
                        if (!string.equals(defaultNetWareJVMVMSize)) {
                            this.addResourceRel(string);
                        }
                    }
                    catch (Throwable throwable) {
                        Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)throwable);
                        throw new RemoteException(defaultNetWareJVMVMSize, throwable);
                    }
                }
                this.webContainerConfig = object;
                this.setBinaryAttr(webContainerConfigAttrName, this.webContainerConfig);
            }
            if (eJBServerAttributes.isSet("ModuleVisibility")) {
                this.moduleVisibility = eJBServerAttributes.getModuleVisibility();
                this.setBinaryAttr(moduleVisibilityAttrName, new Integer(this.moduleVisibility));
            }
            if (eJBServerAttributes.isSet("UseDomainQualifiedUserNames")) {
                this.useDomainQualifiedUserNames = eJBServerAttributes.getUseDomainQualifiedUserNames();
                this.setBinaryAttr(useDomainQualifiedUserNamesAttrName, new Boolean(this.useDomainQualifiedUserNames));
            }
            if (eJBServerAttributes.isSet("DefaultDataSource")) {
                String string = eJBServerAttributes.getDefaultDataSource();
                object = this.defaultDataSource;
                if (object == null) {
                    object = defaultNetWareJVMVMSize;
                }
                if (string == null) {
                    string = defaultNetWareJVMVMSize;
                }
                if (!this.defaultDataSource.equals(string)) {
                    try {
                        if (!((String)object).equals(defaultNetWareJVMVMSize)) {
                            this.removeResourceRel((String)object);
                        }
                        if (string != null && !string.equals(defaultNetWareJVMVMSize)) {
                            this.addResourceRel(string);
                        }
                    }
                    catch (Throwable throwable) {
                        Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)throwable);
                        throw new RemoteException(defaultNetWareJVMVMSize, throwable);
                    }
                    this.defaultDataSource = string;
                    this.setBinaryAttr(defaultDataSourceAttrName, this.defaultDataSource);
                }
            }
            if (eJBServerAttributes.isSet("ORBConfig")) {
                this.orbConfig = eJBServerAttributes.getORBConfig();
                this.setBinaryAttr(orbConfigAttrName, this.orbConfig);
            }
            if (eJBServerAttributes.isSet("JVMConfig")) {
                this.jvmConfig = eJBServerAttributes.getJVMConfig();
                this.setBinaryAttr(jvmConfigAttrName, this.jvmConfig);
            } else if (this.jvmConfig == null) {
                try {
                    this.jvmConfig = new JVMConfig(this.getNode());
                    this.setBinaryAttr(jvmConfigAttrName, this.jvmConfig);
                }
                catch (Exception exception) {
                    Tr.warning((TraceComponent)tc, (String)nls.getString("ejbs.update.jvmconfig", "Unable to initialize JVM config while updating instance variables of EJBServerBen"));
                }
            }
            if (eJBServerAttributes.isSet("CustomServiceConfig")) {
                Vector vector = eJBServerAttributes.getCustomServiceConfig();
                if (this.initialCustomServicesSet) {
                    object = this.customServiceConfig.elements();
                    while (object.hasMoreElements()) {
                        vector.addElement(object.nextElement());
                    }
                    this.initialCustomServicesSet = false;
                }
                this.customServiceConfig = vector;
                this.customServiceConfig = EJBServerBean.applyCSConfigDupFilter(this.customServiceConfig);
                this.setBinaryAttr(customServiceConfigAttrName, this.customServiceConfig);
            }
            if (eJBServerAttributes.isSet("NodeStartState")) {
                this.nodeStartState = eJBServerAttributes.getNodeStartState();
                this.setBinaryAttr(nodeStartStateAttrName, this.nodeStartState);
            }
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeNotSetException));
            throw new RemoteException(defaultNetWareJVMVMSize, attributeNotSetException);
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeDoesNotExistException));
            throw new RemoteException(defaultNetWareJVMVMSize, attributeDoesNotExistException);
        }
        Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables");
    }

    protected static Vector applyCSConfigDupFilter(Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"applyCSConfigDupFilter");
        }
        if (vector == null || vector.size() <= 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"applyCSConfigDupFilter");
            }
            return vector;
        }
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        Vector<CustomServiceConfig> vector2 = new Vector<CustomServiceConfig>();
        int n = 0;
        while (n < vector.size()) {
            CustomServiceConfig customServiceConfig = (CustomServiceConfig)vector.elementAt(n);
            String string = customServiceConfig.getClassname();
            if (hashtable.get(string) == null) {
                hashtable.put(string, new Boolean(true));
                vector2.addElement(customServiceConfig);
            } else {
                Tr.audit((TraceComponent)tc, (String)nls.getFormattedMessage("ejbs.cs.dup.info", new Object[]{customServiceConfig.getName()}, "A duplicate custom service is found and removed: {0}"));
            }
            ++n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"applyCSConfigDupFilter");
        }
        return vector2;
    }

    private EJBServerAttributes readInstanceVariables(Attributes attributes) throws RemoteException, OpException {
        Object object;
        RepositoryObject repositoryObject;
        EJBServerAttributes eJBServerAttributes = (EJBServerAttributes)attributes;
        eJBServerAttributes.setTraceSpec(this.traceSpec);
        eJBServerAttributes.setTraceOutput(this.traceOutput);
        eJBServerAttributes.setPmiSpec(this.pmiSpec);
        eJBServerAttributes.setLogFileSpec(this.logFileSpec);
        eJBServerAttributes.setSelectionPolicy(this.selectionPolicy);
        eJBServerAttributes.setTranTimeout(this.tranTimeout);
        eJBServerAttributes.setTranInactivityTimeout(this.tranInactivityTimeout);
        eJBServerAttributes.setThreadPoolSize(this.threadPoolSize);
        eJBServerAttributes.setAdminAgentIOR(this.agentIOR);
        eJBServerAttributes.setWLMTemplateIOR(this.wlmTemplateIOR);
        eJBServerAttributes.setSystemProperties(this.sysProps);
        eJBServerAttributes.setDebugEnabled(this.debugEnabled);
        eJBServerAttributes.setOLTEnabled(this.oltEnabled);
        eJBServerAttributes.setSourcePath(this.sourcePath);
        eJBServerAttributes.setOLTServerHost(this.oltServerHost);
        eJBServerAttributes.setOLTServerPort(this.oltServerPort);
        eJBServerAttributes.setSecurityEnabled(this.securityEnabled);
        eJBServerAttributes.setIsAClone(this.isAClone);
        if (this.serverGroup != null && this.serverGroup instanceof Stub) {
            try {
                ((Stub)this.serverGroup)._orb();
            }
            catch (Exception exception) {
                ((Stub)this.serverGroup).connect((ORB)EJSORB.init());
            }
        }
        eJBServerAttributes.setServerGroup(this.serverGroup);
        eJBServerAttributes.setCacheConfig(this.cacheConfig);
        eJBServerAttributes.setWebContainerConfig(this.webContainerConfig);
        eJBServerAttributes.setModuleVisibility(this.moduleVisibility);
        eJBServerAttributes.setUseDomainQualifiedUserNames(this.useDomainQualifiedUserNames);
        eJBServerAttributes.setDefaultDataSource(this.defaultDataSource);
        if (eJBServerAttributes.activeAttributeRequested()) {
            this.getActiveAttributes(attributes);
        }
        eJBServerAttributes.setORBConfig(this.orbConfig);
        eJBServerAttributes.setJVMConfig(this.jvmConfig);
        eJBServerAttributes.setCustomServiceConfig(this.customServiceConfig);
        eJBServerAttributes.setNodeStartState(this.nodeStartState);
        try {
            repositoryObject = (Node)this.getContainingObject();
            eJBServerAttributes.setProvider(repositoryObject);
            object = new NodeAttributes();
            ((Attributes)object).request(Attributes.name);
            eJBServerAttributes.setParentName(repositoryObject.getAttributes((Attributes)object).getName());
        }
        catch (Exception exception) {
            throw new RemoteOpException(nls.getString("provider.ejbsrvb.exception", "Fail to request the node name"));
        }
        try {
            if (this.serverGroup != null) {
                repositoryObject = null;
                object = null;
                RelationHome relationHome = (RelationHome)RepositoryObjectImpl.getHome("RelationHome");
                repositoryObject = relationHome.findByName("ServerGroupServerRel", true);
                Enumeration enumeration = repositoryObject.list(this.ec.getEJBObject(), true);
                if (enumeration.hasMoreElements()) {
                    object = (ServerGroup)PortableRemoteObject.narrow(enumeration.nextElement(), (Class)(class$com$ibm$ejs$sm$beans$ServerGroup == null ? (class$com$ibm$ejs$sm$beans$ServerGroup = EJBServerBean.class$("com.ibm.ejs.sm.beans.ServerGroup")) : class$com$ibm$ejs$sm$beans$ServerGroup));
                }
                ServerGroupAttributes serverGroupAttributes = new ServerGroupAttributes();
                serverGroupAttributes.request(Attributes.name);
                eJBServerAttributes.setServerGroupName(object.getAttributes(serverGroupAttributes).getName());
            } else {
                eJBServerAttributes.setServerGroupName(defaultNetWareJVMVMSize);
            }
        }
        catch (Exception exception) {
            throw new RemoteOpException(nls.getString("ejbs.readinst.exception", "Failed to get the server group name"));
        }
        return eJBServerAttributes;
    }

    private EJBServerAttributes getActiveAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getActiveAttributes");
        EJBServerAttributes eJBServerAttributes = (EJBServerAttributes)attributes;
        ActiveEJBServerConfig activeEJBServerConfig = null;
        if (this.getDesiredState() == 3) {
            try {
                activeEJBServerConfig = (ActiveEJBServerConfig)this.getRuntimeAttr("Config");
            }
            catch (Exception exception) {
                Tr.event((TraceComponent)tc, (String)"Exception when fetching config: ", (Object)exception);
                activeEJBServerConfig = null;
            }
        }
        if (activeEJBServerConfig == null) {
            activeEJBServerConfig = (ActiveEJBServerConfig)this.getConfig();
        }
        eJBServerAttributes.setLogFileSpecActive(activeEJBServerConfig.getLogFileSpec());
        eJBServerAttributes.setSystemPropertiesActive(activeEJBServerConfig.getSystemProperties());
        eJBServerAttributes.setDebugEnabledActive(activeEJBServerConfig.getDebugEnabled());
        eJBServerAttributes.setSourcePathActive(activeEJBServerConfig.getSourcePath());
        eJBServerAttributes.setOLTEnabledActive(activeEJBServerConfig.getOLTEnabled());
        eJBServerAttributes.setOLTServerHostActive(activeEJBServerConfig.getOLTServerHost());
        eJBServerAttributes.setOLTServerPortActive(activeEJBServerConfig.getOLTServerPort());
        eJBServerAttributes.setSecurityEnabledActive(activeEJBServerConfig.getSecurityEnabled());
        eJBServerAttributes.setTraceSpecActive(activeEJBServerConfig.getTraceSpec());
        eJBServerAttributes.setTraceOutputActive(activeEJBServerConfig.getTraceOutput());
        ContainerCacheConfig containerCacheConfig = new ContainerCacheConfig();
        containerCacheConfig.setCacheSize(activeEJBServerConfig.getCacheSize());
        containerCacheConfig.setCacheSweepInterval(activeEJBServerConfig.getCacheSweepInterval());
        if (activeEJBServerConfig.getPassivationDir() != null) {
            containerCacheConfig.setPassivationDirectory(activeEJBServerConfig.getPassivationDir());
        }
        eJBServerAttributes.setCacheConfigActive(containerCacheConfig);
        eJBServerAttributes.setWebContainerConfigActive(activeEJBServerConfig.getWebContainerConfig());
        eJBServerAttributes.setModuleVisibilityActive(activeEJBServerConfig.getModuleVisibility());
        String string = null;
        if (activeEJBServerConfig.getDefaultDataSourceConfig() != null) {
            string = activeEJBServerConfig.getDefaultDataSourceConfig().getName();
        }
        eJBServerAttributes.setDefaultDataSourceActive(string);
        eJBServerAttributes.setUseDomainQualifiedUserNamesActive(activeEJBServerConfig.getUseDomainQualifiedUserNames());
        Tr.exit((TraceComponent)tc, (String)"getActiveAttributes");
        return eJBServerAttributes;
    }

    private void getBinaryAttributes() throws RemoteException {
        this.traceSpec = (String)this.getBinaryAttr(traceSpecAttrName);
        this.traceOutput = (String)this.getBinaryAttr(traceOutputAttrName);
        this.pmiSpec = (String)this.getBinaryAttr(pmiSpecAttrName);
        this.agentIOR = (String)this.getBinaryAttr(agentIORAttrName);
        this.wlmTemplateIOR = (String)this.getBinaryAttr(wlmTemplateIORAttrName);
        this.sysProps = (Properties)this.getBinaryAttr(sysPropsAttrName);
        this.listenerPort = (Integer)this.getBinaryAttr(listenerPortAttrName);
        this.oltServerHost = (String)this.getBinaryAttr(oltServerHostAttrName);
        this.sourcePath = (String)this.getBinaryAttr(sourcePathAttrName);
        if (this.sourcePath == null) {
            this.sourcePath = defaultNetWareJVMVMSize;
        }
        if (this.oltServerHost == null) {
            this.oltServerHost = defaultOLTServerHost;
            this.oltServerPort = 2102;
        } else {
            this.oltServerPort = (Integer)this.getBinaryAttr(oltServerPortAttrName);
        }
        this.cacheConfig = (ContainerCacheConfig)this.getBinaryAttr(cacheConfigAttrName);
        this.webContainerConfig = (WebContainerConfig)this.getBinaryAttr(webContainerConfigAttrName);
        this.moduleVisibility = (Integer)this.getBinaryAttr(moduleVisibilityAttrName);
        this.useDomainQualifiedUserNames = (Boolean)this.getBinaryAttr(useDomainQualifiedUserNamesAttrName);
        this.defaultDataSource = (String)this.getBinaryAttr(defaultDataSourceAttrName);
        this.serverGroup = (ServerGroup)this.getBinaryAttr(serverGroupAttrName);
        this.orbConfig = (ORBConfig)this.getBinaryAttr(orbConfigAttrName);
        this.jvmConfig = (JVMConfig)this.getBinaryAttr(jvmConfigAttrName);
        this.customServiceConfig = (Vector)this.getBinaryAttr(customServiceConfigAttrName);
        this.nodeStartState = (String)this.getBinaryAttr(nodeStartStateAttrName);
    }

    private void removeModuleRels() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"removeModuleRels");
        try {
            Relation relation = EJBServerBean.lookupServerModuleRel();
            Enumeration enumeration = this.listRelatedObjects(relation);
            while (enumeration.hasMoreElements()) {
                this.deleteFromRelation(relation, (Module)enumeration.nextElement());
            }
        }
        catch (Throwable throwable) {
            this.ec.setRollbackOnly();
            Tr.error((TraceComponent)tc, (String)nls.getFormattedMessage("ejbs.module.rel.remove.exception", new Object[]{throwable}, "Error removing server's module relationships.\n{0}"));
            throw new RemoteException(defaultNetWareJVMVMSize, throwable);
        }
        Tr.exit((TraceComponent)tc, (String)"removeModuleRels");
    }

    private void removeResourceRels() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"removeResourceRels");
        try {
            Relation relation = EJBServerBean.lookupServerResourceRel();
            relation.deleteForReResolve(this.id);
        }
        catch (RelationInstanceNotFoundException relationInstanceNotFoundException) {
        }
        catch (Throwable throwable) {
            this.ec.setRollbackOnly();
            Tr.error((TraceComponent)tc, (String)nls.getFormattedMessage("ejbs.server.rels.remove.exception", new Object[]{throwable}, "Error removing server's resource relationships.\n{0}"));
            throw new RemoteException(defaultNetWareJVMVMSize, throwable);
        }
        Tr.exit((TraceComponent)tc, (String)"removeResourceRels");
    }

    private void removeResourceRel(String string) throws Throwable {
        Tr.entry((TraceComponent)tc, (String)"removeResourceRel");
        try {
            Relation relation = EJBServerBean.lookupServerResourceRel();
            DataSourceHome dataSourceHome = (DataSourceHome)RepositoryObjectImpl.getHome("DataSourceHome");
            DataSource dataSource = dataSourceHome.findByName(string, true);
            relation.deleteReference(this.ec.getEJBObject(), dataSource);
        }
        catch (FinderException finderException) {
            Tr.warning((TraceComponent)tc, (String)nls.getFormattedMessage("ejbs.resource.rel.finder.exception", new Object[]{string, finderException}, "Could not remove server/resource relationship.  Unable to find the resource named {0}.\n{1}"));
        }
        catch (Throwable throwable) {
            this.ec.setRollbackOnly();
            Tr.error((TraceComponent)tc, (String)nls.getFormattedMessage("ejbs.remove.resource.rel.exception", new Object[]{this.getRelativeName(), string, throwable}, "Error encountered removing relationship between server named {0} and resource named {1}.\n{2}"));
            Tr.exit((TraceComponent)tc, (String)"removeResourceRel", (Object)throwable);
            throw throwable;
        }
        Tr.exit((TraceComponent)tc, (String)"removeResourceRel");
    }

    private void addResourceRel(String string) throws Throwable {
        Tr.entry((TraceComponent)tc, (String)"addResourceRel");
        try {
            Relation relation = EJBServerBean.lookupServerResourceRel();
            DataSourceHome dataSourceHome = (DataSourceHome)RepositoryObjectImpl.getHome("DataSourceHome");
            DataSource dataSource = dataSourceHome.findByName(string, true);
            relation.addWithRefCount(this.id, (Long)dataSource.getPrimaryKey());
        }
        catch (Throwable throwable) {
            this.ec.setRollbackOnly();
            Tr.error((TraceComponent)tc, (String)nls.getFormattedMessage("ejbs.add.resource.rel.exception", new Object[]{this.getRelativeName(), string, throwable}, "Error encountered adding relationship between server named {0} and resource named {1}.\n{2}"));
            Tr.exit((TraceComponent)tc, (String)"addResourceRel", (Object)throwable);
            throw throwable;
        }
        Tr.exit((TraceComponent)tc, (String)"addResourceRel");
    }

    protected static Vector getPreconfiguredCustomServices() {
        Vector<CustomServiceConfig> vector = new Vector<CustomServiceConfig>();
        Domain domain = null;
        com.ibm.ejs.models.base.config.applicationserver.Node node = null;
        ApplicationServer applicationServer = null;
        CustomService customService = null;
        String string = null;
        String string2 = null;
        try {
            string2 = AdminServer.getAdminServerInstance().getPreconfiguredCustomServicesFile();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("list of preconfigured services: " + string2));
            }
            if (string2 == null || string2.equals(defaultNetWareJVMVMSize)) {
                return vector;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processing preconfigured service: " + string));
                }
                if (string == null || string.equals(defaultNetWareJVMVMSize)) continue;
                File file = new File(string);
                if (!file.exists()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Preconfig file does not exist: " + string));
                    }
                    Tr.warning((TraceComponent)tc, (String)nls.getFormattedMessage("ejbs.file.does.not.exist", new Object[]{string}, "File does not exist: {0}"));
                    continue;
                }
                domain = EJBServerBean.readPreconfiguredCustomServices(string);
                EList eList = domain.getNodes();
                if (eList.size() != 1) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"No Node in config file.");
                    continue;
                }
                node = (com.ibm.ejs.models.base.config.applicationserver.Node)eList.get(0);
                EList eList2 = node.getServers();
                if (eList2.size() != 1) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"No ApplicationServer in config file.");
                    continue;
                }
                applicationServer = (ApplicationServer)eList2.get(0);
                EList eList3 = applicationServer.getCustomServices();
                if (eList3.size() < 1) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"No CustomServices in config file.");
                    continue;
                }
                int n = 0;
                while (n < eList3.size()) {
                    customService = (CustomService)eList3.get(n);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("CustomService: " + customService.toString()));
                    }
                    CustomServiceConfig customServiceConfig = new CustomServiceConfig();
                    customServiceConfig.setClassname(customService.getClassname());
                    customServiceConfig.setName(customService.getDisplayName());
                    customServiceConfig.setEnabled(customService.getEnable());
                    customServiceConfig.setClasspath(customService.getClasspath());
                    customServiceConfig.setDescription(customService.getDescription());
                    customServiceConfig.setExternalConfigURL(customService.getExternalConfigURL());
                    EList eList4 = customService.getDynamicProps();
                    Properties properties = new Properties();
                    int n2 = 0;
                    while (n2 < eList4.size()) {
                        SystemProperty systemProperty = (SystemProperty)eList4.get(n2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("CustomService config prop: " + systemProperty.toString()));
                        }
                        ((Hashtable)properties).put(systemProperty.getName(), systemProperty.getValue());
                        ++n2;
                    }
                    customServiceConfig.setDynamicProps(properties);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("CustomServiceConfig: " + customServiceConfig.toString()));
                    }
                    vector.addElement(customServiceConfig);
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("load configFile exception: \n" + throwable));
            }
            Tr.error((TraceComponent)tc, (String)nls.getFormattedMessage("ejbs.failed.to.read.file", new Object[]{string}, "Failed to read and parse file: {0}"));
            return new Vector();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("serviceList: " + vector.toString()));
        }
        return vector;
    }

    protected static Domain readPreconfiguredCustomServices(String string) {
        Context context = EJBServerBean.createContext();
        ResourceSet resourceSet = context.getResourceSet();
        Resource resource = null;
        Extent extent = null;
        try {
            Iterator iterator;
            resource = resourceSet.load(string);
            extent = resource.getExtent();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Read config file successfully.");
            }
            if ((iterator = extent.iterator()).hasNext()) {
                return (Domain)iterator.next();
            }
            Tr.error((TraceComponent)tc, (String)nls.getFormattedMessage("ejbs.failed.to.find.domain", new Object[]{string}, "Could not find the Domain object in {0}"));
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("load configFile exception: \n" + throwable));
            }
            Tr.error((TraceComponent)tc, (String)nls.getFormattedMessage("ejbs.error.reading.file", new Object[]{string, throwable}, "Error encountered reading {0}\n{1}"));
        }
        return null;
    }

    protected static Context createContext() {
        Context context = JavaRefFactoryImpl.createJavaContext();
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        context.setResourceSet((ResourceSet)resourceSetImpl);
        resourceSetImpl.setContext(context);
        context.addAdapterFactory((AdapterFactory)new WebSphereAdapterFactory());
        return context;
    }

    private void validateResources(ActiveEJBServerConfig activeEJBServerConfig) throws RemoteException, OpException {
        Object object;
        Vector vector;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateResources");
        }
        if ((vector = activeEJBServerConfig.getContainedConfigs(null)) != null) {
            object = this.getNode();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Vector vector2;
                ActiveModuleConfig activeModuleConfig = (ActiveModuleConfig)enumeration.nextElement();
                if (activeModuleConfig == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Validating resources for module " + activeModuleConfig.getName()));
                }
                if ((vector2 = activeModuleConfig.getJ2EEResourceConfigs()) == null) continue;
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    J2EEResourceConfig j2EEResourceConfig = (J2EEResourceConfig)enumeration2.nextElement();
                    this.validateResource(j2EEResourceConfig);
                }
            }
        }
        object = activeEJBServerConfig.getDefaultDataSourceConfig();
        this.validateResource((J2EEResourceConfig)object);
        object = activeEJBServerConfig.getSessionMgrDataSourceConfig();
        this.validateResource((J2EEResourceConfig)object);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateResources");
        }
    }

    private void validateResource(J2EEResourceConfig j2EEResourceConfig) throws RemoteException, OpException {
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateResource");
        }
        if (j2EEResourceConfig != null) {
            String string;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Validating resource named " + j2EEResourceConfig.getName()));
            }
            J2EEResourceProviderConfig j2EEResourceProviderConfig = j2EEResourceConfig.getProvider();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Validating resource provider named " + j2EEResourceProviderConfig.getName() + " with classpath = " + j2EEResourceProviderConfig.getClasspath()));
            }
            if ((string = j2EEResourceProviderConfig.getClasspath()) == null) {
                Tr.error((TraceComponent)tc, (String)nls.getFormattedMessage("ejbs.provider.not.installed", new Object[]{j2EEResourceProviderConfig.getName()}, "This server requires the resource provider named {0} but it is not installed on this node."));
                throw new ResourceProviderNotInstalledException(nls.getFormattedMessage("ejbs.provider.not.installed", new Object[]{j2EEResourceProviderConfig.getName()}, "This server requires the resource provider named {0} but it is not installed on this node."));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateResource");
        }
    }

    private Attributes setAttributesForClone(Attributes attributes) {
        boolean bl;
        block37: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"handleSettingConfigAttributes");
            }
            bl = false;
            try {
                bl = ((EJBServerAttributes)attributes).getCalledFromServerGroup();
            }
            catch (AttributeNotSetException attributeNotSetException) {
                if (!tc.isEventEnabled()) break block37;
                Tr.event((TraceComponent)tc, (String)"Caught attribute not set exception; leaving fromGroup false");
            }
        }
        if (!bl) {
            EJBServerAttributes eJBServerAttributes = new EJBServerAttributes();
            int n = 8;
            eJBServerAttributes.copyAttributes((EJBServerAttributes)attributes, n, true);
            try {
                BinaryAttrSerialization binaryAttrSerialization;
                if (attributes.isSet("ORBConfig")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"orbConfig is set");
                    }
                    if (this.handleSettingConfigAttributes(this.orbConfig, (CloneOnlyAwareConfig)((Object)(binaryAttrSerialization = ((EJBServerAttributes)attributes).getORBConfig())), true)) {
                        eJBServerAttributes.setORBConfig(this.orbConfig);
                    }
                }
                if (attributes.isSet("CacheConfig")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"cacheConfig is set");
                    }
                    if (this.handleSettingConfigAttributes(this.cacheConfig, (CloneOnlyAwareConfig)((Object)(binaryAttrSerialization = ((EJBServerAttributes)attributes).getCacheConfig())), true)) {
                        eJBServerAttributes.setCacheConfig(this.cacheConfig);
                    }
                }
                if (attributes.isSet("WebContainerConfig")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"webContainerConfig is set");
                    }
                    if (this.handleSettingConfigAttributes(this.webContainerConfig, (CloneOnlyAwareConfig)((Object)(binaryAttrSerialization = ((EJBServerAttributes)attributes).getWebContainerConfig())), true)) {
                        eJBServerAttributes.setWebContainerConfig(this.webContainerConfig);
                    }
                }
                if (attributes.isSet("JVMConfig")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"jvmConfig is set");
                    }
                    if (this.handleSettingConfigAttributes(this.jvmConfig, (CloneOnlyAwareConfig)((Object)(binaryAttrSerialization = ((EJBServerAttributes)attributes).getJVMConfig())), true)) {
                        eJBServerAttributes.setJVMConfig(this.jvmConfig);
                    }
                }
            }
            catch (AttributeDoesNotExistException attributeDoesNotExistException) {
                Tr.audit((TraceComponent)tc, (String)("Caught AttributeDoesNotExistException: " + (Object)((Object)attributeDoesNotExistException)));
            }
            catch (AttributeNotSetException attributeNotSetException) {
                Tr.audit((TraceComponent)tc, (String)("Caught AttributeNotSetException: " + (Object)((Object)attributeNotSetException)));
            }
            catch (ClassNotFoundException classNotFoundException) {
                Tr.audit((TraceComponent)tc, (String)("Caught ClassNotFoundException: " + classNotFoundException));
            }
            attributes = eJBServerAttributes;
        } else {
            try {
                BinaryAttrSerialization binaryAttrSerialization;
                if (attributes.isSet("ORBConfig")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"orbConfig is set");
                    }
                    binaryAttrSerialization = new ORBConfig(((EJBServerAttributes)attributes).getORBConfig());
                    this.handleSettingConfigAttributes(this.orbConfig, (CloneOnlyAwareConfig)((Object)binaryAttrSerialization), false);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"setting ORBConfig");
                    }
                    ((EJBServerAttributes)attributes).setORBConfig((ORBConfig)binaryAttrSerialization);
                }
                if (attributes.isSet("CacheConfig")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"cacheConfig is set");
                    }
                    binaryAttrSerialization = new ContainerCacheConfig(((EJBServerAttributes)attributes).getCacheConfig());
                    this.handleSettingConfigAttributes(this.cacheConfig, (CloneOnlyAwareConfig)((Object)binaryAttrSerialization), false);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"setting cacheConfig");
                    }
                    ((EJBServerAttributes)attributes).setCacheConfig((ContainerCacheConfig)binaryAttrSerialization);
                }
                if (attributes.isSet("WebContainerConfig")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"webContainerConfig is set");
                    }
                    binaryAttrSerialization = new WebContainerConfig(((EJBServerAttributes)attributes).getWebContainerConfig());
                    this.handleSettingConfigAttributes(this.webContainerConfig, (CloneOnlyAwareConfig)((Object)binaryAttrSerialization), false);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"setting webContainerConfig");
                    }
                    ((EJBServerAttributes)attributes).setWebContainerConfig((WebContainerConfig)binaryAttrSerialization);
                }
                if (attributes.isSet("JVMConfig")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"jvmConfig is set");
                    }
                    binaryAttrSerialization = new JVMConfig(((EJBServerAttributes)attributes).getJVMConfig());
                    this.handleSettingConfigAttributes(this.jvmConfig, (CloneOnlyAwareConfig)((Object)binaryAttrSerialization), false);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"setting jvmConfig");
                    }
                    ((EJBServerAttributes)attributes).setJVMConfig((JVMConfig)binaryAttrSerialization);
                }
            }
            catch (AttributeDoesNotExistException attributeDoesNotExistException) {
                Tr.audit((TraceComponent)tc, (String)("Caught AttributeDoesNotExistException: " + (Object)((Object)attributeDoesNotExistException)));
            }
            catch (AttributeNotSetException attributeNotSetException) {
                Tr.audit((TraceComponent)tc, (String)("Caught AttributeNotSetException: " + (Object)((Object)attributeNotSetException)));
            }
            catch (ClassNotFoundException classNotFoundException) {
                Tr.audit((TraceComponent)tc, (String)("Caught ClassNotFoundException: " + classNotFoundException));
            }
        }
        return attributes;
    }

    private boolean handleSettingConfigAttributes(CloneOnlyAwareConfig cloneOnlyAwareConfig, CloneOnlyAwareConfig cloneOnlyAwareConfig2, boolean bl) throws ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleSettingConfigAttributes");
        }
        boolean bl2 = false;
        Class<?> clazz = cloneOnlyAwareConfig.getClass();
        Vector vector = cloneOnlyAwareConfig.retrieveCloneOnlyAttributeNames();
        Vector vector2 = cloneOnlyAwareConfig.retrieveCloneOnlyAttributeGetters();
        int n = 0;
        while (n < vector.size()) {
            try {
                String string = (String)vector.get(n);
                String string2 = (String)vector2.get(n);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("found clone-only part: " + string));
                }
                Method method = clazz.getMethod(string2, null);
                Object object = method.invoke((Object)cloneOnlyAwareConfig2, null);
                Object object2 = method.invoke((Object)cloneOnlyAwareConfig, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("newValue: " + object));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("existingValue: " + object2));
                }
                if (object == null || !object.equals(object2)) {
                    Object[] objectArray = new Object[]{bl ? object : object2};
                    Class[] classArray = new Class[]{method.getReturnType()};
                    Method method2 = clazz.getMethod("set" + string, classArray);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("changing value for : " + string));
                    }
                    bl2 = true;
                    if (bl) {
                        method2.invoke((Object)cloneOnlyAwareConfig, objectArray);
                    } else {
                        method2.invoke((Object)cloneOnlyAwareConfig2, objectArray);
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                Tr.audit((TraceComponent)tc, (String)("Caught IllegalAccessException setting attributes: " + illegalAccessException));
            }
            catch (InvocationTargetException invocationTargetException) {
                Tr.audit((TraceComponent)tc, (String)("Caught InvocationTargetException setting attributes: " + invocationTargetException));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Tr.audit((TraceComponent)tc, (String)("Caught NoSuchMethodException setting attributes: " + noSuchMethodException));
            }
            ++n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("handleSettingConfigAttributes returning " + bl2));
        }
        return bl2;
    }

    public ActiveObjectConfig getStartedConfigTree() throws RemoteException, OpException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getStartedConfigTree");
        }
        ActiveObjectConfig activeObjectConfig = this.getConfig();
        Enumeration enumeration = this.listContainedObjects();
        while (enumeration.hasMoreElements()) {
            Module module = (Module)enumeration.nextElement();
            if (module.getDesiredState() != 3) continue;
            activeObjectConfig.addContainedConfig(module.getConfig((EJBServer)this.ec.getEJBObject()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getStartedConfigTree");
        }
        return activeObjectConfig;
    }

    private Act deleteXAResource(Node node, String string) throws RemoteException, OpException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteXAResource");
        }
        ActServerImpl actServerImpl = ActServerImpl.getInstance();
        DeleteXAResourceTask deleteXAResourceTask = new DeleteXAResourceTask(node, string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteXAResource");
        }
        return actServerImpl.scheduleWork((AsyncTask)deleteXAResourceTask);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ejbServerBeanKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
        loadStmtKey = ejbServerBeanKeyBase + 1;
        deleteStmtKey = ejbServerBeanKeyBase + 2;
        updateStmtKey = ejbServerBeanKeyBase + 3;
        findAllStmtKey = ejbServerBeanKeyBase + 4;
        restrictedFindAllStmtKey = ejbServerBeanKeyBase + 5;
        insertStmtKey = ejbServerBeanKeyBase + 6;
        findAllStandAloneServersKey = ejbServerBeanKeyBase + 7;
        findAllStandAloneServersStmtSql = "select * from " + tableName + " where " + isACloneColumnName + " = ? ";
        deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " =  ?";
        insertStmtSql = "insert into " + tableName + " values(?,?,?,?,?,?,?,?,?,?,?)";
        updateStmtSql = "update " + tableName + " set " + logFileSpecColumnName + " =  ? , " + selectionPolicyColumnName + " =  ? , " + tranTimeoutColumnName + " =  ? , " + tranInactivityTimeoutColumnName + " =  ? , " + threadPoolSizeColumnName + " =  ? , " + debugEnabledColumnName + " =  ? , " + oltEnabledColumnName + " =  ? , " + securityEnabledColumnName + " =  ? , " + isACloneColumnName + " =  ? " + " where " + "INSTANCE_ID" + " = ?";
    }

    class DeleteXAResourceTask
    implements AsyncTask {
        private Node node;
        private String relativeName;

        DeleteXAResourceTask(Node node, String string) {
            this.node = node;
            this.relativeName = string;
        }

        public String getName() {
            return "DeleteXAResourceTask";
        }

        public void execute() throws RemoteException, OpException {
            FileBrowserServiceHome fileBrowserServiceHome;
            block5: {
                Tr.entry((TraceComponent)tc, (String)"DeleteXAResourceTask - execute");
                fileBrowserServiceHome = null;
                try {
                    fileBrowserServiceHome = (FileBrowserServiceHome)RepositoryObjectImpl.getEJBHome("FileBrowserServiceHome");
                }
                catch (Exception exception) {
                    if (!tc.isEventEnabled()) break block5;
                    Tr.event((TraceComponent)tc, (String)"Exception getting FileBrowserServiceHome; ignoring");
                }
            }
            String string = EJBServerBean.defaultNetWareJVMVMSize;
            String string2 = EJBServerBean.defaultNetWareJVMVMSize;
            try {
                FileBrowserService fileBrowserService = fileBrowserServiceHome.create(this.node);
                NodeAttributes nodeAttributes = new NodeAttributes();
                nodeAttributes.request("InstallRoot");
                String string3 = ((NodeAttributes)this.node.getAttributes(nodeAttributes)).getInstallRoot();
                string = string3 + fileBrowserService.getFileSeparator() + "properties" + fileBrowserService.getFileSeparator() + this.relativeName + "XAResources";
                string2 = this.node.getFullName().getLeafElement().getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("About to remove file " + string + " on node " + string2));
                }
                fileBrowserService.deleteFile(string);
            }
            catch (Exception exception) {
                Tr.audit((TraceComponent)tc, (String)"exception while delete file");
                exception.printStackTrace();
                String string4 = nls.getFormattedMessage("ejbs.cannot.remove.remote.file", new Object[]{string, string2}, "Unable to remove {0} on node {1}; please remove manually when convenient");
                Tr.service((TraceComponent)tc, (String)string4);
            }
            Tr.exit((TraceComponent)tc, (String)"DeleteXAResourceTask - execute");
        }
    }
}

