/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.sm.beans.BinaryAttrSerialization;
import com.ibm.ejs.sm.beans.SecureSocketLayerConfig;
import com.ibm.ejs.sm.beans.TransportConfig;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;

public class HTTPTransportConfig
implements Serializable,
TransportConfig,
BinaryAttrSerialization {
    private static final long serialVersionUID = 0L;
    private int maxKeepAlive;
    private int maxReqKeepAlive;
    private int keepAliveTimeout;
    private int socketTimeout;
    private String host;
    private int port;
    private int backlogConnections;
    private Properties httpProperties = new Properties();
    private boolean sSLEnabled;
    private SecureSocketLayerConfig sSL;
    public static final String maxKeepAlivePropKey = "maxKeepAlive";
    public static final String maxReqKeepAlivePropKey = "maxReqKeepAlive";
    public static final String keepAliveTimeoutPropKey = "keepAliveTimeout";
    public static final String socketTimeoutPropKey = "socketTimeout";
    public static final String hostPropKey = "host";
    public static final String portPropKey = "port";
    public static final String backlogConnectionsPropKey = "backlogConnections";
    public static final String httpPropertiesPropKey = "httpProperties";
    public static final String sSLEnabledPropKey = "sSLEnabled";
    public static final String sSLPropKey = "sSL";

    public boolean equals(Object object) {
        if (!(object instanceof HTTPTransportConfig)) {
            return false;
        }
        HTTPTransportConfig hTTPTransportConfig = (HTTPTransportConfig)object;
        if (hTTPTransportConfig.getHost() != null && this.host != null ? !hTTPTransportConfig.getHost().equals(this.host) : this.host != hTTPTransportConfig.getHost()) {
            return false;
        }
        if (hTTPTransportConfig.getSSLConfig() != null && this.sSL != null ? !hTTPTransportConfig.getSSLConfig().equals(this.sSL) : this.sSL != hTTPTransportConfig.getSSLConfig()) {
            return false;
        }
        if (hTTPTransportConfig.getPort() != this.port || hTTPTransportConfig.getMaxKeepAlive() != this.maxKeepAlive || hTTPTransportConfig.getMaxReqKeepAlive() != this.maxReqKeepAlive || hTTPTransportConfig.getKeepAliveTimeout() != this.keepAliveTimeout || hTTPTransportConfig.getConnectionTimeout() != this.socketTimeout || hTTPTransportConfig.getBacklogConnections() != this.backlogConnections || hTTPTransportConfig.getSSLEnabled() != this.sSLEnabled) {
            return false;
        }
        return !(hTTPTransportConfig.getHttpProperties() != null && this.httpProperties != null ? ((Hashtable)hTTPTransportConfig.getHttpProperties()).size() != ((Hashtable)this.httpProperties).size() : hTTPTransportConfig.getHttpProperties() != this.httpProperties);
    }

    public int getMaxKeepAlive() {
        return this.maxKeepAlive;
    }

    public void setMaxKeepAlive(int n) {
        this.maxKeepAlive = n;
    }

    public int getMaxReqKeepAlive() {
        return this.maxReqKeepAlive;
    }

    public void setMaxReqKeepAlive(int n) {
        this.maxReqKeepAlive = n;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int n) {
        this.keepAliveTimeout = n;
    }

    public int getConnectionTimeout() {
        return this.socketTimeout;
    }

    public void setConnectionTimeout(int n) {
        this.socketTimeout = n;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getBacklogConnections() {
        return this.backlogConnections;
    }

    public void setBacklogConnections(int n) {
        this.backlogConnections = n;
    }

    public Properties getHttpProperties() {
        return this.httpProperties;
    }

    public void setHttpProperties(Properties properties) {
        this.httpProperties = properties;
    }

    public void addHttpProperty(String string, String string2) {
        ((Hashtable)this.httpProperties).put(string, string2);
    }

    public boolean getSSLEnabled() {
        return this.sSLEnabled;
    }

    public void setSSLEnabled(boolean bl) {
        this.sSLEnabled = bl;
    }

    public SecureSocketLayerConfig getSSLConfig() {
        return this.sSL;
    }

    public void setSSLConfig(SecureSocketLayerConfig secureSocketLayerConfig) {
        this.sSL = secureSocketLayerConfig;
    }

    public String getProtocol() {
        if (this.getSSLEnabled()) {
            return "https";
        }
        return "http";
    }

    public static HTTPTransportConfig getDefaultHTTPTransportConfig() {
        HTTPTransportConfig hTTPTransportConfig = new HTTPTransportConfig();
        hTTPTransportConfig.setMaxKeepAlive(45);
        hTTPTransportConfig.setMaxReqKeepAlive(100);
        hTTPTransportConfig.setKeepAliveTimeout(5);
        hTTPTransportConfig.setConnectionTimeout(5);
        hTTPTransportConfig.setHost("*");
        hTTPTransportConfig.setPort(9080);
        hTTPTransportConfig.setBacklogConnections(511);
        hTTPTransportConfig.setSSLEnabled(false);
        hTTPTransportConfig.setSSLConfig(null);
        return hTTPTransportConfig;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        ((Hashtable)properties).put(maxKeepAlivePropKey, new Integer(this.maxKeepAlive));
        ((Hashtable)properties).put(maxReqKeepAlivePropKey, new Integer(this.maxReqKeepAlive));
        ((Hashtable)properties).put(keepAliveTimeoutPropKey, new Integer(this.keepAliveTimeout));
        ((Hashtable)properties).put(socketTimeoutPropKey, new Integer(this.socketTimeout));
        if (this.host != null) {
            ((Hashtable)properties).put(hostPropKey, this.host);
        }
        ((Hashtable)properties).put(portPropKey, new Integer(this.port));
        ((Hashtable)properties).put(backlogConnectionsPropKey, new Integer(this.backlogConnections));
        if (this.httpProperties != null) {
            ((Hashtable)properties).put(httpPropertiesPropKey, this.httpProperties);
        }
        ((Hashtable)properties).put(sSLEnabledPropKey, new Boolean(this.sSLEnabled));
        if (this.sSL != null) {
            ((Hashtable)properties).put(sSLPropKey, this.sSL);
        }
        return properties;
    }

    public void fromProperties(Properties properties) {
        if (((Hashtable)properties).containsKey(maxKeepAlivePropKey)) {
            this.maxKeepAlive = (Integer)((Hashtable)properties).get(maxKeepAlivePropKey);
        }
        if (((Hashtable)properties).containsKey(maxReqKeepAlivePropKey)) {
            this.maxReqKeepAlive = (Integer)((Hashtable)properties).get(maxReqKeepAlivePropKey);
        }
        if (((Hashtable)properties).containsKey(keepAliveTimeoutPropKey)) {
            this.keepAliveTimeout = (Integer)((Hashtable)properties).get(keepAliveTimeoutPropKey);
        }
        if (((Hashtable)properties).containsKey(socketTimeoutPropKey)) {
            this.socketTimeout = (Integer)((Hashtable)properties).get(socketTimeoutPropKey);
        }
        if (((Hashtable)properties).containsKey(hostPropKey)) {
            this.host = (String)((Hashtable)properties).get(hostPropKey);
        }
        if (((Hashtable)properties).containsKey(portPropKey)) {
            this.port = (Integer)((Hashtable)properties).get(portPropKey);
        }
        if (((Hashtable)properties).containsKey(backlogConnectionsPropKey)) {
            this.backlogConnections = (Integer)((Hashtable)properties).get(backlogConnectionsPropKey);
        }
        if (((Hashtable)properties).containsKey(httpPropertiesPropKey)) {
            this.httpProperties = (Properties)((Hashtable)properties).get(httpPropertiesPropKey);
        }
        if (((Hashtable)properties).containsKey(sSLEnabledPropKey)) {
            this.sSLEnabled = (Boolean)((Hashtable)properties).get(sSLEnabledPropKey);
        }
        if (((Hashtable)properties).containsKey(sSLPropKey)) {
            this.sSL = (SecureSocketLayerConfig)((Hashtable)properties).get(sSLPropKey);
        }
    }

    public String toString() {
        return ((Hashtable)this.toProperties()).toString();
    }
}

