/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.j2c.ConnectionFactoryRefBuilder;
import com.ibm.ejs.j2c.ConnectorProperties;
import com.ibm.ejs.j2c.ConnectorProperty;
import com.ibm.ejs.models.base.resources.impl.J2CResourceAdapterImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.J2CConfigProperty;
import com.ibm.ejs.sm.beans.J2CConnectionFactory;
import com.ibm.ejs.sm.beans.J2CConnectionFactoryAttributes;
import com.ibm.ejs.sm.beans.J2CConnectionFactoryConfig;
import com.ibm.ejs.sm.beans.J2CResourceAdapter;
import com.ibm.ejs.sm.beans.J2CResourceAdapterAttributes;
import com.ibm.ejs.sm.beans.J2CResourceAdapterBean;
import com.ibm.ejs.sm.beans.J2CResourceAdapterConfig;
import com.ibm.ejs.sm.beans.J2EEResourceConfig;
import com.ibm.ejs.sm.beans.J2EEResourcePropertyConfig;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.Relation;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.RepositoryObjectName;
import com.ibm.ejs.sm.beans.ResourceBean;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.InvalidJ2CConnectionFactoryNameException;
import com.ibm.ejs.sm.exception.InvalidJ2CResourceAdapterException;
import com.ibm.ejs.sm.exception.InvalidNameChangeException;
import com.ibm.ejs.sm.exception.InvalidResourceNameException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.RelationOpException;
import com.ibm.ejs.sm.exception.RemoteOpException;
import com.ibm.ejs.sm.exception.RequiredAttributeMissingException;
import com.ibm.ejs.sm.util.ObjectCollection;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.Referenceable;

public class J2CConnectionFactoryBean
extends ResourceBean
implements EntityBean {
    protected static NLS nls = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$J2CConnectionFactoryBean == null ? (class$com$ibm$ejs$sm$beans$J2CConnectionFactoryBean = J2CConnectionFactoryBean.class$("com.ibm.ejs.sm.beans.J2CConnectionFactoryBean")) : class$com$ibm$ejs$sm$beans$J2CConnectionFactoryBean));
    private static Integer classLock = new Integer(0);
    private static final String tableName = DBMgr.qualifiedTableName((String)"J2CCONFACT_TABLE");
    private static final String nameColumnName = "NAME";
    private static final int nameColumnIndex = 3;
    private static final String descriptionColumnName = "DESCRIPTION";
    private static final int descriptionColumnIndex = 4;
    private static final String connectionTimeoutColumnName = "CONNTIMEOUT";
    private static final int connectionTimeoutColumnIndex = 5;
    private static final String maxConnectionsColumnName = "MAXCONNECTIONS";
    private static final int maxConnectionsColumnIndex = 6;
    private static final String minConnectionsColumnName = "MINCONNECTIONS";
    private static final int minConnectionsColumnIndex = 7;
    private static final String reapTimeColumnName = "REAPTIME";
    private static final int reapTimeColumnIndex = 8;
    private static final String unusedTimeoutColumnName = "UNUSEDTIMEOUT";
    private static final int unusedTimeoutColumnIndex = 9;
    private static final String poolNameColumnName = "POOLNAME";
    private static final int poolNameColumnIndex = 10;
    private static final String subpoolNameColumnName = "SUBPOOLNAME";
    private static final int subpoolNameColumnIndex = 11;
    private static final String jndiNameColumnName = "JNDINAME";
    private static final int jndiNameColumnIndex = 12;
    private static final int numColumns = 12;
    protected static final String myInterfaceName = RepositoryObjectImpl.qualifyClassName("J2CConnectionFactory");
    private static final String myClassName = RepositoryObjectImpl.qualifyClassName("J2CConnectionFactoryBean");
    private static boolean tableCreated = false;
    private static Type myTypeObj = null;
    private static Long myTypeId = null;
    private static Class myClass;
    private static final String myHomeName = "J2CConnectionFactoryHome";
    private static final String JNDIPREFIX = "eis/";
    private static final String configPropsAttrName;
    private static final int connFactoryBeanKeyBase;
    private static final int loadStmtKey;
    private static final int updateStmtKey;
    private static final int deleteStmtKey;
    private static final int insertStmtKey;
    private static final int restrictedFindAllStmtKey;
    private static final int findAllStmtKey;
    private static final int restrictedFindByNameStmtKey;
    private static final int findByNameStmtKey;
    private static final int findByJNDINameStmtKey;
    private static final int restrictedFindByJNDINameStmtKey;
    private static final String updateStmtSql;
    private static final String deleteStmtSql;
    private static final String restrictedFindByNameStmtSql;
    private static final String findByNameStmtSql;
    private static final String insertStmtSql;
    private static final String restrictedFindByJNDINameStmtSql;
    private static final String findByJNDINameStmtSql;
    private String name;
    private String jndiName;
    private String prevJndiName;
    private String description;
    private String poolName;
    private String subpoolName;
    private long connectionTimeout;
    private int maxConnections;
    private int minConnections;
    private long reapTime;
    private long unusedTimeout;
    private Properties configProperties;
    private boolean duringCreate;
    private Referenceable bindingObject;
    private boolean dirty;
    private J2CResourceAdapter resourceAdapter;
    private static Relation adapterConnectionFactoryRel;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$J2CConnectionFactoryBean;

    public J2CConnectionFactoryBean() throws RemoteException {
        J2CConnectionFactoryBean.initializeNLS("RepositoryStrings");
        J2CConnectionFactoryBean.initializePersistentStore();
        J2CConnectionFactoryBean.initializeTypeId();
    }

    public Long ejbCreate(J2CConnectionFactoryAttributes j2CConnectionFactoryAttributes, J2CResourceAdapter j2CResourceAdapter) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        try {
            j2CResourceAdapter.getFullName();
            this.resourceAdapter = j2CResourceAdapter;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)" < ejbCreate -- invalid J2C resource adapter", (Object)exception);
            throw new InvalidJ2CResourceAdapterException(nls.getString("dsb.jdbc.exception", "Invalid J2C resource adapter specified."));
        }
        try {
            this.name = j2CConnectionFactoryAttributes.getName();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)" < ejbCreate -- required attribute missing", (Object)((Object)attributeNotSetException));
            throw new RequiredAttributeMissingException(attributeNotSetException.getMessage());
        }
        try {
            this.validateStringAttr(this.name);
        }
        catch (Exception exception) {
            throw new RequiredAttributeMissingException("Name");
        }
        try {
            this.validateName(this.name);
            if (this.typeId == null) {
                this.typeId = myTypeId;
            }
            this.id = this.create(this.typeId);
            this.addParentRel(this.name, this.resourceAdapter);
            this.initializeInstanceVariables();
            try {
                this.updateInstanceVariables(j2CConnectionFactoryAttributes, true);
                this.checkAdapterProperties();
            }
            catch (InvalidNameChangeException invalidNameChangeException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate: -- invalid connection factory name", (Object)((Object)invalidNameChangeException));
                throw new InvalidJ2CConnectionFactoryNameException();
            }
            catch (OpException opException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate -- unexpected exception when updating instance variables");
                throw new RemoteException(nls.getString("j2c.instance.operation1.exception", "Could not update the instance variables."), opException);
            }
            Vector<Object> vector = new Vector<Object>(12);
            vector.addElement(Utils.getIdString((Long)this.id));
            vector.addElement(Utils.getIdString((Long)this.typeId));
            vector.addElement(this.name);
            vector.addElement(this.description);
            vector.addElement(Long.toString(this.connectionTimeout));
            vector.addElement(new Integer(this.maxConnections));
            vector.addElement(new Integer(this.minConnections));
            vector.addElement(Long.toString(this.reapTime));
            vector.addElement(Long.toString(this.unusedTimeout));
            vector.addElement(this.poolName);
            vector.addElement(this.subpoolName);
            vector.addElement(this.jndiName);
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("j2c.db.insert0.exception", new Object[]{sQLException.getMessage(), this.id, this.typeId}, "J2CConnectionFactoryBean insert failed due to {0} for statement with id = {1} typeId = {2}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbCreate - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)this.id);
        return this.id;
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException, FinderException {
        Enumeration enumeration;
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll");
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)false, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("j2c.db.select2.exception", new Object[]{sQLException.getMessage(), tableName}, "J2CConnectionFactoryBean findAll failed due to {0} on table {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbFindAll - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)((ObjectCollection)enumeration).getArray());
        return enumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByJNDIName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByJNDIName", (Object)string);
        DBQueryResult dBQueryResult = null;
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByJNDINameStmtKey, (String)findByJNDINameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByJNDINameStmtKey, (String)restrictedFindByJNDINameStmtSql, vector);
                }
                Tr.exit((TraceComponent)tc, (String)"ejbFindByJNDIName");
                l = this.singleFinderEpilogue(dBQueryResult);
                Object var7_8 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("dsb.db.select4.exception", new Object[]{sQLException.getMessage(), string}, "DataSourceBean findByJNDIName failed due to {0} for name {1}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByJNDIName - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    protected Long findByName(String string) throws RemoteException, FinderException {
        return this.ejbFindByName(string, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        DBQueryResult dBQueryResult = null;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByName", (Object)string);
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByNameStmtKey, (String)findByNameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByNameStmtKey, (String)restrictedFindByNameStmtSql, vector);
                }
                Long l2 = this.singleFinderEpilogue(dBQueryResult);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName");
                l = l2;
                Object var8_9 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("j2c.db.select4.exception", new Object[]{sQLException.getMessage(), string}, "J2CConnectionFactoryBean findByName failed due to {0} for name {1}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    public void ejbLoad() throws RemoteException {
        DBQueryResult dBQueryResult = null;
        Long l = (Long)this.ec.getPrimaryKey();
        Tr.entry((TraceComponent)tc, (String)"ejbLoad", (Object)l);
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (resultSet == null || !resultSet.next()) {
                    RemoteException remoteException = new RemoteException(nls.getFormattedMessage("j2c.db.select0.exception", new Object[]{l, tableName}, "J2CConnectionFactoryBean select failed to find datasource instance {0} in table {1}."), new ObjectNotFoundException());
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad - with no resultSet exception", (Object)remoteException);
                    throw remoteException;
                }
                if (this.setId(resultSet, myTypeId)) {
                    super.ejbLoad();
                    this.name = resultSet.getString(3);
                    this.description = resultSet.getString(4);
                    if (this.description == null) {
                        this.description = new String();
                    }
                    this.connectionTimeout = Long.parseLong(resultSet.getString(5));
                    this.maxConnections = resultSet.getInt(6);
                    this.minConnections = resultSet.getInt(7);
                    this.reapTime = Long.parseLong(resultSet.getString(8));
                    this.unusedTimeout = Long.parseLong(resultSet.getString(9));
                    this.poolName = resultSet.getString(10);
                    if (this.poolName == null) {
                        this.poolName = new String();
                    }
                    this.subpoolName = resultSet.getString(11);
                    if (this.subpoolName == null) {
                        this.subpoolName = new String();
                    }
                    this.jndiName = resultSet.getString(12);
                    if (this.jndiName == null) {
                        this.jndiName = new String();
                    }
                    this.prevJndiName = null;
                    this.getBinaryAttributes();
                    this.duringCreate = false;
                }
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("j2c.db.select1.exception", new Object[]{sQLException.getMessage()}, "J2CConnectionFactoryBean select failed due to {0}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbLoad - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        try {
            this.resourceAdapter = (J2CResourceAdapter)this.getContainingObject();
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException("J2C ConnectionFactory update failed due to {0}.", exception);
            Tr.exit((TraceComponent)tc, (String)"ejbLoad - with Exception", (Object)remoteException);
            throw remoteException;
        }
    }

    public void ejbPostCreate(J2CConnectionFactoryAttributes j2CConnectionFactoryAttributes, J2CResourceAdapter j2CResourceAdapter) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbPostCreate");
        try {
            if (!this.ec.getRollbackOnly()) {
                this.insertIntoNameSpace(this.getJNDIName(), (Referenceable)this.getBindingObject());
            }
        }
        catch (Exception exception) {
            this.ec.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"ejbPostCreate:", (Object)exception);
            throw new RemoteException(nls.getString("j2c.instance.operation1.exception", "An operation exception occurred. "), exception);
        }
        Tr.exit((TraceComponent)tc, (String)"ejbPostCreate");
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        if (this.id == null) {
            this.ejbLoad();
        }
        if (this.narrowRef != null) {
            this.narrowRef.remove();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove");
            return;
        }
        super.ejbRemove();
        Long l = (Long)this.ec.getPrimaryKey();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)l));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
            this.deleteFromNameSpace(this.getJNDIName());
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("j2c.db.delete0.exception", new Object[]{sQLException.getMessage(), l}, "J2CConnectionFactoryBean delete failed due to {0} for primary key {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbRemove - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        catch (RemoteException remoteException) {
            this.ec.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove - with RemoteException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        if (this.narrowRef != null) {
            Tr.exit((TraceComponent)tc, (String)"ejbStore");
            return;
        }
        super.ejbStore();
        if (this.dirty) {
            try {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("dirty: " + new Boolean(this.dirty)));
                }
                Vector<Object> vector = new Vector<Object>(12);
                vector.addElement(this.name);
                vector.addElement(this.description);
                vector.addElement(Long.toString(this.connectionTimeout));
                vector.addElement(new Integer(this.maxConnections));
                vector.addElement(new Integer(this.minConnections));
                vector.addElement(Long.toString(this.reapTime));
                vector.addElement(Long.toString(this.unusedTimeout));
                vector.addElement(this.poolName);
                vector.addElement(this.subpoolName);
                vector.addElement(this.jndiName);
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("j2c.db.update0.exception", new Object[]{sQLException.getMessage(), this.name, this.id}, "J2CConnectionFactoryBean update failed due to {0} for statement with name = {1} id = {2}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbStore - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
            if (!this.duringCreate) {
                if (this.prevJndiName != null && !this.prevJndiName.equals("")) {
                    Tr.debug((TraceComponent)tc, (String)("Need to rename in namespace: prevJndiName is " + this.prevJndiName + "jndiName is " + this.getJNDIName()));
                    try {
                        this.renameInNameSpace(this.prevJndiName, this.getJNDIName(), this.bindingObject);
                        this.prevJndiName = null;
                    }
                    catch (Exception exception) {
                        this.ec.setRollbackOnly();
                        RemoteException remoteException = new RemoteException("", exception);
                        Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                        throw remoteException;
                    }
                }
                Tr.debug((TraceComponent)tc, (String)"Need to update binding");
                try {
                    this.updateInNameSpace(this.getJNDIName(), this.bindingObject);
                }
                catch (Exception exception) {
                    this.ec.setRollbackOnly();
                    RemoteException remoteException = new RemoteException("", exception);
                    Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                    throw remoteException;
                }
            }
            Tr.exit((TraceComponent)tc, (String)"ejbStore");
        }
    }

    private J2CResourceAdapter getAdapter() throws RemoteException {
        try {
            Relation relation = J2CConnectionFactoryBean.lookupAdapterJ2CConnectionFactoryRel();
            J2CResourceAdapter j2CResourceAdapter = (J2CResourceAdapter)relation.traverse(this.ec.getEJBObject(), true);
            return j2CResourceAdapter;
        }
        catch (Exception exception) {
            throw new RemoteException(nls.getString("j2c.adapter.lookup.exception", "Could not get J2C resource adapter."), exception);
        }
    }

    public Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        Attributes attributes2 = null;
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        if (this.narrowRef != null) {
            attributes2 = ((J2CConnectionFactory)this.narrowRef).getAttributes(attributes);
        } else {
            this.setVersion(attributes);
            attributes2 = this.readInstanceVariables(attributes);
        }
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return attributes2;
    }

    private void getBinaryAttributes() throws RemoteException {
        this.configProperties = (Properties)this.getBinaryAttr(configPropsAttrName);
    }

    private Object getBindingObject() throws RemoteException, OpException {
        Object object;
        Serializable serializable;
        J2CResourceAdapterImpl j2CResourceAdapterImpl;
        Tr.entry((TraceComponent)tc, (String)"getBindingObject");
        J2CResourceAdapterAttributes j2CResourceAdapterAttributes = new J2CResourceAdapterAttributes();
        j2CResourceAdapterAttributes.requestAll();
        j2CResourceAdapterAttributes = (J2CResourceAdapterAttributes)this.resourceAdapter.getAttributes(j2CResourceAdapterAttributes);
        Properties properties = new Properties();
        Properties properties2 = null;
        Enumeration<?> enumeration = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            properties2 = j2CResourceAdapterAttributes.getAdapterProperties();
            string3 = j2CResourceAdapterAttributes.getName();
            string4 = j2CResourceAdapterAttributes.getDescription();
            if (properties2 != null) {
                enumeration = properties2.propertyNames();
            } else {
                Tr.event((TraceComponent)tc, (String)"no RA properties!!.");
            }
            if (string3 == null) {
                Tr.event((TraceComponent)tc, (String)"no RA name!!.");
            }
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.event((TraceComponent)tc, (String)("caught AttributeNotSetException: " + (Object)((Object)attributeNotSetException)));
            Tr.event((TraceComponent)tc, (String)"swallowing");
        }
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = properties2.getProperty(string);
            if (string.equals("transactionSupport")) {
                try {
                    j2CResourceAdapterImpl = new J2CResourceAdapterImpl();
                    j2CResourceAdapterImpl.setTransactionSupport(string2.toUpperCase());
                    serializable = j2CResourceAdapterImpl.getTransactionSupport();
                    string2 = ((Integer)serializable).toString();
                }
                catch (Exception exception) {
                    Tr.event((TraceComponent)tc, (String)("caught exception: " + exception));
                }
            }
            Tr.event((TraceComponent)tc, (String)("adding name " + string + " and value " + string2 + " to properties"));
            properties.setProperty(string, string2);
        }
        properties.setProperty("name", this.name);
        properties.setProperty("description", this.description);
        properties.setProperty("maxConnections", String.valueOf(this.maxConnections));
        properties.setProperty("minConnections", String.valueOf(this.minConnections));
        properties.setProperty("connectionTimeout", String.valueOf(this.connectionTimeout));
        properties.setProperty("reapTime", String.valueOf(this.reapTime));
        properties.setProperty("unusedTimeout", String.valueOf(this.unusedTimeout));
        properties.setProperty("poolName", this.poolName);
        properties.setProperty("subpoolName", this.subpoolName);
        j2CResourceAdapterImpl = new ConnectorProperties();
        serializable = null;
        ConnectorProperty connectorProperty = null;
        Enumeration enumeration2 = ((Hashtable)this.configProperties).keys();
        if (enumeration2 == null) {
            // empty if block
        }
        while (enumeration2.hasMoreElements()) {
            string = (String)enumeration2.nextElement();
            Tr.event((TraceComponent)tc, (String)("propName is : " + string));
            object = ((Hashtable)this.configProperties).get(string);
            if (object instanceof J2CConfigProperty) {
                Tr.event((TraceComponent)tc, (String)"propName is J2CConfigProperty");
                serializable = (J2CConfigProperty)object;
            } else {
                Tr.event((TraceComponent)tc, (String)("propName has value: " + object));
                serializable = new J2CConfigProperty();
                ((J2CConfigProperty)serializable).setValue((String)object);
                ((J2CConfigProperty)serializable).setName(string);
            }
            connectorProperty = new ConnectorProperty(((J2CConfigProperty)serializable).getName(), ((J2CConfigProperty)serializable).getType(), ((J2CConfigProperty)serializable).getValue());
            j2CResourceAdapterImpl.add(connectorProperty);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"About to create Referenceable: properties: ", (Object)new Object[]{((Hashtable)properties).toString(), j2CResourceAdapterImpl.toString()});
        }
        object = new ConnectionFactoryRefBuilder();
        Referenceable referenceable = object.createConnectorReferenceableObject(properties, (ConnectorProperties)j2CResourceAdapterImpl);
        Tr.exit((TraceComponent)tc, (String)"getBindingObject");
        return referenceable;
    }

    public RepositoryObjectName getFullName() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getFullName");
        RepositoryObjectName repositoryObjectName = this.constructFullName(myHomeName, this.name);
        Tr.exit((TraceComponent)tc, (String)"getFullName");
        return repositoryObjectName;
    }

    public String getJNDIName() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"getJNDIName");
        if (this.jndiName.trim().equals("")) {
            this.jndiName = this.name.startsWith(JNDIPREFIX) ? this.name : JNDIPREFIX + this.name;
        }
        Tr.exit((TraceComponent)tc, (String)"getJNDIName");
        return this.jndiName;
    }

    public J2EEResourceConfig getResourceConfig(Node node) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getResourceConfig");
        J2EEResourceConfig j2EEResourceConfig = this.getResourceConfig();
        J2CResourceAdapter j2CResourceAdapter = this.getAdapter();
        J2CResourceAdapterConfig j2CResourceAdapterConfig = (J2CResourceAdapterConfig)j2EEResourceConfig.getProvider();
        j2CResourceAdapterConfig.setClasspath(j2CResourceAdapter.getRarfile(node));
        Tr.exit((TraceComponent)tc, (String)"getResourceConfig");
        return j2EEResourceConfig;
    }

    public J2EEResourceConfig getResourceConfig() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getResourceConfig");
        J2CResourceAdapter j2CResourceAdapter = this.getAdapter();
        Long l = (Long)j2CResourceAdapter.getPrimaryKey();
        J2CResourceAdapterAttributes j2CResourceAdapterAttributes = new J2CResourceAdapterAttributes();
        j2CResourceAdapterAttributes.requestAll();
        j2CResourceAdapterAttributes = (J2CResourceAdapterAttributes)j2CResourceAdapter.getAttributes(j2CResourceAdapterAttributes);
        Properties properties = null;
        String string = null;
        String string2 = null;
        Object var7_7 = null;
        try {
            properties = j2CResourceAdapterAttributes.getAdapterProperties();
            string = j2CResourceAdapterAttributes.getName();
            string2 = j2CResourceAdapterAttributes.getDescription();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            throw new RemoteOpException(nls.getString("j2c.instance.operation3.exception", "getResourceConfig: AttributeNotSetException."), (Throwable)attributeNotSetException);
        }
        J2CConnectionFactoryConfig j2CConnectionFactoryConfig = new J2CConnectionFactoryConfig();
        J2CResourceAdapterConfig j2CResourceAdapterConfig = new J2CResourceAdapterConfig();
        j2CConnectionFactoryConfig.setProvider(j2CResourceAdapterConfig);
        Properties properties2 = new Properties();
        j2CConnectionFactoryConfig.setJNDIName(this.getJNDIName());
        j2CConnectionFactoryConfig.setName(this.name);
        j2CConnectionFactoryConfig.setDescription(this.description);
        j2CConnectionFactoryConfig.setJtaEnabled(false);
        j2CConnectionFactoryConfig.setConnectionTimeout(this.connectionTimeout);
        j2CConnectionFactoryConfig.setMaxConnections(this.maxConnections);
        j2CConnectionFactoryConfig.setMinConnections(this.minConnections);
        j2CConnectionFactoryConfig.setPoolName(this.poolName);
        j2CConnectionFactoryConfig.setSubpoolName(this.subpoolName);
        j2CConnectionFactoryConfig.setReapTime(this.reapTime);
        j2CConnectionFactoryConfig.setUnusedTimeout(this.unusedTimeout);
        Enumeration<?> enumeration = this.configProperties.propertyNames();
        String string3 = null;
        Object var13_14 = null;
        J2CConfigProperty j2CConfigProperty = null;
        J2EEResourcePropertyConfig j2EEResourcePropertyConfig = null;
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("property= " + string3 + " value= " + ((Hashtable)this.configProperties).get(string3)));
            }
            j2CConfigProperty = (J2CConfigProperty)((Hashtable)this.configProperties).get(string3);
            j2EEResourcePropertyConfig = new J2EEResourcePropertyConfig();
            j2EEResourcePropertyConfig.setName(string3);
            j2EEResourcePropertyConfig.setValue(j2CConfigProperty.getValue());
            j2EEResourcePropertyConfig.setType(j2CConfigProperty.getType());
            j2EEResourcePropertyConfig.setDescription(j2CConfigProperty.getDescription());
            ((Hashtable)properties2).put(string3, j2EEResourcePropertyConfig);
        }
        j2CConnectionFactoryConfig.setPropertySet(properties2);
        j2CResourceAdapterConfig.setDescription(string2);
        j2CResourceAdapterConfig.setName(string);
        j2CResourceAdapterConfig.setProviderId(l);
        j2CResourceAdapterConfig.setArchivePath(properties.getProperty(J2CResourceAdapterAttributes.ADAPTER_archivePath_PROPNAME));
        j2CResourceAdapterConfig.setConnectionFactoryImplClass(properties.getProperty("connectionFactoryImplClass"));
        j2CResourceAdapterConfig.setConnectionFactoryInterface(properties.getProperty("connectionFactoryInterface"));
        j2CResourceAdapterConfig.setConnectionImplClass(properties.getProperty("connectionImplClass"));
        j2CResourceAdapterConfig.setConnectionInterface(properties.getProperty("connectionInterface"));
        j2CResourceAdapterConfig.setDisplayName(properties.getProperty("displayName"));
        j2CResourceAdapterConfig.setEisType(properties.getProperty("eisType"));
        j2CResourceAdapterConfig.setLargeIcon(properties.getProperty(J2CResourceAdapterAttributes.ADAPTER_largeIcon_PROPNAME));
        j2CResourceAdapterConfig.setLicenseDescription(properties.getProperty(J2CResourceAdapterAttributes.ADAPTER_licenseDescription_PROPNAME));
        j2CResourceAdapterConfig.setLicenseRequired(new Boolean(properties.getProperty(J2CResourceAdapterAttributes.ADAPTER_licenseRequired_PROPNAME)));
        j2CResourceAdapterConfig.setManagedConnectionFactoryClass(properties.getProperty("managedConnectionFactoryClass"));
        j2CResourceAdapterConfig.setReauthenticationSupport(new Boolean(properties.getProperty("reauthenticationSupport")));
        j2CResourceAdapterConfig.setSmallIcon(properties.getProperty(J2CResourceAdapterAttributes.ADAPTER_smallIcon_PROPNAME));
        j2CResourceAdapterConfig.setSpecVersion(properties.getProperty("specVersion"));
        String string4 = properties.getProperty("transactionSupport");
        Integer n = null;
        try {
            J2CResourceAdapterImpl j2CResourceAdapterImpl = new J2CResourceAdapterImpl();
            j2CResourceAdapterImpl.setTransactionSupport(string4.toUpperCase());
            n = j2CResourceAdapterImpl.getTransactionSupport();
        }
        catch (Exception exception) {
            Tr.event((TraceComponent)tc, (String)("caught exception: " + exception));
        }
        j2CResourceAdapterConfig.setTransactionSupport(n);
        j2CResourceAdapterConfig.setVendorName(properties.getProperty("vendorName"));
        j2CResourceAdapterConfig.setVersion(properties.getProperty("version"));
        Tr.exit((TraceComponent)tc, (String)"getResourceConfig");
        return j2CConnectionFactoryConfig;
    }

    private void initializeInstanceVariables() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeInstanceVariables");
        J2CConnectionFactoryAttributes j2CConnectionFactoryAttributes = (J2CConnectionFactoryAttributes)RepositoryObjectImpl.getDefaults(myTypeObj);
        try {
            this.minConnections = j2CConnectionFactoryAttributes.getMinConnections();
            this.maxConnections = j2CConnectionFactoryAttributes.getMaxConnections();
            this.connectionTimeout = j2CConnectionFactoryAttributes.getConnectionTimeout();
            this.unusedTimeout = j2CConnectionFactoryAttributes.getUnusedTimeout();
            this.reapTime = j2CConnectionFactoryAttributes.getReapTime();
            this.poolName = j2CConnectionFactoryAttributes.getPoolName();
            this.subpoolName = j2CConnectionFactoryAttributes.getSubpoolName();
            this.description = new String();
            this.configProperties = new Properties();
            this.jndiName = new String();
            this.prevJndiName = new String();
            this.duringCreate = true;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"intializedInstanceVariables", (Object)exception);
            throw new RemoteException(nls.getString("j2c.instance.operation2.exception", "Could not initialize the instance variables."), exception);
        }
        Tr.exit((TraceComponent)tc, (String)"intializedInstanceVariables");
    }

    protected static void initializeNLS(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeNLS");
        }
        if (nls == null) {
            nls = new NLS(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeNLS");
        }
    }

    private static void initializePersistentStore() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (tableCreated) {
                return;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + nameColumnName + DBMgr.mediumStringColumnSpec + " , " + descriptionColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + connectionTimeoutColumnName + DBMgr.idColumnSpec + " , " + maxConnectionsColumnName + " integer " + " , " + minConnectionsColumnName + " integer " + " , " + reapTimeColumnName + DBMgr.idColumnSpec + " , " + unusedTimeoutColumnName + DBMgr.idColumnSpec + " , " + poolNameColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + subpoolNameColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + jndiNameColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Integer n2 = classLock;
            synchronized (n2) {
                tableCreated = true;
            }
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("j2c.db.create0.exception", new Object[]{tableName, sQLException.getMessage()}, "J2CConnectionFactoryBean could not create table {0} because of {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"initializePersistentStore - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
    }

    private static void initializeTypeId() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        Integer n = classLock;
        synchronized (n) {
            if (myTypeId != null) {
                return;
            }
        }
        J2CConnectionFactoryAttributes j2CConnectionFactoryAttributes = new J2CConnectionFactoryAttributes();
        j2CConnectionFactoryAttributes.setConnectionTimeout(0L);
        j2CConnectionFactoryAttributes.setMaxConnections(0);
        j2CConnectionFactoryAttributes.setMinConnections(0);
        j2CConnectionFactoryAttributes.setPoolName(poolNameColumnName);
        j2CConnectionFactoryAttributes.setReapTime(0L);
        j2CConnectionFactoryAttributes.setUnusedTimeout(0L);
        j2CConnectionFactoryAttributes.setSubpoolName(subpoolNameColumnName);
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, j2CConnectionFactoryAttributes, false);
        Long l = (Long)type.getPrimaryKey();
        Integer n2 = classLock;
        synchronized (n2) {
            myTypeObj = type;
            myTypeId = l;
        }
        Tr.exit((TraceComponent)tc, (String)"intializeTypeId");
    }

    public void notifyAdapterChanges(J2CResourceAdapter j2CResourceAdapter) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"notifyAdapterChanges");
        this.updateInNameSpace(this.getJNDIName(), (Referenceable)this.getBindingObject());
        Tr.exit((TraceComponent)tc, (String)"notifyAdapterChanges");
    }

    private J2CConnectionFactoryAttributes readInstanceVariables(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"readInstanceVariables");
        J2CConnectionFactoryAttributes j2CConnectionFactoryAttributes = (J2CConnectionFactoryAttributes)attributes;
        j2CConnectionFactoryAttributes.setName(this.name);
        j2CConnectionFactoryAttributes.setFullName(this.getFullName());
        j2CConnectionFactoryAttributes.setDescription(this.description);
        j2CConnectionFactoryAttributes.setConnectionTimeout(this.connectionTimeout);
        j2CConnectionFactoryAttributes.setMaxConnections(this.maxConnections);
        j2CConnectionFactoryAttributes.setMinConnections(this.minConnections);
        j2CConnectionFactoryAttributes.setReapTime(this.reapTime);
        j2CConnectionFactoryAttributes.setUnusedTimeout(this.unusedTimeout);
        j2CConnectionFactoryAttributes.setPoolName(this.poolName);
        j2CConnectionFactoryAttributes.setSubpoolName(this.subpoolName);
        j2CConnectionFactoryAttributes.setJNDIName(this.jndiName);
        j2CConnectionFactoryAttributes.setConfigProperties(this.configProperties);
        try {
            J2CResourceAdapter j2CResourceAdapter = (J2CResourceAdapter)this.getContainingObject();
            j2CConnectionFactoryAttributes.setProvider(j2CResourceAdapter);
            J2CResourceAdapterAttributes j2CResourceAdapterAttributes = new J2CResourceAdapterAttributes();
            j2CResourceAdapterAttributes.request(Attributes.name);
            j2CConnectionFactoryAttributes.setParentName(j2CResourceAdapter.getAttributes(j2CResourceAdapterAttributes).getName());
        }
        catch (Exception exception) {
            throw new RemoteOpException(nls.getString("provider.j2ccfb.exception", "Fail to request J2CResourceAdapter name"));
        }
        Tr.exit((TraceComponent)tc, (String)"readInstanceVariables");
        return j2CConnectionFactoryAttributes;
    }

    private void checkAdapterProperties() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"checkAdapterProperties");
        if (this.configProperties == null || ((Hashtable)this.configProperties).size() == 0) {
            Tr.event((TraceComponent)tc, (String)"Reading the default config properties from resource adapter");
            J2CResourceAdapterAttributes j2CResourceAdapterAttributes = new J2CResourceAdapterAttributes();
            Hashtable hashtable = null;
            try {
                j2CResourceAdapterAttributes.request("ConfigProperties");
                j2CResourceAdapterAttributes = (J2CResourceAdapterAttributes)this.resourceAdapter.getAttributes(j2CResourceAdapterAttributes);
                hashtable = j2CResourceAdapterAttributes.getConfigProperties();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Enumeration enumeration = hashtable.keys();
            String string = null;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                J2CConfigProperty j2CConfigProperty = (J2CConfigProperty)hashtable.get(string);
                ((Hashtable)this.configProperties).put(string, j2CConfigProperty);
            }
            this.setBinaryAttr(configPropsAttrName, this.configProperties);
        } else {
            Tr.event((TraceComponent)tc, (String)"Use config Properties set in the connection factory");
        }
        Tr.exit((TraceComponent)tc, (String)"checkAdapterProperties");
    }

    public void setAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setAttributes");
        if (this.narrowRef != null) {
            ((J2CConnectionFactory)this.narrowRef).setAttributes(attributes);
        } else {
            try {
                if (attributes.isSet(Attributes.name)) {
                    String string = ((J2CConnectionFactoryAttributes)attributes).getName();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(nls.getFormattedMessage("invalid.attribute.name", new Object[]{"Name"}, "Invalid value for attribute: {0}"));
            }
            this.checkAndIncrVersion(attributes);
            this.renameIfNec(attributes, J2CConnectionFactoryBean.lookupAdapterJ2CConnectionFactoryRel(), true);
            this.updateInstanceVariables((J2CConnectionFactoryAttributes)attributes, false);
        }
        Tr.exit((TraceComponent)tc, (String)"setAttributes");
    }

    private void updateInstanceVariables(J2CConnectionFactoryAttributes j2CConnectionFactoryAttributes, boolean bl) throws RemoteException, OpException {
        Object var3_3 = null;
        Tr.entry((TraceComponent)tc, (String)"updateInstanceVariables");
        this.dirty = true;
        try {
            Object object;
            if (j2CConnectionFactoryAttributes.isSet(Attributes.name)) {
                this.name = j2CConnectionFactoryAttributes.getName();
            }
            if (j2CConnectionFactoryAttributes.isSet(J2CConnectionFactoryAttributes.description)) {
                this.description = j2CConnectionFactoryAttributes.getDescription();
            }
            if (j2CConnectionFactoryAttributes.isSet(J2CConnectionFactoryAttributes.connectionTimeout)) {
                this.connectionTimeout = j2CConnectionFactoryAttributes.getConnectionTimeout();
            }
            if (j2CConnectionFactoryAttributes.isSet(J2CConnectionFactoryAttributes.maxConnections)) {
                this.maxConnections = j2CConnectionFactoryAttributes.getMaxConnections();
            }
            if (j2CConnectionFactoryAttributes.isSet(J2CConnectionFactoryAttributes.minConnections)) {
                this.minConnections = j2CConnectionFactoryAttributes.getMinConnections();
            }
            if (j2CConnectionFactoryAttributes.isSet(J2CConnectionFactoryAttributes.reapTime)) {
                this.reapTime = j2CConnectionFactoryAttributes.getReapTime();
            }
            if (j2CConnectionFactoryAttributes.isSet(J2CConnectionFactoryAttributes.unusedTimeout)) {
                this.unusedTimeout = j2CConnectionFactoryAttributes.getUnusedTimeout();
            }
            if (j2CConnectionFactoryAttributes.isSet(J2CConnectionFactoryAttributes.poolName)) {
                this.poolName = j2CConnectionFactoryAttributes.getPoolName();
            }
            if (j2CConnectionFactoryAttributes.isSet(J2CConnectionFactoryAttributes.subpoolName)) {
                this.subpoolName = j2CConnectionFactoryAttributes.getSubpoolName();
            }
            if (j2CConnectionFactoryAttributes.isSet(J2CConnectionFactoryAttributes.jndiName)) {
                object = j2CConnectionFactoryAttributes.getJNDIName();
                if (!((String)(object = ((String)object).trim())).equals("") && !((String)object).equals(this.jndiName)) {
                    this.checkForDuplicateJNDIName((String)object);
                    if (!bl) {
                        this.prevJndiName = this.jndiName;
                        this.updateModuleBindings(this.prevJndiName, (String)object);
                    }
                    this.jndiName = object;
                }
            }
            if (j2CConnectionFactoryAttributes.isSet(J2CConnectionFactoryAttributes.configProperties)) {
                this.configProperties = j2CConnectionFactoryAttributes.getConfigProperties();
                if (tc.isDebugEnabled()) {
                    object = null;
                    Enumeration enumeration = ((Hashtable)this.configProperties).elements();
                    while (enumeration.hasMoreElements()) {
                        object = (J2CConfigProperty)enumeration.nextElement();
                        Tr.debug((TraceComponent)tc, (String)("property= " + ((J2CConfigProperty)object).getName() + " value= " + ((J2CConfigProperty)object).getValue()));
                    }
                }
                this.setBinaryAttr(configPropsAttrName, this.configProperties);
            }
            this.bindingObject = (Referenceable)this.getBindingObject();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeNotSetException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)attributeNotSetException);
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeDoesNotExistException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)attributeDoesNotExistException);
        }
        Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables");
    }

    private void addParentRel(String string, J2CResourceAdapter j2CResourceAdapter) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"addParentRel");
        J2CConnectionFactoryBean.lookupAdapterJ2CConnectionFactoryRel();
        try {
            adapterConnectionFactoryRel.addUsingKeys((Long)j2CResourceAdapter.getPrimaryKey(), this.id, string);
        }
        catch (RelationOpException relationOpException) {
            this.ec.setRollbackOnly();
            InvalidResourceNameException invalidResourceNameException = new InvalidResourceNameException();
            Tr.exit((TraceComponent)tc, (String)"addParentRel", (Object)invalidResourceNameException);
            throw invalidResourceNameException;
        }
        catch (RemoteException remoteException) {
            Tr.exit((TraceComponent)tc, (String)"addParentRel", (Object)remoteException);
            throw remoteException;
        }
    }

    protected static Relation lookupAdapterJ2CConnectionFactoryRel() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (adapterConnectionFactoryRel != null) {
                Relation relation = adapterConnectionFactoryRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.lookupRel(J2CResourceAdapterBean.myInterfaceName, myTypeObj, "resourceAdapterConnectionFactoryRel");
        Integer n2 = classLock;
        synchronized (n2) {
            adapterConnectionFactoryRel = relation;
        }
        return adapterConnectionFactoryRel;
    }

    private void validateStringAttr(String string) throws RemoteException {
        if (string.trim().equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"validateStringAttr failed.");
            }
            throw new RemoteException("validateStringAttr failed.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        configPropsAttrName = myInterfaceName + ".configProps";
        connFactoryBeanKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
        loadStmtKey = connFactoryBeanKeyBase + 1;
        updateStmtKey = connFactoryBeanKeyBase + 2;
        deleteStmtKey = connFactoryBeanKeyBase + 3;
        insertStmtKey = connFactoryBeanKeyBase + 4;
        restrictedFindAllStmtKey = connFactoryBeanKeyBase + 5;
        findAllStmtKey = connFactoryBeanKeyBase + 6;
        restrictedFindByNameStmtKey = connFactoryBeanKeyBase + 7;
        findByNameStmtKey = connFactoryBeanKeyBase + 8;
        findByJNDINameStmtKey = connFactoryBeanKeyBase + 9;
        restrictedFindByJNDINameStmtKey = connFactoryBeanKeyBase + 10;
        updateStmtSql = "update " + tableName + " set " + nameColumnName + " = ? , " + descriptionColumnName + " = ? ," + connectionTimeoutColumnName + " = ? ," + maxConnectionsColumnName + " = ? ," + minConnectionsColumnName + " = ? ," + reapTimeColumnName + " = ? ," + unusedTimeoutColumnName + " = ? ," + poolNameColumnName + " = ? ," + subpoolNameColumnName + " = ? ," + jndiNameColumnName + " = ? " + " where " + "INSTANCE_ID" + " = ?";
        deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " = ?";
        restrictedFindByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " = ? and " + "TYPE_ID" + " = ? ";
        findByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " =  ?";
        insertStmtSql = "insert into " + tableName + " values (?,?,?,?,?,?,?,?,?,?,?,?)";
        restrictedFindByJNDINameStmtSql = "select * from " + tableName + " where " + jndiNameColumnName + " = ? and " + "TYPE_ID" + " = ? ";
        findByJNDINameStmtSql = "select * from " + tableName + " where " + jndiNameColumnName + " =  ?";
    }
}

