/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.agent.AdminAgent;
import com.ibm.ejs.sm.agent.ParamList;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.FileBrowserServiceHome;
import com.ibm.ejs.sm.beans.J2CConnectionFactory;
import com.ibm.ejs.sm.beans.J2CResourceAdapter;
import com.ibm.ejs.sm.beans.J2CResourceAdapterAttributes;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.Relation;
import com.ibm.ejs.sm.beans.RemoteArchiveInfo;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.RepositoryObjectName;
import com.ibm.ejs.sm.beans.RepositoryObjectNameElem;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.InvalidJ2CResourceAdapterNameException;
import com.ibm.ejs.sm.exception.InvalidJDBCDriverJarFileException;
import com.ibm.ejs.sm.exception.InvalidNameChangeException;
import com.ibm.ejs.sm.exception.JDBCDriverAlreadyInstalledException;
import com.ibm.ejs.sm.exception.JDBCDriverNotInstalledException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.RemoteOpException;
import com.ibm.ejs.sm.exception.RequiredAttributeMissingException;
import com.ibm.ejs.sm.exception.ResourceProviderInUseException;
import com.ibm.ejs.sm.server.AdminServer;
import com.ibm.ejs.sm.server.ManagedServer;
import com.ibm.ejs.sm.util.ObjectCollection;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.act.Act;
import com.ibm.ejs.sm.util.act.ActServerImpl;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import com.ibm.ejs.sm.util.task.AsyncTask;
import com.ibm.ejs.util.RarDeploymentInfo;
import com.ibm.ejs.util.deployment.deploywrapper.DeployOptions;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.Context;
import javax.rmi.PortableRemoteObject;

public class J2CResourceAdapterBean
extends RepositoryObjectImpl
implements EntityBean {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$J2CResourceAdapterBean == null ? (class$com$ibm$ejs$sm$beans$J2CResourceAdapterBean = J2CResourceAdapterBean.class$("com.ibm.ejs.sm.beans.J2CResourceAdapterBean")) : class$com$ibm$ejs$sm$beans$J2CResourceAdapterBean));
    private static Integer classLock = new Integer(0);
    private static final String tableName = DBMgr.qualifiedTableName((String)"J2CRA_TABLE");
    private static final String nameColumnName = "NAME";
    private static final int nameColumnIndex = 3;
    private static final String descriptionColumnName = "DESCRIPTION";
    private static final int descriptionColumnIndex = 4;
    private static final String archiveFileColumnName = "ARCHIVEFILE";
    private static final int archiveFileColumnIndex = 5;
    private static final int numColumns = 5;
    protected static final String myInterfaceName = RepositoryObjectImpl.qualifyClassName("J2CResourceAdapter");
    private static final String myClassName = RepositoryObjectImpl.qualifyClassName("J2CResourceAdapterBean");
    private static final String configPropertiesAttrName = myInterfaceName + ".configProperties";
    private static final String adapterPropertiesAttrName = myInterfaceName + ".adapterProperties";
    private static boolean tableCreated = false;
    private static Type myTypeObj = null;
    private static Long myTypeId = null;
    private static final String myHomeName = "J2CResourceAdapterHome";
    private static Relation driverNodeRel;
    private static Relation adapterConnectionFactoryRel;
    protected static final String adapterNodeRelName = "j2cResourceAdapterInstallations";
    protected static final String adapterConnectionFactoryRelName = "resourceAdapterConnectionFactoryRel";
    private static final int resourceAdapterBeanKeyBase;
    private static final int loadStmtKey;
    private static final int updateStmtKey;
    private static final int deleteStmtKey;
    private static final int insertStmtKey;
    private static final int restrictedFindByNameStmtKey;
    private static final int restrictedFindAllStmtKey;
    private static final int findAllStmtKey;
    private static final int findByNameStmtKey;
    private static final String updateStmtSql;
    private static final String deleteStmtSql;
    private static final String findByNameStmtSql;
    private static final String restrictedFindByNameStmtSql;
    private static final String insertStmtSql;
    private String name;
    private String description;
    private String archiveFile;
    private Properties configProperties;
    private Properties adapterProperties;
    private boolean dirty;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$J2CResourceAdapterBean;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$FileBrowserServiceHome;

    public J2CResourceAdapterBean() throws RemoteException {
        J2CResourceAdapterBean.initializeNLS("RepositoryStrings");
        J2CResourceAdapterBean.initializePersistentStore();
        J2CResourceAdapterBean.initializeTypeId();
        J2CResourceAdapterBean.lookupDriverNodeRel();
        J2CResourceAdapterBean.lookupAdapterConnectionFactoryRel();
    }

    private void checkForAdapterUse() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"checkForAdapterUse");
        adapterConnectionFactoryRel = J2CResourceAdapterBean.lookupAdapterConnectionFactoryRel();
        try {
            Enumeration enumeration = this.listRelatedObjects(J2CResourceAdapterBean.lookupAdapterConnectionFactoryRel());
            if (enumeration.hasMoreElements()) {
                throw new ResourceProviderInUseException();
            }
        }
        catch (OpException opException) {
            Tr.exit((TraceComponent)tc, (String)"checkForAdapterUse", (Object)((Object)opException));
            throw new RemoteException(RepositoryObjectImpl.nls.getString("j2c.instance.operation2.exception", "An operation exception occurred. "), opException);
        }
        Tr.exit((TraceComponent)tc, (String)"checkForAdapterUse");
    }

    public Long ejbCreate(J2CResourceAdapterAttributes j2CResourceAdapterAttributes, EJBObject eJBObject) throws RemoteException, CreateException {
        String string;
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        try {
            string = j2CResourceAdapterAttributes.getName();
            this.archiveFile = j2CResourceAdapterAttributes.getArchiveFile();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)" < ejbCreate -- required attribute missing", (Object)((Object)attributeNotSetException));
            throw new RequiredAttributeMissingException(attributeNotSetException.getMessage());
        }
        try {
            this.validateStringAttr(string);
        }
        catch (Exception exception) {
            throw new RequiredAttributeMissingException("Name");
        }
        try {
            this.validateStringAttr(this.archiveFile);
        }
        catch (Exception exception) {
            throw new RequiredAttributeMissingException("ArchiveFile");
        }
        try {
            this.initializeInstanceVariables();
            try {
                if (!j2CResourceAdapterAttributes.isSet(J2CResourceAdapterAttributes.adapterProperties)) {
                    this.processRARFile(j2CResourceAdapterAttributes);
                }
            }
            catch (OpException opException) {
                Tr.exit((TraceComponent)tc, (String)"ejbCreate -- unexpected exception when updating instance variables");
                throw new RemoteException(RepositoryObjectImpl.nls.getString("j2c.instance.operation1.exception", "Could not update the instance variables."), opException);
            }
            catch (AttributeDoesNotExistException attributeDoesNotExistException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate -- adapterProperties does not exist!");
                throw new RemoteException(RepositoryObjectImpl.nls.getString("j2c.instance.operation1.exception", "Could not update the instance variables."), attributeDoesNotExistException);
            }
            if (this.typeId == null) {
                this.typeId = myTypeId;
            }
            this.id = this.create(this.typeId);
            try {
                this.updateInstanceVariables(j2CResourceAdapterAttributes, true);
            }
            catch (InvalidNameChangeException invalidNameChangeException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate -- invalid resource adapter name");
                throw new InvalidJ2CResourceAdapterNameException();
            }
            catch (OpException opException) {
                Tr.exit((TraceComponent)tc, (String)"ejbCreate -- unexpected exception when updating instance variables");
                throw new RemoteException(RepositoryObjectImpl.nls.getString("j2c.instance.operation1.exception", "Could not update the instance variables."), opException);
            }
            Tr.debug((TraceComponent)tc, (String)"insert record in database");
            this.name = string;
            Vector<String> vector = new Vector<String>(5);
            vector.addElement(Utils.getIdString((Long)this.id));
            vector.addElement(Utils.getIdString((Long)this.typeId));
            vector.addElement(this.name);
            vector.addElement(this.description);
            vector.addElement(this.archiveFile);
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(RepositoryObjectImpl.nls.getFormattedMessage("j2c.db.insert0.exception", new Object[]{sQLException.getMessage(), this.id, this.typeId}, "J2CResourceAdapterBean insert failed due to {0} for statement with id = {1} typeId = {2}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbCreate - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)this.id);
        return this.id;
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException, FinderException {
        Enumeration enumeration;
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll");
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)false, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(RepositoryObjectImpl.nls.getFormattedMessage("j2c.db.select2.exception", new Object[]{sQLException.getMessage(), tableName}, "J2CResourceAdapterBean findAll failed due to {0} on table {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbFindAll - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)((ObjectCollection)enumeration).getArray());
        return enumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByName", (Object)string);
        DBQueryResult dBQueryResult = null;
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByNameStmtKey, (String)findByNameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByNameStmtKey, (String)restrictedFindByNameStmtSql, vector);
                }
                Long l2 = this.singleFinderEpilogue(dBQueryResult);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName");
                l = l2;
                Object var8_9 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(RepositoryObjectImpl.nls.getFormattedMessage("j2c.db.select4.exception", new Object[]{sQLException.getMessage(), string}, "J2CResourceAdapterBean findByName failed due to {0} for name {1}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    public void ejbLoad() throws RemoteException {
        DBQueryResult dBQueryResult = null;
        Long l = (Long)this.ec.getPrimaryKey();
        Tr.entry((TraceComponent)tc, (String)"ejbLoad", (Object)l);
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (resultSet == null || !resultSet.next()) {
                    RemoteException remoteException = new RemoteException(RepositoryObjectImpl.nls.getFormattedMessage("j2c.db.select0.exception", new Object[]{l, tableName}, "J2CResourceAdapterBean select failed to find datasource instance {0} in table {1}."), new ObjectNotFoundException());
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad - with no resultSet exception", (Object)remoteException);
                    throw remoteException;
                }
                if (this.setId(resultSet, myTypeId)) {
                    super.ejbLoad();
                    this.name = resultSet.getString(3);
                    this.description = resultSet.getString(4);
                    if (this.description == null) {
                        this.description = new String();
                    }
                    this.archiveFile = resultSet.getString(5);
                    this.getBinaryAttributes();
                }
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(RepositoryObjectImpl.nls.getFormattedMessage("j2c.db.select1.exception", new Object[]{sQLException.getMessage()}, "J2CResourceAdapterBean select failed due to {0}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbLoad - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        Tr.exit((TraceComponent)tc, (String)"ejbLoad");
    }

    public void ejbPostCreate(J2CResourceAdapterAttributes j2CResourceAdapterAttributes, Node node) {
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        if (this.id == null) {
            this.ejbLoad();
        }
        if (this.narrowRef != null) {
            this.narrowRef.remove();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove");
            return;
        }
        this.checkForAdapterUse();
        super.ejbRemove();
        Long l = (Long)this.ec.getPrimaryKey();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)l));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            RemoteException remoteException = new RemoteException(RepositoryObjectImpl.nls.getFormattedMessage("j2c.db.delete0.exception", new Object[]{sQLException.getMessage(), l}, "J2CConnectionFactoryBean delete failed due to {0} for primary key {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbRemove - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        if (this.narrowRef != null) {
            Tr.exit((TraceComponent)tc, (String)"ejbStore");
            return;
        }
        super.ejbStore();
        if (this.dirty) {
            try {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("dirty: " + new Boolean(this.dirty)));
                }
                Vector<String> vector = new Vector<String>(5);
                vector.addElement(this.name);
                vector.addElement(this.description);
                vector.addElement(this.archiveFile);
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(RepositoryObjectImpl.nls.getFormattedMessage("j2c.db.update0.exception", new Object[]{sQLException.getMessage(), this.name, this.id}, "J2CConnectionFactoryBean update failed due to {0} for statement with name = {1} id = {2}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbStore - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
            Tr.exit((TraceComponent)tc, (String)"ejbStore");
        }
    }

    public Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        Attributes attributes2 = null;
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        if (this.narrowRef != null) {
            attributes2 = ((J2CResourceAdapter)this.narrowRef).getAttributes(attributes);
        } else {
            this.setVersion(attributes);
            attributes2 = this.readInstanceVariables(attributes);
        }
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return attributes2;
    }

    private void getBinaryAttributes() throws RemoteException {
        this.configProperties = (Properties)this.getBinaryAttr(configPropertiesAttrName);
        this.adapterProperties = (Properties)this.getBinaryAttr(adapterPropertiesAttrName);
    }

    public RepositoryObjectName getFullName() throws RemoteException, OpException {
        RepositoryObjectName repositoryObjectName = new RepositoryObjectName();
        repositoryObjectName.addElement(new RepositoryObjectNameElem(myHomeName, this.name));
        return repositoryObjectName;
    }

    public String getRarfile(Node node) throws RemoteException, OpException {
        Enumeration enumeration = J2CResourceAdapterBean.lookupDriverNodeRel().listNames(this.ec.getEJBObject(), node);
        if (enumeration.hasMoreElements()) {
            return (String)enumeration.nextElement();
        }
        return null;
    }

    private void initializeInstanceVariables() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeInstanceVariables");
        this.description = new String();
        Tr.exit((TraceComponent)tc, (String)"intializeInstanceVariables");
    }

    protected static void initializeNLS(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeNLS");
        }
        if (RepositoryObjectImpl.nls == null) {
            RepositoryObjectImpl.nls = new NLS(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeNLS");
        }
    }

    private static void initializePersistentStore() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (tableCreated) {
                return;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + nameColumnName + DBMgr.mediumStringColumnSpec + " , " + descriptionColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + archiveFileColumnName + DBMgr.mediumStringColumnSpec + " , " + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Integer n2 = classLock;
            synchronized (n2) {
                tableCreated = true;
            }
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"initializePersistentStore", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
    }

    private static void initializeTypeId() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (myTypeId != null) {
                return;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        J2CResourceAdapterAttributes j2CResourceAdapterAttributes = null;
        j2CResourceAdapterAttributes = new J2CResourceAdapterAttributes();
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, j2CResourceAdapterAttributes, true);
        Long l = (Long)type.getPrimaryKey();
        Integer n2 = classLock;
        synchronized (n2) {
            myTypeId = l;
            myTypeObj = type;
        }
        Tr.exit((TraceComponent)tc, (String)"initializeTypeId");
    }

    public Act install(Node node, String string) throws RemoteException, OpException {
        Object object;
        Tr.entry((TraceComponent)tc, (String)"install");
        Relation relation = J2CResourceAdapterBean.lookupDriverNodeRel();
        if (relation.listNames(this.ec.getEJBObject(), node).hasMoreElements()) {
            throw new JDBCDriverAlreadyInstalledException();
        }
        FileBrowserServiceHome fileBrowserServiceHome = null;
        Context context = RepositoryObjectImpl.getInitialNamingContext();
        try {
            object = ManagedServer.getInstance().qualifyRepositoryHomeName("FileBrowserServiceHome");
            Tr.event((TraceComponent)tc, (String)"looking up : ", (Object)object);
            Object object2 = context.lookup((String)object);
            fileBrowserServiceHome = (FileBrowserServiceHome)PortableRemoteObject.narrow((Object)object2, (Class)(class$com$ibm$ejs$sm$beans$FileBrowserServiceHome == null ? (class$com$ibm$ejs$sm$beans$FileBrowserServiceHome = J2CResourceAdapterBean.class$("com.ibm.ejs.sm.beans.FileBrowserServiceHome")) : class$com$ibm$ejs$sm$beans$FileBrowserServiceHome));
        }
        catch (Exception exception) {
            throw new RemoteOpException("Could not get FileBrowserServiceHome");
        }
        object = null;
        try {
            object = fileBrowserServiceHome.create(node);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteOpException("Failed to create FileBrowserService remote obj or call methods on it");
        }
        RemoteArchiveInfo remoteArchiveInfo = null;
        DeployOptions deployOptions = new DeployOptions();
        try {
            remoteArchiveInfo = object.deployRarIfNec(string, deployOptions);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteOpException("Failed to deploy J2C resource adapter archive file:" + string);
        }
        String string2 = remoteArchiveInfo.getAbsolutePath();
        this.addToNamedRelation(relation, node, string2);
        Tr.exit((TraceComponent)tc, (String)"install");
        return ActServerImpl.getInstance().scheduleWork(new AsyncTask(){

            public String getName() {
                return "dummyTask";
            }

            public void execute() {
            }
        });
    }

    public Enumeration listInstallations() throws RemoteException, OpException {
        return J2CResourceAdapterBean.lookupDriverNodeRel().list(this.ec.getEJBObject(), false);
    }

    private static Relation lookupAdapterConnectionFactoryRel() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (adapterConnectionFactoryRel != null) {
                Relation relation = adapterConnectionFactoryRel;
                return relation;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"lookupAdapterConnectionFactoryRel");
        Relation relation = RepositoryObjectImpl.createRelIfNeeded(myTypeObj, "J2CConnectionFactory", adapterConnectionFactoryRelName, true, true, 2);
        Integer n2 = classLock;
        synchronized (n2) {
            adapterConnectionFactoryRel = relation;
        }
        Tr.exit((TraceComponent)tc, (String)"lookupAdapterConnectionFactoryRel");
        return relation;
    }

    private static Relation lookupDriverNodeRel() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (driverNodeRel != null) {
                Relation relation = driverNodeRel;
                return relation;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"lookupDriverNodeRel");
        Relation relation = RepositoryObjectImpl.createRelIfNeeded(myTypeObj, "Node", adapterNodeRelName, true, false, 4);
        Tr.exit((TraceComponent)tc, (String)"lookupDriverNodeRel");
        Integer n2 = classLock;
        synchronized (n2) {
            driverNodeRel = relation;
        }
        return relation;
    }

    private J2CResourceAdapterAttributes readInstanceVariables(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"readInstanceVariables");
        J2CResourceAdapterAttributes j2CResourceAdapterAttributes = (J2CResourceAdapterAttributes)attributes;
        j2CResourceAdapterAttributes.setName(this.name);
        j2CResourceAdapterAttributes.setFullName(this.getFullName());
        j2CResourceAdapterAttributes.setDescription(this.description);
        j2CResourceAdapterAttributes.setArchiveFile(this.archiveFile);
        j2CResourceAdapterAttributes.setConfigProperties(this.configProperties);
        j2CResourceAdapterAttributes.setAdapterProperties(this.adapterProperties);
        Tr.exit((TraceComponent)tc, (String)"readInstanceVariables");
        return j2CResourceAdapterAttributes;
    }

    public void setAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setAttributes");
        if (this.narrowRef != null) {
            ((J2CResourceAdapter)this.narrowRef).setAttributes(attributes);
        } else {
            String string;
            try {
                if (attributes.isSet(Attributes.name)) {
                    string = ((J2CResourceAdapterAttributes)attributes).getName();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(RepositoryObjectImpl.nls.getFormattedMessage("invalid.attribute.name", new Object[]{"Name"}, "Invalid value for attribute: {0}"));
            }
            try {
                if (attributes.isSet(J2CResourceAdapterAttributes.archiveFile)) {
                    string = ((J2CResourceAdapterAttributes)attributes).getArchiveFile();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(RepositoryObjectImpl.nls.getFormattedMessage("invalid.attribute.name", new Object[]{"ArchiveFile"}, "Invalid value for attribute: {0}"));
            }
            this.checkAndIncrVersion(attributes);
            this.updateInstanceVariables((J2CResourceAdapterAttributes)attributes, false);
        }
        Tr.exit((TraceComponent)tc, (String)"setAttributes");
    }

    public Act uninstall(Node node) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"uninstall");
        Relation relation = J2CResourceAdapterBean.lookupDriverNodeRel();
        String string = (String)relation.listNames(this.ec.getEJBObject(), node).nextElement();
        if (string == null) {
            throw new JDBCDriverNotInstalledException();
        }
        this.deleteFromRelation(relation, node);
        Tr.exit((TraceComponent)tc, (String)"uninstall");
        return ActServerImpl.getInstance().scheduleWork(new AsyncTask(){

            public String getName() {
                return "dummyTask";
            }

            public void execute() {
            }
        });
    }

    private void updateInstanceVariables(J2CResourceAdapterAttributes j2CResourceAdapterAttributes, boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"updateInstanceVariables");
        boolean bl2 = false;
        this.dirty = true;
        try {
            if (j2CResourceAdapterAttributes.isSet(Attributes.name)) {
                if (bl) {
                    this.name = "";
                }
                this.validateNameChange(j2CResourceAdapterAttributes);
                this.name = j2CResourceAdapterAttributes.getName();
            }
            if (j2CResourceAdapterAttributes.isSet(J2CResourceAdapterAttributes.description)) {
                this.description = j2CResourceAdapterAttributes.getDescription();
            }
            if (j2CResourceAdapterAttributes.isSet(J2CResourceAdapterAttributes.archiveFile)) {
                this.archiveFile = j2CResourceAdapterAttributes.getArchiveFile();
            }
            if (j2CResourceAdapterAttributes.isSet(J2CResourceAdapterAttributes.configProperties)) {
                this.configProperties = j2CResourceAdapterAttributes.getConfigProperties();
                this.setBinaryAttr(configPropertiesAttrName, this.configProperties);
            }
            if (j2CResourceAdapterAttributes.isSet(J2CResourceAdapterAttributes.adapterProperties)) {
                this.adapterProperties = j2CResourceAdapterAttributes.getAdapterProperties();
                this.setBinaryAttr(adapterPropertiesAttrName, this.adapterProperties);
            }
            if (bl2) {
                this.updateRelatedConnectionFactories();
            }
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeNotSetException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)attributeNotSetException);
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeDoesNotExistException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)attributeDoesNotExistException);
        }
        Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables");
    }

    private void updateRelatedConnectionFactories() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"updateRelatedConnectionFactories");
        adapterConnectionFactoryRel = J2CResourceAdapterBean.lookupAdapterConnectionFactoryRel();
        try {
            Enumeration enumeration = this.listRelatedObjects(J2CResourceAdapterBean.lookupAdapterConnectionFactoryRel());
            while (enumeration.hasMoreElements()) {
                J2CConnectionFactory j2CConnectionFactory = (J2CConnectionFactory)enumeration.nextElement();
                j2CConnectionFactory.notifyAdapterChanges((J2CResourceAdapter)this.ec.getEJBObject());
            }
        }
        catch (OpException opException) {
            Tr.exit((TraceComponent)tc, (String)"updateRelatedConnectionFactories", (Object)((Object)opException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)opException);
        }
        Tr.exit((TraceComponent)tc, (String)"updateRelatedConnectionFactories");
    }

    private void validateNameChange(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"validateNameChange ");
        try {
            if (attributes.isSet(Attributes.name)) {
                String string = attributes.getName();
                if (string.equals(this.name)) {
                    Tr.exit((TraceComponent)tc, (String)"validateNameChange");
                    return;
                }
                try {
                    this.ejbFindByName(string, true);
                    Tr.exit((TraceComponent)tc, (String)"validateNameChange -- duplicate name");
                    throw new InvalidNameChangeException();
                }
                catch (ObjectNotFoundException objectNotFoundException) {}
            }
        }
        catch (InvalidNameChangeException invalidNameChangeException) {
            throw invalidNameChangeException;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"validateNameChange -- unexpected error", (Object)exception);
            throw new RemoteOpException("", (Throwable)exception);
        }
        Tr.exit((TraceComponent)tc, (String)"validateNameChange");
    }

    private void processRARFile(J2CResourceAdapterAttributes j2CResourceAdapterAttributes) throws RemoteException, OpException {
        Object object;
        Tr.entry((TraceComponent)tc, (String)"processRARFile");
        Context context = RepositoryObjectImpl.getInitialNamingContext();
        FileBrowserServiceHome fileBrowserServiceHome = null;
        try {
            object = ManagedServer.getInstance().qualifyRepositoryHomeName("FileBrowserServiceHome");
            Tr.event((TraceComponent)tc, (String)"looking up : ", (Object)object);
            Object object2 = context.lookup((String)object);
            fileBrowserServiceHome = (FileBrowserServiceHome)PortableRemoteObject.narrow((Object)object2, (Class)(class$com$ibm$ejs$sm$beans$FileBrowserServiceHome == null ? (class$com$ibm$ejs$sm$beans$FileBrowserServiceHome = J2CResourceAdapterBean.class$("com.ibm.ejs.sm.beans.FileBrowserServiceHome")) : class$com$ibm$ejs$sm$beans$FileBrowserServiceHome));
        }
        catch (Exception exception) {
            throw new RemoteOpException("Could not get FileBrowserServiceHome");
        }
        object = null;
        RemoteArchiveInfo remoteArchiveInfo = null;
        RarDeploymentInfo rarDeploymentInfo = null;
        try {
            AdminServer adminServer = AdminServer.getAdminServerInstance();
            Node node = adminServer.getNode();
            object = fileBrowserServiceHome.create(node);
            remoteArchiveInfo = object.getRemoteArchiveInfo(j2CResourceAdapterAttributes.getArchiveFile(), 1111);
            rarDeploymentInfo = (RarDeploymentInfo)remoteArchiveInfo.getDeploymentInfo();
            j2CResourceAdapterAttributes.setAdapterProperties(rarDeploymentInfo.getAdapterProperties());
            j2CResourceAdapterAttributes.setConfigProperties(rarDeploymentInfo.getConfigProperties());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteOpException("Failed to create FileBrowserService remote obj or call methods on it");
        }
        Tr.exit((TraceComponent)tc, (String)"processRARFile");
    }

    private void validateStringAttr(String string) throws RemoteException {
        if (string.trim().equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"validateStringAttr failed.");
            }
            throw new RemoteException("validateStringAttr failed.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        resourceAdapterBeanKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
        loadStmtKey = resourceAdapterBeanKeyBase + 1;
        updateStmtKey = resourceAdapterBeanKeyBase + 2;
        deleteStmtKey = resourceAdapterBeanKeyBase + 3;
        insertStmtKey = resourceAdapterBeanKeyBase + 4;
        restrictedFindByNameStmtKey = resourceAdapterBeanKeyBase + 5;
        restrictedFindAllStmtKey = resourceAdapterBeanKeyBase + 6;
        findAllStmtKey = resourceAdapterBeanKeyBase + 7;
        findByNameStmtKey = resourceAdapterBeanKeyBase + 8;
        updateStmtSql = "update " + tableName + " set " + nameColumnName + " = ? , " + descriptionColumnName + " = ? , " + archiveFileColumnName + " = ? " + " where " + "INSTANCE_ID" + " = ?";
        deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " = ?";
        findByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " =  ?";
        restrictedFindByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " = ? and " + "TYPE_ID" + " = ? ";
        insertStmtSql = "insert into " + tableName + " values (?,?,?,?,?)";
    }

    class NotifyNodeTask
    implements AsyncTask {
        private Node node;
        private AdminAgent nodeAgent;
        private String jarFile;
        private boolean addOrRemove;

        NotifyNodeTask(Node node, AdminAgent adminAgent, String string, boolean bl) {
            this.node = node;
            this.nodeAgent = adminAgent;
            this.jarFile = string;
            this.addOrRemove = bl;
        }

        public String getName() {
            return "notifyNodeTask";
        }

        public void execute() throws RemoteException, OpException {
            Tr.entry((TraceComponent)tc, (String)"notifyNodeTask - execute");
            ParamList paramList = new ParamList(2);
            paramList.addElement(this.jarFile);
            paramList.addElement(this.addOrRemove);
            try {
                this.nodeAgent.invokeActiveObject(this.node.getActiveObjectContainmentPath(), "notifyDriverInstallation", paramList);
            }
            catch (InvalidJDBCDriverJarFileException invalidJDBCDriverJarFileException) {
                Tr.event((TraceComponent)tc, (String)"invalid jar file, removing driver object");
                J2CResourceAdapterBean.this.deleteFromRelation(J2CResourceAdapterBean.lookupDriverNodeRel(), this.node);
                throw invalidJDBCDriverJarFileException;
            }
            Tr.exit((TraceComponent)tc, (String)"notifyNodeTask - execute");
        }
    }
}

