/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.agent.AdminAgent;
import com.ibm.ejs.sm.agent.ParamList;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.DataSource;
import com.ibm.ejs.sm.beans.JDBCDriver;
import com.ibm.ejs.sm.beans.JDBCDriverAttributes;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.Relation;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.RepositoryObjectName;
import com.ibm.ejs.sm.beans.RepositoryObjectNameElem;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.DataSourceInActiveUseException;
import com.ibm.ejs.sm.exception.InvalidJDBCDriverJarFileException;
import com.ibm.ejs.sm.exception.InvalidJDBCDriverNameException;
import com.ibm.ejs.sm.exception.InvalidNameChangeException;
import com.ibm.ejs.sm.exception.JDBCDriverAlreadyInstalledException;
import com.ibm.ejs.sm.exception.JDBCDriverInActiveUseException;
import com.ibm.ejs.sm.exception.JDBCDriverInUseException;
import com.ibm.ejs.sm.exception.JDBCDriverNotInstalledException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.RemoteOpException;
import com.ibm.ejs.sm.exception.RequiredAttributeMissingException;
import com.ibm.ejs.sm.util.ObjectCollection;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.act.Act;
import com.ibm.ejs.sm.util.act.ActServerImpl;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import com.ibm.ejs.sm.util.task.AsyncTask;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;

public class JDBCDriverBean
extends RepositoryObjectImpl
implements EntityBean {
    protected static NLS nls = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$JDBCDriverBean == null ? (class$com$ibm$ejs$sm$beans$JDBCDriverBean = JDBCDriverBean.class$("com.ibm.ejs.sm.beans.JDBCDriverBean")) : class$com$ibm$ejs$sm$beans$JDBCDriverBean));
    private static Integer classLock = new Integer(0);
    private static final String tableName = DBMgr.qualifiedTableName((String)"JDBCDRIV_TABLE");
    private static final String nameColumnName = "NAME";
    private static final int nameColumnIndex = 3;
    private static final String implClassColumnName = "IMPL_CLASS";
    private static final int implClassColumnIndex = 4;
    private static final String urlPrefixColumnName = "URL_PREFIX";
    private static final int urlPrefixColumnIndex = 5;
    private static final String descriptionColumnName = "DESCRIPTION";
    private static final int descriptionColumnIndex = 6;
    private static final int numColumns = 6;
    protected static final String myInterfaceName = RepositoryObjectImpl.qualifyClassName("JDBCDriver");
    private static final String myClassName = RepositoryObjectImpl.qualifyClassName("JDBCDriverBean");
    private static boolean tableCreated = false;
    private static Type myTypeObj = null;
    private static Long myTypeId = null;
    private static final String myHomeName = "JDBCDriverHome";
    private static final String defaultUrlPrefix = "jdbc:db2";
    private static Relation driverNodeRel;
    private static Relation driverDataSourceRel;
    protected static final String driverNodeRelName = "jdbcDriverInstallations";
    protected static final String driverDataSourceRelName = "jdbcDriverDataSourceRel";
    private static final int jdbcdriverBeanKeyBase;
    private static final int loadStmtKey;
    private static final int updateStmtKey;
    private static final int deleteStmtKey;
    private static final int insertStmtKey;
    private static final int restrictedFindByNameStmtKey;
    private static final int restrictedFindAllStmtKey;
    private static final int findAllStmtKey;
    private static final int findByNameStmtKey;
    private static final String updateStmtSql;
    private static final String deleteStmtSql;
    private static final String findByNameStmtSql;
    private static final String restrictedFindByNameStmtSql;
    private static final String insertStmtSql;
    private String name;
    private String implClass;
    private String urlPrefix;
    private String description;
    private boolean dirty;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$JDBCDriverBean;

    public Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        if (this.narrowRef != null) {
            return ((JDBCDriver)this.narrowRef).getAttributes(attributes);
        }
        this.setVersion(attributes);
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return this.readInstanceVariables(attributes);
    }

    public void setAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setAttributes");
        try {
            if (attributes.isSet(Attributes.name)) {
                this.validateStringAttr(attributes.getName());
            }
        }
        catch (Exception exception) {
            this.ec.setRollbackOnly();
            throw new RemoteOpException(nls.getFormattedMessage("invalid.attribute.name", new Object[]{"Name"}, "Invalid value for attribute: {0}"));
        }
        try {
            if (((JDBCDriverAttributes)attributes).isSet(JDBCDriverAttributes.implClass)) {
                this.validateStringAttr(((JDBCDriverAttributes)attributes).getImplClass());
            }
        }
        catch (Exception exception) {
            this.ec.setRollbackOnly();
            throw new RemoteOpException(nls.getFormattedMessage("invalid.attribute.name", new Object[]{"ImplClass"}, "Invalid value for attribute: {0}"));
        }
        if (this.narrowRef != null) {
            ((JDBCDriver)this.narrowRef).setAttributes(attributes);
            return;
        }
        this.checkAndIncrVersion(attributes);
        this.updateInstanceVariables((JDBCDriverAttributes)attributes, false);
        Tr.exit((TraceComponent)tc, (String)"setAttributes");
    }

    public RepositoryObjectName getFullName() throws RemoteException, OpException {
        RepositoryObjectName repositoryObjectName = new RepositoryObjectName();
        repositoryObjectName.addElement(new RepositoryObjectNameElem(myHomeName, this.name));
        return repositoryObjectName;
    }

    public Enumeration listInstallations() throws RemoteException, OpException {
        return JDBCDriverBean.lookupDriverNodeRel().list(this.ec.getEJBObject(), false);
    }

    public String getJarfile(Node node) throws RemoteException, OpException {
        Enumeration enumeration = JDBCDriverBean.lookupDriverNodeRel().listNames(this.ec.getEJBObject(), node);
        if (enumeration.hasMoreElements()) {
            return (String)enumeration.nextElement();
        }
        return null;
    }

    public Act install(Node node, String string) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"install");
        Relation relation = JDBCDriverBean.lookupDriverNodeRel();
        if (relation.listNames(this.ec.getEJBObject(), node).hasMoreElements()) {
            throw new JDBCDriverAlreadyInstalledException();
        }
        this.addToNamedRelation(relation, node, string);
        Tr.exit((TraceComponent)tc, (String)"install");
        return ActServerImpl.getInstance().scheduleWork(new AsyncTask(){

            public String getName() {
                return "dummyTask";
            }

            public void execute() {
            }
        });
    }

    public Act uninstall(Node node) throws RemoteException, OpException {
        Object object;
        Object object2;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"uninstall");
            }
            try {
                object2 = this.listInstallations();
                if (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    if (!object2.hasMoreElements()) {
                        this.checkForDriverUse();
                    }
                }
            }
            catch (RemoveException removeException) {
                throw new JDBCDriverInActiveUseException(removeException.getMessage());
            }
            object2 = JDBCDriverBean.lookupDriverNodeRel();
            object = null;
            try {
                object = (String)object2.listNames(this.ec.getEJBObject(), node).nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                if (!tc.isEventEnabled()) break block9;
                Tr.event((TraceComponent)tc, (String)"caught NoSuchElementException");
            }
        }
        if (object == null) {
            throw new JDBCDriverNotInstalledException();
        }
        this.deleteFromRelation((Relation)object2, node);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uninstall");
        }
        return ActServerImpl.getInstance().scheduleWork(new AsyncTask(){

            public String getName() {
                return "dummyTask";
            }

            public void execute() {
            }
        });
    }

    public String getImplClass() throws RemoteException, OpException {
        Long l = (Long)this.ec.getPrimaryKey();
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"genImplClass", (Object)l);
        }
        String string = null;
        DBQueryResult dBQueryResult = null;
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (!resultSet.next()) {
                    RemoteOpException remoteOpException = new RemoteOpException("", (Throwable)new ObjectNotFoundException());
                    Tr.exit((TraceComponent)tc, (String)"genImplClass", (Object)remoteOpException);
                    throw remoteOpException;
                }
                string = resultSet.getString(4);
            }
            catch (SQLException sQLException) {
                RemoteOpException remoteOpException = new RemoteOpException("", (Throwable)sQLException);
                Tr.exit((TraceComponent)tc, (String)"genImplClass", (Object)remoteOpException);
                throw remoteOpException;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"genImplClass");
        }
        return string;
    }

    public Vector getCustomProperties() throws RemoteException, OpException {
        Enumeration enumeration;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCustomProperties");
        }
        if (!(enumeration = this.listInstallations()).hasMoreElements()) {
            throw new JDBCDriverNotInstalledException();
        }
        Node node = (Node)enumeration.nextElement();
        AdminAgent adminAgent = node.getAdminAgent();
        String string = this.getJarfile(node);
        ParamList paramList = new ParamList(2);
        paramList.addElement(string);
        paramList.addElement(this.implClass);
        Object object = adminAgent.invokeActiveObject(node.getActiveObjectContainmentPath(), "getJDBCProviderProperties", paramList);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCustomProperties");
        }
        return (Vector)object;
    }

    public Object[] testConnection(Properties properties) throws RemoteException, OpException {
        Enumeration enumeration;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"testConnection");
        }
        if (!(enumeration = this.listInstallations()).hasMoreElements()) {
            throw new JDBCDriverNotInstalledException();
        }
        Node node = (Node)enumeration.nextElement();
        AdminAgent adminAgent = node.getAdminAgent();
        String string = this.getJarfile(node);
        ParamList paramList = new ParamList(3);
        paramList.addElement(this.implClass);
        paramList.addElement(properties);
        paramList.addElement(string);
        Object object = adminAgent.invokeActiveObject(node.getActiveObjectContainmentPath(), "testConnection", paramList);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"testConnection");
        }
        return (Object[])object;
    }

    public JDBCDriverBean() throws RemoteException {
        JDBCDriverBean.initializeNLS("RepositoryStrings");
        JDBCDriverBean.initializePersistentStore();
        JDBCDriverBean.initializeTypeId();
        JDBCDriverBean.lookupDriverNodeRel();
        JDBCDriverBean.lookupDriverDataSourceRel();
    }

    protected static void initializeNLS(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeNLS");
        }
        if (nls == null) {
            nls = new NLS(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeNLS");
        }
    }

    public void ejbLoad() throws RemoteException {
        Long l = (Long)this.ec.getPrimaryKey();
        Tr.entry((TraceComponent)tc, (String)"ejbLoad", (Object)l);
        DBQueryResult dBQueryResult = null;
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (!resultSet.next()) {
                    RemoteException remoteException = new RemoteException(nls.getFormattedMessage("jdbc.db.select0.exception", new Object[]{l, tableName}, "Database select failed to find JDBC driver instance {0} in table {1}."), new ObjectNotFoundException());
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                    throw remoteException;
                }
                if (this.setId(resultSet, myTypeId)) {
                    super.ejbLoad();
                    this.name = resultSet.getString(3);
                    this.implClass = resultSet.getString(4);
                    this.urlPrefix = resultSet.getString(5);
                    this.description = resultSet.getString(6);
                    if (this.name == null) {
                        this.name = new String();
                    }
                    if (this.implClass == null) {
                        this.implClass = new String();
                    }
                    if (this.urlPrefix == null) {
                        this.urlPrefix = new String();
                    }
                    if (this.description == null) {
                        this.description = new String();
                    }
                }
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("jdbc.db.select1.exception", new Object[]{sQLException.getMessage()}, "Database select failed due to {0}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbLoad - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        Tr.exit((TraceComponent)tc, (String)"ejbLoad");
    }

    public void ejbStore() throws RemoteException {
        if (this.narrowRef != null) {
            return;
        }
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        super.ejbStore();
        if (this.dirty) {
            try {
                Vector<String> vector = new Vector<String>(6);
                vector.addElement(this.name);
                vector.addElement(this.implClass);
                vector.addElement(this.urlPrefix);
                vector.addElement(this.description);
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("jdbc.db.update0.exception", new Object[]{sQLException.getMessage(), this.name, this.implClass, this.urlPrefix, this.id}, "Database update failed due to {0} for statement with name = {1}, implClass = {2}, urlPrefix = {3}, id = {4}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbStore - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
            Tr.exit((TraceComponent)tc, (String)"ejbStore");
        }
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        if (this.id == null) {
            this.ejbLoad();
        }
        if (this.narrowRef != null) {
            this.narrowRef.remove();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove");
            return;
        }
        this.checkForDriverUse();
        super.ejbRemove();
        Long l = (Long)this.ec.getPrimaryKey();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)l));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("jdbc.db.delete0.exception", new Object[]{sQLException.getMessage(), l}, "Database delete failed due to {0} for primary key {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbRemove - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public Long ejbCreate(JDBCDriverAttributes jDBCDriverAttributes, EJBObject eJBObject) throws RemoteException, CreateException {
        Serializable serializable;
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        try {
            this.initializeInstanceVariables();
            String string = jDBCDriverAttributes.getName();
            this.implClass = jDBCDriverAttributes.getImplClass();
            try {
                if (!jDBCDriverAttributes.isSet(JDBCDriverAttributes.urlPrefix)) {
                    serializable = (JDBCDriverAttributes)RepositoryObjectImpl.getDefaults(myTypeObj);
                    this.urlPrefix = ((JDBCDriverAttributes)serializable).getUrlPrefix();
                } else {
                    this.urlPrefix = jDBCDriverAttributes.getUrlPrefix();
                }
            }
            catch (AttributeDoesNotExistException attributeDoesNotExistException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("jdbc.attribute0.exception", new Object[]{string}, "Attribute {0} does not exist."), attributeDoesNotExistException);
                Tr.exit((TraceComponent)tc, (String)"ejbCreate - with AttributeDoesNotExistException");
                throw remoteException;
            }
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)" < ejbCreate -- required attribute missing", (Object)((Object)attributeNotSetException));
            throw new RequiredAttributeMissingException(attributeNotSetException.getMessage());
        }
        try {
            if (jDBCDriverAttributes.isSet(Attributes.name)) {
                this.validateStringAttr(jDBCDriverAttributes.getName());
            }
        }
        catch (Exception exception) {
            throw new RemoteException(nls.getFormattedMessage("invalid.attribute.name", new Object[]{"Name"}, "Invalid value for attribute: {0}"));
        }
        try {
            if (jDBCDriverAttributes.isSet(JDBCDriverAttributes.implClass)) {
                this.validateStringAttr(jDBCDriverAttributes.getImplClass());
            }
        }
        catch (Exception exception) {
            throw new RemoteException(nls.getFormattedMessage("invalid.attribute.name", new Object[]{"ImplClass"}, "Invalid value for attribute: {0}"));
        }
        try {
            if (this.typeId == null) {
                this.typeId = myTypeId;
            }
            this.id = this.create(this.typeId);
            try {
                this.updateInstanceVariables(jDBCDriverAttributes, true);
            }
            catch (InvalidNameChangeException invalidNameChangeException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate -- invalid jdbc driver name");
                throw new InvalidJDBCDriverNameException();
            }
            catch (OpException opException) {
                Tr.exit((TraceComponent)tc, (String)"ejbCreate -- unexpected exception when updating instance variables");
                throw new RemoteException(nls.getString("jdbc.instance.operation.exception", "Could not update the instance variables."), opException);
            }
            Tr.debug((TraceComponent)tc, (String)"insert record in database");
            serializable = new Vector(6);
            ((Vector)serializable).addElement(Utils.getIdString((Long)this.id));
            ((Vector)serializable).addElement(Utils.getIdString((Long)this.typeId));
            ((Vector)serializable).addElement(this.name);
            ((Vector)serializable).addElement(this.implClass);
            ((Vector)serializable).addElement(this.urlPrefix);
            ((Vector)serializable).addElement(this.description);
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, (Vector)serializable);
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("jdbc.db.insert0.exception", new Object[]{sQLException.getMessage(), this.name, this.implClass, this.urlPrefix, this.id, this.typeId}, "Database insert failed due to {0} for statement with name = {1}, implClass = {2}, urlPrefix = {3}, id = {4} typeId = {5}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbCreate - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)this.id);
        return this.id;
    }

    public void ejbPostCreate(JDBCDriverAttributes jDBCDriverAttributes, Node node) {
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException, FinderException {
        Enumeration enumeration;
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll");
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)false, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("jdbc.db.select2.exception", new Object[]{sQLException.getMessage(), tableName}, "Database findAll failed due to {0} on table {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbFindAll - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)((ObjectCollection)enumeration).getArray());
        return enumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByName", (Object)string);
        DBQueryResult dBQueryResult = null;
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByNameStmtKey, (String)findByNameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByNameStmtKey, (String)restrictedFindByNameStmtSql, vector);
                }
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName");
                l = this.singleFinderEpilogue(dBQueryResult);
                Object var7_8 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("jdbc.db.select4.exception", new Object[]{sQLException.getMessage(), string}, "Database findByName failed due to {0} for name {1}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    private static void initializePersistentStore() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (tableCreated) {
                return;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + nameColumnName + DBMgr.mediumStringColumnSpec + " , " + implClassColumnName + DBMgr.smallStringColumnSpec + " , " + urlPrefixColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + descriptionColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Integer n2 = classLock;
            synchronized (n2) {
                tableCreated = true;
            }
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("jdbc.db.create0.exception", new Object[]{tableName, sQLException.getMessage()}, "Database could not create table {0} because of {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"initializePersistentStore - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
    }

    private static void initializeTypeId() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (myTypeId != null) {
                return;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        JDBCDriverAttributes jDBCDriverAttributes = null;
        jDBCDriverAttributes = new JDBCDriverAttributes();
        jDBCDriverAttributes.setUrlPrefix(defaultUrlPrefix);
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, jDBCDriverAttributes, true);
        Long l = (Long)type.getPrimaryKey();
        Integer n2 = classLock;
        synchronized (n2) {
            myTypeId = l;
            myTypeObj = type;
        }
        Tr.exit((TraceComponent)tc, (String)"initializeTypeId");
    }

    private void initializeInstanceVariables() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeInstanceVariables");
        JDBCDriverAttributes jDBCDriverAttributes = (JDBCDriverAttributes)RepositoryObjectImpl.getDefaults(myTypeObj);
        try {
            this.urlPrefix = jDBCDriverAttributes.getUrlPrefix();
            this.description = new String();
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"intializeInstanceVariables", (Object)exception);
            throw new RemoteException(nls.getString("jdbc.instance.operation1.exception", "Could not initialize the instance variables."), exception);
        }
        Tr.exit((TraceComponent)tc, (String)"intializeInstanceVariables");
    }

    private void updateInstanceVariables(JDBCDriverAttributes jDBCDriverAttributes, boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"updateInstanceVariables");
        this.dirty = true;
        try {
            if (jDBCDriverAttributes.isSet(Attributes.name)) {
                if (bl) {
                    this.name = "";
                }
                this.validateNameChange(jDBCDriverAttributes);
                this.name = jDBCDriverAttributes.getName();
            }
            boolean bl2 = false;
            if (!bl && (jDBCDriverAttributes.isSet(JDBCDriverAttributes.implClass) || jDBCDriverAttributes.isSet(JDBCDriverAttributes.urlPrefix))) {
                this.checkForActiveDriverUse();
                bl2 = true;
            }
            if (jDBCDriverAttributes.isSet(JDBCDriverAttributes.implClass)) {
                Enumeration enumeration;
                if (this.implClass != null && !this.implClass.equals(jDBCDriverAttributes.getImplClass()) && (enumeration = this.listInstallations()).hasMoreElements()) {
                    throw new JDBCDriverAlreadyInstalledException();
                }
                this.implClass = jDBCDriverAttributes.getImplClass();
            }
            if (jDBCDriverAttributes.isSet(JDBCDriverAttributes.urlPrefix)) {
                this.urlPrefix = jDBCDriverAttributes.getUrlPrefix();
            }
            if (jDBCDriverAttributes.isSet(JDBCDriverAttributes.description)) {
                this.description = jDBCDriverAttributes.getDescription();
            }
            if (bl2) {
                this.updateRelatedDataSources();
            }
        }
        catch (AttributeNotSetException attributeNotSetException) {
            this.ec.setRollbackOnly();
            RemoteOpException remoteOpException = new RemoteOpException(nls.getFormattedMessage("jdbc.attribute1.exception", new Object[]{this.name}, "Attribute {0} is not set."), (Throwable)attributeNotSetException);
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables - with AttributeNotSetException", (Object)((Object)attributeNotSetException));
            throw remoteOpException;
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            this.ec.setRollbackOnly();
            RemoteOpException remoteOpException = new RemoteOpException(nls.getFormattedMessage("jdbc.attribute0.exception", new Object[]{this.name}, "Attribute {0} does not exist."), (Throwable)attributeDoesNotExistException);
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables - with AttributeDoesNotExistException");
            throw remoteOpException;
        }
        Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables");
    }

    private void validateStringAttr(String string) throws RemoteException {
        if (string.trim().equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"validateStringAttr failed.");
            }
            throw new RemoteException("validateStringAttr failed.");
        }
    }

    private JDBCDriverAttributes readInstanceVariables(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"readInstanceVariables");
        JDBCDriverAttributes jDBCDriverAttributes = (JDBCDriverAttributes)attributes;
        jDBCDriverAttributes.setName(this.name);
        jDBCDriverAttributes.setFullName(this.getFullName());
        jDBCDriverAttributes.setImplClass(this.implClass);
        jDBCDriverAttributes.setUrlPrefix(this.urlPrefix);
        jDBCDriverAttributes.setDescription(this.description);
        Tr.exit((TraceComponent)tc, (String)"readInstanceVariables");
        return jDBCDriverAttributes;
    }

    private void validateNameChange(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"validateNameChange ");
        try {
            if (attributes.isSet(Attributes.name)) {
                String string = attributes.getName();
                if (string.equals(this.name)) {
                    Tr.exit((TraceComponent)tc, (String)"validateNameChange");
                    return;
                }
                try {
                    this.ejbFindByName(string, true);
                    Tr.exit((TraceComponent)tc, (String)"validateNameChange -- duplicate name");
                    throw new InvalidNameChangeException();
                }
                catch (ObjectNotFoundException objectNotFoundException) {}
            }
        }
        catch (InvalidNameChangeException invalidNameChangeException) {
            throw invalidNameChangeException;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"validateNameChange -- java.lang.Exception", (Object)exception);
            throw new RemoteOpException(nls.getString("jdbc.instance.name.exception", "Could not change the name of attribute."), (Throwable)exception);
        }
        Tr.exit((TraceComponent)tc, (String)"validateNameChange");
    }

    private void checkForDriverUse() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"checkForDriverUse");
        driverDataSourceRel = JDBCDriverBean.lookupDriverDataSourceRel();
        try {
            Enumeration enumeration = this.listRelatedObjects(JDBCDriverBean.lookupDriverDataSourceRel());
            if (enumeration.hasMoreElements()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Throwing JDBCDriverInUseException...");
                }
                throw new JDBCDriverInUseException();
            }
        }
        catch (OpException opException) {
            Tr.exit((TraceComponent)tc, (String)"checkForDriverUse", (Object)((Object)opException));
            throw new RemoteException(nls.getString("jdbc.instance.operation2.exception", "An operation exception occurred. "), opException);
        }
        Tr.exit((TraceComponent)tc, (String)"checkForDriverUse");
    }

    private void checkForActiveDriverUse() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"checkForActiveDriverUse");
        driverDataSourceRel = JDBCDriverBean.lookupDriverDataSourceRel();
        try {
            Enumeration enumeration = this.listRelatedObjects(JDBCDriverBean.lookupDriverDataSourceRel());
            while (enumeration.hasMoreElements()) {
                try {
                    DataSource dataSource = (DataSource)enumeration.nextElement();
                    dataSource.checkForActiveUse();
                }
                catch (DataSourceInActiveUseException dataSourceInActiveUseException) {
                    Tr.exit((TraceComponent)tc, (String)"driver in active use ... ");
                    throw new JDBCDriverInActiveUseException();
                }
            }
        }
        catch (OpException opException) {
            Tr.exit((TraceComponent)tc, (String)"checkForActiveDriverUse", (Object)((Object)opException));
            throw new RemoteOpException(nls.getString("jdbc.instance.operation2.exception", "An operation exception occurred. "), (Throwable)opException);
        }
    }

    private void updateRelatedDataSources() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"updateRelatedDataSources");
        driverDataSourceRel = JDBCDriverBean.lookupDriverDataSourceRel();
        try {
            Enumeration enumeration = this.listRelatedObjects(JDBCDriverBean.lookupDriverDataSourceRel());
            while (enumeration.hasMoreElements()) {
                DataSource dataSource = (DataSource)enumeration.nextElement();
                dataSource.notifyDriverChanges((JDBCDriver)this.ec.getEJBObject());
            }
        }
        catch (OpException opException) {
            Tr.exit((TraceComponent)tc, (String)"updateRelatedDataSources", (Object)((Object)opException));
            throw new RemoteOpException(nls.getString("jdbc.instance.operation2.exception", "An operation exception occurred. "), (Throwable)opException);
        }
        Tr.exit((TraceComponent)tc, (String)"updateRelatedDataSources");
    }

    private static Relation lookupDriverDataSourceRel() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (driverDataSourceRel != null) {
                Relation relation = driverDataSourceRel;
                return relation;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"lookupDriverDataSourceRel");
        Relation relation = RepositoryObjectImpl.createRelIfNeeded(myTypeObj, "DataSource", driverDataSourceRelName, true, true, 2);
        Tr.exit((TraceComponent)tc, (String)"lookupDriverDataSourceRel");
        Integer n2 = classLock;
        synchronized (n2) {
            driverDataSourceRel = relation;
        }
        return relation;
    }

    private static Relation lookupDriverNodeRel() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (driverNodeRel != null) {
                Relation relation = driverNodeRel;
                return relation;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"lookupDriverNodeRel");
        Relation relation = RepositoryObjectImpl.createRelIfNeeded(myTypeObj, "Node", driverNodeRelName, true, false, 4);
        Tr.exit((TraceComponent)tc, (String)"lookupDriverNodeRel");
        Integer n2 = classLock;
        synchronized (n2) {
            driverNodeRel = relation;
        }
        return relation;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        jdbcdriverBeanKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
        loadStmtKey = jdbcdriverBeanKeyBase + 1;
        updateStmtKey = jdbcdriverBeanKeyBase + 2;
        deleteStmtKey = jdbcdriverBeanKeyBase + 3;
        insertStmtKey = jdbcdriverBeanKeyBase + 4;
        restrictedFindByNameStmtKey = jdbcdriverBeanKeyBase + 5;
        restrictedFindAllStmtKey = jdbcdriverBeanKeyBase + 6;
        findAllStmtKey = jdbcdriverBeanKeyBase + 7;
        findByNameStmtKey = jdbcdriverBeanKeyBase + 8;
        updateStmtSql = "update " + tableName + " set " + nameColumnName + " = ? , " + implClassColumnName + " = ? ," + urlPrefixColumnName + " = ? ," + descriptionColumnName + " = ? " + " where " + "INSTANCE_ID" + " = ?";
        deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " = ?";
        findByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " =  ?";
        restrictedFindByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " = ? and " + "TYPE_ID" + " = ? ";
        insertStmtSql = "insert into " + tableName + " values (?,?,?,?,?,?)";
    }

    class NotifyNodeTask
    implements AsyncTask {
        private Node node;
        private AdminAgent nodeAgent;
        private JDBCDriver driver;
        private String jarFile;
        private String driverClass;
        private boolean addOrRemove;

        NotifyNodeTask(Node node, EJBObject eJBObject, AdminAgent adminAgent, String string, String string2, boolean bl) {
            this.node = node;
            this.nodeAgent = adminAgent;
            this.driverClass = string;
            this.jarFile = string2;
            this.addOrRemove = bl;
        }

        public String getName() {
            return "notifyNodeTask";
        }

        public void execute() throws RemoteException, OpException {
            Tr.entry((TraceComponent)tc, (String)"notifyNodeTask - execute");
            ParamList paramList = new ParamList(2);
            paramList.addElement(this.jarFile);
            paramList.addElement(this.addOrRemove);
            try {
                this.nodeAgent.invokeActiveObject(this.node.getActiveObjectContainmentPath(), "notifyDriverInstallation", paramList);
            }
            catch (InvalidJDBCDriverJarFileException invalidJDBCDriverJarFileException) {
                Tr.event((TraceComponent)tc, (String)"invalid jar file, removing driver object");
                JDBCDriverBean.this.deleteFromRelation(JDBCDriverBean.lookupDriverNodeRel(), this.node);
                throw invalidJDBCDriverJarFileException;
            }
        }
    }
}

