/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.J2EEResourceConfig;
import com.ibm.ejs.sm.beans.JMSDestination;
import com.ibm.ejs.sm.beans.JMSDestinationAttributes;
import com.ibm.ejs.sm.beans.JMSDestinationConfig;
import com.ibm.ejs.sm.beans.JMSProvider;
import com.ibm.ejs.sm.beans.JMSProviderAttributes;
import com.ibm.ejs.sm.beans.JMSProviderBean;
import com.ibm.ejs.sm.beans.JMSProviderConfig;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.Relation;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.RepositoryObjectName;
import com.ibm.ejs.sm.beans.ResourceBean;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.InvalidJDBCDriverException;
import com.ibm.ejs.sm.exception.InvalidNameChangeException;
import com.ibm.ejs.sm.exception.InvalidResourceNameException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.RelationOpException;
import com.ibm.ejs.sm.exception.RemoteOpException;
import com.ibm.ejs.sm.exception.RequiredAttributeMissingException;
import com.ibm.ejs.sm.util.ObjectCollection;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;

public class JMSDestinationBean
extends ResourceBean
implements EntityBean {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$JMSDestinationBean == null ? (class$com$ibm$ejs$sm$beans$JMSDestinationBean = JMSDestinationBean.class$("com.ibm.ejs.sm.beans.JMSDestinationBean")) : class$com$ibm$ejs$sm$beans$JMSDestinationBean));
    private static Integer classLock = new Integer(0);
    private static final String tableName = DBMgr.qualifiedTableName((String)"JMSDEST_TABLE");
    private static final String nameColumnName = "NAME";
    private static final int nameColumnIndex = 3;
    private static final String jndiNameColumnName = "JNDINAME";
    private static final int jndiNameColumnIndex = 4;
    private static final String descriptionColumnName = "DESCRIPTION";
    private static final int descriptionColumnIndex = 5;
    private static final String externalJndiNameColumnName = "EXTERNALJNDINAME";
    private static final int externalJndiNameColumnIndex = 6;
    private static final String destinationTypeColumnName = "DESTINATIONTYPE";
    private static final int destinationTypeColumnIndex = 7;
    private static final int numColumns = 7;
    protected static final String myInterfaceName = RepositoryObjectImpl.qualifyClassName("JMSDestination");
    private static final String myClassName = RepositoryObjectImpl.qualifyClassName("JMSDestinationBean");
    private static boolean tableCreated = false;
    private static Type myTypeObj = null;
    private static Long myTypeId = null;
    private static final String myHomeName = "JMSDestinationHome";
    private static final String JNDIPREFIX = "jms/";
    private static Relation providerDestinationRel;
    private static final int jmsCFBeanKeyBase;
    private static final int loadStmtKey;
    private static final int updateStmtKey;
    private static final int deleteStmtKey;
    private static final int insertStmtKey;
    private static final int restrictedFindAllStmtKey;
    private static final int findAllStmtKey;
    private static final int restrictedFindByNameStmtKey;
    private static final int findByNameStmtKey;
    private static final int findByJNDINameStmtKey;
    private static final int restrictedFindByJNDINameStmtKey;
    private static final int findByExternalJNDINameStmtKey;
    private static final int restrictedFindByExternalJNDINameStmtKey;
    private static final String updateStmtSql;
    private static final String deleteStmtSql;
    private static final String restrictedFindByNameStmtSql;
    private static final String findByNameStmtSql;
    private static final String insertStmtSql;
    private static final String restrictedFindByJNDINameStmtSql;
    private static final String findByJNDINameStmtSql;
    private static final String restrictedFindByExternalJNDINameStmtSql;
    private static final String findByExternalJNDINameStmtSql;
    private String name;
    private String jndiName;
    private String description;
    private String externalJndiName;
    private int destinationType;
    private boolean dirty;
    private JMSProvider provider;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$JMSDestinationBean;

    public JMSDestinationBean() throws RemoteException {
        JMSDestinationBean.initializePersistentStore();
        JMSDestinationBean.initializeTypeId();
    }

    public Long ejbCreate(JMSDestinationAttributes jMSDestinationAttributes, JMSProvider jMSProvider) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        try {
            jMSProvider.getFullName();
            this.provider = jMSProvider;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)" < ejbCreate -- invalid JMS Provider", (Object)exception);
            throw new InvalidJDBCDriverException("Invalid JMS Provider specified.");
        }
        try {
            this.name = jMSDestinationAttributes.getName();
            this.externalJndiName = jMSDestinationAttributes.getExternalJNDIName();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)" < ejbCreate -- required attribute missing", (Object)((Object)attributeNotSetException));
            throw new RequiredAttributeMissingException(attributeNotSetException.getMessage());
        }
        try {
            this.validateStringAttr(this.name);
        }
        catch (Exception exception) {
            throw new RequiredAttributeMissingException("Name");
        }
        try {
            this.validateStringAttr(this.externalJndiName);
        }
        catch (Exception exception) {
            throw new RequiredAttributeMissingException("ExternalJndiName");
        }
        try {
            this.validateName(this.name);
            if (this.typeId == null) {
                this.typeId = myTypeId;
            }
            this.id = this.create(this.typeId);
            this.addParentRel(this.name, this.provider);
            this.initializeInstanceVariables();
            try {
                this.updateInstanceVariables(jMSDestinationAttributes, true);
            }
            catch (InvalidNameChangeException invalidNameChangeException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate: -- invalid data source name", (Object)((Object)invalidNameChangeException));
                throw new InvalidResourceNameException();
            }
            catch (OpException opException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate: ", (Object)((Object)opException));
                throw new RemoteException("", opException);
            }
            this.name = this.name;
            Vector<Object> vector = new Vector<Object>(7);
            vector.addElement(Utils.getIdString((Long)this.id));
            vector.addElement(Utils.getIdString((Long)this.typeId));
            vector.addElement(this.name);
            vector.addElement(this.jndiName);
            vector.addElement(this.description);
            vector.addElement(this.externalJndiName);
            vector.addElement(new Integer(this.destinationType));
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)this.id);
        return this.id;
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException, FinderException {
        Enumeration enumeration;
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll");
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)false, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbFileAll", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)((ObjectCollection)enumeration).getArray());
        return enumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByExternalJNDIName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByExternalJNDIName", (Object)string);
        DBQueryResult dBQueryResult = null;
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByExternalJNDINameStmtKey, (String)findByExternalJNDINameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByExternalJNDINameStmtKey, (String)restrictedFindByExternalJNDINameStmtSql, vector);
                }
                Tr.exit((TraceComponent)tc, (String)"ejbFindByExternalJNDIName");
                l = this.singleFinderEpilogue(dBQueryResult);
                Object var7_8 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("JMSDestinationBean findByExternalJNDIName failed", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByExternalJNDIName - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByJNDIName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByJNDIName", (Object)string);
        DBQueryResult dBQueryResult = null;
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByJNDINameStmtKey, (String)findByJNDINameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByJNDINameStmtKey, (String)restrictedFindByJNDINameStmtSql, vector);
                }
                Tr.exit((TraceComponent)tc, (String)"ejbFindByJNDIName");
                l = this.singleFinderEpilogue(dBQueryResult);
                Object var7_8 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("JMSDestinationBean findByJNDIName failed", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByJNDIName - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    protected Long findByName(String string) throws RemoteException, FinderException {
        return this.ejbFindByName(string, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        DBQueryResult dBQueryResult = null;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByName", (Object)string);
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByNameStmtKey, (String)findByNameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByNameStmtKey, (String)restrictedFindByNameStmtSql, vector);
                }
                Long l2 = this.singleFinderEpilogue(dBQueryResult);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName");
                l = l2;
                Object var8_9 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    public void ejbLoad() throws RemoteException {
        DBQueryResult dBQueryResult = null;
        Long l = (Long)this.ec.getPrimaryKey();
        Tr.entry((TraceComponent)tc, (String)"ejbLoad", (Object)l);
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (resultSet == null || !resultSet.next()) {
                    RemoteException remoteException = new RemoteException("", new ObjectNotFoundException());
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                    throw remoteException;
                }
                if (this.setId(resultSet, myTypeId)) {
                    super.ejbLoad();
                    this.name = resultSet.getString(3);
                    this.jndiName = resultSet.getString(4);
                    if (this.jndiName == null) {
                        this.jndiName = new String();
                    }
                    this.description = resultSet.getString(5);
                    if (this.description == null) {
                        this.description = new String();
                    }
                    this.externalJndiName = resultSet.getString(6);
                    this.destinationType = resultSet.getInt(7);
                }
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                throw remoteException;
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        try {
            this.provider = (JMSProvider)this.getContainingObject();
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException("JMS Destination update failed due to {0}.", exception);
            Tr.exit((TraceComponent)tc, (String)"ejbLoad - with Exception", (Object)remoteException);
            throw remoteException;
        }
    }

    public void ejbPostCreate(JMSDestinationAttributes jMSDestinationAttributes, JMSProvider jMSProvider) throws RemoteException {
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        if (this.id == null) {
            this.ejbLoad();
        }
        if (this.narrowRef != null) {
            this.narrowRef.remove();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove");
            return;
        }
        super.ejbRemove();
        Long l = (Long)this.ec.getPrimaryKey();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)l));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbRemove", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        super.ejbStore();
        if (this.dirty) {
            try {
                Vector<Object> vector = new Vector<Object>(7);
                vector.addElement(this.name);
                vector.addElement(this.jndiName);
                vector.addElement(this.description);
                vector.addElement(this.externalJndiName);
                vector.addElement(new Integer(this.destinationType));
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                throw remoteException;
            }
            Tr.exit((TraceComponent)tc, (String)"ejbStore");
        }
    }

    public Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        Attributes attributes2 = null;
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        if (this.narrowRef != null) {
            attributes2 = ((JMSDestination)this.narrowRef).getAttributes(attributes);
        } else {
            this.setVersion(attributes);
            attributes2 = this.readInstanceVariables(attributes);
        }
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return attributes2;
    }

    private Object getBindingObject() {
        Tr.entry((TraceComponent)tc, (String)"getBindingObject");
        Tr.exit((TraceComponent)tc, (String)"getBindingObject");
        return null;
    }

    public RepositoryObjectName getFullName() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getFullName");
        RepositoryObjectName repositoryObjectName = this.constructFullName(myHomeName, this.name);
        Tr.exit((TraceComponent)tc, (String)"getFullName");
        return repositoryObjectName;
    }

    public String getJNDIName() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"getJNDIName");
        if (this.jndiName.trim().equals("")) {
            this.jndiName = this.name.startsWith(JNDIPREFIX) ? this.name : JNDIPREFIX + this.name;
        }
        Tr.exit((TraceComponent)tc, (String)"getJNDIName");
        return this.jndiName;
    }

    public J2EEResourceConfig getResourceConfig(Node node) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getResourceConfig(node)");
        J2EEResourceConfig j2EEResourceConfig = this.getResourceConfig();
        JMSProviderConfig jMSProviderConfig = (JMSProviderConfig)j2EEResourceConfig.getProvider();
        jMSProviderConfig.setClasspath(this.provider.getJarFile(node));
        Tr.exit((TraceComponent)tc, (String)"getResourceConfig(node)");
        return j2EEResourceConfig;
    }

    public J2EEResourceConfig getResourceConfig() throws RemoteException, OpException {
        String string;
        String string2;
        String string3;
        String string4;
        Tr.entry((TraceComponent)tc, (String)"getResourceConfig");
        Long l = (Long)this.provider.getPrimaryKey();
        JMSProviderAttributes jMSProviderAttributes = new JMSProviderAttributes();
        jMSProviderAttributes.requestAll();
        jMSProviderAttributes = (JMSProviderAttributes)this.provider.getAttributes(jMSProviderAttributes);
        try {
            string4 = jMSProviderAttributes.getName();
            string3 = jMSProviderAttributes.getExternalInitialContextFactory();
            string2 = jMSProviderAttributes.getExternalProviderURL();
            string = jMSProviderAttributes.getJNDIBindingMechanism();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            throw new OpException("getResourceConfig: AttributeNotSetException: " + attributeNotSetException.getMessage());
        }
        JMSDestinationConfig jMSDestinationConfig = new JMSDestinationConfig();
        JMSProviderConfig jMSProviderConfig = new JMSProviderConfig();
        jMSDestinationConfig.setProvider(jMSProviderConfig);
        jMSDestinationConfig.setName(this.name);
        jMSDestinationConfig.setDescription(this.description);
        jMSDestinationConfig.setJNDIName(this.jndiName);
        jMSDestinationConfig.setJtaEnabled(false);
        jMSDestinationConfig.setExternalJNDIName(this.externalJndiName);
        jMSDestinationConfig.setDestinationType(this.destinationType);
        jMSProviderConfig.setName(string4);
        jMSProviderConfig.setProviderId(l);
        jMSProviderConfig.setExternalInitialContextFactory(string3);
        jMSProviderConfig.setExternalProviderURL(string2);
        jMSProviderConfig.setJNDIBindingMechanism(string);
        Tr.exit((TraceComponent)tc, (String)"getResourceConfig");
        return jMSDestinationConfig;
    }

    private void initializeInstanceVariables() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeInstanceVariables");
        JMSDestinationAttributes jMSDestinationAttributes = (JMSDestinationAttributes)RepositoryObjectImpl.getDefaults(myTypeObj);
        try {
            this.jndiName = new String(JNDIPREFIX + this.name);
            this.description = new String();
            this.externalJndiName = new String();
            this.destinationType = 0;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"intializedInstanceVariables", (Object)exception);
            throw new RemoteException("", exception);
        }
        Tr.exit((TraceComponent)tc, (String)"intializedInstanceVariables");
    }

    private static void initializePersistentStore() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (tableCreated) {
                return;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + nameColumnName + DBMgr.mediumStringColumnSpec + " , " + jndiNameColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + descriptionColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + externalJndiNameColumnName + DBMgr.mediumStringColumnSpec + " , " + destinationTypeColumnName + " integer not null " + " , " + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Integer n2 = classLock;
            synchronized (n2) {
                tableCreated = true;
            }
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"intializePersistentStore");
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
    }

    private static void initializeTypeId() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        Integer n = classLock;
        synchronized (n) {
            if (myTypeId != null) {
                Tr.exit((TraceComponent)tc, (String)"initializeTypeId");
                return;
            }
        }
        JMSDestinationAttributes jMSDestinationAttributes = new JMSDestinationAttributes();
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, jMSDestinationAttributes, false);
        Long l = (Long)type.getPrimaryKey();
        Integer n2 = classLock;
        synchronized (n2) {
            myTypeObj = type;
            myTypeId = l;
        }
        Tr.exit((TraceComponent)tc, (String)"intializeTypeId");
    }

    private JMSDestinationAttributes readInstanceVariables(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"readInstanceVariables");
        JMSDestinationAttributes jMSDestinationAttributes = (JMSDestinationAttributes)attributes;
        jMSDestinationAttributes.setName(this.name);
        jMSDestinationAttributes.setJNDIName(this.jndiName);
        jMSDestinationAttributes.setFullName(this.getFullName());
        jMSDestinationAttributes.setDescription(this.description);
        jMSDestinationAttributes.setExternalJNDIName(this.externalJndiName);
        jMSDestinationAttributes.setDestinationType(this.destinationType);
        try {
            JMSProvider jMSProvider = (JMSProvider)this.getContainingObject();
            jMSDestinationAttributes.setProvider(jMSProvider);
            JMSProviderAttributes jMSProviderAttributes = new JMSProviderAttributes();
            jMSProviderAttributes.request(Attributes.name);
            jMSDestinationAttributes.setParentName(jMSProvider.getAttributes(jMSProviderAttributes).getName());
        }
        catch (Exception exception) {
            throw new RemoteOpException(ResourceBean.nls.getString("provider.jmsdest.exception", "Fail to request JMSProvider name"));
        }
        Tr.exit((TraceComponent)tc, (String)"readInstanceVariables");
        return jMSDestinationAttributes;
    }

    public void setAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setAttributes");
        if (this.narrowRef != null) {
            ((JMSDestination)this.narrowRef).setAttributes(attributes);
        } else {
            String string;
            try {
                if (attributes.isSet(Attributes.name)) {
                    string = ((JMSDestinationAttributes)attributes).getName();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(ResourceBean.nls.getFormattedMessage("invalid.attribute.name", new Object[]{"Name"}, "Invalid value for attribute: {0}"));
            }
            try {
                if (attributes.isSet(JMSDestinationAttributes.externalJndiName)) {
                    string = ((JMSDestinationAttributes)attributes).getExternalJNDIName();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(ResourceBean.nls.getFormattedMessage("invalid.attribute.name", new Object[]{"ExternalJndiName"}, "Invalid value for attribute: {0}"));
            }
            this.checkAndIncrVersion(attributes);
            this.renameIfNec(attributes, JMSDestinationBean.lookupProviderDestinationRel(), true);
            this.updateInstanceVariables((JMSDestinationAttributes)attributes, false);
        }
        Tr.exit((TraceComponent)tc, (String)"setAttributes");
    }

    private void updateInstanceVariables(JMSDestinationAttributes jMSDestinationAttributes, boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"updateInstanceVariables");
        this.dirty = true;
        try {
            String string;
            if (jMSDestinationAttributes.isSet(Attributes.name)) {
                this.name = jMSDestinationAttributes.getName();
            }
            if (jMSDestinationAttributes.isSet(JMSDestinationAttributes.description)) {
                this.description = jMSDestinationAttributes.getDescription();
            }
            if (jMSDestinationAttributes.isSet(JMSDestinationAttributes.jndiName) && (string = jMSDestinationAttributes.getJNDIName()) != null && !string.equals("")) {
                this.jndiName = jMSDestinationAttributes.getJNDIName();
            }
            if (jMSDestinationAttributes.isSet(JMSDestinationAttributes.externalJndiName)) {
                string = jMSDestinationAttributes.getExternalJNDIName();
                if ((string = string.trim()) != null && !string.equals(this.externalJndiName)) {
                    try {
                        if (this.ejbFindByExternalJNDIName(string, false) != null) {
                            this.ec.setRollbackOnly();
                            Tr.error((TraceComponent)tc, (String)ResourceBean.nls.getFormattedMessage("resource.duplicate.jndi.name", new Object[]{string}, "JNDI name {0} is already in use."));
                            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables");
                            throw new RemoteOpException("JNDI name " + string + " is already in use.");
                        }
                    }
                    catch (FinderException finderException) {
                        // empty catch block
                    }
                    if (!bl) {
                        this.checkForActiveResourceUse();
                    }
                    this.externalJndiName = string;
                }
            }
            if (jMSDestinationAttributes.isSet(JMSDestinationAttributes.destinationType)) {
                this.destinationType = jMSDestinationAttributes.getDestinationType();
            }
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeNotSetException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)attributeNotSetException);
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeDoesNotExistException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)attributeDoesNotExistException);
        }
        Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables");
    }

    private void addParentRel(String string, JMSProvider jMSProvider) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"addParentRel");
        JMSDestinationBean.lookupProviderDestinationRel();
        try {
            providerDestinationRel.addUsingKeys((Long)jMSProvider.getPrimaryKey(), this.id, string);
        }
        catch (RelationOpException relationOpException) {
            this.ec.setRollbackOnly();
            InvalidResourceNameException invalidResourceNameException = new InvalidResourceNameException();
            Tr.exit((TraceComponent)tc, (String)"addParentRel", (Object)invalidResourceNameException);
            throw invalidResourceNameException;
        }
        catch (RemoteException remoteException) {
            Tr.exit((TraceComponent)tc, (String)"addParentRel", (Object)remoteException);
            throw remoteException;
        }
    }

    protected static Relation lookupProviderDestinationRel() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (providerDestinationRel != null) {
                Relation relation = providerDestinationRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.lookupRel(JMSProviderBean.myInterfaceName, myTypeObj, "jmsProviderDestinationRel");
        Integer n2 = classLock;
        synchronized (n2) {
            providerDestinationRel = relation;
        }
        return providerDestinationRel;
    }

    private void validateStringAttr(String string) throws RemoteException {
        if (string.trim().equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"validateStringAttr failed.");
            }
            throw new RemoteException("validateStringAttr failed.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        jmsCFBeanKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
        loadStmtKey = jmsCFBeanKeyBase + 1;
        updateStmtKey = jmsCFBeanKeyBase + 2;
        deleteStmtKey = jmsCFBeanKeyBase + 3;
        insertStmtKey = jmsCFBeanKeyBase + 4;
        restrictedFindAllStmtKey = jmsCFBeanKeyBase + 5;
        findAllStmtKey = jmsCFBeanKeyBase + 6;
        restrictedFindByNameStmtKey = jmsCFBeanKeyBase + 7;
        findByNameStmtKey = jmsCFBeanKeyBase + 8;
        findByJNDINameStmtKey = jmsCFBeanKeyBase + 9;
        restrictedFindByJNDINameStmtKey = jmsCFBeanKeyBase + 10;
        findByExternalJNDINameStmtKey = jmsCFBeanKeyBase + 11;
        restrictedFindByExternalJNDINameStmtKey = jmsCFBeanKeyBase + 12;
        updateStmtSql = "update " + tableName + " set " + nameColumnName + " = ? , " + jndiNameColumnName + " = ? , " + descriptionColumnName + " = ? , " + externalJndiNameColumnName + " = ? , " + destinationTypeColumnName + " = ? " + " where " + "INSTANCE_ID" + " = ?";
        deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " = ?";
        restrictedFindByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " = ? and " + "TYPE_ID" + " = ? ";
        findByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " =  ?";
        insertStmtSql = "insert into " + tableName + " values (?,?,?,?,?,?,?)";
        restrictedFindByJNDINameStmtSql = "select * from " + tableName + " where " + jndiNameColumnName + " = ? and " + "TYPE_ID" + " = ? ";
        findByJNDINameStmtSql = "select * from " + tableName + " where " + jndiNameColumnName + " =  ?";
        restrictedFindByExternalJNDINameStmtSql = "select * from " + tableName + " where " + externalJndiNameColumnName + " = ? and " + "TYPE_ID" + " = ? ";
        findByExternalJNDINameStmtSql = "select * from " + tableName + " where " + externalJndiNameColumnName + " =  ?";
    }
}

