/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.agent.AdminAgent;
import com.ibm.ejs.sm.agent.ParamList;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.J2EEResourceProviderConfig;
import com.ibm.ejs.sm.beans.JMSProvider;
import com.ibm.ejs.sm.beans.JMSProviderAttributes;
import com.ibm.ejs.sm.beans.JMSProviderConfig;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.Relation;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.RepositoryObjectName;
import com.ibm.ejs.sm.beans.RepositoryObjectNameElem;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.InvalidJDBCDriverJarFileException;
import com.ibm.ejs.sm.exception.InvalidNameChangeException;
import com.ibm.ejs.sm.exception.InvalidResourceProviderNameException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.RemoteOpException;
import com.ibm.ejs.sm.exception.RequiredAttributeMissingException;
import com.ibm.ejs.sm.exception.ResourceProviderAlreadyInstalledException;
import com.ibm.ejs.sm.exception.ResourceProviderInUseException;
import com.ibm.ejs.sm.exception.ResourceProviderNotInstalledException;
import com.ibm.ejs.sm.util.ObjectCollection;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.act.Act;
import com.ibm.ejs.sm.util.act.ActServerImpl;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import com.ibm.ejs.sm.util.task.AsyncTask;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;

public class JMSProviderBean
extends RepositoryObjectImpl
implements EntityBean {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$JMSProviderBean == null ? (class$com$ibm$ejs$sm$beans$JMSProviderBean = JMSProviderBean.class$("com.ibm.ejs.sm.beans.JMSProviderBean")) : class$com$ibm$ejs$sm$beans$JMSProviderBean));
    private static Integer classLock = new Integer(0);
    private static final String tableName = DBMgr.qualifiedTableName((String)"JMSPROVIDER_TABLE");
    private static final String nameColumnName = "NAME";
    private static final int nameColumnIndex = 3;
    private static final String descriptionColumnName = "DESCRIPTION";
    private static final int descriptionColumnIndex = 4;
    private static final String externalInitialContextFactoryColumnName = "EXTINITCTX_FACTORY";
    private static final int externalInitialContextFactoryColumnIndex = 5;
    private static final String externalProviderURLColumnName = "EXTPROVIDERURL";
    private static final int externalProviderURLColumnIndex = 6;
    private static final String jndiBindingMechanismColumnName = "JNDIBINDMECH";
    private static final int jndiBindingMechanismColumnIndex = 7;
    private static final int numColumns = 7;
    protected static final String myInterfaceName = RepositoryObjectImpl.qualifyClassName("JMSProvider");
    private static final String myClassName = RepositoryObjectImpl.qualifyClassName("JMSProviderBean");
    private static boolean tableCreated = false;
    private static Type myTypeObj = null;
    private static Long myTypeId = null;
    private static final String myHomeName = "JMSProviderHome";
    private static Relation providerNodeRel;
    protected static final String providerNodeRelName = "jmsProviderInstallations";
    private static Relation providerConnectionRel;
    protected static final String providerConnectionRelName = "jmsProviderConnectionRel";
    private static Relation providerDestinationRel;
    protected static final String providerDestinationRelName = "jmsProviderDestinationRel";
    private static final int jmsProviderBeanKeyBase;
    private static final int loadStmtKey;
    private static final int updateStmtKey;
    private static final int deleteStmtKey;
    private static final int insertStmtKey;
    private static final int restrictedFindAllStmtKey;
    private static final int findAllStmtKey;
    private static final int restrictedFindByNameStmtKey;
    private static final int findByNameStmtKey;
    private static final String updateStmtSql;
    private static final String deleteStmtSql;
    private static final String restrictedFindByNameStmtSql;
    private static final String findByNameStmtSql;
    private static final String insertStmtSql;
    private String name;
    private String description;
    private String externalInitialContextFactory;
    private String externalProviderURL;
    private String jndiBindingMechanism;
    private boolean dirty;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$JMSProviderBean;

    public JMSProviderBean() throws RemoteException {
        JMSProviderBean.initializePersistentStore();
        JMSProviderBean.initializeTypeId();
        JMSProviderBean.lookupProviderNodeRel();
        JMSProviderBean.lookupProviderConnectionRel();
        JMSProviderBean.lookupProviderDestinationRel();
    }

    public Long ejbCreate(JMSProviderAttributes jMSProviderAttributes, EJBObject eJBObject) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        try {
            this.externalInitialContextFactory = jMSProviderAttributes.getExternalInitialContextFactory();
            this.externalProviderURL = jMSProviderAttributes.getExternalProviderURL();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)" < ejbCreate -- required attribute missing", (Object)((Object)attributeNotSetException));
            throw new RequiredAttributeMissingException(attributeNotSetException.getMessage());
        }
        try {
            this.validateStringAttr(jMSProviderAttributes.getName());
        }
        catch (Exception exception) {
            throw new RequiredAttributeMissingException("Name");
        }
        try {
            this.validateStringAttr(this.externalInitialContextFactory);
        }
        catch (Exception exception) {
            throw new RequiredAttributeMissingException("ExternalInitialContextFactory");
        }
        try {
            this.validateStringAttr(this.externalProviderURL);
        }
        catch (Exception exception) {
            throw new RequiredAttributeMissingException("ExternalProviderURL");
        }
        try {
            if (this.typeId == null) {
                this.typeId = myTypeId;
            }
            this.id = this.create(this.typeId);
            this.initializeInstanceVariables();
            try {
                this.updateInstanceVariables(jMSProviderAttributes, true);
            }
            catch (InvalidNameChangeException invalidNameChangeException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate: -- invalid data source name", (Object)((Object)invalidNameChangeException));
                throw new InvalidResourceProviderNameException();
            }
            catch (OpException opException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate: ", (Object)((Object)opException));
                throw new RemoteException("", opException);
            }
            this.name = this.name;
            Vector<String> vector = new Vector<String>(7);
            vector.addElement(Utils.getIdString((Long)this.id));
            vector.addElement(Utils.getIdString((Long)this.typeId));
            vector.addElement(this.name);
            vector.addElement(this.description);
            vector.addElement(this.externalInitialContextFactory);
            vector.addElement(this.externalProviderURL);
            vector.addElement(this.jndiBindingMechanism);
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)this.id);
        return this.id;
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException, FinderException {
        Enumeration enumeration;
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll");
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)false, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbFileAll", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)((ObjectCollection)enumeration).getArray());
        return enumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        DBQueryResult dBQueryResult = null;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByName", (Object)string);
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByNameStmtKey, (String)findByNameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByNameStmtKey, (String)restrictedFindByNameStmtSql, vector);
                }
                Long l2 = this.singleFinderEpilogue(dBQueryResult);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName");
                l = l2;
                Object var8_9 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    public void ejbLoad() throws RemoteException {
        Long l = (Long)this.ec.getPrimaryKey();
        Tr.entry((TraceComponent)tc, (String)"ejbLoad", (Object)l);
        DBQueryResult dBQueryResult = null;
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (resultSet == null || !resultSet.next()) {
                    RemoteException remoteException = new RemoteException("", new ObjectNotFoundException());
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                    throw remoteException;
                }
                if (this.setId(resultSet, myTypeId)) {
                    super.ejbLoad();
                    this.name = resultSet.getString(3);
                    this.description = resultSet.getString(4);
                    this.externalInitialContextFactory = resultSet.getString(5);
                    this.externalProviderURL = resultSet.getString(6);
                    this.jndiBindingMechanism = resultSet.getString(7);
                    if (this.name == null) {
                        this.name = new String();
                    }
                    if (this.description == null) {
                        this.description = new String();
                    }
                    if (this.externalInitialContextFactory == null) {
                        this.externalInitialContextFactory = new String();
                    }
                    if (this.externalProviderURL == null) {
                        this.externalProviderURL = new String();
                    }
                    if (this.jndiBindingMechanism == null) {
                        this.jndiBindingMechanism = new String();
                    }
                    this.jndiBindingMechanism = this.jndiBindingMechanism.trim();
                }
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                throw remoteException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
    }

    public void ejbPostCreate(JMSProviderAttributes jMSProviderAttributes, EJBObject eJBObject) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbPostCreate");
        Tr.exit((TraceComponent)tc, (String)"ejbPostCreate");
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        if (this.id == null) {
            this.ejbLoad();
        }
        if (this.narrowRef != null) {
            this.narrowRef.remove();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove");
            return;
        }
        this.checkForProviderUse();
        super.ejbRemove();
        Long l = (Long)this.ec.getPrimaryKey();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)l));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbRemove", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        super.ejbStore();
        if (this.dirty) {
            try {
                Vector<String> vector = new Vector<String>(7);
                vector.addElement(this.name);
                vector.addElement(this.description);
                vector.addElement(this.externalInitialContextFactory);
                vector.addElement(this.externalProviderURL);
                vector.addElement(this.jndiBindingMechanism);
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                throw remoteException;
            }
            Tr.exit((TraceComponent)tc, (String)"ejbStore");
        }
    }

    public Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        Attributes attributes2 = null;
        if (this.narrowRef != null) {
            attributes2 = ((JMSProvider)this.narrowRef).getAttributes(attributes);
        } else {
            this.setVersion(attributes);
            attributes2 = this.readInstanceVariables(attributes);
        }
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return attributes2;
    }

    public RepositoryObjectName getFullName() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getFullName");
        RepositoryObjectName repositoryObjectName = new RepositoryObjectName();
        repositoryObjectName.addElement(new RepositoryObjectNameElem(myHomeName, this.name));
        Tr.exit((TraceComponent)tc, (String)"getFullName");
        return repositoryObjectName;
    }

    public J2EEResourceProviderConfig getResourceProviderConfig() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getResourceProviderConfig");
        JMSProviderConfig jMSProviderConfig = new JMSProviderConfig();
        jMSProviderConfig.setName(this.name);
        jMSProviderConfig.setDescription(this.description);
        jMSProviderConfig.setExternalInitialContextFactory(this.externalInitialContextFactory);
        jMSProviderConfig.setExternalProviderURL(this.externalProviderURL);
        jMSProviderConfig.setJNDIBindingMechanism(this.jndiBindingMechanism);
        Tr.exit((TraceComponent)tc, (String)"getResourceProviderConfig");
        return jMSProviderConfig;
    }

    private void initializeInstanceVariables() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeInstanceVariables");
        JMSProviderAttributes jMSProviderAttributes = (JMSProviderAttributes)RepositoryObjectImpl.getDefaults(myTypeObj);
        try {
            this.description = new String();
            this.externalInitialContextFactory = new String();
            this.externalProviderURL = new String();
            this.jndiBindingMechanism = new String();
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"intializedInstanceVariables", (Object)exception);
            throw new RemoteException("", exception);
        }
        Tr.exit((TraceComponent)tc, (String)"intializedInstanceVariables");
    }

    private static void initializePersistentStore() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (tableCreated) {
                return;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + nameColumnName + DBMgr.mediumStringColumnSpec + " , " + descriptionColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + externalInitialContextFactoryColumnName + DBMgr.mediumStringColumnSpec + " , " + externalProviderURLColumnName + DBMgr.mediumStringColumnSpec + " , " + jndiBindingMechanismColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Integer n2 = classLock;
            synchronized (n2) {
                tableCreated = true;
            }
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"intializePersistentStore");
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
    }

    private static void initializeTypeId() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        Integer n = classLock;
        synchronized (n) {
            if (myTypeId != null) {
                Tr.exit((TraceComponent)tc, (String)"initializeTypeId");
                return;
            }
        }
        JMSProviderAttributes jMSProviderAttributes = new JMSProviderAttributes();
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, jMSProviderAttributes, true);
        Long l = (Long)type.getPrimaryKey();
        Integer n2 = classLock;
        synchronized (n2) {
            myTypeObj = type;
            myTypeId = l;
        }
        Tr.exit((TraceComponent)tc, (String)"intializeTypeId");
    }

    private JMSProviderAttributes readInstanceVariables(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"readInstanceVariables");
        JMSProviderAttributes jMSProviderAttributes = (JMSProviderAttributes)attributes;
        jMSProviderAttributes.setName(this.name);
        jMSProviderAttributes.setFullName(this.getFullName());
        jMSProviderAttributes.setDescription(this.description);
        jMSProviderAttributes.setExternalInitialContextFactory(this.externalInitialContextFactory);
        jMSProviderAttributes.setExternalProviderURL(this.externalProviderURL);
        jMSProviderAttributes.setJNDIBindingMechanism(this.jndiBindingMechanism);
        Tr.exit((TraceComponent)tc, (String)"readInstanceVariables");
        return jMSProviderAttributes;
    }

    public void setAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setAttributes");
        if (this.narrowRef != null) {
            ((JMSProvider)this.narrowRef).setAttributes(attributes);
        } else {
            String string;
            try {
                if (attributes.isSet(Attributes.name)) {
                    string = ((JMSProviderAttributes)attributes).getName();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(RepositoryObjectImpl.nls.getFormattedMessage("invalid.attribute.name", new Object[]{"Name"}, "Invalid value for attribute: {0}"));
            }
            try {
                if (attributes.isSet(JMSProviderAttributes.externalInitialContextFactory)) {
                    string = ((JMSProviderAttributes)attributes).getExternalInitialContextFactory();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(RepositoryObjectImpl.nls.getFormattedMessage("invalid.attribute.name", new Object[]{"ExternalInitialContextFactory"}, "Invalid value for attribute: {0}"));
            }
            try {
                if (attributes.isSet(JMSProviderAttributes.externalProviderURL)) {
                    string = ((JMSProviderAttributes)attributes).getExternalProviderURL();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(RepositoryObjectImpl.nls.getFormattedMessage("invalid.attribute.name", new Object[]{"ExternalProviderURL"}, "Invalid value for attribute: {0}"));
            }
            this.checkAndIncrVersion(attributes);
            this.updateInstanceVariables((JMSProviderAttributes)attributes, false);
        }
        Tr.exit((TraceComponent)tc, (String)"setAttributes");
    }

    private void updateInstanceVariables(JMSProviderAttributes jMSProviderAttributes, boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"updateInstanceVariables");
        this.dirty = true;
        try {
            if (jMSProviderAttributes.isSet(Attributes.name)) {
                String string;
                if (bl) {
                    this.name = "";
                }
                this.validateNameChange(jMSProviderAttributes);
                this.name = string = jMSProviderAttributes.getName();
            }
            if (jMSProviderAttributes.isSet(JMSProviderAttributes.description)) {
                this.description = jMSProviderAttributes.getDescription();
            }
            if (jMSProviderAttributes.isSet(JMSProviderAttributes.externalInitialContextFactory)) {
                this.externalInitialContextFactory = jMSProviderAttributes.getExternalInitialContextFactory();
            }
            if (jMSProviderAttributes.isSet(JMSProviderAttributes.externalProviderURL)) {
                this.externalProviderURL = jMSProviderAttributes.getExternalProviderURL();
            }
            if (jMSProviderAttributes.isSet(JMSProviderAttributes.jndiBindingMechanism)) {
                this.jndiBindingMechanism = jMSProviderAttributes.getJNDIBindingMechanism().trim();
            }
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeNotSetException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)attributeNotSetException);
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeDoesNotExistException));
            throw new RemoteOpException("", (Throwable)attributeDoesNotExistException);
        }
        Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables");
    }

    private void validateNameChange(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"validateNameChange ");
        try {
            if (attributes.isSet(Attributes.name)) {
                String string = attributes.getName();
                if (string.equals(this.name)) {
                    Tr.exit((TraceComponent)tc, (String)"validateNameChange");
                    return;
                }
                try {
                    this.ejbFindByName(string, true);
                    Tr.exit((TraceComponent)tc, (String)"validateNameChange -- duplicate name");
                    throw new InvalidNameChangeException();
                }
                catch (ObjectNotFoundException objectNotFoundException) {}
            }
        }
        catch (InvalidNameChangeException invalidNameChangeException) {
            throw invalidNameChangeException;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"validateNameChange -- unexpected error", (Object)exception);
            throw new RemoteException("", exception);
        }
        Tr.exit((TraceComponent)tc, (String)"validateNameChange");
    }

    public Act install(Node node, String string) throws OpException, RemoteException {
        Tr.entry((TraceComponent)tc, (String)"install");
        Relation relation = JMSProviderBean.lookupProviderNodeRel();
        if (relation.listNames(this.ec.getEJBObject(), node).hasMoreElements()) {
            throw new ResourceProviderAlreadyInstalledException();
        }
        this.addToNamedRelation(relation, node, string);
        Tr.exit((TraceComponent)tc, (String)"install");
        return ActServerImpl.getInstance().scheduleWork(new AsyncTask(){

            public String getName() {
                return "dummyTask";
            }

            public void execute() {
            }
        });
    }

    public Enumeration listInstallations() throws OpException, RemoteException {
        Tr.entry((TraceComponent)tc, (String)"listInstallations ");
        Enumeration enumeration = JMSProviderBean.lookupProviderNodeRel().list(this.ec.getEJBObject(), false);
        Tr.exit((TraceComponent)tc, (String)"listInstallations ");
        return enumeration;
    }

    public String getJarFile(Node node) throws OpException, RemoteException {
        Tr.entry((TraceComponent)tc, (String)"getJarFile ");
        String string = null;
        Enumeration enumeration = JMSProviderBean.lookupProviderNodeRel().listNames(this.ec.getEJBObject(), node);
        if (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
        }
        Tr.exit((TraceComponent)tc, (String)"getJarFile ");
        return string;
    }

    public Act uninstall(Node node) throws OpException, RemoteException {
        Tr.entry((TraceComponent)tc, (String)"uninstall ");
        Relation relation = JMSProviderBean.lookupProviderNodeRel();
        String string = (String)relation.listNames(this.ec.getEJBObject(), node).nextElement();
        if (string == null) {
            throw new ResourceProviderNotInstalledException();
        }
        this.deleteFromRelation(relation, node);
        Tr.exit((TraceComponent)tc, (String)"uninstall");
        return ActServerImpl.getInstance().scheduleWork(new AsyncTask(){

            public String getName() {
                return "dummyTask";
            }

            public void execute() {
            }
        });
    }

    private static Relation lookupProviderConnectionRel() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"lookupProviderConnectionRel");
        Integer n = classLock;
        synchronized (n) {
            if (providerConnectionRel != null) {
                Tr.exit((TraceComponent)tc, (String)"lookupProviderConnectionRel");
                Relation relation = providerConnectionRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.createRelIfNeeded(myTypeObj, "JMSConnectionFactory", providerConnectionRelName, true, true, 2);
        Integer n2 = classLock;
        synchronized (n2) {
            providerConnectionRel = relation;
        }
        Tr.exit((TraceComponent)tc, (String)"lookupProviderConnectionRel");
        return relation;
    }

    private static Relation lookupProviderDestinationRel() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"lookupProviderDestinationRel");
        Integer n = classLock;
        synchronized (n) {
            if (providerDestinationRel != null) {
                Tr.exit((TraceComponent)tc, (String)"lookupProviderDestinationRel");
                Relation relation = providerDestinationRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.createRelIfNeeded(myTypeObj, "JMSDestination", providerDestinationRelName, true, true, 2);
        Integer n2 = classLock;
        synchronized (n2) {
            providerDestinationRel = relation;
        }
        Tr.exit((TraceComponent)tc, (String)"lookupProviderDestinationRel");
        return relation;
    }

    private static Relation lookupProviderNodeRel() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"lookupProviderNodeRel");
        Integer n = classLock;
        synchronized (n) {
            if (providerNodeRel != null) {
                Tr.exit((TraceComponent)tc, (String)"lookupProviderNodeRel");
                Relation relation = providerNodeRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.createRelIfNeeded(myTypeObj, "Node", providerNodeRelName, true, false, 4);
        Integer n2 = classLock;
        synchronized (n2) {
            providerNodeRel = relation;
        }
        Tr.exit((TraceComponent)tc, (String)"lookupProviderNodeRel");
        return relation;
    }

    private void checkForProviderUse() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"checkForProviderUse");
        providerConnectionRel = JMSProviderBean.lookupProviderConnectionRel();
        providerDestinationRel = JMSProviderBean.lookupProviderDestinationRel();
        try {
            Enumeration enumeration = this.listRelatedObjects(providerConnectionRel);
            if (enumeration.hasMoreElements()) {
                throw new ResourceProviderInUseException();
            }
            enumeration = this.listRelatedObjects(providerDestinationRel);
            if (enumeration.hasMoreElements()) {
                throw new ResourceProviderInUseException();
            }
        }
        catch (OpException opException) {
            Tr.exit((TraceComponent)tc, (String)"checkForProviderUse", (Object)((Object)opException));
            throw new RemoteException("", opException);
        }
        Tr.exit((TraceComponent)tc, (String)"checkForDriverUse");
    }

    private void validateStringAttr(String string) throws RemoteException {
        if (string.trim().equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"validateStringAttr failed.");
            }
            throw new RemoteException("validateStringAttr failed.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        jmsProviderBeanKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
        loadStmtKey = jmsProviderBeanKeyBase + 1;
        updateStmtKey = jmsProviderBeanKeyBase + 2;
        deleteStmtKey = jmsProviderBeanKeyBase + 3;
        insertStmtKey = jmsProviderBeanKeyBase + 4;
        restrictedFindAllStmtKey = jmsProviderBeanKeyBase + 5;
        findAllStmtKey = jmsProviderBeanKeyBase + 6;
        restrictedFindByNameStmtKey = jmsProviderBeanKeyBase + 7;
        findByNameStmtKey = jmsProviderBeanKeyBase + 8;
        updateStmtSql = "update " + tableName + " set " + nameColumnName + " = ? , " + descriptionColumnName + " = ? , " + externalInitialContextFactoryColumnName + " = ? , " + externalProviderURLColumnName + " = ? , " + jndiBindingMechanismColumnName + " = ?  " + " where " + "INSTANCE_ID" + " = ?";
        deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " = ?";
        restrictedFindByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " = ? and " + "TYPE_ID" + " = ? ";
        findByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " =  ?";
        insertStmtSql = "insert into " + tableName + " values (?,?,?,?,?,?,?)";
    }

    class NotifyNodeTask
    implements AsyncTask {
        private Node node;
        private AdminAgent nodeAgent;
        private String jarFile;
        private boolean addOrRemove;

        NotifyNodeTask(Node node, AdminAgent adminAgent, String string, boolean bl) {
            this.node = node;
            this.nodeAgent = adminAgent;
            this.jarFile = string;
            this.addOrRemove = bl;
        }

        public String getName() {
            return "notifyNodeTask";
        }

        public void execute() throws RemoteException, OpException {
            Tr.entry((TraceComponent)tc, (String)"notifyNodeTask - execute");
            ParamList paramList = new ParamList(2);
            paramList.addElement(this.jarFile);
            paramList.addElement(this.addOrRemove);
            try {
                this.nodeAgent.invokeActiveObject(this.node.getActiveObjectContainmentPath(), "notifyDriverInstallation", paramList);
            }
            catch (InvalidJDBCDriverJarFileException invalidJDBCDriverJarFileException) {
                Tr.event((TraceComponent)tc, (String)"invalid jar file, removing driver object");
                JMSProviderBean.this.deleteFromRelation(JMSProviderBean.lookupProviderNodeRel(), this.node);
                throw invalidJDBCDriverJarFileException;
            }
            Tr.exit((TraceComponent)tc, (String)"notifyNodeTask - execute");
        }
    }
}

