/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.beans.BinaryAttrSerialization;
import com.ibm.ejs.sm.beans.CloneOnlyAwareConfig;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.NodeAttributes;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class JVMConfig
implements Serializable,
Cloneable,
BinaryAttrSerialization,
CloneOnlyAwareConfig {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$JVMConfig == null ? (class$com$ibm$ejs$sm$beans$JVMConfig = JVMConfig.class$("com.ibm.ejs.sm.beans.JVMConfig")) : class$com$ibm$ejs$sm$beans$JVMConfig));
    private static final long serialVersionUID = 0L;
    private int initialHeapSize;
    private int maxHeapSize;
    private String generatedCommandLineArgs;
    private String[] classpaths;
    private Properties systemProperties;
    private String additionalCommandLineArgs;
    private boolean debugMode;
    private String debugString;
    private boolean runHProf;
    private String hProfArgs;
    private boolean disableJIT;
    private boolean verboseClassLoading;
    private boolean verboseJNI;
    private boolean verboseGC;
    private String bootClasspathReplace;
    private String bootClasspathAppend;
    private String bootClasspathPrepend;
    public static final int DEFAULT_INITIAL_HEAP_SIZE = 0;
    public static final int DEFAULT_MAXIMUM_HEAP_SIZE = 0;
    public static final String DEFAULT_DEBUG_STRING = "";
    public static final String DEFAULT_HPROF_STRING = "";
    public static final int DEFAULT_INITIAL_HEAP_SIZE_400 = 32;
    public static final String INITIAL_HEAP_SIZE_OPTION = "-Xms";
    public static final String MAXIMUM_HEAP_SIZE_OPTION = "-Xmx";
    public static final String HEAP_SIZE_UNITS = "m";
    public static final String BOOTCLASSPATH_REPLACE = "-Xbootclasspath:";
    public static final String BOOTCLASSPATH_APPEND = "-Xbootclasspath/a:";
    public static final String BOOTCLASSPATH_PREPEND = "-Xbootclasspath/p:";
    public static final String VERBOSE_CLASSLOADING = "-verbose";
    public static final String VERBOSE_JNI = "-verbose:jni";
    public static final String VERBOSE_GC = "-verbosegc";
    public static final String DISABLE_JIT = "-Djava.compiler=NONE";
    public static final String CLASSPATH_OPTION = "-classpath";
    public static final String DEBUGMODE_OPTION = "-Xdebug";
    public static final String DEBUGMODE_OPTION2 = "-Xnoagent";
    public static final String RUNHPROF_OPTION = "-Xrunhprof";
    private static JVMConfig cfg;
    public static final String initialHeapSizePropKey = "initialHeapSize";
    public static final String maxHeapSizePropKey = "maxHeapSize";
    public static final String generatedCommandLineArgsPropKey = "generatedCommandLineArgs";
    public static final String classpathsPropKey = "classpaths";
    public static final String systemPropertiesPropKey = "systemProperties";
    public static final String additionalCommandLineArgsPropKey = "additionalCommandLineArgs";
    public static final String debugModePropKey = "debugMode";
    public static final String debugStringPropKey = "debugString";
    public static final String runHProfPropKey = "runHProf";
    public static final String hProfArgsPropKey = "hProfArgs";
    public static final String disableJITPropKey = "disableJIT";
    public static final String verboseClassLoadingPropKey = "verboseClassLoading";
    public static final String verboseJNIPropKey = "verboseJNI";
    public static final String verboseGCPropKey = "verboseGC";
    public static final String bootClasspathReplacePropKey = "bootClasspathReplace";
    public static final String bootClasspathAppendPropKey = "bootClasspathAppend";
    public static final String bootClasspathPrependPropKey = "bootClasspathPrepend";
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$JVMConfig;

    public JVMConfig() {
        this.initialHeapSize = System.getProperty("os.name").equals("OS/400") ? 32 : 0;
        this.maxHeapSize = 0;
        this.generatedCommandLineArgs = "";
        this.classpaths = null;
        this.systemProperties = new Properties();
        this.additionalCommandLineArgs = "";
        this.debugMode = false;
        this.debugString = "";
        this.runHProf = false;
        this.hProfArgs = "";
        this.disableJIT = false;
        this.verboseClassLoading = false;
        this.verboseJNI = false;
        this.verboseGC = false;
        this.bootClasspathReplace = "";
        this.bootClasspathAppend = "";
        this.bootClasspathPrepend = "";
    }

    public JVMConfig(Node node) {
        block4: {
            this();
            if (node == null) {
                return;
            }
            try {
                NodeAttributes nodeAttributes = new NodeAttributes();
                nodeAttributes.request("OsName");
                nodeAttributes = (NodeAttributes)node.getAttributes(nodeAttributes);
                String string = nodeAttributes.getOsName();
                if (string.startsWith("OS/400") || string.startsWith("NetWare")) {
                    this.maxHeapSize = 0;
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Error getting node os name: {0}", (Object)new Object[]{exception});
            }
        }
    }

    public JVMConfig(JVMConfig jVMConfig) {
        this();
        if (jVMConfig != null) {
            Enumeration<?> enumeration;
            this.initialHeapSize = jVMConfig.initialHeapSize;
            this.maxHeapSize = jVMConfig.maxHeapSize;
            if (jVMConfig.generatedCommandLineArgs != null) {
                this.generatedCommandLineArgs = new String(jVMConfig.generatedCommandLineArgs);
            }
            if (jVMConfig.classpaths != null) {
                this.classpaths = new String[jVMConfig.classpaths.length];
                int n = 0;
                while (n < jVMConfig.classpaths.length) {
                    if (jVMConfig.classpaths[n] != null) {
                        this.classpaths[n] = new String(jVMConfig.classpaths[n]);
                    }
                    ++n;
                }
            }
            this.systemProperties = new Properties();
            if (jVMConfig.systemProperties != null && (enumeration = jVMConfig.systemProperties.propertyNames()) != null) {
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.systemProperties.setProperty(string, jVMConfig.systemProperties.getProperty(string));
                }
            }
            if (jVMConfig.additionalCommandLineArgs != null) {
                this.additionalCommandLineArgs = new String(jVMConfig.additionalCommandLineArgs);
            }
            this.debugMode = jVMConfig.debugMode;
            if (jVMConfig.debugString != null) {
                this.debugString = new String(jVMConfig.debugString);
            }
            this.runHProf = jVMConfig.runHProf;
            if (jVMConfig.hProfArgs != null) {
                this.hProfArgs = new String(jVMConfig.hProfArgs);
            }
            this.disableJIT = jVMConfig.disableJIT;
            this.verboseClassLoading = jVMConfig.verboseClassLoading;
            this.verboseJNI = jVMConfig.verboseJNI;
            this.verboseGC = jVMConfig.verboseGC;
            if (jVMConfig.bootClasspathReplace != null) {
                this.bootClasspathReplace = new String(jVMConfig.bootClasspathReplace);
            }
            if (jVMConfig.bootClasspathAppend != null) {
                this.bootClasspathAppend = new String(jVMConfig.bootClasspathAppend);
            }
            if (jVMConfig.bootClasspathPrepend != null) {
                this.bootClasspathPrepend = new String(jVMConfig.bootClasspathPrepend);
            }
        }
    }

    public String[] getJvmPropertiesArray() {
        Object object;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JVMConfig member variables: \ninitialHeapSize = " + this.initialHeapSize + "\n" + "maxHeapSize = " + this.maxHeapSize + "\n" + "generatedCommandLineArgs = " + this.generatedCommandLineArgs + "\n" + "classpaths = " + this.classpaths + "\n" + "systemProperties = " + this.systemProperties + "\n" + "additionalCommandLineArgs = " + this.additionalCommandLineArgs + "\n" + "debugMode = " + this.debugMode + "\n" + "debugString = " + this.debugString + "\n" + "runHProf = " + this.runHProf + "\n" + "hProfArgs = " + this.hProfArgs + "\n" + "disableJIT = " + this.disableJIT + "\n" + "verboseClassLoading = " + this.verboseClassLoading + "\n" + "verboseJNI = " + this.verboseJNI + "\n" + "verboseGC = " + this.verboseGC + "\n" + "bootClasspathReplace = " + this.bootClasspathReplace + "\n" + "bootClasspathAppend = " + this.bootClasspathAppend + "\n" + "bootClasspathPrepend = " + this.bootClasspathPrepend));
        }
        Vector<Object> vector = new Vector<Object>();
        if (this.initialHeapSize != 0) {
            vector.addElement(INITIAL_HEAP_SIZE_OPTION + new Integer(this.initialHeapSize).toString() + HEAP_SIZE_UNITS);
        }
        if (this.maxHeapSize != 0) {
            vector.addElement(MAXIMUM_HEAP_SIZE_OPTION + new Integer(this.maxHeapSize).toString() + HEAP_SIZE_UNITS);
        }
        if (this.bootClasspathReplace != null && !this.bootClasspathReplace.trim().equals("")) {
            vector.addElement(BOOTCLASSPATH_REPLACE + this.bootClasspathReplace);
        }
        if (this.bootClasspathAppend != null && !this.bootClasspathAppend.trim().equals("")) {
            vector.addElement(BOOTCLASSPATH_APPEND + this.bootClasspathAppend);
        }
        if (this.bootClasspathPrepend != null && !this.bootClasspathPrepend.trim().equals("")) {
            vector.addElement(BOOTCLASSPATH_PREPEND + this.bootClasspathPrepend);
        }
        if (this.verboseClassLoading) {
            vector.addElement(VERBOSE_CLASSLOADING);
        }
        if (this.verboseJNI) {
            vector.addElement(VERBOSE_JNI);
        }
        if (this.verboseGC) {
            vector.addElement(VERBOSE_GC);
        }
        if (this.disableJIT) {
            vector.addElement(DISABLE_JIT);
        }
        if (this.debugMode) {
            vector.addElement(DEBUGMODE_OPTION);
            if (!System.getProperty("os.name").equals("OS/400")) {
                vector.addElement(DEBUGMODE_OPTION2);
            }
            if (this.debugString != null && !this.debugString.trim().equals("")) {
                object = new StringTokenizer(this.debugString);
                while (((StringTokenizer)object).hasMoreElements()) {
                    vector.addElement((String)((StringTokenizer)object).nextElement());
                }
            }
        }
        if (this.runHProf) {
            object = "-Xrunhprof";
            if (this.hProfArgs != null && !this.hProfArgs.trim().equals("")) {
                object = (String)object + ":" + this.hProfArgs;
            }
            vector.addElement(object);
        }
        if (this.classpaths != null && this.classpaths.length > 0) {
            vector.addElement(CLASSPATH_OPTION);
            object = new StringBuffer(this.classpaths[0]);
            int n = 1;
            while (n < this.classpaths.length) {
                ((StringBuffer)object).append(File.pathSeparator);
                ((StringBuffer)object).append(this.classpaths[n]);
                ++n;
            }
            vector.addElement(((StringBuffer)object).toString());
        }
        if (this.systemProperties != null) {
            object = null;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JVMConfig: system properties: " + this.systemProperties));
            }
            Enumeration enumeration = ((Hashtable)this.systemProperties).keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("JVMConfig: property: " + (String)object));
                }
                vector.addElement("-D" + (String)object + "=" + ((Hashtable)this.systemProperties).get(object).toString());
            }
        }
        if (this.additionalCommandLineArgs != null && !this.additionalCommandLineArgs.trim().equals("")) {
            object = new StringTokenizer(this.additionalCommandLineArgs);
            String string = null;
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken();
                if (!string.equals(" ") && string.indexOf("\"") != -1) {
                    while (!string.endsWith("\"")) {
                        string = string + " " + ((StringTokenizer)object).nextToken();
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("JVMConfig: additional command line arg: " + string));
                }
                vector.addElement(string);
            }
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JVMConfig properties array : " + vector.toString()));
        }
        return object;
    }

    public static void main(String[] stringArray) {
        System.out.println("JVMConfig test.");
        JVMConfig.printTest("initial constructor");
        cfg = new JVMConfig();
        JVMConfig.printProps();
        JVMConfig.printTest("modify initialHeapSize");
        cfg.setInitialHeapSize(500);
        JVMConfig.printProps();
        JVMConfig.printTest("modify maxHeapSize");
        cfg.setMaxHeapSize(4000);
        JVMConfig.printProps();
        JVMConfig.printTest("set verbose JNI");
        cfg.setVerboseJNI(true);
        JVMConfig.printProps();
        JVMConfig.printTest("set verbose GC");
        cfg.setVerboseGC(true);
        JVMConfig.printProps();
        JVMConfig.printTest("set verbose classloading");
        cfg.setVerboseClassLoading(true);
        JVMConfig.printProps();
        JVMConfig.printTest("reset verbose JNI");
        cfg.setVerboseJNI(false);
        JVMConfig.printProps();
        JVMConfig.printTest("modify run HProf with options");
        cfg.setRunHProf(true);
        cfg.setHProfArgs("heap=sites");
        JVMConfig.printProps();
        JVMConfig.printTest("modify run HProf without options");
        cfg.setRunHProf(true);
        cfg.setHProfArgs("  ");
        JVMConfig.printProps();
        JVMConfig.printTest("reset run HProf");
        cfg.setRunHProf(false);
        JVMConfig.printProps();
        JVMConfig.printTest("reset verbose GC");
        cfg.setVerboseGC(false);
        JVMConfig.printProps();
        JVMConfig.printTest("modify bootClasspathAppend");
        cfg.setBootClasspathAppend("stuffToAppendToBootclasspath");
        JVMConfig.printProps();
        JVMConfig.printTest("modify bootClasspathPrepend");
        cfg.setBootClasspathPrepend("stuffToPrependToBootclasspath");
        JVMConfig.printProps();
        JVMConfig.printTest("modify debugMode");
        cfg.setDebugMode(true);
        cfg.setDebugString("-XsomeDebugString");
        JVMConfig.printProps();
        JVMConfig.printTest("reset bootClasspathAppend");
        cfg.setBootClasspathAppend("  ");
        JVMConfig.printProps();
        JVMConfig.printTest("modify bootClasspathReplace");
        cfg.setBootClasspathReplace("stuffToReplaceBootclasspathWith");
        JVMConfig.printProps();
        JVMConfig.printTest("reset debugMode");
        cfg.setDebugMode(false);
        JVMConfig.printProps();
        JVMConfig.printTest("modify disableJIT");
        cfg.setDisableJIT(true);
        JVMConfig.printProps();
        JVMConfig.printTest("reset bootClasspathPrepend");
        cfg.setBootClasspathPrepend("  ");
        JVMConfig.printProps();
        JVMConfig.printTest("modify additionalCommandLineArgs");
        cfg.setAdditionalCommandLineArgs("-additional properties to add to the command line");
        JVMConfig.printProps();
        JVMConfig.printTest("modify additionalCommandLineArgs");
        cfg.setAdditionalCommandLineArgs("-shortCmd");
        JVMConfig.printProps();
        JVMConfig.printTest("modify classpaths");
        String[] stringArray2 = new String[]{new String("classpath1"), new String("classpath2"), new String("classpath3")};
        cfg.setClasspaths(stringArray2);
        JVMConfig.printProps();
        JVMConfig.printTest("reset classpaths");
        cfg.setClasspaths(null);
        JVMConfig.printProps();
        JVMConfig.printTest("modify systemProperties");
        Properties properties = new Properties();
        ((Hashtable)properties).put("com.ibm.websphere.SomeProp", "1243");
        cfg.setSystemProperties(properties);
        JVMConfig.printProps();
    }

    private static void printProps() {
        String[] stringArray = cfg.getJvmPropertiesArray();
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n]);
            ++n;
        }
        System.out.println(cfg.getGeneratedCommandLineArgs());
    }

    private static void printTest(String string) {
        System.out.println("******* JVMConfig: " + string + " : ");
    }

    public String getAdditionalCommandLineArgs() {
        return this.additionalCommandLineArgs;
    }

    public String getBootClasspathAppend() {
        return this.bootClasspathAppend;
    }

    public String getBootClasspathPrepend() {
        return this.bootClasspathPrepend;
    }

    public String getBootClasspathReplace() {
        return this.bootClasspathReplace;
    }

    public String[] getClasspaths() {
        return this.classpaths;
    }

    public boolean getDebugMode() {
        return this.debugMode;
    }

    public String getDebugString() {
        return this.debugString;
    }

    public boolean getDisableJIT() {
        return this.disableJIT;
    }

    public String getHProfArgs() {
        return this.hProfArgs;
    }

    public int getInitialHeapSize() {
        return this.initialHeapSize;
    }

    public int getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public boolean getRunHProf() {
        return this.runHProf;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public boolean getVerboseClassLoading() {
        return this.verboseClassLoading;
    }

    public boolean getVerboseGC() {
        return this.verboseGC;
    }

    public boolean getVerboseJNI() {
        return this.verboseJNI;
    }

    public void setAdditionalCommandLineArgs(String string) {
        this.additionalCommandLineArgs = string;
        this.getGeneratedCommandLineArgs();
    }

    public void setBootClasspathAppend(String string) {
        this.bootClasspathAppend = string;
        this.getGeneratedCommandLineArgs();
    }

    public void setBootClasspathPrepend(String string) {
        this.bootClasspathPrepend = string;
        this.getGeneratedCommandLineArgs();
    }

    public void setBootClasspathReplace(String string) {
        this.bootClasspathReplace = string;
        this.getGeneratedCommandLineArgs();
    }

    public void setClasspaths(String[] stringArray) {
        this.classpaths = stringArray;
        this.getGeneratedCommandLineArgs();
    }

    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
        if (this.debugMode) {
            this.setDisableJIT(true);
            String string = System.getProperty("java.home");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string + File.separator + ".." + File.separator);
            stringBuffer.append("lib" + File.separator + "tools.jar");
            this.setBootClasspathAppend(stringBuffer.toString());
        }
        this.getGeneratedCommandLineArgs();
    }

    public void setDebugString(String string) {
        this.debugString = string;
        this.getGeneratedCommandLineArgs();
    }

    public void setDisableJIT(boolean bl) {
        this.disableJIT = bl;
        this.getGeneratedCommandLineArgs();
    }

    public void setGeneratedCommandLineArgs(String string) {
        this.generatedCommandLineArgs = string;
    }

    public void setHProfArgs(String string) {
        this.hProfArgs = string;
        this.getGeneratedCommandLineArgs();
    }

    public void setInitialHeapSize(int n) {
        this.initialHeapSize = n;
        this.getGeneratedCommandLineArgs();
    }

    public void setMaxHeapSize(int n) {
        this.maxHeapSize = n;
        this.getGeneratedCommandLineArgs();
    }

    public void setRunHProf(boolean bl) {
        this.runHProf = bl;
        this.getGeneratedCommandLineArgs();
    }

    public void setSystemProperties(Properties properties) {
        this.systemProperties = properties;
        this.getGeneratedCommandLineArgs();
    }

    public void setVerboseClassLoading(boolean bl) {
        this.verboseClassLoading = bl;
        this.getGeneratedCommandLineArgs();
    }

    public void setVerboseGC(boolean bl) {
        this.verboseGC = bl;
        this.getGeneratedCommandLineArgs();
    }

    public void setVerboseJNI(boolean bl) {
        this.verboseJNI = bl;
        this.getGeneratedCommandLineArgs();
    }

    public Object clone() {
        JVMConfig jVMConfig = new JVMConfig();
        jVMConfig.initialHeapSize = this.initialHeapSize;
        jVMConfig.maxHeapSize = this.maxHeapSize;
        jVMConfig.debugMode = this.debugMode;
        jVMConfig.runHProf = this.runHProf;
        jVMConfig.disableJIT = this.disableJIT;
        jVMConfig.verboseClassLoading = this.verboseClassLoading;
        jVMConfig.verboseJNI = this.verboseJNI;
        jVMConfig.verboseGC = this.verboseGC;
        jVMConfig.generatedCommandLineArgs = this.cloneString(this.generatedCommandLineArgs);
        jVMConfig.additionalCommandLineArgs = this.cloneString(this.additionalCommandLineArgs);
        jVMConfig.debugString = this.cloneString(this.debugString);
        jVMConfig.hProfArgs = this.cloneString(this.hProfArgs);
        jVMConfig.bootClasspathReplace = this.cloneString(this.bootClasspathReplace);
        jVMConfig.bootClasspathAppend = this.cloneString(this.bootClasspathAppend);
        jVMConfig.bootClasspathPrepend = this.cloneString(this.bootClasspathPrepend);
        if (this.classpaths != null) {
            jVMConfig.classpaths = new String[this.classpaths.length];
            int n = 0;
            while (n < this.classpaths.length) {
                jVMConfig.classpaths[n] = new String(this.classpaths[n]);
                ++n;
            }
        }
        if (this.systemProperties != null) {
            jVMConfig.systemProperties = (Properties)((Hashtable)this.systemProperties).clone();
        }
        return jVMConfig;
    }

    public String cloneString(String string) {
        String string2 = null;
        if (string != null) {
            string2 = new String(string);
        }
        return string2;
    }

    public String getGeneratedCommandLineArgs() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getJvmPropertiesArray();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(" ");
            ++n;
        }
        this.generatedCommandLineArgs = stringBuffer.toString();
        return this.generatedCommandLineArgs;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        ((Hashtable)properties).put(initialHeapSizePropKey, new Integer(this.initialHeapSize));
        ((Hashtable)properties).put(maxHeapSizePropKey, new Integer(this.maxHeapSize));
        if (this.generatedCommandLineArgs != null) {
            ((Hashtable)properties).put(generatedCommandLineArgsPropKey, this.generatedCommandLineArgs);
        }
        if (this.classpaths != null) {
            ((Hashtable)properties).put(classpathsPropKey, this.classpaths);
        }
        if (this.systemProperties != null) {
            ((Hashtable)properties).put(systemPropertiesPropKey, this.systemProperties);
        }
        if (this.additionalCommandLineArgs != null) {
            ((Hashtable)properties).put(additionalCommandLineArgsPropKey, this.additionalCommandLineArgs);
        }
        ((Hashtable)properties).put(debugModePropKey, new Boolean(this.debugMode));
        if (this.debugString != null) {
            ((Hashtable)properties).put(debugStringPropKey, this.debugString);
        }
        ((Hashtable)properties).put(runHProfPropKey, new Boolean(this.runHProf));
        if (this.hProfArgs != null) {
            ((Hashtable)properties).put(hProfArgsPropKey, this.hProfArgs);
        }
        ((Hashtable)properties).put(disableJITPropKey, new Boolean(this.disableJIT));
        ((Hashtable)properties).put(verboseClassLoadingPropKey, new Boolean(this.verboseClassLoading));
        ((Hashtable)properties).put(verboseJNIPropKey, new Boolean(this.verboseJNI));
        ((Hashtable)properties).put(verboseGCPropKey, new Boolean(this.verboseGC));
        if (this.bootClasspathReplace != null) {
            ((Hashtable)properties).put(bootClasspathReplacePropKey, this.bootClasspathReplace);
        }
        if (this.bootClasspathAppend != null) {
            ((Hashtable)properties).put(bootClasspathAppendPropKey, this.bootClasspathAppend);
        }
        if (this.bootClasspathPrepend != null) {
            ((Hashtable)properties).put(bootClasspathPrependPropKey, this.bootClasspathPrepend);
        }
        return properties;
    }

    public void fromProperties(Properties properties) {
        if (((Hashtable)properties).containsKey(initialHeapSizePropKey)) {
            this.initialHeapSize = (Integer)((Hashtable)properties).get(initialHeapSizePropKey);
        }
        if (((Hashtable)properties).containsKey(maxHeapSizePropKey)) {
            this.maxHeapSize = (Integer)((Hashtable)properties).get(maxHeapSizePropKey);
        }
        if (((Hashtable)properties).containsKey(generatedCommandLineArgsPropKey)) {
            this.generatedCommandLineArgs = (String)((Hashtable)properties).get(generatedCommandLineArgsPropKey);
        }
        if (((Hashtable)properties).containsKey(classpathsPropKey)) {
            this.classpaths = (String[])((Hashtable)properties).get(classpathsPropKey);
        }
        if (((Hashtable)properties).containsKey(systemPropertiesPropKey)) {
            this.systemProperties = (Properties)((Hashtable)properties).get(systemPropertiesPropKey);
        }
        if (((Hashtable)properties).containsKey(additionalCommandLineArgsPropKey)) {
            this.additionalCommandLineArgs = (String)((Hashtable)properties).get(additionalCommandLineArgsPropKey);
        }
        if (((Hashtable)properties).containsKey(debugModePropKey)) {
            this.debugMode = (Boolean)((Hashtable)properties).get(debugModePropKey);
        }
        if (((Hashtable)properties).containsKey(debugStringPropKey)) {
            this.debugString = (String)((Hashtable)properties).get(debugStringPropKey);
        }
        if (((Hashtable)properties).containsKey(runHProfPropKey)) {
            this.runHProf = (Boolean)((Hashtable)properties).get(runHProfPropKey);
        }
        if (((Hashtable)properties).containsKey(hProfArgsPropKey)) {
            this.hProfArgs = (String)((Hashtable)properties).get(hProfArgsPropKey);
        }
        if (((Hashtable)properties).containsKey(disableJITPropKey)) {
            this.disableJIT = (Boolean)((Hashtable)properties).get(disableJITPropKey);
        }
        if (((Hashtable)properties).containsKey(verboseClassLoadingPropKey)) {
            this.verboseClassLoading = (Boolean)((Hashtable)properties).get(verboseClassLoadingPropKey);
        }
        if (((Hashtable)properties).containsKey(verboseJNIPropKey)) {
            this.verboseJNI = (Boolean)((Hashtable)properties).get(verboseJNIPropKey);
        }
        if (((Hashtable)properties).containsKey(verboseGCPropKey)) {
            this.verboseGC = (Boolean)((Hashtable)properties).get(verboseGCPropKey);
        }
        if (((Hashtable)properties).containsKey(bootClasspathReplacePropKey)) {
            this.bootClasspathReplace = (String)((Hashtable)properties).get(bootClasspathReplacePropKey);
        }
        if (((Hashtable)properties).containsKey(bootClasspathAppendPropKey)) {
            this.bootClasspathAppend = (String)((Hashtable)properties).get(bootClasspathAppendPropKey);
        }
        if (((Hashtable)properties).containsKey(bootClasspathPrependPropKey)) {
            this.bootClasspathPrepend = (String)((Hashtable)properties).get(bootClasspathPrependPropKey);
        }
    }

    public String toString() {
        return ((Hashtable)this.toProperties()).toString();
    }

    public Vector retrieveCloneOnlyAttributeNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("Classpaths");
        vector.add("DebugMode");
        vector.add("DebugString");
        vector.add("VerboseClassLoading");
        vector.add("VerboseGC");
        vector.add("VerboseJNI");
        vector.add("BootClasspathReplace");
        vector.add("BootClasspathAppend");
        vector.add("BootClasspathPrepend");
        vector.add("DisableJIT");
        vector.add("SystemProperties");
        return vector;
    }

    public Vector retrieveCloneOnlyAttributeGetters() {
        Vector<String> vector = new Vector<String>();
        vector.add("getClasspaths");
        vector.add("getDebugMode");
        vector.add("getDebugString");
        vector.add("getVerboseClassLoading");
        vector.add("getVerboseGC");
        vector.add("getVerboseJNI");
        vector.add("getBootClasspathReplace");
        vector.add("getBootClasspathAppend");
        vector.add("getBootClasspathPrepend");
        vector.add("getDisableJIT");
        vector.add("getSystemProperties");
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

