/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.active.ActiveObjectConfig;
import com.ibm.ejs.sm.agent.ContainmentPath;
import com.ibm.ejs.sm.agent.ContainmentPathElem;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.LiveObjectAttributes;
import com.ibm.ejs.sm.beans.LiveRepositoryObject;
import com.ibm.ejs.sm.beans.Relation;
import com.ibm.ejs.sm.beans.RelationAttributes;
import com.ibm.ejs.sm.beans.RelationHome;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.beans.TypeAttributes;
import com.ibm.ejs.sm.beans.TypeHome;
import com.ibm.ejs.sm.exception.ActiveObjectStoppedException;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.EmptyObjectGroupStartException;
import com.ibm.ejs.sm.exception.NonEmptyObjectGroupRemoveException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.RunningObjectRemoveException;
import com.ibm.ejs.sm.util.ObjectCollection;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.act.Act;
import com.ibm.ejs.sm.util.act.ActServerImpl;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import com.ibm.ejs.sm.util.task.AsyncTask;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.rmi.PortableRemoteObject;

public class LiveObjectGroupImpl
extends RepositoryObjectImpl {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$LiveObjectGroupImpl == null ? (class$com$ibm$ejs$sm$beans$LiveObjectGroupImpl = LiveObjectGroupImpl.class$("com.ibm.ejs.sm.beans.LiveObjectGroupImpl")) : class$com$ibm$ejs$sm$beans$LiveObjectGroupImpl), (String)"", (String)"com.ibm.ejs.resources.RepositoryStrings");
    private static Integer classLock = new Integer(0);
    private static String tableName = DBMgr.qualifiedTableName((String)"LIVE_OBJ_GRP_TBL");
    private static final String desiredStateColumnName = "DESIRED_STATE";
    private static final int desiredStateColumnIndex = 3;
    private static final String startTimeColumnName = "START_TIME";
    private static final int startTimeColumnIndex = 4;
    private static final int numColumns = 4;
    private static boolean tableCreated = false;
    private static final int liveObjectGroupKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
    private static final int loadStmtKey = liveObjectGroupKeyBase + 1;
    private static final int updateStmtKey = liveObjectGroupKeyBase + 2;
    private static final int deleteStmtKey = liveObjectGroupKeyBase + 3;
    private static final int insertStmtKey = liveObjectGroupKeyBase + 4;
    private static final String updateStmtSql = "update " + tableName + " set " + "DESIRED_STATE" + " =  ? ," + "START_TIME" + " =  ? " + " where " + "INSTANCE_ID" + " = ?";
    private static final String deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " =  ?";
    private static String insertStmtSql = "insert into " + tableName + " values(?,?,?,?)";
    private int desiredState;
    private long startTime;
    private boolean dirty;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$LiveObjectGroupImpl;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$Relation;

    public Act start() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"start");
        this.dirty = true;
        this.desiredState = 3;
        this.startTime = System.currentTimeMillis();
        TypeHome typeHome = (TypeHome)RepositoryObjectImpl.getHome("TypeHome");
        Enumeration enumeration = this.getRelationshipsWithSelfAsSource();
        Act act = null;
        while (enumeration.hasMoreElements()) {
            Relation relation = (Relation)enumeration.nextElement();
            if (!this.checkForLiveObjectGroupRel(relation)) continue;
            Enumeration enumeration2 = this.listRelatedObjects(relation);
            while (enumeration2.hasMoreElements()) {
                LiveRepositoryObject liveRepositoryObject = (LiveRepositoryObject)enumeration2.nextElement();
                act = liveRepositoryObject.start();
            }
        }
        Tr.exit((TraceComponent)tc, (String)"start");
        if (act == null) {
            throw new EmptyObjectGroupStartException();
        }
        return act;
    }

    public Act stop(int n) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"stop");
        this.dirty = true;
        this.desiredState = 5;
        this.startTime = 0L;
        TypeHome typeHome = (TypeHome)RepositoryObjectImpl.getHome("TypeHome");
        Enumeration enumeration = this.getRelationshipsWithSelfAsSource();
        Act act = null;
        while (enumeration.hasMoreElements()) {
            Relation relation = (Relation)enumeration.nextElement();
            if (!this.checkForLiveObjectGroupRel(relation)) continue;
            Enumeration enumeration2 = this.listRelatedObjects(relation);
            while (enumeration2.hasMoreElements()) {
                LiveRepositoryObject liveRepositoryObject = (LiveRepositoryObject)enumeration2.nextElement();
                try {
                    act = liveRepositoryObject.stop(n);
                }
                catch (ActiveObjectStoppedException activeObjectStoppedException) {
                    Tr.event((TraceComponent)tc, (String)"Live object is already stopped. Ignoring.", (Object)liveRepositoryObject);
                }
            }
        }
        Tr.exit((TraceComponent)tc, (String)"stop");
        if (act == null) {
            act = this.scheduleDummyTask();
        }
        return act;
    }

    public Act forceStop() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"forceStop");
        Tr.exit((TraceComponent)tc, (String)"forceStop");
        return this.stop(-1);
    }

    public ActiveObjectConfig startingContainerObject() throws RemoteException, OpException {
        throw new RemoteException(RepositoryObjectImpl.nls.getString("liveogi.notimplemented.exception", "ADMR2100E: Operation not implemented, but you should not see this exception"));
    }

    public void stoppingContainerObject() throws RemoteException, OpException {
        throw new RemoteException(RepositoryObjectImpl.nls.getString("liveogi.notimplemented.exception", "ADMR2100E: Operation not implemented, but you should not see this exception"));
    }

    public Act startingContainedObject(ActiveObjectConfig activeObjectConfig) throws RemoteException, OpException {
        throw new RemoteException(RepositoryObjectImpl.nls.getString("liveogi.notimplemented.exception", "ADMR2100E: Operation not implemented, but you should not see this exception"));
    }

    public Act stoppingContainedObject(int n) throws RemoteException, OpException {
        throw new RemoteException(RepositoryObjectImpl.nls.getString("liveogi.notimplemented.exception", "ADMR2100E: Operation not implemented, but you should not see this exception"));
    }

    public ContainmentPath getActiveObjectContainmentPath() throws RemoteException, OpException {
        return new ContainmentPath();
    }

    public int getDesiredState() throws RemoteException, OpException {
        return this.desiredState;
    }

    public int getCurrentState() throws RemoteException, OpException {
        int n = this.desiredState;
        TypeHome typeHome = (TypeHome)RepositoryObjectImpl.getHome("TypeHome");
        Enumeration enumeration = this.getRelationshipsWithSelfAsSource();
        while (enumeration.hasMoreElements()) {
            LiveRepositoryObject liveRepositoryObject;
            Enumeration enumeration2;
            Relation relation = (Relation)enumeration.nextElement();
            if (!this.checkForLiveObjectGroupRel(relation) || !(enumeration2 = this.listRelatedObjects(relation)).hasMoreElements() || (liveRepositoryObject = (LiveRepositoryObject)enumeration2.nextElement()).getDesiredState() != this.desiredState || (n = liveRepositoryObject.getCurrentState()) == this.desiredState) continue;
            return n;
        }
        return n;
    }

    public void stopCompleted() throws RemoteException {
        throw new RemoteException(RepositoryObjectImpl.nls.getString("liveogi.notimplemented.exception", "ADMR2100E: Operation not implemented, but you should not see this exception"));
    }

    public void startCompleted() throws RemoteException, OpException {
        throw new RemoteException(RepositoryObjectImpl.nls.getString("liveogi.notimplemented.exception", "ADMR2100E: Operation not implemented, but you should not see this exception"));
    }

    public ContainmentPathElem getActiveObjectName() throws RemoteException, OpException {
        throw new RemoteException(RepositoryObjectImpl.nls.getString("liveogi.notimplemented.exception", "ADMR2100E: Operation not implemented, but you should not see this exception"));
    }

    public ActiveObjectConfig getConfig() throws RemoteException, OpException {
        throw new RemoteException(RepositoryObjectImpl.nls.getString("liveogi.notimplemented.exception", "ADMR2100E: Operation not implemented, but you should not see this exception"));
    }

    public boolean getStopConfirmed() throws RemoteException {
        throw new RemoteException(RepositoryObjectImpl.nls.getString("liveogi.notimplemented.exception", "ADMR2100E: Operation not implemented, but you should not see this exception"));
    }

    public void confirmContainedObjectStops() throws RemoteException {
        throw new RemoteException(RepositoryObjectImpl.nls.getString("liveogi.notimplemented.exception", "ADMR2100E: Operation not implemented, but you should not see this exception"));
    }

    public ActiveObjectConfig getStartedConfigTree() throws RemoteException, OpException {
        throw new RemoteException(RepositoryObjectImpl.nls.getString("liveogi.notimplemented.exception", "ADMR2100E: Operation not implemented, but you should not see this exception"));
    }

    public Act reconfirmContainedObjectsStop() throws RemoteException, OpException {
        throw new RemoteException(RepositoryObjectImpl.nls.getString("liveogi.notimplemented.exception", "ADMR2100E: Operation not implemented, but you should not see this exception"));
    }

    public void ejbLoad() throws RemoteException {
        Long l = (Long)this.ec.getPrimaryKey();
        Tr.entry((TraceComponent)tc, (String)"ejbLoad");
        super.ejbLoad();
        DBQueryResult dBQueryResult = null;
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (!resultSet.next()) {
                    RemoteException remoteException = new RemoteException("", new ObjectNotFoundException());
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                    throw remoteException;
                }
                this.desiredState = resultSet.getInt(3);
                this.startTime = Long.parseLong(resultSet.getString(4));
                this.dirty = false;
                Tr.exit((TraceComponent)tc, (String)"ejbLoad");
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                throw remoteException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        super.ejbStore();
        if (this.dirty) {
            try {
                Vector<Object> vector = new Vector<Object>(3);
                vector.addElement(new Integer(this.desiredState));
                vector.addElement(Long.toString(this.startTime));
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                Tr.event((TraceComponent)tc, (String)"sqlException: ", (Object)sQLException);
                RemoteException remoteException = new RemoteException("", new ObjectNotFoundException());
                Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                throw remoteException;
            }
        }
        Tr.exit((TraceComponent)tc, (String)"ejbStore");
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        this.removeCheck();
        super.ejbRemove();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)this.id));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            throw new RemoteException("", sQLException);
        }
    }

    public Long ejbCreate() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        this.desiredState = 5;
        Vector<Object> vector = new Vector<Object>(4);
        vector.addElement(Utils.getIdString((Long)this.id));
        vector.addElement(Utils.getIdString((Long)this.typeId));
        vector.addElement(new Integer(this.desiredState));
        vector.addElement(Long.toString(0L));
        try {
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate");
        return this.id;
    }

    public LiveObjectAttributes getAttributes(LiveObjectAttributes liveObjectAttributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        LiveObjectAttributes liveObjectAttributes2 = liveObjectAttributes;
        if (liveObjectAttributes.isRequested("DesiredState")) {
            liveObjectAttributes2.setGeneric("DesiredState", new Integer(this.getDesiredState()));
        }
        if (liveObjectAttributes.isRequested("CurrentState")) {
            liveObjectAttributes2.setGeneric("CurrentState", new Integer(this.getCurrentState()));
        }
        if (liveObjectAttributes.isRequested("StartTime")) {
            if (this.desiredState == 5) {
                liveObjectAttributes2.setGeneric("StartTime", new Long(0L));
            } else {
                liveObjectAttributes2.setGeneric("StartTime", new Long(this.startTime));
            }
        }
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return liveObjectAttributes2;
    }

    public LiveObjectGroupImpl() throws RemoteException {
        LiveObjectGroupImpl.initializePersistentStore();
    }

    private boolean checkForLiveObjectGroupRel(Relation relation) throws RemoteException, OpException {
        Object object;
        Serializable serializable;
        Tr.entry((TraceComponent)tc, (String)"checkforLiveObjectGroupRel");
        String string = null;
        try {
            serializable = new RelationAttributes();
            serializable.request("TargetType");
            serializable = (RelationAttributes)relation.getAttributes((Attributes)serializable);
            object = serializable.getTargetType();
            TypeAttributes typeAttributes = new TypeAttributes();
            typeAttributes.request("InterfaceClass");
            typeAttributes = (TypeAttributes)object.getAttributes(typeAttributes);
            string = typeAttributes.getInterfaceClass();
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"checkforLiveObjectGroupRel", (Object)((Object)attributeDoesNotExistException));
            throw new RemoteException("", attributeDoesNotExistException);
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"checkforLiveObjectGroupRel", (Object)((Object)attributeNotSetException));
            throw new RemoteException("", attributeNotSetException);
        }
        try {
            serializable = Class.forName(string);
            object = Class.forName("com.ibm.ejs.sm.beans.LiveRepositoryObject");
            if (((Class)object).isAssignableFrom((Class<?>)serializable)) {
                Tr.exit((TraceComponent)tc, (String)"checkforLiveObjectGroupRel -- true");
                return true;
            }
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"checkforLiveObjectGroupRel", (Object)exception);
            throw new RemoteException("", exception);
        }
        Tr.exit((TraceComponent)tc, (String)"checkforLiveObjectGroupRel -- false");
        return false;
    }

    private void removeCheck() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"removeCheck");
        if (this.desiredState == 5) {
            Enumeration enumeration = null;
            enumeration = this.getRelationshipsWithSelfAsSource();
            while (enumeration.hasMoreElements()) {
                Relation relation = (Relation)enumeration.nextElement();
                try {
                    if (!this.checkForLiveObjectGroupRel(relation)) continue;
                    Enumeration enumeration2 = null;
                    enumeration2 = this.listRelatedObjects(relation);
                    if (!enumeration2.hasMoreElements()) continue;
                    Tr.exit((TraceComponent)tc, (String)"removeCheck -- non empty object group remove");
                    throw new NonEmptyObjectGroupRemoveException();
                }
                catch (OpException opException) {
                    throw new RemoteException("", opException);
                }
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"liveroi.running.object.remove.error");
            Tr.exit((TraceComponent)tc, (String)"removeCheck -- running object remove exception");
            throw new RunningObjectRemoveException();
        }
        Tr.exit((TraceComponent)tc, (String)"removeCheck -- success");
    }

    private static void initializePersistentStore() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (tableCreated) {
                return;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + desiredStateColumnName + " integer not null , " + startTimeColumnName + DBMgr.idColumnSpec + " , " + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Integer n2 = classLock;
            synchronized (n2) {
                tableCreated = true;
            }
            Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"initializePersistentStore", (Object)remoteException);
        }
    }

    private Enumeration getRelationshipsWithSelfAsSource() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"getRelationshipsWithSelfAsSource");
        RelationHome relationHome = (RelationHome)RepositoryObjectImpl.getHome("RelationHome");
        TypeHome typeHome = (TypeHome)RepositoryObjectImpl.getHome("TypeHome");
        try {
            Type type = typeHome.findByPrimaryKey(RepositoryObjectImpl.getTypeId(this.id));
            Enumeration enumeration = relationHome.findBySource(type, true);
            ObjectCollection objectCollection = new ObjectCollection();
            while (enumeration.hasMoreElements()) {
                objectCollection.addElement(PortableRemoteObject.narrow(enumeration.nextElement(), (Class)(class$com$ibm$ejs$sm$beans$Relation == null ? LiveObjectGroupImpl.class$("com.ibm.ejs.sm.beans.Relation") : class$com$ibm$ejs$sm$beans$Relation)));
            }
            Tr.exit((TraceComponent)tc, (String)"getRelationshipsWithSelfAsSource", (Object)objectCollection);
            return objectCollection;
        }
        catch (RemoteException remoteException) {
            Tr.exit((TraceComponent)tc, (String)"getRelationshipsWithSelfAsSource", (Object)remoteException);
            throw remoteException;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"getRelationshipsWithSelfAsSource", (Object)exception);
            throw new RemoteException("", exception);
        }
    }

    Act scheduleDummyTask() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"sceduleDummyTask");
        ActServerImpl actServerImpl = ActServerImpl.getInstance();
        Act act = actServerImpl.scheduleWork((AsyncTask)new dummyTask());
        Tr.exit((TraceComponent)tc, (String)"sceduleDummyTask", (Object)act);
        return act;
    }

    protected void setDesiredState(int n) {
        this.desiredState = n;
        this.dirty = true;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected void setStartTime(long l) {
        this.startTime = l;
        this.dirty = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class dummyTask
    implements AsyncTask {
        dummyTask() {
        }

        public String getName() {
            return "dummyTask";
        }

        public void execute() throws RemoteException, OpException {
        }
    }
}

