/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.active.ActiveObjectConfig;
import com.ibm.ejs.sm.agent.AdminAgent;
import com.ibm.ejs.sm.agent.ContainmentPath;
import com.ibm.ejs.sm.agent.ContainmentPathElem;
import com.ibm.ejs.sm.agent.ParamList;
import com.ibm.ejs.sm.beans.LiveObjectAttributes;
import com.ibm.ejs.sm.beans.LiveRepositoryObject;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.RepositoryObject;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.exception.ActiveObjectInitializingException;
import com.ibm.ejs.sm.exception.ActiveObjectStoppedException;
import com.ibm.ejs.sm.exception.ActiveObjectTerminatingException;
import com.ibm.ejs.sm.exception.ObjectWithContainedObjectsRemoveException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.RunningObjectRemoveException;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.act.Act;
import com.ibm.ejs.sm.util.act.ActServerImpl;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import com.ibm.ejs.sm.util.task.AsyncTask;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import org.omg.CosTransactions.Control;

public class LiveRepositoryObjectImpl
extends RepositoryObjectImpl {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$LiveRepositoryObjectImpl == null ? (class$com$ibm$ejs$sm$beans$LiveRepositoryObjectImpl = LiveRepositoryObjectImpl.class$("com.ibm.ejs.sm.beans.LiveRepositoryObjectImpl")) : class$com$ibm$ejs$sm$beans$LiveRepositoryObjectImpl), (String)"", (String)"com.ibm.ejs.resources.RepositoryStrings");
    private static Integer classLock = new Integer(0);
    private static String tableName = DBMgr.qualifiedTableName((String)"LIVE_OBJ_TABLE");
    private static final String desiredStateColumnName = "DESIRED_STATE";
    private static final int desiredStateColumnIndex = 3;
    private static final String stopConfirmedColumnName = "STOP_CONFIRMED";
    private static final int stopConfirmedColumnIndex = 4;
    private static final String epochColumnName = "EPOCH";
    private static final int epochColumnIndex = 5;
    private static final String versionColumnName = "VERSION";
    private static final int versionColumnIndex = 6;
    private static final String implicitStartColumnName = "IMPLICIT_START";
    private static final int implicitStartColumnIndex = 7;
    private static final int numColumns = 7;
    private static boolean tableCreated = false;
    private static final int liveObjectKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
    private static final int loadStmtKey = liveObjectKeyBase + 1;
    private static final int updateStmtKey = liveObjectKeyBase + 2;
    private static final int deleteStmtKey = liveObjectKeyBase + 3;
    private static final int insertStmtKey = liveObjectKeyBase + 4;
    private static final String updateStmtSql = "update " + tableName + " set " + "DESIRED_STATE" + " =  ? ," + "STOP_CONFIRMED" + " =  ? ," + "EPOCH" + " =  ? ," + "VERSION" + " =  ? ," + "IMPLICIT_START" + " =  ? " + " where " + "INSTANCE_ID" + " = ?";
    private static final String deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " =  ?";
    private static String insertStmtSql = "insert into " + tableName + " values(?,?,?,?,?,?,?)";
    private int desiredState;
    private boolean stopConfirmed;
    private int epoch;
    private int version;
    private boolean implicitStart;
    private boolean dirty;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$LiveRepositoryObjectImpl;

    public Act start() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"start");
        this.startPrologue();
        ActiveObjectConfig activeObjectConfig = this.startSelf(false);
        this.startContainedObjects(activeObjectConfig);
        Act act = this.startContainingObject(activeObjectConfig);
        if (act == null) {
            act = this.scheduleStartTask(activeObjectConfig);
        }
        Tr.exit((TraceComponent)tc, (String)"start");
        return act;
    }

    public Act stop(int n) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"stop");
        try {
            this.stopSelf();
        }
        catch (ActiveObjectStoppedException activeObjectStoppedException) {
            if (n == -1) {
                Tr.event((TraceComponent)tc, (String)"ignoring stopped exception");
            }
            throw activeObjectStoppedException;
        }
        this.stopContainedObjects();
        Act act = this.stopContainingObject(n);
        if (act == null) {
            act = this.scheduleStopTask(n);
        }
        Tr.exit((TraceComponent)tc, (String)"stop");
        return act;
    }

    public Act stopSelfAndContainedObjects(int n) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"stopSelfAndContainedObjects");
        try {
            this.stopSelf();
        }
        catch (ActiveObjectStoppedException activeObjectStoppedException) {
            if (n == -1) {
                Tr.event((TraceComponent)tc, (String)"ignoring stopped exception");
            }
            throw activeObjectStoppedException;
        }
        this.stopContainedObjects();
        Act act = this.scheduleStopTask(n);
        Tr.exit((TraceComponent)tc, (String)"stopSelfAndContainedObjects");
        return act;
    }

    public Act forceStop() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"forceStop");
        Tr.exit((TraceComponent)tc, (String)"forceStop");
        return this.stop(-1);
    }

    protected void startPrologue() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"startPrologue");
        Tr.exit((TraceComponent)tc, (String)"startPrologue");
    }

    public ActiveObjectConfig startingContainerObject() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"startingContainerObject");
        ActiveObjectConfig activeObjectConfig = this.startSelf(true);
        this.startContainedObjects(activeObjectConfig);
        Tr.exit((TraceComponent)tc, (String)"startingContainerObject");
        return activeObjectConfig;
    }

    public void stoppingContainerObject() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"stoppingContainerObject");
        try {
            this.stopSelf();
        }
        catch (ActiveObjectStoppedException activeObjectStoppedException) {
            Tr.exit((TraceComponent)tc, (String)"stoppingContainerObject -- obj already stopped");
            return;
        }
        this.stopContainedObjects();
        Tr.exit((TraceComponent)tc, (String)"stoppingContainerObject");
    }

    public Act startingContainedObject(ActiveObjectConfig activeObjectConfig) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"startingContainedObject");
        if (this.desiredState == 5 && !this.stopConfirmed) {
            Tr.exit((TraceComponent)tc, (String)"startingContainedObject -- terminating exception");
            throw new ActiveObjectTerminatingException();
        }
        if (this.desiredState == 3) {
            Tr.exit((TraceComponent)tc, (String)"startingContainedObject -- already started -- returning null");
            return null;
        }
        ActiveObjectConfig activeObjectConfig2 = this.startSelf(true);
        Tr.event((TraceComponent)tc, (String)"change obj state to running, epoch is ", (Object)new Integer(this.epoch));
        activeObjectConfig2.addContainedConfig(activeObjectConfig);
        Act act = this.startContainingObject(activeObjectConfig2);
        if (act == null) {
            act = this.scheduleStartTask(activeObjectConfig2);
        }
        Tr.exit((TraceComponent)tc, (String)"startingContainedObject ");
        return act;
    }

    public Act stoppingContainedObject(int n) throws RemoteException, OpException {
        LiveRepositoryObject liveRepositoryObject;
        Tr.entry((TraceComponent)tc, (String)"stoppingContainedObject");
        if (!this.implicitStart) {
            Tr.exit((TraceComponent)tc, (String)"stoppingContainedObject no implicit start -- returning null");
            return null;
        }
        if (this.desiredState == 5 && this.stopConfirmed) {
            Tr.exit((TraceComponent)tc, (String)"stoppingContainedObject object already stopped -- returning null");
            return null;
        }
        Enumeration enumeration = this.listContainedObjects();
        while (enumeration.hasMoreElements()) {
            liveRepositoryObject = (LiveRepositoryObject)enumeration.nextElement();
            if (liveRepositoryObject.getDesiredState() == 5) continue;
            Tr.exit((TraceComponent)tc, (String)"stoppingContainedObj not all contained objs are stopped -- returing null");
            return null;
        }
        this.stopSelf();
        liveRepositoryObject = this.stopContainingObject(n);
        if (liveRepositoryObject == null) {
            liveRepositoryObject = this.scheduleStopTask(n);
        }
        Tr.exit((TraceComponent)tc, (String)"stoppingContainedObject ");
        return liveRepositoryObject;
    }

    public ContainmentPath getActiveObjectContainmentPath() throws RemoteException, OpException {
        ContainmentPath containmentPath;
        Tr.entry((TraceComponent)tc, (String)"getActiveObjectContainmentPath");
        try {
            LiveRepositoryObject liveRepositoryObject = (LiveRepositoryObject)this.getContainingObject();
            containmentPath = liveRepositoryObject.getActiveObjectContainmentPath();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            containmentPath = new ContainmentPath();
        }
        containmentPath.addElement(this.getActiveObjectName());
        Tr.exit((TraceComponent)tc, (String)"getActiveObjectContainmentPath");
        return containmentPath;
    }

    public int getDesiredState() throws RemoteException, OpException {
        return this.desiredState;
    }

    public boolean getStopConfirmed() throws RemoteException {
        return this.stopConfirmed;
    }

    public int getCurrentState() throws RemoteException, OpException {
        int n;
        if (this.desiredState == 5) {
            n = this.stopConfirmed ? 5 : 4;
        } else {
            try {
                n = (Integer)this.getRuntimeAttr("CurrentState");
            }
            catch (ActiveObjectInitializingException activeObjectInitializingException) {
                Tr.event((TraceComponent)tc, (String)"object is initializing ...");
                n = 1;
            }
            catch (ActiveObjectStoppedException activeObjectStoppedException) {
                Tr.event((TraceComponent)tc, (String)"object is stopped ...");
                n = 5;
            }
            catch (Throwable throwable) {
                Tr.event((TraceComponent)tc, (String)"Exception when fetching current state: ", (Object)throwable);
                n = 6;
            }
        }
        return n;
    }

    public void stopCompleted() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"stopCompleted");
        this.stopConfirmed = true;
        this.dirty = true;
        Enumeration enumeration = this.listContainedObjects();
        while (enumeration.hasMoreElements()) {
            LiveRepositoryObject liveRepositoryObject = (LiveRepositoryObject)enumeration.nextElement();
            liveRepositoryObject.stopCompleted();
        }
        Tr.exit((TraceComponent)tc, (String)"stopCompleted");
    }

    public ActiveObjectConfig getStartedConfigTree() throws RemoteException, OpException {
        ActiveObjectConfig activeObjectConfig = this.getConfig();
        Enumeration enumeration = this.listContainedObjects();
        while (enumeration.hasMoreElements()) {
            LiveRepositoryObject liveRepositoryObject = (LiveRepositoryObject)enumeration.nextElement();
            if (liveRepositoryObject.getDesiredState() != 3) continue;
            activeObjectConfig.addContainedConfig(liveRepositoryObject.getStartedConfigTree());
        }
        return activeObjectConfig;
    }

    public Act reconfirmContainedObjectsStop() throws RemoteException, OpException {
        Enumeration enumeration = this.listContainedObjects();
        Act act = null;
        while (enumeration.hasMoreElements()) {
            LiveRepositoryObject liveRepositoryObject = (LiveRepositoryObject)enumeration.nextElement();
            if (liveRepositoryObject.getDesiredState() != 5 || this.stopConfirmed) continue;
            act = liveRepositoryObject.forceStop();
        }
        return act;
    }

    public ContainmentPathElem getActiveObjectName() throws RemoteException, OpException {
        throw new RemoteException(RepositoryObjectImpl.nls.getString("liveroi.activeobject.exception", "getActiveObjectName not implemented"));
    }

    public ActiveObjectConfig getConfig() throws RemoteException, OpException {
        throw new RemoteException(RepositoryObjectImpl.nls.getString("liveroi.config.exception", "getConfig not implemented"));
    }

    public void ejbLoad() throws RemoteException {
        Long l = (Long)this.ec.getPrimaryKey();
        Tr.entry((TraceComponent)tc, (String)"ejbLoad");
        DBQueryResult dBQueryResult = null;
        super.ejbLoad();
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (!resultSet.next()) {
                    RemoteException remoteException = new RemoteException("", new ObjectNotFoundException());
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                    throw remoteException;
                }
                this.desiredState = resultSet.getInt(3);
                this.stopConfirmed = Utils.intToBoolean((int)resultSet.getInt(4));
                this.epoch = resultSet.getInt(5);
                this.version = resultSet.getInt(6);
                this.implicitStart = Utils.intToBoolean((int)resultSet.getInt(7));
                this.dirty = false;
                Tr.exit((TraceComponent)tc, (String)"ejbLoad");
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                throw remoteException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        super.ejbStore();
        if (this.dirty) {
            try {
                Vector<Object> vector = new Vector<Object>(6);
                vector.addElement(new Integer(this.desiredState));
                vector.addElement(new Integer(Utils.booleanToInt((boolean)this.stopConfirmed)));
                vector.addElement(new Integer(this.epoch));
                vector.addElement(new Integer(this.version));
                vector.addElement(new Integer(Utils.booleanToInt((boolean)this.implicitStart)));
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", new ObjectNotFoundException());
                Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                throw remoteException;
            }
        }
        Tr.exit((TraceComponent)tc, (String)"ejbStore");
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        this.removeCheck();
        super.ejbRemove();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)this.id));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            throw new RemoteException("", sQLException);
        }
    }

    public Long ejbCreate() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        this.desiredState = 5;
        this.stopConfirmed = true;
        this.epoch = 0;
        this.version = 0;
        this.implicitStart = false;
        Vector<Object> vector = new Vector<Object>(7);
        vector.addElement(Utils.getIdString((Long)this.id));
        vector.addElement(Utils.getIdString((Long)this.typeId));
        vector.addElement(new Integer(this.desiredState));
        vector.addElement(new Integer(Utils.booleanToInt((boolean)this.stopConfirmed)));
        vector.addElement(new Integer(this.epoch));
        vector.addElement(new Integer(this.version));
        vector.addElement(new Integer(Utils.booleanToInt((boolean)this.implicitStart)));
        try {
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate");
        return this.id;
    }

    public LiveObjectAttributes getAttributes(LiveObjectAttributes liveObjectAttributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        LiveObjectAttributes liveObjectAttributes2 = liveObjectAttributes;
        if (liveObjectAttributes.isRequested("DesiredState")) {
            liveObjectAttributes2.setGeneric("DesiredState", new Integer(this.getDesiredState()));
        }
        int n = 5;
        if (liveObjectAttributes.isRequested("CurrentState")) {
            n = this.getCurrentState();
            liveObjectAttributes2.setGeneric("CurrentState", new Integer(n));
        }
        if (liveObjectAttributes.isRequested("StartTime")) {
            if (this.desiredState == 5) {
                liveObjectAttributes2.setGeneric("StartTime", new Long(0L));
            } else {
                try {
                    liveObjectAttributes2.setGeneric("StartTime", this.getRuntimeAttr("StartTime"));
                }
                catch (Throwable throwable) {
                    Tr.event((TraceComponent)tc, (String)"Exception when fetching start time: ", (Object)throwable);
                    liveObjectAttributes2.setGeneric("StartTime", new Long(0L));
                }
            }
        }
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return liveObjectAttributes2;
    }

    public LiveRepositoryObjectImpl() throws RemoteException {
        LiveRepositoryObjectImpl.initializePersistentStore();
    }

    protected int getEpoch() {
        return this.epoch;
    }

    protected int getVersion() {
        return this.version;
    }

    protected void markStarted() {
        if (this.desiredState != 3) {
            this.desiredState = 3;
            ++this.epoch;
            ++this.version;
            this.stopConfirmed = false;
            this.implicitStart = false;
            this.dirty = true;
        }
    }

    protected void markStopped() {
        this.desiredState = 5;
        this.stopConfirmed = true;
        this.implicitStart = false;
        this.dirty = true;
    }

    protected void markOffline(boolean bl) throws RemoteException {
        if (bl) {
            this.desiredState = 5;
            this.stopConfirmed = true;
        } else {
            this.desiredState = 3;
            this.stopConfirmed = false;
        }
        this.dirty = true;
    }

    protected Object getRuntimeAttr(String string) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getRuntimeAttr");
        Node node = this.getNode();
        int n = node.getDesiredState();
        if (n == 5) {
            Tr.exit((TraceComponent)tc, (String)"getRuntimeAttr -- object is stopped");
            throw new ActiveObjectStoppedException();
        }
        if (this.desiredState == 5) {
            Tr.exit((TraceComponent)tc, (String)"getRuntimeAttr -- object is stopped");
            throw new ActiveObjectStoppedException();
        }
        AdminAgent adminAgent = node.getAdminAgent();
        ContainmentPath containmentPath = this.getActiveObjectContainmentPath();
        Control control = Utils.activeObjectInvocationPrologue();
        Object object = null;
        try {
            try {
                object = adminAgent.invokeActiveObject(containmentPath, "get" + string, null);
            }
            catch (IOException iOException) {
                node.markOffline(true);
                throw new ActiveObjectStoppedException();
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            Utils.activeObjectInvocationEpilogue((Control)control);
            throw throwable;
        }
        Utils.activeObjectInvocationEpilogue((Control)control);
        Tr.exit((TraceComponent)tc, (String)"getRuntimeAttr");
        return object;
    }

    protected void initializeConfig(ActiveObjectConfig activeObjectConfig) throws RemoteException, OpException {
        activeObjectConfig.setName(this.getActiveObjectContainmentPath());
        activeObjectConfig.setVersion(this.getVersion());
    }

    private void removeCheck() throws RemoteException, RemoveException {
        if (this.desiredState == 5 && this.stopConfirmed) {
            Enumeration enumeration = this.listContainedObjects();
            if (enumeration.hasMoreElements()) {
                throw new ObjectWithContainedObjectsRemoveException();
            }
            return;
        }
        Tr.error((TraceComponent)tc, (String)"liveroi.running.object.remove.error");
        throw new RunningObjectRemoveException();
    }

    protected ActiveObjectConfig startSelf(boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"startSelf", (Object)new Boolean(bl));
        if (this.desiredState == 5 && !this.stopConfirmed) {
            Tr.exit((TraceComponent)tc, (String)"startSelf -- object is terminating");
            throw new ActiveObjectTerminatingException();
        }
        if (this.desiredState == 5) {
            Tr.event((TraceComponent)tc, (String)"current state is stopped -- changing to running");
            ++this.epoch;
            this.desiredState = 3;
        }
        this.dirty = true;
        this.implicitStart = bl;
        ++this.version;
        Tr.exit((TraceComponent)tc, (String)"startSelf");
        return this.getConfig();
    }

    protected void stopSelf() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"stopSelf");
        if (this.desiredState == 5 && this.stopConfirmed) {
            Tr.exit((TraceComponent)tc, (String)"stopSelf -- object already stopped");
            throw new ActiveObjectStoppedException();
        }
        this.desiredState = 5;
        this.stopConfirmed = false;
        this.dirty = true;
        this.implicitStart = false;
        Tr.exit((TraceComponent)tc, (String)"stopSelf");
    }

    protected void startContainedObjects(ActiveObjectConfig activeObjectConfig) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"startContainedObjects");
        Enumeration enumeration = this.listContainedObjects();
        while (enumeration.hasMoreElements()) {
            LiveRepositoryObject liveRepositoryObject = (LiveRepositoryObject)enumeration.nextElement();
            activeObjectConfig.addContainedConfig(liveRepositoryObject.startingContainerObject());
        }
        Tr.exit((TraceComponent)tc, (String)"startContainedObjects");
    }

    private Act startContainingObject(ActiveObjectConfig activeObjectConfig) throws RemoteException, OpException {
        Act act;
        Tr.entry((TraceComponent)tc, (String)"startContainingObject");
        try {
            LiveRepositoryObject liveRepositoryObject = (LiveRepositoryObject)this.getContainingObject();
            act = liveRepositoryObject.startingContainedObject(activeObjectConfig);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            act = null;
        }
        Tr.exit((TraceComponent)tc, (String)"startContainingObject");
        return act;
    }

    private void stopContainedObjects() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"stopContainedObjects");
        Enumeration enumeration = this.listContainedObjects();
        while (enumeration.hasMoreElements()) {
            LiveRepositoryObject liveRepositoryObject = (LiveRepositoryObject)enumeration.nextElement();
            liveRepositoryObject.stoppingContainerObject();
        }
        Tr.exit((TraceComponent)tc, (String)"stopContainedObjects");
    }

    private Act stopContainingObject(int n) throws RemoteException, OpException {
        Act act;
        Tr.entry((TraceComponent)tc, (String)"stopContainingObject");
        try {
            LiveRepositoryObject liveRepositoryObject = (LiveRepositoryObject)this.getContainingObject();
            act = liveRepositoryObject.stoppingContainedObject(n);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            act = null;
        }
        Tr.exit((TraceComponent)tc, (String)"stopContainingObject");
        return act;
    }

    private Act scheduleStartTask(ActiveObjectConfig activeObjectConfig) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"scheduleStartTask");
        AdminAgent adminAgent = this.getNode().getAdminAgent();
        ActServerImpl actServerImpl = ActServerImpl.getInstance();
        Tr.exit((TraceComponent)tc, (String)"scheduleStartTask");
        return actServerImpl.scheduleWork((AsyncTask)new StartTask(adminAgent, this.epoch, activeObjectConfig, (LiveRepositoryObject)this.ec.getEJBObject()));
    }

    private Act scheduleStopTask(int n) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"scheduleStopTask");
        AdminAgent adminAgent = this.getNode().getAdminAgent();
        ActServerImpl actServerImpl = ActServerImpl.getInstance();
        ContainmentPath containmentPath = this.getActiveObjectContainmentPath();
        Tr.entry((TraceComponent)tc, (String)"scheduleStopTask");
        return actServerImpl.scheduleWork((AsyncTask)new StopTask(adminAgent, containmentPath, this.epoch, n, (LiveRepositoryObject)this.ec.getEJBObject()));
    }

    public Node getNode() throws RemoteException, OpException {
        RepositoryObject repositoryObject = (RepositoryObject)this.ec.getEJBObject();
        try {
            while (true) {
                RepositoryObject repositoryObject2;
                repositoryObject = repositoryObject2 = (RepositoryObject)repositoryObject.getContainingObject();
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return (Node)repositoryObject;
        }
    }

    private static void initializePersistentStore() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (tableCreated) {
                return;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + desiredStateColumnName + " integer not null, " + stopConfirmedColumnName + " integer not null, " + epochColumnName + " integer not null, " + versionColumnName + " integer not null, " + implicitStartColumnName + " integer not null, " + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Integer n2 = classLock;
            synchronized (n2) {
                tableCreated = true;
            }
            Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"initializePersistentStore", (Object)remoteException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class StopTask
    implements AsyncTask {
        private AdminAgent nodeAgent;
        private ContainmentPath target;
        private int epoch;
        private int timeout;
        private LiveRepositoryObject obj;

        StopTask(AdminAgent adminAgent, ContainmentPath containmentPath, int n, int n2, LiveRepositoryObject liveRepositoryObject) {
            this.nodeAgent = adminAgent;
            this.target = containmentPath;
            this.epoch = n;
            this.timeout = n2;
            this.obj = liveRepositoryObject;
        }

        public String getName() {
            return "startTask";
        }

        public void execute() throws RemoteException, OpException {
            Tr.entry((TraceComponent)tc, (String)"stopTask - execute");
            ParamList paramList = new ParamList(2);
            paramList.addElement(this.epoch);
            paramList.addElement(this.timeout);
            try {
                this.nodeAgent.invokeActiveObject(this.target, "stop", paramList);
            }
            catch (ActiveObjectStoppedException activeObjectStoppedException) {
                if (this.timeout == -1) {
                    Tr.event((TraceComponent)tc, (String)"ignoring stopped exception");
                }
                throw activeObjectStoppedException;
            }
            catch (RemoteException remoteException) {
                if (this.timeout == -1) {
                    Tr.event((TraceComponent)tc, (String)"ignoring stopped exception");
                }
                throw remoteException;
            }
            this.obj.stopCompleted();
            if (this.target.length() == 1) {
                paramList = new ParamList(1);
                paramList.addElement(this.timeout == -1);
                this.nodeAgent.invokeActiveObject(this.target, "terminateAdminServer", paramList);
            }
            Tr.exit((TraceComponent)tc, (String)"stopTask - execute");
        }
    }

    class StartTask
    implements AsyncTask {
        private AdminAgent nodeAgent;
        private int epoch;
        private ActiveObjectConfig config;
        private LiveRepositoryObject obj;

        StartTask(AdminAgent adminAgent, int n, ActiveObjectConfig activeObjectConfig, LiveRepositoryObject liveRepositoryObject) {
            this.nodeAgent = adminAgent;
            this.epoch = n;
            this.config = activeObjectConfig;
            this.obj = liveRepositoryObject;
        }

        public String getName() {
            return "startTask";
        }

        public void execute() throws RemoteException, OpException {
            Tr.entry((TraceComponent)tc, (String)"startTask - execute");
            ParamList paramList = new ParamList(2);
            paramList.addElement(this.epoch);
            paramList.addElement(this.config);
            this.nodeAgent.invokeActiveObject(this.config.getName(), "start", paramList);
            Tr.exit((TraceComponent)tc, (String)"startTask - execute");
        }
    }
}

