/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.J2EEResourceConfig;
import com.ibm.ejs.sm.beans.J2EEResourceProviderConfig;
import com.ibm.ejs.sm.beans.MailSession;
import com.ibm.ejs.sm.beans.MailSessionAttributes;
import com.ibm.ejs.sm.beans.MailSessionConfig;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.RepositoryObjectName;
import com.ibm.ejs.sm.beans.RepositoryObjectNameElem;
import com.ibm.ejs.sm.beans.ResourceBean;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.InvalidMailSessionNameException;
import com.ibm.ejs.sm.exception.InvalidNameChangeException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.RemoteOpException;
import com.ibm.ejs.sm.exception.RequiredAttributeMissingException;
import com.ibm.ejs.sm.util.ObjectCollection;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import com.ibm.ws.mail.SessionReferenceable;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.Referenceable;

public class MailSessionBean
extends ResourceBean
implements EntityBean {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$MailSessionBean == null ? (class$com$ibm$ejs$sm$beans$MailSessionBean = MailSessionBean.class$("com.ibm.ejs.sm.beans.MailSessionBean")) : class$com$ibm$ejs$sm$beans$MailSessionBean));
    private static Integer classLock = new Integer(0);
    private static final String tableName = DBMgr.qualifiedTableName((String)"MAILSESSION_TABLE");
    private static final String nameColumnName = "NAME";
    private static final int nameColumnIndex = 3;
    private static final String mailTransportHostColumnName = "THOST";
    private static final int mailTransportHostColumnIndex = 4;
    private static final String mailTransportProtocolColumnName = "TPROTOCOL";
    private static final int mailTransportProtocolColumnIndex = 5;
    private static final String mailTransportUserColumnName = "TUSER";
    private static final int mailTransportUserColumnIndex = 6;
    private static final String mailTransportPasswordColumnName = "TPASSWORD";
    private static final int mailTransportPasswordColumnIndex = 7;
    private static final String mailFromColumnName = "MAILFROM";
    private static final int mailFromColumnIndex = 8;
    private static final String mailStoreProtocolColumnName = "SPROTOCOL";
    private static final int mailStoreProtocolColumnIndex = 9;
    private static final String mailStoreHostColumnName = "SHOST";
    private static final int mailStoreHostColumnIndex = 10;
    private static final String mailStoreUserColumnName = "SUSER";
    private static final int mailStoreUserColumnIndex = 11;
    private static final String mailStorePasswordColumnName = "SPASSWORD";
    private static final int mailStorePasswordColumnIndex = 12;
    private static final String descriptionColumnName = "DESCRIPTION";
    private static final int descriptionColumnIndex = 13;
    private static final String jndiNameColumnName = "JNDINAME";
    private static final int jndiNameColumnIndex = 14;
    private static final int numColumns = 14;
    protected static final String myInterfaceName = RepositoryObjectImpl.qualifyClassName("MailSession");
    private static final String myClassName = RepositoryObjectImpl.qualifyClassName("MailSessionBean");
    private static boolean tableCreated = false;
    private static Type myTypeObj = null;
    private static Long myTypeId = null;
    private static final String myHomeName = "MailSessionHome";
    private static final String JNDIPREFIX = "mail/";
    private static final String defaultMailTransportProtocol = "smtp";
    private static final String defaultMailStoreProtocol = "imap";
    private static final int mailSessionBeanKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
    private static final int loadStmtKey = mailSessionBeanKeyBase + 1;
    private static final int updateStmtKey = mailSessionBeanKeyBase + 2;
    private static final int deleteStmtKey = mailSessionBeanKeyBase + 3;
    private static final int insertStmtKey = mailSessionBeanKeyBase + 4;
    private static final int restrictedFindAllStmtKey = mailSessionBeanKeyBase + 5;
    private static final int findAllStmtKey = mailSessionBeanKeyBase + 6;
    private static final int restrictedFindByNameStmtKey = mailSessionBeanKeyBase + 7;
    private static final int findByNameStmtKey = mailSessionBeanKeyBase + 8;
    private static final int findByJNDINameStmtKey = mailSessionBeanKeyBase + 9;
    private static final int restrictedFindByJNDINameStmtKey = mailSessionBeanKeyBase + 10;
    private static final String updateStmtSql = "update " + tableName + " set " + "NAME" + " = ? , " + "THOST" + " = ? ," + "TPROTOCOL" + " = ? ," + "TUSER" + " = ? ," + "TPASSWORD" + " = ? ," + "MAILFROM" + " = ? ," + "SPROTOCOL" + " = ? , " + "SHOST" + " = ? , " + "SUSER" + " = ? , " + "SPASSWORD" + " = ? , " + "DESCRIPTION" + " = ? , " + "JNDINAME" + " = ?  " + " where " + "INSTANCE_ID" + " = ?";
    private static final String deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " = ?";
    private static final String restrictedFindByNameStmtSql = "select * from " + tableName + " where " + "NAME" + " = ? and " + "TYPE_ID" + " = ? ";
    private static final String findByNameStmtSql = "select * from " + tableName + " where " + "NAME" + " =  ?";
    private static final String insertStmtSql = "insert into " + tableName + " values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String restrictedFindByJNDINameStmtSql = "select * from " + tableName + " where " + "JNDINAME" + " = ? and " + "TYPE_ID" + " = ? ";
    private static final String findByJNDINameStmtSql = "select * from " + tableName + " where " + "JNDINAME" + " =  ?";
    private String name;
    private String jndiName;
    private String prevJndiName;
    private String mailTransportHost;
    private String mailTransportProtocol;
    private String mailTransportUser;
    private String mailTransportPassword;
    private String mailFrom;
    private String mailStoreProtocol;
    private String mailStoreHost;
    private String mailStoreUser;
    private String mailStorePassword;
    private String description;
    private boolean duringCreate;
    private boolean dirty;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$MailSessionBean;

    public MailSessionBean() throws RemoteException {
        MailSessionBean.initializePersistentStore();
        MailSessionBean.initializeTypeId();
    }

    public Long ejbCreate(MailSessionAttributes mailSessionAttributes, EJBObject eJBObject) throws RemoteException, CreateException {
        Serializable serializable;
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        try {
            this.mailTransportHost = mailSessionAttributes.getMailTransportHost();
            if (!mailSessionAttributes.isSet(MailSessionAttributes.mailTransportProtocol)) {
                serializable = (MailSessionAttributes)RepositoryObjectImpl.getDefaults(myTypeObj);
                this.mailTransportProtocol = ((MailSessionAttributes)serializable).getMailTransportProtocol();
            } else {
                this.mailTransportProtocol = mailSessionAttributes.getMailTransportProtocol();
            }
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)" < ejbCreate -- attribute does not exist!", (Object)((Object)attributeDoesNotExistException));
            throw new RequiredAttributeMissingException(attributeDoesNotExistException.getMessage());
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)" < ejbCreate -- required attribute missing", (Object)((Object)attributeNotSetException));
            throw new RequiredAttributeMissingException(attributeNotSetException.getMessage());
        }
        try {
            this.validateStringAttr(mailSessionAttributes.getName());
        }
        catch (Exception exception) {
            throw new RequiredAttributeMissingException("Name");
        }
        try {
            this.validateStringAttr(this.mailTransportHost);
        }
        catch (Exception exception) {
            throw new RequiredAttributeMissingException("MailTransportHost");
        }
        try {
            this.validateStringAttr(this.mailTransportProtocol);
        }
        catch (Exception exception) {
            throw new RequiredAttributeMissingException("MailTransportProtocol");
        }
        try {
            if (this.typeId == null) {
                this.typeId = myTypeId;
            }
            this.id = this.create(this.typeId);
            this.initializeInstanceVariables();
            try {
                this.updateInstanceVariables(mailSessionAttributes, true);
            }
            catch (InvalidNameChangeException invalidNameChangeException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate: -- invalid data source name", (Object)((Object)invalidNameChangeException));
                throw new InvalidMailSessionNameException();
            }
            catch (OpException opException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate: ", (Object)((Object)opException));
                throw new RemoteException("", opException);
            }
            this.name = this.name;
            serializable = new Vector(14);
            ((Vector)serializable).addElement(Utils.getIdString((Long)this.id));
            ((Vector)serializable).addElement(Utils.getIdString((Long)this.typeId));
            ((Vector)serializable).addElement(this.name);
            ((Vector)serializable).addElement(this.mailTransportHost);
            ((Vector)serializable).addElement(this.mailTransportProtocol);
            ((Vector)serializable).addElement(this.mailTransportUser);
            ((Vector)serializable).addElement(this.mailTransportPassword);
            ((Vector)serializable).addElement(this.mailFrom);
            ((Vector)serializable).addElement(this.mailStoreProtocol);
            ((Vector)serializable).addElement(this.mailStoreHost);
            ((Vector)serializable).addElement(this.mailStoreUser);
            ((Vector)serializable).addElement(this.mailStorePassword);
            ((Vector)serializable).addElement(this.description);
            ((Vector)serializable).addElement(this.jndiName);
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, (Vector)serializable);
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)this.id);
        return this.id;
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException, FinderException {
        Enumeration enumeration;
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll");
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)false, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbFileAll", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)((ObjectCollection)enumeration).getArray());
        return enumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByJNDIName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByName", (Object)string);
        DBQueryResult dBQueryResult = null;
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByJNDINameStmtKey, (String)findByJNDINameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByJNDINameStmtKey, (String)restrictedFindByJNDINameStmtSql, vector);
                }
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName");
                l = this.singleFinderEpilogue(dBQueryResult);
                Object var7_8 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(ResourceBean.nls.getFormattedMessage("dsb.db.select4.exception", new Object[]{sQLException.getMessage(), string}, "DataSourceBean findByJNDIName failed due to {0} for name {1}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        DBQueryResult dBQueryResult = null;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByName", (Object)string);
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByNameStmtKey, (String)findByNameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByNameStmtKey, (String)restrictedFindByNameStmtSql, vector);
                }
                Long l2 = this.singleFinderEpilogue(dBQueryResult);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName");
                l = l2;
                Object var8_9 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    public void ejbLoad() throws RemoteException {
        DBQueryResult dBQueryResult = null;
        Long l = (Long)this.ec.getPrimaryKey();
        Tr.entry((TraceComponent)tc, (String)"ejbLoad", (Object)l);
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (resultSet == null || !resultSet.next()) {
                    RemoteException remoteException = new RemoteException("", new ObjectNotFoundException());
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                    throw remoteException;
                }
                if (this.setId(resultSet, myTypeId)) {
                    super.ejbLoad();
                    this.name = resultSet.getString(3);
                    this.mailTransportHost = resultSet.getString(4);
                    this.mailTransportProtocol = resultSet.getString(5);
                    if (this.mailTransportProtocol == null) {
                        this.mailTransportProtocol = new String();
                    }
                    this.mailTransportUser = resultSet.getString(6);
                    if (this.mailTransportUser == null) {
                        this.mailTransportUser = new String();
                    }
                    this.mailTransportPassword = resultSet.getString(7);
                    if (this.mailTransportPassword == null) {
                        this.mailTransportPassword = new String();
                    }
                    this.mailFrom = resultSet.getString(8);
                    if (this.mailFrom == null) {
                        this.mailFrom = new String();
                    }
                    this.mailStoreProtocol = resultSet.getString(9);
                    if (this.mailStoreProtocol == null) {
                        this.mailStoreProtocol = new String();
                    }
                    this.mailStoreHost = resultSet.getString(10);
                    if (this.mailStoreHost == null) {
                        this.mailStoreHost = new String();
                    }
                    this.mailStoreUser = resultSet.getString(11);
                    if (this.mailStoreUser == null) {
                        this.mailStoreUser = new String();
                    }
                    this.mailStorePassword = resultSet.getString(12);
                    if (this.mailStorePassword == null) {
                        this.mailStorePassword = new String();
                    }
                    this.description = resultSet.getString(13);
                    if (this.description == null) {
                        this.description = new String();
                    }
                    this.jndiName = resultSet.getString(14);
                    if (this.jndiName == null) {
                        this.jndiName = new String();
                    }
                }
                this.duringCreate = false;
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                throw remoteException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
    }

    public void ejbPostCreate(MailSessionAttributes mailSessionAttributes, EJBObject eJBObject) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbPostCreate");
        try {
            if (!this.ec.getRollbackOnly()) {
                this.insertIntoNameSpace(this.getJNDIName(), (Referenceable)this.getBindingObject());
            }
        }
        catch (Exception exception) {
            this.ec.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"ejbPostCreate:", (Object)exception);
            throw new RemoteException("", exception);
        }
        Tr.exit((TraceComponent)tc, (String)"ejbPostCreate");
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        if (this.id == null) {
            this.ejbLoad();
        }
        if (this.narrowRef != null) {
            this.narrowRef.remove();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove");
            return;
        }
        super.ejbRemove();
        Long l = (Long)this.ec.getPrimaryKey();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)l));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
            this.deleteFromNameSpace(this.getJNDIName());
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbRemove", (Object)remoteException);
            throw remoteException;
        }
        catch (RemoteException remoteException) {
            this.ec.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove - with RemoteException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        super.ejbStore();
        if (this.dirty) {
            try {
                Vector<String> vector = new Vector<String>(14);
                vector.addElement(this.name);
                vector.addElement(this.mailTransportHost);
                vector.addElement(this.mailTransportProtocol);
                vector.addElement(this.mailTransportUser);
                vector.addElement(this.mailTransportPassword);
                vector.addElement(this.mailFrom);
                vector.addElement(this.mailStoreProtocol);
                vector.addElement(this.mailStoreHost);
                vector.addElement(this.mailStoreUser);
                vector.addElement(this.mailStorePassword);
                vector.addElement(this.description);
                vector.addElement(this.jndiName);
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                throw remoteException;
            }
            if (!this.duringCreate) {
                if (this.prevJndiName != null && !this.prevJndiName.equals("")) {
                    try {
                        this.renameInNameSpace(this.prevJndiName, this.getJNDIName(), (Referenceable)this.getBindingObject());
                        this.prevJndiName = null;
                    }
                    catch (Exception exception) {
                        this.ec.setRollbackOnly();
                        RemoteException remoteException = new RemoteException("", exception);
                        Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                        throw remoteException;
                    }
                }
                try {
                    this.updateInNameSpace(this.getJNDIName(), (Referenceable)this.getBindingObject());
                }
                catch (Exception exception) {
                    this.ec.setRollbackOnly();
                    RemoteException remoteException = new RemoteException("", exception);
                    Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                    throw remoteException;
                }
            }
        }
        Tr.exit((TraceComponent)tc, (String)"ejbStore");
    }

    public Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        Attributes attributes2 = null;
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        if (this.narrowRef != null) {
            attributes2 = ((MailSession)this.narrowRef).getAttributes(attributes);
        } else {
            this.setVersion(attributes);
            attributes2 = this.readInstanceVariables(attributes);
        }
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return attributes2;
    }

    private Object getBindingObject() {
        Tr.entry((TraceComponent)tc, (String)"getBindingObject");
        Properties properties = new Properties();
        ((Hashtable)properties).put("mail.transport.protocol", this.mailTransportProtocol);
        ((Hashtable)properties).put("mail." + this.mailTransportProtocol + ".host", this.mailTransportHost);
        if (this.mailTransportUser != null & !this.mailTransportUser.equals("")) {
            ((Hashtable)properties).put("mail." + this.mailTransportProtocol + ".user", this.mailTransportUser);
        }
        if (this.mailTransportPassword != null & !this.mailTransportPassword.equals("")) {
            ((Hashtable)properties).put("ws.transport.password", this.mailTransportPassword);
        }
        ((Hashtable)properties).put("mail.store.protocol", this.mailStoreProtocol);
        ((Hashtable)properties).put("mail." + this.mailStoreProtocol + ".host", this.mailStoreHost);
        if (this.mailStoreUser != null & !this.mailStoreUser.equals("")) {
            ((Hashtable)properties).put("mail." + this.mailStoreProtocol + ".user", this.mailStoreUser);
        }
        if (this.mailStorePassword != null & !this.mailStorePassword.equals("")) {
            ((Hashtable)properties).put("ws.store.password", this.mailStorePassword);
        }
        ((Hashtable)properties).put("mail.from", this.mailFrom);
        SessionReferenceable sessionReferenceable = new SessionReferenceable(properties);
        Tr.exit((TraceComponent)tc, (String)"getBindingObject");
        return sessionReferenceable;
    }

    public RepositoryObjectName getFullName() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getFullName");
        RepositoryObjectName repositoryObjectName = new RepositoryObjectName();
        repositoryObjectName.addElement(new RepositoryObjectNameElem(myHomeName, this.name));
        Tr.exit((TraceComponent)tc, (String)"getFullName");
        return repositoryObjectName;
    }

    public String getJNDIName() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"getJNDIName");
        if (this.jndiName.trim().equals("")) {
            this.jndiName = this.name.startsWith(JNDIPREFIX) ? this.name : JNDIPREFIX + this.name;
        }
        Tr.exit((TraceComponent)tc, (String)"getJNDIName");
        return this.jndiName;
    }

    public J2EEResourceConfig getResourceConfig(Node node) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getConfig");
        MailSessionConfig mailSessionConfig = new MailSessionConfig();
        J2EEResourceProviderConfig j2EEResourceProviderConfig = new J2EEResourceProviderConfig();
        mailSessionConfig.setProvider(j2EEResourceProviderConfig);
        j2EEResourceProviderConfig.setName("Default JavaMail Provider");
        j2EEResourceProviderConfig.setProviderId(0L);
        j2EEResourceProviderConfig.setClasspath("");
        mailSessionConfig.setName(this.name);
        mailSessionConfig.setJtaEnabled(false);
        mailSessionConfig.setDescription(this.description);
        mailSessionConfig.setJNDIName(this.getJNDIName());
        mailSessionConfig.setMailTransportHost(this.mailTransportHost);
        mailSessionConfig.setMailTransportProtocol(this.mailTransportProtocol);
        mailSessionConfig.setMailTransportUser(this.mailTransportUser);
        mailSessionConfig.setMailTransportPassword(this.mailTransportPassword);
        mailSessionConfig.setMailFrom(this.mailFrom);
        mailSessionConfig.setMailStoreProtocol(this.mailStoreProtocol);
        mailSessionConfig.setMailStoreHost(this.mailStoreHost);
        mailSessionConfig.setMailStoreUser(this.mailStoreUser);
        mailSessionConfig.setMailStorePassword(this.mailStorePassword);
        Tr.exit((TraceComponent)tc, (String)"getConfig");
        return mailSessionConfig;
    }

    private void initializeInstanceVariables() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeInstanceVariables");
        MailSessionAttributes mailSessionAttributes = (MailSessionAttributes)RepositoryObjectImpl.getDefaults(myTypeObj);
        try {
            this.mailTransportProtocol = mailSessionAttributes.getMailTransportProtocol();
            this.mailStoreProtocol = mailSessionAttributes.getMailStoreProtocol();
            this.mailTransportHost = new String();
            this.mailTransportUser = new String();
            this.mailTransportPassword = new String();
            this.mailFrom = new String();
            this.mailStoreHost = new String();
            this.mailStoreUser = new String();
            this.mailStorePassword = new String();
            this.description = new String();
            this.jndiName = new String();
            this.prevJndiName = null;
            this.duringCreate = true;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"intializedInstanceVariables", (Object)exception);
            throw new RemoteException("", exception);
        }
        Tr.exit((TraceComponent)tc, (String)"intializedInstanceVariables");
    }

    private static void initializePersistentStore() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (tableCreated) {
                return;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + nameColumnName + DBMgr.mediumStringColumnSpec + " , " + mailTransportHostColumnName + DBMgr.mediumStringColumnSpec + " , " + mailTransportProtocolColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + mailTransportUserColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + mailTransportPasswordColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + mailFromColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + mailStoreProtocolColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + mailStoreHostColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + mailStoreUserColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + mailStorePasswordColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + descriptionColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + jndiNameColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Integer n2 = classLock;
            synchronized (n2) {
                tableCreated = true;
            }
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"intializePersistentStore");
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
    }

    private static void initializeTypeId() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        Integer n = classLock;
        synchronized (n) {
            if (myTypeId != null) {
                Tr.exit((TraceComponent)tc, (String)"initializeTypeId");
                return;
            }
        }
        MailSessionAttributes mailSessionAttributes = new MailSessionAttributes();
        mailSessionAttributes.setMailTransportProtocol(defaultMailTransportProtocol);
        mailSessionAttributes.setMailStoreProtocol(defaultMailStoreProtocol);
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, mailSessionAttributes, true);
        Long l = (Long)type.getPrimaryKey();
        Integer n2 = classLock;
        synchronized (n2) {
            myTypeObj = type;
            myTypeId = l;
        }
        Tr.exit((TraceComponent)tc, (String)"intializeTypeId");
    }

    private MailSessionAttributes readInstanceVariables(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"readInstanceVariables");
        MailSessionAttributes mailSessionAttributes = (MailSessionAttributes)attributes;
        mailSessionAttributes.setName(this.name);
        mailSessionAttributes.setJNDIName(this.jndiName);
        mailSessionAttributes.setFullName(this.getFullName());
        mailSessionAttributes.setMailTransportHost(this.mailTransportHost);
        mailSessionAttributes.setMailTransportProtocol(this.mailTransportProtocol);
        mailSessionAttributes.setMailTransportUser(this.mailTransportUser);
        mailSessionAttributes.setMailTransportPassword(this.mailTransportPassword);
        mailSessionAttributes.setMailFrom(this.mailFrom);
        mailSessionAttributes.setMailStoreProtocol(this.mailStoreProtocol);
        mailSessionAttributes.setMailStoreHost(this.mailStoreHost);
        mailSessionAttributes.setMailStoreUser(this.mailStoreUser);
        mailSessionAttributes.setMailStorePassword(this.mailStorePassword);
        mailSessionAttributes.setDescription(this.description);
        Tr.exit((TraceComponent)tc, (String)"readInstanceVariables");
        return mailSessionAttributes;
    }

    public void setAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setAttributes");
        if (this.narrowRef != null) {
            ((MailSession)this.narrowRef).setAttributes(attributes);
        } else {
            String string;
            try {
                if (attributes.isSet(Attributes.name)) {
                    string = ((MailSessionAttributes)attributes).getName();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(ResourceBean.nls.getFormattedMessage("invalid.attribute.name", new Object[]{"Name"}, "Invalid value for attribute: {0}"));
            }
            try {
                if (attributes.isSet(MailSessionAttributes.mailTransportHost)) {
                    string = ((MailSessionAttributes)attributes).getMailTransportHost();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(ResourceBean.nls.getFormattedMessage("invalid.attribute.name", new Object[]{"MailTransportHost"}, "Invalid value for attribute: {0}"));
            }
            try {
                if (attributes.isSet(MailSessionAttributes.mailTransportProtocol)) {
                    string = ((MailSessionAttributes)attributes).getMailTransportProtocol();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(ResourceBean.nls.getFormattedMessage("invalid.attribute.name", new Object[]{"MailTransportProtocol"}, "Invalid value for attribute: {0}"));
            }
            this.checkAndIncrVersion(attributes);
            this.updateInstanceVariables((MailSessionAttributes)attributes, false);
        }
        Tr.exit((TraceComponent)tc, (String)"setAttributes");
    }

    private void updateInstanceVariables(MailSessionAttributes mailSessionAttributes, boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"updateInstanceVariables");
        this.dirty = true;
        try {
            String string;
            if (mailSessionAttributes.isSet(Attributes.name)) {
                if (bl) {
                    this.name = "";
                }
                this.validateNameChange(mailSessionAttributes);
                this.name = string = mailSessionAttributes.getName();
                if (bl) {
                    this.jndiName = this.getJNDIName();
                }
            }
            if (mailSessionAttributes.isSet(MailSessionAttributes.mailTransportHost)) {
                this.mailTransportHost = mailSessionAttributes.getMailTransportHost();
            }
            if (mailSessionAttributes.isSet(MailSessionAttributes.mailTransportProtocol)) {
                this.mailTransportProtocol = mailSessionAttributes.getMailTransportProtocol();
            }
            if (mailSessionAttributes.isSet(MailSessionAttributes.mailTransportUser)) {
                this.mailTransportUser = mailSessionAttributes.getMailTransportUser();
            }
            if (mailSessionAttributes.isSet(MailSessionAttributes.mailTransportPassword)) {
                this.mailTransportPassword = mailSessionAttributes.getMailTransportPassword();
            }
            if (mailSessionAttributes.isSet(MailSessionAttributes.mailFrom)) {
                this.mailFrom = mailSessionAttributes.getMailFrom();
            }
            if (mailSessionAttributes.isSet(MailSessionAttributes.mailStoreProtocol)) {
                this.mailStoreProtocol = mailSessionAttributes.getMailStoreProtocol();
            }
            if (mailSessionAttributes.isSet(MailSessionAttributes.mailStoreHost)) {
                this.mailStoreHost = mailSessionAttributes.getMailStoreHost();
            }
            if (mailSessionAttributes.isSet(MailSessionAttributes.mailStoreUser)) {
                this.mailStoreUser = mailSessionAttributes.getMailStoreUser();
            }
            if (mailSessionAttributes.isSet(MailSessionAttributes.mailStorePassword)) {
                this.mailStorePassword = mailSessionAttributes.getMailStorePassword();
            }
            if (mailSessionAttributes.isSet(MailSessionAttributes.description)) {
                this.description = mailSessionAttributes.getDescription();
            }
            if (mailSessionAttributes.isSet(MailSessionAttributes.jndiName)) {
                string = mailSessionAttributes.getJNDIName();
                if (!(string = string.trim()).equals("") && !string.equals(this.jndiName)) {
                    this.checkForDuplicateJNDIName(string);
                    if (!bl) {
                        this.prevJndiName = this.jndiName;
                        this.updateModuleBindings(this.prevJndiName, string);
                    }
                    this.jndiName = string;
                }
            }
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeNotSetException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)attributeNotSetException);
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeDoesNotExistException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)attributeDoesNotExistException);
        }
        Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables");
    }

    private void validateNameChange(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"validateNameChange ");
        try {
            if (attributes.isSet(Attributes.name)) {
                String string = attributes.getName();
                if (string.equals(this.name)) {
                    Tr.exit((TraceComponent)tc, (String)"validateNameChange");
                    return;
                }
                try {
                    this.ejbFindByName(string, true);
                    Tr.exit((TraceComponent)tc, (String)"validateNameChange -- duplicate name");
                    throw new InvalidNameChangeException();
                }
                catch (ObjectNotFoundException objectNotFoundException) {}
            }
        }
        catch (InvalidNameChangeException invalidNameChangeException) {
            throw invalidNameChangeException;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"validateNameChange -- unexpected error", (Object)exception);
            throw new RemoteOpException("", (Throwable)exception);
        }
        Tr.exit((TraceComponent)tc, (String)"validateNameChange");
    }

    private void validateStringAttr(String string) throws RemoteException {
        if (string.trim().equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"validateStringAttr failed.");
            }
            throw new RemoteException("validateStringAttr failed.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

