/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.LiveObjectGroupImpl;
import com.ibm.ejs.sm.beans.LiveRepositoryObject;
import com.ibm.ejs.sm.beans.Model;
import com.ibm.ejs.sm.beans.ModelAttributes;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.Relation;
import com.ibm.ejs.sm.beans.RepositoryHome;
import com.ibm.ejs.sm.beans.RepositoryObject;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.RepositoryObjectName;
import com.ibm.ejs.sm.beans.RepositoryObjectNameElem;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.sm.exception.ActiveObjectStoppedException;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.EmptyObjectGroupStartException;
import com.ibm.ejs.sm.exception.EmptyObjectGroupStopException;
import com.ibm.ejs.sm.exception.InvalidModelNameException;
import com.ibm.ejs.sm.exception.InvalidNameChangeException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.RelationOpException;
import com.ibm.ejs.sm.exception.RequiredAttributeMissingException;
import com.ibm.ejs.sm.server.AdminServer;
import com.ibm.ejs.sm.server.ManagedServer;
import com.ibm.ejs.sm.util.ObjectCollection;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.act.Act;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.rmi.PortableRemoteObject;

public class ModelBean
extends LiveObjectGroupImpl
implements EntityBean {
    protected static NLS nls = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$ModelBean == null ? (class$com$ibm$ejs$sm$beans$ModelBean = ModelBean.class$("com.ibm.ejs.sm.beans.ModelBean")) : class$com$ibm$ejs$sm$beans$ModelBean));
    private static Integer classLock = new Integer(0);
    protected static final String myInterfaceName = RepositoryObjectImpl.qualifyClassName("Model");
    private static final String myClassName = RepositoryObjectImpl.qualifyClassName("ModelBean");
    private static final String myHomeName = "ModelHome";
    private static final String instanceAttributesAttrName = myInterfaceName + ".instanceAttributes";
    private static boolean tableCreated = false;
    private static Type myTypeObj = null;
    private static Long myTypeId = null;
    private static final String tableName = DBMgr.qualifiedTableName((String)"MODEL_TABLE");
    private static final int nameColumnIndex = 3;
    private static final String nameColumnName = "NAME";
    private static final String cloneInterfaceClassColumnName = "CLONE_INTF_CLASS";
    private static final int cloneInterfaceClassColumnIndex = 4;
    private static final int ifStartedColumnIndex = 5;
    private static final String ifStartedColumnName = "IF_STARTED";
    private static final int startTimeColumnIndex = 6;
    private static final String startTimeColumnName = "START_TIME";
    private static final String configNoColumnName = "CONFIG_NO";
    private static final int configNoColumnIndex = 7;
    private static final String numClonesColumnName = "NUM_CLONES";
    private static final int numClonesColumnIndex = 8;
    private static final int numColumns = 8;
    private static final int modelBeanKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
    private static final int loadStmtKey = modelBeanKeyBase + 1;
    private static final int updateStmtKey = modelBeanKeyBase + 2;
    private static final int deleteStmtKey = modelBeanKeyBase + 3;
    private static final int findAllStmtKey = modelBeanKeyBase + 4;
    private static final int restrictedFindAllStmtKey = modelBeanKeyBase + 5;
    private static final int findByNameStmtKey = modelBeanKeyBase + 6;
    private static final int restrictedFindByNameStmtKey = modelBeanKeyBase + 7;
    private static final int insertStmtKey = modelBeanKeyBase + 8;
    private static final String updateStmtSql = "update " + tableName + " set " + "NAME" + " = ? , " + "CLONE_INTF_CLASS" + " = ? ,  " + "IF_STARTED" + " = ? ,  " + "START_TIME" + " = ? ,  " + "CONFIG_NO" + " = ? , " + "NUM_CLONES" + " = ? " + " where " + "INSTANCE_ID" + " = ?";
    private static final String deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " =  ?";
    private static final String findByNameStmtSql = "select * from " + tableName + " where " + "NAME" + " =  ?";
    private static final String restrictedFindByNameStmtSql = "select * from " + tableName + " where " + "NAME" + " =  ?  and " + "TYPE_ID" + " = ? ";
    private static final String insertStmtSql = "insert into " + tableName + " values(?,?,?,?,?,?,?,?)";
    private String name;
    private String cloneInterfaceClassName;
    private Attributes instanceAttributes = null;
    private boolean ifStarted = false;
    private long startTime = 0L;
    private long configNo = 0L;
    private long numClones = 0L;
    private boolean dirty;
    private static Relation modelModelContainmentRel;
    protected static final String modelModelContainmentRelName = "ModelModelContainmentRel";
    static /* synthetic */ Class class$javax$ejb$EJBObject;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$Model;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$RepositoryObject;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$ModelBean;

    public Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        if (this.narrowRef != null) {
            return ((Model)this.narrowRef).getAttributes(attributes);
        }
        this.setVersion(attributes);
        ModelAttributes modelAttributes = (ModelAttributes)attributes;
        modelAttributes.setName(this.name);
        if (modelAttributes.isRequested(Attributes.fullName)) {
            modelAttributes.setFullName(this.getFullName());
        }
        modelAttributes.setCloneInterfaceClass(this.cloneInterfaceClassName);
        modelAttributes.setIfStarted(this.ifStarted);
        modelAttributes.setStartTime(this.startTime);
        modelAttributes.setConfigNo(this.configNo);
        modelAttributes.setAttributes(this.instanceAttributes);
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return modelAttributes;
    }

    public void setAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setAttributes");
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Incremented configNo: configNo = " + this.configNo));
        }
        if (this.narrowRef != null) {
            ((Model)this.narrowRef).setAttributes(attributes);
            return;
        }
        this.checkAndIncrVersion(attributes);
        try {
            ++this.configNo;
            this.dirty = true;
            ModelAttributes modelAttributes = (ModelAttributes)attributes;
            this.renameIfNec(attributes);
            if (modelAttributes.isSet("Attributes")) {
                this.instanceAttributes.copyAttributes(modelAttributes.getAttributes(), 65535L, true);
                if (!this.instanceAttributes.checkSetAttributes(65535L)) {
                    Tr.event((TraceComponent)tc, (String)"Inapplicable attributes provided for model instance. Ignoring them. ");
                }
                this.setBinaryAttr(instanceAttributesAttrName, this.instanceAttributes);
                Enumeration enumeration = this.listClones();
                while (enumeration.hasMoreElements()) {
                    RepositoryObject repositoryObject = (RepositoryObject)enumeration.nextElement();
                    repositoryObject.setAttributes(modelAttributes.getAttributes());
                }
            }
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.warning((TraceComponent)tc, (String)nls.getString("model.db.set.warning1", "Encountered a bad implementation of a ModelAttributes object in the setAttributes method: {0}"), (Object)new Object[]{attributeDoesNotExistException});
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.warning((TraceComponent)tc, (String)nls.getString("model.db.set.warning2", "Attribute is set but the get method failed in the setAttributes method {0}"), (Object)new Object[]{attributeNotSetException});
        }
        catch (ClassCastException classCastException) {
            Tr.exit((TraceComponent)tc, (String)"setAttributes", (Object)classCastException);
            this.ec.setRollbackOnly();
            throw new OpException(nls.getString("model.db.set.exception", "Invalid attributes class provided:") + classCastException.toString());
        }
        Tr.exit((TraceComponent)tc, (String)"setAttributes");
    }

    public RepositoryObjectName getFullName() throws RemoteException, OpException {
        Model model = null;
        try {
            model = (Model)this.getContainingObject();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
        }
        catch (Exception exception) {
            throw new RemoteException("", exception);
        }
        RepositoryObjectName repositoryObjectName = model == null ? new RepositoryObjectName() : model.getFullName();
        repositoryObjectName.addElement(new RepositoryObjectNameElem(myHomeName, this.name));
        return repositoryObjectName;
    }

    public Attributes[] getAllCloneAttributes(Attributes attributes) throws RemoteException, OpException {
        Object[] objectArray;
        Tr.entry((TraceComponent)tc, (String)"getAllCloneAttributes");
        Vector<Attributes> vector = new Vector<Attributes>();
        Attributes attributes2 = null;
        try {
            objectArray = Class.forName(this.cloneInterfaceClassName + "Attributes");
            Enumeration enumeration = this.listClones();
            while (enumeration.hasMoreElements()) {
                RepositoryObject repositoryObject = (RepositoryObject)enumeration.nextElement();
                Attributes attributes3 = repositoryObject.getAttributes(attributes);
                attributes2 = (Attributes)objectArray.newInstance();
                attributes2.copyAttributes(attributes3, 65535L, true);
                vector.addElement(attributes2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.exit((TraceComponent)tc, (String)"getAllCloneAttributes", (Object)classNotFoundException);
            throw new RemoteException("", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            Tr.exit((TraceComponent)tc, (String)"getAllCloneAttributes", (Object)instantiationException);
            throw new RemoteException("", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.exit((TraceComponent)tc, (String)"getAllCloneAttributes", (Object)illegalAccessException);
            throw new RemoteException("", illegalAccessException);
        }
        objectArray = new Attributes[vector.size()];
        vector.copyInto(objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getAllCloneAttributes: length: " + new Integer(objectArray.length)));
        }
        return objectArray;
    }

    public void incrementConfigNo(EJBObject eJBObject, long l) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"incrementConfigNo", (Object)new Long(l));
        Relation relation = this.lookupModelCloneRel();
        Enumeration enumeration = relation.list(eJBObject, true);
        if (!enumeration.hasMoreElements()) {
            Tr.exit((TraceComponent)tc, (String)"Clone is not part of model:", (Object)eJBObject);
            throw new RemoteException(nls.getString("model.config.exception", "incrementConfigNo: Clone is not part of model"));
        }
        ++this.configNo;
        this.dirty = true;
        try {
            this.pushModelChangesForWLM(l);
        }
        catch (Exception exception) {
            Tr.warning((TraceComponent)tc, (String)nls.getString("model.config.warning", "Unexpected exception in pushModelChangesForWLM"), (Object)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("incrementConfigNo: configNo = " + this.configNo));
        }
    }

    public void incrementConfigNo(EJBObject eJBObject) throws RemoteException, OpException {
        this.incrementConfigNo(eJBObject, -1L);
    }

    public EJBObject clone(Attributes attributes, EJBObject eJBObject) throws RemoteException, CreateException, OpException {
        String string = null;
        if (attributes != null) {
            try {
                string = attributes.getName();
            }
            catch (AttributeNotSetException attributeNotSetException) {
                // empty catch block
            }
        }
        if (string == null) {
            if (attributes == null) {
                try {
                    Class<?> clazz = Class.forName(this.cloneInterfaceClassName + "Attributes");
                    attributes = (Attributes)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new RemoteException("", exception);
                }
            }
            attributes.setName(this.name + "Clone");
        }
        return this.clone(attributes, eJBObject, false);
    }

    private EJBObject clone(Attributes attributes, EJBObject eJBObject, boolean bl) throws RemoteException, CreateException, OpException {
        Object object;
        Tr.entry((TraceComponent)tc, (String)"clone");
        ++this.configNo;
        ++this.numClones;
        this.dirty = true;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Incremented configNo: configNo = " + this.configNo));
        }
        Attributes attributes2 = this.instanceAttributes;
        if (attributes != null) {
            Tr.event((TraceComponent)tc, (String)"cloneInstanceAttributes non-null");
            if (!attributes.checkSetAttributes(8L)) {
                this.ec.setRollbackOnly();
                throw new OpException(nls.getString("model.clone.exception", "Inapplicable attributes provided for root clone instance"));
            }
            attributes2.copyAttributes(attributes, 8L, true);
        }
        try {
            object = attributes2.getName();
            Tr.event((TraceComponent)tc, (String)"name: ", (Object)object);
            if (object == null || ((String)object).equals("")) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("name not set; using " + this.name));
                }
                attributes2.setName(this.name);
            }
        }
        catch (AttributeNotSetException attributeNotSetException) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("name not set; using " + this.name));
            }
            attributes2.setName(this.name);
        }
        try {
            Object object2;
            Object object3;
            Class clazz;
            Class<?> clazz2 = Class.forName(this.cloneInterfaceClassName + "Attributes");
            Class<?> clazz3 = Class.forName(this.cloneInterfaceClassName + "Home");
            Class clazz4 = clazz = class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = ModelBean.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject;
            if (eJBObject != null) {
                clazz = this.getEJBObjectInterface(eJBObject);
            }
            CloneCreateMethod cloneCreateMethod = this.getCloneCreateMethod(clazz3, clazz2, clazz);
            RepositoryObject repositoryObject = null;
            if (eJBObject != null) {
                repositoryObject = (RepositoryObject)PortableRemoteObject.narrow((Object)eJBObject, (Class)clazz);
            }
            RepositoryHome repositoryHome = RepositoryObjectImpl.getHome(this.getUnqualifiedCloneInterfaceName() + "Home");
            try {
                if (cloneCreateMethod.provideModelParam) {
                    object3 = (Object[])PortableRemoteObject.narrow((Object)this.ec.getEJBObject(), (Class)(class$com$ibm$ejs$sm$beans$Model == null ? (class$com$ibm$ejs$sm$beans$Model = ModelBean.class$("com.ibm.ejs.sm.beans.Model")) : class$com$ibm$ejs$sm$beans$Model));
                    object2 = new Object[]{object3, attributes2, repositoryObject};
                    object = (RepositoryObject)cloneCreateMethod.m.invoke((Object)repositoryHome, (Object[])object2);
                } else {
                    object3 = new Object[]{attributes2, repositoryObject};
                    object = (RepositoryObject)cloneCreateMethod.m.invoke((Object)repositoryHome, (Object[])object3);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof CreateException) {
                    if (this.ec != null) {
                        this.ec.setRollbackOnly();
                    }
                    throw (CreateException)throwable;
                }
                throw invocationTargetException;
            }
            object3 = this.lookupModelCloneRel();
            object3.addUsingKeys(this.id, (Long)object.getPrimaryKey());
            if (!bl) {
                object2 = this.listContainedObjects();
                while (object2.hasMoreElements()) {
                    Model model = (Model)object2.nextElement();
                    Tr.event((TraceComponent)tc, (String)"Cloning contained model: ", (Object)model);
                    model.clone(null, (EJBObject)object);
                }
            }
        }
        catch (CreateException createException) {
            Tr.exit((TraceComponent)tc, (String)"clone", (Object)((Object)createException));
            throw createException;
        }
        catch (RemoteException remoteException) {
            Tr.exit((TraceComponent)tc, (String)"clone", (Object)remoteException);
            throw remoteException;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"clone", (Object)exception);
            throw new RemoteException("", exception);
        }
        Tr.exit((TraceComponent)tc, (String)"clone");
        return object;
    }

    public void disassociateClone(EJBObject eJBObject) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"disassociateClone", (Object)eJBObject);
        try {
            try {
                RepositoryObject repositoryObject;
                ++this.configNo;
                --this.numClones;
                this.dirty = true;
                Enumeration enumeration = ((RepositoryObject)eJBObject).listContainedObjects();
                while (enumeration.hasMoreElements()) {
                    repositoryObject = (RepositoryObject)enumeration.nextElement();
                    Tr.event((TraceComponent)tc, (String)"Found contained object", (Object)repositoryObject);
                    Relation relation = repositoryObject.getModelRelation();
                    if (relation == null) continue;
                    Enumeration enumeration2 = relation.list(repositoryObject, true);
                    if (enumeration2.hasMoreElements()) {
                        Model model = (Model)enumeration2.nextElement();
                        model.disassociateClone(repositoryObject);
                        continue;
                    }
                    Tr.warning((TraceComponent)tc, (String)nls.getString("model.clone.warning", "Model not found"));
                }
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Incremented configNo: configNo = " + this.configNo));
                }
                repositoryObject = this.lookupModelCloneRel();
                this.deleteFromRelation((Relation)repositoryObject, eJBObject);
            }
            catch (OpException opException) {
                this.ec.setRollbackOnly();
                throw opException;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Tr.exit((TraceComponent)tc, (String)"disassociateClone");
            throw throwable;
        }
        Tr.exit((TraceComponent)tc, (String)"disassociateClone");
    }

    public void associateClone(EJBObject eJBObject) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"associateClone", (Object)eJBObject);
        ++this.configNo;
        ++this.numClones;
        this.dirty = true;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Incremented configNo: configNo = " + this.configNo));
        }
        Relation relation = this.lookupModelCloneRel();
        relation.addUsingKeys(this.id, (Long)eJBObject.getPrimaryKey());
        Tr.exit((TraceComponent)tc, (String)"associateClone");
    }

    public Enumeration listClones() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"listClones");
        if (this.narrowRef != null) {
            return ((Model)this.narrowRef).listClones();
        }
        Relation relation = this.lookupModelCloneRel();
        Enumeration enumeration = relation.list(this.id, false);
        Tr.exit((TraceComponent)tc, (String)"listClones");
        return enumeration;
    }

    public Enumeration getRelationships(boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getRelationships", (Object)new Boolean(bl));
        Enumeration enumeration = this.getRelationshipsForInstance(bl);
        Tr.exit((TraceComponent)tc, (String)"getRelationships", (Object)enumeration);
        return enumeration;
    }

    /*
     * Unable to fully structure code
     */
    public Act start() throws RemoteException, OpException {
        Tr.entry((TraceComponent)ModelBean.tc, (String)"start");
        ++this.configNo;
        if (ModelBean.tc.isEventEnabled()) {
            Tr.event((TraceComponent)ModelBean.tc, (String)("Incremented configNo: configNo = " + this.configNo));
        }
        var1_1 = null;
        var2_2 = this.listClones();
        if (var2_2.hasMoreElements()) ** GOTO lbl11
        throw new EmptyObjectGroupStartException();
lbl-1000:
        // 1 sources

        {
            var3_3 = (LiveRepositoryObject)var2_2.nextElement();
            var1_1 = var3_3.start();
lbl11:
            // 2 sources

            ** while (var2_2.hasMoreElements())
        }
lbl12:
        // 1 sources

        var3_4 = true;
        this.recursiveStart(var3_4);
        var3_4 = false;
        this.recursiveStart(var3_4);
        Tr.exit((TraceComponent)ModelBean.tc, (String)"start", (Object)var1_1);
        return var1_1;
    }

    public void recursiveStart(boolean bl) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"recursiveStart", (Object)new Boolean(bl));
        this.ifStarted = true;
        this.startTime = System.currentTimeMillis();
        this.dirty = true;
        if (bl) {
            try {
                Model model = (Model)this.getContainingObject();
                model.recursiveStart(true);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                return;
            }
        } else {
            Enumeration enumeration = this.listContainedObjects();
            while (enumeration.hasMoreElements()) {
                Model model = (Model)enumeration.nextElement();
                model.recursiveStart(false);
            }
        }
        Tr.exit((TraceComponent)tc, (String)"recursiveStart");
    }

    /*
     * Unable to fully structure code
     */
    public Act stop(int var1_1) throws RemoteException, OpException {
        Tr.entry((TraceComponent)ModelBean.tc, (String)"stop");
        ++this.configNo;
        if (ModelBean.tc.isEventEnabled()) {
            Tr.event((TraceComponent)ModelBean.tc, (String)("Incremented configNo: configNo = " + this.configNo));
        }
        var2_2 = null;
        var3_3 = this.listClones();
        if (var3_3.hasMoreElements()) ** GOTO lbl15
        throw new EmptyObjectGroupStopException();
lbl-1000:
        // 1 sources

        {
            var4_4 = (LiveRepositoryObject)var3_3.nextElement();
            try {
                var2_2 = var4_4.stop(var1_1);
                continue;
            }
            catch (ActiveObjectStoppedException var5_5) {
                Tr.event((TraceComponent)ModelBean.tc, (String)"Clone is already stopped. Ignoring.", (Object)var4_4);
            }
lbl15:
            // 3 sources

            ** while (var3_3.hasMoreElements())
        }
lbl16:
        // 1 sources

        this.recursiveStop();
        Tr.exit((TraceComponent)ModelBean.tc, (String)"stop");
        if (var2_2 == null) {
            Tr.event((TraceComponent)ModelBean.tc, (String)"All clones already stopped");
            var2_2 = this.scheduleDummyTask();
        }
        return var2_2;
    }

    public void recursiveStop() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"recursiveStop");
        this.ifStarted = false;
        this.startTime = 0L;
        this.dirty = true;
        Enumeration enumeration = this.listContainedObjects();
        while (enumeration.hasMoreElements()) {
            Model model = (Model)enumeration.nextElement();
            model.recursiveStop();
        }
        Tr.exit((TraceComponent)tc, (String)"recursiveStop");
    }

    public int getDesiredState() throws RemoteException, OpException {
        throw new OpException(nls.getString("model.state.exception1", "DesiredState does not exist for Models"));
    }

    public Node getNode() throws RemoteException, OpException {
        throw new OpException(nls.getString("model.node.exception", "getNode not implemented for Models"));
    }

    public int getCurrentState() throws RemoteException, OpException {
        throw new OpException(nls.getString("model.state.exception2", "CurrentState does not exist for Models"));
    }

    public ModelBean() throws RemoteException {
        ModelBean.initializeNLS("RepositoryStrings");
        Tr.entry((TraceComponent)tc, (String)"ModelBean");
        ModelBean.initializePersistentStore();
        ModelBean.initializeTypeId();
        Tr.exit((TraceComponent)tc, (String)"ModelBean");
    }

    protected static void initializeNLS(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeNLS");
        }
        if (nls == null) {
            nls = new NLS(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeNLS");
        }
    }

    public void ejbLoad() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbLoad");
        Long l = (Long)this.ec.getPrimaryKey();
        DBQueryResult dBQueryResult = null;
        try {
            block6: {
                try {
                    dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                    ResultSet resultSet = dBQueryResult.getResultSet();
                    if (!resultSet.next()) {
                        RemoteException remoteException = new RemoteException(nls.getFormattedMessage("appl.db.select0.exception", new Object[]{l, tableName}, "ApplicationBean select failed to find application instance {0} in table {1}."), new ObjectNotFoundException());
                        Tr.exit((TraceComponent)tc, (String)"ejbLoad - with no resultSet exception", (Object)remoteException);
                        throw remoteException;
                    }
                    if (!this.setId(resultSet, myTypeId)) break block6;
                    super.ejbLoad();
                    this.name = resultSet.getString(3);
                    this.cloneInterfaceClassName = resultSet.getString(4);
                    this.ifStarted = Utils.intToBoolean((int)resultSet.getInt(5));
                    this.startTime = Long.parseLong(resultSet.getString(6));
                    this.configNo = Long.parseLong(resultSet.getString(7));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ejbLoad: configNo = " + this.configNo));
                    }
                    this.numClones = Long.parseLong(resultSet.getString(8));
                    this.getBinaryAttributes();
                }
                catch (SQLException sQLException) {
                    RemoteException remoteException = new RemoteException(nls.getFormattedMessage("appl.db.select1.exception", new Object[]{sQLException.getMessage()}, "ApplicationBean select failed due to {0}."), sQLException);
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad - with java.sql.SQLException", (Object)remoteException);
                    throw remoteException;
                }
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        Tr.exit((TraceComponent)tc, (String)"ejbLoad");
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        if (this.narrowRef != null) {
            return;
        }
        super.ejbStore();
        if (this.dirty) {
            try {
                Vector<Object> vector = new Vector<Object>(4);
                vector.addElement(this.name);
                vector.addElement(this.cloneInterfaceClassName);
                vector.addElement(new Integer(Utils.booleanToInt((boolean)this.ifStarted)));
                vector.addElement(Long.toString(this.startTime));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ejbStore: configNo = " + this.configNo));
                }
                vector.addElement(Long.toString(this.configNo));
                vector.addElement(Long.toString(this.numClones));
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("appl.db.update0.exception", new Object[]{sQLException.getMessage(), this.name, this.id}, "ApplicationBean update failed due to {0} for statement with name = {1} id = {2}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbStore - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
        }
        Tr.exit((TraceComponent)tc, (String)"ejbStore");
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        if (this.id == null) {
            this.ejbLoad();
        }
        if (this.narrowRef != null) {
            this.narrowRef.remove();
            return;
        }
        this.informWLMofModelRemove();
        super.ejbRemove();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)this.id));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("appl.db.delete0.exception", new Object[]{sQLException.getMessage(), this.id}, "ApplicationBean delete failed due to {0} for id = {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbRemove - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public Long ejbCreate(ModelAttributes modelAttributes, Model model) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"ejbCreate(ModelAttributes, Model)");
        try {
            this.name = modelAttributes.getName();
            if (model == null) {
                boolean bl = true;
                try {
                    this.ejbFindByName(this.name, true);
                }
                catch (FinderException finderException) {
                    bl = false;
                }
                if (bl) {
                    InvalidModelNameException invalidModelNameException = new InvalidModelNameException();
                    Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)invalidModelNameException);
                    throw invalidModelNameException;
                }
            }
            if (this.typeId == null) {
                this.typeId = myTypeId;
            }
            this.initializeInstanceVariables();
            this.cloneInterfaceClassName = modelAttributes.getCloneInterfaceClass();
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("cloneInterfaceClassName: " + this.cloneInterfaceClassName));
            }
            try {
                this.instanceAttributes = modelAttributes.getAttributes();
                if (!this.instanceAttributes.checkSetAttributes(65535L)) {
                    this.ec.setRollbackOnly();
                    throw new CreateException(nls.getString("model.create.exception1", "Inapplicable attributes provided for model instance"));
                }
            }
            catch (AttributeNotSetException attributeNotSetException) {
                Type type = RepositoryObjectImpl.getTypeObj(this.cloneInterfaceClassName);
                if (type != null) {
                    this.instanceAttributes = RepositoryObjectImpl.getDefaults(type);
                }
                throw new CreateException(nls.getString("model.create.exception2", "CloneInterface type does  not exist in the repository"));
            }
            this.id = this.create(this.typeId);
            super.ejbCreate();
            this.setBinaryAttr(instanceAttributesAttrName, this.instanceAttributes);
            if (model != null) {
                Relation relation = ModelBean.lookupModelModelContainmentRel();
                relation.addUsingKeys((Long)model.getPrimaryKey(), this.id, this.name);
            }
            Vector<Object> vector = new Vector<Object>(8);
            vector.addElement(Utils.getIdString((Long)this.id));
            vector.addElement(Utils.getIdString((Long)this.typeId));
            vector.addElement(this.name);
            vector.addElement(this.cloneInterfaceClassName);
            vector.addElement(new Integer(Utils.booleanToInt((boolean)this.ifStarted)));
            vector.addElement(Long.toString(this.startTime));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ejbCreate: configNo = " + this.configNo));
            }
            vector.addElement(Long.toString(this.configNo));
            vector.addElement(Long.toString(this.numClones));
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"< ejbCreate -- required attributes missing", (Object)((Object)attributeNotSetException));
            throw new RequiredAttributeMissingException();
        }
        catch (RelationOpException relationOpException) {
            InvalidModelNameException invalidModelNameException = new InvalidModelNameException();
            Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)((Object)relationOpException));
            this.ec.setRollbackOnly();
            throw invalidModelNameException;
        }
        catch (OpException opException) {
            this.ec.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"< ejbCreate -- listClones of containingModel failed ", (Object)((Object)opException));
            throw new CreateException(nls.getString("model.create.exception3", "ListClones of containingModel failed: ") + opException.toString());
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("appl.db.insert0.exception", new Object[]{sQLException.getMessage(), this.id, this.typeId}, "ApplicationBean insert failed due to {0} for statement with id = {1} typeId = {2}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbCreate - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)this.id);
        return this.id;
    }

    public Long ejbCreate(ModelAttributes modelAttributes, EJBObject eJBObject, boolean bl) throws RemoteException, CreateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("ejbCreate: instance: " + eJBObject + " makeInstanceAClone: " + new Boolean(bl)));
        }
        Long l = this.createInternal(null, modelAttributes, eJBObject, bl);
        Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)l);
        return l;
    }

    public Long ejbCreate(ModelAttributes modelAttributes, Model model, EJBObject eJBObject) throws RemoteException, CreateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("ejbCreate: instance: " + eJBObject));
        }
        Long l = this.createInternal(model, modelAttributes, eJBObject, false);
        Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)l);
        return l;
    }

    private Long createInternal(Model model, ModelAttributes modelAttributes, EJBObject eJBObject, boolean bl) throws RemoteException, CreateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createInternal: containingModel: " + model + " instance: " + eJBObject + " makeInstanceAClone: " + new Boolean(bl)));
        }
        RepositoryObject repositoryObject = (RepositoryObject)PortableRemoteObject.narrow((Object)eJBObject, (Class)(class$com$ibm$ejs$sm$beans$RepositoryObject == null ? (class$com$ibm$ejs$sm$beans$RepositoryObject = ModelBean.class$("com.ibm.ejs.sm.beans.RepositoryObject")) : class$com$ibm$ejs$sm$beans$RepositoryObject));
        Attributes attributes = null;
        try {
            Constable constable;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("cloneInstance: " + repositoryObject + " class: " + repositoryObject.getClass()));
            }
            if (repositoryObject != null) {
                this.cloneInterfaceClassName = modelAttributes.getCloneInterfaceClass();
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("cloneInterfaceClassName: " + this.cloneInterfaceClassName));
                }
                constable = Class.forName(this.cloneInterfaceClassName);
                try {
                    repositoryObject = (RepositoryObject)PortableRemoteObject.narrow((Object)eJBObject, (Class)constable);
                }
                catch (ClassCastException classCastException) {
                    Tr.exit((TraceComponent)tc, (String)"", (Object)classCastException);
                    this.ec.setRollbackOnly();
                    throw new CreateException(nls.getString("model.create.exception4", "cloneInstance is not of the given clone type specified for this model instance"));
                }
                Class<?> clazz = Class.forName(this.cloneInterfaceClassName + "Attributes");
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("cloneAttributesClass: " + clazz));
                }
                attributes = (Attributes)clazz.newInstance();
                attributes.requestAll();
                attributes = repositoryObject.getAttributes(attributes);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("cloneAttrs: " + attributes));
                }
                try {
                    Attributes attributes2 = modelAttributes.getAttributes();
                    attributes.copyAttributes(attributes2, 65535L, true);
                }
                catch (AttributeNotSetException attributeNotSetException) {
                    Tr.event((TraceComponent)tc, (String)"Attributes attribute in Model not set. ", (Object)((Object)attributeNotSetException));
                }
                attributes.clearAll(8L);
                modelAttributes.setAttributes(attributes);
            }
            constable = this.ejbCreate(modelAttributes, model);
            if (bl) {
                this.associateClone(eJBObject);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)classNotFoundException);
            throw new RemoteException("", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)illegalAccessException);
            throw new RemoteException("", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)instantiationException);
            throw new RemoteException("", instantiationException);
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)((Object)attributeNotSetException));
            this.ec.setRollbackOnly();
            throw new RequiredAttributeMissingException(attributeNotSetException.toString());
        }
        catch (OpException opException) {
            Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)((Object)opException));
            this.ec.setRollbackOnly();
            throw new CreateException(opException.toString());
        }
        Tr.exit((TraceComponent)tc, (String)"createInternal", (Object)this.id);
        return this.id;
    }

    public void ejbPostCreate(ModelAttributes modelAttributes, Model model) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"ejbPostCreate(ModelAttributes, Model)");
        this.createCloneIfNec(model);
        Tr.exit((TraceComponent)tc, (String)"ejbPostCreate(ModelAttributes, Model)");
    }

    private void createCloneIfNec(Model model) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"createCloneIfNec");
        try {
            if (model != null) {
                Enumeration enumeration = model.listClones();
                while (enumeration.hasMoreElements()) {
                    EJBObject eJBObject = (EJBObject)enumeration.nextElement();
                    this.clone(null, eJBObject, true);
                    this.dirty = true;
                }
            }
        }
        catch (OpException opException) {
            this.ec.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"< createCloneIfNec -- listClones of containingModel failed ", (Object)((Object)opException));
            throw new CreateException(nls.getString("model.create.exception5", "ListClones of containingModel failed: ") + opException.toString());
        }
    }

    public void ejbPostCreate(ModelAttributes modelAttributes, EJBObject eJBObject, boolean bl) {
    }

    public void ejbPostCreate(ModelAttributes modelAttributes, Model model, EJBObject eJBObject) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"ejbPostCreate(ModelAttributes, Model, EJBObject)");
        this.createCloneIfNec(model);
        Tr.exit((TraceComponent)tc, (String)"ejbPostCreate(ModelAttributes, Model, EJBObject)");
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException, FinderException {
        Enumeration enumeration;
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll", (Object)new Boolean(bl));
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)bl, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)((ObjectCollection)enumeration).getArray());
        return enumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByName", (Object)string);
        DBQueryResult dBQueryResult = null;
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByNameStmtKey, (String)findByNameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByNameStmtKey, (String)restrictedFindByNameStmtSql, vector);
                }
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName");
                l = this.singleFinderEpilogue(dBQueryResult);
                Object var7_8 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("appl.db.select4.exception", new Object[]{sQLException.getMessage(), string}, "ApplicationBean findByName failed due to {0} for name {1}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    private static void initializePersistentStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        Integer n = classLock;
        synchronized (n) {
            if (tableCreated) {
                Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
                return;
            }
        }
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + nameColumnName + DBMgr.mediumStringColumnSpec + " , " + cloneInterfaceClassColumnName + DBMgr.mediumStringColumnSpec + " , " + ifStartedColumnName + " integer not null, " + startTimeColumnName + DBMgr.idColumnSpec + " , " + configNoColumnName + DBMgr.idColumnSpec + " , " + numClonesColumnName + DBMgr.idColumnSpec + " , " + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Integer n2 = classLock;
            synchronized (n2) {
                tableCreated = true;
            }
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("appl.db.create0.exception", new Object[]{tableName, sQLException.getMessage()}, "ApplicationBean could not create table {0} because of {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"initializePersistentStore - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
    }

    private static void initializeTypeId() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        Integer n = classLock;
        synchronized (n) {
            if (myTypeId != null) {
                Tr.exit((TraceComponent)tc, (String)"initializeTypeId");
                return;
            }
        }
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, new ModelAttributes(), true);
        Long l = (Long)type.getPrimaryKey();
        Integer n2 = classLock;
        synchronized (n2) {
            myTypeObj = type;
            myTypeId = l;
        }
        Tr.exit((TraceComponent)tc, (String)"initializeTypeId");
    }

    private void initializeInstanceVariables() throws RemoteException {
    }

    private static Relation lookupModelModelContainmentRel() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (modelModelContainmentRel != null) {
                Relation relation = modelModelContainmentRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.createRelIfNeeded(myTypeObj, "Model", modelModelContainmentRelName, true, true, 2);
        Integer n2 = classLock;
        synchronized (n2) {
            modelModelContainmentRel = relation;
        }
        return relation;
    }

    private Relation lookupModelCloneRel() throws RemoteException {
        String string = "Model" + this.getUnqualifiedCloneInterfaceName() + "Rel";
        Relation relation = RepositoryObjectImpl.createRelIfNeeded(myTypeObj, this.getUnqualifiedCloneInterfaceName(), string, false, false, 2);
        return relation;
    }

    private String getUnqualifiedCloneInterfaceName() {
        Tr.entry((TraceComponent)tc, (String)"getUnqualifiedCloneInterfaceName");
        String string = this.cloneInterfaceClassName.substring(this.cloneInterfaceClassName.lastIndexOf(46) + 1);
        Tr.exit((TraceComponent)tc, (String)"getUnqualifiedCloneInterfaceName");
        return string;
    }

    private void renameIfNec(Attributes attributes) throws RemoteException, OpException {
        block11: {
            Tr.entry((TraceComponent)tc, (String)"renameIfNec ");
            try {
                if (!attributes.isSet(Attributes.name)) break block11;
                String string = attributes.getName();
                if (string.equals(this.name)) {
                    Tr.exit((TraceComponent)tc, (String)"validateNameChange");
                    return;
                }
                Model model = null;
                try {
                    model = (Model)this.getContainingObject();
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                }
                catch (Exception exception) {
                    throw new RemoteException("", exception);
                }
                if (model == null) {
                    try {
                        this.ejbFindByName(string, true);
                        Tr.exit((TraceComponent)tc, (String)"validateNameChange -- duplicate name");
                        throw new InvalidNameChangeException();
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {}
                } else {
                    this.renameIfNec(attributes, ModelBean.lookupModelModelContainmentRel());
                }
                this.name = string;
            }
            catch (InvalidNameChangeException invalidNameChangeException) {
                throw invalidNameChangeException;
            }
            catch (Exception exception) {
                Tr.exit((TraceComponent)tc, (String)"renameIfNec -- unexpected error", (Object)exception);
                throw new RemoteException("", exception);
            }
        }
        Tr.exit((TraceComponent)tc, (String)"renameIfNec");
    }

    private void getBinaryAttributes() throws RemoteException {
        this.instanceAttributes = (Attributes)this.getBinaryAttr(instanceAttributesAttrName);
    }

    private void pushModelChangesForWLM(long l) throws OpException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"pushModelChangesForWLM", (Object)new Long(l));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"cloneInterfaceClassName", (Object)this.cloneInterfaceClassName);
        }
        if (this.cloneInterfaceClassName.equals("com.ibm.ejs.sm.beans.EJBServer")) {
            boolean bl = false;
            if (l == 1L && this.configNo > 2L * this.numClones) {
                bl = true;
            }
            ((AdminServer)ManagedServer.getInstance()).pushModelChangesForWLM(this.name, bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pushModelChangesForWLM");
        }
    }

    private void informWLMofModelRemove() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"informWLMofModelRemove");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"cloneInterfaceClassName", (Object)this.cloneInterfaceClassName);
        }
        if (this.cloneInterfaceClassName.equals("com.ibm.ejs.sm.beans.EJBServer")) {
            ((AdminServer)ManagedServer.getInstance()).informWLMofModelRemove(this.name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"informWLMofModelRemove");
        }
    }

    private CloneCreateMethod getCloneCreateMethod(Class clazz, Class clazz2, Class clazz3) throws Exception {
        Method method;
        Class[] classArray;
        Tr.entry((TraceComponent)tc, (String)"getCloneCreateMethod");
        CloneCreateMethod cloneCreateMethod = null;
        try {
            classArray = new Class[]{class$com$ibm$ejs$sm$beans$Model == null ? (class$com$ibm$ejs$sm$beans$Model = ModelBean.class$("com.ibm.ejs.sm.beans.Model")) : class$com$ibm$ejs$sm$beans$Model, clazz2, clazz3};
            method = clazz.getMethod("create", classArray);
            cloneCreateMethod = new CloneCreateMethod(method, true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Tr.event((TraceComponent)tc, (String)"No special create method for creating clones.");
        }
        if (cloneCreateMethod == null) {
            classArray = new Class[]{clazz2, clazz3};
            method = clazz.getMethod("create", classArray);
            cloneCreateMethod = new CloneCreateMethod(method, false);
        }
        Tr.exit((TraceComponent)tc, (String)"getCloneCreateMethod");
        return cloneCreateMethod;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CloneCreateMethod {
        Method m;
        boolean provideModelParam;

        CloneCreateMethod(Method method, boolean bl) {
            this.m = method;
            this.provideModelParam = bl;
        }
    }
}

