/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.beans.BinaryAttrSerialization;
import com.ibm.ejs.sm.beans.CloneOnlyAwareConfig;
import com.ibm.ejs.sm.beans.SecureSocketLayerConfig;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ORBConfig
implements Serializable,
BinaryAttrSerialization,
CloneOnlyAwareConfig {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$ORBConfig == null ? (class$com$ibm$ejs$sm$beans$ORBConfig = ORBConfig.class$("com.ibm.ejs.sm.beans.ORBConfig")) : class$com$ibm$ejs$sm$beans$ORBConfig));
    private static final long serialVersionUID = 0L;
    private String compositeORBProperties;
    private Hashtable orbPropertiesTable;
    private String bootstrapHostname;
    private int bootstrapPort = 900;
    private boolean commTraceEnabled = false;
    private int connectionCacheMaximum = 240;
    private int connectionCacheMinimum = 100;
    private String externalConfigURL;
    private String forceTunnel = "whenrequired";
    private int listenerPort;
    private int locateRequestTimeout = 180;
    private String localHostname;
    private String LSDHostname;
    private boolean noLocalCopies = false;
    private int requestRetriesCount = 1;
    private int requestRetriesDelay = 0;
    private int requestTimeout = 180;
    private int threadPoolSize = 20;
    private String tunnelAgentURL;
    private String RMIRemoteCodebase;
    private int sslListenerPort;
    private SecureSocketLayerConfig sslConfig = null;
    public static final String ENABLE_HTTP_TUNNELING_ALWAYS = "always";
    public static final String ENABLE_HTTP_TUNNELING_NEVER = "never";
    public static final String ENABLE_HTTP_TUNNELING_WHENREQUIRED = "whenrequired";
    public static final int DEFAULT_BOOTSTRAP_PORT = 900;
    public static final int DEFAULT_THREADPOOL_SIZE = 20;
    public static final int DEFAULT_REQUEST_TIMEOUT = 180;
    public static final int DEFAULT_LOCATE_REQUEST_TIMEOUT = 180;
    public static final int DEFAULT_CONNECTION_CACHE_MAX = 240;
    public static final int DEFAULT_CONNECTION_CACHE_MIN = 100;
    public static final int DEFAULT_REQUEST_RETRY = 1;
    public static final int DEFAULT_REQUEST_RETRY_DELAY = 0;
    public static final String DEFAULT_ENABLE_HTTP_TUNNELING = "whenrequired";
    public static final String DEFAULT_NO_LOCAL_COPIES_UTILCLASS = "com.ibm.CORBA.iiop.Util";
    public static final String BOOTSTRAP_HOST_PROPERTY = "com.ibm.CORBA.BootstrapHost";
    public static final String BOOTSTRAP_PORT_PROPERTY = "com.ibm.CORBA.BootstrapPort";
    public static final String LOCAL_HOSTNAME_PROPERTY = "com.ibm.CORBA.LocalHost";
    public static final String LISTENER_PORT_PROPERTY = "com.ibm.CORBA.ListenerPort";
    public static final String LSD_HOSTNAME_PROPERTY = "com.ibm.CORBA.LSDHostName";
    public static final String REQUEST_TIMEOUT_PROPERTY = "com.ibm.CORBA.requestTimeout";
    public static final String LOCATE_REQUEST_TIMEOUT_PROPERTY = "com.ibm.CORBA.locateRequestTimeout";
    public static final String CONNECTION_CACHE_MAX_PROPERTY = "com.ibm.CORBA.MaxOpenConnections";
    public static final String CONNECTION_CACHE_MIN_PROPERTY = "com.ibm.CORBA.MinOpenConnections";
    public static final String ENABLE_HTTP_TUNNELING_PROPERTY = "com.ibm.CORBA.ForceTunnel";
    public static final String TUNNEL_AGENT_URL_PROPERTY = "com.ibm.CORBA.TunnelAgentURL";
    public static final String NO_LOCAL_COPIES_PROPERTY = "com.ibm.CORBA.iiop.noLocalCopies";
    public static final String NO_LOCAL_COPIES_UTILCLASS_PROPERTY = "javax.rmi.CORBA.UtilClass";
    public static final String REQUEST_RETRIES_COUNT_PROPERTY = "com.ibm.CORBA.requestRetriesCount";
    public static final String REQUEST_RETRIES_DELAY_PROPERTY = "com.ibm.CORBA.requestRetriesDelay";
    public static final String EXTERNAL_CONFIG_URL_PROPERTY = "com.ibm.CORBA.ConfigURL";
    public static final String THREAD_POOL_SIZE_PROPERTY = "com.ibm.CORBA.ThreadPoolSize";
    public static final String RMI_REMOTE_CODEBASE_PROPERTY = "java.rmi.server.codebase";
    public static final String COMM_TRACE_PROPERTY1 = "com.ibm.CORBA.Debug";
    public static final String COMM_TRACE_PROPERTY2 = "com.ibm.CORBA.CommTrace";
    public static final String SSL_LISTENER_PORT_PROPERTY = "com.ibm.CORBA.SSLListenerPort";
    private static ORBConfig cfg;
    public static final String compositeORBPropertiesPropKey = "compositeORBProperties";
    public static final String orbPropertiesTablePropKey = "orbPropertiesTable";
    public static final String bootstrapHostnamePropKey = "bootstrapHostname";
    public static final String bootstrapPortPropKey = "bootstrapPort";
    public static final String commTraceEnabledPropKey = "commTraceEnabled";
    public static final String connectionCacheMaximumPropKey = "connectionCacheMaximum";
    public static final String connectionCacheMinimumPropKey = "connectionCacheMinimum";
    public static final String externalConfigURLPropKey = "externalConfigURL";
    public static final String forceTunnelPropKey = "forceTunnel";
    public static final String listenerPortPropKey = "listenerPort";
    public static final String locateRequestTimeoutPropKey = "locateRequestTimeout";
    public static final String localHostnamePropKey = "localHostname";
    public static final String LSDHostnamePropKey = "LSDHostname";
    public static final String noLocalCopiesPropKey = "noLocalCopies";
    public static final String requestRetriesCountPropKey = "requestRetriesCount";
    public static final String requestRetriesDelayPropKey = "requestRetriesDelay";
    public static final String requestTimeoutPropKey = "requestTimeout";
    public static final String threadPoolSizePropKey = "threadPoolSize";
    public static final String tunnelAgentURLPropKey = "tunnelAgentURL";
    public static final String RMIRemoteCodebasePropKey = "RMIRemoteCodebase";
    public static final String sslListenerPortPropKey = "sslListenerPort";
    public static final String sslConfigPropKey = "sslConfig";
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$ORBConfig;

    public ORBConfig() {
    }

    public ORBConfig(ORBConfig oRBConfig) {
        this();
        if (oRBConfig != null) {
            if (oRBConfig.bootstrapHostname != null) {
                this.bootstrapHostname = new String(oRBConfig.bootstrapHostname);
            }
            this.bootstrapPort = oRBConfig.bootstrapPort;
            this.commTraceEnabled = oRBConfig.commTraceEnabled;
            this.connectionCacheMaximum = oRBConfig.connectionCacheMaximum;
            this.connectionCacheMinimum = oRBConfig.connectionCacheMinimum;
            if (oRBConfig.externalConfigURL != null) {
                this.externalConfigURL = new String(oRBConfig.externalConfigURL);
            }
            if (oRBConfig.forceTunnel != null) {
                this.forceTunnel = new String(oRBConfig.forceTunnel);
            }
            this.listenerPort = oRBConfig.listenerPort;
            this.locateRequestTimeout = oRBConfig.locateRequestTimeout;
            if (oRBConfig.localHostname != null) {
                this.localHostname = new String(oRBConfig.localHostname);
            }
            if (oRBConfig.LSDHostname != null) {
                this.LSDHostname = new String(oRBConfig.LSDHostname);
            }
            this.noLocalCopies = oRBConfig.noLocalCopies;
            this.requestRetriesCount = oRBConfig.requestRetriesCount;
            this.requestRetriesDelay = oRBConfig.requestRetriesDelay;
            this.requestTimeout = oRBConfig.requestTimeout;
            this.threadPoolSize = oRBConfig.threadPoolSize;
            if (oRBConfig.tunnelAgentURL != null) {
                this.tunnelAgentURL = new String(oRBConfig.tunnelAgentURL);
            }
            if (oRBConfig.RMIRemoteCodebase != null) {
                this.RMIRemoteCodebase = new String(oRBConfig.RMIRemoteCodebase);
            }
            this.sslListenerPort = oRBConfig.sslListenerPort;
            this.sslConfig = oRBConfig.sslConfig == null ? null : new SecureSocketLayerConfig(oRBConfig.sslConfig);
        }
    }

    public Hashtable getOrbPropertiesTable() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ORBConfig member variables: \nbootstrapHostname=" + this.bootstrapHostname + "\n" + "bootstrapPort=" + this.bootstrapPort + "\n" + "commTraceEnabled=" + this.commTraceEnabled + "\n" + "connectionCacheMaximum=" + this.connectionCacheMaximum + "\n" + "connectionCacheMinimum=" + this.connectionCacheMinimum + "\n" + "externalConfigURL=" + this.externalConfigURL + "\n" + "forceTunnel=" + this.forceTunnel + "\n" + "listenerPort=" + this.listenerPort + "\n" + "locateRequestTimeout=" + this.locateRequestTimeout + "\n" + "localHostname=" + this.localHostname + "\n" + "LSDHostname=" + this.LSDHostname + "\n" + "noLocalCopies=" + this.noLocalCopies + "\n" + "requestRetriesCount=" + this.requestRetriesCount + "\n" + "requestRetriesDelay=" + this.requestRetriesDelay + "\n" + "requestTimeout=" + this.requestTimeout + "\n" + "threadPoolSize=" + this.threadPoolSize + "\n" + "tunnelAgentURL=" + this.tunnelAgentURL + "\n" + "RMIRemoteCodebase=" + this.RMIRemoteCodebase));
        }
        this.orbPropertiesTable = new Hashtable();
        if (this.threadPoolSize != 20 && this.threadPoolSize != 0) {
            this.orbPropertiesTable.put(THREAD_POOL_SIZE_PROPERTY, new Integer(this.threadPoolSize));
        }
        if (this.bootstrapHostname != null && !this.bootstrapHostname.trim().equals("")) {
            this.orbPropertiesTable.put(BOOTSTRAP_HOST_PROPERTY, this.bootstrapHostname);
        }
        if (this.bootstrapPort != 900 && this.bootstrapPort != 0) {
            this.orbPropertiesTable.put(BOOTSTRAP_PORT_PROPERTY, new Integer(this.bootstrapPort));
        }
        if (this.commTraceEnabled) {
            this.orbPropertiesTable.put(COMM_TRACE_PROPERTY1, "true");
            this.orbPropertiesTable.put(COMM_TRACE_PROPERTY2, "true");
        }
        if (this.connectionCacheMaximum != 240 && this.connectionCacheMaximum != 0) {
            this.orbPropertiesTable.put(CONNECTION_CACHE_MAX_PROPERTY, new Integer(this.connectionCacheMaximum));
        }
        if (this.connectionCacheMinimum != 100 && this.connectionCacheMinimum != 0) {
            this.orbPropertiesTable.put(CONNECTION_CACHE_MIN_PROPERTY, new Integer(this.connectionCacheMinimum));
        }
        if (this.externalConfigURL != null && !this.externalConfigURL.trim().equals("")) {
            this.orbPropertiesTable.put(EXTERNAL_CONFIG_URL_PROPERTY, this.externalConfigURL);
        }
        if (!this.forceTunnel.equals("whenrequired") && !this.forceTunnel.trim().equals("")) {
            this.orbPropertiesTable.put(ENABLE_HTTP_TUNNELING_PROPERTY, this.forceTunnel);
        }
        if (this.listenerPort != 0) {
            this.orbPropertiesTable.put(LISTENER_PORT_PROPERTY, new Integer(this.listenerPort));
        }
        if (this.sslListenerPort != 0) {
            this.orbPropertiesTable.put(SSL_LISTENER_PORT_PROPERTY, new Integer(this.sslListenerPort));
        }
        if (this.locateRequestTimeout != 180 && this.locateRequestTimeout != 0) {
            this.orbPropertiesTable.put(LOCATE_REQUEST_TIMEOUT_PROPERTY, new Integer(this.locateRequestTimeout));
        }
        if (this.localHostname != null && !this.localHostname.trim().equals("")) {
            this.orbPropertiesTable.put(LOCAL_HOSTNAME_PROPERTY, this.localHostname);
        }
        if (this.LSDHostname != null && !this.LSDHostname.trim().equals("")) {
            this.orbPropertiesTable.put(LSD_HOSTNAME_PROPERTY, this.LSDHostname);
        }
        if (this.noLocalCopies) {
            this.orbPropertiesTable.put(NO_LOCAL_COPIES_PROPERTY, new Boolean(this.noLocalCopies));
            this.orbPropertiesTable.put(NO_LOCAL_COPIES_UTILCLASS_PROPERTY, DEFAULT_NO_LOCAL_COPIES_UTILCLASS);
        }
        if (this.requestRetriesCount != 1 && this.requestRetriesCount != 0) {
            this.orbPropertiesTable.put(REQUEST_RETRIES_COUNT_PROPERTY, new Integer(this.requestRetriesCount));
        }
        if (this.requestRetriesDelay != 0 && this.requestRetriesDelay != 0) {
            this.orbPropertiesTable.put(REQUEST_RETRIES_DELAY_PROPERTY, new Integer(this.requestRetriesDelay));
        }
        if (this.requestTimeout != 180 && this.requestTimeout != 0) {
            this.orbPropertiesTable.put(REQUEST_TIMEOUT_PROPERTY, new Integer(this.requestTimeout));
        }
        if (this.tunnelAgentURL != null && !this.tunnelAgentURL.trim().equals("")) {
            this.orbPropertiesTable.put(TUNNEL_AGENT_URL_PROPERTY, this.tunnelAgentURL);
        }
        if (this.RMIRemoteCodebase != null && !this.RMIRemoteCodebase.trim().equals("")) {
            this.orbPropertiesTable.put(RMI_REMOTE_CODEBASE_PROPERTY, this.RMIRemoteCodebase);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ORBConfig properties table : " + this.orbPropertiesTable));
        }
        return this.orbPropertiesTable;
    }

    public static void main(String[] stringArray) {
        System.out.println("ORBConfig test.");
        ORBConfig.printTest("initial constructor");
        cfg = new ORBConfig();
        ORBConfig.printProps();
        ORBConfig.printTest("modify bootstrapHostname");
        cfg.setBootstrapHostname("myBootstrapHost");
        ORBConfig.printProps();
        ORBConfig.printTest("modify bootstrapPort");
        cfg.setBootstrapPort(25);
        ORBConfig.printProps();
        ORBConfig.printTest("reset bootstrapPort to default");
        cfg.setBootstrapPort(900);
        ORBConfig.printProps();
        ORBConfig.printTest("reset bootstrapPort to 0");
        cfg.setBootstrapPort(0);
        ORBConfig.printProps();
        ORBConfig.printTest("modify threadPoolSize");
        cfg.setThreadPoolSize(25);
        ORBConfig.printProps();
        ORBConfig.printTest("modify requestTimeout");
        cfg.setRequestTimeout(222);
        ORBConfig.printProps();
        ORBConfig.printTest("reset bootstrapHostname");
        cfg.setBootstrapHostname("  ");
        ORBConfig.printProps();
        ORBConfig.printTest("reset requestTimeout to default");
        cfg.setRequestTimeout(180);
        ORBConfig.printProps();
        ORBConfig.printTest("reset threadPoolSize");
        cfg.setThreadPoolSize(20);
        ORBConfig.printProps();
        ORBConfig.printTest("reset requestTimeout to 0");
        cfg.setRequestTimeout(0);
        ORBConfig.printProps();
        ORBConfig.printTest("modify connectionCacheMaximum");
        cfg.setConnectionCacheMaximum(500);
        ORBConfig.printProps();
        ORBConfig.printTest("modify connectionCacheMinimum");
        cfg.setConnectionCacheMinimum(50);
        ORBConfig.printProps();
        ORBConfig.printTest("reset connectionCacheMaximum to default");
        cfg.setConnectionCacheMaximum(240);
        ORBConfig.printProps();
        ORBConfig.printTest("reset connectionCacheMinimum to 0");
        cfg.setConnectionCacheMinimum(0);
        ORBConfig.printProps();
        ORBConfig.printTest("set connectionCacheMaximum to 0");
        cfg.setConnectionCacheMaximum(0);
        ORBConfig.printProps();
        ORBConfig.printTest("modify http tunneling");
        cfg.setForceTunnel(ENABLE_HTTP_TUNNELING_ALWAYS);
        cfg.setTunnelAgentURL("http://www.test.url");
        ORBConfig.printProps();
        ORBConfig.printTest("modify listenerPort");
        cfg.setListenerPort(1234);
        ORBConfig.printProps();
        ORBConfig.printTest("reset http tunneling");
        cfg.setForceTunnel("  ");
        cfg.setTunnelAgentURL("  ");
        ORBConfig.printProps();
        ORBConfig.printTest("reset listenerPort");
        cfg.setListenerPort(0);
        ORBConfig.printProps();
        ORBConfig.printTest("modify requestRetriesCount");
        cfg.setRequestRetriesCount(5);
        ORBConfig.printProps();
        ORBConfig.printTest("modify requestRetriesDelay");
        cfg.setRequestRetriesDelay(-1);
        ORBConfig.printProps();
        ORBConfig.printTest("reset requestRetriesCount to default");
        cfg.setRequestRetriesCount(1);
        ORBConfig.printProps();
        ORBConfig.printTest("reset requestRetriesDelay");
        cfg.setRequestRetriesDelay(0);
        ORBConfig.printProps();
        ORBConfig.printTest("modify RMIRemoteCodebase");
        cfg.setRMIRemoteCodebase("test.ibm.com");
        ORBConfig.printProps();
        ORBConfig.printTest("modify locateRequestTimeout");
        cfg.setLocateRequestTimeout(200);
        ORBConfig.printProps();
        ORBConfig.printTest("reset RMIRemoteCodebase");
        cfg.setRMIRemoteCodebase("  ");
        ORBConfig.printProps();
        ORBConfig.printTest("reset locateRequestTimeout");
        cfg.setLocateRequestTimeout(180);
        ORBConfig.printProps();
        ORBConfig.printTest("modify external config URL");
        cfg.setExternalConfigURL("http://www.test.url");
        ORBConfig.printProps();
        ORBConfig.printTest("modify noLocalCopies");
        cfg.setNoLocalCopies(true);
        ORBConfig.printProps();
        ORBConfig.printTest("reset external config URL");
        cfg.setExternalConfigURL("  ");
        ORBConfig.printProps();
        ORBConfig.printTest("modify commTraceEnabled");
        cfg.setCommTraceEnabled(true);
        ORBConfig.printProps();
        ORBConfig.printTest("reset noLocalCopies");
        cfg.setNoLocalCopies(false);
        ORBConfig.printProps();
        ORBConfig.printTest("reset commTraceEnabled");
        cfg.setCommTraceEnabled(false);
        ORBConfig.printProps();
    }

    private static void printProps() {
        System.out.println(cfg.getOrbPropertiesTable());
    }

    private static void printTest(String string) {
        System.out.println("******* ORBConfig: " + string + " : ");
    }

    public String getRMIRemoteCodebase() {
        return this.RMIRemoteCodebase;
    }

    public void setRMIRemoteCodebase(String string) {
        this.RMIRemoteCodebase = string;
    }

    public String getBootstrapHostname() {
        return this.bootstrapHostname;
    }

    public int getBootstrapPort() {
        return this.bootstrapPort;
    }

    public int getConnectionCacheMaximum() {
        return this.connectionCacheMaximum;
    }

    public int getConnectionCacheMinimum() {
        return this.connectionCacheMinimum;
    }

    public String getExternalConfigURL() {
        return this.externalConfigURL;
    }

    public String getForceTunnel() {
        return this.forceTunnel;
    }

    public int getListenerPort() {
        return this.listenerPort;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getLocateRequestTimeout() {
        return this.locateRequestTimeout;
    }

    public String getLSDHostname() {
        return this.LSDHostname;
    }

    public String getLocalHostname() {
        return this.localHostname;
    }

    public int getRequestRetriesCount() {
        return this.requestRetriesCount;
    }

    public int getRequestRetriesDelay() {
        return this.requestRetriesDelay;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getTunnelAgentURL() {
        return this.tunnelAgentURL;
    }

    public boolean isCommTraceEnabled() {
        return this.commTraceEnabled;
    }

    public boolean isNoLocalCopies() {
        return this.noLocalCopies;
    }

    public void setBootstrapHostname(String string) {
        this.bootstrapHostname = string;
    }

    public void setBootstrapPort(int n) {
        this.bootstrapPort = n;
    }

    public void setCommTraceEnabled(boolean bl) {
        this.commTraceEnabled = bl;
    }

    public void setConnectionCacheMaximum(int n) {
        this.connectionCacheMaximum = n;
    }

    public void setConnectionCacheMinimum(int n) {
        this.connectionCacheMinimum = n;
    }

    public void setExternalConfigURL(String string) {
        this.externalConfigURL = string;
    }

    public void setForceTunnel(String string) {
        this.forceTunnel = string;
    }

    public void setListenerPort(int n) {
        this.listenerPort = n;
    }

    public void setThreadPoolSize(int n) {
        this.threadPoolSize = n;
    }

    public void setLocateRequestTimeout(int n) {
        this.locateRequestTimeout = n;
    }

    public void setLocalHostname(String string) {
        this.localHostname = string;
    }

    public void setLSDHostname(String string) {
        this.LSDHostname = string;
    }

    public void setNoLocalCopies(boolean bl) {
        this.noLocalCopies = bl;
    }

    public void setRequestRetriesCount(int n) {
        this.requestRetriesCount = n;
    }

    public void setRequestRetriesDelay(int n) {
        this.requestRetriesDelay = n;
    }

    public void setRequestTimeout(int n) {
        this.requestTimeout = n;
    }

    public void setTunnelAgentURL(String string) {
        this.tunnelAgentURL = string;
    }

    public SecureSocketLayerConfig getSSLConfig() {
        return this.sslConfig;
    }

    public void setSSLConfig(SecureSocketLayerConfig secureSocketLayerConfig) {
        this.sslConfig = secureSocketLayerConfig;
    }

    public int getSSLListenerPort() {
        return this.sslListenerPort;
    }

    public void setSSLListenerPort(int n) {
        this.sslListenerPort = n;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        if (this.compositeORBProperties != null) {
            ((Hashtable)properties).put(compositeORBPropertiesPropKey, this.compositeORBProperties);
        }
        if (this.orbPropertiesTable != null) {
            ((Hashtable)properties).put(orbPropertiesTablePropKey, this.orbPropertiesTable);
        }
        if (this.bootstrapHostname != null) {
            ((Hashtable)properties).put(bootstrapHostnamePropKey, this.bootstrapHostname);
        }
        ((Hashtable)properties).put(bootstrapPortPropKey, new Integer(this.bootstrapPort));
        ((Hashtable)properties).put(commTraceEnabledPropKey, new Boolean(this.commTraceEnabled));
        ((Hashtable)properties).put(connectionCacheMaximumPropKey, new Integer(this.connectionCacheMaximum));
        ((Hashtable)properties).put(connectionCacheMinimumPropKey, new Integer(this.connectionCacheMinimum));
        if (this.externalConfigURL != null) {
            ((Hashtable)properties).put(externalConfigURLPropKey, this.externalConfigURL);
        }
        if (this.forceTunnel != null) {
            ((Hashtable)properties).put(forceTunnelPropKey, this.forceTunnel);
        }
        ((Hashtable)properties).put(listenerPortPropKey, new Integer(this.listenerPort));
        ((Hashtable)properties).put(locateRequestTimeoutPropKey, new Integer(this.locateRequestTimeout));
        if (this.localHostname != null) {
            ((Hashtable)properties).put(localHostnamePropKey, this.localHostname);
        }
        if (this.LSDHostname != null) {
            ((Hashtable)properties).put(LSDHostnamePropKey, this.LSDHostname);
        }
        ((Hashtable)properties).put(noLocalCopiesPropKey, new Boolean(this.noLocalCopies));
        ((Hashtable)properties).put(requestRetriesCountPropKey, new Integer(this.requestRetriesCount));
        ((Hashtable)properties).put(requestRetriesDelayPropKey, new Integer(this.requestRetriesDelay));
        ((Hashtable)properties).put(requestTimeoutPropKey, new Integer(this.requestTimeout));
        ((Hashtable)properties).put(threadPoolSizePropKey, new Integer(this.threadPoolSize));
        if (this.tunnelAgentURL != null) {
            ((Hashtable)properties).put(tunnelAgentURLPropKey, this.tunnelAgentURL);
        }
        if (this.RMIRemoteCodebase != null) {
            ((Hashtable)properties).put(RMIRemoteCodebasePropKey, this.RMIRemoteCodebase);
        }
        ((Hashtable)properties).put(sslListenerPortPropKey, new Integer(this.sslListenerPort));
        if (this.sslConfig != null) {
            ((Hashtable)properties).put(sslConfigPropKey, this.sslConfig);
        }
        return properties;
    }

    public void fromProperties(Properties properties) {
        if (((Hashtable)properties).containsKey(compositeORBPropertiesPropKey)) {
            this.compositeORBProperties = (String)((Hashtable)properties).get(compositeORBPropertiesPropKey);
        }
        if (((Hashtable)properties).containsKey(orbPropertiesTablePropKey)) {
            this.orbPropertiesTable = (Hashtable)((Hashtable)properties).get(orbPropertiesTablePropKey);
        }
        if (((Hashtable)properties).containsKey(bootstrapHostnamePropKey)) {
            this.bootstrapHostname = (String)((Hashtable)properties).get(bootstrapHostnamePropKey);
        }
        if (((Hashtable)properties).containsKey(bootstrapPortPropKey)) {
            this.bootstrapPort = (Integer)((Hashtable)properties).get(bootstrapPortPropKey);
        }
        if (((Hashtable)properties).containsKey(commTraceEnabledPropKey)) {
            this.commTraceEnabled = (Boolean)((Hashtable)properties).get(commTraceEnabledPropKey);
        }
        if (((Hashtable)properties).containsKey(connectionCacheMaximumPropKey)) {
            this.connectionCacheMaximum = (Integer)((Hashtable)properties).get(connectionCacheMaximumPropKey);
        }
        if (((Hashtable)properties).containsKey(connectionCacheMinimumPropKey)) {
            this.connectionCacheMinimum = (Integer)((Hashtable)properties).get(connectionCacheMinimumPropKey);
        }
        if (((Hashtable)properties).containsKey(externalConfigURLPropKey)) {
            this.externalConfigURL = (String)((Hashtable)properties).get(externalConfigURLPropKey);
        }
        if (((Hashtable)properties).containsKey(forceTunnelPropKey)) {
            this.forceTunnel = (String)((Hashtable)properties).get(forceTunnelPropKey);
        }
        if (((Hashtable)properties).containsKey(listenerPortPropKey)) {
            this.listenerPort = (Integer)((Hashtable)properties).get(listenerPortPropKey);
        }
        if (((Hashtable)properties).containsKey(locateRequestTimeoutPropKey)) {
            this.locateRequestTimeout = (Integer)((Hashtable)properties).get(locateRequestTimeoutPropKey);
        }
        if (((Hashtable)properties).containsKey(localHostnamePropKey)) {
            this.localHostname = (String)((Hashtable)properties).get(localHostnamePropKey);
        }
        if (((Hashtable)properties).containsKey(LSDHostnamePropKey)) {
            this.LSDHostname = (String)((Hashtable)properties).get(LSDHostnamePropKey);
        }
        if (((Hashtable)properties).containsKey(noLocalCopiesPropKey)) {
            this.noLocalCopies = (Boolean)((Hashtable)properties).get(noLocalCopiesPropKey);
        }
        if (((Hashtable)properties).containsKey(requestRetriesCountPropKey)) {
            this.requestRetriesCount = (Integer)((Hashtable)properties).get(requestRetriesCountPropKey);
        }
        if (((Hashtable)properties).containsKey(requestRetriesDelayPropKey)) {
            this.requestRetriesDelay = (Integer)((Hashtable)properties).get(requestRetriesDelayPropKey);
        }
        if (((Hashtable)properties).containsKey(requestTimeoutPropKey)) {
            this.requestTimeout = (Integer)((Hashtable)properties).get(requestTimeoutPropKey);
        }
        if (((Hashtable)properties).containsKey(threadPoolSizePropKey)) {
            this.threadPoolSize = (Integer)((Hashtable)properties).get(threadPoolSizePropKey);
        }
        if (((Hashtable)properties).containsKey(tunnelAgentURLPropKey)) {
            this.tunnelAgentURL = (String)((Hashtable)properties).get(tunnelAgentURLPropKey);
        }
        if (((Hashtable)properties).containsKey(RMIRemoteCodebasePropKey)) {
            this.RMIRemoteCodebase = (String)((Hashtable)properties).get(RMIRemoteCodebasePropKey);
        }
        if (((Hashtable)properties).containsKey(sslListenerPortPropKey)) {
            this.sslListenerPort = (Integer)((Hashtable)properties).get(sslListenerPortPropKey);
        }
        if (((Hashtable)properties).containsKey(sslConfigPropKey)) {
            this.sslConfig = (SecureSocketLayerConfig)((Hashtable)properties).get(sslConfigPropKey);
        }
    }

    public String toString() {
        return ((Hashtable)this.toProperties()).toString();
    }

    public Vector retrieveCloneOnlyAttributeNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ListenerPort");
        vector.add("CommTraceEnabled");
        vector.add("ThreadPoolSize");
        return vector;
    }

    public Vector retrieveCloneOnlyAttributeGetters() {
        Vector<String> vector = new Vector<String>();
        vector.add("getListenerPort");
        vector.add("isCommTraceEnabled");
        vector.add("getThreadPoolSize");
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

