/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.agent.ParamList;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.EJBServer;
import com.ibm.ejs.sm.beans.EJBServerAttributes;
import com.ibm.ejs.sm.beans.EJBServerHome;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.NodeAttributes;
import com.ibm.ejs.sm.beans.NodeHome;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.Server;
import com.ibm.ejs.sm.beans.ServerGroup;
import com.ibm.ejs.sm.beans.ServerGroupAttributes;
import com.ibm.ejs.sm.beans.ServiceBaseImpl;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.beans.TypeHome;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.client.PerfLevelSpec;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.PmiServiceCache;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.server.ServerInfo;
import com.ibm.ws.pmi.wire.WpdCollection;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.ejb.SessionBean;

public class PmiServiceBean
extends ServiceBaseImpl
implements SessionBean {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$PmiServiceBean == null ? (class$com$ibm$ejs$sm$beans$PmiServiceBean = PmiServiceBean.class$("com.ibm.ejs.sm.beans.PmiServiceBean")) : class$com$ibm$ejs$sm$beans$PmiServiceBean));
    private boolean exposeAS = false;
    public static String asName = "AdminServer";
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$PmiServiceBean;

    public PmiServiceBean() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"PmiServiceBean");
        Tr.exit((TraceComponent)tc, (String)"PmiServiceBean");
    }

    public String[] listNodes() throws RemoteException, OpException {
        String[] stringArray;
        Tr.entry((TraceComponent)tc, (String)"listNodes");
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            PmiServiceCache.clear();
            stringArray = (String[])RepositoryObjectImpl.getHome("NodeHome");
            Enumeration enumeration = stringArray.findAll(false);
            while (enumeration.hasMoreElements()) {
                EJBObject eJBObject = (EJBObject)enumeration.nextElement();
                Long l = (Long)eJBObject.getPrimaryKey();
                Node node = stringArray.findByPrimaryKey(l);
                NodeAttributes nodeAttributes = new NodeAttributes();
                nodeAttributes.request(Attributes.name);
                nodeAttributes = (NodeAttributes)node.getAttributes(nodeAttributes);
                String string = nodeAttributes.getName();
                arrayList.add(string);
                PmiServiceCache.addNode((String)string, (Node)node);
            }
        }
        catch (Exception exception) {
            throw new RemoteException("PmiService.listNodes failed\n" + exception.toString());
        }
        stringArray = new String[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            stringArray[n] = (String)arrayList.get(n);
            ++n;
        }
        Tr.exit((TraceComponent)tc, (String)"listNodes");
        return stringArray;
    }

    private String getKey(String string, String string2) {
        return string + ".pmi." + string2;
    }

    public String[] listServers(String string) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"listServers");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("listServers for node " + string));
        }
        PmiServiceCache.clear((String)string);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            EJBObject eJBObject;
            NodeHome nodeHome = (NodeHome)RepositoryObjectImpl.getHome("NodeHome");
            TypeHome typeHome = (TypeHome)RepositoryObjectImpl.getHome("TypeHome");
            EJBServerHome eJBServerHome = (EJBServerHome)RepositoryObjectImpl.getHome("EJBServerHome");
            Node node = nodeHome.findByName(string, true);
            PmiServiceCache.addNode((String)string, (Node)node);
            Type type = typeHome.findByImplClass("com.ibm.ejs.sm.beans.EJBServerBean", true);
            Enumeration enumeration = node.listContainedObjects(type);
            while (enumeration.hasMoreElements()) {
                eJBObject = (EJBObject)enumeration.nextElement();
                Long l = (Long)eJBObject.getPrimaryKey();
                try {
                    EJBServer eJBServer = eJBServerHome.findByPrimaryKey(l);
                    if (eJBServer != null) {
                        String string2 = this.getServerName(eJBServer);
                        arrayList.add(string2);
                        String string3 = this.getKey(string, string2);
                        PmiServiceCache.addServer((String)string3, (Server)eJBServer);
                        continue;
                    }
                    Tr.warning((TraceComponent)tc, (String)("Cannot find server for key " + l));
                }
                catch (Exception exception) {
                    Tr.warning((TraceComponent)tc, (String)("Failed to findByPrimaryKey: " + l + " - generic Server is not supported"));
                }
            }
            eJBObject = new String[arrayList.size()];
            int n = 0;
            while (n < ((EJBObject)eJBObject).length) {
                eJBObject[n] = (String)arrayList.get(n);
                ++n;
            }
            Tr.exit((TraceComponent)tc, (String)"listServers");
            return eJBObject;
        }
        catch (Exception exception) {
            throw new RemoteException("PmiService.listServers failed: \n" + exception.toString());
        }
    }

    public DataDescriptor[] listMembers(String string, String string2, DataDescriptor dataDescriptor) throws RemoteException, OpException {
        if (this.exposeAS && string2.equals(asName)) {
            return PmiRegistry.listMembers((DataDescriptor)dataDescriptor);
        }
        Server server = this.getServer(string, string2);
        return this.listMembers(server, dataDescriptor);
    }

    public DataDescriptor[] listMembers(Object object, DataDescriptor dataDescriptor) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"listMembers(node, server, dd)");
        ServerInfo serverInfo = this.getServerInfo(object);
        ParamList paramList = null;
        if (dataDescriptor == null) {
            paramList = null;
        } else {
            paramList = new ParamList(1);
            paramList.addElement(dataDescriptor);
        }
        DataDescriptor[] dataDescriptorArray = (DataDescriptor[])this.invoke(serverInfo, "listMembers", paramList);
        Tr.exit((TraceComponent)tc, (String)"listMembers(node, server,dd)");
        return dataDescriptorArray;
    }

    public DataDescriptor[] listMembers(String string, String string2) throws RemoteException, OpException {
        if (this.exposeAS && string2.equals(asName)) {
            return PmiRegistry.listMembers();
        }
        Server server = this.getServer(string, string2);
        return this.listMembers(server);
    }

    public DataDescriptor[] listMembers(Object object) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"listMembers(server,dd)");
        ServerInfo serverInfo = this.getServerInfo(object);
        DataDescriptor[] dataDescriptorArray = (DataDescriptor[])this.invoke(serverInfo, "listMembers", null);
        Tr.exit((TraceComponent)tc, (String)"listMembers(server,dd)");
        return dataDescriptorArray;
    }

    public PmiModuleConfig[] getConfigs(String string, String string2) throws RemoteException, OpException {
        if (this.exposeAS && string2.equals(asName)) {
            return PmiRegistry.getConfigs();
        }
        Server server = this.getServer(string, string2);
        return this.getConfigs(server);
    }

    public PmiModuleConfig[] getConfigs(Object object) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getConfigs(server)");
        ServerInfo serverInfo = this.getServerInfo(object);
        PmiModuleConfig[] pmiModuleConfigArray = (PmiModuleConfig[])this.invoke(serverInfo, "getConfigs", null);
        Tr.exit((TraceComponent)tc, (String)"getConfigs(server)");
        return pmiModuleConfigArray;
    }

    public WpdCollection get(String string, String string2, boolean bl) throws RemoteException, OpException {
        if (this.exposeAS && string2.equals(asName)) {
            return PmiRegistry.get(null, (boolean)bl);
        }
        Server server = this.getServer(string, string2);
        return this.get(server, bl);
    }

    public WpdCollection get(Object object, boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"get");
        ServerInfo serverInfo = this.getServerInfo(object);
        ParamList paramList = new ParamList(1);
        paramList.addElement(bl);
        WpdCollection wpdCollection = (WpdCollection)this.invoke(serverInfo, "get", paramList);
        Tr.exit((TraceComponent)tc, (String)"get");
        return wpdCollection;
    }

    public WpdCollection get(String string, String string2, DataDescriptor dataDescriptor, boolean bl) throws RemoteException, OpException {
        if (this.exposeAS && string2.equals(asName)) {
            return PmiRegistry.get((DataDescriptor)dataDescriptor, (boolean)bl);
        }
        Server server = this.getServer(string, string2);
        return this.get(server, dataDescriptor, bl);
    }

    public WpdCollection get(Object object, DataDescriptor dataDescriptor, boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"get");
        ServerInfo serverInfo = this.getServerInfo(object);
        ParamList paramList = null;
        if (dataDescriptor == null) {
            paramList = new ParamList(1);
            paramList.addElement(bl);
        } else {
            paramList = new ParamList(2);
            paramList.addElement(dataDescriptor);
            paramList.addElement(bl);
        }
        WpdCollection wpdCollection = (WpdCollection)this.invoke(serverInfo, "get", paramList);
        Tr.exit((TraceComponent)tc, (String)"get");
        return wpdCollection;
    }

    public WpdCollection[] gets(String string, String string2, DataDescriptor[] dataDescriptorArray, boolean bl) throws RemoteException, OpException {
        if (this.exposeAS && string2.equals(asName)) {
            return PmiRegistry.gets((DataDescriptor[])dataDescriptorArray, (boolean)bl);
        }
        Server server = this.getServer(string, string2);
        return this.gets(server, dataDescriptorArray, bl);
    }

    public WpdCollection[] gets(Object object, DataDescriptor[] dataDescriptorArray, boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"gets");
        if (dataDescriptorArray == null) {
            return null;
        }
        ServerInfo serverInfo = this.getServerInfo(object);
        ParamList paramList = new ParamList(2);
        paramList.addElement(dataDescriptorArray);
        paramList.addElement(bl);
        WpdCollection[] wpdCollectionArray = (WpdCollection[])this.invoke(serverInfo, "gets", paramList);
        Tr.exit((TraceComponent)tc, (String)"gets");
        return wpdCollectionArray;
    }

    public void setInstrumentationLevel(String string, String string2, PerfLevelDescriptor[] perfLevelDescriptorArray, boolean bl) throws RemoteException, OpException {
        if (this.exposeAS && string2.equals(asName)) {
            PmiRegistry.setInstrumentationLevel((PerfLevelDescriptor[])perfLevelDescriptorArray, (boolean)bl);
        } else {
            Server server = this.getServer(string, string2);
            this.setInstrumentationLevel(server, perfLevelDescriptorArray, bl);
        }
    }

    public void setInstrumentationLevel(Object object, PerfLevelDescriptor[] perfLevelDescriptorArray, boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setInstrumentationLevel(server,specs, recursive)");
        if (perfLevelDescriptorArray == null) {
            return;
        }
        if (object instanceof ServerGroup) {
            ServerGroup serverGroup = (ServerGroup)object;
            Enumeration enumeration = serverGroup.listClones();
            while (enumeration.hasMoreElements()) {
                Server server = (Server)enumeration.nextElement();
                ServerInfo serverInfo = this.getServerInfo(server);
                ParamList paramList = new ParamList(2);
                paramList.addElement(perfLevelDescriptorArray);
                paramList.addElement(true);
                this.invoke(serverInfo, "setInstrumentationLevel", paramList);
            }
        } else {
            ServerInfo serverInfo = this.getServerInfo(object);
            ParamList paramList = new ParamList(2);
            paramList.addElement(perfLevelDescriptorArray);
            paramList.addElement(bl);
            this.invoke(serverInfo, "setInstrumentationLevel", paramList);
        }
        Tr.exit((TraceComponent)tc, (String)"setInstrumentationLevel(server,specs, recursive)");
    }

    public PerfLevelDescriptor[] getInstrumentationLevel(String string, String string2) throws RemoteException, OpException {
        if (this.exposeAS && string2.equals(asName)) {
            return PmiRegistry.getAllInstrumentationLevels();
        }
        Server server = this.getServer(string, string2);
        return this.getInstrumentationLevel(server);
    }

    public PerfLevelDescriptor[] getInstrumentationLevel(Object object) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getInstrumentationLevel");
        PerfLevelDescriptor[] perfLevelDescriptorArray = null;
        if (object instanceof ServerGroup) {
            String[] stringArray;
            String string = this.getPmiAttribute(object);
            perfLevelDescriptorArray = PmiUtil.getPerfLevelSpecsFromString((String)string);
            if (perfLevelDescriptorArray == null) {
                perfLevelDescriptorArray = PmiRegistry.getDefaultPerfLevelSpecs();
            }
            int n = 0;
            while (n < perfLevelDescriptorArray.length) {
                if (perfLevelDescriptorArray[n] != null && (stringArray = perfLevelDescriptorArray[n].getShortPath()) != null && stringArray.length > 1) {
                    return perfLevelDescriptorArray;
                }
                ++n;
            }
            stringArray = (String[])object;
            Enumeration enumeration = stringArray.listClones();
            while (enumeration.hasMoreElements()) {
                Server server = (Server)enumeration.nextElement();
                ServerInfo serverInfo = this.getServerInfo(server);
                PerfLevelDescriptor[] perfLevelDescriptorArray2 = (PerfLevelDescriptor[])this.invoke(serverInfo, "getInstrumentationLevel", null);
                if (perfLevelDescriptorArray2 == null) continue;
                int n2 = 0;
                while (n2 < perfLevelDescriptorArray2.length) {
                    int n3 = 0;
                    while (n3 < perfLevelDescriptorArray.length) {
                        if (perfLevelDescriptorArray[n3].comparePath((PerfLevelSpec)perfLevelDescriptorArray2[n2]) == 0) {
                            perfLevelDescriptorArray2[n2].setLevel(perfLevelDescriptorArray[n3].getLevel());
                            break;
                        }
                        if (perfLevelDescriptorArray[n3].isSubPath((PerfLevelSpec)perfLevelDescriptorArray2[n2])) {
                            perfLevelDescriptorArray2[n2].setLevel(perfLevelDescriptorArray[n3].getLevel());
                            break;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("return srvList" + PmiUtil.getStringFromPerfLevelSpecs((PerfLevelDescriptor[])perfLevelDescriptorArray2)));
                }
                Tr.exit((TraceComponent)tc, (String)"getInstrumentationLevel - from server group");
                return perfLevelDescriptorArray2;
            }
        } else {
            String string;
            ServerInfo serverInfo = this.getServerInfo(object);
            perfLevelDescriptorArray = (PerfLevelDescriptor[])this.invoke(serverInfo, "getInstrumentationLevel", null);
            if (perfLevelDescriptorArray == null && (perfLevelDescriptorArray = PmiUtil.getPerfLevelSpecsFromString((String)(string = this.getPmiAttribute(object)))) == null) {
                perfLevelDescriptorArray = PmiRegistry.getDefaultPerfLevelSpecs();
            }
        }
        Tr.exit((TraceComponent)tc, (String)"getInstrumentationLevel");
        return perfLevelDescriptorArray;
    }

    public void enableData(String string, String string2, DataDescriptor[] dataDescriptorArray, boolean bl) throws RemoteException, OpException {
        Server server = this.getServer(string, string2);
        this.enableData(server, dataDescriptorArray, bl);
    }

    public void enableData(Object object, DataDescriptor[] dataDescriptorArray, boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"enableData");
        ServerInfo serverInfo = this.getServerInfo(object);
        ParamList paramList = new ParamList(2);
        paramList.addElement(dataDescriptorArray);
        paramList.addElement(bl);
        this.invoke(serverInfo, "enableData", paramList);
        Tr.exit((TraceComponent)tc, (String)"enableData");
    }

    public void disableData(String string, String string2, DataDescriptor[] dataDescriptorArray, boolean bl) throws RemoteException, OpException {
        Server server = this.getServer(string, string2);
        this.disableData(server, dataDescriptorArray, bl);
    }

    public void disableData(Object object, DataDescriptor[] dataDescriptorArray, boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"disableData");
        ServerInfo serverInfo = this.getServerInfo(object);
        ParamList paramList = new ParamList(2);
        paramList.addElement(dataDescriptorArray);
        paramList.addElement(bl);
        this.invoke(serverInfo, "disableData", paramList);
        Tr.exit((TraceComponent)tc, (String)"disableData");
    }

    public void enablePmi(String string, String string2) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"enablePmi");
        Tr.exit((TraceComponent)tc, (String)"enablePmi");
    }

    public void enablePmi(Object object) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"enablePmi");
        Tr.exit((TraceComponent)tc, (String)"enablePmi");
    }

    public void disablePmi(String string, String string2) throws RemoteException, OpException {
        Server server = this.getServer(string, string2);
        this.disablePmi(server);
    }

    public void disablePmi(Object object) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"disablePmi");
        if (object instanceof ServerGroup) {
            ServerGroup serverGroup = (ServerGroup)object;
            Enumeration enumeration = serverGroup.listClones();
            while (enumeration.hasMoreElements()) {
                Server server = (Server)enumeration.nextElement();
                ServerInfo serverInfo = this.getServerInfo(server);
                PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[]{new PerfLevelDescriptor(null, 0)};
                this.setInstrumentationLevel(object, perfLevelDescriptorArray, true);
                ParamList paramList = new ParamList(1);
                paramList.addElement(true);
                this.invoke(serverInfo, "setAllLevelNone", paramList);
            }
        } else {
            ServerInfo serverInfo = this.getServerInfo(object);
            PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[]{new PerfLevelDescriptor(null, 0)};
            this.setInstrumentationLevel(object, perfLevelDescriptorArray, true);
            ParamList paramList = new ParamList(1);
            paramList.addElement(true);
            this.invoke(serverInfo, "setAllLevelNone", paramList);
        }
        Tr.exit((TraceComponent)tc, (String)"disablePmi");
    }

    public boolean isAllLevelNone(String string, String string2) throws RemoteException, OpException {
        Server server = this.getServer(string, string2);
        return this.isAllLevelNone(server);
    }

    public boolean isAllLevelNone(Object object) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"isAllLevelNone");
        boolean bl = false;
        if (object instanceof ServerGroup) {
            String string = this.getPmiAttribute(object);
            PerfLevelDescriptor[] perfLevelDescriptorArray = PmiUtil.getPerfLevelSpecsFromString((String)string);
            if (string == null || perfLevelDescriptorArray == null || string.equals("pmi=disable")) {
                return true;
            }
            int n = 0;
            while (n < perfLevelDescriptorArray.length) {
                if (perfLevelDescriptorArray[n].getLevel() != 0) {
                    return false;
                }
                ++n;
            }
            bl = true;
        } else {
            ServerInfo serverInfo = this.getServerInfo(object);
            Boolean bl2 = (Boolean)this.invoke(serverInfo, "isAllLevelNone", null);
            if (bl2 != null) {
                bl = bl2;
            } else {
                String string = this.getPmiAttribute(object);
                PerfLevelDescriptor[] perfLevelDescriptorArray = PmiUtil.getPerfLevelSpecsFromString((String)string);
                if (string == null || perfLevelDescriptorArray == null || string.equals("pmi=disable")) {
                    bl = true;
                }
            }
        }
        Tr.exit((TraceComponent)tc, (String)"isAllLevelNone");
        return bl;
    }

    public int getAdminState(String string) throws RemoteException, OpException {
        try {
            NodeHome nodeHome = (NodeHome)RepositoryObjectImpl.getHome("NodeHome");
            Node node = PmiServiceCache.getNode((String)string);
            if (node == null) {
                node = nodeHome.findByName(string, true);
            }
            if (node != null) {
                return node.getCurrentState();
            }
            return -1;
        }
        catch (Exception exception) {
            throw new RemoteException("PmiService.getAdminState failed: \n" + exception.toString());
        }
    }

    public int getAdminState(String string, String string2) throws RemoteException, OpException {
        Server server = this.getServer(string, string2);
        if (server != null) {
            return server.getCurrentState();
        }
        return -1;
    }

    public void ejbCreate() throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        Tr.exit((TraceComponent)tc, (String)"ejbCreate");
    }

    private Object invoke(ServerInfo serverInfo, String string, ParamList paramList) throws RemoteException, OpException {
        if (serverInfo == null) {
            Tr.warning((TraceComponent)tc, (String)"invoke - serverInfo is null");
            return null;
        }
        try {
            if (serverInfo.server.getCurrentState() != 3) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return serverInfo.nodeAgent.invokeActiveObject(serverInfo.cp, string, paramList);
    }

    private Server getServer(String string, String string2) {
        try {
            Server server = PmiServiceCache.getServer((String)this.getKey(string, string2));
            if (server == null) {
                this.listServers(string);
                server = PmiServiceCache.getServer((String)this.getKey(string, string2));
            }
            return server;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private String getServerName(Object object) {
        try {
            Server server = (Server)object;
            EJBServerAttributes eJBServerAttributes = new EJBServerAttributes();
            eJBServerAttributes.request(Attributes.name);
            eJBServerAttributes = (EJBServerAttributes)server.getAttributes(eJBServerAttributes);
            return eJBServerAttributes.getName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void updatePmiAttribute(String string, String string2, PerfLevelDescriptor[] perfLevelDescriptorArray, boolean bl) throws RemoteException, OpException {
        Server server = this.getServer(string, string2);
        this.updatePmiAttribute(server, perfLevelDescriptorArray, bl);
    }

    public void updatePmiAttribute(Object object, PerfLevelDescriptor[] perfLevelDescriptorArray, boolean bl) throws RemoteException, OpException {
        try {
            Server server = (Server)object;
            EJBServerAttributes eJBServerAttributes = new EJBServerAttributes();
            eJBServerAttributes.request("PmiSpec");
            eJBServerAttributes = (EJBServerAttributes)server.getAttributes(eJBServerAttributes);
            String string = eJBServerAttributes.getPmiSpec();
            string = PmiUtil.updatePerfLevelSpecString((String)string, (PerfLevelDescriptor[])perfLevelDescriptorArray, (boolean)bl);
            eJBServerAttributes.setPmiSpec(string);
            server.setAttributes(eJBServerAttributes);
        }
        catch (AttributeNotSetException attributeNotSetException) {
            attributeNotSetException.printStackTrace();
            return;
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            attributeDoesNotExistException.printStackTrace();
            return;
        }
    }

    private String getPmiAttribute(Object object) {
        String string = null;
        try {
            if (object instanceof Server) {
                Server server = (Server)object;
                EJBServerAttributes eJBServerAttributes = new EJBServerAttributes();
                eJBServerAttributes.request("PmiSpec");
                eJBServerAttributes = (EJBServerAttributes)server.getAttributes(eJBServerAttributes);
                string = eJBServerAttributes.getPmiSpec();
            } else if (object instanceof ServerGroup) {
                ServerGroup serverGroup = (ServerGroup)object;
                ServerGroupAttributes serverGroupAttributes = new ServerGroupAttributes();
                serverGroupAttributes.requestAll();
                serverGroupAttributes = (ServerGroupAttributes)serverGroup.getAttributes(serverGroupAttributes);
                EJBServerAttributes eJBServerAttributes = serverGroupAttributes.getEJBServerAttributes();
                string = eJBServerAttributes.getPmiSpec();
            } else {
                Tr.warning((TraceComponent)tc, (String)"wrong type of server: must be either Server or ServerGroup");
            }
        }
        catch (AttributeNotSetException attributeNotSetException) {
            string = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string = null;
        }
        return string;
    }

    private ServerInfo getServerInfo(Object object) throws RemoteException, OpException {
        return PmiServiceCache.getServerInfo((Object)object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

