/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.cm.portability.DuplicateKeyException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.BinaryAttrSerialization;
import com.ibm.ejs.sm.beans.BinaryAttrVal;
import com.ibm.ejs.sm.beans.DataSource;
import com.ibm.ejs.sm.beans.Model;
import com.ibm.ejs.sm.beans.ModelAttributes;
import com.ibm.ejs.sm.beans.ModelHome;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.NodeBean;
import com.ibm.ejs.sm.beans.ObjectTableCacheElement;
import com.ibm.ejs.sm.beans.Relation;
import com.ibm.ejs.sm.beans.RelationAttributes;
import com.ibm.ejs.sm.beans.RelationBean;
import com.ibm.ejs.sm.beans.RelationHome;
import com.ibm.ejs.sm.beans.RepositoryHome;
import com.ibm.ejs.sm.beans.RepositoryObject;
import com.ibm.ejs.sm.beans.RepositoryObjectName;
import com.ibm.ejs.sm.beans.RepositoryObjectNameElem;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.beans.TypeAttributes;
import com.ibm.ejs.sm.beans.TypeHome;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.AttrsVersionMismatchException;
import com.ibm.ejs.sm.exception.DataSourceUnavailableOnNodeException;
import com.ibm.ejs.sm.exception.InvalidContainmentRelationOpException;
import com.ibm.ejs.sm.exception.InvalidNameChangeException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.OpNotImplementedException;
import com.ibm.ejs.sm.exception.RelationOpException;
import com.ibm.ejs.sm.server.ManagedServer;
import com.ibm.ejs.sm.util.EJBObjectCollection;
import com.ibm.ejs.sm.util.ObjectCollection;
import com.ibm.ejs.sm.util.TranContext;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import com.ibm.ejs.util.cache.Cache;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class RepositoryObjectImpl {
    protected static NLS nls = new NLS("RepositoryStrings");
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$RepositoryObjectImpl == null ? (class$com$ibm$ejs$sm$beans$RepositoryObjectImpl = RepositoryObjectImpl.class$("com.ibm.ejs.sm.beans.RepositoryObjectImpl")) : class$com$ibm$ejs$sm$beans$RepositoryObjectImpl));
    protected Long id;
    protected Long typeId;
    protected EntityContext ec;
    protected EJBObject narrowRef;
    private int version;
    private Properties binaryAttrs;
    private boolean dirty;
    private static final int typeTypeId = 1;
    private static final int instanceIdIncrement = 32;
    private static final int objectIdKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
    private static final int loadStmtKey = objectIdKeyBase + 1;
    private static final int insertStmtKey = objectIdKeyBase + 2;
    private static final int findTypeIdStmtKey = objectIdKeyBase + 3;
    private static final int deleteStmtKey = objectIdKeyBase + 4;
    private static final int updateStmtKey = objectIdKeyBase + 5;
    private static final int loadObjTableCacheStmtKey = objectIdKeyBase + 6;
    private static final String tableName = DBMgr.qualifiedTableName((String)"OBJECT_TABLE");
    protected static final String instanceIdColumnName = "INSTANCE_ID";
    protected static final int instanceIdColumnIndex = 1;
    protected static final String typeIdColumnName = "TYPE_ID";
    protected static final int typeIdColumnIndex = 2;
    private static final String versionColumnName = "VERSION";
    private static final int versionColumnIndex = 3;
    private static final String binaryAttrsColumnName = "BINARY_ATTR";
    private static final int binaryAttrsColumnIndex = 4;
    protected static final int columnIndexBase = 2;
    private static Integer nextInstanceIdLock = new Integer(1);
    private static long nextInstanceId = 2L;
    private static boolean tableCreated = false;
    private static Context initCtx = null;
    private static Hashtable homeCache = new Hashtable();
    private static String duplicateKeySQLState = "23505";
    private static int numObjTableCacheElements = 4096;
    private static Cache objTableCache = new Cache(numObjTableCacheElements);
    private static final String insertStmtSql = "insert into " + tableName + " (" + "INSTANCE_ID" + "," + "TYPE_ID" + "," + "VERSION" + "," + "BINARY_ATTR" + ")" + " values(?, ?, ?, ?)";
    private static final String updateStmtSql = "update " + tableName + " set " + "TYPE_ID" + " = ? , " + "VERSION" + " = ? , " + "BINARY_ATTR" + " = ? " + " where " + "INSTANCE_ID" + " = ? ";
    private static final String findTypeIdStmtSql = "select * from " + tableName + " where " + "INSTANCE_ID" + " =  ?";
    private static final String deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " =  ?";
    private static final String loadObjTableCacheStmtSql = "select INSTANCE_ID from " + tableName + " where " + "TYPE_ID" + " =  ?";
    protected static final String packageName = "com.ibm.ejs.sm.beans";
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$RepositoryObjectImpl;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$Relation;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$RepositoryObject;

    private static void initializeInstanceId() throws RemoteException {
        Vector<Object> vector;
        Tr.entry((TraceComponent)tc, (String)"initializeInstanceId");
        DBQueryResult dBQueryResult = null;
        long l = 0L;
        try {
            block12: {
                try {
                    dBQueryResult = DBMgr.executePreparedReadForUpdateByPrimaryKey((int)loadStmtKey, (String)tableName, (String)instanceIdColumnName, (String)Long.toString(1L));
                    vector = dBQueryResult.getResultSet();
                    if (vector == null || !vector.next()) break block12;
                    String string = vector.getString(2);
                    Tr.event((TraceComponent)tc, (String)("maxInstanceId: " + string));
                    if (string == null) break block12;
                    l = Long.parseLong(string);
                }
                catch (SQLException sQLException) {
                    RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.init.exception", new Object[]{sQLException.getMessage()}, "RepositoryObjectImpl could not initialize the instance because of {0}."), sQLException);
                    Tr.exit((TraceComponent)tc, (String)"initializeInstanceId", (Object)remoteException);
                    throw remoteException;
                }
            }
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        if (l == 0L) {
            try {
                vector = new Vector(4);
                vector.addElement(Long.toString(1L));
                vector.addElement(Long.toString(32L));
                vector.addElement(new Integer(0));
                vector.addElement(Utils.serializeObject((Object)new Properties()));
                DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                Tr.debug((TraceComponent)tc, (String)"duplicated instanceId. Ignored");
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.db.duplicate.exception", new Object[]{new Integer(32), sQLException.getMessage()}, "RepositoryObjectImpl could not insert duplicate key {0} because of {1}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"initializeInstanceId", (Object)remoteException);
                throw remoteException;
            }
            nextInstanceId = 2L;
        } else {
            try {
                vector = new Vector<Object>(4);
                vector.addElement(Long.toString(l + 32L));
                vector.addElement(new Integer(0));
                vector.addElement(Utils.serializeObject((Object)new Properties()));
                vector.addElement(Long.toString(1L));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                Tr.debug((TraceComponent)tc, (String)"duplicate instanceId, ignored.");
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.db.duplicate.exception", new Object[]{new Long(l + 32L), sQLException.getMessage()}, "RepositoryObjectImpl could not insert duplicate key {0} because of {1}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"initializeInstanceId", (Object)remoteException);
                throw remoteException;
            }
            nextInstanceId = l + 1L;
        }
        Tr.exit((TraceComponent)tc, (String)"initializeInstanceId");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initializePersistentStore() throws RemoteException {
        block9: {
            if (tableCreated) {
                return;
            }
            Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
            String string = "create table " + tableName + " ( " + instanceIdColumnName + DBMgr.idColumnSpec + " , " + typeIdColumnName + DBMgr.idColumnSpec + " , " + versionColumnName + " INTEGER NOT NULL " + " , " + binaryAttrsColumnName + DBMgr.hugeByteArrayColumnSpec + " , " + " primary key(" + instanceIdColumnName + "))";
            try {
                DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.db.create0.exception", new Object[]{tableName, sQLException.getMessage()}, "RepositoryObjectImpl could not create table {0} because of {1}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"initializePersistentStore - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
            TranContext tranContext = null;
            try {
                try {
                    tranContext = TranContext.create();
                    RepositoryObjectImpl.initializeInstanceId();
                }
                catch (Exception exception) {
                    if (tranContext != null) {
                        tranContext.markRollback();
                    }
                    Tr.exit((TraceComponent)tc, (String)"initializePersistentStore", (Object)exception);
                    throw new RemoteException(nls.getFormattedMessage("repo.db.init.exception", new Object[]{exception.getMessage()}, "RepositoryObjectImpl could initialize because of {0}."), exception);
                }
                Object var4_5 = null;
                if (tranContext == null) break block9;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (tranContext != null) {
                    tranContext.terminate();
                }
                throw throwable;
            }
            tranContext.terminate();
        }
        tableCreated = true;
        Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
    }

    public RepositoryObjectImpl() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"RepositoryObjectImpl");
        RepositoryObjectImpl.initializeNLS("RepositoryStrings");
        RepositoryObjectImpl.initializePersistentStore();
        Tr.exit((TraceComponent)tc, (String)"RepositoryObjectImpl");
    }

    private static void initializeNLS(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeNLS");
        }
        if (nls == null) {
            nls = new NLS(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeNLS");
        }
    }

    private static final synchronized long getNextInstanceId() throws RemoteException {
        return new Date().getTime();
    }

    protected String getName(Relation relation) throws RemoteException {
        String string = null;
        Tr.entry((TraceComponent)tc, (String)"getName");
        try {
            Enumeration enumeration = relation.listNames(this.ec.getEJBObject(), true);
            if (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
            }
            if (enumeration.hasMoreElements()) {
                Tr.event((TraceComponent)tc, (String)"object has more than relation with container type instance");
            }
        }
        catch (RelationOpException relationOpException) {
            // empty catch block
        }
        Tr.exit((TraceComponent)tc, (String)"getName", string);
        return string;
    }

    protected static Long getTypeTypeId() {
        return new Long(1L);
    }

    public void ejbActivate() {
        Long l;
        Tr.entry((TraceComponent)tc, (String)"ejbActivate");
        try {
            l = (Long)this.ec.getPrimaryKey();
        }
        catch (Exception exception) {
            l = null;
        }
        if (l != null && l != this.id) {
            Tr.event((TraceComponent)tc, (String)"nulling out old id, new id: ", (Object)l);
            this.id = null;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbActivate");
    }

    public void ejbPassivate() {
    }

    public void setEntityContext(EntityContext entityContext) {
        Tr.entry((TraceComponent)tc, (String)"setEntityContext", (Object)entityContext);
        this.ec = entityContext;
        this.id = null;
        Tr.exit((TraceComponent)tc, (String)"setEntityContext");
    }

    public void unsetEntityContext() {
        Tr.entry((TraceComponent)tc, (String)"unsetEntitityContext");
        this.ec = null;
        Tr.exit((TraceComponent)tc, (String)"unsetEntitityContext");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByPrimaryKey(Long l) throws RemoteException, FinderException {
        Long l2;
        DBQueryResult dBQueryResult;
        block9: {
            Long l3;
            block8: {
                Tr.entry((TraceComponent)tc, (String)"ejbFindByPrimaryKey", (Object)l);
                if (l < 0L) {
                    Tr.exit((TraceComponent)tc, (String)"ejbFindByPrimaryKey", null);
                    return null;
                }
                if (l == 1L) {
                    Tr.exit((TraceComponent)tc, (String)"ejbFindByPrimaryKey", (Object)l);
                    return l;
                }
                dBQueryResult = null;
                try {
                    try {
                        String string;
                        if (objTableCache.find((Object)l) != null) {
                            objTableCache.unpin((Object)l);
                            l3 = l;
                            Object var8_6 = null;
                            break block8;
                        }
                        dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)instanceIdColumnName, (String)Utils.getIdString((Long)l));
                        ResultSet resultSet = dBQueryResult.getResultSet();
                        if (resultSet.next() && (string = resultSet.getString(1)) != null) {
                            String string2 = resultSet.getString(2);
                            objTableCache.insert((Object)l, (Object)new ObjectTableCacheElement(l, Utils.getId((String)string2)));
                            Tr.exit((TraceComponent)tc, (String)"ejbFindByPrimaryKey", (Object)l);
                            l2 = l;
                            break block9;
                        }
                        ObjectNotFoundException objectNotFoundException = new ObjectNotFoundException();
                        Tr.exit((TraceComponent)tc, (String)"ejbFindByPrimaryKey", (Object)((Object)objectNotFoundException));
                        throw objectNotFoundException;
                    }
                    catch (SQLException sQLException) {
                        RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.db.select0.exception", new Object[]{sQLException.getMessage(), tableName, l}, "RepositoryObjectImpl findByPrimaryKey failed due to {0} on table {1} for key {2}."), sQLException);
                        Tr.exit((TraceComponent)tc, (String)"ejbFindByPrimaryKey - with java.sql.SQLException", (Object)remoteException);
                        throw remoteException;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    DBMgr.doneWithQuery(dBQueryResult);
                    throw throwable;
                }
            }
            DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
            return l3;
        }
        Object var8_7 = null;
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l2;
    }

    public Long ejbFindByPrimaryKeyGeneric(Long l) throws RemoteException, FinderException {
        Tr.entry((TraceComponent)tc, (String)"ejbFindByPrimaryKeyGeneric", (Object)l);
        Long l2 = this.ejbFindByPrimaryKey(l);
        Tr.exit((TraceComponent)tc, (String)"ejbFindByPrimaryKeyGeneric", (Object)l2);
        return l2;
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)this.id));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
            objTableCache.unpin((Object)this.id);
            objTableCache.remove((Object)this.id, true);
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.db.delete0.exception", new Object[]{sQLException.getMessage(), this.id}, "RepositoryObjectImpl delete failed due to {0} for id = {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbRemove - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        try {
            RelationBean.handleObjectDeletion(this.id);
        }
        catch (RemoteException remoteException) {
            this.ec.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public void ejbLoad() throws RemoteException {
        Long l = (Long)this.ec.getPrimaryKey();
        Tr.entry((TraceComponent)tc, (String)"ejbLoad");
        DBQueryResult dBQueryResult = null;
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)instanceIdColumnName, (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (!resultSet.next()) {
                    RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.db.select1.exception", new Object[]{l, tableName}, "RepositoryObjectImpl select failed to find server instance {0} in table {1}."), new ObjectNotFoundException());
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad - with no resultSet exception", (Object)remoteException);
                    throw remoteException;
                }
                this.version = resultSet.getInt(3);
                this.binaryAttrs = (Properties)Utils.deserializeObject((byte[])resultSet.getBytes(4));
                this.dirty = false;
                Tr.exit((TraceComponent)tc, (String)"ejbLoad");
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.db.select2.exception", new Object[]{sQLException.getMessage()}, "RepositoryObjectImpl select failed due to {0}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbLoad - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        this.storeImplementation();
        Tr.exit((TraceComponent)tc, (String)"ejbStore");
    }

    protected Long create(Long l) throws RemoteException {
        Serializable serializable;
        Tr.entry((TraceComponent)tc, (String)"create", (Object)l);
        boolean bl = false;
        long l2 = RepositoryObjectImpl.getNextInstanceId();
        while (!bl) {
            bl = true;
            try {
                serializable = new Vector(3);
                ((Vector)serializable).addElement(Long.toString(l2));
                ((Vector)serializable).addElement(Utils.getIdString((Long)l));
                this.version = 0;
                ((Vector)serializable).addElement(new Integer(this.version));
                this.binaryAttrs = new Properties();
                ((Vector)serializable).addElement(Utils.serializeObject((Object)this.binaryAttrs));
                DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, (Vector)serializable);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                bl = false;
                l2 = RepositoryObjectImpl.getNextInstanceId();
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.db.update0.exception", new Object[]{sQLException.getMessage(), new Long(l2)}, "RepositoryObjectImpl update failed due to {0} for statement with id = {1} ."), sQLException);
                Tr.event((TraceComponent)tc, (String)"nextInstanceId : ", (Object)new Long(l2));
                Tr.exit((TraceComponent)tc, (String)"create - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
        }
        serializable = new Long(l2);
        this.id = serializable;
        this.typeId = l;
        ObjectTableCacheElement objectTableCacheElement = new ObjectTableCacheElement(this.id, l);
        objTableCache.insert((Object)this.id, (Object)objectTableCacheElement);
        Tr.exit((TraceComponent)tc, (String)"create", (Object)serializable);
        return serializable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static final Long getTypeId(Long l) throws RemoteException {
        Long l2;
        DBQueryResult dBQueryResult;
        block10: {
            Long l3;
            block9: {
                Long l4;
                block8: {
                    Tr.entry((TraceComponent)tc, (String)"getTypeId", (Object)l);
                    if (l == 1L) {
                        Tr.exit((TraceComponent)tc, (String)"getTypeId", (Object)l);
                        return l;
                    }
                    dBQueryResult = null;
                    try {
                        try {
                            Long l5 = null;
                            ObjectTableCacheElement objectTableCacheElement = (ObjectTableCacheElement)((Object)objTableCache.find((Object)l));
                            if (objectTableCacheElement != null) {
                                objTableCache.unpin((Object)l);
                                l4 = objectTableCacheElement.getTypeId();
                                Object var9_8 = null;
                                break block8;
                            }
                            Vector<String> vector = new Vector<String>(1);
                            vector.addElement(Utils.getIdString((Long)l));
                            dBQueryResult = DBMgr.executePreparedQuery((int)findTypeIdStmtKey, (String)findTypeIdStmtSql, vector);
                            ResultSet resultSet = dBQueryResult.getResultSet();
                            String string = null;
                            if (resultSet.next()) {
                                string = resultSet.getString(2);
                            }
                            if (string != null) {
                                l5 = Utils.getId((String)string);
                                objTableCache.insert((Object)l, (Object)new ObjectTableCacheElement(l, l5));
                                Tr.exit((TraceComponent)tc, (String)"getTypeId", (Object)l5);
                                l3 = l5;
                                break block9;
                            }
                            Tr.exit((TraceComponent)tc, (String)"getTypeId", null);
                            l2 = null;
                            break block10;
                        }
                        catch (SQLException sQLException) {
                            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.db.read0.exception", new Object[]{sQLException.getMessage(), l}, "RepositoryObjectImpl could not get typeId {1} due to {0}."), sQLException);
                            Tr.exit((TraceComponent)tc, (String)"getTypeId - with java.sql.SQLException", (Object)remoteException);
                            throw remoteException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        DBMgr.doneWithQuery(dBQueryResult);
                        throw throwable;
                    }
                }
                DBMgr.doneWithQuery(dBQueryResult);
                return l4;
            }
            Object var9_9 = null;
            DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
            return l3;
        }
        Object var9_10 = null;
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l2;
    }

    protected static final EJBHome getHome(Long l) throws RemoteException {
        Object object;
        Type type;
        TypeHome typeHome = (TypeHome)RepositoryObjectImpl.getHome("TypeHome");
        Tr.entry((TraceComponent)tc, (String)"getHome", (Object)l);
        try {
            type = typeHome.findByPrimaryKey(l);
        }
        catch (FinderException finderException) {
            RemoteException remoteException = new RemoteException("", finderException);
            Tr.exit((TraceComponent)tc, (String)"getHome", (Object)remoteException);
            throw remoteException;
        }
        String string = null;
        try {
            object = new TypeAttributes();
            ((Attributes)object).request("InterfaceClass");
            object = (TypeAttributes)type.getAttributes((Attributes)object);
            string = (String)((Attributes)object).getGeneric("InterfaceClass");
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables ", (Object)((Object)attributeDoesNotExistException));
            throw new RemoteException(nls.getString("repo.attribute0.exception", "Attribute does not exist."), attributeDoesNotExistException);
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeNotSetException));
            throw new RemoteException(nls.getString("repo.attribute1.exception", "Attribute is not set."), attributeNotSetException);
        }
        catch (OpException opException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)opException));
            throw new RemoteException(nls.getString("repo.operation.exception", "Operation is not valid."), opException);
        }
        object = RepositoryObjectImpl.getHome(string + "Home");
        Tr.exit((TraceComponent)tc, (String)"getHome");
        return object;
    }

    public static final RepositoryHome getHome(String string) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"getHome", (Object)string);
        RepositoryHome repositoryHome = (RepositoryHome)homeCache.get(string);
        if (repositoryHome != null) {
            Tr.exit((TraceComponent)tc, (String)"getHome -- cache hit");
            return repositoryHome;
        }
        Context context = RepositoryObjectImpl.getInitialNamingContext();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = string;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            String string3 = ManagedServer.getInstance().qualifyRepositoryHomeName(string2);
            Tr.event((TraceComponent)tc, (String)"looking up : ", (Object)string3);
            Object object = context.lookup(string3);
            Class<?> clazz = string.equals(string2) ? Class.forName(RepositoryObjectImpl.qualifyClassName(string)) : Class.forName(string);
            repositoryHome = (RepositoryHome)PortableRemoteObject.narrow((Object)object, clazz);
            homeCache.put(string, repositoryHome);
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.home.exception", new Object[]{string, exception.getMessage()}, "RepositoryObjectImpl could not find the home interface {0} due to {1}."), exception);
            Tr.exit((TraceComponent)tc, (String)"getHome - with java.lang.Exception", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"getHome");
        return repositoryHome;
    }

    public static final EJBHome getEJBHome(String string) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"getEJBHome", (Object)string);
        EJBHome eJBHome = (EJBHome)homeCache.get(string);
        if (eJBHome != null) {
            Tr.exit((TraceComponent)tc, (String)"getEJBHome -- cache hit");
            return eJBHome;
        }
        Context context = RepositoryObjectImpl.getInitialNamingContext();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = string;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            String string3 = ManagedServer.getInstance().qualifyRepositoryHomeName(string2);
            Tr.event((TraceComponent)tc, (String)"looking up : ", (Object)string3);
            Object object = context.lookup(string3);
            Class<?> clazz = string.equals(string2) ? Class.forName(RepositoryObjectImpl.qualifyClassName(string)) : Class.forName(string);
            eJBHome = (EJBHome)PortableRemoteObject.narrow((Object)object, clazz);
            homeCache.put(string, eJBHome);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.home.exception", new Object[]{string, exception.getMessage()}, "RepositoryObjectImpl could not find the home interface {0} due to {1}."), exception);
            Tr.exit((TraceComponent)tc, (String)"getEJBHome - with java.lang.Exception", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"getEJBHome");
        return eJBHome;
    }

    public static synchronized Context getInitialNamingContext() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"getInitialContext");
        if (initCtx == null) {
            try {
                initCtx = new InitialContext();
            }
            catch (Exception exception) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.init.jndi.exception", new Object[]{exception.getMessage()}, "RepositoryObjectImpl could not find the naming context due to {0}."), exception);
                Tr.exit((TraceComponent)tc, (String)"getInitialContext - with java.lang.Exception", (Object)remoteException);
                throw remoteException;
            }
        }
        Tr.exit((TraceComponent)tc, (String)"getInitialNamingContext");
        return initCtx;
    }

    protected boolean setId(ResultSet resultSet, Long l) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"setId - type:", (Object)l);
        try {
            if (this.id == null) {
                this.id = Utils.getId((String)resultSet.getString(1));
                Tr.event((TraceComponent)tc, (String)"setting id: ", (Object)this.id);
                this.typeId = Utils.getId((String)resultSet.getString(2));
                if (!this.typeId.equals(l)) {
                    Tr.event((TraceComponent)tc, (String)"setting narrow ref, implType: ", (Object)l);
                    RepositoryHome repositoryHome = (RepositoryHome)RepositoryObjectImpl.getHome(this.typeId);
                    this.narrowRef = RepositoryObjectImpl.dynamicFindByPrimaryKey(repositoryHome, this.id);
                }
            }
            boolean bl = this.narrowRef == null;
            Tr.exit((TraceComponent)tc, (String)"setId", (Object)new Boolean(bl));
            return bl;
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.db.read0.exception", new Object[]{sQLException.getMessage(), l}, "RepositoryObjectImpl could not get typeId {1} due to {0}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"setId - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
    }

    public EJBObject getContainingObject() throws RemoteException, ObjectNotFoundException {
        Tr.entry((TraceComponent)tc, (String)"getContainingObject");
        if (this.narrowRef != null) {
            return ((RepositoryObject)this.narrowRef).getContainingObject();
        }
        Enumeration enumeration = this.getAllContainmentRels(false);
        EJBObject eJBObject = null;
        while (enumeration.hasMoreElements()) {
            Relation relation = (Relation)PortableRemoteObject.narrow(enumeration.nextElement(), (Class)(class$com$ibm$ejs$sm$beans$Relation == null ? RepositoryObjectImpl.class$("com.ibm.ejs.sm.beans.Relation") : class$com$ibm$ejs$sm$beans$Relation));
            try {
                eJBObject = relation.traverse(this.ec.getEJBObject(), true);
                break;
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                eJBObject = null;
            }
            catch (RelationOpException relationOpException) {
                Tr.exit((TraceComponent)tc, (String)"getContainingObject - with RelationOpException", (Object)((Object)relationOpException));
                throw new RemoteException(nls.getString("repo.relation.operation.exception", "RepositoryObjectImpl found an invalid relation operation."), relationOpException);
            }
        }
        if (eJBObject == null) {
            Tr.exit((TraceComponent)tc, (String)"getContainingObject -- object not found");
            throw new ObjectNotFoundException();
        }
        Tr.exit((TraceComponent)tc, (String)"getContainingObj");
        return eJBObject;
    }

    public Enumeration listContainedObjects() throws RemoteException {
        return this.listContainedObjects(true);
    }

    public Enumeration listContainedObjects(boolean bl) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"listContainedObjects");
        EJBObjectCollection eJBObjectCollection = new EJBObjectCollection();
        if (bl) {
            Enumeration enumeration = this.getAllContainmentRels(true);
            while (enumeration.hasMoreElements()) {
                Relation relation = (Relation)PortableRemoteObject.narrow(enumeration.nextElement(), (Class)(class$com$ibm$ejs$sm$beans$Relation == null ? RepositoryObjectImpl.class$("com.ibm.ejs.sm.beans.Relation") : class$com$ibm$ejs$sm$beans$Relation));
                Enumeration enumeration2 = relation.list(this.ec.getEJBObject(), false);
                while (enumeration2.hasMoreElements()) {
                    eJBObjectCollection.addElement((EJBObject)enumeration2.nextElement());
                }
            }
        }
        Tr.exit((TraceComponent)tc, (String)"listContainedObjects");
        return eJBObjectCollection;
    }

    public Enumeration listContainedObjects(Type type) throws RemoteException {
        return this.listContainedObjects(type, true);
    }

    public Enumeration listContainedObjects(Type type, boolean bl) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"listContainedObjects");
        if (bl) {
            Relation relation = null;
            try {
                relation = this.getContainmentRel(type);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                Tr.exit((TraceComponent)tc, (String)"listContainedObjects -- return empty collection");
                return new EJBObjectCollection();
            }
            Enumeration enumeration = relation.list(this.ec.getEJBObject(), false);
            Tr.exit((TraceComponent)tc, (String)"listContainedObjects");
            return enumeration;
        }
        Tr.exit((TraceComponent)tc, (String)"listContainedObjects - false");
        return new EJBObjectCollection();
    }

    public int getNumContainedObjects() throws RemoteException {
        int n = 0;
        Enumeration enumeration = this.listContainedObjects();
        while (enumeration.hasMoreElements()) {
            ++n;
            enumeration.nextElement();
        }
        return n;
    }

    public EJBObject lookupContainedObject(Type type, String string) throws RemoteException, ObjectNotFoundException {
        Tr.entry((TraceComponent)tc, (String)"lookupContainedObject");
        Relation relation = this.getContainmentRel(type);
        EJBObject eJBObject = null;
        try {
            eJBObject = relation.traverse(this.ec.getEJBObject(), string, false);
        }
        catch (RelationOpException relationOpException) {
            Tr.exit((TraceComponent)tc, (String)"lookupContainedObject - with RelationOpException", (Object)((Object)relationOpException));
            throw new RemoteException(nls.getString("repo.relation.operation.exception", "RepositoryObjectImpl found an invalid relation operation."), relationOpException);
        }
        Tr.exit((TraceComponent)tc, (String)"lookupContainedObject");
        return eJBObject;
    }

    public Enumeration getRelationshipsForInstance(boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getRelationshipsForInstance", (Object)new Boolean(bl));
        RelationHome relationHome = (RelationHome)RepositoryObjectImpl.getHome("RelationHome");
        TypeHome typeHome = (TypeHome)RepositoryObjectImpl.getHome("TypeHome");
        EJBObjectCollection eJBObjectCollection = new EJBObjectCollection();
        try {
            Type type = typeHome.findByPrimaryKey(RepositoryObjectImpl.getTypeId(this.id));
            Enumeration enumeration = relationHome.findByEndpoint(type, true);
            while (enumeration.hasMoreElements()) {
                Relation relation = (Relation)PortableRemoteObject.narrow(enumeration.nextElement(), (Class)(class$com$ibm$ejs$sm$beans$Relation == null ? RepositoryObjectImpl.class$("com.ibm.ejs.sm.beans.Relation") : class$com$ibm$ejs$sm$beans$Relation));
                RelationAttributes relationAttributes = new RelationAttributes();
                relationAttributes.request("IsContainment");
                relationAttributes = (RelationAttributes)relation.getAttributes(relationAttributes);
                Tr.event((TraceComponent)tc, (String)"isContainmentRel: ", (Object)new Boolean(relationAttributes.getIsContainment()));
                if (!bl && relationAttributes.getIsContainment()) continue;
                Enumeration enumeration2 = relation.list(this.id, false);
                Enumeration enumeration3 = relation.list(this.id, true);
                Tr.event((TraceComponent)tc, (String)"instance has relations: ", (Object)new Boolean(enumeration2.hasMoreElements() || enumeration3.hasMoreElements()));
                if (!enumeration2.hasMoreElements() && !enumeration3.hasMoreElements()) continue;
                eJBObjectCollection.addElement((EJBObject)relation);
            }
        }
        catch (RemoteException remoteException) {
            Tr.exit((TraceComponent)tc, (String)"getRelationshipsForInstance", (Object)remoteException);
            throw remoteException;
        }
        catch (OpException opException) {
            Tr.exit((TraceComponent)tc, (String)"getRelationshipsForInstance", (Object)((Object)opException));
            throw opException;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"getRelationshipsForInstance", (Object)exception);
            throw new RemoteException(nls.getFormattedMessage("repo.relationship.exception", new Object[]{exception.getMessage()}, "RepositoryObjectImpl could not get the relationship because of {0}."), exception);
        }
        Tr.exit((TraceComponent)tc, (String)"getRelationshipsForInstance", (Object)eJBObjectCollection);
        return eJBObjectCollection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Enumeration getRelationships(boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getRelationships");
        RelationHome relationHome = (RelationHome)RepositoryObjectImpl.getHome("RelationHome");
        TypeHome typeHome = (TypeHome)RepositoryObjectImpl.getHome("TypeHome");
        EJBObjectCollection eJBObjectCollection = new EJBObjectCollection();
        try {
            Type type = typeHome.findByPrimaryKey(RepositoryObjectImpl.getTypeId(this.id));
            Enumeration enumeration = relationHome.findByEndpoint(type, true);
            if (bl) {
                return enumeration;
            }
            while (enumeration.hasMoreElements()) {
                Relation relation = (Relation)PortableRemoteObject.narrow(enumeration.nextElement(), (Class)(class$com$ibm$ejs$sm$beans$Relation == null ? RepositoryObjectImpl.class$("com.ibm.ejs.sm.beans.Relation") : class$com$ibm$ejs$sm$beans$Relation));
                RelationAttributes relationAttributes = new RelationAttributes();
                relationAttributes.request("IsContainment");
                if ((relationAttributes = (RelationAttributes)relation.getAttributes(relationAttributes)).getIsContainment()) continue;
                eJBObjectCollection.addElement((EJBObject)relation);
            }
        }
        catch (RemoteException remoteException) {
            Tr.exit((TraceComponent)tc, (String)"getRelationships", (Object)remoteException);
            throw remoteException;
        }
        catch (OpException opException) {
            Tr.exit((TraceComponent)tc, (String)"getRelationships", (Object)((Object)opException));
            throw opException;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"getRelationships", (Object)exception);
            throw new RemoteException(nls.getFormattedMessage("repo.relationship.exception", new Object[]{exception.getMessage()}, "RepositoryObjectImpl could not get the relationship because of {0}."), exception);
        }
        Tr.exit((TraceComponent)tc, (String)"getRelationships", (Object)eJBObjectCollection);
        return eJBObjectCollection;
    }

    public Relation getModelRelation() throws RemoteException, OpException {
        Relation relation = null;
        Tr.entry((TraceComponent)tc, (String)"getModelRelation");
        Enumeration enumeration = this.getRelationships(false);
        while (enumeration.hasMoreElements()) {
            Relation relation2 = (Relation)enumeration.nextElement();
            RelationAttributes relationAttributes = new RelationAttributes();
            try {
                relationAttributes.request(Attributes.name);
                relationAttributes = (RelationAttributes)relation2.getAttributes(relationAttributes);
                if (!relationAttributes.getName().startsWith("Model")) continue;
                relation = relation2;
                break;
            }
            catch (AttributeDoesNotExistException attributeDoesNotExistException) {
                Tr.exit((TraceComponent)tc, (String)"getModelRelation - with attribute does not exist exception", (Object)((Object)attributeDoesNotExistException));
                throw new RemoteException(nls.getString("repo.attribute0.exception", "Attribute does not exist."), attributeDoesNotExistException);
            }
            catch (AttributeNotSetException attributeNotSetException) {
                Tr.exit((TraceComponent)tc, (String)"getModelRelation - with attribute not set exception", (Object)((Object)attributeNotSetException));
                throw new RemoteException(nls.getString("repo.attribute1.exception", "Attribute is not set."), attributeNotSetException);
            }
        }
        Tr.exit((TraceComponent)tc, (String)"getModelRelation", relation);
        return relation;
    }

    public Enumeration listRelatedObjects(Relation relation) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"listRelatedObjects");
        boolean bl = this.checkForReverseTraversal(relation);
        Enumeration enumeration = relation.list(this.id, bl);
        Tr.exit((TraceComponent)tc, (String)"listRelatedObjects");
        return enumeration;
    }

    public Enumeration listRelatedObjects(Relation relation, String string) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"listRelatedObjects");
        boolean bl = this.checkForReverseTraversal(relation);
        Enumeration enumeration = relation.list(this.id, string, bl);
        Tr.exit((TraceComponent)tc, (String)"listRelatedObjects");
        return enumeration;
    }

    public Enumeration listRelatedNames(Relation relation) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"listRelatedObjects");
        boolean bl = this.checkForReverseTraversal(relation);
        Enumeration enumeration = relation.listNames(this.ec.getEJBObject(), bl);
        Tr.exit((TraceComponent)tc, (String)"listRelatedNames");
        return enumeration;
    }

    public void addToRelation(Relation relation, EJBObject eJBObject) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"addToRelation");
        boolean bl = this.checkForReverseTraversal(relation);
        if (bl) {
            relation.add(eJBObject, this.ec.getEJBObject());
        } else {
            relation.add(this.ec.getEJBObject(), eJBObject);
        }
        Tr.exit((TraceComponent)tc, (String)"addToRelation");
    }

    public void addToNamedRelation(Relation relation, EJBObject eJBObject, String string) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"addToNamedRelation");
        this.checkForContainmentRelation(relation);
        boolean bl = this.checkForReverseTraversal(relation);
        if (bl) {
            relation.add(eJBObject, this.ec.getEJBObject(), string);
        } else {
            relation.add(this.ec.getEJBObject(), eJBObject, string);
        }
        Tr.exit((TraceComponent)tc, (String)"addToNamedRelation");
    }

    public void deleteFromRelation(Relation relation, EJBObject eJBObject) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"deleteFromRelation");
        this.checkForContainmentRelation(relation);
        boolean bl = this.checkForReverseTraversal(relation);
        if (bl) {
            relation.delete(eJBObject, this.ec.getEJBObject());
        } else {
            relation.delete(this.ec.getEJBObject(), eJBObject);
        }
        Tr.exit((TraceComponent)tc, (String)"deleteFromRelation");
    }

    public void deleteFromNamedRelation(Relation relation, EJBObject eJBObject, String string) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"deleteFromNamedRelation");
        this.checkForContainmentRelation(relation);
        boolean bl = this.checkForReverseTraversal(relation);
        if (bl) {
            relation.delete(eJBObject, this.ec.getEJBObject(), string);
        } else {
            relation.delete(this.ec.getEJBObject(), eJBObject, string);
        }
        Tr.exit((TraceComponent)tc, (String)"deleteFromNamedRelation");
    }

    public RepositoryObjectName getFullName() throws RemoteException, OpException {
        throw new OpNotImplementedException();
    }

    public Model createModelTreeFromInstanceTree(String string, boolean bl) throws RemoteException, CreateException, OpException {
        Tr.entry((TraceComponent)tc, (String)("createModelTreeFromInstanceTree:  modelNameSuffix" + string + " makeInstanceAClone " + bl));
        try {
            Model model = this.createModelTreeInternal(null, string, this.ec.getEJBObject(), bl);
            Tr.exit((TraceComponent)tc, (String)"createModelTreeFromInstanceTree", (Object)model);
            return model;
        }
        catch (OpException opException) {
            this.ec.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"createModelTreeFromInstanceTree", (Object)((Object)opException));
            throw opException;
        }
        catch (CreateException createException) {
            this.ec.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"createModelTreeFromInstanceTree", (Object)((Object)createException));
            throw createException;
        }
    }

    private Model createModelTreeInternal(Model model, String string, EJBObject eJBObject, boolean bl) throws RemoteException, CreateException, OpException {
        Tr.entry((TraceComponent)tc, (String)("createModelTreeInternal:  instance " + eJBObject + " makeInstanceAClone " + bl));
        ModelAttributes modelAttributes = new ModelAttributes();
        Class clazz = this.getEJBObjectInterface(eJBObject);
        modelAttributes.setName(string);
        modelAttributes.setCloneInterfaceClass(clazz.getName());
        modelAttributes.setName(string);
        modelAttributes.setCloneInterfaceClass(clazz.getName());
        RepositoryObject repositoryObject = (RepositoryObject)PortableRemoteObject.narrow((Object)eJBObject, (Class)(class$com$ibm$ejs$sm$beans$RepositoryObject == null ? (class$com$ibm$ejs$sm$beans$RepositoryObject = RepositoryObjectImpl.class$("com.ibm.ejs.sm.beans.RepositoryObject")) : class$com$ibm$ejs$sm$beans$RepositoryObject));
        ModelHome modelHome = (ModelHome)RepositoryObjectImpl.getHome("ModelHome");
        Model model2 = modelHome.create(modelAttributes, model, eJBObject);
        Enumeration enumeration = repositoryObject.listContainedObjects();
        while (enumeration.hasMoreElements()) {
            Object object;
            RepositoryObject repositoryObject2 = (RepositoryObject)enumeration.nextElement();
            Tr.event((TraceComponent)tc, (String)("containedObject: " + repositoryObject2 + " primaryKey: " + repositoryObject2.getPrimaryKey()));
            String string2 = null;
            try {
                object = this.getEJBObjectInterface(repositoryObject2).getName() + "Attributes";
                Class<?> clazz2 = Class.forName((String)object);
                Attributes attributes = (Attributes)clazz2.newInstance();
                attributes.request(Attributes.name);
                attributes = repositoryObject2.getAttributes(attributes);
                string2 = attributes.getName();
            }
            catch (Exception exception) {
                Tr.exit((TraceComponent)tc, (String)"createModelTreeInternal -- unexpected exception", (Object)exception);
                throw new RemoteException(nls.getFormattedMessage("repo.model.tree.exception", new Object[]{exception.getMessage()}, "RepositoryObjectImpl could not create the model tree because of {0}."), exception);
            }
            object = this.createModelTreeInternal(model2, string2, repositoryObject2, bl);
        }
        if (bl) {
            model2.associateClone(eJBObject);
        }
        Tr.exit((TraceComponent)tc, (String)"createModelTreeInternal", (Object)model2);
        return model2;
    }

    private String getUnqualifiedName(Class clazz) {
        Tr.entry((TraceComponent)tc, (String)"getUnqualifiedName", (Object)clazz);
        String string = clazz.getName();
        Tr.event((TraceComponent)tc, (String)"className: ", (Object)string);
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        Tr.exit((TraceComponent)tc, (String)"getUnqualifiedName", (Object)string2);
        return string2;
    }

    public Model isAClone() throws RemoteException, OpException {
        Enumeration enumeration;
        Relation relation = this.getModelRelation();
        Model model = null;
        if (relation != null && (enumeration = this.listRelatedObjects(relation)).hasMoreElements()) {
            try {
                model = (Model)relation.traverse(this.ec.getEJBObject(), true);
            }
            catch (RelationOpException relationOpException) {
                Tr.exit((TraceComponent)tc, (String)"isAClone - with RelationOpException", (Object)((Object)relationOpException));
                throw new RemoteException(nls.getString("repo.relation.operation.exception", "RepositoryObjectImpl found an invalid relation operation."), relationOpException);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                Tr.exit((TraceComponent)tc, (String)"isAClone - with ObjectNotFoundException", (Object)((Object)objectNotFoundException));
                throw new RemoteException(nls.getString("repo.object.exception", "RepositoryObjectImpl could not find an object."), objectNotFoundException);
            }
        }
        return model;
    }

    public String getModelName() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getModelName");
        String string = null;
        Model model = this.isAClone();
        Tr.event((TraceComponent)tc, (String)"Instance model: ", (Object)model);
        if (model != null) {
            try {
                ModelAttributes modelAttributes = new ModelAttributes();
                modelAttributes.request(Attributes.name);
                ModelAttributes modelAttributes2 = (ModelAttributes)model.getAttributes(modelAttributes);
                string = modelAttributes2.getName();
            }
            catch (AttributeDoesNotExistException attributeDoesNotExistException) {
                Tr.exit((TraceComponent)tc, (String)"getModelName - with attribute does not exist exception", (Object)((Object)attributeDoesNotExistException));
                throw new RemoteException(nls.getString("repo.attribute0.exception", "Attribute does not exist."), attributeDoesNotExistException);
            }
            catch (AttributeNotSetException attributeNotSetException) {
                Tr.exit((TraceComponent)tc, (String)"getModelName - with attribute not set exception", (Object)((Object)attributeNotSetException));
                throw new RemoteException(nls.getString("repo.attribute1.exception", "Attribute is not set."), attributeNotSetException);
            }
        }
        Tr.exit((TraceComponent)tc, (String)("getModelName: modelName = " + string));
        return string;
    }

    protected static Type getTypeObj(Long l) throws RemoteException {
        Type type;
        Tr.entry((TraceComponent)tc, (String)"getTypeObj", (Object)l);
        TypeHome typeHome = (TypeHome)RepositoryObjectImpl.getHome("TypeHome");
        try {
            type = typeHome.findByPrimaryKey(l);
        }
        catch (FinderException finderException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.finder.exception", new Object[]{l}, "Repository could not find the primary key {0}."), finderException);
            Tr.exit((TraceComponent)tc, (String)"getTypeObj - with FinderException", (Object)remoteException);
            throw remoteException;
        }
        return type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Type getTypeObj(String string, String string2, Attributes attributes, boolean bl) throws RemoteException {
        Type type;
        block9: {
            Tr.entry((TraceComponent)tc, (String)"getTypeObj", (Object)string);
            TypeHome typeHome = (TypeHome)RepositoryObjectImpl.getHome("TypeHome");
            type = null;
            TranContext tranContext = null;
            try {
                try {
                    tranContext = TranContext.create();
                    try {
                        type = typeHome.findByImplClass(string2, true);
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {
                        type = null;
                    }
                    if (type == null) {
                        TypeAttributes typeAttributes = new TypeAttributes();
                        typeAttributes.setImplClass(string2);
                        typeAttributes.setInterfaceClass(string);
                        typeAttributes.setDefaults(attributes);
                        typeAttributes.setIsRootType(bl);
                        type = typeHome.create(typeAttributes, null);
                    }
                }
                catch (Exception exception) {
                    if (tranContext != null) {
                        tranContext.markRollback();
                    }
                    Tr.exit((TraceComponent)tc, (String)"getTypeObj", (Object)exception);
                    throw new RemoteException("", exception);
                }
                Object var10_10 = null;
                if (tranContext == null) break block9;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (tranContext != null) {
                    tranContext.terminate();
                }
                throw throwable;
            }
            tranContext.terminate();
        }
        Tr.exit((TraceComponent)tc, (String)"getTypeObj", (Object)type.getPrimaryKey());
        return type;
    }

    protected static Type getTypeObj(String string) throws RemoteException {
        Type type;
        Tr.entry((TraceComponent)tc, (String)"getTypeObj", (Object)string);
        TypeHome typeHome = (TypeHome)RepositoryObjectImpl.getHome("TypeHome");
        try {
            type = typeHome.findByInterfaceClass(string, true);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            type = null;
        }
        catch (FinderException finderException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.finder1.exception", new Object[]{string}, "Repository could not find the type corresponding to interface {0}."), finderException);
            Tr.exit((TraceComponent)tc, (String)"getTypeObj", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"getTypeObj");
        return type;
    }

    protected static Attributes getDefaults(Type type) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"getDefaults");
        TypeAttributes typeAttributes = new TypeAttributes();
        Attributes attributes = null;
        try {
            typeAttributes.request("Defaults");
            typeAttributes = (TypeAttributes)type.getAttributes(typeAttributes);
            attributes = typeAttributes.getDefaults();
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.default.exception", new Object[]{exception.getMessage()}, "Repository could not get the default attributes due to {0}."), exception);
            Tr.exit((TraceComponent)tc, (String)"getDefaults - with java.lang.Exception", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"getDefaults");
        return attributes;
    }

    protected static String qualifyClassName(String string) {
        return "com.ibm.ejs.sm.beans." + string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Relation createRelIfNeeded(Type type, String string, String string2, boolean bl, boolean bl2, int n) throws RemoteException {
        Object object;
        Tr.entry((TraceComponent)tc, (String)"createRelIfNeeded", (Object)string2);
        RelationHome relationHome = (RelationHome)RepositoryObjectImpl.getHome("RelationHome");
        TranContext tranContext = null;
        try {
            try {
                tranContext = TranContext.create();
                Relation relation = null;
                try {
                    relation = relationHome.findByName(string2, true);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    Tr.event((TraceComponent)tc, (String)"Relation not yet created");
                }
                if (relation == null) {
                    Type type2;
                    object = (TypeHome)RepositoryObjectImpl.getHome("TypeHome");
                    try {
                        type2 = object.findByInterfaceClass("com.ibm.ejs.sm.beans." + string, true);
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {
                        if (!Boolean.getBoolean("com.ibm.ejs.sm.adminServer.stdEdition")) throw objectNotFoundException;
                        if (!string.equals("EJBContainer")) {
                            if (!string.equals("EnterpriseBean")) throw objectNotFoundException;
                        }
                        Tr.event((TraceComponent)tc, (String)"Ignoring create rel failure for std edition: ", (Object)((Object)objectNotFoundException));
                        Tr.exit((TraceComponent)tc, (String)"returning null");
                        Relation relation2 = null;
                        Object var14_16 = null;
                        if (tranContext == null) return relation2;
                        tranContext.terminate();
                        return relation2;
                    }
                    RelationAttributes relationAttributes = new RelationAttributes();
                    relationAttributes.setSourceType(type);
                    relationAttributes.setTargetType(type2);
                    relationAttributes.setName(string2);
                    relationAttributes.setIsNamed(bl);
                    relationAttributes.setIsContainment(bl2);
                    relationAttributes.setCardinality(n);
                    relation = relationHome.create(relationAttributes, null);
                }
                Tr.exit((TraceComponent)tc, (String)"createRelIfNeeded");
                object = relation;
                Object var14_17 = null;
                if (tranContext == null) return object;
            }
            catch (Exception exception) {
                if (tranContext == null) throw new RemoteException("", exception);
                tranContext.markRollback();
                throw new RemoteException("", exception);
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            if (tranContext == null) throw throwable;
            tranContext.terminate();
            throw throwable;
        }
        tranContext.terminate();
        return object;
    }

    protected static Relation lookupRel(EJBObject eJBObject, Type type, String string) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"lookupRel", (Object)string);
        Relation relation = null;
        try {
            RelationHome relationHome = (RelationHome)RepositoryObjectImpl.getHome("Relation");
            relation = relationHome.findByName(string, true);
        }
        catch (FinderException finderException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.finder2.exception", new Object[]{string}, "Repository could not find the relationship {0}."), finderException);
            Tr.exit((TraceComponent)tc, (String)"lookupRel", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"lookupRel", (Object)relation);
        return relation;
    }

    protected static Relation lookupRel(String string, Type type, String string2) throws RemoteException {
        Relation relation;
        Tr.entry((TraceComponent)tc, (String)"lookupRel", (Object)string2);
        try {
            TypeHome typeHome = (TypeHome)RepositoryObjectImpl.getHome("TypeHome");
            RelationHome relationHome = (RelationHome)RepositoryObjectImpl.getHome("RelationHome");
            Type type2 = typeHome.findByInterfaceClass(string, true);
            relation = relationHome.findByName(string2, true);
        }
        catch (FinderException finderException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.finder2.exception", new Object[]{string2}, "Repository could not find the relationship {0}."), finderException);
            Tr.exit((TraceComponent)tc, (String)"lookupRel", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"lookupRel", (Object)relation);
        return relation;
    }

    protected Enumeration enumFinderEpilogue(DBQueryResult dBQueryResult) throws SQLException {
        Tr.entry((TraceComponent)tc, (String)"enumFinderEpilogue");
        ResultSet resultSet = dBQueryResult.getResultSet();
        ObjectCollection objectCollection = new ObjectCollection();
        while (resultSet.next()) {
            objectCollection.addElement((Object)Utils.getId((String)resultSet.getString(1)));
        }
        try {
            Tr.exit((TraceComponent)tc, (String)"enumFinderEpilogue", (Object)objectCollection.getArray());
        }
        catch (RemoteException remoteException) {
            Tr.exit((TraceComponent)tc, (String)"enumFinderEpilogue ", (Object)remoteException);
        }
        return objectCollection;
    }

    protected Long singleFinderEpilogue(DBQueryResult dBQueryResult) throws ObjectNotFoundException, SQLException {
        String string;
        Tr.entry((TraceComponent)tc, (String)"singleFinderEpilogue");
        ResultSet resultSet = dBQueryResult.getResultSet();
        if (resultSet != null && resultSet.next() && (string = resultSet.getString(1)) != null) {
            Long l = Utils.getId((String)string);
            Tr.exit((TraceComponent)tc, (String)"singleFinderEpilogue", (Object)l);
            return l;
        }
        ObjectNotFoundException objectNotFoundException = new ObjectNotFoundException();
        Tr.exit((TraceComponent)tc, (String)"singleFinderEpilogue", (Object)((Object)objectNotFoundException));
        throw objectNotFoundException;
    }

    protected void renameIfNec(Attributes attributes, Relation relation) throws RemoteException, OpException {
        this.renameIfNec(attributes, relation, false);
    }

    protected void renameIfNec(Attributes attributes, Relation relation, boolean bl) throws RemoteException, OpException {
        try {
            if (attributes.isSet(Attributes.name)) {
                this.rename(relation, attributes.getName(), bl);
            }
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"getModelRelation - with attribute does not exist exception", (Object)((Object)attributeDoesNotExistException));
            throw new RemoteException(nls.getString("repo.attribute0.exception", "Attribute does not exist."), attributeDoesNotExistException);
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"getModelRelation - with attribute not set exception", (Object)((Object)attributeNotSetException));
            throw new RemoteException(nls.getString("repo.attribute1.exception", "Attribute is not set."), attributeNotSetException);
        }
    }

    protected RepositoryObjectName constructFullName(String string, String string2) throws RemoteException, OpException {
        RepositoryObject repositoryObject = null;
        try {
            repositoryObject = (RepositoryObject)this.getContainingObject();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new RemoteException("", objectNotFoundException);
        }
        RepositoryObjectName repositoryObjectName = repositoryObject.getFullName();
        RepositoryObjectName repositoryObjectName2 = new RepositoryObjectName(repositoryObjectName);
        repositoryObjectName2.addElement(new RepositoryObjectNameElem(string, string2));
        return repositoryObjectName2;
    }

    private boolean checkForReverseTraversal(Relation relation) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"checkForReverseTraversal");
        boolean bl = false;
        TypeHome typeHome = (TypeHome)RepositoryObjectImpl.getHome("TypeHome");
        Type type = null;
        try {
            type = typeHome.findByPrimaryKey(RepositoryObjectImpl.getTypeId(this.id));
        }
        catch (FinderException finderException) {
            Tr.exit((TraceComponent)tc, (String)"checkForReverseTraversal", (Object)((Object)finderException));
            throw new RemoteException("", finderException);
        }
        RelationAttributes relationAttributes = new RelationAttributes();
        try {
            relationAttributes.request("SourceType");
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"checkForReverseTraversal - with attribute does not exist exception", (Object)((Object)attributeDoesNotExistException));
            throw new RemoteException(nls.getString("repo.attribute0.exception", "Attribute does not exist."), attributeDoesNotExistException);
        }
        relationAttributes = (RelationAttributes)relation.getAttributes(relationAttributes);
        try {
            Long l = (Long)type.getPrimaryKey();
            Long l2 = (Long)relationAttributes.getSourceType().getPrimaryKey();
            if (!l.equals(l2)) {
                bl = true;
            }
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"checkForReverseTraversal - with attribute not set exception", (Object)((Object)attributeNotSetException));
            throw new RemoteException(nls.getString("repo.attribute1.exception", "Attribute is not set."), attributeNotSetException);
        }
        Tr.exit((TraceComponent)tc, (String)"checkForReverseTraversal", (Object)new Boolean(bl));
        return bl;
    }

    private void checkForContainmentRelation(Relation relation) throws RemoteException, OpException {
        try {
            RelationAttributes relationAttributes = new RelationAttributes();
            relationAttributes.request("IsContainment");
            relationAttributes = (RelationAttributes)relation.getAttributes(relationAttributes);
            if (relationAttributes.getIsContainment()) {
                throw new InvalidContainmentRelationOpException();
            }
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"checkForContainmentRelation - with attribute does not exist exception", (Object)((Object)attributeDoesNotExistException));
            throw new RemoteException(nls.getString("repo.attribute0.exception", "Attribute does not exist."), attributeDoesNotExistException);
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"checkForContainmentRelation - with attribute not set exception", (Object)((Object)attributeNotSetException));
            throw new RemoteException(nls.getString("repo.attribute1.exception", "Attribute is not set."), attributeNotSetException);
        }
    }

    private Relation getContainmentRel(Type type) throws ObjectNotFoundException, RemoteException {
        Tr.entry((TraceComponent)tc, (String)"getContainmentRel");
        Enumeration enumeration = this.getAllContainmentRels(true);
        try {
            while (enumeration.hasMoreElements()) {
                Relation relation = (Relation)PortableRemoteObject.narrow(enumeration.nextElement(), (Class)(class$com$ibm$ejs$sm$beans$Relation == null ? RepositoryObjectImpl.class$("com.ibm.ejs.sm.beans.Relation") : class$com$ibm$ejs$sm$beans$Relation));
                RelationAttributes relationAttributes = new RelationAttributes();
                relationAttributes.request("TargetType");
                relationAttributes = (RelationAttributes)relation.getAttributes(relationAttributes);
                if (!relationAttributes.getTargetType().getPrimaryKey().equals(type.getPrimaryKey()) && !type.isSubtype(relationAttributes.getTargetType())) continue;
                Tr.exit((TraceComponent)tc, (String)"getContainmentRel");
                return relation;
            }
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.containment.exception", new Object[]{exception.getMessage()}, "RepositoryObjectImpl could not find the containment relation due to {0}."), exception);
            Tr.exit((TraceComponent)tc, (String)"getContainmentRel", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"getContainmentRel -- not found");
        throw new ObjectNotFoundException();
    }

    private Enumeration getAllContainmentRels(boolean bl) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"getAllContainmentRels");
        RelationHome relationHome = (RelationHome)RepositoryObjectImpl.getHome("RelationHome");
        Enumeration enumeration = null;
        try {
            enumeration = relationHome.findAllContainmentRels(this.typeId, bl, true);
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.containment.exception", new Object[]{exception.getMessage()}, "RepositoryObjectImpl could not find the containment relation due to {0}."), exception);
            Tr.exit((TraceComponent)tc, (String)"getAllContainmentRels - with java.lang.Exception", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"getAllContainmentRels");
        return enumeration;
    }

    private void rename(Relation relation, String string, boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"rename", (Object)string);
        String string2 = this.getName(relation);
        if (string.equals(string2)) {
            Tr.exit((TraceComponent)tc, (String)"rename -- no op");
            return;
        }
        try {
            if (bl) {
                this.findByName(string);
                Tr.exit((TraceComponent)tc, (String)"rename -- duplicate name");
                throw new InvalidNameChangeException();
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"rename -- unexpected error", (Object)exception);
            throw new RemoteException("", exception);
        }
        EJBObject eJBObject = null;
        try {
            eJBObject = relation.traverse(this.ec.getEJBObject(), string2, true);
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.rename.exception", new Object[]{string, exception.getMessage()}, "RepositoryObjectImpl could not set the new name {0} due to {1}."), exception);
            Tr.exit((TraceComponent)tc, (String)"rename -- error while fetching containing object", (Object)remoteException);
            throw remoteException;
        }
        try {
            relation.traverse(eJBObject, string, false);
            Tr.exit((TraceComponent)tc, (String)"rename -- new name already in use");
            throw new InvalidNameChangeException();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            try {
                relation.delete(eJBObject, string2);
                relation.add(eJBObject, this.ec.getEJBObject(), string);
            }
            catch (OpException opException) {
                Tr.exit((TraceComponent)tc, (String)"rename -- error when doing delete, add for rename", (Object)((Object)opException));
                throw new RemoteException(nls.getString("repo.operation.exception", "Operation is not valid."), opException);
            }
            Tr.exit((TraceComponent)tc, (String)"rename");
            return;
        }
    }

    protected void checkAndIncrVersion(Attributes attributes) throws AttrsVersionMismatchException, RemoteException {
        if (attributes.versionCheckEnabled() && attributes.readVersion() != this.version) {
            throw new AttrsVersionMismatchException();
        }
        ++this.version;
        this.dirty = true;
    }

    protected void setVersion(Attributes attributes) {
        attributes.updateVersion(this.version);
    }

    protected void incrementVersion() {
        ++this.version;
        this.dirty = true;
    }

    protected static EJBObject dynamicFindByPrimaryKey(RepositoryHome repositoryHome, Long l) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"dynamicFindByPrimaryKey");
        EJBObject eJBObject = null;
        try {
            eJBObject = (EJBObject)PortableRemoteObject.narrow((Object)repositoryHome.findByPrimaryKeyGeneric(l), (Class)repositoryHome.getEJBMetaData().getRemoteInterfaceClass());
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException("", exception);
            Tr.exit((TraceComponent)tc, (String)"setId -- finder invocation exception", (Object)exception);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"dynamicFindByPrimaryKey");
        return eJBObject;
    }

    protected void setBinaryAttr(String string, Object object) throws RemoteException {
        Object object2;
        Tr.entry((TraceComponent)tc, (String)("setBinaryAttr:  name " + string + " val " + object));
        if (object == null) {
            Tr.exit((TraceComponent)tc, (String)"setBinaryAttr: null val");
            return;
        }
        if (object instanceof BinaryAttrSerialization) {
            object2 = new BinaryAttrVal();
            try {
                ((BinaryAttrVal)object2).setVal(((BinaryAttrSerialization)object).toProperties());
            }
            catch (Exception exception) {
                Tr.exit((TraceComponent)tc, (String)"setBinaryAttr -- error ", (Object)exception);
                throw new RemoteException("", exception);
            }
            ((BinaryAttrVal)object2).setClassName(object.getClass().getName());
        } else if (object instanceof Serializable) {
            object2 = object;
        } else {
            Tr.exit((TraceComponent)tc, (String)"setBinaryAttr -- not serializable ");
            throw new RemoteException("Binary attr not serializable");
        }
        this.dirty = true;
        ((Hashtable)this.binaryAttrs).put(string, object2);
        Tr.exit((TraceComponent)tc, (String)"setBinaryAttr");
    }

    protected Object getBinaryAttr(String string) throws RemoteException {
        Object object;
        String string2;
        Object object2;
        Tr.entry((TraceComponent)tc, (String)"getBinaryAttr: ", (Object)string);
        Object object3 = ((Hashtable)this.binaryAttrs).get(string);
        if (object3 == null) {
            Tr.exit((TraceComponent)tc, (String)"getBinaryAttr: null");
            return null;
        }
        if (object3 instanceof BinaryAttrVal) {
            object2 = ((BinaryAttrVal)object3).getVal();
            string2 = ((BinaryAttrVal)object3).getClassName();
            try {
                object = Class.forName(string2);
                object3 = ((Class)object).newInstance();
                ((BinaryAttrSerialization)object3).fromProperties((Properties)object2);
            }
            catch (Exception exception) {
                Tr.exit((TraceComponent)tc, (String)"getBinaryAttr -- error", (Object)exception);
                throw new RemoteException("", exception);
            }
        }
        object2 = new StringTokenizer(object3.toString(), ",");
        object = "";
        int n = 0;
        try {
            while (((StringTokenizer)object2).hasMoreTokens()) {
                string2 = (n != 0 ? "," : "") + ((StringTokenizer)object2).nextToken();
                int n2 = string2.toLowerCase().indexOf("password=");
                if (n2 > -1) {
                    string2 = string2.substring(0, n2 + 9) + "******";
                }
                object = (String)object + string2;
                ++n;
            }
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)tc, (String)("Error occured while parsing trace string: " + exception));
        }
        Tr.exit((TraceComponent)tc, (String)("getBinaryAttr: " + (String)object));
        return object3;
    }

    protected void removeBinaryAttr(String string) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"removeBinaryAttr: ", (Object)string);
        if (string != null) {
            Object v = ((Hashtable)this.binaryAttrs).get(string);
            if (v != null) {
                this.dirty = true;
                ((Hashtable)this.binaryAttrs).remove(string);
                Tr.exit((TraceComponent)tc, (String)"removeBinaryAttr: removed");
            }
        } else {
            Tr.exit((TraceComponent)tc, (String)"removeBinaryAttr: no remove, name=null");
        }
    }

    private void storeImplementation() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"storeImplementation");
        if (this.dirty) {
            Tr.event((TraceComponent)tc, (String)("dirty: " + new Boolean(this.dirty)));
            try {
                Vector<Object> vector = new Vector<Object>(3);
                vector.addElement(Utils.getIdString((Long)this.typeId));
                vector.addElement(new Integer(this.version));
                vector.addElement(Utils.serializeObject((Object)this.binaryAttrs));
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("repo.db.update0.exception", new Object[]{sQLException.getMessage(), this.id}, "RepositoryObjectImpl update failed due to {0} for statement with id = {1} ."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"storeImplementation - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
        }
        Tr.exit((TraceComponent)tc, (String)"storeImplementation");
    }

    protected DataSource getDataSource(Relation relation) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getDataSource");
        DataSource dataSource = null;
        Enumeration enumeration = this.listRelatedObjects(relation);
        if (enumeration.hasMoreElements()) {
            dataSource = (DataSource)enumeration.nextElement();
        }
        Tr.exit((TraceComponent)tc, (String)"getDataSource");
        return dataSource;
    }

    protected void updateDataSource(Relation relation, Node node, DataSource dataSource) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"updateDataSource");
        if (dataSource != null && !dataSource.checkUsabilityOnNode(node)) {
            Tr.exit((TraceComponent)tc, (String)"updateDataSource -- data source not present on node");
            throw new DataSourceUnavailableOnNodeException();
        }
        DataSource dataSource2 = this.getDataSource(relation);
        if (dataSource2 != null) {
            this.deleteFromRelation(relation, dataSource2);
        }
        if (dataSource != null) {
            this.addToRelation(relation, dataSource);
        }
        Tr.exit((TraceComponent)tc, (String)"updateDataSource");
    }

    protected void setDataSource(Relation relation, Node node, DataSource dataSource) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setDataSource");
        if (dataSource == null) {
            Tr.exit((TraceComponent)tc, (String)"setDataSource -- null data source");
            return;
        }
        if (!dataSource.checkUsabilityOnNode(node)) {
            Tr.exit((TraceComponent)tc, (String)"setDataSource -- unavailable on node");
            throw new DataSourceUnavailableOnNodeException();
        }
        relation.addUsingKeys((Long)dataSource.getPrimaryKey(), this.id);
        Tr.exit((TraceComponent)tc, (String)"setDataSource");
    }

    public void recursiveRemove() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"recursiveRemove");
        EntityContext entityContext = this.ec;
        try {
            Enumeration enumeration = this.listContainedObjects(true);
            while (enumeration.hasMoreElements()) {
                if (this instanceof NodeBean) {
                    throw new RemoteException("First remove all the servers on this node");
                }
                RepositoryObject repositoryObject = (RepositoryObject)enumeration.nextElement();
                repositoryObject.recursiveRemove();
            }
            this.ec.getEJBObject().remove();
        }
        catch (RemoveException removeException) {
            entityContext.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"recursiveRemove", (Object)((Object)removeException));
            throw removeException;
        }
        Tr.exit((TraceComponent)tc, (String)"recursiveRemove");
    }

    protected Class getEJBObjectInterface(EJBObject eJBObject) throws RemoteException {
        try {
            return eJBObject.getEJBHome().getEJBMetaData().getRemoteInterfaceClass();
        }
        catch (Exception exception) {
            throw new RemoteException(nls.getFormattedMessage("repo.remote.exception", new Object[]{exception.getMessage()}, "Repository could not find the remote interface due to {0}."), exception);
        }
    }

    /*
     * Loose catch block
     */
    protected void loadObjectTableCache(Long l) {
        block10: {
            DBQueryResult dBQueryResult = null;
            Tr.entry((TraceComponent)tc, (String)"loadObjectTableCache");
            Vector<String> vector = new Vector<String>();
            vector.addElement(Utils.getIdString((Long)l));
            dBQueryResult = DBMgr.executePreparedQuery((int)loadObjTableCacheStmtKey, (String)loadObjTableCacheStmtSql, vector);
            ResultSet resultSet = dBQueryResult.getResultSet();
            while (resultSet.next()) {
                Long l2 = Utils.getId((String)resultSet.getString(1));
                ObjectTableCacheElement objectTableCacheElement = new ObjectTableCacheElement(l2, l);
                objTableCache.insert((Object)l2, (Object)objectTableCacheElement);
            }
            Object var8_8 = null;
            try {
                DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
            }
            catch (Exception exception) {
                Tr.event((TraceComponent)tc, (String)"Ignoring exception when loading obj table cache", (Object)exception);
            }
            Tr.exit((TraceComponent)tc, (String)"loadObjectTableCache");
            {
                break block10;
                catch (Exception exception) {
                    Tr.event((TraceComponent)tc, (String)"Ignoring exception when loading obj table cache", (Object)exception);
                    Object var8_9 = null;
                    try {
                        DBMgr.doneWithQuery(dBQueryResult);
                    }
                    catch (Exception exception2) {
                        Tr.event((TraceComponent)tc, (String)"Ignoring exception when loading obj table cache", (Object)exception2);
                    }
                    Tr.exit((TraceComponent)tc, (String)"loadObjectTableCache");
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    DBMgr.doneWithQuery(dBQueryResult);
                }
                catch (Exception exception) {
                    Tr.event((TraceComponent)tc, (String)"Ignoring exception when loading obj table cache", (Object)exception);
                }
                Tr.exit((TraceComponent)tc, (String)"loadObjectTableCache");
                throw throwable;
            }
        }
    }

    protected Long findByName(String string) throws RemoteException, FinderException {
        Tr.entry((TraceComponent)tc, (String)"findByName - subclass must override");
        Tr.exit((TraceComponent)tc, (String)"findByName");
        return new Long(0L);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

