/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.DataSourceHome;
import com.ibm.ejs.sm.beans.EJBServer;
import com.ibm.ejs.sm.beans.EJBServerAttributes;
import com.ibm.ejs.sm.beans.EJBServerBean;
import com.ibm.ejs.sm.beans.J2CConnectionFactoryHome;
import com.ibm.ejs.sm.beans.J2EEResourceConfig;
import com.ibm.ejs.sm.beans.JMSConnectionFactoryHome;
import com.ibm.ejs.sm.beans.JMSDestinationHome;
import com.ibm.ejs.sm.beans.MailSessionHome;
import com.ibm.ejs.sm.beans.Module;
import com.ibm.ejs.sm.beans.ModuleAttributes;
import com.ibm.ejs.sm.beans.ModuleBean;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.Relation;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.Resource;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.beans.URLHome;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.sm.exception.DuplicateResourceNameException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.RemoteOpException;
import com.ibm.ejs.sm.exception.ResourceInActiveUseException;
import com.ibm.ejs.sm.exception.ResourceInUseException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Referenceable;

public class ResourceBean
extends RepositoryObjectImpl
implements EntityBean {
    protected static NLS nls = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$ResourceBean == null ? (class$com$ibm$ejs$sm$beans$ResourceBean = ResourceBean.class$("com.ibm.ejs.sm.beans.ResourceBean")) : class$com$ibm$ejs$sm$beans$ResourceBean));
    private static Integer classLock = new Integer(0);
    protected static final String myInterfaceName = RepositoryObjectImpl.qualifyClassName("Resource");
    private static final String myClassName = RepositoryObjectImpl.qualifyClassName("ResourceBean");
    private static boolean tableCreated = false;
    private static Type myTypeObj = null;
    private static Long myTypeId = null;
    private static Class myClass;
    private static final String myHomeName = "ResourceHome";
    private static Relation moduleResourceRel;
    private static Relation serverResourceRel;
    private String name;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$ResourceBean;

    public ResourceBean() throws RemoteException {
        ResourceBean.initializeNLS("RepositoryStrings");
        ResourceBean.initializeTypeId();
    }

    private void checkForUse() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"checkForUse");
        try {
            Enumeration enumeration;
            Object object;
            Relation relation = ResourceBean.lookupModuleResourceRel();
            if (relation != null && (object = this.listRelatedObjects(relation)).hasMoreElements()) {
                throw new ResourceInUseException();
            }
            object = ResourceBean.lookupServerResourceRel();
            if (object != null && (enumeration = this.listRelatedObjects((Relation)object)).hasMoreElements()) {
                throw new ResourceInUseException();
            }
        }
        catch (OpException opException) {
            Tr.event((TraceComponent)tc, (String)"checkForUse -- unexpected exception ", (Object)((Object)opException));
            throw new RemoteException(nls.getString("dsb.instance.operation1.exception", "An operation exception occurred. "), opException);
        }
    }

    protected void checkForActiveResourceUse() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"checkForActiveResourceUse");
        boolean bl = false;
        try {
            Object object;
            Object object2;
            Object object3;
            Relation relation = ResourceBean.lookupModuleResourceRel();
            if (relation != null) {
                object3 = this.listRelatedObjects(relation);
                while (object3.hasMoreElements()) {
                    object2 = (Module)object3.nextElement();
                    if (object2.getCurrentState() == 5) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("module: " + object2));
                        Tr.debug((TraceComponent)tc, (String)("current state: " + object2.getCurrentState()));
                    }
                    bl = true;
                    object = new ModuleAttributes();
                    object = (ModuleAttributes)object2.getAttributes((Attributes)object);
                    Tr.error((TraceComponent)tc, (String)nls.getFormattedMessage("resource.in.active.use", new Object[]{((Attributes)object).getName()}, "Resource is in active use by module {0}."));
                }
            }
            if ((object3 = ResourceBean.lookupServerResourceRel()) != null) {
                object2 = this.listRelatedObjects((Relation)object3);
                while (object2.hasMoreElements()) {
                    object = (EJBServer)object2.nextElement();
                    if (object.getCurrentState() == 5) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("server: " + object));
                        Tr.debug((TraceComponent)tc, (String)("current state: " + object.getCurrentState()));
                    }
                    bl = true;
                    EJBServerAttributes eJBServerAttributes = new EJBServerAttributes();
                    eJBServerAttributes = (EJBServerAttributes)object.getAttributes(eJBServerAttributes);
                    Tr.error((TraceComponent)tc, (String)nls.getFormattedMessage("resource.in.active.server.use", new Object[]{eJBServerAttributes.getName()}, "Resource is in active use by server {0}."));
                }
            }
        }
        catch (Throwable throwable) {
            this.ec.setRollbackOnly();
            Tr.error((TraceComponent)tc, (String)nls.getString("dsb.instance.operation1.exception", "An operation exception occurred. "), (Object)throwable);
            Tr.exit((TraceComponent)tc, (String)"checkForActiveResourceUse");
            throw new RemoteOpException(nls.getString("dsb.instance.operation1.exception", "An operation exception occurred. "), throwable);
        }
        if (bl) {
            this.ec.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"checkForActiveResourceUse");
            throw new ResourceInActiveUseException();
        }
        Tr.exit((TraceComponent)tc, (String)"checkForActiveResourceUse");
    }

    private static Relation lookupModuleResourceRel() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupModuleResourceRel");
        }
        Integer n = classLock;
        synchronized (n) {
            if (moduleResourceRel != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"lookupModuleResourceRel");
                }
                Relation relation = moduleResourceRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.lookupRel(ModuleBean.myInterfaceName, myTypeObj, "moduleResourceRel");
        Integer n2 = classLock;
        synchronized (n2) {
            moduleResourceRel = relation;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupModuleResourceRel");
        }
        return relation;
    }

    private static Relation lookupServerResourceRel() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupServerResourceRel");
        }
        Integer n = classLock;
        synchronized (n) {
            if (serverResourceRel != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"lookupServerResourceRel");
                }
                Relation relation = serverResourceRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.lookupRel(EJBServerBean.myInterfaceName, myTypeObj, "ejbServerResourceRel");
        Integer n2 = classLock;
        synchronized (n2) {
            serverResourceRel = relation;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupModuleResourceRel");
        }
        return relation;
    }

    public Long ejbCreate(Attributes attributes, EJBObject eJBObject) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        Tr.exit((TraceComponent)tc, (String)"ejbCreate");
        return null;
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException, FinderException {
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll", (Object)new Boolean(bl));
        Enumeration enumeration = null;
        Tr.exit((TraceComponent)tc, (String)"ejbFindAll");
        return enumeration;
    }

    public void ejbLoad() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbLoad");
        super.ejbLoad();
        Tr.exit((TraceComponent)tc, (String)"ejbLoad");
    }

    public void ejbPostCreate(Attributes attributes, EJBObject eJBObject) throws RemoteException {
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        this.checkForUse();
        super.ejbRemove();
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        super.ejbStore();
        Tr.exit((TraceComponent)tc, (String)"ejbStore");
    }

    public Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return attributes;
    }

    public J2EEResourceConfig getResourceConfig() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getConfig");
        Tr.exit((TraceComponent)tc, (String)"getConfig");
        return null;
    }

    public J2EEResourceConfig getResourceConfig(Node node) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getConfig");
        Tr.exit((TraceComponent)tc, (String)"getConfig");
        return null;
    }

    protected static void initializeNLS(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeNLS");
        }
        if (nls == null) {
            nls = new NLS(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeNLS");
        }
    }

    private static void initializeTypeId() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        Integer n = classLock;
        synchronized (n) {
            if (myTypeId != null) {
                return;
            }
        }
        Attributes attributes = new Attributes();
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, attributes, true);
        Long l = (Long)type.getPrimaryKey();
        Integer n2 = classLock;
        synchronized (n2) {
            myTypeObj = type;
            myTypeId = l;
        }
        Tr.exit((TraceComponent)tc, (String)"intializeTypeId");
    }

    public void setAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setAttributes");
        Tr.exit((TraceComponent)tc, (String)"setAttributes");
    }

    public Enumeration ejbFindByResourceType(String string) throws RemoteException, FinderException {
        Tr.entry((TraceComponent)tc, (String)"ejbFindByResourceType", (Object)string);
        Enumeration enumeration = null;
        Vector vector = new Vector();
        J2CConnectionFactoryHome j2CConnectionFactoryHome = (J2CConnectionFactoryHome)RepositoryObjectImpl.getHome("J2CConnectionFactoryHome");
        try {
            if (string.equals("javax.sql.DataSource")) {
                DataSourceHome dataSourceHome = (DataSourceHome)RepositoryObjectImpl.getHome("DataSourceHome");
                enumeration = dataSourceHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = j2CConnectionFactoryHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = vector.elements();
            } else if (string.equals("javax.mail.Session")) {
                MailSessionHome mailSessionHome = (MailSessionHome)RepositoryObjectImpl.getHome("MailSessionHome");
                enumeration = mailSessionHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = j2CConnectionFactoryHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = vector.elements();
            } else if (string.equals("java.net.URL")) {
                URLHome uRLHome = (URLHome)RepositoryObjectImpl.getHome("URLHome");
                enumeration = uRLHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = j2CConnectionFactoryHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = vector.elements();
            } else if (string.equals("javax.resource.cci.ConnectionFactory")) {
                enumeration = j2CConnectionFactoryHome.findAll(false);
            } else if (string.equals("javax.jms.QueueConnectionFactory") || string.equals("javax.jms.TopicConnectionFactory") || string.equals("javax.jms.XAQueueConnectionFactory") || string.equals("javax.jms.XATopicConnectionFactory")) {
                JMSConnectionFactoryHome jMSConnectionFactoryHome = (JMSConnectionFactoryHome)RepositoryObjectImpl.getHome("JMSConnectionFactoryHome");
                enumeration = jMSConnectionFactoryHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = j2CConnectionFactoryHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = vector.elements();
            } else if (string.equals("javax.jms.Queue") || string.equals("javax.jms.Topic")) {
                JMSDestinationHome jMSDestinationHome = (JMSDestinationHome)RepositoryObjectImpl.getHome("JMSDestinationHome");
                enumeration = jMSDestinationHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = j2CConnectionFactoryHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = vector.elements();
            } else {
                DataSourceHome dataSourceHome = (DataSourceHome)RepositoryObjectImpl.getHome("DataSourceHome");
                MailSessionHome mailSessionHome = (MailSessionHome)RepositoryObjectImpl.getHome("MailSessionHome");
                URLHome uRLHome = (URLHome)RepositoryObjectImpl.getHome("URLHome");
                JMSConnectionFactoryHome jMSConnectionFactoryHome = (JMSConnectionFactoryHome)RepositoryObjectImpl.getHome("JMSConnectionFactoryHome");
                JMSDestinationHome jMSDestinationHome = (JMSDestinationHome)RepositoryObjectImpl.getHome("JMSDestinationHome");
                enumeration = j2CConnectionFactoryHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = dataSourceHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = mailSessionHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = uRLHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = jMSConnectionFactoryHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = jMSDestinationHome.findAll(false);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                enumeration = vector.elements();
            }
        }
        catch (FinderException finderException) {
            Tr.warning((TraceComponent)tc, (String)"ejbFindAll failed", (Object)new Object[]{string, finderException});
            throw finderException;
        }
        catch (RemoteException remoteException) {
            Tr.exit((TraceComponent)tc, (String)"ejbFindByResourceType internal error", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFindByResourceType");
        return enumeration;
    }

    public String getJNDIName() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"getJNDIName");
        Tr.exit((TraceComponent)tc, (String)"getJNDIName");
        return null;
    }

    public Long ejbFindByJNDIName(String string, String string2) throws RemoteException, FinderException {
        Object object;
        Resource resource;
        block37: {
            Tr.entry((TraceComponent)tc, (String)"ejbFindByJNDIName", (Object)string2);
            resource = null;
            J2CConnectionFactoryHome j2CConnectionFactoryHome = (J2CConnectionFactoryHome)RepositoryObjectImpl.getHome("J2CConnectionFactoryHome");
            try {
                if (string2.equals("javax.sql.DataSource")) {
                    object = (DataSourceHome)RepositoryObjectImpl.getHome("DataSourceHome");
                    try {
                        resource = object.findByJNDIName(string, false);
                    }
                    catch (FinderException finderException) {
                        resource = j2CConnectionFactoryHome.findByJNDIName(string, false);
                    }
                    break block37;
                }
                if (string2.equals("javax.mail.Session")) {
                    object = (MailSessionHome)RepositoryObjectImpl.getHome("MailSessionHome");
                    try {
                        resource = object.findByJNDIName(string, false);
                    }
                    catch (FinderException finderException) {
                        resource = j2CConnectionFactoryHome.findByJNDIName(string, false);
                    }
                    break block37;
                }
                if (string2.equals("java.net.URL")) {
                    object = (URLHome)RepositoryObjectImpl.getHome("URLHome");
                    try {
                        resource = object.findByJNDIName(string, false);
                    }
                    catch (FinderException finderException) {
                        resource = j2CConnectionFactoryHome.findByJNDIName(string, false);
                    }
                    break block37;
                }
                if (string2.equals("javax.resource.cci.ConnectionFactory")) {
                    resource = j2CConnectionFactoryHome.findByJNDIName(string, false);
                    break block37;
                }
                if (string2.equals("javax.jms.QueueConnectionFactory") || string2.equals("javax.jms.TopicConnectionFactory") || string2.equals("javax.jms.XAQueueConnectionFactory") || string2.equals("javax.jms.XATopicConnectionFactory")) {
                    object = (JMSConnectionFactoryHome)RepositoryObjectImpl.getHome("JMSConnectionFactoryHome");
                    try {
                        resource = object.findByJNDIName(string, false);
                    }
                    catch (FinderException finderException) {
                        resource = j2CConnectionFactoryHome.findByJNDIName(string, false);
                    }
                    break block37;
                }
                if (string2.equals("javax.jms.Queue") || string2.equals("javax.jms.Topic")) {
                    object = (JMSDestinationHome)RepositoryObjectImpl.getHome("JMSDestinationHome");
                    try {
                        resource = object.findByJNDIName(string, false);
                    }
                    catch (FinderException finderException) {
                        resource = j2CConnectionFactoryHome.findByJNDIName(string, false);
                    }
                    break block37;
                }
                object = (DataSourceHome)RepositoryObjectImpl.getHome("DataSourceHome");
                MailSessionHome mailSessionHome = (MailSessionHome)RepositoryObjectImpl.getHome("MailSessionHome");
                URLHome uRLHome = (URLHome)RepositoryObjectImpl.getHome("URLHome");
                JMSConnectionFactoryHome jMSConnectionFactoryHome = (JMSConnectionFactoryHome)RepositoryObjectImpl.getHome("JMSConnectionFactoryHome");
                JMSDestinationHome jMSDestinationHome = (JMSDestinationHome)RepositoryObjectImpl.getHome("JMSDestinationHome");
                try {
                    resource = object.findByJNDIName(string, false);
                }
                catch (FinderException finderException) {
                    // empty catch block
                }
                if (resource == null) {
                    try {
                        resource = mailSessionHome.findByJNDIName(string, false);
                    }
                    catch (FinderException finderException) {
                        // empty catch block
                    }
                }
                if (resource == null) {
                    try {
                        resource = uRLHome.findByJNDIName(string, false);
                    }
                    catch (FinderException finderException) {
                        // empty catch block
                    }
                }
                if (resource == null) {
                    try {
                        resource = j2CConnectionFactoryHome.findByJNDIName(string, false);
                    }
                    catch (FinderException finderException) {
                        // empty catch block
                    }
                }
                if (resource == null) {
                    try {
                        resource = jMSConnectionFactoryHome.findByJNDIName(string, false);
                    }
                    catch (FinderException finderException) {
                        // empty catch block
                    }
                }
                if (resource == null) {
                    try {
                        resource = jMSDestinationHome.findByJNDIName(string, false);
                    }
                    catch (FinderException finderException) {}
                }
            }
            catch (FinderException finderException) {
                Tr.warning((TraceComponent)tc, (String)"ejbFindByJNDIName failed", (Object)new Object[]{string2, finderException});
                throw finderException;
            }
            catch (RemoteException remoteException) {
                Tr.exit((TraceComponent)tc, (String)"ejbFindByJNDIName internal error", (Object)remoteException);
                throw remoteException;
            }
        }
        if (resource == null) {
            object = nls.getFormattedMessage("rsb.jndiname.exception", new Object[]{string, string2}, "can not find the resource with jdni name {0} of type {1}");
            Tr.error((TraceComponent)tc, (String)object);
            throw new FinderException((String)object);
        }
        object = (Long)resource.getPrimaryKey();
        Tr.exit((TraceComponent)tc, (String)"ejbFindByJNDIName");
        return object;
    }

    protected void validateName(String string) throws RemoteException, CreateException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("validateName: " + this));
        }
        try {
            this.findByName(string);
            bl = true;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            bl = false;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"validateName -- unexpected error", (Object)exception);
            throw new RemoteException("", exception);
        }
        if (bl) {
            Tr.exit((TraceComponent)tc, (String)"validateName -- duplicate name");
            throw new DuplicateResourceNameException(nls.getFormattedMessage("resource.duplicate.name", new Object[]{string}, "Resource named {0} already exists."));
        }
        Tr.exit((TraceComponent)tc, (String)"validateName");
    }

    protected void insertIntoNameSpace(String string, Referenceable referenceable) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)("insertIntoNameSpace: " + string));
        try {
            this.recursiveBind(string, referenceable);
        }
        catch (NamingException namingException) {
            Tr.exit((TraceComponent)tc, (String)"insertIntoNameSpace", (Object)namingException);
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)namingException);
        }
        Tr.exit((TraceComponent)tc, (String)"insertIntoNameSpace");
    }

    protected void updateInNameSpace(String string, Referenceable referenceable) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)("updateInNameSpace: " + string));
        try {
            InitialContext initialContext = new InitialContext();
            initialContext.rebind(string, (Object)referenceable);
        }
        catch (NamingException namingException) {
            Tr.exit((TraceComponent)tc, (String)"updateInNameSpace", (Object)namingException);
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)namingException);
        }
        Tr.exit((TraceComponent)tc, (String)"updateInNameSpace");
    }

    protected void renameInNameSpace(String string, String string2, Referenceable referenceable) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)("renameInNameSpace: " + string + " -> " + string2));
        this.insertIntoNameSpace(string2, referenceable);
        try {
            this.deleteFromNameSpace(string);
        }
        catch (RemoteException remoteException) {
            this.deleteFromNameSpace(string2);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"renameInNameSpace");
    }

    protected void deleteFromNameSpace(String string) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)("deleteFromNameSpace: " + string));
        try {
            InitialContext initialContext = new InitialContext();
            initialContext.unbind(string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            Tr.event((TraceComponent)tc, (String)("Can't delete <" + string + "> - It's not in the namespace"));
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"deleteFromNameSpace", (Object)exception);
            RemoteException remoteException = new RemoteException("", exception);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"deleteFromNameSpace");
    }

    private void recursiveBind(String string, Referenceable referenceable) throws NamingException {
        Tr.entry((TraceComponent)tc, (String)"recursiveBind");
        InitialContext initialContext = new InitialContext();
        Name name = initialContext.getNameParser("").parse(string);
        Name name2 = null;
        int n = 0;
        while (n < name.size()) {
            try {
                name2 = name.getPrefix(n);
                if (!name2.isEmpty()) {
                    Tr.debug((TraceComponent)tc, (String)"Creating context", (Object)name2);
                    initialContext.createSubcontext(name2);
                }
            }
            catch (NameAlreadyBoundException nameAlreadyBoundException) {
                Tr.debug((TraceComponent)tc, (String)"Already bound", (Object)name2);
            }
            ++n;
        }
        initialContext.bind(name, (Object)referenceable);
        Tr.exit((TraceComponent)tc, (String)"recursiveBind");
    }

    protected void updateModuleBindings(String string, String string2) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"updateModuleBindings");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Replacing " + string + " with " + string2 + " in bindings."));
        }
        this.checkForActiveResourceUse();
        Relation relation = ResourceBean.lookupModuleResourceRel();
        if (relation != null) {
            Enumeration enumeration = this.listRelatedObjects(relation);
            while (enumeration.hasMoreElements()) {
                Module module = (Module)enumeration.nextElement();
                module.renameInBindings(string, string2);
            }
        }
        Tr.exit((TraceComponent)tc, (String)"updateModuleBindings");
    }

    protected void checkForDuplicateJNDIName(String string) throws RemoteOpException {
        Tr.entry((TraceComponent)tc, (String)"checkForDuplicateJNDIName");
        try {
            try {
                InitialContext initialContext = new InitialContext();
                initialContext.lookup(string);
                Tr.error((TraceComponent)tc, (String)nls.getFormattedMessage("resource.duplicate.jndi.name", new Object[]{string}, "JNDI name {0} is already in use."));
                throw new RemoteOpException("JNDI name " + string + " is already in use");
            }
            catch (NameNotFoundException nameNotFoundException) {
                Object var5_4 = null;
                Tr.exit((TraceComponent)tc, (String)"checkForDuplicateJNDIName");
            }
            catch (Exception exception) {
                throw new RemoteOpException("Caught exception while looking up " + string, (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Tr.exit((TraceComponent)tc, (String)"checkForDuplicateJNDIName");
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

