/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.WebSphereSecurity.AuthenticationFailedException;
import com.ibm.WebSphereSecurity.BasicAuthData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.security.SecurityCollaborator;
import com.ibm.ejs.security.registry.CustomRegistryImpl;
import com.ibm.ejs.security.registry.RegistryImpl;
import com.ibm.ejs.security.registry.RegistryImplFactory;
import com.ibm.ejs.security.util.Constants;
import com.ibm.ejs.sm.active.ActiveObjectConfig;
import com.ibm.ejs.sm.active.ActiveSecurityConfigConfig;
import com.ibm.ejs.sm.agent.AdminAgent;
import com.ibm.ejs.sm.agent.ContainmentPath;
import com.ibm.ejs.sm.agent.ContainmentPathElem;
import com.ibm.ejs.sm.agent.ParamList;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.NodeHome;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.SecureSocketLayerConfig;
import com.ibm.ejs.sm.beans.SecurityConfig;
import com.ibm.ejs.sm.beans.SecurityConfigAttributes;
import com.ibm.ejs.sm.beans.ServerAttributes;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.InvalidUserRegistryConfigException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.RemoteOpException;
import com.ibm.ejs.sm.server.ManagedServer;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.act.Act;
import com.ibm.ejs.sm.util.act.ActServerImpl;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import com.ibm.ejs.sm.util.task.AsyncTask;
import com.ibm.ws.security.core.SASConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.rmi.PortableRemoteObject;
import org.omg.CosTransactions.Control;

public class SecurityConfigBean
extends RepositoryObjectImpl
implements EntityBean {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$SecurityConfigBean == null ? (class$com$ibm$ejs$sm$beans$SecurityConfigBean = SecurityConfigBean.class$("com.ibm.ejs.sm.beans.SecurityConfigBean")) : class$com$ibm$ejs$sm$beans$SecurityConfigBean));
    private static Object classLock = new Object();
    static Long singletonId = null;
    public static final String DEFAULTREALMNAME = "Default";
    public static final String NONE = "None";
    public static final String BASIC = "Basic";
    public static final String CERT = "Cert";
    public static final String DIGEST = "Digest";
    public static final String CUSTOM = "Custom";
    public static final String LTPA = "LTPA";
    public static final String LDAP = "LDAP";
    public static final String LOCALOS = "LOCALOS";
    public static final String defaultURFactory = "com.ibm.ejs.security.registry.WSRegistryImplFactory";
    public static final String USING_CUSTOM_DATASOURCE = "com.ibm.websphere.security.customuserregistry.datasource";
    public static final String SSO_COOKIE_DOMAIN = "cookie.domain";
    public static final String SSO_COOKIE_SECURE = "cookie.secure";
    public static final String SSO_COOKIE_NAME = "cookie.name";
    public static final String defaultToBasicKey = "defaultToBasic";
    public static final String regURLKey = "registrationURL";
    public static final String loginURLKey = "loginURL";
    public static final String reloginURLKey = "reloginURL";
    public static final String codeKey = "code";
    public static final String ssoName = "sso.name";
    public static final String ssoDomain = "sso.domain";
    public static final String ssoSecure = "sso.secure";
    public static final String SERVER_ID_SUFFIX = ".server.id";
    public static final String SERVER_PWD_SUFFIX = ".server.pwd";
    public static final String LOCALOS_ID = "LOCALOS.server.id";
    public static final String LOCALOS_PWD = "LOCALOS.server.pwd";
    public static final int defaultPluginCacheTimeout = 600;
    protected static String myInterfaceName = RepositoryObjectImpl.qualifyClassName("SecurityConfig");
    protected static String myClassName = RepositoryObjectImpl.qualifyClassName("SecurityConfigBean");
    protected static Long myTypeId = null;
    protected static Type myTypeObj = null;
    protected static SecurityConfigAttributes defaults = null;
    private static boolean tableCreated = false;
    protected boolean dirty = false;
    private static final String ctPropsAttrName = myInterfaceName + ".ctProps";
    private static final String amPropsAttrName = myInterfaceName + ".amProps";
    private static final String uRPropsAttrName = myInterfaceName + ".uRProps";
    private static final String defaultSSLAttrName = myInterfaceName + ".defaultSSLConfig";
    private static final String ldapSSLAttrName = myInterfaceName + ".ldapSSLConfig";
    private boolean securityEnabled = true;
    private String realmName;
    private String challengeType = "Basic";
    private Properties ctProperties = null;
    private boolean sslEnabled = false;
    private String authMechanism = "LOCALOS";
    private Properties amProperties = null;
    private boolean ssoEnabled = false;
    private String userRegistry = "LOCALOS";
    private String uRFactoryClass = "com.ibm.ejs.security.registry.WSRegistryImplFactory";
    private Properties uRProperties = null;
    private int pluginCacheTimeout = 600;
    private boolean trustAssociationEnabled = false;
    private SecureSocketLayerConfig defaultSSLConfig = null;
    private boolean ldapSSLEnabled = false;
    private SecureSocketLayerConfig ldapSSLConfig = null;
    static String tableName = DBMgr.qualifiedTableName((String)"SECURITYCFG_TABLE");
    private static String securityEnabledColumnName = "SECURITYENABLED";
    private static final int securityEnabledColumnIndex = 3;
    private static String realmNameColumnName = "REALMNAME";
    private static final int realmNameColumnIndex = 4;
    private static String challengeTypeColumnName = "CHALLENGETYPE";
    private static final int challengeTypeColumnIndex = 5;
    private static String sslEnabledColumnName = "SSLEnabled";
    private static final int SSLEnabledColumnIndex = 6;
    private static String ssoEnabledColumnName = "SSOEnabled";
    private static final int SSOEnabledColumnIndex = 7;
    private static String authMechanismColumnName = "AUTHMECHANISM";
    private static final int authMechanismColumnIndex = 8;
    private static String userRegistryColumnName = "URTYPE";
    private static final int userRegistryColumnIndex = 9;
    private static String uRFactoryClassColumnName = "URFACTORYCLASS";
    private static final int uRFactoryClassColumnIndex = 10;
    private static String pluginCacheTimeoutColumnName = "PLUGINCACHETIMEOUT";
    private static final int pluginCacheTimeoutColumnIndex = 11;
    private static String trustAssociationEnabledColumnName = "TRUSTAENABLED";
    private static final int trustAssociationEnabledColumnIndex = 12;
    private static String ldapSSLEnabledColumnName = "ldapSSLEnabled";
    private static final int ldapSSLEnabledColumnIndex = 13;
    private static final int numColumns = 14;
    private static final int serverBeanKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
    private static final int loadStmtKey = serverBeanKeyBase + 1;
    private static final int updateStmtKey = serverBeanKeyBase + 2;
    private static final int deleteStmtKey = serverBeanKeyBase + 3;
    private static final int findAllStmtKey = serverBeanKeyBase + 4;
    private static final int restrictedFindAllStmtKey = serverBeanKeyBase + 5;
    private static final int insertStmtKey = serverBeanKeyBase + 6;
    private static final String updateStmtSql = "update " + tableName + " set " + securityEnabledColumnName + " = ?, " + realmNameColumnName + " = ?, " + challengeTypeColumnName + " = ?, " + sslEnabledColumnName + " = ? , " + ssoEnabledColumnName + " = ? , " + authMechanismColumnName + " = ?, " + userRegistryColumnName + " = ?, " + uRFactoryClassColumnName + " = ?, " + pluginCacheTimeoutColumnName + " = ?, " + trustAssociationEnabledColumnName + " = ?, " + ldapSSLEnabledColumnName + " = ? " + " where " + "INSTANCE_ID" + " = ?";
    private static final String deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " =  ?";
    private static final String insertStmtSql = "insert into " + tableName + " values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$SecurityConfigBean;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$Node;

    public SecurityConfigBean() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"SecurityConfigBean");
        SecurityConfigBean.initializeTypeId();
        SecurityConfigBean.initializePersistentStore();
        Tr.exit((TraceComponent)tc, (String)"SecurityConfigBean");
    }

    public Long ejbCreate(SecurityConfigAttributes securityConfigAttributes, EJBObject eJBObject) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        try {
            this.ejbFind();
            throw new CreateException("Already exists");
        }
        catch (FinderException finderException) {
            Object var3_4 = null;
            if (this.typeId == null) {
                this.typeId = myTypeId;
            }
            this.id = this.create(this.typeId);
            this.initializeInstanceVariables();
            try {
                this.updateInstanceVariables(securityConfigAttributes);
            }
            catch (OpException opException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)((Object)opException));
                throw new CreateException(opException.getMessage());
            }
            Vector<Object> vector = new Vector<Object>(14);
            vector.addElement(Utils.getIdString((Long)this.id));
            vector.addElement(Utils.getIdString((Long)this.typeId));
            vector.addElement(new Integer(Utils.booleanToInt((boolean)this.securityEnabled)));
            vector.addElement(this.realmName);
            vector.addElement(this.challengeType);
            vector.addElement(new Integer(Utils.booleanToInt((boolean)this.sslEnabled)));
            vector.addElement(new Integer(Utils.booleanToInt((boolean)this.ssoEnabled)));
            vector.addElement(this.authMechanism);
            vector.addElement(this.userRegistry);
            vector.addElement(this.uRFactoryClass);
            vector.addElement(new Integer(this.pluginCacheTimeout));
            vector.addElement(new Integer(Utils.booleanToInt((boolean)this.trustAssociationEnabled)));
            vector.addElement(new Integer(Utils.booleanToInt((boolean)this.ldapSSLEnabled)));
            try {
                DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(Constants.nls.getString("security.ErrorCreatingSecCfg", "Error while creating Security Config bean"), sQLException);
                throw remoteException;
            }
            Tr.exit((TraceComponent)tc, (String)"ejbCreate");
            return this.id;
        }
    }

    public void ejbLoad() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbLoad");
        Long l = (Long)this.ec.getPrimaryKey();
        DBQueryResult dBQueryResult = null;
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (!resultSet.next()) {
                    throw new RemoteException(Constants.nls.getString("security.ErrorFindingSecCfg", "Error while finding Security Config bean"));
                }
                if (this.setId(resultSet, myTypeId)) {
                    super.ejbLoad();
                    this.securityEnabled = Utils.intToBoolean((int)resultSet.getInt(3));
                    this.realmName = resultSet.getString(4);
                    this.challengeType = resultSet.getString(5);
                    this.sslEnabled = Utils.intToBoolean((int)resultSet.getInt(6));
                    this.ssoEnabled = Utils.intToBoolean((int)resultSet.getInt(7));
                    this.authMechanism = resultSet.getString(8);
                    if (this.authMechanism == null) {
                        this.authMechanism = new String();
                    }
                    this.userRegistry = resultSet.getString(9);
                    if (this.userRegistry == null) {
                        this.userRegistry = new String();
                    }
                    this.uRFactoryClass = resultSet.getString(10);
                    if (this.uRFactoryClass == null) {
                        this.uRFactoryClass = new String();
                    }
                    this.pluginCacheTimeout = resultSet.getInt(11);
                    this.trustAssociationEnabled = Utils.intToBoolean((int)resultSet.getInt(12));
                    this.ldapSSLEnabled = Utils.intToBoolean((int)resultSet.getInt(13));
                    this.getBinaryAttributes();
                }
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)sQLException);
                throw new RemoteException(Constants.nls.getString("security.ErrorFindingSecCfg", "Error while finding Security Config bean"), sQLException);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        Tr.exit((TraceComponent)tc, (String)"ejbLoad");
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        if (this.narrowRef != null) {
            return;
        }
        super.ejbStore();
        if (this.dirty) {
            try {
                Vector<Object> vector = new Vector<Object>(14);
                vector.addElement(new Integer(Utils.booleanToInt((boolean)this.securityEnabled)));
                vector.addElement(this.realmName);
                vector.addElement(this.challengeType);
                vector.addElement(new Integer(Utils.booleanToInt((boolean)this.sslEnabled)));
                vector.addElement(new Integer(Utils.booleanToInt((boolean)this.ssoEnabled)));
                vector.addElement(this.authMechanism);
                vector.addElement(this.userRegistry);
                vector.addElement(this.uRFactoryClass);
                vector.addElement(new Integer(this.pluginCacheTimeout));
                vector.addElement(new Integer(Utils.booleanToInt((boolean)this.trustAssociationEnabled)));
                vector.addElement(new Integer(Utils.booleanToInt((boolean)this.ldapSSLEnabled)));
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)sQLException);
                throw new RemoteException(Constants.nls.getString("security.ErrorStoringSecCfg", "Error while storing Security Config bean"), sQLException);
            }
        }
        Tr.exit((TraceComponent)tc, (String)"ejbStore");
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        if (this.id == null) {
            this.ejbLoad();
        }
        if (this.narrowRef != null) {
            this.narrowRef.remove();
            return;
        }
        super.ejbRemove();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)this.id));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove", (Object)sQLException);
            throw new RemoteException(Constants.nls.getString("security.ErrorRemovingSecCfg", "Error while removing Security Config bean"), sQLException);
        }
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public void ejbPostCreate(ServerAttributes serverAttributes, EJBObject eJBObject) {
        Tr.entry((TraceComponent)tc, (String)"ejbPostCreate");
        Tr.exit((TraceComponent)tc, (String)"ejbPostCreate");
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException, FinderException {
        Enumeration enumeration;
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll");
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)bl, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
        }
        catch (SQLException sQLException) {
            Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)sQLException);
            throw new RemoteException(Constants.nls.getString("security.ErrorFindingAllSecCfgs", "Error while finding all Security Config beans"), sQLException);
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFindAll");
        return enumeration;
    }

    public Long ejbFind() throws RemoteException, FinderException {
        Tr.entry((TraceComponent)tc, (String)"ejbFind");
        Long l = null;
        if (singletonId != null) {
            l = singletonId;
        } else {
            Enumeration enumeration = this.ejbFindAll(false);
            if (enumeration.hasMoreElements()) {
                l = singletonId = (Long)enumeration.nextElement();
            } else {
                throw new ObjectNotFoundException();
            }
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFind");
        return l;
    }

    public ContainmentPath getActiveObjectContainmentPath() throws RemoteException, OpException {
        ContainmentPath containmentPath;
        Tr.entry((TraceComponent)tc, (String)"getActiveObjectContainmentPath");
        try {
            containmentPath = this.getNode().getActiveObjectContainmentPath();
            containmentPath.addElement(this.getActiveObjectName());
        }
        catch (FinderException finderException) {
            throw new RemoteOpException(Constants.nls.getString("security.finder.exception", "Error finding security related objects"), (Throwable)finderException);
        }
        Tr.exit((TraceComponent)tc, (String)"getActiveObjectContainmentPath");
        return containmentPath;
    }

    public ContainmentPathElem getActiveObjectName() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getActiveObjectName");
        String string = "com.ibm.ejs.sm.active.ActiveSecurityConfig";
        ContainmentPathElem containmentPathElem = new ContainmentPathElem(this.id, string, this.getRelativeName(), this.getEpoch());
        Tr.exit((TraceComponent)tc, (String)"getActiveObjectName");
        return containmentPathElem;
    }

    private int getEpoch() {
        Tr.entry((TraceComponent)tc, (String)"getEpoch");
        Tr.exit((TraceComponent)tc, (String)"getEpoch");
        return 1;
    }

    private Node getNode() throws RemoteException, OpException, FinderException {
        Tr.entry((TraceComponent)tc, (String)"getNode");
        NodeHome nodeHome = (NodeHome)RepositoryObjectImpl.getHome("NodeHome");
        Node node = nodeHome.findByName(ManagedServer.getInstance().getNodeName(), true);
        Tr.exit((TraceComponent)tc, (String)"getNode");
        return node;
    }

    private String getRelativeName() {
        Tr.entry((TraceComponent)tc, (String)"getRelativeName");
        Tr.exit((TraceComponent)tc, (String)"getRelativeName");
        return "";
    }

    public ActiveObjectConfig getConfig() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getConfig");
        ActiveSecurityConfigConfig activeSecurityConfigConfig = new ActiveSecurityConfigConfig();
        activeSecurityConfigConfig.setName(this.getActiveObjectContainmentPath());
        activeSecurityConfigConfig.setSecurityEnabled(this.securityEnabled);
        activeSecurityConfigConfig.setRealmName(this.realmName);
        activeSecurityConfigConfig.setChallengeType(this.challengeType);
        activeSecurityConfigConfig.setChallengeTypeProperties(this.ctProperties);
        activeSecurityConfigConfig.setSSLEnabled(this.sslEnabled);
        activeSecurityConfigConfig.setSSOEnabled(this.ssoEnabled);
        activeSecurityConfigConfig.setAuthenticationMechanism(this.authMechanism);
        activeSecurityConfigConfig.setAuthenticationMechanismProperties(this.amProperties);
        activeSecurityConfigConfig.setUserRegistry(this.userRegistry);
        activeSecurityConfigConfig.setUserRegistryFactoryClass(this.uRFactoryClass);
        activeSecurityConfigConfig.setUserRegistryProperties(this.uRProperties);
        activeSecurityConfigConfig.setPluginCacheTimeout(this.pluginCacheTimeout);
        activeSecurityConfigConfig.setTrustAssociationEnabled(this.trustAssociationEnabled);
        activeSecurityConfigConfig.setSSLConfig(this.defaultSSLConfig);
        activeSecurityConfigConfig.setLdapSSLEnabled(this.ldapSSLEnabled);
        activeSecurityConfigConfig.setLdapSSLConfig(this.ldapSSLConfig);
        Tr.exit((TraceComponent)tc, (String)"getConfig");
        return activeSecurityConfigConfig;
    }

    public ActiveSecurityConfigConfig getActiveConfig() throws RemoteException, OpException {
        return (ActiveSecurityConfigConfig)this.getRuntimeAttr("Config");
    }

    public void updateActiveObjects() throws RemoteException {
        this.scheduleServerUpdate();
    }

    private void scheduleServerUpdate() {
        Tr.entry((TraceComponent)tc, (String)"scheduleServerUpdate");
        try {
            ActiveSecurityConfigConfig activeSecurityConfigConfig = (ActiveSecurityConfigConfig)this.getConfig();
            Vector vector = this.getNodeAgents();
            ActServerImpl actServerImpl = ActServerImpl.getInstance();
            Act act = actServerImpl.scheduleWork((AsyncTask)new UpdateTask(vector, activeSecurityConfigConfig));
        }
        catch (RemoteException remoteException) {
        }
        catch (OpException opException) {
        }
        catch (FinderException finderException) {
            // empty catch block
        }
        Tr.exit((TraceComponent)tc, (String)"scheduleServerUpdate");
    }

    private Vector getNodeAgents() throws RemoteException, OpException, FinderException {
        Tr.entry((TraceComponent)tc, (String)"getNodeAgents");
        Enumeration enumeration = this.getNodes();
        Vector<AdminAgent> vector = new Vector<AdminAgent>(5);
        while (enumeration.hasMoreElements()) {
            Node node = (Node)PortableRemoteObject.narrow(enumeration.nextElement(), (Class)(class$com$ibm$ejs$sm$beans$Node == null ? SecurityConfigBean.class$("com.ibm.ejs.sm.beans.Node") : class$com$ibm$ejs$sm$beans$Node));
            vector.addElement(node.getAdminAgent());
        }
        Tr.exit((TraceComponent)tc, (String)"getNodeAgents");
        return vector;
    }

    private Enumeration getNodes() throws RemoteException, OpException, FinderException {
        Tr.entry((TraceComponent)tc, (String)"getNodes");
        NodeHome nodeHome = (NodeHome)RepositoryObjectImpl.getHome("NodeHome");
        Enumeration enumeration = nodeHome.findAll(true);
        Tr.exit((TraceComponent)tc, (String)"getNodes");
        return enumeration;
    }

    private static void initializePersistentStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        Object object = classLock;
        synchronized (object) {
            if (tableCreated) {
                return;
            }
        }
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + "," + "TYPE_ID" + DBMgr.idColumnSpec + "," + securityEnabledColumnName + " INTEGER ," + realmNameColumnName + DBMgr.smallStringColumnSpec + "," + challengeTypeColumnName + DBMgr.smallStringColumnSpec + "," + sslEnabledColumnName + " INTEGER ," + ssoEnabledColumnName + " INTEGER ," + authMechanismColumnName + DBMgr.nullableSmallStringColumnSpec + "," + userRegistryColumnName + DBMgr.nullableSmallStringColumnSpec + "," + uRFactoryClassColumnName + DBMgr.nullableMediumStringColumnSpec + "," + pluginCacheTimeoutColumnName + " INTEGER ," + trustAssociationEnabledColumnName + " INTEGER ," + ldapSSLEnabledColumnName + " INTEGER ," + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Object object2 = classLock;
            synchronized (object2) {
                tableCreated = true;
            }
        }
        catch (SQLException sQLException) {
            Tr.exit((TraceComponent)tc, (String)"initializePersistentStore", (Object)sQLException);
            throw new RemoteException(Constants.nls.getString("security.ErrorCreatingDatabaseTable", "Error while creating database table"), sQLException);
        }
        Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
    }

    private static void initializeTypeId() throws RemoteException {
        SecurityConfigAttributes securityConfigAttributes;
        Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        Object object = classLock;
        synchronized (object) {
            if (myTypeId != null) {
                return;
            }
        }
        Object object2 = classLock;
        synchronized (object2) {
            securityConfigAttributes = defaults;
        }
        if (securityConfigAttributes == null) {
            securityConfigAttributes = new SecurityConfigAttributes();
            securityConfigAttributes.setName(SecurityConfigBean.getDefaultRealmName());
            securityConfigAttributes.setSecurityEnabled(true);
            securityConfigAttributes.setChallengeType(BASIC);
            securityConfigAttributes.setCTProperties(new Properties());
            securityConfigAttributes.setSSLEnabled(false);
            securityConfigAttributes.setAuthMechanism(LOCALOS);
            securityConfigAttributes.setAMProperties(new Properties());
            securityConfigAttributes.setSSOEnabled(false);
            securityConfigAttributes.setUserRegistry(LOCALOS);
            securityConfigAttributes.setURFactoryClass(defaultURFactory);
            securityConfigAttributes.setURProperties(new Properties());
            securityConfigAttributes.setPluginCacheTimeout(600);
            securityConfigAttributes.setTrustAssociationEnabled(false);
            securityConfigAttributes.setSSLConfig(new SecureSocketLayerConfig());
            securityConfigAttributes.setLdapSSLEnabled(false);
            securityConfigAttributes.setLdapSSLConfig(new SecureSocketLayerConfig());
        }
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, securityConfigAttributes, true);
        securityConfigAttributes = (SecurityConfigAttributes)RepositoryObjectImpl.getDefaults(type);
        Long l = (Long)type.getPrimaryKey();
        Object object3 = classLock;
        synchronized (object3) {
            myTypeObj = type;
            defaults = securityConfigAttributes;
            myTypeId = l;
        }
        Tr.exit((TraceComponent)tc, (String)"initializeTypeId");
    }

    public Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        if (this.narrowRef != null) {
            return ((SecurityConfig)this.narrowRef).getAttributes(attributes);
        }
        this.setVersion(attributes);
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return this.readInstanceVariables(attributes);
    }

    public void setAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setAttributes");
        if (this.narrowRef != null) {
            ((SecurityConfig)this.narrowRef).setAttributes(attributes);
            return;
        }
        this.checkAndIncrVersion(attributes);
        this.updateInstanceVariables((SecurityConfigAttributes)attributes);
        Tr.exit((TraceComponent)tc, (String)"setAttributes");
    }

    private void initializeInstanceVariables() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeInstanceVariables");
        try {
            this.securityEnabled = defaults.isSecurityEnabled();
            this.realmName = defaults.getName();
            this.challengeType = defaults.getChallengeType();
            this.ctProperties = defaults.getCTProperties();
            this.setBinaryAttr(ctPropsAttrName, this.ctProperties);
            this.sslEnabled = defaults.isSSLEnabled();
            this.authMechanism = defaults.getAuthMechanism();
            this.amProperties = defaults.getAMProperties();
            this.setBinaryAttr(amPropsAttrName, this.amProperties);
            this.ssoEnabled = defaults.isSSOEnabled();
            this.userRegistry = defaults.getUserRegistry();
            this.uRFactoryClass = defaults.getURFactoryClass();
            this.uRProperties = defaults.getURProperties();
            this.setBinaryAttr(uRPropsAttrName, this.uRProperties);
            this.pluginCacheTimeout = defaults.getPluginCacheTimeout();
            this.trustAssociationEnabled = defaults.isTrustAssociationEnabled();
            this.defaultSSLConfig = defaults.getSSLConfig();
            this.ldapSSLEnabled = defaults.isLdapSSLEnabled();
            this.ldapSSLConfig = defaults.getLdapSSLConfig();
            this.setBinaryAttr(defaultSSLAttrName, this.defaultSSLConfig);
            this.setBinaryAttr(ldapSSLAttrName, this.ldapSSLConfig);
        }
        catch (Exception exception) {
            Tr.warning((TraceComponent)tc, (String)"Default.attribute.not.set", (Object)exception);
            throw new RemoteException(Constants.nls.getString("security.ErrorInitializingInstanceVars", "Error while initializing instance variables"), exception);
        }
        Tr.exit((TraceComponent)tc, (String)"initializeInstanceVariables");
    }

    private void updateInstanceVariables(SecurityConfigAttributes securityConfigAttributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"updateInstanceVariables");
        try {
            this.dirty = true;
            boolean bl = false;
            boolean bl2 = false;
            if (securityConfigAttributes.isSet("SecurityEnabled")) {
                bl = this.securityEnabled = securityConfigAttributes.isSecurityEnabled();
            }
            if (securityConfigAttributes.isSet(Attributes.name)) {
                this.realmName = securityConfigAttributes.getName();
            }
            if (securityConfigAttributes.isSet("ChallengeType")) {
                this.challengeType = securityConfigAttributes.getChallengeType();
            }
            if (securityConfigAttributes.isSet("CTProperties")) {
                this.ctProperties = securityConfigAttributes.getCTProperties();
                this.setBinaryAttr(ctPropsAttrName, this.ctProperties);
            }
            if (securityConfigAttributes.isSet("SSLEnabled")) {
                this.sslEnabled = securityConfigAttributes.isSSLEnabled();
            }
            if (securityConfigAttributes.isSet("SSOEnabled")) {
                this.ssoEnabled = securityConfigAttributes.isSSOEnabled();
            }
            if (securityConfigAttributes.isSet("AuthMechanism")) {
                this.authMechanism = securityConfigAttributes.getAuthMechanism();
            }
            if (securityConfigAttributes.isSet("AMProperties")) {
                this.amProperties = securityConfigAttributes.getAMProperties();
                this.setBinaryAttr(amPropsAttrName, this.amProperties);
            }
            if (securityConfigAttributes.isSet("UserRegistry")) {
                bl = true;
                this.userRegistry = securityConfigAttributes.getUserRegistry();
            }
            if (securityConfigAttributes.isSet("URFactoryClass")) {
                bl = true;
                this.uRFactoryClass = securityConfigAttributes.getURFactoryClass();
            }
            if (securityConfigAttributes.isSet("URProperties")) {
                bl = true;
                bl2 = true;
                this.uRProperties = securityConfigAttributes.getURProperties();
            }
            if (securityConfigAttributes.isSet("PluginCacheTimeout")) {
                this.pluginCacheTimeout = securityConfigAttributes.getPluginCacheTimeout();
            }
            if (securityConfigAttributes.isSet("TrustAssociationEnabled")) {
                this.trustAssociationEnabled = securityConfigAttributes.isTrustAssociationEnabled();
            }
            if (securityConfigAttributes.isSet("DefaultSecureSocketLayer")) {
                this.defaultSSLConfig = securityConfigAttributes.getSSLConfig();
                this.setBinaryAttr(defaultSSLAttrName, this.defaultSSLConfig);
            }
            if (securityConfigAttributes.isSet("ldapSSLEnabled")) {
                this.ldapSSLEnabled = securityConfigAttributes.isLdapSSLEnabled();
            }
            if (securityConfigAttributes.isSet("LdapSecureSocketLayer")) {
                this.ldapSSLConfig = securityConfigAttributes.getLdapSSLConfig();
                this.setBinaryAttr(ldapSSLAttrName, this.ldapSSLConfig);
            }
            if (bl) {
                this.validateAttributes();
            }
            if (bl2) {
                if (this.userRegistry.equals(LOCALOS)) {
                    SASConfig sASConfig = SASConfig.getInstance();
                    sASConfig.setLoginData(LOCALOS, this.uRProperties);
                    ((Hashtable)this.uRProperties).remove(LOCALOS_ID);
                    ((Hashtable)this.uRProperties).remove(LOCALOS_PWD);
                }
                this.setBinaryAttr(uRPropsAttrName, this.uRProperties);
            }
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeDoesNotExistException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException(Constants.nls.getString("security.InvalidAttribute", "Invalid attribute"), (Throwable)attributeDoesNotExistException);
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeNotSetException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException(Constants.nls.getString("security.AttributeNotSet", "Missing attribute value"), (Throwable)attributeNotSetException);
        }
        catch (IOException iOException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)iOException);
            throw new RemoteException(Constants.nls.getString("security.ErrorSavingPropsFile", "Error while saving server security properties file"), iOException);
        }
        Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateAttributes() throws RemoteException, OpException {
        block11: {
            Tr.entry((TraceComponent)tc, (String)"validateAttributes");
            if (!this.securityEnabled) {
                return;
            }
            RegistryImplFactory registryImplFactory = null;
            RegistryImpl registryImpl = null;
            String string = null;
            Control control = null;
            try {
                try {
                    registryImplFactory = (RegistryImplFactory)Class.forName(this.uRFactoryClass).newInstance();
                    registryImpl = registryImplFactory.create(this.userRegistry, this.uRProperties);
                    string = this.uRProperties.getProperty(this.userRegistry + SERVER_ID_SUFFIX);
                    String string2 = this.uRProperties.getProperty(this.userRegistry + SERVER_PWD_SUFFIX);
                    if (System.getProperty(USING_CUSTOM_DATASOURCE) != null && System.getProperty(USING_CUSTOM_DATASOURCE).equalsIgnoreCase("true") && registryImpl instanceof CustomRegistryImpl) {
                        control = SecurityCollaborator.suspendTransaction();
                    }
                    registryImpl.authenticate(new BasicAuthData(string, string2));
                    if (control != null) {
                        SecurityCollaborator.resumeTransaction((Control)control);
                    }
                }
                catch (AuthenticationFailedException authenticationFailedException) {
                    if (control != null) {
                        SecurityCollaborator.resumeTransaction(control);
                    }
                    this.ec.setRollbackOnly();
                    throw new InvalidUserRegistryConfigException(Constants.nls.getFormattedMessage("security.authn.failed.foruser", (Object[])new String[]{string}, "Authentication failed"));
                }
                catch (Exception exception) {
                    if (control != null) {
                        SecurityCollaborator.resumeTransaction(control);
                    }
                    Tr.exit((TraceComponent)tc, (String)"validateAttributes", (Object)exception);
                    this.ec.setRollbackOnly();
                    throw new InvalidUserRegistryConfigException(exception.getMessage());
                }
                Object var8_7 = null;
                if (registryImplFactory == null || registryImpl == null) break block11;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (registryImplFactory != null && registryImpl != null) {
                    registryImplFactory.destroy(registryImpl, this.uRProperties);
                }
                throw throwable;
            }
            registryImplFactory.destroy(registryImpl, this.uRProperties);
        }
        Tr.exit((TraceComponent)tc, (String)"validateAttributes");
    }

    private SecurityConfigAttributes readInstanceVariables(Attributes attributes) throws RemoteException, OpException {
        SASConfig sASConfig;
        Tr.entry((TraceComponent)tc, (String)"readInstanceVariables");
        SecurityConfigAttributes securityConfigAttributes = (SecurityConfigAttributes)attributes;
        securityConfigAttributes.setName(this.realmName);
        securityConfigAttributes.setSecurityEnabled(this.securityEnabled);
        securityConfigAttributes.setChallengeType(this.challengeType);
        securityConfigAttributes.setCTProperties(this.ctProperties);
        securityConfigAttributes.setSSLEnabled(this.sslEnabled);
        securityConfigAttributes.setAuthMechanism(this.authMechanism);
        securityConfigAttributes.setAMProperties(this.amProperties);
        securityConfigAttributes.setSSOEnabled(this.ssoEnabled);
        securityConfigAttributes.setUserRegistry(this.userRegistry);
        securityConfigAttributes.setURFactoryClass(this.uRFactoryClass);
        securityConfigAttributes.setURProperties(this.uRProperties);
        if (this.userRegistry.equals(LOCALOS)) {
            sASConfig = SASConfig.getInstance();
            try {
                Properties properties = sASConfig.getLoginData(LOCALOS);
                ((Hashtable)this.uRProperties).put(LOCALOS_ID, properties.getProperty(LOCALOS_ID));
                ((Hashtable)this.uRProperties).put(LOCALOS_PWD, properties.getProperty(LOCALOS_PWD));
            }
            catch (NullPointerException nullPointerException) {
                ((Hashtable)this.uRProperties).remove(LOCALOS_ID);
                ((Hashtable)this.uRProperties).remove(LOCALOS_PWD);
            }
            catch (IOException iOException) {
                Tr.exit((TraceComponent)tc, (String)"readInstanceVariables", (Object)iOException);
                throw new RemoteOpException(Constants.nls.getString("security.ErrorReadingPropsFile", "Error reading server security properties file"), (Throwable)iOException);
            }
        }
        securityConfigAttributes.setPluginCacheTimeout(this.pluginCacheTimeout);
        securityConfigAttributes.setTrustAssociationEnabled(this.trustAssociationEnabled);
        securityConfigAttributes.setSSLConfig(this.defaultSSLConfig);
        securityConfigAttributes.setLdapSSLEnabled(this.ldapSSLEnabled);
        securityConfigAttributes.setLdapSSLConfig(this.ldapSSLConfig);
        sASConfig = (ActiveSecurityConfigConfig)this.getRuntimeAttr("Config");
        boolean bl = false;
        if (sASConfig != null) {
            bl = this.securityEnabled == sASConfig.isSecurityEnabled();
            bl |= this.authMechanism.equals(sASConfig.getAuthenticationMechanism());
            bl |= this.userRegistry.equals(sASConfig.getUserRegistry());
            Properties properties = sASConfig.getUserRegistryProperties();
            Enumeration<?> enumeration = this.uRProperties.propertyNames();
            while (bl && enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                bl &= this.uRProperties.getProperty(string).equals(properties.getProperty(string));
            }
            bl |= this.trustAssociationEnabled == sASConfig.isTrustAssociationEnabled();
            bl |= this.defaultSSLConfig.equals(sASConfig.getSSLConfig());
            bl |= this.ldapSSLEnabled == sASConfig.isLdapSSLEnabled();
            bl |= this.ldapSSLConfig.equals(sASConfig.getLdapSSLConfig());
        }
        securityConfigAttributes.setCurrentActive(bl);
        Tr.exit((TraceComponent)tc, (String)"readInstanceVariables");
        return securityConfigAttributes;
    }

    protected Object getRuntimeAttr(String string) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getRuntimeAttr");
        AdminAgent adminAgent = ManagedServer.getInstance().getAdminAgent();
        Object object = adminAgent.invokeActiveObject(this.getActiveObjectContainmentPath(), "get" + string, null);
        Tr.exit((TraceComponent)tc, (String)"getRuntimeAttr");
        return object;
    }

    private void getBinaryAttributes() throws RemoteException {
        this.ctProperties = (Properties)this.getBinaryAttr(ctPropsAttrName);
        this.amProperties = (Properties)this.getBinaryAttr(amPropsAttrName);
        this.uRProperties = (Properties)this.getBinaryAttr(uRPropsAttrName);
        this.defaultSSLConfig = (SecureSocketLayerConfig)this.getBinaryAttr(defaultSSLAttrName);
        this.ldapSSLConfig = (SecureSocketLayerConfig)this.getBinaryAttr(ldapSSLAttrName);
    }

    private static String getDefaultRealmName() {
        try {
            String string = null;
            try {
                string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        return InetAddress.getLocalHost().getHostName();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (UnknownHostException)privilegedActionException.getException();
            }
            int n = string.indexOf(46);
            if (n != -1) {
                return string.substring(n + 1);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return DEFAULTREALMNAME;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class UpdateTask
    implements AsyncTask {
        String updateMethod = "updateConfig";
        private Vector agents;
        private ContainmentPath activeObject;
        private ActiveSecurityConfigConfig activeConfig;

        UpdateTask(Vector vector, ActiveSecurityConfigConfig activeSecurityConfigConfig) {
            this.agents = vector;
            try {
                this.activeObject = SecurityConfigBean.this.getActiveObjectContainmentPath();
            }
            catch (OpException opException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.activeConfig = activeSecurityConfigConfig;
        }

        public String getName() {
            return "updateTask";
        }

        public void execute() throws RemoteException, OpException {
            Tr.entry((TraceComponent)tc, (String)"updateTask - execute");
            ParamList paramList = new ParamList(1);
            paramList.addElement((ActiveObjectConfig)this.activeConfig);
            int n = 0;
            int n2 = this.agents.size();
            while (n < n2) {
                AdminAgent adminAgent = (AdminAgent)this.agents.elementAt(n);
                adminAgent.invokeActiveObject(this.activeObject, this.updateMethod, paramList);
                ++n;
            }
            Tr.exit((TraceComponent)tc, (String)"updateTask - execute");
        }
    }
}

