/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.cm.portability.DuplicateKeyException;
import com.ibm.ejs.cm.portability.PortableConnection;
import com.ibm.ejs.cm.portability.PortableDataSource;
import com.ibm.ejs.cm.portability.TableAlreadyExistsException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.beans.DataSourceConfig;
import com.ibm.ejs.sm.beans.SeriousEventTable;
import com.ibm.websphere.advanced.cm.factory.CMFactoryException;
import com.ibm.websphere.advanced.cm.factory.DataSourceFactory;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class SeriousEventDataManager
implements SeriousEventTable {
    private static PortableDataSource readerDataSource = null;
    private static PortableDataSource loggerDataSource = null;
    private static boolean initialized = false;
    private static String dbSchema = null;
    private static int seriousEventLogSize = 0;
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$SeriousEventDataManager == null ? (class$com$ibm$ejs$sm$beans$SeriousEventDataManager = SeriousEventDataManager.class$("com.ibm.ejs.sm.beans.SeriousEventDataManager")) : class$com$ibm$ejs$sm$beans$SeriousEventDataManager));
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$SeriousEventDataManager;

    public static final void initializeReader(DataSourceConfig dataSourceConfig, String string, boolean bl) {
        SeriousEventDataManager.initializeReader(dataSourceConfig, string, bl, 0);
    }

    public static final void initializeReader(DataSourceConfig dataSourceConfig, String string, boolean bl, int n) {
        readerDataSource = (PortableDataSource)SeriousEventDataManager.getDataSource("Serious Event Reader", dataSourceConfig);
        SeriousEventDataManager.initialize(string, bl, n);
    }

    public static final void initializeLogger(DataSourceConfig dataSourceConfig, String string, boolean bl) {
        SeriousEventDataManager.initializeLogger(dataSourceConfig, string, bl, 0);
    }

    public static final void initializeLogger(DataSourceConfig dataSourceConfig, String string, boolean bl, int n) {
        loggerDataSource = (PortableDataSource)SeriousEventDataManager.getDataSource("Serious Event Logger", dataSourceConfig);
        SeriousEventDataManager.initialize(string, bl, n);
    }

    private static final synchronized void initialize(String string, boolean bl, int n) {
        PortableDataSource portableDataSource;
        if (initialized) {
            return;
        }
        dbSchema = string;
        PortableDataSource portableDataSource2 = portableDataSource = readerDataSource != null ? readerDataSource : loggerDataSource;
        if (bl) {
            SeriousEventDataManager.createTable(portableDataSource);
        }
        SeriousEventDataManager.initializeTable(portableDataSource, n);
        initialized = true;
    }

    public static final int getSeriousEventLogSize() {
        return seriousEventLogSize;
    }

    public static final DataSource getReaderDataSource() {
        return readerDataSource;
    }

    public static final DataSource getLoggerDataSource() {
        return loggerDataSource;
    }

    private static final void createTable(PortableDataSource portableDataSource) {
        Tr.entry((TraceComponent)tc, (String)"createTable");
        try {
            PortableConnection portableConnection = (PortableConnection)portableDataSource.getConnection();
            portableConnection.createTable(dbSchema, "SE_TABLE", SeriousEventTable.createTableSQL);
            portableConnection.close();
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            Tr.event((TraceComponent)tc, (String)"Table already exists");
        }
        catch (SQLException sQLException) {
            Tr.fatal((TraceComponent)tc, (String)"Could not initialize persistent storage for serious events. Got exception {0}", (Object)new Object[]{sQLException});
        }
        Tr.exit((TraceComponent)tc, (String)"createTable");
    }

    /*
     * Loose catch block
     */
    private static final void initializeTable(PortableDataSource portableDataSource, int n) {
        block25: {
            Exception exception2222;
            ResultSet resultSet;
            PortableConnection portableConnection;
            block22: {
                Tr.entry((TraceComponent)tc, (String)"initializeTable");
                portableConnection = null;
                resultSet = null;
                seriousEventLogSize = n;
                Tr.debug((TraceComponent)tc, (String)("seriousEventLogSize " + seriousEventLogSize));
                portableConnection = (PortableConnection)portableDataSource.getConnection();
                portableConnection.setAutoCommit(false);
                PreparedStatement preparedStatement = portableConnection.prepareStatement(SeriousEventTable.selectKnownRowSQL);
                preparedStatement.setInt(1, 0);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    PreparedStatement preparedStatement2 = portableConnection.prepareStatement(SeriousEventTable.insertStmtSQL);
                    preparedStatement2.setInt(1, 0);
                    preparedStatement2.setString(2, Integer.toString(0));
                    preparedStatement2.setString(3, Integer.toString(0));
                    preparedStatement2.setString(4, Integer.toString(n));
                    preparedStatement2.setString(5, "");
                    preparedStatement2.setBytes(6, new byte[0]);
                    preparedStatement2.setString(7, "");
                    preparedStatement2.setString(8, "");
                    preparedStatement2.executeUpdate();
                }
                portableConnection.commit();
                Object var8_8 = null;
                if (resultSet == null) break block22;
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {
                    Tr.event((TraceComponent)tc, (String)"Ignoring exception from result set close", (Object)exception2222);
                }
            }
            if (portableConnection != null) {
                try {
                    portableConnection.commit();
                    portableConnection.close();
                }
                catch (Exception exception2222) {
                    Tr.event((TraceComponent)tc, (String)"Failed to close database connection", (Object)exception2222);
                }
            }
            break block25;
            {
                catch (SQLException sQLException) {
                    Exception exception32222;
                    try {
                        if (portableConnection != null) {
                            throw portableConnection.translateException(sQLException);
                        }
                        throw sQLException;
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                    }
                    catch (SQLException sQLException2) {
                        Tr.fatal((TraceComponent)tc, (String)"Could not initialize persistent storage for serious events. Got exception {0}", (Object)new Object[]{sQLException});
                    }
                    Object var8_9 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception32222) {
                            Tr.event((TraceComponent)tc, (String)"Ignoring exception from result set close", (Object)exception32222);
                        }
                    }
                    if (portableConnection != null) {
                        try {
                            portableConnection.commit();
                            portableConnection.close();
                        }
                        catch (Exception exception32222) {
                            Tr.event((TraceComponent)tc, (String)"Failed to close database connection", (Object)exception32222);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var8_10 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        Tr.event((TraceComponent)tc, (String)"Ignoring exception from result set close", (Object)exception42222);
                    }
                }
                if (portableConnection != null) {
                    try {
                        portableConnection.commit();
                        portableConnection.close();
                    }
                    catch (Exception exception42222) {
                        Tr.event((TraceComponent)tc, (String)"Failed to close database connection", (Object)exception42222);
                    }
                }
                throw throwable;
            }
        }
        Tr.exit((TraceComponent)tc, (String)"initializeTable");
    }

    private static DataSource getDataSource(String string, DataSourceConfig dataSourceConfig) {
        DataSource dataSource;
        Properties properties = dataSourceConfig.asProperties();
        properties.setProperty("name", string);
        try {
            dataSource = DataSourceFactory.getDataSource((Properties)properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.error((TraceComponent)tc, (String)"Unable to get datasource for SeriousEventManager.", (Object)classNotFoundException);
            dataSource = null;
        }
        catch (CMFactoryException cMFactoryException) {
            Tr.error((TraceComponent)tc, (String)"Unable to get datasource for SeriousEventManager.", (Object)((Object)cMFactoryException));
            dataSource = null;
        }
        return dataSource;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

