/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.active.ActiveObjectConfig;
import com.ibm.ejs.sm.active.ActiveServerConfig;
import com.ibm.ejs.sm.agent.AdminAgent;
import com.ibm.ejs.sm.agent.ContainmentPathElem;
import com.ibm.ejs.sm.agent.ParamList;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.LiveRepositoryObjectImpl;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.NodeBean;
import com.ibm.ejs.sm.beans.Relation;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.RepositoryObjectName;
import com.ibm.ejs.sm.beans.Server;
import com.ibm.ejs.sm.beans.ServerAttributes;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.InvalidServerNameException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.ReconnectFailureException;
import com.ibm.ejs.sm.exception.RelationOpException;
import com.ibm.ejs.sm.exception.RequiredAttributeMissingException;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.act.Act;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;

public class ServerBean
extends LiveRepositoryObjectImpl
implements EntityBean {
    protected static NLS nls = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$ServerBean == null ? (class$com$ibm$ejs$sm$beans$ServerBean = ServerBean.class$("com.ibm.ejs.sm.beans.ServerBean")) : class$com$ibm$ejs$sm$beans$ServerBean));
    private static Integer classLock = new Integer(0);
    private static final String tableName = DBMgr.qualifiedTableName((String)"SERVER_TABLE");
    private static final String executableColumnName = "EXECUTABLE";
    private static final int executableColumnIndex = 3;
    private static final String userIdColumnName = "USER_ID";
    private static final int userIdColumnIndex = 4;
    private static final String groupIdColumnName = "GROUP_ID";
    private static final int groupIdColumnIndex = 5;
    private static final String workingDirColumnName = "WORKING_DIR";
    private static final int workingDirColumnIndex = 6;
    private static final String umaskColumnName = "UMASK";
    private static final int umaskColumnIndex = 7;
    private static final String stdinColumnName = "STDIN";
    private static final int stdinColumnIndex = 8;
    private static final String stdoutColumnName = "STDOUT";
    private static final int stdoutColumnIndex = 9;
    private static final String stderrColumnName = "STDERR";
    private static final int stderrColumnIndex = 10;
    private static final String maxStartupAttemptsColumnName = "MAX_START_TRIES";
    private static final int maxStartupAttemptsColumnIndex = 11;
    private static final String processPriorityColumnName = "PROC_PRIORITY";
    private static final int processPriorityColumnIndex = 12;
    private static final String pingIntervalColumnName = "PING_INTERVAL";
    private static final int pingIntervalColumnIndex = 13;
    private static final String pingTimeoutColumnName = "PING_TIMEOUT";
    private static final int pingTimeoutColumnIndex = 14;
    private static final String pingInitialTimeoutColumnName = "PING_INIT_TIMEOUT";
    private static final int pingInitialTimeoutColumnIndex = 15;
    private static final String serverInstanceColumnName = "SERVER_INSTANCE";
    private static final int serverInstanceColumnIndex = 16;
    private static final String selectionPolicyColumnName = "SELECTION_POLICY";
    private static final int selectionPolicyColumnIndex = 17;
    private static final int numColumns = 17;
    protected static final String myInterfaceName = RepositoryObjectImpl.qualifyClassName("Server");
    private static final String myClassName = RepositoryObjectImpl.qualifyClassName("ServerBean");
    private static final String myHomeName = "ServerHome";
    private static boolean tableCreated = false;
    private static Type myTypeObj = null;
    private static Long myTypeId = null;
    private static final String cmdlineArgsAttrName = myInterfaceName + ".cmdlineArgs";
    private static final String environmentAttrName = myInterfaceName + ".environment";
    private static final String recordedConfigAttrName = myInterfaceName + ".recordedConfig";
    private static final String startOnNodeRestartAttrName = myInterfaceName + ".startOnNodeRestart";
    private static final String defaultUserId = "";
    private static final String defaultGroupId = "";
    private static final String defaultWorkingDir = "";
    private static final int defaultUmask = 18;
    private static final String defaultStdin = "";
    private static final String defaultStdout = "stdout.txt";
    private static final String defaultStderr = "stderr.txt";
    private static final int defaultMaxStartupAttempts = 2;
    private static final int defaultProcessPriority = 20;
    private static final int defaultPingInterval = 60;
    private static final int defaultPingTimeout = 200;
    private static final int defaultPingInitialTimeout = 600;
    private static final String[] defaultCmdlineArgs = new String[0];
    private static final String[] defaultEnvironment = new String[0];
    private static final long defaultServerInstance = 0L;
    private static final String defaultSelectionPolicy = "roundrobin";
    private static Relation nodeServerRel;
    private static final int serverBeanKeyBase;
    private static final int loadStmtKey;
    private static final int updateStmtKey;
    private static final int deleteStmtKey;
    private static final int findAllStmtKey;
    private static final int restrictedFindAllStmtKey;
    private static final int insertStmtKey;
    private static final String updateStmtSql;
    private static final String deleteStmtSql;
    private static final String insertStmtSql;
    private static final String activeObjectClassName = "ActiveServerProcess";
    private String executable;
    private String userId;
    private String groupId;
    private String workingDir;
    private int umask;
    private String stdin;
    private String stdout;
    private String stderr;
    private int maxStartupAttempts;
    private int processPriority;
    private int pingInterval;
    private int pingTimeout;
    private int pingInitialTimeout;
    private String[] cmdlineArgs;
    private String[] environment;
    private ActiveServerConfig recordedConfig;
    private boolean dirty;
    protected long serverInstance;
    private String selectionPolicy;
    private boolean startOnNodeRestart;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$ServerBean;

    public synchronized Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        if (this.narrowRef != null) {
            return ((Server)this.narrowRef).getAttributes(attributes);
        }
        this.setVersion(attributes);
        return this.readInstanceVariables(attributes);
    }

    public synchronized void setAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setAttributes");
        if (this.narrowRef != null) {
            ((Server)this.narrowRef).setAttributes(attributes);
            return;
        }
        this.checkAndIncrVersion(attributes);
        this.renameIfNec(attributes, ServerBean.lookupNodeServerRel());
        this.updateInstanceVariables((ServerAttributes)attributes);
        Tr.exit((TraceComponent)tc, (String)"setAttributes");
    }

    public RepositoryObjectName getFullName() throws RemoteException, OpException {
        return this.constructFullName(myHomeName, this.getRelativeName());
    }

    public ContainmentPathElem getActiveObjectName() throws RemoteException, OpException {
        ContainmentPathElem containmentPathElem = new ContainmentPathElem(this.id, activeObjectClassName, this.getRelativeName(), this.getEpoch());
        return containmentPathElem;
    }

    public ActiveObjectConfig getConfig() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getConfig");
        ActiveServerConfig activeServerConfig = new ActiveServerConfig();
        this.initializeConfig(activeServerConfig);
        Tr.entry((TraceComponent)tc, (String)"getConfig");
        return activeServerConfig;
    }

    public synchronized void startCompleted(ActiveServerConfig activeServerConfig) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"startCompleted");
        this.recordedConfig = activeServerConfig;
        this.setBinaryAttr(recordedConfigAttrName, this.recordedConfig);
        Tr.event((TraceComponent)tc, (String)"recordedPid: ", (Object)this.recordedConfig.getRecordedPid());
        Tr.event((TraceComponent)tc, (String)"serverInstance: ", (Object)new Long(this.serverInstance));
        this.dirty = true;
        Tr.exit((TraceComponent)tc, (String)"startCompleted");
    }

    public Act reconnect(boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"reconnect");
        if (this.recordedConfig.getRecordedPid() == null || this.recordedConfig.getRecordedPid().equals("")) {
            Tr.warning((TraceComponent)tc, (String)nls.getFormattedMessage("serv.connect1.warning", new Object[]{this.getRelativeName()}, "Failed to reconnect to a server: {0}. No PID available"));
            Tr.exit((TraceComponent)tc, (String)"reconnect failure -- recorded pid is 0");
            this.markStopped();
            throw new ReconnectFailureException();
        }
        AdminAgent adminAgent = this.getNode().getAdminAgent();
        ParamList paramList = new ParamList(3);
        paramList.addElement(this.getEpoch());
        paramList.addElement((ActiveObjectConfig)this.recordedConfig);
        paramList.addElement(bl);
        Tr.event((TraceComponent)tc, (String)"recordedPid: ", (Object)this.recordedConfig.getRecordedPid());
        try {
            adminAgent.invokeActiveObject(this.recordedConfig.getName(), "reconnect", paramList);
        }
        catch (Exception exception) {
            Tr.warning((TraceComponent)tc, (String)nls.getFormattedMessage("serv.connect2.warning", new Object[]{this.getRelativeName(), exception}, "Failed to reconnect to a server: {0} {1}"));
            this.markStopped();
            throw new ReconnectFailureException();
        }
        Tr.exit((TraceComponent)tc, (String)"reconnect");
        return null;
    }

    public void setStartOnNodeRestart(boolean bl) throws RemoteException, OpException {
        this.setBinaryAttr(startOnNodeRestartAttrName, new Boolean(bl));
    }

    public boolean getStartOnNodeRestart() throws RemoteException, OpException {
        return (Boolean)this.getBinaryAttr(startOnNodeRestartAttrName);
    }

    public ServerBean() throws RemoteException {
        ServerBean.initializeNLS("RepositoryStrings");
        ServerBean.initializePersistentStore();
        ServerBean.initializeTypeId();
    }

    protected static void initializeNLS(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeNLS");
        }
        if (nls == null) {
            nls = new NLS(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeNLS");
        }
    }

    public void ejbLoad() throws RemoteException {
        Long l = (Long)this.ec.getPrimaryKey();
        Tr.entry((TraceComponent)tc, (String)"ejbLoad");
        DBQueryResult dBQueryResult = null;
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (!resultSet.next()) {
                    RemoteException remoteException = new RemoteException(nls.getFormattedMessage("serv.db.select0.exception", new Object[]{l, tableName}, "ServerBean select failed to find server instance {0} in table {1}."), new ObjectNotFoundException());
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad - with no resultSet exception", (Object)remoteException);
                    throw remoteException;
                }
                if (this.setId(resultSet, myTypeId)) {
                    super.ejbLoad();
                    this.executable = resultSet.getString(3);
                    this.userId = resultSet.getString(4);
                    this.userId = this.userId == null ? new String() : this.userId.trim();
                    this.groupId = resultSet.getString(5);
                    this.groupId = this.groupId == null ? new String() : this.groupId.trim();
                    this.workingDir = resultSet.getString(6);
                    this.workingDir = this.workingDir == null ? new String() : this.workingDir.trim();
                    this.umask = resultSet.getInt(7);
                    this.stdin = resultSet.getString(8);
                    this.stdin = this.stdin == null ? new String() : this.stdin.trim();
                    this.stdout = resultSet.getString(9);
                    if (this.stdout == null) {
                        this.stdout = new String();
                    }
                    this.stderr = resultSet.getString(10);
                    if (this.stderr == null) {
                        this.stderr = new String();
                    }
                    this.maxStartupAttempts = resultSet.getInt(11);
                    this.processPriority = resultSet.getInt(12);
                    this.pingInterval = resultSet.getInt(13);
                    this.pingTimeout = resultSet.getInt(14);
                    this.pingInitialTimeout = resultSet.getInt(15);
                    this.serverInstance = new Long(resultSet.getString(16));
                    this.selectionPolicy = resultSet.getString(17);
                    if (this.selectionPolicy == null) {
                        this.selectionPolicy = new String();
                    }
                    this.getBinaryAttributes();
                }
                this.dirty = false;
                Tr.exit((TraceComponent)tc, (String)"ejbLoad");
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("serv.db.select1.exception", new Object[]{sQLException.getMessage()}, "ServerBean select failed due to {0}."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbLoad - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        if (this.narrowRef != null) {
            return;
        }
        super.ejbStore();
        if (this.dirty) {
            try {
                Vector<Object> vector = new Vector<Object>(20);
                vector.addElement(this.executable);
                vector.addElement(this.userId);
                vector.addElement(this.groupId);
                vector.addElement(this.workingDir);
                vector.addElement(new Integer(this.umask));
                vector.addElement(this.stdin);
                vector.addElement(this.stdout);
                vector.addElement(this.stderr);
                vector.addElement(new Integer(this.maxStartupAttempts));
                vector.addElement(new Integer(this.processPriority));
                vector.addElement(new Integer(this.pingInterval));
                vector.addElement(new Integer(this.pingTimeout));
                vector.addElement(new Integer(this.pingInitialTimeout));
                vector.addElement(Utils.getIdString((Long)new Long(this.serverInstance)));
                vector.addElement(this.selectionPolicy);
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("serv.db.update0.exception", new Object[]{sQLException.getMessage(), this.id}, "ServerBean update failed due to {0} for statement with id = {1} ."), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbStore - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
        }
        Tr.exit((TraceComponent)tc, (String)"ejbStore");
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        if (this.id == null) {
            this.ejbLoad();
        }
        if (this.narrowRef != null) {
            this.narrowRef.remove();
            return;
        }
        super.ejbRemove();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)this.id));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("serv.db.delete0.exception", new Object[]{sQLException.getMessage(), this.id}, "ServerBean delete failed due to {0} for id = {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbRemove - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
    }

    public Long ejbCreate(ServerAttributes serverAttributes, Node node) throws RemoteException, CreateException {
        String string;
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        try {
            string = serverAttributes.getName();
            serverAttributes.getExecutable();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"< ejbCreate -- required attributes missing", (Object)((Object)attributeNotSetException));
            throw new RequiredAttributeMissingException(attributeNotSetException.getMessage());
        }
        try {
            if (this.typeId == null) {
                this.typeId = myTypeId;
            }
            this.id = this.create(this.typeId);
            super.ejbCreate();
            Relation relation = ServerBean.lookupNodeServerRel();
            try {
                relation.addUsingKeys((Long)node.getPrimaryKey(), this.id, string);
            }
            catch (RelationOpException relationOpException) {
                this.ec.setRollbackOnly();
                InvalidServerNameException invalidServerNameException = new InvalidServerNameException();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)invalidServerNameException);
                throw invalidServerNameException;
            }
            catch (RemoteException remoteException) {
                Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)remoteException);
                throw remoteException;
            }
            this.initializeInstanceVariables();
            this.updateInstanceVariables(serverAttributes);
            Vector<Object> vector = new Vector<Object>(17);
            vector.addElement(Utils.getIdString((Long)this.id));
            vector.addElement(Utils.getIdString((Long)this.typeId));
            vector.addElement(this.executable);
            vector.addElement(this.userId);
            vector.addElement(this.groupId);
            vector.addElement(this.workingDir);
            vector.addElement(new Integer(this.umask));
            vector.addElement(this.stdin);
            vector.addElement(this.stdout);
            vector.addElement(this.stderr);
            vector.addElement(new Integer(this.maxStartupAttempts));
            vector.addElement(new Integer(this.processPriority));
            vector.addElement(new Integer(this.pingInterval));
            vector.addElement(new Integer(this.pingTimeout));
            vector.addElement(new Integer(this.pingInitialTimeout));
            vector.addElement(new Long(this.serverInstance).toString());
            vector.addElement(this.selectionPolicy);
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("serv.db.insert0.exception", new Object[]{sQLException.getMessage(), this.id, this.typeId}, "ServerBean insert failed due to {0} for statement with id = {1} typeId = {2}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbCreate - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("serv.db.insert1.exception", new Object[]{exception.getMessage()}, "ServerBean insert failed due to {0}."), exception);
            Tr.exit((TraceComponent)tc, (String)"ejbCreate - with java.lang.Exception", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate");
        return this.id;
    }

    public void ejbPostCreate(ServerAttributes serverAttributes, Node node) {
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException, FinderException {
        Enumeration enumeration;
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll");
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)bl, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("serv.db.select2.exception", new Object[]{sQLException.getMessage(), tableName}, "ServerBean findAll failed due to {0} on table {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbFindAll - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)enumeration);
        return enumeration;
    }

    protected void initializeConfig(ActiveServerConfig activeServerConfig) throws RemoteException, OpException {
        super.initializeConfig((ActiveObjectConfig)activeServerConfig);
        activeServerConfig.setExecutable(this.executable);
        activeServerConfig.setCommandLineArgs(this.cmdlineArgs);
        activeServerConfig.setEnvironment(this.environment);
        activeServerConfig.setUserId(this.userId);
        activeServerConfig.setGroupId(this.groupId);
        activeServerConfig.setWorkingDirectory(this.workingDir);
        activeServerConfig.setUmask(this.umask);
        activeServerConfig.setStdin(this.stdin);
        activeServerConfig.setStdout(this.stdout);
        activeServerConfig.setStderr(this.stderr);
        activeServerConfig.setMaxStartupAttempts(this.maxStartupAttempts);
        activeServerConfig.setProcessPriority(this.processPriority);
        activeServerConfig.setPingInterval(this.pingInterval);
        activeServerConfig.setPingTimeout(this.pingTimeout);
        activeServerConfig.setPingInitialTimeout(this.pingInitialTimeout);
        activeServerConfig.setRecordedPid("");
        activeServerConfig.setRecordedStartTime(0L);
        activeServerConfig.setModelName(this.getModelName());
    }

    protected void getRecordedConfig(ActiveServerConfig activeServerConfig) {
        activeServerConfig.setExecutable(this.recordedConfig.getExecutable());
        activeServerConfig.setCommandLineArgs(this.recordedConfig.getCommandLineArgs());
        activeServerConfig.setEnvironment(this.recordedConfig.getEnvironment());
        activeServerConfig.setUserId(this.recordedConfig.getUserId());
        activeServerConfig.setGroupId(this.recordedConfig.getGroupId());
        activeServerConfig.setWorkingDirectory(this.recordedConfig.getWorkingDirectory());
        activeServerConfig.setUmask(this.recordedConfig.getUmask());
        activeServerConfig.setStdin(this.recordedConfig.getStdin());
        activeServerConfig.setStdout(this.recordedConfig.getStdout());
        activeServerConfig.setStderr(this.recordedConfig.getStderr());
        activeServerConfig.setMaxStartupAttempts(this.recordedConfig.getMaxStartupAttempts());
        activeServerConfig.setProcessPriority(this.recordedConfig.getProcessPriority());
        activeServerConfig.setPingInterval(this.recordedConfig.getPingInterval());
        activeServerConfig.setPingTimeout(this.recordedConfig.getPingTimeout());
        activeServerConfig.setPingInitialTimeout(this.recordedConfig.getPingInitialTimeout());
        activeServerConfig.setRecordedPid(this.recordedConfig.getRecordedPid());
        activeServerConfig.setRecordedStartTime(this.recordedConfig.getRecordedStartTime());
        activeServerConfig.setModelName(this.recordedConfig.getModelName());
    }

    protected String getRelativeName() throws RemoteException {
        return super.getName(ServerBean.lookupNodeServerRel());
    }

    protected static void initializeDefaults(ServerAttributes serverAttributes) {
        serverAttributes.setUserId("");
        serverAttributes.setGroupId("");
        serverAttributes.setWorkingDirectory("");
        serverAttributes.setUmask(18);
        serverAttributes.setStdin("");
        serverAttributes.setStdout(defaultStdout);
        serverAttributes.setStderr(defaultStderr);
        serverAttributes.setMaxStartupAttempts(2);
        serverAttributes.setProcessPriority(20);
        serverAttributes.setPingInterval(60);
        serverAttributes.setPingTimeout(200);
        serverAttributes.setPingInitialTimeout(600);
        serverAttributes.setCommandLineArgs(defaultCmdlineArgs);
        serverAttributes.setEnvironment(defaultEnvironment);
        serverAttributes.setServerInstance(0L);
        serverAttributes.setSelectionPolicy(defaultSelectionPolicy);
    }

    private static void initializePersistentStore() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (tableCreated) {
                return;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + executableColumnName + DBMgr.mediumStringColumnSpec + " , " + userIdColumnName + DBMgr.nullableMediumMediumStringColumnSpec + " , " + groupIdColumnName + DBMgr.nullableMediumMediumStringColumnSpec + " , " + workingDirColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + umaskColumnName + " integer " + " , " + stdinColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + stdoutColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + stderrColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + maxStartupAttemptsColumnName + " integer " + " , " + processPriorityColumnName + " integer " + " , " + pingIntervalColumnName + " integer " + " , " + pingTimeoutColumnName + " integer " + " , " + pingInitialTimeoutColumnName + " integer " + " , " + serverInstanceColumnName + DBMgr.idColumnSpec + " , " + selectionPolicyColumnName + DBMgr.nullableSmallStringColumnSpec + " , " + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Integer n2 = classLock;
            synchronized (n2) {
                tableCreated = true;
            }
            Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("serv.db.create0.exception", new Object[]{tableName, sQLException.getMessage()}, "ServerBean could not create table {0} because of {1}."), sQLException);
            Tr.exit((TraceComponent)tc, (String)"initializePersistentStore - with java.sql.SQLException", (Object)remoteException);
            throw remoteException;
        }
    }

    private static void initializeTypeId() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        Integer n = classLock;
        synchronized (n) {
            if (myTypeId != null) {
                return;
            }
        }
        ServerAttributes serverAttributes = new ServerAttributes();
        ServerBean.initializeDefaults(serverAttributes);
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, serverAttributes, false);
        Long l = (Long)type.getPrimaryKey();
        Integer n2 = classLock;
        synchronized (n2) {
            myTypeObj = type;
            myTypeId = l;
        }
        Tr.exit((TraceComponent)tc, (String)"initializeTypeId");
    }

    protected static Relation lookupNodeServerRel() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (nodeServerRel != null) {
                Relation relation = nodeServerRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.lookupRel(NodeBean.myInterfaceName, myTypeObj, "nodeServerRel");
        Integer n2 = classLock;
        synchronized (n2) {
            nodeServerRel = relation;
        }
        return relation;
    }

    private void initializeInstanceVariables() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeInstanceVariables");
        ServerAttributes serverAttributes = (ServerAttributes)RepositoryObjectImpl.getDefaults(myTypeObj);
        try {
            this.userId = serverAttributes.getUserId();
            this.groupId = serverAttributes.getGroupId();
            this.workingDir = serverAttributes.getWorkingDirectory();
            this.umask = serverAttributes.getUmask();
            this.stdin = serverAttributes.getStdin();
            this.stdout = serverAttributes.getStdout();
            this.stderr = serverAttributes.getStderr();
            this.maxStartupAttempts = serverAttributes.getMaxStartupAttempts();
            this.processPriority = serverAttributes.getProcessPriority();
            this.pingInterval = serverAttributes.getPingInterval();
            this.pingTimeout = serverAttributes.getPingTimeout();
            this.pingInitialTimeout = serverAttributes.getPingInitialTimeout();
            this.cmdlineArgs = serverAttributes.getCommandLineArgs();
            this.setBinaryAttr(cmdlineArgsAttrName, this.cmdlineArgs);
            this.environment = serverAttributes.getEnvironment();
            this.setBinaryAttr(environmentAttrName, this.environment);
            this.recordedConfig = new ActiveServerConfig();
            this.serverInstance = serverAttributes.getServerInstance();
            this.selectionPolicy = serverAttributes.getSelectionPolicy();
            this.setBinaryAttr(recordedConfigAttrName, this.recordedConfig);
            this.startOnNodeRestart = false;
            this.setBinaryAttr(startOnNodeRestartAttrName, new Boolean(false));
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"initializeInstanceVariables", (Object)exception);
            throw new RemoteException(nls.getFormattedMessage("serv.init.exception", new Object[]{exception.getMessage()}, "ServerBean could not initialize because of {0}."), exception);
        }
        Tr.exit((TraceComponent)tc, (String)"initializeInstanceVariables");
    }

    private void updateInstanceVariables(ServerAttributes serverAttributes) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"updateInstanceVariables");
        this.dirty = true;
        try {
            if (serverAttributes.isSet("Executable")) {
                this.executable = serverAttributes.getExecutable();
            }
            if (serverAttributes.isSet("CommandLineArgs")) {
                this.cmdlineArgs = serverAttributes.getCommandLineArgs();
                this.setBinaryAttr(cmdlineArgsAttrName, this.cmdlineArgs);
            }
            if (serverAttributes.isSet("Environment")) {
                this.environment = serverAttributes.getEnvironment();
                this.setBinaryAttr(environmentAttrName, this.environment);
            }
            if (serverAttributes.isSet("UserId")) {
                this.userId = serverAttributes.getUserId();
            }
            if (serverAttributes.isSet("GroupId")) {
                this.groupId = serverAttributes.getGroupId();
            }
            if (serverAttributes.isSet("WorkingDirectory")) {
                this.workingDir = serverAttributes.getWorkingDirectory();
            }
            if (serverAttributes.isSet("Umask")) {
                this.umask = serverAttributes.getUmask();
            }
            if (serverAttributes.isSet("Stdin")) {
                this.stdin = serverAttributes.getStdin();
            }
            if (serverAttributes.isSet("Stdout")) {
                this.stdout = serverAttributes.getStdout();
            }
            if (serverAttributes.isSet("Stderr")) {
                this.stderr = serverAttributes.getStderr();
            }
            if (serverAttributes.isSet("ProcessPriority")) {
                this.processPriority = serverAttributes.getProcessPriority();
            }
            if (serverAttributes.isSet("MaxStartupAttempts")) {
                this.maxStartupAttempts = serverAttributes.getMaxStartupAttempts();
            }
            if (serverAttributes.isSet("PingInterval")) {
                this.pingInterval = serverAttributes.getPingInterval();
            }
            if (serverAttributes.isSet("PingTimeout")) {
                this.pingTimeout = serverAttributes.getPingTimeout();
            }
            if (serverAttributes.isSet("PingInitialTimeout")) {
                this.pingInitialTimeout = serverAttributes.getPingInitialTimeout();
            }
            if (serverAttributes.isSet("ServerInstance")) {
                this.serverInstance = serverAttributes.getServerInstance();
            }
            if (serverAttributes.isSet("SelectionPolicy")) {
                this.selectionPolicy = serverAttributes.getSelectionPolicy();
            }
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeDoesNotExistException));
            throw new RemoteException(nls.getString("serv.attribute0.exception", "Attribute does not exist."), attributeDoesNotExistException);
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeNotSetException));
            throw new RemoteException(nls.getString("serv.attribute1.exception", "Attribute is not set."), attributeNotSetException);
        }
        Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables");
    }

    private ServerAttributes readInstanceVariables(Attributes attributes) throws RemoteException, OpException {
        ServerAttributes serverAttributes = (ServerAttributes)attributes;
        serverAttributes = (ServerAttributes)super.getAttributes(serverAttributes);
        serverAttributes.setName(this.getRelativeName());
        if (serverAttributes.isRequested(Attributes.fullName)) {
            serverAttributes.setFullName(this.getFullName());
        }
        serverAttributes.setExecutable(this.executable);
        serverAttributes.setCommandLineArgs(this.cmdlineArgs);
        serverAttributes.setEnvironment(this.environment);
        serverAttributes.setUserId(this.userId);
        serverAttributes.setGroupId(this.groupId);
        serverAttributes.setWorkingDirectory(this.workingDir);
        serverAttributes.setUmask(this.umask);
        serverAttributes.setStdin(this.stdin);
        serverAttributes.setStdout(this.stdout);
        serverAttributes.setStderr(this.stderr);
        serverAttributes.setProcessPriority(this.processPriority);
        serverAttributes.setMaxStartupAttempts(this.maxStartupAttempts);
        serverAttributes.setPingInitialTimeout(this.pingInitialTimeout);
        serverAttributes.setPingInterval(this.pingInterval);
        serverAttributes.setPingTimeout(this.pingTimeout);
        serverAttributes.setServerId(this.id);
        serverAttributes.setServerInstance(this.serverInstance);
        serverAttributes.setSelectionPolicy(this.selectionPolicy);
        if (serverAttributes.activeAttributeRequested()) {
            this.getActiveAttributes(attributes);
        }
        if (serverAttributes.isRequested("ProcessId")) {
            try {
                serverAttributes.setGeneric("ProcessId", this.getRuntimeAttr("ProcessId"));
            }
            catch (Throwable throwable) {
                Tr.event((TraceComponent)tc, (String)"Exception when fetching process id: ", (Object)throwable);
                serverAttributes.setGeneric("ProcessId", "0");
            }
        }
        return serverAttributes;
    }

    private ServerAttributes getActiveAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getActiveAttributes");
        ServerAttributes serverAttributes = (ServerAttributes)attributes;
        ActiveServerConfig activeServerConfig = null;
        if (this.getDesiredState() == 3) {
            try {
                activeServerConfig = (ActiveServerConfig)this.getRuntimeAttr("Config");
            }
            catch (Throwable throwable) {
                Tr.event((TraceComponent)tc, (String)"Exception when fetching config: ", (Object)throwable);
                activeServerConfig = null;
            }
        }
        if (activeServerConfig == null) {
            activeServerConfig = (ActiveServerConfig)this.getConfig();
        }
        serverAttributes.setExecutableActive(activeServerConfig.getExecutable());
        serverAttributes.setCommandLineArgsActive(activeServerConfig.getCommandLineArgs());
        serverAttributes.setEnvironmentActive(activeServerConfig.getEnvironment());
        serverAttributes.setUserIdActive(activeServerConfig.getUserId());
        serverAttributes.setGroupIdActive(activeServerConfig.getGroupId());
        serverAttributes.setWorkingDirectoryActive(activeServerConfig.getWorkingDirectory());
        serverAttributes.setUmaskActive(activeServerConfig.getUmask());
        serverAttributes.setStdinActive(activeServerConfig.getStdin());
        serverAttributes.setStdoutActive(activeServerConfig.getStdout());
        serverAttributes.setStderrActive(activeServerConfig.getStderr());
        serverAttributes.setProcessPriorityActive(activeServerConfig.getProcessPriority());
        Tr.exit((TraceComponent)tc, (String)"getActiveAttributes");
        return serverAttributes;
    }

    private void getBinaryAttributes() throws RemoteException {
        this.cmdlineArgs = (String[])this.getBinaryAttr(cmdlineArgsAttrName);
        this.environment = (String[])this.getBinaryAttr(environmentAttrName);
        this.recordedConfig = (ActiveServerConfig)this.getBinaryAttr(recordedConfigAttrName);
        this.startOnNodeRestart = (Boolean)this.getBinaryAttr(startOnNodeRestartAttrName);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        serverBeanKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
        loadStmtKey = serverBeanKeyBase + 1;
        updateStmtKey = serverBeanKeyBase + 2;
        deleteStmtKey = serverBeanKeyBase + 3;
        findAllStmtKey = serverBeanKeyBase + 4;
        restrictedFindAllStmtKey = serverBeanKeyBase + 5;
        insertStmtKey = serverBeanKeyBase + 6;
        updateStmtSql = "update " + tableName + " set " + executableColumnName + " =  ? ," + userIdColumnName + " =  ? ," + groupIdColumnName + " =  ? ," + workingDirColumnName + " =  ? ," + umaskColumnName + " =  ? ," + stdinColumnName + " =  ? ," + stdoutColumnName + " =  ? ," + stderrColumnName + " =  ? ," + maxStartupAttemptsColumnName + " =  ? ," + processPriorityColumnName + " =  ? ," + pingIntervalColumnName + " =  ? ," + pingTimeoutColumnName + " =  ? ," + pingInitialTimeoutColumnName + " =  ? ," + serverInstanceColumnName + " =  ? ," + selectionPolicyColumnName + " =  ? " + " where " + "INSTANCE_ID" + " = ?";
        deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " =  ?";
        insertStmtSql = "insert into " + tableName + " values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    }
}

