/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.J2EEResourceConfig;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.Relation;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.RepositoryObjectName;
import com.ibm.ejs.sm.beans.ResourceBean;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.beans.URL;
import com.ibm.ejs.sm.beans.URLAttributes;
import com.ibm.ejs.sm.beans.URLConfig;
import com.ibm.ejs.sm.beans.URLProvider;
import com.ibm.ejs.sm.beans.URLProviderAttributes;
import com.ibm.ejs.sm.beans.URLProviderBean;
import com.ibm.ejs.sm.beans.URLProviderConfig;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.InvalidJDBCDriverException;
import com.ibm.ejs.sm.exception.InvalidNameChangeException;
import com.ibm.ejs.sm.exception.InvalidResourceNameException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.RelationOpException;
import com.ibm.ejs.sm.exception.RemoteOpException;
import com.ibm.ejs.sm.exception.RequiredAttributeMissingException;
import com.ibm.ejs.sm.util.ObjectCollection;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import com.ibm.ws.URL.URLReferenceable;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.Referenceable;

public class URLBean
extends ResourceBean
implements EntityBean {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$URLBean == null ? (class$com$ibm$ejs$sm$beans$URLBean = URLBean.class$("com.ibm.ejs.sm.beans.URLBean")) : class$com$ibm$ejs$sm$beans$URLBean));
    private static Integer classLock = new Integer(0);
    private static final String tableName = DBMgr.qualifiedTableName((String)"URL_TABLE");
    private static final String nameColumnName = "NAME";
    private static final int nameColumnIndex = 3;
    private static final String jndiNameColumnName = "JNDINAME";
    private static final int jndiNameColumnIndex = 4;
    private static final String descriptionColumnName = "DESCRIPTION";
    private static final int descriptionColumnIndex = 5;
    private static final String specColumnName = "SPEC";
    private static final int specColumnIndex = 6;
    private static final int numColumns = 6;
    protected static final String myInterfaceName = RepositoryObjectImpl.qualifyClassName("URL");
    private static final String myClassName = RepositoryObjectImpl.qualifyClassName("URLBean");
    private static boolean tableCreated = false;
    private static Type myTypeObj = null;
    private static Long myTypeId = null;
    private static final String myHomeName = "URLHome";
    private static final String JNDIPREFIX = "url/";
    private static Relation providerResourceRel;
    private static final int urlBeanKeyBase;
    private static final int loadStmtKey;
    private static final int updateStmtKey;
    private static final int deleteStmtKey;
    private static final int insertStmtKey;
    private static final int restrictedFindAllStmtKey;
    private static final int findAllStmtKey;
    private static final int restrictedFindByNameStmtKey;
    private static final int findByNameStmtKey;
    private static final int findByJNDINameStmtKey;
    private static final int restrictedFindByJNDINameStmtKey;
    private static final String updateStmtSql;
    private static final String deleteStmtSql;
    private static final String restrictedFindByNameStmtSql;
    private static final String findByNameStmtSql;
    private static final String insertStmtSql;
    private static final String restrictedFindByJNDINameStmtSql;
    private static final String findByJNDINameStmtSql;
    private String name;
    private String jndiName;
    private String prevJndiName;
    private String description;
    private String spec;
    private boolean dirty;
    private boolean duringCreate;
    private URLProvider provider;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$URLBean;

    public URLBean() throws RemoteException {
        URLBean.initializePersistentStore();
        URLBean.initializeTypeId();
    }

    public Long ejbCreate(URLAttributes uRLAttributes, URLProvider uRLProvider) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        try {
            uRLProvider.getFullName();
            this.provider = uRLProvider;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)" < ejbCreate -- invalid URL Provider", (Object)exception);
            throw new InvalidJDBCDriverException("Invalid URL Provider specified.");
        }
        try {
            this.name = uRLAttributes.getName();
            this.spec = uRLAttributes.getSpec();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)" < ejbCreate -- required attribute missing", (Object)((Object)attributeNotSetException));
            throw new RequiredAttributeMissingException(attributeNotSetException.getMessage());
        }
        try {
            this.validateStringAttr(this.name);
        }
        catch (RemoteException remoteException) {
            throw new RequiredAttributeMissingException("Name");
        }
        try {
            this.validateStringAttr(this.spec);
        }
        catch (RemoteException remoteException) {
            throw new RequiredAttributeMissingException("Spec");
        }
        try {
            this.validateName(this.name);
            if (this.typeId == null) {
                this.typeId = myTypeId;
            }
            this.id = this.create(this.typeId);
            this.addParentRel(this.name, this.provider);
            this.initializeInstanceVariables();
            try {
                this.updateInstanceVariables(uRLAttributes, true);
            }
            catch (InvalidNameChangeException invalidNameChangeException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate: -- invalid data source name", (Object)((Object)invalidNameChangeException));
                throw new InvalidResourceNameException();
            }
            catch (OpException opException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate: ", (Object)((Object)opException));
                throw new RemoteException("", opException);
            }
            Vector<String> vector = new Vector<String>(6);
            vector.addElement(Utils.getIdString((Long)this.id));
            vector.addElement(Utils.getIdString((Long)this.typeId));
            vector.addElement(this.name);
            vector.addElement(this.jndiName);
            vector.addElement(this.description);
            vector.addElement(this.spec);
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)this.id);
        return this.id;
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException, FinderException {
        Enumeration enumeration;
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll");
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)false, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbFileAll", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)((ObjectCollection)enumeration).getArray());
        return enumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByJNDIName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByJNDIName", (Object)string);
        DBQueryResult dBQueryResult = null;
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByJNDINameStmtKey, (String)findByJNDINameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByJNDINameStmtKey, (String)restrictedFindByJNDINameStmtSql, vector);
                }
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName");
                l = this.singleFinderEpilogue(dBQueryResult);
                Object var7_8 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("URLBean findByJNDIName failed", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByJNDIName - with java.sql.SQLException", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    protected Long findByName(String string) throws RemoteException, FinderException {
        return this.ejbFindByName(string, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        DBQueryResult dBQueryResult = null;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByName", (Object)string);
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByNameStmtKey, (String)findByNameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByNameStmtKey, (String)restrictedFindByNameStmtSql, vector);
                }
                Long l2 = this.singleFinderEpilogue(dBQueryResult);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName");
                l = l2;
                Object var8_9 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    public void ejbLoad() throws RemoteException {
        DBQueryResult dBQueryResult = null;
        Long l = (Long)this.ec.getPrimaryKey();
        Tr.entry((TraceComponent)tc, (String)"ejbLoad", (Object)l);
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (resultSet == null || !resultSet.next()) {
                    RemoteException remoteException = new RemoteException("", new ObjectNotFoundException());
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                    throw remoteException;
                }
                if (this.setId(resultSet, myTypeId)) {
                    super.ejbLoad();
                    this.name = resultSet.getString(3);
                    this.jndiName = resultSet.getString(4);
                    if (this.jndiName == null) {
                        this.jndiName = new String();
                    }
                    this.prevJndiName = null;
                    this.description = resultSet.getString(5);
                    if (this.description == null) {
                        this.description = new String();
                    }
                    this.spec = resultSet.getString(6);
                }
                this.duringCreate = false;
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                throw remoteException;
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        try {
            this.provider = (URLProvider)this.getContainingObject();
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException("URL resource update failed due to {0}.", exception);
            Tr.exit((TraceComponent)tc, (String)"ejbLoad - with Exception", (Object)remoteException);
            throw remoteException;
        }
    }

    public void ejbPostCreate(URLAttributes uRLAttributes, URLProvider uRLProvider) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbPostCreate");
        try {
            if (!this.ec.getRollbackOnly()) {
                this.insertIntoNameSpace(this.getJNDIName(), (Referenceable)this.getBindingObject());
            }
        }
        catch (Exception exception) {
            this.ec.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"ejbPostCreate:", (Object)exception);
            throw new RemoteException("", exception);
        }
        Tr.exit((TraceComponent)tc, (String)"ejbPostCreate");
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        if (this.id == null) {
            this.ejbLoad();
        }
        if (this.narrowRef != null) {
            this.narrowRef.remove();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove");
            return;
        }
        super.ejbRemove();
        Long l = (Long)this.ec.getPrimaryKey();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)l));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
            this.deleteFromNameSpace(this.getJNDIName());
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbRemove", (Object)remoteException);
            throw remoteException;
        }
        catch (RemoteException remoteException) {
            this.ec.setRollbackOnly();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove - with RemoteException", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        super.ejbStore();
        if (this.dirty) {
            try {
                Vector<String> vector = new Vector<String>(6);
                vector.addElement(this.name);
                vector.addElement(this.jndiName);
                vector.addElement(this.description);
                vector.addElement(this.spec);
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                throw remoteException;
            }
            if (!this.duringCreate) {
                if (this.prevJndiName != null && !this.prevJndiName.equals("")) {
                    try {
                        this.renameInNameSpace(this.prevJndiName, this.getJNDIName(), (Referenceable)this.getBindingObject());
                        this.prevJndiName = null;
                    }
                    catch (Exception exception) {
                        this.ec.setRollbackOnly();
                        RemoteException remoteException = new RemoteException("", exception);
                        Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                        throw remoteException;
                    }
                }
                try {
                    this.updateInNameSpace(this.getJNDIName(), (Referenceable)this.getBindingObject());
                }
                catch (Exception exception) {
                    this.ec.setRollbackOnly();
                    RemoteException remoteException = new RemoteException("", exception);
                    Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                    throw remoteException;
                }
            }
        }
        Tr.exit((TraceComponent)tc, (String)"ejbStore");
    }

    public Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        Attributes attributes2 = null;
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        if (this.narrowRef != null) {
            attributes2 = ((URL)this.narrowRef).getAttributes(attributes);
        } else {
            this.setVersion(attributes);
            attributes2 = this.readInstanceVariables(attributes);
        }
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return attributes2;
    }

    private Object getBindingObject() {
        Tr.entry((TraceComponent)tc, (String)"getBindingObject");
        Properties properties = new Properties();
        ((Hashtable)properties).put("spec", this.spec);
        URLReferenceable uRLReferenceable = new URLReferenceable(properties);
        Tr.exit((TraceComponent)tc, (String)"getBindingObject");
        return uRLReferenceable;
    }

    public RepositoryObjectName getFullName() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getFullName");
        RepositoryObjectName repositoryObjectName = this.constructFullName(myHomeName, this.name);
        Tr.exit((TraceComponent)tc, (String)"getFullName");
        return repositoryObjectName;
    }

    public String getJNDIName() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"getJNDIName");
        if (this.jndiName.trim().equals("")) {
            this.jndiName = this.name.startsWith(JNDIPREFIX) ? this.name : JNDIPREFIX + this.name;
        }
        Tr.exit((TraceComponent)tc, (String)"getJNDIName");
        return this.jndiName;
    }

    public J2EEResourceConfig getResourceConfig(Node node) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getResourceConfig(node)");
        J2EEResourceConfig j2EEResourceConfig = this.getResourceConfig();
        URLProviderConfig uRLProviderConfig = (URLProviderConfig)j2EEResourceConfig.getProvider();
        uRLProviderConfig.setClasspath(this.provider.getJarFile(node));
        Tr.exit((TraceComponent)tc, (String)"getResourceConfig(node)");
        return j2EEResourceConfig;
    }

    public J2EEResourceConfig getResourceConfig() throws RemoteException, OpException {
        String string;
        String string2;
        String string3;
        Tr.entry((TraceComponent)tc, (String)"getResourceConfig");
        Long l = (Long)this.provider.getPrimaryKey();
        URLProviderAttributes uRLProviderAttributes = new URLProviderAttributes();
        uRLProviderAttributes.requestAll();
        uRLProviderAttributes = (URLProviderAttributes)this.provider.getAttributes(uRLProviderAttributes);
        try {
            string3 = uRLProviderAttributes.getName();
            string2 = uRLProviderAttributes.getProtocol();
            string = uRLProviderAttributes.getStreamHandlerClassName();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            throw new OpException("getResourceConfig: AttributeNotSetException: " + attributeNotSetException.getMessage());
        }
        URLConfig uRLConfig = new URLConfig();
        URLProviderConfig uRLProviderConfig = new URLProviderConfig();
        uRLConfig.setProvider(uRLProviderConfig);
        uRLConfig.setName(this.name);
        uRLConfig.setJNDIName(this.getJNDIName());
        uRLConfig.setJtaEnabled(false);
        uRLConfig.setDescription(this.description);
        uRLConfig.setSpec(this.spec);
        uRLProviderConfig.setName(string3);
        uRLProviderConfig.setProviderId(l);
        uRLProviderConfig.setProtocol(string2);
        uRLProviderConfig.setStreamHandlerClassName(string);
        Tr.exit((TraceComponent)tc, (String)"getResourceConfig");
        return uRLConfig;
    }

    private void initializeInstanceVariables() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeInstanceVariables");
        URLAttributes uRLAttributes = (URLAttributes)RepositoryObjectImpl.getDefaults(myTypeObj);
        try {
            this.jndiName = new String();
            this.prevJndiName = null;
            this.description = new String();
            this.spec = new String();
            this.duringCreate = true;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"intializedInstanceVariables", (Object)exception);
            throw new RemoteException("", exception);
        }
        Tr.exit((TraceComponent)tc, (String)"intializedInstanceVariables");
    }

    private static void initializePersistentStore() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (tableCreated) {
                return;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + nameColumnName + DBMgr.mediumStringColumnSpec + " , " + jndiNameColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + descriptionColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + specColumnName + DBMgr.mediumStringColumnSpec + " , " + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Integer n2 = classLock;
            synchronized (n2) {
                tableCreated = true;
            }
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"intializePersistentStore");
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
    }

    private static void initializeTypeId() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        Integer n = classLock;
        synchronized (n) {
            if (myTypeId != null) {
                Tr.exit((TraceComponent)tc, (String)"initializeTypeId");
                return;
            }
        }
        URLAttributes uRLAttributes = new URLAttributes();
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, uRLAttributes, false);
        Long l = (Long)type.getPrimaryKey();
        Integer n2 = classLock;
        synchronized (n2) {
            myTypeObj = type;
            myTypeId = l;
        }
        Tr.exit((TraceComponent)tc, (String)"intializeTypeId");
    }

    private URLAttributes readInstanceVariables(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"readInstanceVariables");
        URLAttributes uRLAttributes = (URLAttributes)attributes;
        uRLAttributes.setName(this.name);
        uRLAttributes.setJNDIName(this.jndiName);
        uRLAttributes.setFullName(this.getFullName());
        uRLAttributes.setDescription(this.description);
        uRLAttributes.setSpec(this.spec);
        try {
            URLProvider uRLProvider = (URLProvider)this.getContainingObject();
            uRLAttributes.setProvider(uRLProvider);
            URLProviderAttributes uRLProviderAttributes = new URLProviderAttributes();
            uRLProviderAttributes.request(Attributes.name);
            uRLAttributes.setParentName(uRLProvider.getAttributes(uRLProviderAttributes).getName());
        }
        catch (Exception exception) {
            throw new RemoteOpException(ResourceBean.nls.getString("provider.urlb.exception", "Fail to request URLProvider name"));
        }
        Tr.exit((TraceComponent)tc, (String)"readInstanceVariables");
        return uRLAttributes;
    }

    public void setAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setAttributes");
        if (this.narrowRef != null) {
            ((URL)this.narrowRef).setAttributes(attributes);
        } else {
            String string;
            try {
                if (attributes.isSet(Attributes.name)) {
                    string = ((URLAttributes)attributes).getName();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(ResourceBean.nls.getFormattedMessage("invalid.attribute.name", new Object[]{"Name"}, "Invalid value for attribute: {0}"));
            }
            try {
                if (attributes.isSet(URLAttributes.spec)) {
                    string = ((URLAttributes)attributes).getSpec();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(ResourceBean.nls.getFormattedMessage("invalid.attribute.name", new Object[]{"Spec"}, "Invalid value for attribute: {0}"));
            }
            this.checkAndIncrVersion(attributes);
            this.renameIfNec(attributes, URLBean.lookupProviderResourceRel(), true);
            this.updateInstanceVariables((URLAttributes)attributes, false);
        }
        Tr.exit((TraceComponent)tc, (String)"setAttributes");
    }

    private void updateInstanceVariables(URLAttributes uRLAttributes, boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"updateInstanceVariables");
        this.dirty = true;
        try {
            if (uRLAttributes.isSet(Attributes.name)) {
                this.name = uRLAttributes.getName();
            }
            if (uRLAttributes.isSet(URLAttributes.jndiName)) {
                String string = uRLAttributes.getJNDIName();
                if (!(string = string.trim()).equals("") && !string.equals(this.jndiName)) {
                    this.checkForDuplicateJNDIName(string);
                    if (!bl) {
                        this.prevJndiName = this.jndiName;
                        this.updateModuleBindings(this.prevJndiName, string);
                    }
                    this.jndiName = string;
                }
            }
            if (uRLAttributes.isSet(URLAttributes.description)) {
                this.description = uRLAttributes.getDescription();
            }
            if (uRLAttributes.isSet(URLAttributes.spec)) {
                this.spec = uRLAttributes.getSpec();
            }
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeNotSetException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)attributeNotSetException);
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeDoesNotExistException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)attributeDoesNotExistException);
        }
        Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables");
    }

    private void addParentRel(String string, URLProvider uRLProvider) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"addParentRel");
        URLBean.lookupProviderResourceRel();
        try {
            providerResourceRel.addUsingKeys((Long)uRLProvider.getPrimaryKey(), this.id, string);
        }
        catch (RelationOpException relationOpException) {
            this.ec.setRollbackOnly();
            InvalidResourceNameException invalidResourceNameException = new InvalidResourceNameException();
            Tr.exit((TraceComponent)tc, (String)"addParentRel", (Object)invalidResourceNameException);
            throw invalidResourceNameException;
        }
        catch (RemoteException remoteException) {
            Tr.exit((TraceComponent)tc, (String)"addParentRel", (Object)remoteException);
            throw remoteException;
        }
    }

    protected static Relation lookupProviderResourceRel() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (providerResourceRel != null) {
                Relation relation = providerResourceRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.lookupRel(URLProviderBean.myInterfaceName, myTypeObj, "urlProviderUrlRel");
        Integer n2 = classLock;
        synchronized (n2) {
            providerResourceRel = relation;
        }
        return providerResourceRel;
    }

    private void validateStringAttr(String string) throws RemoteException {
        if (string.trim().equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"validateStringAttr failed.");
            }
            throw new RemoteException("validateStringAttr failed.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        urlBeanKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
        loadStmtKey = urlBeanKeyBase + 1;
        updateStmtKey = urlBeanKeyBase + 2;
        deleteStmtKey = urlBeanKeyBase + 3;
        insertStmtKey = urlBeanKeyBase + 4;
        restrictedFindAllStmtKey = urlBeanKeyBase + 5;
        findAllStmtKey = urlBeanKeyBase + 6;
        restrictedFindByNameStmtKey = urlBeanKeyBase + 7;
        findByNameStmtKey = urlBeanKeyBase + 8;
        findByJNDINameStmtKey = urlBeanKeyBase + 9;
        restrictedFindByJNDINameStmtKey = urlBeanKeyBase + 10;
        updateStmtSql = "update " + tableName + " set " + nameColumnName + " = ? , " + jndiNameColumnName + " = ? , " + descriptionColumnName + " = ? , " + specColumnName + " = ? " + " where " + "INSTANCE_ID" + " = ?";
        deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " = ?";
        restrictedFindByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " = ? and " + "TYPE_ID" + " = ? ";
        findByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " =  ?";
        insertStmtSql = "insert into " + tableName + " values (?,?,?,?,?,?)";
        restrictedFindByJNDINameStmtSql = "select * from " + tableName + " where " + jndiNameColumnName + " = ? and " + "TYPE_ID" + " = ? ";
        findByJNDINameStmtSql = "select * from " + tableName + " where " + jndiNameColumnName + " =  ?";
    }
}

