/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.agent.AdminAgent;
import com.ibm.ejs.sm.agent.ParamList;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.J2EEResourceProviderConfig;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.Relation;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.RepositoryObjectName;
import com.ibm.ejs.sm.beans.RepositoryObjectNameElem;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.beans.URLProvider;
import com.ibm.ejs.sm.beans.URLProviderAttributes;
import com.ibm.ejs.sm.beans.URLProviderConfig;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.InvalidJDBCDriverJarFileException;
import com.ibm.ejs.sm.exception.InvalidNameChangeException;
import com.ibm.ejs.sm.exception.InvalidResourceProviderNameException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.RemoteOpException;
import com.ibm.ejs.sm.exception.RequiredAttributeMissingException;
import com.ibm.ejs.sm.exception.ResourceProviderAlreadyInstalledException;
import com.ibm.ejs.sm.exception.ResourceProviderInUseException;
import com.ibm.ejs.sm.exception.ResourceProviderNotInstalledException;
import com.ibm.ejs.sm.util.ObjectCollection;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.act.Act;
import com.ibm.ejs.sm.util.act.ActServerImpl;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import com.ibm.ejs.sm.util.task.AsyncTask;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;

public class URLProviderBean
extends RepositoryObjectImpl
implements EntityBean {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$URLProviderBean == null ? (class$com$ibm$ejs$sm$beans$URLProviderBean = URLProviderBean.class$("com.ibm.ejs.sm.beans.URLProviderBean")) : class$com$ibm$ejs$sm$beans$URLProviderBean));
    private static Integer classLock = new Integer(0);
    private static final String tableName = DBMgr.qualifiedTableName((String)"URLPROVIDER_TABLE");
    private static final String nameColumnName = "NAME";
    private static final int nameColumnIndex = 3;
    private static final String descriptionColumnName = "DESCRIPTION";
    private static final int descriptionColumnIndex = 4;
    private static final String protocolColumnName = "PROTOCOL";
    private static final int protocolColumnIndex = 5;
    private static final String streamHandlerClassNameColumnName = "STREAMHNDLRCLASS";
    private static final int streamHandlerClassNameColumnIndex = 6;
    private static final int numColumns = 6;
    protected static final String myInterfaceName = RepositoryObjectImpl.qualifyClassName("URLProvider");
    private static final String myClassName = RepositoryObjectImpl.qualifyClassName("URLProviderBean");
    private static boolean tableCreated = false;
    private static Type myTypeObj = null;
    private static Long myTypeId = null;
    private static final String myHomeName = "URLProviderHome";
    private static Relation providerNodeRel;
    protected static final String providerNodeRelName = "urlProviderInstallations";
    private static Relation providerResourceRel;
    protected static final String providerResourceRelName = "urlProviderUrlRel";
    private static final int urlProviderBeanKeyBase;
    private static final int loadStmtKey;
    private static final int updateStmtKey;
    private static final int deleteStmtKey;
    private static final int insertStmtKey;
    private static final int restrictedFindAllStmtKey;
    private static final int findAllStmtKey;
    private static final int restrictedFindByNameStmtKey;
    private static final int findByNameStmtKey;
    private static final String updateStmtSql;
    private static final String deleteStmtSql;
    private static final String restrictedFindByNameStmtSql;
    private static final String findByNameStmtSql;
    private static final String insertStmtSql;
    private String name;
    private String description;
    private String protocol;
    private String streamHandlerClassName;
    private boolean dirty;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$URLProviderBean;

    public URLProviderBean() throws RemoteException {
        URLProviderBean.initializePersistentStore();
        URLProviderBean.initializeTypeId();
        URLProviderBean.lookupProviderNodeRel();
        URLProviderBean.lookupProviderResourceRel();
    }

    public Long ejbCreate(URLProviderAttributes uRLProviderAttributes, EJBObject eJBObject) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        try {
            this.protocol = uRLProviderAttributes.getProtocol();
            this.streamHandlerClassName = uRLProviderAttributes.getStreamHandlerClassName();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)" < ejbCreate -- required attribute missing", (Object)((Object)attributeNotSetException));
            throw new RequiredAttributeMissingException(attributeNotSetException.getMessage());
        }
        try {
            this.validateStringAttr(uRLProviderAttributes.getName());
        }
        catch (Exception exception) {
            throw new RequiredAttributeMissingException("Name");
        }
        try {
            this.validateStringAttr(this.protocol);
        }
        catch (Exception exception) {
            throw new RequiredAttributeMissingException("Protocol");
        }
        try {
            this.validateStringAttr(this.streamHandlerClassName);
        }
        catch (Exception exception) {
            throw new RequiredAttributeMissingException("StreamHandlerClassName");
        }
        try {
            if (this.typeId == null) {
                this.typeId = myTypeId;
            }
            this.id = this.create(this.typeId);
            this.initializeInstanceVariables();
            try {
                this.updateInstanceVariables(uRLProviderAttributes, true);
            }
            catch (InvalidNameChangeException invalidNameChangeException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate: -- invalid data source name", (Object)((Object)invalidNameChangeException));
                throw new InvalidResourceProviderNameException();
            }
            catch (OpException opException) {
                this.ec.setRollbackOnly();
                Tr.exit((TraceComponent)tc, (String)"ejbCreate: ", (Object)((Object)opException));
                throw new RemoteException("", opException);
            }
            this.name = this.name;
            Vector<String> vector = new Vector<String>(6);
            vector.addElement(Utils.getIdString((Long)this.id));
            vector.addElement(Utils.getIdString((Long)this.typeId));
            vector.addElement(this.name);
            vector.addElement(this.description);
            vector.addElement(this.protocol);
            vector.addElement(this.streamHandlerClassName);
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)this.id);
        return this.id;
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException, FinderException {
        Enumeration enumeration;
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll");
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)false, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbFileAll", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)((ObjectCollection)enumeration).getArray());
        return enumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        DBQueryResult dBQueryResult = null;
        Tr.entry((TraceComponent)tc, (String)"ejbFindByName", (Object)string);
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByNameStmtKey, (String)findByNameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByNameStmtKey, (String)restrictedFindByNameStmtSql, vector);
                }
                Long l2 = this.singleFinderEpilogue(dBQueryResult);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName");
                l = l2;
                Object var8_9 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    public void ejbLoad() throws RemoteException {
        Long l = (Long)this.ec.getPrimaryKey();
        Tr.entry((TraceComponent)tc, (String)"ejbLoad", (Object)l);
        DBQueryResult dBQueryResult = null;
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (resultSet == null || !resultSet.next()) {
                    RemoteException remoteException = new RemoteException("", new ObjectNotFoundException());
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                    throw remoteException;
                }
                if (this.setId(resultSet, myTypeId)) {
                    super.ejbLoad();
                    this.name = resultSet.getString(3);
                    this.description = resultSet.getString(4);
                    this.protocol = resultSet.getString(5);
                    this.streamHandlerClassName = resultSet.getString(6);
                    if (this.name == null) {
                        this.name = new String();
                    }
                    if (this.description == null) {
                        this.description = new String();
                    }
                    if (this.protocol == null) {
                        this.protocol = new String();
                    }
                    if (this.streamHandlerClassName == null) {
                        this.streamHandlerClassName = new String();
                    }
                }
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                throw remoteException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
    }

    public void ejbPostCreate(URLProviderAttributes uRLProviderAttributes, EJBObject eJBObject) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbPostCreate");
        Tr.exit((TraceComponent)tc, (String)"ejbPostCreate");
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        if (this.id == null) {
            this.ejbLoad();
        }
        if (this.narrowRef != null) {
            this.narrowRef.remove();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove");
            return;
        }
        this.checkForProviderUse();
        super.ejbRemove();
        Long l = (Long)this.ec.getPrimaryKey();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)l));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbRemove", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        super.ejbStore();
        if (this.dirty) {
            try {
                Vector<String> vector = new Vector<String>(6);
                vector.addElement(this.name);
                vector.addElement(this.description);
                vector.addElement(this.protocol);
                vector.addElement(this.streamHandlerClassName);
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException("", sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                throw remoteException;
            }
            Tr.exit((TraceComponent)tc, (String)"ejbStore");
        }
    }

    public Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        Attributes attributes2 = null;
        if (this.narrowRef != null) {
            attributes2 = ((URLProvider)this.narrowRef).getAttributes(attributes);
        } else {
            this.setVersion(attributes);
            attributes2 = this.readInstanceVariables(attributes);
        }
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return attributes2;
    }

    public RepositoryObjectName getFullName() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getFullName");
        RepositoryObjectName repositoryObjectName = new RepositoryObjectName();
        repositoryObjectName.addElement(new RepositoryObjectNameElem(myHomeName, this.name));
        Tr.exit((TraceComponent)tc, (String)"getFullName");
        return repositoryObjectName;
    }

    public J2EEResourceProviderConfig getResourceProviderConfig() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getResourceProviderConfig");
        URLProviderConfig uRLProviderConfig = new URLProviderConfig();
        uRLProviderConfig.setName(this.name);
        uRLProviderConfig.setDescription(this.description);
        uRLProviderConfig.setProtocol(this.protocol);
        uRLProviderConfig.setStreamHandlerClassName(this.streamHandlerClassName);
        Tr.exit((TraceComponent)tc, (String)"getResourceProviderConfig");
        return uRLProviderConfig;
    }

    private void initializeInstanceVariables() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeInstanceVariables");
        URLProviderAttributes uRLProviderAttributes = (URLProviderAttributes)RepositoryObjectImpl.getDefaults(myTypeObj);
        try {
            this.description = new String();
            this.protocol = new String();
            this.streamHandlerClassName = new String();
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"intializedInstanceVariables", (Object)exception);
            throw new RemoteException("", exception);
        }
        Tr.exit((TraceComponent)tc, (String)"intializedInstanceVariables");
    }

    private static void initializePersistentStore() throws RemoteException {
        Integer n = classLock;
        synchronized (n) {
            if (tableCreated) {
                return;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + nameColumnName + DBMgr.mediumStringColumnSpec + " , " + descriptionColumnName + DBMgr.nullableMediumStringColumnSpec + " , " + protocolColumnName + DBMgr.mediumStringColumnSpec + " , " + streamHandlerClassNameColumnName + DBMgr.mediumStringColumnSpec + " , " + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Integer n2 = classLock;
            synchronized (n2) {
                tableCreated = true;
            }
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException("", sQLException);
            Tr.exit((TraceComponent)tc, (String)"intializePersistentStore");
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
    }

    private static void initializeTypeId() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        Integer n = classLock;
        synchronized (n) {
            if (myTypeId != null) {
                Tr.exit((TraceComponent)tc, (String)"initializeTypeId");
                return;
            }
        }
        URLProviderAttributes uRLProviderAttributes = new URLProviderAttributes();
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, uRLProviderAttributes, true);
        Long l = (Long)type.getPrimaryKey();
        Integer n2 = classLock;
        synchronized (n2) {
            myTypeObj = type;
            myTypeId = l;
        }
        Tr.exit((TraceComponent)tc, (String)"intializeTypeId");
    }

    private URLProviderAttributes readInstanceVariables(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"readInstanceVariables");
        URLProviderAttributes uRLProviderAttributes = (URLProviderAttributes)attributes;
        uRLProviderAttributes.setName(this.name);
        uRLProviderAttributes.setFullName(this.getFullName());
        uRLProviderAttributes.setDescription(this.description);
        uRLProviderAttributes.setProtocol(this.protocol);
        uRLProviderAttributes.setStreamHandlerClassName(this.streamHandlerClassName);
        Tr.exit((TraceComponent)tc, (String)"readInstanceVariables");
        return uRLProviderAttributes;
    }

    public void setAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setAttributes");
        if (this.narrowRef != null) {
            ((URLProvider)this.narrowRef).setAttributes(attributes);
        } else {
            String string;
            try {
                if (attributes.isSet(Attributes.name)) {
                    string = ((URLProviderAttributes)attributes).getName();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(RepositoryObjectImpl.nls.getFormattedMessage("invalid.attribute.name", new Object[]{"Name"}, "Invalid value for attribute: {0}"));
            }
            try {
                if (attributes.isSet(URLProviderAttributes.protocol)) {
                    string = ((URLProviderAttributes)attributes).getProtocol();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(RepositoryObjectImpl.nls.getFormattedMessage("invalid.attribute.name", new Object[]{"Protocol"}, "Invalid value for attribute: {0}"));
            }
            try {
                if (attributes.isSet(URLProviderAttributes.streamHandlerClassName)) {
                    string = ((URLProviderAttributes)attributes).getStreamHandlerClassName();
                    this.validateStringAttr(string);
                }
            }
            catch (Exception exception) {
                this.ec.setRollbackOnly();
                throw new RemoteOpException(RepositoryObjectImpl.nls.getFormattedMessage("invalid.attribute.name", new Object[]{"StreamHandlerClassName"}, "Invalid value for attribute: {0}"));
            }
            this.checkAndIncrVersion(attributes);
            this.updateInstanceVariables((URLProviderAttributes)attributes, false);
        }
        Tr.exit((TraceComponent)tc, (String)"setAttributes");
    }

    private void updateInstanceVariables(URLProviderAttributes uRLProviderAttributes, boolean bl) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"updateInstanceVariables");
        this.dirty = true;
        try {
            if (uRLProviderAttributes.isSet(Attributes.name)) {
                String string;
                if (bl) {
                    this.name = "";
                }
                this.validateNameChange(uRLProviderAttributes);
                this.name = string = uRLProviderAttributes.getName();
            }
            if (uRLProviderAttributes.isSet(URLProviderAttributes.description)) {
                this.description = uRLProviderAttributes.getDescription();
            }
            if (uRLProviderAttributes.isSet(URLProviderAttributes.protocol)) {
                this.protocol = uRLProviderAttributes.getProtocol();
            }
            if (uRLProviderAttributes.isSet(URLProviderAttributes.streamHandlerClassName)) {
                this.streamHandlerClassName = uRLProviderAttributes.getStreamHandlerClassName();
            }
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeNotSetException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)attributeNotSetException);
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeDoesNotExistException));
            this.ec.setRollbackOnly();
            throw new RemoteOpException("", (Throwable)attributeDoesNotExistException);
        }
        Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables");
    }

    private void validateNameChange(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"validateNameChange ");
        try {
            if (attributes.isSet(Attributes.name)) {
                String string = attributes.getName();
                if (string.equals(this.name)) {
                    Tr.exit((TraceComponent)tc, (String)"validateNameChange");
                    return;
                }
                try {
                    this.ejbFindByName(string, true);
                    Tr.exit((TraceComponent)tc, (String)"validateNameChange -- duplicate name");
                    throw new InvalidNameChangeException();
                }
                catch (ObjectNotFoundException objectNotFoundException) {}
            }
        }
        catch (InvalidNameChangeException invalidNameChangeException) {
            throw invalidNameChangeException;
        }
        catch (Exception exception) {
            Tr.exit((TraceComponent)tc, (String)"validateNameChange -- unexpected error", (Object)exception);
            throw new RemoteOpException("", (Throwable)exception);
        }
        Tr.exit((TraceComponent)tc, (String)"validateNameChange");
    }

    public Act install(Node node, String string) throws OpException, RemoteException {
        Tr.entry((TraceComponent)tc, (String)"install");
        Relation relation = URLProviderBean.lookupProviderNodeRel();
        if (relation.listNames(this.ec.getEJBObject(), node).hasMoreElements()) {
            throw new ResourceProviderAlreadyInstalledException();
        }
        this.addToNamedRelation(relation, node, string);
        Tr.exit((TraceComponent)tc, (String)"install");
        return ActServerImpl.getInstance().scheduleWork(new AsyncTask(){

            public String getName() {
                return "dummyTask";
            }

            public void execute() {
            }
        });
    }

    public Enumeration listInstallations() throws OpException, RemoteException {
        Tr.entry((TraceComponent)tc, (String)"listInstallations ");
        Enumeration enumeration = URLProviderBean.lookupProviderNodeRel().list(this.ec.getEJBObject(), false);
        Tr.exit((TraceComponent)tc, (String)"listInstallations ");
        return enumeration;
    }

    public String getJarFile(Node node) throws OpException, RemoteException {
        Tr.entry((TraceComponent)tc, (String)"getJarFile ");
        String string = null;
        Enumeration enumeration = URLProviderBean.lookupProviderNodeRel().listNames(this.ec.getEJBObject(), node);
        if (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
        }
        Tr.exit((TraceComponent)tc, (String)"getJarFile ");
        return string;
    }

    public Act uninstall(Node node) throws OpException, RemoteException {
        Tr.entry((TraceComponent)tc, (String)"uninstall ");
        Relation relation = URLProviderBean.lookupProviderNodeRel();
        String string = (String)relation.listNames(this.ec.getEJBObject(), node).nextElement();
        if (string == null) {
            throw new ResourceProviderNotInstalledException();
        }
        this.deleteFromRelation(relation, node);
        Tr.exit((TraceComponent)tc, (String)"uninstall");
        return ActServerImpl.getInstance().scheduleWork(new AsyncTask(){

            public String getName() {
                return "dummyTask";
            }

            public void execute() {
            }
        });
    }

    private static Relation lookupProviderResourceRel() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"lookupProviderResourceRel");
        Integer n = classLock;
        synchronized (n) {
            if (providerResourceRel != null) {
                Tr.exit((TraceComponent)tc, (String)"lookupProviderResourceRel");
                Relation relation = providerResourceRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.createRelIfNeeded(myTypeObj, "URL", providerResourceRelName, true, true, 2);
        Integer n2 = classLock;
        synchronized (n2) {
            providerResourceRel = relation;
        }
        Tr.exit((TraceComponent)tc, (String)"lookupProviderResourceRel");
        return relation;
    }

    private static Relation lookupProviderNodeRel() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"lookupProviderNodeRel");
        Integer n = classLock;
        synchronized (n) {
            if (providerNodeRel != null) {
                Tr.exit((TraceComponent)tc, (String)"lookupProviderNodeRel");
                Relation relation = providerNodeRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.createRelIfNeeded(myTypeObj, "Node", providerNodeRelName, true, false, 4);
        Integer n2 = classLock;
        synchronized (n2) {
            providerNodeRel = relation;
        }
        Tr.exit((TraceComponent)tc, (String)"lookupProviderNodeRel");
        return relation;
    }

    private void checkForProviderUse() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"checkForProviderUse");
        providerResourceRel = URLProviderBean.lookupProviderResourceRel();
        try {
            Enumeration enumeration = this.listRelatedObjects(providerResourceRel);
            if (enumeration.hasMoreElements()) {
                throw new ResourceProviderInUseException();
            }
        }
        catch (OpException opException) {
            Tr.exit((TraceComponent)tc, (String)"checkForProviderUse", (Object)((Object)opException));
            throw new RemoteException("", opException);
        }
        Tr.exit((TraceComponent)tc, (String)"checkForDriverUse");
    }

    private void validateStringAttr(String string) throws RemoteException {
        if (string.trim().equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"validateStringAttr failed.");
            }
            throw new RemoteException("validateStringAttr failed.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        urlProviderBeanKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
        loadStmtKey = urlProviderBeanKeyBase + 1;
        updateStmtKey = urlProviderBeanKeyBase + 2;
        deleteStmtKey = urlProviderBeanKeyBase + 3;
        insertStmtKey = urlProviderBeanKeyBase + 4;
        restrictedFindAllStmtKey = urlProviderBeanKeyBase + 5;
        findAllStmtKey = urlProviderBeanKeyBase + 6;
        restrictedFindByNameStmtKey = urlProviderBeanKeyBase + 7;
        findByNameStmtKey = urlProviderBeanKeyBase + 8;
        updateStmtSql = "update " + tableName + " set " + nameColumnName + " = ? , " + descriptionColumnName + " = ? , " + protocolColumnName + " = ? ," + streamHandlerClassNameColumnName + " = ?  " + " where " + "INSTANCE_ID" + " = ?";
        deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " = ?";
        restrictedFindByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " = ? and " + "TYPE_ID" + " = ? ";
        findByNameStmtSql = "select * from " + tableName + " where " + nameColumnName + " =  ?";
        insertStmtSql = "insert into " + tableName + " values (?,?,?,?,?,?)";
    }

    class NotifyNodeTask
    implements AsyncTask {
        private Node node;
        private AdminAgent nodeAgent;
        private String jarFile;
        private boolean addOrRemove;

        NotifyNodeTask(Node node, AdminAgent adminAgent, String string, boolean bl) {
            this.node = node;
            this.nodeAgent = adminAgent;
            this.jarFile = string;
            this.addOrRemove = bl;
        }

        public String getName() {
            return "notifyNodeTask";
        }

        public void execute() throws RemoteException, OpException {
            Tr.entry((TraceComponent)tc, (String)"notifyNodeTask - execute");
            ParamList paramList = new ParamList(2);
            paramList.addElement(this.jarFile);
            paramList.addElement(this.addOrRemove);
            try {
                this.nodeAgent.invokeActiveObject(this.node.getActiveObjectContainmentPath(), "notifyDriverInstallation", paramList);
            }
            catch (InvalidJDBCDriverJarFileException invalidJDBCDriverJarFileException) {
                Tr.event((TraceComponent)tc, (String)"invalid jar file, removing driver object");
                URLProviderBean.this.deleteFromRelation(URLProviderBean.lookupProviderNodeRel(), this.node);
                throw invalidJDBCDriverJarFileException;
            }
            Tr.exit((TraceComponent)tc, (String)"notifyNodeTask - execute");
        }
    }
}

