/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.Module;
import com.ibm.ejs.sm.beans.ModuleAttributes;
import com.ibm.ejs.sm.beans.ModuleBean;
import com.ibm.ejs.sm.beans.Relation;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.RepositoryObjectName;
import com.ibm.ejs.sm.beans.RepositoryObjectNameElem;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.beans.VirtualHost;
import com.ibm.ejs.sm.beans.VirtualHostAttributes;
import com.ibm.ejs.sm.beans.VirtualHostHome;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.InvalidNameChangeException;
import com.ibm.ejs.sm.exception.InvalidVirtualHostNameException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.exception.RequiredAttributeMissingException;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.rmi.PortableRemoteObject;

public class VirtualHostBean
extends RepositoryObjectImpl
implements EntityBean {
    private static Integer classLock = new Integer(0);
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$beans$VirtualHostBean == null ? (class$com$ibm$ejs$sm$beans$VirtualHostBean = VirtualHostBean.class$("com.ibm.ejs.sm.beans.VirtualHostBean")) : class$com$ibm$ejs$sm$beans$VirtualHostBean));
    private static final String PLUGIN_REGEN = "The administrative action just performed may invalidate the Web Server plugin configuration file. Use the Plugin regen operation of the Node to update this file.";
    private static NLS nls = null;
    protected static final String myInterfaceName = RepositoryObjectImpl.qualifyClassName("VirtualHost");
    private static final String myClassName = RepositoryObjectImpl.qualifyClassName("VirtualHostBean");
    private static boolean tableCreated = false;
    private static Type myTypeObj = null;
    private static Long myTypeId = null;
    private boolean dirty;
    private String name;
    private String virtualHostName;
    private Hashtable mimeTable;
    private Vector aliasList;
    private static final String mimeTableBinAttrName = myInterfaceName + ".mimeTable";
    private static final String aliasListBinAttrName = myInterfaceName + ".aliasList";
    private static Hashtable defaultMimeTable = null;
    private static final Vector defaultAliasList = new Vector();
    private static final String tableName = DBMgr.qualifiedTableName((String)"VIRTUAL_HOST_TBL");
    private static final String virtualHostNameColumnName = "VirtualHostName";
    private static final int virtualHostNameColumnIndex = 3;
    private static final int numColumns = 3;
    private static final int vhostBeanKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
    private static final int loadStmtKey = vhostBeanKeyBase + 1;
    private static final int deleteStmtKey = vhostBeanKeyBase + 2;
    private static final int updateStmtKey = vhostBeanKeyBase + 3;
    private static final int findAllStmtKey = vhostBeanKeyBase + 4;
    private static final int restrictedFindAllStmtKey = vhostBeanKeyBase + 5;
    private static final int findByNameStmtKey = vhostBeanKeyBase + 6;
    private static final int restrictedFindByNameStmtKey = vhostBeanKeyBase + 7;
    private static final int insertStmtKey = vhostBeanKeyBase + 8;
    private static final String insertStmtSql = "insert into " + tableName + " values(?,?,?)";
    private static final String updateStmtSql = "update " + tableName + " set " + "VirtualHostName" + " =  ? " + " where " + "INSTANCE_ID" + " = ?";
    private static final String deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " =  ?";
    private static final String findByNameStmtSql = "select * from " + tableName + " where " + "VirtualHostName" + " =  ?";
    private static final String restrictedFindByNameStmtSql = "select * from " + tableName + " where " + "VirtualHostName" + " =  ?  and " + "TYPE_ID" + " = ? ";
    private static Relation moduleVirtualHostRel;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$VirtualHostBean;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$VirtualHostHome;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$Module;

    public VirtualHostBean() throws RemoteException {
        this.initializeNLS("RepositoryStrings");
        VirtualHostBean.initializePersistentStore();
        VirtualHostBean.initializeTypeId();
    }

    public Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttributes");
        }
        if (this.narrowRef != null) {
            return ((VirtualHost)this.narrowRef).getAttributes(attributes);
        }
        this.setVersion(attributes);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttributes");
        }
        return this.readInstanceVariables(attributes);
    }

    public void setAttributes(Attributes attributes) throws RemoteException, OpException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setAttributes");
        }
        if (this.narrowRef != null) {
            ((VirtualHost)this.narrowRef).setAttributes(attributes);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setAttributes");
            }
            return;
        }
        this.validateNameChange(attributes, false);
        this.checkAndIncrVersion(attributes);
        this.updateInstanceVariables((VirtualHostAttributes)attributes);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAttributes");
        }
    }

    private static void initializePersistentStore() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        }
        Integer n = classLock;
        synchronized (n) {
            if (tableCreated) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
                }
                return;
            }
        }
        try {
            String string = "create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + virtualHostNameColumnName + DBMgr.mediumStringColumnSpec + " , " + " primary key(" + "INSTANCE_ID" + "))";
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Integer n2 = classLock;
            synchronized (n2) {
                tableCreated = true;
            }
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getString("vhost.db.create.exception", "Database create table failed."), sQLException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initializePersistentStore", (Object)remoteException);
            }
            throw remoteException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
        }
    }

    private static void initializeTypeId() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        }
        Integer n = classLock;
        synchronized (n) {
            if (myTypeId != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initializeTypeId");
                }
                return;
            }
        }
        VirtualHostAttributes virtualHostAttributes = new VirtualHostAttributes();
        defaultMimeTable = VirtualHostBean.createDefaultMimeTable();
        virtualHostAttributes.setMimeTable(defaultMimeTable);
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, virtualHostAttributes, true);
        Long l = (Long)type.getPrimaryKey();
        Integer n2 = classLock;
        synchronized (n2) {
            myTypeObj = type;
            myTypeId = l;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeTypeId");
        }
    }

    public void ejbLoad() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ejbLoad");
        }
        Long l = (Long)this.ec.getPrimaryKey();
        DBQueryResult dBQueryResult = null;
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (!resultSet.next()) {
                    RemoteException remoteException = new RemoteException(nls.getFormattedMessage("vhost.db.select1.exception", new Object[]{l}, "Database select failed to find VirtualHost instance (id={0})."), new ObjectNotFoundException());
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                    }
                    throw remoteException;
                }
                if (this.setId(resultSet, myTypeId)) {
                    super.ejbLoad();
                    this.virtualHostName = resultSet.getString(3);
                    this.mimeTable = (Hashtable)this.getBinaryAttr(mimeTableBinAttrName);
                    this.aliasList = (Vector)this.getBinaryAttr(aliasListBinAttrName);
                }
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getString("vhost.db.select2.exception", "Database select failed."), sQLException);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                }
                throw remoteException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ejbLoad");
        }
    }

    public void ejbStore() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ejbStore");
        }
        if (this.narrowRef != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ejbStore");
            }
            return;
        }
        super.ejbStore();
        if (this.dirty) {
            try {
                Vector<String> vector = new Vector<String>(3);
                vector.addElement(this.virtualHostName);
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("vhost.db.update.exception", new Object[]{this.id}, "Database update failed to store VirtualHost attributes (id={0})."), sQLException);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                }
                throw remoteException;
            }
        }
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        }
        if (this.id == null) {
            this.ejbLoad();
        }
        if (this.narrowRef != null) {
            this.narrowRef.remove();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ejbRemove");
            }
            return;
        }
        this.checkInUse();
        super.ejbRemove();
        Long l = (Long)this.ec.getPrimaryKey();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)l));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("vhost.db.remove.exception", new Object[]{l}, "Database delete failed to remove VirtualHost instance (id={0})."), sQLException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ejbRemove", (Object)remoteException);
            }
            throw remoteException;
        }
        Tr.audit((TraceComponent)tc, (String)nls.getFormattedMessage("node.plugin.config.regen", null, PLUGIN_REGEN));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ejbRemove");
        }
    }

    public Long ejbCreate(VirtualHostAttributes virtualHostAttributes, EJBObject eJBObject) throws RemoteException, CreateException, AttributeNotSetException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        }
        try {
            this.name = virtualHostAttributes.getName();
            virtualHostAttributes.getAliasList();
        }
        catch (AttributeNotSetException attributeNotSetException) {
            RequiredAttributeMissingException requiredAttributeMissingException = new RequiredAttributeMissingException(nls.getString("vhost.attribute.missing1.exception", "Required VirtualHost name or AliasList attribute was not specified."));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ejbCreate -- required attribute missing", (Object)requiredAttributeMissingException);
            }
            throw requiredAttributeMissingException;
        }
        try {
            this.virtualHostName = "";
            this.validateNameChange(virtualHostAttributes, true);
        }
        catch (InvalidNameChangeException invalidNameChangeException) {
            InvalidVirtualHostNameException invalidVirtualHostNameException = new InvalidVirtualHostNameException(nls.getFormattedMessage("vhost.already.exists.exception", new Object[]{this.name}, "VirtualHost already exists (name={0})."));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ejbCreate -- invalid VirtualHost name");
            }
            throw invalidVirtualHostNameException;
        }
        catch (OpException opException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("vhost.validate.name.exception", new Object[]{this.name}, "Exception occurred validating input VirtualHost (name={0})."), opException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ejbCreate -- validateNameChange error occurred");
            }
            throw remoteException;
        }
        try {
            if (this.typeId == null) {
                this.typeId = myTypeId;
            }
            this.id = this.create(this.typeId);
            this.initializeInstanceVariables();
            this.updateInstanceVariables(virtualHostAttributes);
            Vector<String> vector = new Vector<String>(3);
            vector.addElement(Utils.getIdString((Long)this.id));
            vector.addElement(Utils.getIdString((Long)this.typeId));
            vector.addElement(this.virtualHostName);
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("vhost.db.insert.exception", new Object[]{this.id}, "Database insert failed to store new VirtualHost instance (id={0})."), sQLException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)remoteException);
            }
            throw remoteException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ejbCreate", (Object)this.id);
        }
        return this.id;
    }

    public void ejbPostCreate(VirtualHostAttributes virtualHostAttributes) {
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException, FinderException {
        Enumeration enumeration;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ejbFindAll");
        }
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)bl, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getString("vhost.db.select3.exception", "Database select failed to find all instances of VirtualHost."), sQLException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)remoteException);
            }
            throw remoteException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)enumeration);
        }
        return enumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long ejbFindByName(String string, boolean bl) throws RemoteException, FinderException {
        Long l;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ejbFindByName", (Object)string);
        }
        DBQueryResult dBQueryResult = null;
        try {
            try {
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(string);
                if (bl) {
                    dBQueryResult = DBMgr.executePreparedQuery((int)findByNameStmtKey, (String)findByNameStmtSql, vector);
                } else {
                    vector.addElement(Utils.getIdString((Long)myTypeId));
                    dBQueryResult = DBMgr.executePreparedQuery((int)restrictedFindByNameStmtKey, (String)restrictedFindByNameStmtSql, vector);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"ejbFindByName");
                }
                l = this.singleFinderEpilogue(dBQueryResult);
                Object var7_8 = null;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(nls.getFormattedMessage("vhost.db.select4.exception", new Object[]{string}, "Database select failed to find instance of VirtualHost (name={0})."), sQLException);
                if (!tc.isEntryEnabled()) throw remoteException;
                Tr.exit((TraceComponent)tc, (String)"ejbFindByName", (Object)remoteException);
                throw remoteException;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        return l;
    }

    public Long ejbFindByAliasName(String string, boolean bl) throws RemoteException, FinderException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ejbFindByAliasName");
        }
        Long l = null;
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            Object object;
            Enumeration enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)bl, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
            boolean bl2 = false;
            VirtualHostHome virtualHostHome = (VirtualHostHome)PortableRemoteObject.narrow((Object)RepositoryObjectImpl.getHome("VirtualHostHome"), (Class)(class$com$ibm$ejs$sm$beans$VirtualHostHome == null ? (class$com$ibm$ejs$sm$beans$VirtualHostHome = VirtualHostBean.class$("com.ibm.ejs.sm.beans.VirtualHostHome")) : class$com$ibm$ejs$sm$beans$VirtualHostHome));
            while (enumeration.hasMoreElements() && !bl2) {
                l = (Long)enumeration.nextElement();
                object = virtualHostHome.findByPrimaryKey(l);
                VirtualHostAttributes virtualHostAttributes = new VirtualHostAttributes();
                virtualHostAttributes = (VirtualHostAttributes)object.getAttributes(virtualHostAttributes);
                Vector vector = virtualHostAttributes.getAliasList();
                int n2 = vector.size();
                int n3 = 0;
                while (n3 < n2) {
                    String string2 = (String)vector.elementAt(n3);
                    if (string2.equalsIgnoreCase(string)) {
                        bl2 = true;
                    }
                    ++n3;
                }
            }
            if (!bl2) {
                object = new ObjectNotFoundException(nls.getFormattedMessage("vhost.not.found.exception", new Object[]{string}, "VirtualHost was not found for Alias (name={0})."));
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"ejbFindByAliasName", (Object)object);
                }
                throw object;
            }
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(nls.getString("vhost.db.select3.exception", "Database select failed to find all instances of VirtualHost."), sQLException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ejbFindByAliasName", (Object)remoteException);
            }
            throw remoteException;
        }
        catch (OpException opException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("vhost.find1.exception", new Object[]{string}, "Exception occurred trying to find VirtualHost for Alias (name={0})."), opException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ejbFindByAliasName", (Object)remoteException);
            }
            throw remoteException;
        }
        catch (AttributeNotSetException attributeNotSetException) {
            RemoteException remoteException = new RemoteException(nls.getString("vhost.attribute.not.set1.exception", "VirtualHost AliasList attribute was not set."), attributeNotSetException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ejbFindByAliasName", (Object)remoteException);
            }
            throw remoteException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ejbFindByAliasName");
        }
        return l;
    }

    private void initializeInstanceVariables() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeInstanceVariables");
        }
        try {
            VirtualHostAttributes virtualHostAttributes = (VirtualHostAttributes)RepositoryObjectImpl.getDefaults(myTypeObj);
            this.virtualHostName = this.name;
            this.mimeTable = virtualHostAttributes.getMimeTable();
            this.setBinaryAttr(mimeTableBinAttrName, this.mimeTable);
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException(nls.getString("vhost.attribute.init.exception", "Exception occurred initializing default VirtualHost attributes."), exception);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initializeInstanceVariables", (Object)remoteException);
            }
            throw remoteException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeInstanceVariables");
        }
    }

    private void updateInstanceVariables(VirtualHostAttributes virtualHostAttributes) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateInstanceVariables");
        }
        this.dirty = true;
        try {
            if (virtualHostAttributes.isSet(VirtualHostAttributes.mimeTable)) {
                this.mimeTable = virtualHostAttributes.getMimeTable();
                this.setBinaryAttr(mimeTableBinAttrName, this.mimeTable);
            }
            if (virtualHostAttributes.isSet(VirtualHostAttributes.aliasList)) {
                this.aliasList = virtualHostAttributes.getAliasList();
                this.setBinaryAttr(aliasListBinAttrName, this.aliasList);
            }
        }
        catch (AttributeNotSetException attributeNotSetException) {
            RemoteException remoteException = new RemoteException(nls.getString("vhost.attribute.missing2.exception", "Required attribute for VirtualHost was not input."), attributeNotSetException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)remoteException);
            }
            throw remoteException;
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            RemoteException remoteException = new RemoteException(nls.getString("vhost.attribute.not.exist1.exception", "Input attribute does not exist for a VirtualHost."), attributeDoesNotExistException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)remoteException);
            }
            throw remoteException;
        }
        Tr.audit((TraceComponent)tc, (String)nls.getFormattedMessage("node.plugin.config.regen", null, PLUGIN_REGEN));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables");
        }
    }

    private VirtualHostAttributes readInstanceVariables(Attributes attributes) throws RemoteException, OpException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readInstanceVariables");
        }
        VirtualHostAttributes virtualHostAttributes = (VirtualHostAttributes)attributes;
        virtualHostAttributes.setName(this.virtualHostName);
        virtualHostAttributes.setFullName(this.getFullName());
        virtualHostAttributes.setMimeTable(this.mimeTable);
        virtualHostAttributes.setAliasList(this.aliasList);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readInstanceVariables");
        }
        return virtualHostAttributes;
    }

    public RepositoryObjectName getFullName() throws RemoteException, OpException {
        RepositoryObjectName repositoryObjectName = new RepositoryObjectName();
        repositoryObjectName.addElement(new RepositoryObjectNameElem("VirtualHostHome", this.virtualHostName));
        return repositoryObjectName;
    }

    private static Relation lookupWebModuleVirtualHostRel() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupWebModuleVirtualHostRel");
        }
        Integer n = classLock;
        synchronized (n) {
            if (moduleVirtualHostRel != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"lookupWebModuleVirtualHostRel");
                }
                Relation relation = moduleVirtualHostRel;
                return relation;
            }
        }
        Relation relation = RepositoryObjectImpl.lookupRel(ModuleBean.myInterfaceName, myTypeObj, "moduleVirtualHostRel");
        Integer n2 = classLock;
        synchronized (n2) {
            moduleVirtualHostRel = relation;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupWebModuleVirtualHostRel");
        }
        return relation;
    }

    protected void initializeNLS(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeNLS");
        }
        if (nls == null) {
            nls = new NLS(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeNLS");
        }
    }

    private void checkInUse() throws RemoteException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkInUse");
        }
        boolean bl = false;
        String string = null;
        try {
            object = VirtualHostBean.lookupWebModuleVirtualHostRel();
            Enumeration enumeration = object.list(this.ec.getEJBObject(), true);
            if (enumeration.hasMoreElements()) {
                bl = true;
                Module module = (Module)PortableRemoteObject.narrow(enumeration.nextElement(), (Class)(class$com$ibm$ejs$sm$beans$Module == null ? (class$com$ibm$ejs$sm$beans$Module = VirtualHostBean.class$("com.ibm.ejs.sm.beans.Module")) : class$com$ibm$ejs$sm$beans$Module));
                ModuleAttributes moduleAttributes = new ModuleAttributes();
                moduleAttributes.request(Attributes.name);
                moduleAttributes = (ModuleAttributes)module.getAttributes(moduleAttributes);
                string = moduleAttributes.getName();
            }
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException(nls.getString("vhost.get.modules.exception", "An error occurred obtaining the Modules using this Virtual Host."), exception);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkInUse", (Object)remoteException);
            }
            throw remoteException;
        }
        if (bl) {
            object = new RemoteException(nls.getFormattedMessage("vhost.module.rel.exists", new Object[]{string}, "The Virtual Host cannot be removed because it is currently being used by Module (name={0})."));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkInUse", (Object)object);
            }
            throw object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkInUse");
        }
    }

    private void validateNameChange(Attributes attributes, boolean bl) throws RemoteException, OpException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateNameChange ");
        }
        String string = null;
        try {
            if (attributes.isSet(Attributes.name)) {
                string = attributes.getName();
                if (!bl && string.equals(this.virtualHostName)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"validateNameChange");
                    }
                    return;
                }
                try {
                    this.ejbFindByName(string, true);
                    InvalidNameChangeException invalidNameChangeException = new InvalidNameChangeException(nls.getFormattedMessage("vhost.already.exists.exception", new Object[]{string}, "VirtualHost already exists (name={0})."));
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"validateNameChange -- duplicate name");
                    }
                    throw invalidNameChangeException;
                }
                catch (ObjectNotFoundException objectNotFoundException) {}
            }
        }
        catch (FinderException finderException) {
            RemoteException remoteException = new RemoteException(nls.getFormattedMessage("vhost.find2.exception", new Object[]{string}, "Exception occurred attempting to find VirtualHost by name (name={0})."), finderException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validateNameChange", (Object)remoteException);
            }
            throw remoteException;
        }
        catch (AttributeNotSetException attributeNotSetException) {
            RemoteException remoteException = new RemoteException(nls.getString("vhost.attribute.not.set2.exception", "VirtualHost name attribute was not set."), attributeNotSetException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validateNameChange", (Object)remoteException);
            }
            throw remoteException;
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            RemoteException remoteException = new RemoteException(nls.getString("vhost.attribute.not.exist2.exception", "VirtualHost name attribute does not exist."), attributeDoesNotExistException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validateNameChange", (Object)remoteException);
            }
            throw remoteException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateNameChange");
        }
    }

    public static Hashtable createDefaultMimeTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createDefaultMimeTable");
        }
        Hashtable hashtable = new Hashtable(150);
        Vector<String> vector = new Vector<String>();
        vector.addElement("STL");
        vector.addElement("stl");
        hashtable.put("application/SLA", vector);
        vector = new Vector();
        vector.addElement("STEP");
        vector.addElement("STP");
        vector.addElement("step");
        vector.addElement("stp");
        hashtable.put("application/STEP", vector);
        vector = new Vector();
        vector.addElement("DGW");
        vector.addElement("dgw");
        hashtable.put("application/acad", vector);
        vector = new Vector();
        vector.addElement("CCAD");
        hashtable.put("application/clariscad", vector);
        vector = new Vector();
        vector.addElement("DRW");
        hashtable.put("application/drafting", vector);
        vector = new Vector();
        vector.addElement("DXF");
        vector.addElement("dxf");
        hashtable.put("application/dxf", vector);
        vector = new Vector();
        vector.addElement("UNV");
        vector.addElement("unv");
        hashtable.put("application/i-deas", vector);
        vector = new Vector();
        vector.addElement("IGES");
        vector.addElement("IGS");
        vector.addElement("iges");
        vector.addElement("igs");
        hashtable.put("application/iges", vector);
        vector = new Vector();
        vector.addElement("bin");
        vector.addElement("class");
        hashtable.put("application/octet-stream", vector);
        vector = new Vector();
        vector.addElement("oda");
        hashtable.put("application/oda", vector);
        vector = new Vector();
        vector.addElement("pdf");
        hashtable.put("application/pdf", vector);
        vector = new Vector();
        vector.addElement("PS");
        vector.addElement("ai");
        vector.addElement("eps");
        vector.addElement("ps");
        hashtable.put("application/postscript", vector);
        vector = new Vector();
        vector.addElement("PRT");
        vector.addElement("prt");
        hashtable.put("application/pro_eng", vector);
        vector = new Vector();
        vector.addElement("SET");
        vector.addElement("set");
        hashtable.put("application/set", vector);
        vector = new Vector();
        vector.addElement("SOL");
        hashtable.put("application/solids", vector);
        vector = new Vector();
        vector.addElement("VDA");
        vector.addElement("vda");
        hashtable.put("application/vda", vector);
        vector = new Vector();
        vector.addElement("123");
        vector.addElement("wk1");
        vector.addElement("wk3");
        vector.addElement("wk4");
        hashtable.put("application/vnd.lotus-1-2-3", vector);
        vector = new Vector();
        vector.addElement("apr");
        vector.addElement("vew");
        hashtable.put("application/vnd.lotus-approach", vector);
        vector = new Vector();
        vector.addElement("pre");
        vector.addElement("prz");
        hashtable.put("application/vnd.lotus-freelance", vector);
        vector = new Vector();
        vector.addElement("or2");
        vector.addElement("or3");
        vector.addElement("org");
        hashtable.put("application/vnd.lotus-organizer", vector);
        vector = new Vector();
        vector.addElement("scm");
        hashtable.put("application/vnd.lotus-screencam", vector);
        vector = new Vector();
        vector.addElement("lwp");
        vector.addElement("sam");
        hashtable.put("application/vnd.lotus-wordpro", vector);
        vector = new Vector();
        vector.addElement("wk1");
        hashtable.put("application/x-123", vector);
        vector = new Vector();
        vector.addElement("bcpio");
        hashtable.put("application/x-bcpio", vector);
        vector = new Vector();
        vector.addElement("bsh");
        hashtable.put("application/x-bsh", vector);
        vector = new Vector();
        vector.addElement("cpio");
        hashtable.put("application/x-cpio", vector);
        vector = new Vector();
        vector.addElement("csh");
        hashtable.put("application/x-csh", vector);
        vector = new Vector();
        vector.addElement("dvi");
        hashtable.put("application/x-dvi", vector);
        vector = new Vector();
        vector.addElement("prs");
        hashtable.put("application/x-freelance", vector);
        vector = new Vector();
        vector.addElement("gtar");
        hashtable.put("application/x-gtar", vector);
        vector = new Vector();
        vector.addElement("hdf");
        hashtable.put("application/x-hdf", vector);
        vector = new Vector();
        vector.addElement("js");
        hashtable.put("application/x-javascript", vector);
        vector = new Vector();
        vector.addElement("ksh");
        hashtable.put("application/x-ksh", vector);
        vector = new Vector();
        vector.addElement("latex");
        hashtable.put("application/x-latex", vector);
        vector = new Vector();
        vector.addElement("cdf");
        vector.addElement("nc");
        hashtable.put("application/x-netcdf", vector);
        vector = new Vector();
        vector.addElement("pcl");
        hashtable.put("application/x-pcl", vector);
        vector = new Vector();
        vector.addElement("rtf");
        hashtable.put("application/x-rtf", vector);
        vector = new Vector();
        vector.addElement("sh");
        hashtable.put("application/x-sh", vector);
        vector = new Vector();
        vector.addElement("shar");
        hashtable.put("application/x-shar", vector);
        vector = new Vector();
        vector.addElement("sv4cpio");
        hashtable.put("application/x-sv4cpio", vector);
        vector = new Vector();
        vector.addElement("sv4crc");
        hashtable.put("application/x-sv4crc", vector);
        vector = new Vector();
        vector.addElement("tcl");
        hashtable.put("application/x-tcl", vector);
        vector = new Vector();
        vector.addElement("tex");
        hashtable.put("application/x-tex", vector);
        vector = new Vector();
        vector.addElement("texi");
        vector.addElement("texinfo");
        hashtable.put("application/x-texinfo", vector);
        vector = new Vector();
        vector.addElement("roff");
        vector.addElement("t");
        vector.addElement("tr");
        hashtable.put("application/x-troff", vector);
        vector = new Vector();
        vector.addElement("man");
        hashtable.put("application/x-troff-man", vector);
        vector = new Vector();
        vector.addElement("me");
        hashtable.put("application/x-troff-me", vector);
        vector = new Vector();
        vector.addElement("ms");
        hashtable.put("application/x-troff-ms", vector);
        vector = new Vector();
        vector.addElement("src");
        hashtable.put("application/x-wais-source", vector);
        vector = new Vector();
        vector.addElement("der");
        hashtable.put("application/x-x509-ca-cert", vector);
        vector = new Vector();
        vector.addElement("au");
        vector.addElement("snd");
        hashtable.put("audio/basic", vector);
        vector = new Vector();
        vector.addElement("aif");
        vector.addElement("aifc");
        vector.addElement("aiff");
        hashtable.put("audio/x-aiff", vector);
        vector = new Vector();
        vector.addElement("wav");
        hashtable.put("audio/x-wav", vector);
        vector = new Vector();
        vector.addElement("bmp");
        hashtable.put("image/bmp", vector);
        vector = new Vector();
        vector.addElement("ras");
        hashtable.put("image/cmu-raster", vector);
        vector = new Vector();
        vector.addElement("gif");
        hashtable.put("image/gif", vector);
        vector = new Vector();
        vector.addElement("ief");
        hashtable.put("image/ief", vector);
        vector = new Vector();
        vector.addElement("JPE");
        vector.addElement("JPEG");
        vector.addElement("JPG");
        vector.addElement("jpe");
        vector.addElement("jpeg");
        vector.addElement("jpg");
        hashtable.put("image/jpeg", vector);
        vector = new Vector();
        vector.addElement("tif");
        vector.addElement("tiff");
        hashtable.put("image/tiff", vector);
        vector = new Vector();
        vector.addElement("pnm");
        hashtable.put("image/x-portable-anymap", vector);
        vector = new Vector();
        vector.addElement("pbm");
        hashtable.put("image/x-portable-bitmap", vector);
        vector = new Vector();
        vector.addElement("pgm");
        hashtable.put("image/x-portable-graymap", vector);
        vector = new Vector();
        vector.addElement("ppm");
        hashtable.put("image/x-portable-pixmap", vector);
        vector = new Vector();
        vector.addElement("rgb");
        hashtable.put("image/x-rgb", vector);
        vector = new Vector();
        vector.addElement("xbm");
        hashtable.put("image/x-xbitmap", vector);
        vector = new Vector();
        vector.addElement("xpm");
        hashtable.put("image/x-xpixmap", vector);
        vector = new Vector();
        vector.addElement("xwd");
        hashtable.put("image/x-xwindowdump", vector);
        vector = new Vector();
        vector.addElement("gz");
        hashtable.put("mulitpart/x-gzip", vector);
        vector = new Vector();
        vector.addElement("tar");
        hashtable.put("multipart/x-tar", vector);
        vector = new Vector();
        vector.addElement("ustar");
        hashtable.put("multipart/x-ustar", vector);
        vector = new Vector();
        vector.addElement("zip");
        hashtable.put("multipart/x-zip", vector);
        vector = new Vector();
        vector.addElement("css");
        vector.addElement("s");
        hashtable.put("text/css", vector);
        vector = new Vector();
        vector.addElement("htm");
        vector.addElement("html");
        hashtable.put("text/html", vector);
        vector = new Vector();
        vector.addElement("C");
        vector.addElement("c");
        vector.addElement("cc");
        vector.addElement("com");
        vector.addElement("conf");
        vector.addElement("cxx");
        vector.addElement("def");
        vector.addElement("f90");
        vector.addElement("for");
        vector.addElement("h");
        vector.addElement("hh");
        vector.addElement("java");
        vector.addElement("list");
        vector.addElement("log");
        vector.addElement("lst");
        vector.addElement("m");
        vector.addElement("mar");
        vector.addElement("sdml");
        vector.addElement("txt");
        hashtable.put("text/plain", vector);
        vector = new Vector();
        vector.addElement("rtx");
        hashtable.put("text/richtext", vector);
        vector = new Vector();
        vector.addElement("tsv");
        hashtable.put("text/tab-separated-values", vector);
        vector = new Vector();
        vector.addElement("asm");
        hashtable.put("test/x-asm", vector);
        vector = new Vector();
        vector.addElement("etx");
        hashtable.put("text/x-setext", vector);
        vector = new Vector();
        vector.addElement("htmls");
        vector.addElement("shtml");
        hashtable.put("text/x-ssi-html", vector);
        vector = new Vector();
        vector.addElement("uil");
        hashtable.put("text/x-uil", vector);
        vector = new Vector();
        vector.addElement("latex");
        hashtable.put("application/x-latex", vector);
        vector = new Vector();
        vector.addElement("uu");
        hashtable.put("text/x-uuencode", vector);
        vector = new Vector();
        vector.addElement("MPE");
        vector.addElement("MPEG");
        vector.addElement("MPG");
        vector.addElement("mpe");
        vector.addElement("mpeg");
        vector.addElement("mpg");
        hashtable.put("video/mpeg", vector);
        vector = new Vector();
        vector.addElement("mov");
        vector.addElement("qt");
        hashtable.put("video/quicktime", vector);
        vector = new Vector();
        vector.addElement("mjpg");
        hashtable.put("video/x-motion-jpeg", vector);
        vector = new Vector();
        vector.addElement("avi");
        hashtable.put("video/x-msvideo", vector);
        vector = new Vector();
        vector.addElement("movie");
        hashtable.put("video/x-sgi-movie", vector);
        vector = new Vector();
        vector.addElement("mime");
        hashtable.put("www/mime", vector);
        vector = new Vector();
        vector.addElement("*");
        vector.addElement("*.*");
        hashtable.put("www/unknown", vector);
        vector = new Vector();
        vector.addElement("wrl");
        hashtable.put("x-world/x-vrml", vector);
        vector = new Vector();
        vector.addElement("xml");
        vector.addElement("dtd");
        hashtable.put("text/xml", vector);
        vector = new Vector();
        vector.addElement("xsl");
        hashtable.put("application/xml", vector);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createDefaultMimeTable");
        }
        return hashtable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

