/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.beans;

import com.ibm.ejs.sm.beans.BinaryAttrSerialization;
import com.ibm.ejs.sm.beans.CloneOnlyAwareConfig;
import com.ibm.ejs.sm.beans.DynamicCacheConfig;
import com.ibm.ejs.sm.beans.HTTPTransportConfig;
import com.ibm.ejs.sm.beans.SessionManagerConfig;
import com.ibm.ejs.sm.beans.ThreadPoolConfig;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class WebContainerConfig
implements Serializable,
BinaryAttrSerialization,
CloneOnlyAwareConfig {
    private static final long serialVersionUID = 0L;
    private SessionManagerConfig sessionMgrConfig;
    private ThreadPoolConfig threadPoolConfig;
    private Vector transports;
    private DynamicCacheConfig dynamicCacheConfig;
    public static final String sessionMgrConfigPropKey = "sessionMgrConfig";
    public static final String threadPoolConfigPropKey = "threadPoolConfig";
    public static final String transportsPropKey = "transports";
    public static final String dynamicCacheConfigPropKey = "dynamicCacheConfig";

    public SessionManagerConfig getSessionManagerConfig() {
        return this.sessionMgrConfig;
    }

    public void setSessionManagerConfig(SessionManagerConfig sessionManagerConfig) {
        this.sessionMgrConfig = sessionManagerConfig;
    }

    public ThreadPoolConfig getThreadPoolConfig() {
        return this.threadPoolConfig;
    }

    public void setThreadPoolConfig(ThreadPoolConfig threadPoolConfig) {
        this.threadPoolConfig = threadPoolConfig;
    }

    public Vector getTransports() {
        return this.transports;
    }

    public void setTransports(Vector vector) {
        this.transports = vector;
    }

    public DynamicCacheConfig getDynamicCacheConfig() {
        return this.dynamicCacheConfig;
    }

    public void setDynamicCacheConfig(DynamicCacheConfig dynamicCacheConfig) {
        this.dynamicCacheConfig = dynamicCacheConfig;
    }

    public static WebContainerConfig getDefaultWebContainerConfig() {
        WebContainerConfig webContainerConfig = new WebContainerConfig();
        webContainerConfig.setSessionManagerConfig(SessionManagerConfig.getDefaultSessionManagerConfig());
        webContainerConfig.setThreadPoolConfig(ThreadPoolConfig.getDefaultThreadPoolConfig());
        Vector<HTTPTransportConfig> vector = new Vector<HTTPTransportConfig>(1);
        HTTPTransportConfig hTTPTransportConfig = HTTPTransportConfig.getDefaultHTTPTransportConfig();
        vector.addElement(hTTPTransportConfig);
        webContainerConfig.setTransports(vector);
        webContainerConfig.setDynamicCacheConfig(DynamicCacheConfig.getDefaultDynamicCacheConfig());
        return webContainerConfig;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        if (this.sessionMgrConfig != null) {
            ((Hashtable)properties).put(sessionMgrConfigPropKey, this.sessionMgrConfig);
        }
        if (this.threadPoolConfig != null) {
            ((Hashtable)properties).put(threadPoolConfigPropKey, this.threadPoolConfig);
        }
        if (this.transports != null) {
            ((Hashtable)properties).put(transportsPropKey, this.transports);
        }
        if (this.dynamicCacheConfig != null) {
            ((Hashtable)properties).put(dynamicCacheConfigPropKey, this.dynamicCacheConfig);
        }
        return properties;
    }

    public void fromProperties(Properties properties) {
        if (((Hashtable)properties).containsKey(sessionMgrConfigPropKey)) {
            this.sessionMgrConfig = (SessionManagerConfig)((Hashtable)properties).get(sessionMgrConfigPropKey);
        }
        if (((Hashtable)properties).containsKey(threadPoolConfigPropKey)) {
            this.threadPoolConfig = (ThreadPoolConfig)((Hashtable)properties).get(threadPoolConfigPropKey);
        }
        if (((Hashtable)properties).containsKey(transportsPropKey)) {
            this.transports = (Vector)((Hashtable)properties).get(transportsPropKey);
        }
        if (((Hashtable)properties).containsKey(dynamicCacheConfigPropKey)) {
            this.dynamicCacheConfig = (DynamicCacheConfig)((Hashtable)properties).get(dynamicCacheConfigPropKey);
        }
    }

    public String toString() {
        return ((Hashtable)this.toProperties()).toString();
    }

    public WebContainerConfig() {
    }

    public WebContainerConfig(WebContainerConfig webContainerConfig) {
        this();
        if (webContainerConfig != null) {
            this.sessionMgrConfig = webContainerConfig.sessionMgrConfig == null ? null : new SessionManagerConfig(webContainerConfig.sessionMgrConfig);
            this.threadPoolConfig = webContainerConfig.threadPoolConfig == null ? null : new ThreadPoolConfig(webContainerConfig.threadPoolConfig);
            this.dynamicCacheConfig = webContainerConfig.dynamicCacheConfig == null ? null : new DynamicCacheConfig(webContainerConfig.dynamicCacheConfig);
        }
    }

    public Vector retrieveCloneOnlyAttributeNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("Transports");
        vector.add("ThreadPoolConfig");
        return vector;
    }

    public Vector retrieveCloneOnlyAttributeGetters() {
        Vector<String> vector = new Vector<String>();
        vector.add("getTransports");
        vector.add("getThreadPoolConfig");
        return vector;
    }
}

