/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.datastore.deploy;

import com.ibm.isclite.datastore.deploy.UpdateNavigation;
import com.ibm.isclite.datastore.deploy.augvalidation.AugmentedValidationException;
import com.ibm.isclite.datastore.deploy.augvalidation.AugmentedValidationManager;
import com.ibm.isclite.deploy.helper.ComponentAlreadyExistsException;
import com.ibm.isclite.deploy.helper.ComponentRegistryException;
import com.ibm.isclite.deploy.helper.FailedPrereqException;
import com.ibm.isclite.deploy.helper.IscDeployCoreException;
import com.ibm.isclite.deploy.helper.NavTreeUpdateException;
import com.ibm.isclite.deploy.helper.PortletEntityRegistryException;
import com.ibm.isclite.wccm.navigation.NavElement;
import com.ibm.isclite.wccm.navigation.NavigationFactory;
import com.ibm.isclite.wccm.navigation.NavigationPackage;
import com.ibm.isclite.wccm.navigation.NavigationTree;
import com.ibm.isclite.wccm.navigation.NodeType;
import com.ibm.isclite.wccm.navigation.PageParams;
import com.ibm.isclite.wccm.navigation.impl.NavigationPackageImpl;
import com.ibm.isclite.wccm.navigation.util.NavigationResourceFactoryImpl;
import com.ibm.isclite.wccm.portletentities.AccessControl;
import com.ibm.isclite.wccm.portletentities.ApplicationDefinition;
import com.ibm.isclite.wccm.portletentities.IbmPortalportletEntities;
import com.ibm.isclite.wccm.portletentities.LinkType;
import com.ibm.isclite.wccm.portletentities.PortletDefinition;
import com.ibm.isclite.wccm.portletentities.PortletRefresh;
import com.ibm.isclite.wccm.portletentities.PortletWindowIdentifier;
import com.ibm.isclite.wccm.portletentities.PortletentitiesFactory;
import com.ibm.isclite.wccm.portletentities.PortletentitiesPackage;
import com.ibm.isclite.wccm.portletentities.RefreshMode;
import com.ibm.isclite.wccm.portletentities.Requires;
import com.ibm.isclite.wccm.portletentities.ResourceLink;
import com.ibm.isclite.wccm.portletentities.impl.PortletentitiesPackageImpl;
import com.ibm.isclite.wccm.preferences.idmap.Mappings;
import com.ibm.isclite.wccm.preferences.idmap.Module;
import com.ibm.isclite.wccm.registry.Component;
import com.ibm.isclite.wccm.registry.DocumentRoot;
import com.ibm.isclite.wccm.registry.PortletApplication;
import com.ibm.isclite.wccm.registry.Registry;
import com.ibm.isclite.wccm.registry.RegistryFactory;
import com.ibm.isclite.wccm.registry.RegistryPackage;
import com.ibm.isclite.wccm.registry.impl.RegistryPackageImpl;
import com.ibm.isclite.wccm.security.ApplicationRole;
import com.ibm.isclite.wccm.security.IbmPortalSecurity;
import com.ibm.isclite.wccm.security.PortalRole;
import com.ibm.isclite.wccm.security.impl.SecurityPackageImpl;
import com.ibm.isclite.wccm.topology.ComponentDefinition;
import com.ibm.isclite.wccm.topology.Container;
import com.ibm.isclite.wccm.topology.IbmPortalTopology;
import com.ibm.isclite.wccm.topology.LayoutElement;
import com.ibm.isclite.wccm.topology.NavigationContent;
import com.ibm.isclite.wccm.topology.NavigationElement;
import com.ibm.isclite.wccm.topology.ParentTree;
import com.ibm.isclite.wccm.topology.PortletDefinitionResourceLink;
import com.ibm.isclite.wccm.topology.PortletEntity;
import com.ibm.isclite.wccm.topology.RenderParam;
import com.ibm.isclite.wccm.topology.TaskType;
import com.ibm.isclite.wccm.topology.UrlLink;
import com.ibm.isclite.wccm.topology.Window;
import com.ibm.isclite.wccm.topology.impl.ApplicationDefinitionImpl;
import com.ibm.isclite.wccm.topology.impl.PortletDefinitionImpl;
import com.ibm.isclite.wccm.topology.impl.PortletEntityImpl;
import com.ibm.isclite.wccm.topology.impl.TopologyPackageImpl;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpdateNavigationImpl
implements UpdateNavigation {
    private static String CLASSNAME = "UpdateNavigationImpl";
    private static Logger logger = Logger.getLogger(UpdateNavigationImpl.class.getName());
    private NavigationFactory navFactory = null;
    private RegistryFactory registryFactory = null;
    private ResourceSetImpl resSet = null;
    private String baseURI;
    private String xmiFilePath;
    private IbmPortalTopology ibmPortalTopology;
    private IbmPortalSecurity ibmPortalSecurity;
    private Registry registry;
    private NavigationTree navTree;
    private boolean paaValidation = false;
    private PortletentitiesFactory prltEntitiesFactory = null;
    private IbmPortalportletEntities ibmPortalEntities;
    private HashMap PWIMap = new HashMap();

    public UpdateNavigationImpl() {
        this(".");
    }

    public UpdateNavigationImpl(String string) {
        Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;
        Map map = registry.getExtensionToFactoryMap();
        map.put("xml", new NavigationResourceFactoryImpl());
        TopologyPackageImpl.init();
        SecurityPackageImpl.init();
        NavigationPackageImpl.init();
        RegistryPackageImpl.init();
        PortletentitiesPackageImpl.init();
        this.resSet = new ResourceSetImpl();
        this.baseURI = string;
        EPackage.Registry registry2 = EPackage.Registry.INSTANCE;
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINE, CLASSNAME, "UpdateNavigationImpl", "registry.isEmpty()= " + registry2.isEmpty() + ", registry.keySet()= " + registry2.keySet());
        }
        NavigationPackage navigationPackage = (NavigationPackage)registry2.getEPackage("http://www.ibm.com/websphere/appserver/schemas/6.0/ibm-portal-navigation.xsd");
        this.navFactory = navigationPackage.getNavigationFactory();
        RegistryPackage registryPackage = (RegistryPackage)registry2.getEPackage("http://www.ibm.com/websphere/appserver/schemas/6.0/ibm-portal-registry.xsd");
        this.registryFactory = registryPackage.getRegistryFactory();
        PortletentitiesPackage portletentitiesPackage = (PortletentitiesPackage)registry2.getEPackage("http://www.ibm.com/websphere/appserver/schemas/6.0/ibm-portal-portletentities.xsd");
        this.prltEntitiesFactory = portletentitiesPackage.getPortletentitiesFactory();
    }

    public boolean isPAAValidator() {
        return this.paaValidation;
    }

    public void setPAAValidator(boolean bl) {
        this.paaValidation = bl;
    }

    public boolean addNode(String string, String string2, String string3) throws AugmentedValidationException, IscDeployCoreException, FailedPrereqException, ComponentAlreadyExistsException, ComponentRegistryException, NavTreeUpdateException, PortletEntityRegistryException {
        block28: {
            Object object;
            Object object2;
            Object object3;
            logger.entering(CLASSNAME, "addNode");
            Resource resource = null;
            Resource resource2 = null;
            Resource resource3 = null;
            Resource resource4 = null;
            Resource resource5 = null;
            this.xmiFilePath = string;
            String string4 = string3;
            String string5 = string + File.separator + "ibm-portal-topology.xml";
            String string6 = string + File.separator + "ibm-portal-security.xml";
            String string7 = string + File.separator + "portlet.xml";
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, "addNode", "topologyXMI :" + string5);
                logger.logp(Level.FINE, CLASSNAME, "addNode", "securityXMI :" + string6);
                logger.logp(Level.FINE, CLASSNAME, "addNode", "portletXMI :" + string7 + "for war name = " + string4);
            }
            URI uRI = URI.createFileURI((String)string5);
            URI uRI2 = URI.createFileURI((String)string6);
            String string8 = this.baseURI + File.separator + "components.xml";
            String string9 = this.baseURI + File.separator + "navigation.xml";
            URI uRI3 = URI.createFileURI((String)string8);
            URI uRI4 = URI.createFileURI((String)string9);
            try {
                resource3 = this.resSet.getResource(uRI3, true);
                resource4 = this.resSet.getResource(uRI4, true);
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLASSNAME, "addNode", "Components Registry does not exist. It will be created.");
            }
            String string10 = this.baseURI + File.separator + "portletEntities.xml";
            URI uRI5 = URI.createFileURI((String)string10);
            try {
                resource5 = this.resSet.getResource(uRI5, true);
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLASSNAME, "addNode", "PortletEntities Registry does not exist. It will be created.");
            }
            try {
                resource2 = this.resSet.getResource(uRI2, true);
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLASSNAME, "addNode", "ibm_portal_security.xml does not exist. ");
            }
            try {
                resource = this.resSet.getResource(uRI, true);
                if (resource3 == null) {
                    resource3 = this.resSet.createResource(uRI3);
                    object3 = this.registryFactory.createDocumentRoot();
                    resource3.getContents().add(object3);
                    object2 = this.registryFactory.createRegistry();
                    object3.setRegistry((Registry)object2);
                    resource3.save(new HashMap());
                }
                if (resource4 == null) {
                    resource4 = this.resSet.createResource(uRI4);
                    object3 = this.navFactory.createDocumentRoot();
                    object2 = this.navFactory.createNavigationTree();
                    object3.setNavigationTree((NavigationTree)object2);
                    resource4.getContents().add(object3);
                    resource4.save(new HashMap());
                }
                if (resource5 == null) {
                    resource5 = this.resSet.createResource(uRI5);
                    object3 = this.prltEntitiesFactory.createDocumentRoot();
                    object2 = this.prltEntitiesFactory.createIbmPortalportletEntities();
                    object3.setIbmPortalPortletentities((IbmPortalportletEntities)object2);
                    resource5.getContents().add(object3);
                    object = new HashMap<String, String>();
                    object.put("ENCODING", "UTF-8");
                    resource5.save((Map)object);
                }
            }
            catch (IOException iOException) {
                logger.logp(Level.SEVERE, CLASSNAME, "addNode", iOException.toString());
                logger.exiting(CLASSNAME, "addNode");
                throw new IscDeployCoreException(iOException);
            }
            object3 = (DocumentRoot)resource3.getContents().get(0);
            this.registry = object3.getRegistry();
            object2 = (com.ibm.isclite.wccm.navigation.DocumentRoot)resource4.getContents().get(0);
            this.navTree = object2.getNavigationTree();
            object = (com.ibm.isclite.wccm.topology.DocumentRoot)resource.getContents().get(0);
            this.ibmPortalTopology = object.getIbmPortalTopology();
            if (resource2 == null) {
                logger.logp(Level.WARNING, CLASSNAME, "addNode", "securityRes is null or not specified.");
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASSNAME, "addNode", "securityRes is specified = " + resource2);
                }
                com.ibm.isclite.wccm.security.DocumentRoot documentRoot = (com.ibm.isclite.wccm.security.DocumentRoot)resource2.getContents().get(0);
                this.ibmPortalSecurity = documentRoot.getIbmPortalSecurity();
            }
            com.ibm.isclite.wccm.portletentities.DocumentRoot documentRoot = (com.ibm.isclite.wccm.portletentities.DocumentRoot)resource5.getContents().get(0);
            this.ibmPortalEntities = documentRoot.getIbmPortalPortletentities();
            logger.logp(Level.WARNING, CLASSNAME, "addNode", "PAA Validation Option Request= " + this.isPAAValidator());
            if (this.isPAAValidator()) {
                try {
                    AugmentedValidationManager augmentedValidationManager = new AugmentedValidationManager();
                    if (!augmentedValidationManager.execAugmentedValidators(resource, this.ibmPortalTopology, resource4, resource3)) {
                        logger.logp(Level.WARNING, CLASSNAME, "addNode", "execAugmentedValidators failed.");
                        logger.exiting(CLASSNAME, "addNode");
                        return false;
                    }
                }
                catch (AugmentedValidationException augmentedValidationException) {
                    logger.logp(Level.WARNING, CLASSNAME, "addNode", "addToNavigation() failed.");
                    logger.exiting(CLASSNAME, "addNode");
                    throw new ComponentRegistryException("CLWAA10200E : Error registrying the application \"" + ((ApplicationDefinitionImpl)this.ibmPortalTopology.getApplicationDefinition().get(0)).getAppID() + "\".  Topology validation failed.", augmentedValidationException);
                }
            }
            try {
                if (this.addToComponentRegistry(resource, string7, resource3, string2, string4)) {
                    if (!this.addToNavigation(resource, resource4, resource2)) {
                        logger.logp(Level.WARNING, CLASSNAME, "addNode", "addToNavigation() failed");
                        logger.exiting(CLASSNAME, "addNode");
                        return false;
                    }
                    if (!this.addToPortletEntities(resource, resource2, resource5)) {
                        logger.logp(Level.WARNING, CLASSNAME, "addNode", "addToPortletEntities() failed");
                        logger.exiting(CLASSNAME, "addNode");
                        return false;
                    }
                    break block28;
                }
                logger.logp(Level.SEVERE, CLASSNAME, "addNode", "addToComponentRegistry() failed");
                logger.exiting(CLASSNAME, "addNode");
                return false;
            }
            catch (ComponentAlreadyExistsException componentAlreadyExistsException) {
                throw new ComponentAlreadyExistsException(componentAlreadyExistsException);
            }
            catch (ComponentRegistryException componentRegistryException) {
                throw new ComponentRegistryException(componentRegistryException);
            }
            catch (FailedPrereqException failedPrereqException) {
                throw new FailedPrereqException(failedPrereqException);
            }
            catch (NavTreeUpdateException navTreeUpdateException) {
                throw new FailedPrereqException(navTreeUpdateException);
            }
            catch (PortletEntityRegistryException portletEntityRegistryException) {
                throw new PortletEntityRegistryException(portletEntityRegistryException);
            }
        }
        logger.exiting(CLASSNAME, "addNode");
        return true;
    }

    private boolean addToPortletEntities(Resource resource, Resource resource2, Resource resource3) throws PortletEntityRegistryException, ComponentAlreadyExistsException {
        Object object;
        Object object2;
        Object object3;
        String string = "addToPortletEntities";
        logger.entering(CLASSNAME, string);
        ApplicationDefinition applicationDefinition = null;
        ApplicationDefinitionImpl applicationDefinitionImpl = (ApplicationDefinitionImpl)this.ibmPortalTopology.getApplicationDefinition().get(0);
        String string2 = applicationDefinitionImpl.getAppID();
        logger.logp(Level.FINE, CLASSNAME, string, "appDefId=" + string2);
        applicationDefinition = (ApplicationDefinition)resource3.getEObject(string2);
        if (applicationDefinition != null) {
            logger.logp(Level.WARNING, CLASSNAME, string, "CLWAA10205E : Error adding application to portletEntities.xml \"" + string2 + "\". It is already installed.");
            logger.exiting(CLASSNAME, string);
            throw new ComponentAlreadyExistsException("CLWAA10205E : Error adding application to portletEntities.xml \"" + string2 + "\". It is already installed.");
        }
        applicationDefinition = this.prltEntitiesFactory.createApplicationDefinition();
        logger.logp(Level.FINE, CLASSNAME, string, "Creating PortletEntities ApplicationDefinition for appDefId=" + string2);
        applicationDefinition.setAppID(applicationDefinitionImpl.getAppID());
        applicationDefinition.setVersion(applicationDefinitionImpl.getVersion());
        applicationDefinition.setTitle(applicationDefinitionImpl.getTitle());
        applicationDefinition.setDescription(applicationDefinitionImpl.getDescription());
        Requires requires = null;
        EList eList = applicationDefinitionImpl.getRequires();
        if (eList.size() > 0) {
            object3 = eList.iterator();
            while (object3.hasNext()) {
                object2 = (com.ibm.isclite.wccm.topology.Requires)object3.next();
                if (object2 == null) continue;
                logger.logp(Level.FINE, CLASSNAME, string, "Creating PortletEntities Requires using Topology Requires=" + object2.toString());
                requires = this.prltEntitiesFactory.createRequires();
                requires.setUniqueName(object2.getUniqueName());
                requires.setVersion(object2.getVersion());
                applicationDefinition.getRequires().add((Object)requires);
            }
        }
        object3 = applicationDefinitionImpl.getComponentTree();
        object2 = new HashMap();
        HashMap<String, com.ibm.isclite.wccm.portletentities.PortletEntity> hashMap = new HashMap<String, com.ibm.isclite.wccm.portletentities.PortletEntity>();
        PortletDefinition portletDefinition = null;
        ResourceLink resourceLink = null;
        com.ibm.isclite.wccm.portletentities.PortletEntity portletEntity = null;
        PortletDefinitionResourceLink portletDefinitionResourceLink = null;
        com.ibm.isclite.wccm.topology.PortletDefinition portletDefinition2 = null;
        PortletEntityImpl portletEntityImpl = null;
        if (object3 != null) {
            Object object4;
            Object e;
            object = object3.getAbstractComponentDefinition();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof PortletDefinitionImpl)) continue;
                portletDefinition2 = (com.ibm.isclite.wccm.topology.PortletDefinition)e;
                logger.logp(Level.FINE, CLASSNAME, string, "Creating Portlet-Definition in PortletEntities.xml using Topology Portlet-Definition=" + portletDefinition2.toString());
                portletDefinition = this.prltEntitiesFactory.createPortletDefinition();
                portletDefinition.setUniqueName(portletDefinition2.getUniqueName());
                portletDefinition.setTitle(portletDefinition2.getTitle());
                portletDefinition.setKeyword(portletDefinition2.getKeyword());
                portletDefinition.setDescription(portletDefinition2.getDescription());
                portletDefinitionResourceLink = portletDefinition2.getResourceLink();
                object4 = Integer.toString((portletDefinitionResourceLink.getName() + portletDefinitionResourceLink.getPortletApplication()).hashCode());
                resourceLink = (ResourceLink)resource3.getEObject((String)object4);
                if (resourceLink == null) {
                    logger.logp(Level.FINE, CLASSNAME, string, "Creating ResourceLink in PortletEntities, ResourceLink uniqueName=" + (String)object4);
                    resourceLink = this.prltEntitiesFactory.createResourceLink();
                    resourceLink.setUniqueName((String)object4);
                    resourceLink.setName(portletDefinitionResourceLink.getName());
                    resourceLink.setPortletApplication(portletDefinitionResourceLink.getPortletApplication());
                    if (portletDefinitionResourceLink.isSetType()) {
                        resourceLink.setType(LinkType.get(portletDefinitionResourceLink.getType().getValue()));
                    }
                    this.ibmPortalEntities.getResourceLink().add((Object)resourceLink);
                }
                portletDefinition.setResourceLinkRef(resourceLink);
                ((HashMap)object2).put(portletDefinition.getUniqueName(), portletDefinition);
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object5;
                e = iterator.next();
                if (!(e instanceof PortletEntityImpl)) continue;
                portletEntityImpl = (PortletEntityImpl)e;
                logger.logp(Level.FINE, CLASSNAME, string, "Creating Portlet-Entity in PortletEntities.xml using Topology Portlet-Entity=" + portletEntityImpl.toString());
                portletEntity = this.prltEntitiesFactory.createPortletEntity();
                portletEntity.setUniqueName(portletEntityImpl.getUniqueName());
                portletEntity.setTitle(portletEntityImpl.getTitle());
                portletEntity.setDescription(portletEntityImpl.getDescription());
                portletEntity.setKeyword(portletEntityImpl.getKeyword());
                object4 = this.getAccessControl(portletEntity.getUniqueName(), resource2);
                if (object4 != null) {
                    object5 = ((HashMap)object4).values().iterator();
                    while (object5.hasNext()) {
                        portletEntity.getAccessControl().add((Object)((AccessControl)object5.next()));
                    }
                }
                if ((object5 = (PortletDefinition)((HashMap)object2).get(portletEntityImpl.getPortletDefinitionRef().getUniqueName())) == null) {
                    logger.logp(Level.WARNING, CLASSNAME, string, "Cannot add Portlet-Entity '" + portletEntity.getUniqueName() + "' to Portlet-Definition as Portlet-Defnition is null.");
                }
                object5.getPortletEntity().add((Object)portletEntity);
                hashMap.put(portletEntity.getUniqueName(), portletEntity);
            }
            this.addPortletWindowIdentifier(resource3, hashMap, string2);
            iterator = ((HashMap)object2).values().iterator();
            while (iterator.hasNext()) {
                applicationDefinition.getPortletDefinition().add((Object)((PortletDefinition)iterator.next()));
            }
        }
        this.ibmPortalEntities.getApplicationDefinition().add((Object)applicationDefinition);
        try {
            object = new HashMap();
            object.put("ENCODING", "UTF-8");
            resource3.save((Map)object);
        }
        catch (IOException iOException) {
            logger.logp(Level.SEVERE, CLASSNAME, string, iOException.toString());
            logger.exiting(CLASSNAME, string);
            throw new PortletEntityRegistryException("CLWAA10205E : Error saving PortletEntities registry.", iOException);
        }
        logger.exiting(CLASSNAME, "addToComponentRegistry");
        return true;
    }

    private void addPortletWindowIdentifier(Resource resource, HashMap hashMap, String string) throws PortletEntityRegistryException {
        String string2 = "addPortletWindowIdentifier";
        NavigationElement navigationElement = null;
        EList eList = ((ApplicationDefinitionImpl)this.ibmPortalTopology.getApplicationDefinition().get(0)).getNavigationElement();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            navigationElement = (NavigationElement)iterator.next();
            if (navigationElement == null) continue;
            this.processNavigationElement4PortletEntities(resource, navigationElement, hashMap, string);
        }
        this.PWIMap.clear();
    }

    private void processNavigationElement4PortletEntities(Resource resource, NavigationElement navigationElement, HashMap hashMap, String string) {
        String string2 = "processNavigationElement4PortletEntities";
        logger.logp(Level.FINE, CLASSNAME, string2, "Processing NavigationElement= " + navigationElement.getUniqueName() + " to add PrtletWindowIdentifier to PortletEntities in portletEntities.xml.");
        NavigationElement navigationElement2 = null;
        this.processLayoutElement4PortletEntities(resource, navigationElement, hashMap, string);
        this.processNavigationContent4PortletEntities(resource, navigationElement, hashMap, string);
        EList eList = navigationElement.getNavigationElement();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            navigationElement2 = (NavigationElement)iterator.next();
            if (navigationElement2 == null) continue;
            this.processNavigationElement4PortletEntities(resource, navigationElement2, hashMap, string);
        }
    }

    private void processLayoutElement4PortletEntities(Resource resource, NavigationElement navigationElement, HashMap hashMap, String string) {
        String string2 = "processLayoutElement4PortletEntities";
        LayoutElement layoutElement = null;
        layoutElement = navigationElement.getLayoutElementRef();
        if (layoutElement != null) {
            logger.logp(Level.FINE, CLASSNAME, string2, "Processing LayoutElement= " + layoutElement.getUniqueName() + " to add PrtletWindowIdentifier to PortletEntities in portletEntities.xml.");
            Container container = layoutElement.getAbstractContainer();
            if (container != null) {
                this.processLayoutContainer4PortletEntities(resource, container, navigationElement, hashMap, string);
            }
        }
    }

    private void processLayoutContainer4PortletEntities(Resource resource, Container container, NavigationElement navigationElement, HashMap hashMap, String string) {
        Object object;
        String string2 = "processLayoutContainer4PortletEntities";
        if (container == null) {
            return;
        }
        logger.logp(Level.FINE, CLASSNAME, string2, "Processing LayoutContainer= " + container.getUniqueName() + " to add PrtletWindowIdentifier to PortletEntities in portletEntities.xml.");
        String string3 = null;
        String string4 = null;
        PortletWindowIdentifier portletWindowIdentifier = null;
        com.ibm.isclite.wccm.topology.PortletRefresh portletRefresh = null;
        ComponentDefinition componentDefinition = null;
        com.ibm.isclite.wccm.portletentities.PortletEntity portletEntity = null;
        EList eList = container.getWindow();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            object = (Window)iterator.next();
            if (object == null || (componentDefinition = object.getComponentDefinitionRef()) == null) continue;
            portletEntity = (com.ibm.isclite.wccm.portletentities.PortletEntity)hashMap.get(componentDefinition.getUniqueName());
            if (portletEntity == null) {
                logger.logp(Level.WARNING, CLASSNAME, string2, "Skiping processing of adding PortletWindowIdentifier for Window '" + object.getUniqueName() + "' and ComponentRef '" + componentDefinition.getUniqueName() + "' as was not able to find PortletEntites in HashMap.");
                continue;
            }
            string3 = string + "-SPSVS-" + navigationElement.getUniqueName() + "-SPSVS-" + navigationElement.getLayoutElementRef().getUniqueName() + "-SPSVS-" + object.getUniqueName();
            string4 = String.valueOf(string3.hashCode());
            portletWindowIdentifier = (PortletWindowIdentifier)this.PWIMap.get(string4);
            if (portletWindowIdentifier == null) {
                portletWindowIdentifier = this.prltEntitiesFactory.createPortletWindowIdentifier();
                logger.logp(Level.FINE, CLASSNAME, string2, "Creating PortletWindowIdentifier uniqueName= " + string3 + " for Portlet-Entity= " + portletEntity.getUniqueName());
                portletWindowIdentifier.setUniqueName(string4);
                this.PWIMap.put(string4, portletWindowIdentifier);
            }
            if ((portletRefresh = object.getPortletRefresh()) != null) {
                logger.logp(Level.FINE, CLASSNAME, string2, "Found Portletrefresh settings in Window= " + object.getUniqueName() + " and Portlet-Entity= " + portletEntity.getUniqueName());
                portletWindowIdentifier.setPortletRefresh(this.createPortletEntitiesPortletRefresh(portletRefresh));
            }
            portletEntity.getPortletWindowIdentifier().add((Object)portletWindowIdentifier);
        }
        iterator = container.getAbstractContainer();
        object = iterator.iterator();
        while (object.hasNext()) {
            Container container2 = (Container)object.next();
            if (container2 == null) continue;
            this.processLayoutContainer4PortletEntities(resource, container2, navigationElement, hashMap, string);
        }
    }

    private void processNavigationContent4PortletEntities(Resource resource, NavigationElement navigationElement, HashMap hashMap, String string) {
        String string2 = "processNavigationContent4PortletEntities";
        NavigationContent navigationContent = null;
        Window window = null;
        com.ibm.isclite.wccm.topology.PortletRefresh portletRefresh = null;
        com.ibm.isclite.wccm.portletentities.PortletEntity portletEntity = null;
        ComponentDefinition componentDefinition = null;
        PortletWindowIdentifier portletWindowIdentifier = null;
        String string3 = null;
        String string4 = null;
        EList eList = navigationElement.getNavigationContent();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            navigationContent = (NavigationContent)iterator.next();
            if (navigationContent == null) continue;
            logger.logp(Level.FINE, CLASSNAME, string2, "Found NavigationContent= " + navigationContent.getUniqueName());
            componentDefinition = navigationContent.getComponentDefinitionRef();
            portletEntity = (com.ibm.isclite.wccm.portletentities.PortletEntity)hashMap.get(componentDefinition.getUniqueName());
            if (portletEntity == null) {
                logger.logp(Level.WARNING, CLASSNAME, string2, "Skiping processing of adding PortletWindowIdentifier for NAvigationContent '" + navigationContent.getUniqueName() + "' and ComponentRef '" + componentDefinition.getUniqueName() + "' as was not able to find PortletEntites in HashMap.");
                continue;
            }
            window = navigationContent.getWindowRef();
            if (window == null) {
                logger.logp(Level.FINE, CLASSNAME, string2, "Cannot add PortletWindowIdentifier to Portlet-Entity '" + portletEntity.getUniqueName() + "' in PortletEntites.xml as Window object for NavigationContent '" + navigationContent.getUniqueName() + "' is null.");
                continue;
            }
            string3 = string + "-SPSVS-" + navigationElement.getUniqueName() + "-SPSVS-" + navigationElement.getLayoutElementRef().getUniqueName() + "-SPSVS-" + window.getUniqueName();
            string4 = String.valueOf(string3.hashCode());
            portletWindowIdentifier = (PortletWindowIdentifier)this.PWIMap.get(string4);
            if (portletWindowIdentifier == null) {
                portletWindowIdentifier = this.prltEntitiesFactory.createPortletWindowIdentifier();
                logger.logp(Level.FINE, CLASSNAME, string2, "Creating PortletWindowIdentifier uniqueName= " + string3 + " for Portlet-Entity= " + portletEntity.getUniqueName());
                portletWindowIdentifier.setUniqueName(string4);
                this.PWIMap.put(string4, portletWindowIdentifier);
            }
            if ((portletRefresh = navigationContent.getPortletRefresh()) != null) {
                logger.logp(Level.FINE, CLASSNAME, string2, "Found Portletrefresh settings in NavigationContent= " + navigationContent.getUniqueName() + " and Portlet-Entity= " + portletEntity.getUniqueName());
                portletWindowIdentifier.setPortletRefresh(this.createPortletEntitiesPortletRefresh(portletRefresh));
            }
            portletEntity.getPortletWindowIdentifier().add((Object)portletWindowIdentifier);
        }
    }

    private PortletRefresh createPortletEntitiesPortletRefresh(com.ibm.isclite.wccm.topology.PortletRefresh portletRefresh) {
        String string = "createPortletEntitiesPortletRefresh";
        logger.logp(Level.FINE, CLASSNAME, string, "Creating PortletEntities Portletrefresh using Topology PortletRefresh topoPortletRefresh= " + portletRefresh.toString());
        PortletRefresh portletRefresh2 = null;
        portletRefresh2 = this.prltEntitiesFactory.createPortletRefresh();
        portletRefresh2.setRefreshMode(RefreshMode.get(portletRefresh.getRefreshMode().getValue()));
        portletRefresh2.setRefreshInterval(portletRefresh.getRefreshInterval());
        if (portletRefresh.isSetShowTimer()) {
            portletRefresh2.setShowTimer(portletRefresh.isShowTimer());
        }
        portletRefresh2.setThreshold(portletRefresh.getThreshold());
        if (portletRefresh.isSetUserConfigurable()) {
            portletRefresh2.setUserConfigurable(portletRefresh.isUserConfigurable());
        }
        return portletRefresh2;
    }

    private HashMap getAccessControl(String string, Resource resource) {
        String string2 = "getAccessControl";
        logger.entering(CLASSNAME, string2);
        HashMap<String, AccessControl> hashMap = new HashMap<String, AccessControl>();
        AccessControl accessControl = null;
        if (resource == null) {
            return null;
        }
        EList eList = this.ibmPortalSecurity.getApplicationRole();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ApplicationRole applicationRole = (ApplicationRole)iterator.next();
            EList eList2 = applicationRole.getPortalRole();
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                PortalRole portalRole = (PortalRole)iterator2.next();
                if (!portalRole.getObjectRef().equals(string)) continue;
                accessControl = (AccessControl)hashMap.get(applicationRole.getUniqueName());
                if (accessControl != null && accessControl.getRoleType() != null && accessControl.getRoleType().length() > 0) {
                    accessControl.setRoleType(accessControl.getRoleType() + "," + portalRole.getRoleType());
                } else {
                    accessControl = this.prltEntitiesFactory.createAccessControl();
                    accessControl.setApplicationRole(applicationRole.getUniqueName());
                    accessControl.setRoleType(portalRole.getRoleType());
                }
                hashMap.put(accessControl.getApplicationRole(), accessControl);
            }
        }
        logger.logp(Level.FINE, CLASSNAME, string2, "Adding '" + hashMap.size() + "' Access-Control for Portlet-Entity '" + string + "'");
        logger.exiting(CLASSNAME, string2);
        return hashMap;
    }

    private boolean addToComponentRegistry(Resource resource, String string, Resource resource2, String string2, String string3) throws IscDeployCoreException, ComponentAlreadyExistsException, FailedPrereqException, ComponentRegistryException {
        logger.entering(CLASSNAME, "addToComponentRegistry");
        Component component = this.registryFactory.createComponent();
        String string4 = ((ApplicationDefinitionImpl)this.ibmPortalTopology.getApplicationDefinition().get(0)).getAppID();
        logger.logp(Level.FINE, CLASSNAME, "addToComponentRegistry", "CompID=" + string4);
        Component component2 = (Component)resource2.getEObject(string4);
        if (component2 != null) {
            logger.logp(Level.WARNING, CLASSNAME, "addToComponentRegistry", "CLWAA10201E : Error registering application \"" + string4 + "\". It is already installed.");
            logger.exiting(CLASSNAME, "addToComponentRegistry");
            throw new ComponentAlreadyExistsException("CLWAA10201E : Error registering the application \"" + string4 + "\". It is already installed.");
        }
        try {
            if (!this.checkDependency(resource2)) {
                logger.exiting(CLASSNAME, "addToComponentRegistry");
                return false;
            }
        }
        catch (FailedPrereqException failedPrereqException) {
            throw new FailedPrereqException(failedPrereqException);
        }
        component.setId(string4);
        component.setTitle(((ApplicationDefinitionImpl)this.ibmPortalTopology.getApplicationDefinition().get(0)).getTitle());
        component.setVersion(((ApplicationDefinitionImpl)this.ibmPortalTopology.getApplicationDefinition().get(0)).getVersion());
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, "addToComponentRegistry", component + ", prereqList= " + ((ApplicationDefinitionImpl)this.ibmPortalTopology.getApplicationDefinition().get(0)).getRequires());
        }
        String string5 = this.getPortletAppIDfromPortletDescriptor(string);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, "addToComponentRegistry", ".addToComponentRegistry: portletApplication portletAppID=" + string5 + "war name=" + string3);
        }
        PortletApplication portletApplication = null;
        if (string5 != null) {
            portletApplication = this.registryFactory.createPortletApplication();
            portletApplication.setId(string5);
            portletApplication.setName(string3);
        }
        if (this.ibmPortalTopology.getAboutPage() != null) {
            component.setAboutPage(this.ibmPortalTopology.getAboutPage().trim());
        } else if (this.ibmPortalTopology.getPAARef() != null) {
            component.setPAARef(this.ibmPortalTopology.getPAARef());
        }
        String string6 = string2 != null ? string2 : this.getContextPath();
        component.setContextRoot(string6);
        this.registry.getComponent().add((Object)component);
        this.registry.getComponent().add((Object)component);
        if (portletApplication != null && string5 != null) {
            component.getPortletApplication().add((Object)portletApplication);
        }
        try {
            resource2.save(new HashMap());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            logger.logp(Level.SEVERE, CLASSNAME, "addToComponentRegistry", iOException.toString());
            logger.exiting(CLASSNAME, "addToComponentRegistry");
            throw new ComponentRegistryException("CLWAA10203E : Error saving componets registery.", iOException);
        }
        logger.exiting(CLASSNAME, "addToComponentRegistry");
        return true;
    }

    private String getPortletAppIDfromPortletDescriptor(String string) {
        String string2 = "getPortletAppIDfromPortletDescriptor";
        logger.exiting(CLASSNAME, string2);
        String string3 = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new File(string));
            NodeList nodeList = document.getElementsByTagName("portlet-app");
            int n = nodeList.getLength();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                string3 = element.getAttribute("id");
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, CLASSNAME, "getPortletAppIDfromPortletDescriptor", "portletAppID=" + string3);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            logger.logp(Level.WARNING, CLASSNAME, "getPortletAppIDfromPortletDescriptor", "IO Error (Expected if re-using an existing portlet):" + iOException.getMessage());
        }
        return string3;
    }

    private boolean checkDependency(Resource resource) throws FailedPrereqException {
        logger.entering(CLASSNAME, "checkDependency");
        EList eList = ((ApplicationDefinitionImpl)this.ibmPortalTopology.getApplicationDefinition().get(0)).getRequires();
        Component component = null;
        StringBuffer stringBuffer = new StringBuffer(" ");
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            com.ibm.isclite.wccm.topology.Requires requires = (com.ibm.isclite.wccm.topology.Requires)iterator.next();
            String string = requires.getUniqueName();
            component = (Component)resource.getEObject(string);
            if (component == null) {
                logger.logp(Level.WARNING, CLASSNAME, "checkDependency", "Required module " + string + " is not installed yet");
                stringBuffer.append(", ");
                stringBuffer.append(string);
            }
            if (null != component && !component.getVersion().equals(requires.getVersion())) {
                logger.logp(Level.WARNING, CLASSNAME, "checkDependency", "Dependency check failed. Required version \"" + requires.getVersion() + "\" of the module \"" + string + "\" is not installed yet!");
                stringBuffer.append(", ");
                stringBuffer.append(component);
                stringBuffer.append(" v");
                stringBuffer.append(component.getVersion());
            }
            if (stringBuffer.length() > 1) continue;
            com.ibm.isclite.wccm.registry.Requires requires2 = this.registryFactory.createRequires();
            requires2.setUniqueName(((ApplicationDefinitionImpl)this.ibmPortalTopology.getApplicationDefinition().get(0)).getAppID());
            requires2.setVersion(((ApplicationDefinitionImpl)this.ibmPortalTopology.getApplicationDefinition().get(0)).getVersion());
            EList eList2 = component.getRequires();
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, "checkDependency", "required module= " + component + " required module.getRequires()= " + eList2.toString());
            }
            boolean bl = false;
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                com.ibm.isclite.wccm.registry.Requires requires3 = (com.ibm.isclite.wccm.registry.Requires)iterator2.next();
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASSNAME, "checkDependency", "required module name= " + requires3.getUniqueName());
                }
                if (!requires3.getUniqueName().equals(requires2.getUniqueName()) || !requires3.getVersion().equals(requires2.getVersion())) continue;
                bl = true;
                break;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, "checkDependency", "doesContain= " + bl);
            }
            if (!bl) {
                component.getRequires().add((Object)requires2);
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.logp(Level.FINE, CLASSNAME, "checkDependency", "module.getRequires() after requires element added = " + component.getRequires());
        }
        if (stringBuffer.length() > 1) {
            throw new FailedPrereqException("CLWAA10202E : Application \"" + ((ApplicationDefinitionImpl)this.ibmPortalTopology.getApplicationDefinition().get(0)).getAppID() + "\" deployment failed. The prerequisite components " + stringBuffer.toString() + " not installed.");
        }
        return true;
    }

    private String getContextPath() {
        int n = this.xmiFilePath.indexOf("cells");
        String string = this.xmiFilePath.substring(n);
        return string;
    }

    private boolean addToNavigation(Resource resource, Resource resource2, Resource resource3) throws NavTreeUpdateException {
        Object object;
        Object object2;
        Object object3;
        logger.entering(CLASSNAME, "addToNavigation");
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        String string = ((ApplicationDefinitionImpl)this.ibmPortalTopology.getApplicationDefinition().get(0)).getAppID();
        String string2 = "";
        EList eList = ((ApplicationDefinitionImpl)this.ibmPortalTopology.getApplicationDefinition().get(0)).getNavigationElement();
        Object object4 = eList.iterator();
        while (object4.hasNext()) {
            object3 = (NavigationElement)object4.next();
            object2 = this.createNavElement((NavigationElement)object3, string);
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, "addtoNavigation", "navElement created = " + object2);
            }
            object = this.checkForParent(resource2, (NavigationElement)object3, string);
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, "addtoNavigation", "parent= " + object);
            }
            string2 = this.checkSecurityDeploytime(object3.getUniqueName(), resource3);
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, "addtoNavigation", "roleList= " + string2);
            }
            if (object != null) {
                if (!string2.equals("")) {
                    object2.setIsWscNode(false);
                    object2.setWscRole(string2);
                }
                object.getNavElement().add(object2);
            } else {
                if (!string2.equals("")) {
                    object2.setIsWscNode(false);
                    object2.setWscRole(string2);
                }
                this.navTree.getNavElement().add(object2);
            }
            if (object3.getNavigationElement().size() <= 0) continue;
            vector2.add(object3);
            vector.add(object2);
        }
        while (vector2.size() > 0) {
            object4 = (NavigationElement)vector2.get(0);
            object3 = (NavElement)vector.get(0);
            eList = object4.getNavigationElement();
            object2 = eList.iterator();
            while (object2.hasNext()) {
                object = (NavigationElement)object2.next();
                NavElement navElement = this.createNavElement((NavigationElement)object, string);
                NavElement navElement2 = this.checkForParent(resource2, (NavigationElement)object, string);
                string2 = this.checkSecurityDeploytime(object.getUniqueName(), resource3);
                if (navElement2 != null) {
                    if (!string2.equals("")) {
                        navElement.setIsWscNode(false);
                        navElement.setWscRole(string2);
                    }
                    navElement2.getNavElement().add((Object)navElement);
                } else {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASSNAME, "addToNavigation", " --->addtoNavigation: newNavElement= " + navElement.toString() + ", roleList= " + string2);
                    }
                    if (!string2.equals("")) {
                        navElement.setIsWscNode(false);
                        navElement.setWscRole(string2);
                    }
                    object3.getNavElement().add((Object)navElement);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASSNAME, "addToNavigation", "addtoNavigation: navigationElement.getNavigationElement().size()= " + object.getNavigationElement().size());
                }
                if (object.getNavigationElement().size() <= 0) continue;
                vector2.add(object);
                vector.add(navElement);
            }
            vector2.remove(0);
            vector.remove(0);
        }
        try {
            resource2.save(new HashMap());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            logger.logp(Level.SEVERE, CLASSNAME, "addToNavigation", iOException.toString());
            logger.exiting(CLASSNAME, "addToNavigation");
            throw new NavTreeUpdateException("CLWAA10204E : Error saving Navigation registery.", iOException);
        }
        logger.exiting(CLASSNAME, "addToNavigation");
        return true;
    }

    private String checkSecurityDeploytime(String string, Resource resource) {
        logger.entering(CLASSNAME, "checkSecurityDeploytime");
        String string2 = "";
        if (resource == null) {
            return string2;
        }
        EList eList = this.ibmPortalSecurity.getApplicationRole();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ApplicationRole applicationRole = (ApplicationRole)iterator.next();
            EList eList2 = applicationRole.getPortalRole();
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                PortalRole portalRole = (PortalRole)iterator2.next();
                String string3 = portalRole.getObjectRef();
                if (!string3.equalsIgnoreCase(string)) continue;
                if (string2.equals("")) {
                    string2 = string2 + applicationRole.getUniqueName();
                    continue;
                }
                string2 = string2 + "," + applicationRole.getUniqueName();
            }
        }
        logger.logp(Level.FINE, CLASSNAME, "checkSecurityDeploytime", "AppRoleList is= " + string2);
        logger.exiting(CLASSNAME, "checkSecurityDeploytime");
        return string2;
    }

    private NavElement checkForParent(Resource resource, NavigationElement navigationElement, String string) {
        ParentTree parentTree = navigationElement.getParentTree();
        if (parentTree == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, "checkForParent", "Parent is null");
            }
            return null;
        }
        String string2 = parentTree.getParentTreeRef();
        if (string2 == null || string2.equals("")) {
            logger.logp(Level.FINE, CLASSNAME, "checkForParent", "ParentTreeRef is an empty string.");
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        if (stringTokenizer.countTokens() == 2) {
            string = stringTokenizer.nextToken();
        }
        String string3 = stringTokenizer.nextToken();
        String string4 = string + "-SPSVS-" + string3;
        NavElement navElement = (NavElement)resource.getEObject(string4);
        return navElement;
    }

    private NavElement createNavElement(NavigationElement navigationElement, String string) {
        String string2;
        Object object;
        Object object2;
        ComponentDefinition componentDefinition;
        Object object3;
        Object object4;
        Object object5;
        logger.entering(CLASSNAME, "createNavElement");
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, "createNavElement", "navigationElement= " + navigationElement.getUniqueName() + ", moduleID= " + string);
        }
        NavElement navElement = this.navFactory.createNavElement();
        navElement.setUniqueName(string + "-SPSVS-" + navigationElement.getUniqueName());
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, "createNavElement", "navElement.getUniqueName= " + navElement.getUniqueName());
        }
        navElement.setModuleID(string);
        navElement.setTitle(navigationElement.getTitle());
        navElement.setDescription(navigationElement.getDescription());
        if (navigationElement.isSetHidden()) {
            navElement.setHidden(navigationElement.isHidden());
        }
        if (navigationElement.isFormPersistence()) {
            navElement.setFormPersistence(navigationElement.isFormPersistence());
        }
        ParentTree parentTree = navigationElement.getParentTree();
        com.ibm.isclite.wccm.navigation.ParentTree parentTree2 = null;
        if (parentTree != null) {
            parentTree2 = navElement.getParentTree();
            if (parentTree2 == null) {
                parentTree2 = this.navFactory.createParentTree();
            }
            parentTree2.setParentTreeRef(parentTree.getParentTreeRef());
            parentTree2.setOrdinal(parentTree.getOrdinal());
        }
        navElement.setParentTree(parentTree2);
        navElement.getParameter().addAll((Collection)navigationElement.getPreference());
        LayoutElement layoutElement = navigationElement.getLayoutElementRef();
        if (layoutElement != null) {
            navElement.setLayoutElementRef(layoutElement.getUniqueName());
            navElement.setNodeType(NodeType.PAGE_LITERAL);
            if (navigationElement.isSetTaskType() && (object5 = navigationElement.getTaskType()) != null) {
                navElement.setTaskType(com.ibm.isclite.wccm.navigation.TaskType.get(object5.getValue()));
                if (object5.getName().equals(TaskType.MODAL_TASK_LITERAL.toString())) {
                    navElement.setHidden(true);
                }
            }
            object5 = navigationElement.getPageParams();
            object4 = null;
            if (object5 != null) {
                object4 = navElement.getPageParams();
                if (object4 == null) {
                    object4 = this.navFactory.createPageParams();
                }
                object3 = null;
                componentDefinition = object5.getRenderParam();
                if (componentDefinition.size() > 0) {
                    object2 = componentDefinition.iterator();
                    while (object2.hasNext()) {
                        object = (RenderParam)object2.next();
                        if (object == null) continue;
                        object3 = this.navFactory.createRenderParam();
                        object3.setName(object.getName());
                        object3.setValue(object.getValue());
                        object4.getRenderParam().add(object3);
                    }
                }
                if ((object2 = object5.getPageHeader()).size() > 0) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        string2 = (String)object.next();
                        if (string2 == null || string2.equals("")) continue;
                        object4.getPageHeader().add((Object)string2);
                    }
                }
                if (object4.getRenderParam().size() > 0 || object4.getPageHeader().size() > 0) {
                    navElement.setPageParams((PageParams)object4);
                }
            }
        }
        if ((object5 = navigationElement.getNavigationContent()).size() > 0) {
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (NavigationContent)object4.next();
                if (object3.getWindowRef() != null) continue;
                componentDefinition = object3.getComponentDefinitionRef();
                if (componentDefinition instanceof com.ibm.isclite.wccm.topology.PortletDefinition) {
                    object2 = ((com.ibm.isclite.wccm.topology.PortletDefinition)componentDefinition).getResourceLink();
                    object = object2.getName();
                    string2 = ((PortletDefinitionResourceLink)object2).getPortletApplication();
                    if (string2 != null) {
                        navElement.setUniqueName((String)object + "-SPSVS-" + string2);
                    } else {
                        navElement.setUniqueName((String)object);
                    }
                    navElement.setNodeType(NodeType.PAGE_LITERAL);
                } else if (componentDefinition instanceof PortletEntity) {
                    object2 = ((PortletEntity)componentDefinition).getPortletDefinitionRef();
                    object = object2.getResourceLink();
                    string2 = ((PortletDefinitionResourceLink)object).getName();
                    String string3 = ((PortletDefinitionResourceLink)object).getPortletApplication();
                    if (string3 != null) {
                        navElement.setUniqueName(string2 + "-SPSVS-" + string3);
                    } else {
                        navElement.setUniqueName(string2);
                    }
                    navElement.setNodeType(NodeType.PAGE_LITERAL);
                } else {
                    if (!(componentDefinition instanceof UrlLink)) continue;
                    navElement.setUniqueName(((UrlLink)componentDefinition).getUniqueName());
                    navElement.setUrl(((UrlLink)componentDefinition).getUrl());
                    navElement.setNodeType(NodeType.URL_LITERAL);
                }
                break;
            }
        } else if (null == layoutElement) {
            navElement.setNodeType(NodeType.LABEL_LITERAL);
        }
        logger.exiting(CLASSNAME, "createNavElement");
        return navElement;
    }

    public boolean removeNode(String string) throws IscDeployCoreException, NavTreeUpdateException, PortletEntityRegistryException {
        Object object;
        String string2;
        Resource resource;
        Resource resource2;
        block24: {
            logger.entering(CLASSNAME, "removeNode");
            Resource resource3 = null;
            resource2 = null;
            Resource resource4 = null;
            Resource resource5 = null;
            resource = null;
            String string3 = string + File.separator + "ibm-portal-topology.xml";
            String string4 = this.baseURI + File.separator + "components.xml";
            String string5 = this.baseURI + File.separator + "navigation.xml";
            String string6 = this.baseURI + File.separator + "idmap.xml";
            String string7 = this.baseURI + File.separator + "portletEntities.xml";
            URI uRI = URI.createFileURI((String)string3);
            URI uRI2 = URI.createFileURI((String)string4);
            URI uRI3 = URI.createFileURI((String)string5);
            URI uRI4 = URI.createFileURI((String)string6);
            URI uRI5 = URI.createFileURI((String)string7);
            try {
                resource4 = this.resSet.getResource(uRI, true);
                resource3 = this.resSet.getResource(uRI2, true);
                resource2 = this.resSet.getResource(uRI3, true);
                resource5 = this.resSet.getResource(uRI4, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.logp(Level.FINE, CLASSNAME, "removeNode", exception.toString());
                logger.exiting(CLASSNAME, "removeNode");
                throw new IscDeployCoreException(exception);
            }
            try {
                resource = this.resSet.getResource(uRI5, true);
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLASSNAME, "removeNode", "portletEntities.xml does not exist as no new ISC module were deployed after Component Pack install. - " + exception.toString());
            }
            com.ibm.isclite.wccm.topology.DocumentRoot documentRoot = (com.ibm.isclite.wccm.topology.DocumentRoot)resource4.getContents().get(0);
            this.ibmPortalTopology = documentRoot.getIbmPortalTopology();
            string2 = ((ApplicationDefinitionImpl)this.ibmPortalTopology.getApplicationDefinition().get(0)).getAppID();
            if (resource3 != null) {
                object = (DocumentRoot)resource3.getContents().get(0);
                this.registry = object.getRegistry();
                try {
                    if (this.removeFromComponentRegistry(string2, resource3)) {
                        if (resource5 != null) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASSNAME, "removeNode", "updateNavigation undeploy removeformidmap() start");
                            }
                            com.ibm.isclite.wccm.preferences.idmap.DocumentRoot documentRoot2 = (com.ibm.isclite.wccm.preferences.idmap.DocumentRoot)resource5.getContents().get(0);
                            Mappings mappings = documentRoot2.getMappings();
                            if (!this.removeFromIdmap(string2, resource5)) {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASSNAME, "removeNode", "removeFrom IDMAPRegistry() failed");
                                }
                                logger.exiting(CLASSNAME, "removeNode");
                            }
                        }
                        break block24;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASSNAME, "removeNode", "removeFromComponentRegistry() failed");
                    }
                    logger.exiting(CLASSNAME, "removeNode");
                    return false;
                }
                catch (IscDeployCoreException iscDeployCoreException) {
                    throw new IscDeployCoreException(iscDeployCoreException);
                }
                catch (ComponentRegistryException componentRegistryException) {
                    throw new IscDeployCoreException(componentRegistryException);
                }
            }
        }
        if (resource2 != null) {
            object = (com.ibm.isclite.wccm.navigation.DocumentRoot)resource2.getContents().get(0);
            this.navTree = object.getNavigationTree();
            try {
                if (!this.removeFromNavigation(string2, resource2)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASSNAME, "removeNode", "removeFromNavigation() failed");
                    }
                    logger.exiting(CLASSNAME, "removeNode");
                    return false;
                }
            }
            catch (NavTreeUpdateException navTreeUpdateException) {
                throw new NavTreeUpdateException(navTreeUpdateException);
            }
        }
        if (resource != null) {
            object = (com.ibm.isclite.wccm.portletentities.DocumentRoot)resource.getContents().get(0);
            this.ibmPortalEntities = object.getIbmPortalPortletentities();
            try {
                if (!this.removeFromPortletEntities(string2, resource)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASSNAME, "removeNode", "removeFromPortletEntities() failed");
                    }
                    logger.exiting(CLASSNAME, "removeNode");
                    return false;
                }
            }
            catch (PortletEntityRegistryException portletEntityRegistryException) {
                throw new PortletEntityRegistryException(portletEntityRegistryException);
            }
        }
        logger.exiting(CLASSNAME, "removeNode");
        return true;
    }

    private boolean removeFromPortletEntities(String string, Resource resource) throws PortletEntityRegistryException {
        String string2 = "removeFromPortletEntities";
        logger.entering(CLASSNAME, string2);
        ApplicationDefinition applicationDefinition = (ApplicationDefinition)resource.getEObject(string);
        if (applicationDefinition == null) {
            logger.logp(Level.WARNING, CLASSNAME, string2, string + " does not exist in the portletEntities registry.");
            logger.exiting(CLASSNAME, string2);
            return true;
        }
        EList eList = applicationDefinition.getPortletDefinition();
        Object object = eList.iterator();
        while (object.hasNext()) {
            PortletDefinition portletDefinition = (PortletDefinition)object.next();
            ResourceLink resourceLink = portletDefinition.getResourceLinkRef();
            if (resourceLink == null || !this.canResourceLinkBeRemoved(resource, string, resourceLink.getUniqueName())) continue;
            EcoreUtil.remove((EObject)resourceLink);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, string2, "Attempting to remove application \"" + applicationDefinition.getAppID() + "\" from the portletEntities registry.");
        }
        EcoreUtil.remove((EObject)applicationDefinition);
        try {
            object = new HashMap();
            object.put("ENCODING", "UTF-8");
            resource.save((Map)object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            logger.logp(Level.SEVERE, CLASSNAME, string2, iOException.toString());
            logger.exiting(CLASSNAME, string2);
            throw new PortletEntityRegistryException("CLWAA10205E : Error removing module\"" + applicationDefinition.getAppID() + "\" from the portletEntities registry.", iOException);
        }
        logger.exiting(CLASSNAME, string2);
        return true;
    }

    private boolean canResourceLinkBeRemoved(Resource resource, String string, String string2) {
        boolean bl = true;
        EList eList = this.ibmPortalEntities.getApplicationDefinition();
        Iterator iterator = eList.iterator();
        block0: while (iterator.hasNext()) {
            ApplicationDefinition applicationDefinition = (ApplicationDefinition)iterator.next();
            if (applicationDefinition == null || applicationDefinition.getAppID().equals(string)) continue;
            EList eList2 = applicationDefinition.getPortletDefinition();
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                PortletDefinition portletDefinition = (PortletDefinition)iterator2.next();
                if (portletDefinition == null || !string2.equals(portletDefinition.getResourceLinkRef().getUniqueName())) continue;
                bl = false;
                continue block0;
            }
        }
        return bl;
    }

    private boolean removeFromComponentRegistry(String string, Resource resource) throws IscDeployCoreException, ComponentRegistryException {
        logger.entering(CLASSNAME, "removeFromComponentRegistry");
        Component component = (Component)resource.getEObject(string);
        if (component == null) {
            logger.logp(Level.WARNING, CLASSNAME, "removeFromComponentRegistry", string + " does not exist in the registry");
            logger.exiting(CLASSNAME, "removeFromComponentRegistry");
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, "removeFromComponentRegistry", "Attempting to remove application \"" + component.getId() + "\".");
        }
        EList eList = component.getRequires();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            com.ibm.isclite.wccm.registry.Requires requires = (com.ibm.isclite.wccm.registry.Requires)iterator.next();
            String string2 = requires.getUniqueName();
            Component component2 = (Component)resource.getEObject(string2);
            if (component2 == null || !component2.getVersion().equals(requires.getVersion())) continue;
            logger.logp(Level.WARNING, CLASSNAME, "removeFromComponentRegistry", "CWLAA10206E : Application \"" + component.getId() + "\" is required by other  application \"" + string2 + "\". It can not be uninstalled.");
            logger.exiting(CLASSNAME, "removeFromComponentRegistry");
            return false;
        }
        EcoreUtil.remove((EObject)component);
        try {
            resource.save(new HashMap());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            logger.logp(Level.SEVERE, CLASSNAME, "removeFromComponentRegistry", iOException.toString());
            logger.exiting(CLASSNAME, "removeFromComponentRegistry");
            throw new ComponentRegistryException("CWLAA10207E : Error removing component\"" + component.getId() + "\" from the Registry.", iOException);
        }
        logger.exiting(CLASSNAME, "removeFromComponentRegistry");
        return true;
    }

    private boolean removeFromNavigation(String string, Resource resource) throws NavTreeUpdateException {
        logger.entering(CLASSNAME, "removeFromNavigation");
        Vector vector = new Vector();
        EList eList = this.navTree.getNavElement();
        vector.addAll(eList);
        while (vector.size() > 0) {
            NavElement navElement = (NavElement)vector.get(0);
            if (navElement.getModuleID().equals(string)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASSNAME, "removeFromNavigation", "   Removing : " + navElement.getUniqueName());
                }
                EcoreUtil.remove((EObject)navElement);
            } else {
                eList = navElement.getNavElement();
                vector.addAll(eList);
            }
            vector.remove(0);
        }
        try {
            resource.save(new HashMap());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            logger.exiting(CLASSNAME, "removeFromNavigation");
            throw new NavTreeUpdateException("CLWAA10204E : Error saving Navigation registery.", iOException);
        }
        logger.exiting(CLASSNAME, "removeFromNavigation");
        return true;
    }

    private boolean removeFromIdmap(String string, Resource resource) {
        logger.entering(CLASSNAME, "removeFromIDMAP");
        Module module = (Module)resource.getEObject(string);
        if (module == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, "removeFromIdmap", string + " does not exist in the registry");
            }
            logger.exiting(CLASSNAME, "removeFromIDMAP");
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, "removeFromIdmap", "UpdateNavigation " + string + "calling remove");
        }
        EcoreUtil.remove((EObject)module);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, "removeFromIdmap", "UpdateNavigation " + string + "done remove");
        }
        try {
            resource.save(new HashMap());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            logger.logp(Level.WARNING, CLASSNAME, "removeFromIdmap", iOException.toString());
            logger.exiting(CLASSNAME, "removeFromIDMAP");
            return false;
        }
        logger.exiting(CLASSNAME, "removeFromIDMAP");
        return true;
    }

    public void destroy() throws IscDeployCoreException {
        logger.entering(CLASSNAME, "destroy");
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IscDeployCoreException(throwable);
        }
        logger.exiting(CLASSNAME, "destroy");
    }
}

