/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.datastore.deploy.augvalidation;

import com.ibm.isclite.datastore.deploy.augvalidation.AugmentedValidator;
import com.ibm.isclite.wccm.registry.Component;
import com.ibm.isclite.wccm.topology.IbmPortalTopology;
import com.ibm.isclite.wccm.topology.LayoutElement;
import com.ibm.isclite.wccm.topology.LayoutTree;
import com.ibm.isclite.wccm.topology.impl.ApplicationDefinitionImpl;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class AboutPageValidator
implements AugmentedValidator {
    private static String CLASSNAME = "AboutPageValidator";
    private static Logger logger = Logger.getLogger(AboutPageValidator.class.getName());
    boolean validationPassed = false;

    public boolean validate(Resource resource, IbmPortalTopology ibmPortalTopology, Resource resource2, Resource resource3) {
        logger.entering(CLASSNAME, "validate");
        if (null == ibmPortalTopology || null == resource) {
            logger.exiting(CLASSNAME, "validate");
            return false;
        }
        String string = ibmPortalTopology.getAboutPage();
        String string2 = ((ApplicationDefinitionImpl)ibmPortalTopology.getApplicationDefinition().get(0)).getAppID();
        if (null == string) {
            String string3 = ibmPortalTopology.getPAARef();
            if (null == string3) {
                logger.logp(Level.FINE, CLASSNAME, "validate", "About Page is not defined for the application \"" + string2 + "\"");
            } else {
                Component component = (Component)resource3.getEObject(string3);
                if (component != null) {
                    logger.logp(Level.FINE, CLASSNAME, "validate", "Application \"" + string2 + "\" is referencing the lead component \"" + component.getId() + "\"");
                } else {
                    logger.logp(Level.WARNING, CLASSNAME, "validate", "Application \"" + string2 + "\" is referencing a lead component \"" + string3 + "\" that does not exist.");
                }
            }
            logger.exiting(CLASSNAME, "validate");
            return true;
        }
        LayoutTree layoutTree = ((ApplicationDefinitionImpl)ibmPortalTopology.getApplicationDefinition().get(0)).getLayoutTree();
        EList eList = layoutTree.getLayoutElement();
        if (null == eList) {
            logger.logp(Level.WARNING, CLASSNAME, "validate", "topology layout-elements are not defined.");
            logger.exiting(CLASSNAME, "validate");
            return false;
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            LayoutElement layoutElement = (LayoutElement)iterator.next();
            String string4 = layoutElement.getUniqueName();
            if (!string.equals(string4)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, "validate", "AboutPage references a valid LayoutElement= " + string4);
            }
            this.validationPassed = true;
            break;
        }
        logger.exiting(CLASSNAME, "validate");
        if (this.validationPassed) {
            logger.exiting(CLASSNAME, "validate");
            return true;
        }
        logger.logp(Level.WARNING, CLASSNAME, "validate", "AboutPage references an invalid LayoutElement= " + string);
        logger.exiting(CLASSNAME, "validate");
        return false;
    }
}

