/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.datastore.deploy.augvalidation;

import com.ibm.isclite.datastore.deploy.augvalidation.AugmentedValidationException;
import com.ibm.isclite.datastore.deploy.augvalidation.AugmentedValidator;
import com.ibm.isclite.deploy.util.XmlUtils;
import com.ibm.isclite.wccm.topology.IbmPortalTopology;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AugmentedValidationManager {
    private static String CLASSNAME = "AugmentedValidationManager";
    private static Logger logger = Logger.getLogger(AugmentedValidationManager.class.getName());

    public boolean execAugmentedValidators(Resource resource, IbmPortalTopology ibmPortalTopology, Resource resource2, Resource resource3) throws AugmentedValidationException {
        logger.entering(CLASSNAME, "execAugmentedValidators");
        List list = this.readValidators();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ++n;
            String string = (String)iterator.next();
            AugmentedValidator augmentedValidator = null;
            try {
                Class<?> clazz = Class.forName(string);
                augmentedValidator = (AugmentedValidator)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.logp(Level.WARNING, CLASSNAME, "execAugmentedValidators", "Could not load extension " + string);
                augmentedValidator = null;
                throw new AugmentedValidationException("Could not load augmented validator " + string, classNotFoundException);
            }
            catch (ClassCastException classCastException) {
                logger.logp(Level.WARNING, CLASSNAME, "execAugmentedValidators", "ClassCastException for " + string);
                augmentedValidator = null;
                throw new AugmentedValidationException("Could not load augmented validator " + string, classCastException);
            }
            catch (InstantiationException instantiationException) {
                logger.logp(Level.WARNING, CLASSNAME, "execAugmentedValidators", "InstantiationException for " + string);
                augmentedValidator = null;
                throw new AugmentedValidationException("Could not load augmented validator " + string, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.logp(Level.WARNING, CLASSNAME, "execAugmentedValidators", "InstantiationException for " + string);
                augmentedValidator = null;
                throw new AugmentedValidationException("Could not load augmented validator " + string, illegalAccessException);
            }
            if (augmentedValidator != null) {
                if (!augmentedValidator.validate(resource, ibmPortalTopology, resource2, resource3)) {
                    logger.logp(Level.WARNING, CLASSNAME, "execAugmentedValidators", "Error while executing " + string + "augmented validator");
                    logger.logp(Level.WARNING, CLASSNAME, "execAugmentedValidators", "Continuing to execute other augmented validators, but some function may not work properly");
                    continue;
                }
                ++n2;
                continue;
            }
            logger.logp(Level.WARNING, CLASSNAME, "execAugmentedValidators", "Error while loading or instantiating " + string + " validator");
            logger.logp(Level.WARNING, CLASSNAME, "execAugmentedValidators", "Continuing to load and instantiate other validators, but some function may not work properly");
        }
        if (n2 != n) {
            logger.logp(Level.WARNING, CLASSNAME, "execAugmentedValidators", "Successfully executed " + n2 + " out of " + n + " augmented validators");
            logger.logp(Level.WARNING, CLASSNAME, "execAugmentedValidators", "Some function may not work properly");
            throw new AugmentedValidationException("Errors occured while executing " + (n - n2) + " out of " + n + " augmented validators");
        }
        bl = true;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, "execAugmentedValidators", "Successfully executed " + n2 + " out of " + n + " augmented validators");
        }
        logger.exiting(CLASSNAME, "execAugmentedValidators");
        return bl;
    }

    private List readValidators() {
        logger.entering(CLASSNAME, "readValidators");
        InputStream inputStream = this.getClass().getResourceAsStream("augmentedvalidators.xml");
        XmlUtils xmlUtils = new XmlUtils(inputStream, "augmentedvalidators.xml", "blah");
        Document document = xmlUtils.createDOM();
        NodeList nodeList = document.getElementsByTagName("class");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Node node2 = node.getFirstChild();
            String string = node2.getNodeValue();
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, "readValidators", "Augmented validator class: " + string);
            }
            arrayList.add(i, string);
        }
        logger.exiting(CLASSNAME, "readValidators");
        return arrayList;
    }
}

