/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.datastore.deploy.augvalidation;

import com.ibm.isclite.datastore.deploy.augvalidation.AugmentedValidator;
import com.ibm.isclite.wccm.topology.IbmPortalTopology;
import com.ibm.isclite.wccm.topology.LayoutElement;
import com.ibm.isclite.wccm.topology.LayoutTree;
import com.ibm.isclite.wccm.topology.NavigationElement;
import com.ibm.isclite.wccm.topology.impl.ApplicationDefinitionImpl;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class LayoutElementRefValidator
implements AugmentedValidator {
    private static String CLASSNAME = "LayoutElementRefValidator";
    private static Logger logger = Logger.getLogger(LayoutElementRefValidator.class.getName());
    boolean validationPassed = false;
    int numFailed = 0;

    public boolean validate(Resource resource, IbmPortalTopology ibmPortalTopology, Resource resource2, Resource resource3) {
        logger.entering(CLASSNAME, "validate");
        if (null == ibmPortalTopology || null == resource) {
            logger.exiting(CLASSNAME, "validate");
            return false;
        }
        EList eList = ((ApplicationDefinitionImpl)ibmPortalTopology.getApplicationDefinition().get(0)).getNavigationElement();
        LayoutTree layoutTree = ((ApplicationDefinitionImpl)ibmPortalTopology.getApplicationDefinition().get(0)).getLayoutTree();
        EList eList2 = layoutTree.getLayoutElement();
        if (null == eList2) {
            logger.logp(Level.WARNING, CLASSNAME, "validate", "topology layout-elements are not defined.");
            logger.exiting(CLASSNAME, "validate");
            return false;
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            NavigationElement navigationElement = (NavigationElement)iterator.next();
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, "validate", "navigationElement= " + navigationElement);
            }
            this.recurseForNavigationElementNodes(navigationElement, eList2);
        }
        logger.exiting(CLASSNAME, "validate");
        return this.numFailed <= 0;
    }

    private void recurseForNavigationElementNodes(NavigationElement navigationElement, EList eList) {
        Object object;
        Object object2;
        LayoutElement layoutElement = navigationElement.getLayoutElementRef();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINEST, CLASSNAME, "recurseForNavigationElementNodes", "navigation-element= " + navigationElement + ", layoutElementRef=" + layoutElement);
        }
        this.validationPassed = false;
        if (null != layoutElement) {
            this.validationPassed = false;
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, "recurseForNavigationElementNodes", "LayoutElementRef UniqueName= " + layoutElement.getUniqueName());
            }
            object2 = eList.iterator();
            while (object2.hasNext()) {
                object = (LayoutElement)object2.next();
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASSNAME, "recurseForNavigationElementNodes", "layout-element uniqueName= " + object.getUniqueName());
                }
                if (!layoutElement.getUniqueName().equals(object.getUniqueName())) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASSNAME, "recurseForNavigationElementNodes", "layoutElementRef attribute of the navigation-element is successfully validated.");
                }
                this.validationPassed = true;
                break;
            }
            if (!this.validationPassed) {
                ++this.numFailed;
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, "recurseForNavigationElementNodes", "Navigation Element is a Label and contains no layoutElementRef attribute.");
        }
        object2 = navigationElement.getNavigationElement();
        object = object2.iterator();
        while (object.hasNext()) {
            NavigationElement navigationElement2 = (NavigationElement)object.next();
            this.recurseForNavigationElementNodes(navigationElement2, eList);
        }
    }
}

