/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.datastore.deploy.augvalidation;

import com.ibm.isclite.datastore.deploy.augvalidation.AugmentedValidator;
import com.ibm.isclite.wccm.topology.ComponentDefinition;
import com.ibm.isclite.wccm.topology.ComponentTree;
import com.ibm.isclite.wccm.topology.IbmPortalTopology;
import com.ibm.isclite.wccm.topology.LayoutTree;
import com.ibm.isclite.wccm.topology.NavigationContent;
import com.ibm.isclite.wccm.topology.NavigationElement;
import com.ibm.isclite.wccm.topology.UrlLink;
import com.ibm.isclite.wccm.topology.Window;
import com.ibm.isclite.wccm.topology.impl.ApplicationDefinitionImpl;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class NavigationContentElementValidator
implements AugmentedValidator {
    private static String CLASSNAME = "NavigationContentElementValidator";
    private static Logger logger = Logger.getLogger(NavigationContentElementValidator.class.getName());
    private int navigationContentValidationCount = 0;
    private boolean urlLinkResource = false;

    public boolean validate(Resource resource, IbmPortalTopology ibmPortalTopology, Resource resource2, Resource resource3) {
        logger.entering(CLASSNAME, "validate");
        if (null == ibmPortalTopology || null == resource) {
            logger.logp(Level.WARNING, CLASSNAME, "validate", "Missing ibm-portal-topology resource.  Validation failed.");
            logger.exiting(CLASSNAME, "validate");
            return false;
        }
        EList eList = ((ApplicationDefinitionImpl)ibmPortalTopology.getApplicationDefinition().get(0)).getNavigationElement();
        LayoutTree layoutTree = ((ApplicationDefinitionImpl)ibmPortalTopology.getApplicationDefinition().get(0)).getLayoutTree();
        EList eList2 = layoutTree.getLayoutElement();
        ComponentTree componentTree = ((ApplicationDefinitionImpl)ibmPortalTopology.getApplicationDefinition().get(0)).getComponentTree();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, "validate", "componentTreeName= " + componentTree.getUniqueName() + ", componentTree= " + componentTree);
        }
        EList eList3 = componentTree.getComponentTree();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, "validate", "Component Tree List= " + eList3);
        }
        if (null != eList3 && !eList3.isEmpty()) {
            logger.logp(Level.WARNING, CLASSNAME, "validate", "Nest ComponentTree is not currently supported.");
            return false;
        }
        if (null == eList2 || null == componentTree) {
            logger.logp(Level.WARNING, CLASSNAME, "validate", "Topology layout-elements or componentElements are not defined. Validation failed.");
            logger.exiting(CLASSNAME, "validate");
            return false;
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            NavigationElement navigationElement = (NavigationElement)iterator.next();
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, "validate", "navigationElement= " + navigationElement);
            }
            this.recurseForNavigationElementNodes(navigationElement, eList2, componentTree);
        }
        logger.exiting(CLASSNAME, "validate");
        if (this.navigationContentValidationCount > 0) {
            logger.logp(Level.WARNING, CLASSNAME, "validate", "number of invalid navigation-contents = " + this.navigationContentValidationCount);
            return false;
        }
        return true;
    }

    private void recurseForNavigationElementNodes(NavigationElement navigationElement, EList eList, ComponentTree componentTree) {
        EList eList2;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, "recurseForNavigationElementNodes", "Validating navigation-element = " + navigationElement);
        }
        if (null != (eList2 = navigationElement.getNavigationContent()) || !eList2.isEmpty()) {
            this.recurseForNavigationContentElements(eList2, eList, componentTree);
        }
        EList eList3 = navigationElement.getNavigationElement();
        Iterator iterator = eList3.iterator();
        while (iterator.hasNext()) {
            NavigationElement navigationElement2 = (NavigationElement)iterator.next();
            this.recurseForNavigationElementNodes(navigationElement2, eList, componentTree);
        }
    }

    private void recurseForNavigationContentElements(EList eList, EList eList2, ComponentTree componentTree) {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            NavigationContent navigationContent = (NavigationContent)iterator.next();
            if (!this.verifyComponentDefinitionRef(navigationContent, componentTree)) {
                ++this.navigationContentValidationCount;
            }
            if (this.verifyWindowRef(navigationContent, eList2)) continue;
            ++this.navigationContentValidationCount;
        }
    }

    private boolean verifyComponentDefinitionRef(NavigationContent navigationContent, ComponentTree componentTree) {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, "verifyComponentDefinitionRef", "navigation-content = " + navigationContent);
        }
        ComponentDefinition componentDefinition = navigationContent.getComponentDefinitionRef();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, "verifyComponentDefinitionRef", "componentDefinitionRef Object = " + componentDefinition);
        }
        this.urlLinkResource = false;
        if (null != componentDefinition) {
            String string = componentDefinition.getUniqueName();
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, "verifyComponentDefinitionRef", "componentDefinitionRef UniqueName found= " + string);
            }
            if (componentDefinition instanceof UrlLink) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASSNAME, "verifyComponentDefinitionRef", "Component Definition Resource is a UrlLink.");
                }
                this.urlLinkResource = true;
            }
            return true;
        }
        return false;
    }

    private boolean verifyWindowRef(NavigationContent navigationContent, EList eList) {
        Window window = navigationContent.getWindowRef();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASSNAME, "verifyWindowRef", "windowRef = " + window);
        }
        if (null == window) {
            return this.urlLinkResource;
        }
        return true;
    }
}

