/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.datastore.deploy.augvalidation;

import com.ibm.isclite.datastore.deploy.augvalidation.AugmentedValidator;
import com.ibm.isclite.wccm.topology.Container;
import com.ibm.isclite.wccm.topology.IbmPortalTopology;
import com.ibm.isclite.wccm.topology.LayoutElement;
import com.ibm.isclite.wccm.topology.NavigationContent;
import com.ibm.isclite.wccm.topology.NavigationElement;
import com.ibm.isclite.wccm.topology.PortletRefresh;
import com.ibm.isclite.wccm.topology.RefreshMode;
import com.ibm.isclite.wccm.topology.Window;
import com.ibm.isclite.wccm.topology.impl.ApplicationDefinitionImpl;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class PortletRefreshValidator
implements AugmentedValidator {
    private static String CLASSNAME = "PortletRefreshValidator";
    private static Logger logger = Logger.getLogger(PortletRefreshValidator.class.getName());
    boolean validationPassed = false;

    public boolean validate(Resource resource, IbmPortalTopology ibmPortalTopology, Resource resource2, Resource resource3) {
        logger.entering(CLASSNAME, "validate");
        if (null == ibmPortalTopology || null == resource) {
            logger.exiting(CLASSNAME, "validate");
            return false;
        }
        NavigationElement navigationElement = null;
        EList eList = ((ApplicationDefinitionImpl)ibmPortalTopology.getApplicationDefinition().get(0)).getNavigationElement();
        Object object = eList.iterator();
        while (object.hasNext()) {
            navigationElement = (NavigationElement)object.next();
            if (navigationElement == null || this.processNavigationElement(navigationElement)) continue;
            logger.logp(Level.WARNING, CLASSNAME, "validate", "Invalid portlet-refresh setting specified for navigation-element(" + navigationElement.getUniqueName() + "), Please make sure valid refreshInterval and refreshThreshold values are specified.");
            logger.exiting(CLASSNAME, "validate");
            return false;
        }
        object = ((ApplicationDefinitionImpl)ibmPortalTopology.getApplicationDefinition().get(0)).getLayoutTree();
        EList eList2 = object.getLayoutElement();
        if (null == eList2) {
            logger.logp(Level.WARNING, CLASSNAME, "validate", "topology layout-elements are not defined.");
            logger.exiting(CLASSNAME, "validate");
            return false;
        }
        Iterator iterator = eList2.iterator();
        while (iterator.hasNext()) {
            LayoutElement layoutElement = (LayoutElement)iterator.next();
            Container container = layoutElement.getAbstractContainer();
            if (container == null || this.processLayoutElement(container)) continue;
            logger.logp(Level.WARNING, CLASSNAME, "validate", "Invalid portlet-refresh setting specified for layout-element(" + container.getUniqueName() + "), Please make sure valid refreshInterval and refreshThreshold values are specified.");
            logger.exiting(CLASSNAME, "validate");
            return false;
        }
        logger.exiting(CLASSNAME, "validate");
        return true;
    }

    private boolean processLayoutElement(Container container) {
        String string = "processLayoutElement";
        EList eList = container.getWindow();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Window window = (Window)iterator.next();
            if (eList == null) continue;
            logger.logp(Level.FINE, CLASSNAME, string, "Found Window= " + window.getUniqueName());
            PortletRefresh portletRefresh = window.getPortletRefresh();
            if (portletRefresh == null) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, string, "Found PortletRefresh \"" + portletRefresh.toString() + "\" for Window " + window.getUniqueName());
            }
            if (this.validatePortletRefresh(portletRefresh, window.getUniqueName())) continue;
            return false;
        }
        return true;
    }

    private boolean processNavigationElement(NavigationElement navigationElement) {
        String string = "processNavigationElement";
        NavigationElement navigationElement2 = null;
        NavigationContent navigationContent = null;
        PortletRefresh portletRefresh = null;
        EList eList = navigationElement.getNavigationContent();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            navigationContent = (NavigationContent)iterator.next();
            if (navigationContent == null) continue;
            logger.logp(Level.FINE, CLASSNAME, string, "Found NavigationContent= " + navigationContent.getUniqueName());
            portletRefresh = navigationContent.getPortletRefresh();
            if (portletRefresh == null) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASSNAME, string, "Found PortletRefresh \"" + portletRefresh.toString() + "\" for NavigationContent " + navigationContent.getUniqueName());
            }
            if (this.validatePortletRefresh(portletRefresh, navigationContent.getUniqueName())) continue;
            return false;
        }
        iterator = navigationElement.getNavigationElement();
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            navigationElement2 = (NavigationElement)iterator2.next();
            if (navigationElement2 == null || this.processNavigationElement(navigationElement2)) continue;
            return false;
        }
        return true;
    }

    private boolean validatePortletRefresh(PortletRefresh portletRefresh, String string) {
        String string2 = "validatePortletRefresh";
        boolean bl = true;
        logger.logp(Level.FINE, CLASSNAME, string2, "Validating PortletRefresh \"" + portletRefresh.toString() + "\" for uniqueName " + string);
        if (portletRefresh.isSetRefreshMode()) {
            if (((Object)((Object)portletRefresh.getRefreshMode())).equals((Object)RefreshMode.UNREGISTER_LITERAL)) {
                return bl;
            }
            if (portletRefresh.getRefreshInterval() == null) {
                logger.logp(Level.WARNING, CLASSNAME, string2, "Invalid portlet-refresh setting found for uniqueName \"" + string + "\", refreshInterval is null.");
                bl = false;
            }
            if (portletRefresh.getThreshold() == null) {
                logger.logp(Level.WARNING, CLASSNAME, string2, "Invalid portlet-refresh setting found for uniqueName \"" + string + "\", refreshThreshold is null.");
                bl = false;
            }
            if (portletRefresh.getRefreshInterval().intValue() < portletRefresh.getThreshold().intValue()) {
                logger.logp(Level.WARNING, CLASSNAME, string2, "Invalid portlet-refresh setting found for uniqueName \"" + string + "\", refreshInterval(" + portletRefresh.getRefreshInterval().intValue() + ") should be greater than or equal to refreshThreshold(" + portletRefresh.getThreshold().intValue() + ").");
                bl = false;
            }
            if (portletRefresh.getRefreshInterval().intValue() <= 0) {
                logger.logp(Level.WARNING, CLASSNAME, string2, "Invalid portlet-refresh setting found for uniqueName \"" + string + "\", refreshInterval(" + portletRefresh.getRefreshInterval().intValue() + ") should be greater than 0.");
                bl = false;
            }
            if (portletRefresh.getThreshold().intValue() <= 0) {
                logger.logp(Level.WARNING, CLASSNAME, string2, "Invalid portlet-refresh setting found for uniqueName \"" + string + "\", refreshThreshold(" + portletRefresh.getThreshold().intValue() + ") should be greater than 0.");
                bl = false;
            }
        } else {
            if (portletRefresh.getRefreshInterval() != null) {
                logger.logp(Level.WARNING, CLASSNAME, string2, "Cannot sepcify refreshInterval without specifying a valid refreshMode.");
                bl = false;
            }
            if (portletRefresh.getThreshold() != null) {
                logger.logp(Level.WARNING, CLASSNAME, string2, "Cannot sepcify threshold without specifying a valid refreshMode.");
                bl = false;
            }
            if (portletRefresh.isSetShowTimer()) {
                logger.logp(Level.WARNING, CLASSNAME, string2, "Cannot sepcify showTimer without specifying a valid refreshMode.");
                bl = false;
            }
            if (portletRefresh.isSetUserConfigurable()) {
                logger.logp(Level.WARNING, CLASSNAME, string2, "Cannot sepcify userConfigurable without specifying a valid refreshMode.");
                bl = false;
            }
        }
        return bl;
    }
}

