/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.deploy.extensions;

import com.ibm.isclite.deploy.extensions.DeploymentExtension;
import com.ibm.isclite.deploy.extensions.IscDeployExtensionException;
import com.ibm.isclite.deploy.helper.IscDeployCoreException;
import com.ibm.isclite.deploy.util.XmlUtils;
import com.ibm.websphere.management.application.Scheduler;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeploymentExtensionManager {
    private static String CLASSNAME = "DeploymentExtensionManager";
    private static Logger logger = Logger.getLogger(DeploymentExtensionManager.class.getName());

    public void execDeployExtensions(Scheduler scheduler, WARFile wARFile) throws IscDeployCoreException {
        logger.entering(CLASSNAME, "execDeployExtensions");
        List list = this.readExtensions();
        int n = 0;
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ++n;
            String string = (String)iterator.next();
            logger.logp(Level.FINE, CLASSNAME, "execDeployExtensions", "Loading extension " + string);
            DeploymentExtension deploymentExtension = null;
            try {
                Class<?> clazz = Class.forName(string);
                deploymentExtension = (DeploymentExtension)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.logp(Level.WARNING, CLASSNAME, "execDeployExtensions", "Could not load extension " + string);
                deploymentExtension = null;
                throw new IscDeployCoreException("Could not load extension " + string, classNotFoundException);
            }
            catch (ClassCastException classCastException) {
                logger.logp(Level.WARNING, CLASSNAME, "execDeployExtensions", "ClassCastException for " + string);
                deploymentExtension = null;
                throw new IscDeployCoreException("Could not load extension " + string, classCastException);
            }
            catch (InstantiationException instantiationException) {
                logger.logp(Level.WARNING, CLASSNAME, "execDeployExtensions", "InstantiationException for " + string);
                deploymentExtension = null;
                throw new IscDeployCoreException("Could not load extension " + string, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.logp(Level.WARNING, CLASSNAME, "execDeployExtensions", "InstantiationException for " + string);
                deploymentExtension = null;
                throw new IscDeployCoreException("Could not load extension " + string, illegalAccessException);
            }
            if (deploymentExtension != null) {
                try {
                    if (!deploymentExtension.deployExtension(scheduler, wARFile)) {
                        logger.logp(Level.WARNING, CLASSNAME, "execDeployExtensions", "Error while executing " + string + " extension");
                        logger.logp(Level.WARNING, CLASSNAME, "execDeployExtensions", "Continuing to execute other extensions, but some function may not work properly");
                        continue;
                    }
                    logger.logp(Level.FINE, CLASSNAME, "execDeployExtensions", "Successfully executed " + string + " extension");
                    ++n2;
                    continue;
                }
                catch (IscDeployExtensionException iscDeployExtensionException) {
                    logger.logp(Level.WARNING, CLASSNAME, "execDeployExtensions", "IscDeployExtensionExceptionwhile executing deployExtension for an extension");
                    throw new IscDeployCoreException("Could not execute extension " + string + " at deploy time", iscDeployExtensionException);
                }
            }
            logger.logp(Level.WARNING, CLASSNAME, "execDeployExtensions", "Error while loading or instantiating " + string + "extension");
            logger.logp(Level.WARNING, CLASSNAME, "execDeployExtensions", "Continuing to load and instantiate other extensions, but some function may not work properly");
        }
        if (n2 != n) {
            logger.logp(Level.WARNING, CLASSNAME, "execDeployExtensions", "Successfully executed " + n2 + " out of " + n + " deploy time extensions");
            logger.logp(Level.WARNING, CLASSNAME, "execDeployExtensions", "Some deploy function may not work properly");
            throw new IscDeployCoreException("Errors occured while executing " + (n - n2) + " out of " + n + " deploy time extensions");
        }
        logger.logp(Level.FINE, CLASSNAME, "execDeployExtensions", "Successfully executed " + n2 + " out of " + n + " deploy time extensions");
        logger.exiting(CLASSNAME, "execDeployExtensions");
    }

    public void execRemoveExtensions(Scheduler scheduler, String string) throws IscDeployCoreException {
        logger.entering(CLASSNAME, "execRemoveExtensions");
        List list = this.readExtensions();
        int n = 0;
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ++n;
            String string2 = (String)iterator.next();
            DeploymentExtension deploymentExtension = null;
            try {
                Class<?> clazz = Class.forName(string2);
                deploymentExtension = (DeploymentExtension)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.logp(Level.FINE, CLASSNAME, "execRemoveExtensions", "Could not load extension " + string2);
                deploymentExtension = null;
                throw new IscDeployCoreException("Could not load extension " + string2, classNotFoundException);
            }
            catch (ClassCastException classCastException) {
                logger.logp(Level.FINE, CLASSNAME, "execRemoveExtensions", "ClassCastException for " + string2);
                deploymentExtension = null;
                throw new IscDeployCoreException("Could not load extension " + string2, classCastException);
            }
            catch (InstantiationException instantiationException) {
                logger.logp(Level.FINE, CLASSNAME, "execRemoveExtensions", "InstantiationException for " + string2);
                deploymentExtension = null;
                throw new IscDeployCoreException("Could not load extension " + string2, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.logp(Level.WARNING, CLASSNAME, "execRemoveExtensions", "InstantiationException for " + string2);
                deploymentExtension = null;
                throw new IscDeployCoreException("Could not load extension " + string2, illegalAccessException);
            }
            if (deploymentExtension != null) {
                try {
                    if (!deploymentExtension.removeExtension(scheduler, string)) {
                        logger.logp(Level.WARNING, CLASSNAME, "execRemoveExtensions", "Error while executing " + string2 + "extension");
                        logger.logp(Level.WARNING, CLASSNAME, "execRemoveExtensions", "Continuing to execute other extensions, but some function in your new ISC module may not work properly");
                        continue;
                    }
                    ++n2;
                    continue;
                }
                catch (IscDeployExtensionException iscDeployExtensionException) {
                    logger.logp(Level.WARNING, CLASSNAME, "execRemoveExtensions", "DeployExtensionExceptionwhile executing removeExtension for an extension");
                    throw new IscDeployCoreException("Could not execute extension " + string2 + "at remove time ", iscDeployExtensionException);
                }
            }
            logger.logp(Level.WARNING, CLASSNAME, "execRemoveExtensions", "Error while loading or instantiating " + string2 + "extension");
            logger.logp(Level.WARNING, CLASSNAME, "execRemoveExtensions", "Continuing to load and instantiate other extensions, but some function in your new ISC module may not work properly");
        }
        if (n2 != n) {
            logger.logp(Level.WARNING, CLASSNAME, "execRemoveExtensions", "Successfully executed " + n2 + " out of " + n + " deploy time extensions");
            logger.logp(Level.WARNING, CLASSNAME, "execRemoveExtensions", "Some function in your new ISC module may not work properly");
            throw new IscDeployCoreException("Errors occured while executing " + (n - n2) + " out of " + n + " remove time extensions");
        }
        logger.logp(Level.FINE, CLASSNAME, "execRemoveExtensions", "Successfully executed " + n2 + " out of " + n + " deploy time extensions");
    }

    private List readExtensions() {
        logger.entering(CLASSNAME, "readExtensions");
        InputStream inputStream = this.getClass().getResourceAsStream("extensions.xml");
        XmlUtils xmlUtils = new XmlUtils(inputStream, "extensions.xml", "blah");
        Document document = xmlUtils.createDOM();
        NodeList nodeList = document.getElementsByTagName("class");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Node node2 = node.getFirstChild();
            String string = node2.getNodeValue();
            logger.logp(Level.FINE, CLASSNAME, "readExtensions", "DeployExtension class: " + string);
            arrayList.add(i, string);
        }
        logger.exiting(CLASSNAME, "readExtensions");
        return arrayList;
    }
}

