/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.deploy.extensions;

import com.ibm.isclite.deploy.extensions.DeploymentExtension;
import com.ibm.isclite.deploy.extensions.IscDeployExtensionException;
import com.ibm.isclite.deploy.util.FileUtil;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;

public class HelpDeployTask
implements DeploymentExtension {
    private static String CLASSNAME = "HelpDeployTask";
    private static Logger logger = Logger.getLogger(HelpDeployTask.class.getName());
    Hashtable props = null;
    UpdateScheduler updateScheduler = null;
    String warName = null;
    String iehsPropertiesUri = File.separatorChar + "applications" + File.separatorChar + "isclite.ear" + File.separatorChar + "deployments" + File.separatorChar + "isclite" + File.separatorChar + "iehs.war" + File.separatorChar + "WEB-INF" + File.separatorChar + "iehs.properties";
    String msg = "";
    String taskName = "";
    String status = "";

    private void logp(Level level, String string, String string2, String string3) {
        logger.logp(level, string, string2, string3);
        FileUtil.debug(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deployExtension(Scheduler scheduler, WARFile wARFile) throws IscDeployExtensionException {
        Object object;
        Object object2;
        Object object3;
        this.props = scheduler.getProperties();
        this.warName = wARFile.getName();
        this.logp(Level.FINE, CLASSNAME, "deployExtension", "warName:" + this.warName);
        if (this.warName == null) {
            return true;
        }
        WorkSpace workSpace = scheduler.getWorkSpace();
        RepositoryContext repositoryContext = workSpace.getRootContext();
        this.iehsPropertiesUri = "cells" + File.separatorChar + (String)this.props.get("cell.name") + this.iehsPropertiesUri;
        this.extractWorkSpace(workSpace, repositoryContext, this.iehsPropertiesUri);
        String string = System.getProperty("was.install.root") + File.separatorChar + "systemApps" + File.separatorChar + "isclite.ear" + File.separatorChar + this.warName;
        if (logger.isLoggable(Level.FINE)) {
            this.logp(Level.FINE, CLASSNAME, "deployExtension", "rc.getPath()" + repositoryContext.getPath());
            this.logp(Level.FINE, CLASSNAME, "deployExtension", "ws.getPath()" + workSpace.getPath());
            this.logp(Level.FINE, CLASSNAME, "deployExtension", "iehsPropertiesUri:" + this.iehsPropertiesUri);
            this.logp(Level.FINE, CLASSNAME, "deployExtension", "warRootLoc:" + string);
        }
        String string2 = null;
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            object3 = "";
            for (int i = 0; i < fileArray.length; ++i) {
                object2 = fileArray[i];
                this.logp(Level.FINE, CLASSNAME, "deployExtension", "file:" + ((File)object2).toString());
                if (!((File)object2).isDirectory()) continue;
                object3 = object2 + "";
                object3 = ((String)object3).substring(string.length() + 1, ((String)object3).length());
                this.logp(Level.FINE, CLASSNAME, "deployExtension", "helpcontent:" + (String)object3);
                if (!((String)object3).equals("help")) continue;
                string2 = System.getProperty("was.install.root") + File.separatorChar + "systemApps" + File.separatorChar + "isclite.ear" + File.separatorChar + this.warName + File.separatorChar + "help";
                break;
            }
        } else {
            try {
                object3 = new FileInputStream(string);
                JarInputStream jarInputStream = new JarInputStream((InputStream)object3);
                object2 = null;
                while ((object2 = jarInputStream.getNextJarEntry()) != null) {
                    object = "help/";
                    this.logp(Level.FINE, CLASSNAME, "deployExtension", "warfile:" + ((ZipEntry)object2).toString());
                    if (!((String)object).equals(((ZipEntry)object2).toString())) continue;
                    string2 = System.getProperty("was.install.root") + File.separatorChar + "systemApps" + File.separatorChar + "isclite.ear" + File.separatorChar + this.warName + File.separatorChar + "help";
                    break;
                }
                jarInputStream.close();
                ((FileInputStream)object3).close();
            }
            catch (IOException iOException) {
                this.logp(Level.INFO, CLASSNAME, "deployExtension", "I/O exception trying to find help file:" + iOException.getMessage() + "  warfile:" + string);
            }
        }
        this.logp(Level.FINE, CLASSNAME, "deployExtension", "pluginLoc: " + string2);
        if (string2 == null) {
            return true;
        }
        object3 = repositoryContext.getPath() + File.separatorChar + this.iehsPropertiesUri;
        FileInputStream fileInputStream = null;
        object2 = null;
        object = new File((String)object3);
        boolean bl = ((File)object).exists();
        if (!bl) {
            this.logp(Level.FINE, CLASSNAME, "deployExtension", "properties file " + (String)object3 + " does not exist and will be created");
            try {
                boolean bl2 = ((File)object).createNewFile();
            }
            catch (IOException iOException) {
                this.logp(Level.WARNING, CLASSNAME, "deployExtension", "properties file " + (String)object3 + " could not be created");
            }
        }
        try {
            String string3;
            fileInputStream = new FileInputStream((String)object3);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            this.logp(Level.FINE, CLASSNAME, "deployExtension", "properties file " + (String)object3 + " is loaded.");
            Enumeration<?> enumeration = properties.propertyNames();
            bl = false;
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                if (!string3.equals(this.warName)) continue;
                this.logp(Level.FINE, CLASSNAME, "deployExtension", "entry: " + this.warName + " is not an unique key.");
                bl = true;
                this.msg = FileUtil.getMessage("deploy.help.failure");
                this.taskName = "Help Deploy";
                this.status = "STATUS_FAILED";
                AppNotification appNotification = new AppNotification(this.taskName, this.taskName, this.status, this.taskName, this.msg);
                scheduler.propagateTaskEvent(appNotification);
                break;
            }
            if (!bl) {
                properties.setProperty(this.warName, string2);
                this.logp(Level.FINE, CLASSNAME, "deployExtension", "entry: " + this.warName + " is added.");
                object2 = new FileOutputStream((String)object3);
                properties.store((OutputStream)object2, "updated");
                ((FileOutputStream)object2).close();
                this.logp(Level.FINE, CLASSNAME, "deployExtension", "properties file " + (String)object3 + " is saved.");
                this.msg = FileUtil.getMessage("deploy.help.success");
                this.taskName = "Help Deploy";
                this.status = "STATUS_COMPLETED";
                string3 = new AppNotification(this.taskName, this.taskName, this.status, this.taskName, this.msg);
                scheduler.propagateTaskEvent((AppNotification)string3);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logp(Level.FINE, CLASSNAME, "deployExtension", fileNotFoundException.getMessage());
            throw new IscDeployExtensionException("Cannot find " + (String)object3, fileNotFoundException);
        }
        catch (IOException iOException) {
            this.logp(Level.FINE, CLASSNAME, "deployExtension", iOException.getMessage());
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                this.logp(Level.FINE, CLASSNAME, "deployExtension", iOException.getMessage());
            }
        }
        this.updateWorkSpace(repositoryContext, this.iehsPropertiesUri);
        return true;
    }

    private String getWEBINFPathFromDeploy() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("isclite.war").append(File.separatorChar);
        stringBuffer.append("WEB-INF");
        return stringBuffer.toString();
    }

    private String getRelPathToISCDeploy() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cells").append(File.separatorChar);
        stringBuffer.append((String)this.props.get("cell.name")).append(File.separatorChar);
        stringBuffer.append("applications").append(File.separatorChar);
        stringBuffer.append("isclite.ear").append(File.separatorChar);
        stringBuffer.append("deployments").append(File.separatorChar);
        stringBuffer.append("isclite");
        return stringBuffer.toString().replace('\\', '/');
    }

    private void extractWorkSpace(WorkSpace workSpace, RepositoryContext repositoryContext, String string) throws IscDeployExtensionException {
        try {
            String string2 = this.getRelPathToISCDeploy();
            RepositoryContext repositoryContext2 = workSpace.findContext(string2);
            workSpace.extract(repositoryContext2, string, false);
        }
        catch (WorkSpaceException workSpaceException) {
            this.logp(Level.FINE, CLASSNAME, "extractWorkSpace", workSpaceException.getMessage());
            FFDCFilter.processException((Throwable)workSpaceException, (String)(CLASSNAME + ".extractWorkSpace()"), (String)"", (Object)this);
            throw new IscDeployExtensionException("Unable to extract from the config repository " + string, workSpaceException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeExtension(Scheduler scheduler, String string) throws IscDeployExtensionException {
        logger.entering(CLASSNAME, "removeExtension");
        WorkSpace workSpace = scheduler.getWorkSpace();
        RepositoryContext repositoryContext = workSpace.getRootContext();
        this.updateScheduler = (UpdateScheduler)scheduler;
        this.props = scheduler.getProperties();
        this.warName = (String)this.props.get("contenturi");
        this.iehsPropertiesUri = "cells" + File.separatorChar + (String)this.props.get("cell.name") + this.iehsPropertiesUri;
        this.extractWorkSpace(workSpace, repositoryContext, this.iehsPropertiesUri);
        Properties properties = new Properties();
        String string2 = System.getProperty("was.repository.root") + File.separatorChar + this.iehsPropertiesUri;
        File file = new File(string2);
        boolean bl = file.exists();
        if (!bl) {
            this.logp(Level.FINE, CLASSNAME, "removeExtension", "properties file " + string2 + " does not exist");
        } else {
            String string3 = repositoryContext.getPath() + File.separatorChar + this.iehsPropertiesUri;
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                fileInputStream = new FileInputStream(string3);
                properties.load(fileInputStream);
                if (logger.isLoggable(Level.FINE)) {
                    this.logp(Level.FINE, CLASSNAME, "removeExtension", "properties file " + string3 + " is loaded, removing warfile " + this.warName);
                }
                properties.remove(this.warName);
                fileOutputStream = new FileOutputStream(string3);
                properties.store(fileOutputStream, "updated");
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logp(Level.FINE, CLASSNAME, "removeExtension", fileNotFoundException.getMessage());
                throw new IscDeployExtensionException("Cannot find " + string3, fileNotFoundException);
            }
            catch (IOException iOException) {
                this.logp(Level.FINE, CLASSNAME, "removeExtension", iOException.getMessage());
            }
            finally {
                try {
                    fileInputStream.close();
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.logp(Level.FINE, CLASSNAME, "removeExtension", iOException.getMessage());
                }
            }
        }
        this.updateWorkSpace(repositoryContext, this.iehsPropertiesUri);
        return true;
    }

    private void updateWorkSpace(RepositoryContext repositoryContext, String string) throws IscDeployExtensionException {
        String string2 = "iehs.war" + File.separatorChar + "WEB-INF" + File.separatorChar + "iehs.properties";
        String string3 = this.getRelPathToISCDeploy();
        try {
            RepositoryContext repositoryContext2 = repositoryContext.findContext(string3);
            repositoryContext2.notifyChanged(1, string2);
        }
        catch (WorkSpaceException workSpaceException) {
            this.logp(Level.FINE, CLASSNAME, "updateWorkSpace", workSpaceException.getMessage());
            FFDCFilter.processException((Throwable)workSpaceException, (String)(CLASSNAME + ".updateWorkSpace()"), (String)"", (Object)this);
            throw new IscDeployExtensionException("Cannot update iehs.properties", workSpaceException);
        }
    }
}

