/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.deploy.extensions;

import com.ibm.isclite.deploy.extensions.DeploymentExtension;
import com.ibm.isclite.deploy.extensions.IscDeployExtensionException;
import com.ibm.isclite.wccm.security.ApplicationRole;
import com.ibm.isclite.wccm.security.DocumentRoot;
import com.ibm.isclite.wccm.security.IbmPortalSecurity;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.models.config.rolebasedauthz.AuthorizationTableExt;
import com.ibm.websphere.models.config.rolebasedauthz.RolebasedauthzFactory;
import com.ibm.websphere.models.config.rolebasedauthz.impl.SecurityRoleExtImpl;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;

public class UpdateSuperRoles
implements DeploymentExtension {
    private static String CLASSNAME = "UpdateSuperRoles";
    private static Logger logger = Logger.getLogger(UpdateSuperRoles.class.getName());
    protected Hashtable props = null;
    protected Scheduler updateScheduler = null;
    protected WARFile war = null;
    protected WorkSpace ws = null;
    protected RepositoryContext rc = null;
    protected Resource adminAuthzResource = null;
    protected Resource securityResource = null;
    protected ResourceSet resSet = null;
    protected String pathToAdminAuthzXml = null;
    protected String pathToSecurityXml = null;

    public boolean deployExtension(Scheduler scheduler, WARFile wARFile) throws IscDeployExtensionException {
        logger.entering(CLASSNAME, "deployExtension()");
        this.updateScheduler = scheduler;
        this.props = this.updateScheduler.getProperties();
        try {
            this.war = wARFile;
        }
        catch (Exception exception) {
            throw new IscDeployExtensionException("Cannot read input WAR file", exception);
        }
        this.setupWorkSpace();
        if (this.securityResource == null) {
            logger.log(Level.FINE, "No ibm-portal-security.xml found.");
            logger.exiting(CLASSNAME, "deployExtension()");
            return true;
        }
        HashSet hashSet = this.getRolesToBeCreated();
        if (hashSet.isEmpty()) {
            logger.log(Level.FINE, "No new roles defined, so authorization table does not have to be updated.");
            logger.exiting(CLASSNAME, "deployExtension()");
            return true;
        }
        if (this.updateAuthorizationTable(hashSet)) {
            logger.log(Level.FINE, "Updating authorization table succeeded.");
            if (this.refreshRoles()) {
                logger.log(Level.FINE, "Refreshed authorization table successfully");
                logger.exiting(CLASSNAME, "deployExtension()");
                return true;
            }
            logger.log(Level.FINE, "Refreshing authorization table failed.");
            logger.exiting(CLASSNAME, "deployExtension()");
            return false;
        }
        logger.log(Level.FINE, "Updating authorization table failed.");
        logger.exiting(CLASSNAME, "deployExtension()");
        return false;
    }

    private boolean updateAuthorizationTable(HashSet hashSet) throws IscDeployExtensionException {
        logger.entering(CLASSNAME, "updateAuthorizationTable()");
        AuthorizationTableExt authorizationTableExt = null;
        EList eList = this.adminAuthzResource.getContents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            SecurityRoleExtImpl securityRoleExtImpl;
            authorizationTableExt = (AuthorizationTableExt)iterator.next();
            if (!authorizationTableExt.getContext().equals("domain")) continue;
            logger.log(Level.FINEST, "authTable.getContext() :" + authorizationTableExt.getContext());
            EList eList2 = authorizationTableExt.getRoles();
            if (eList2.isEmpty()) {
                logger.log(Level.FINEST, "roles is empty");
            } else {
                logger.log(Level.FINEST, "roles is NOT empty");
                logger.log(Level.FINEST, eList2.toString());
            }
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                securityRoleExtImpl = (SecurityRoleExtImpl)iterator2.next();
                String string = securityRoleExtImpl.getRoleName();
                logger.log(Level.FINE, "From adminauthz.xml, role is: " + string);
                if (hashSet.contains(string)) {
                    logger.log(Level.FINE, "from roleSet remove the role : " + string);
                    hashSet.remove(string);
                    continue;
                }
                String string2 = null;
                Iterator iterator3 = hashSet.iterator();
                while (iterator3.hasNext()) {
                    String string3 = iterator3.next().toString();
                    logger.log(Level.FINE, "roleSet's appRole value is " + string3);
                    logger.log(Level.FINE, "authzRolename: " + string);
                    if (!string.equalsIgnoreCase(string3)) continue;
                    string2 = string3;
                    hashSet.remove(string2);
                    logger.logp(Level.SEVERE, CLASSNAME, "updateAuthorizationTable", string3 + " role can't be created due to the same string with different alphabetic case is used by another role, Please make sure you use the correct role name alphabetic cases if you want to reuse the previously defined roles");
                    throw new IscDeployExtensionException("Error notifying update of workspace");
                }
            }
            iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                securityRoleExtImpl = RolebasedauthzFactory.eINSTANCE.createSecurityRoleExt();
                securityRoleExtImpl.setRoleName(iterator2.next().toString());
                eList2.add((Object)securityRoleExtImpl);
                logger.log(Level.FINE, "Added " + securityRoleExtImpl.getRoleName() + " to adminauthz");
            }
            try {
                this.adminAuthzResource.save(new HashMap());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            logger.exiting(CLASSNAME, "updateAuthorizationTable()");
            return true;
        }
        logger.exiting(CLASSNAME, "updateAuthorizationTable()");
        return false;
    }

    private boolean refreshRoles() throws IscDeployExtensionException {
        logger.entering(CLASSNAME, "refreshRoles()");
        return true;
    }

    private HashSet getRolesToBeCreated() throws IscDeployExtensionException {
        logger.entering(CLASSNAME, "getRolesToBeCreated()");
        if (this.securityResource == null) {
            logger.exiting(CLASSNAME, "getRolesToBeCreated()");
            return null;
        }
        DocumentRoot documentRoot = (DocumentRoot)this.securityResource.getContents().get(0);
        IbmPortalSecurity ibmPortalSecurity = documentRoot.getIbmPortalSecurity();
        EList eList = ibmPortalSecurity.getApplicationRole();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ApplicationRole applicationRole = (ApplicationRole)iterator.next();
            if (!this.validateRolesToBeCreated(hashSet, applicationRole.getUniqueName())) {
                throw new IscDeployExtensionException("Unable to update any super roles defined in this ISC Module due to duplicate roles or same role with different case in the ibm-portal-security.xml file or role has invalid character");
            }
            if ("all authenticated portal users".equals(applicationRole.getUniqueName())) continue;
            hashSet.add(applicationRole.getUniqueName());
            logger.log(Level.FINE, "SuperRole is :" + applicationRole.getUniqueName());
        }
        logger.exiting(CLASSNAME, "getRolesToBeCreated()");
        return hashSet;
    }

    private boolean validateRolesToBeCreated(HashSet hashSet, String string) {
        logger.entering(CLASSNAME, "validateRolesToBeCreated()");
        if (string.indexOf(",") != -1) {
            logger.logp(Level.SEVERE, CLASSNAME, "validateRolesToBeCreated()", "Commas are not allowed in roles:" + string);
            logger.exiting(CLASSNAME, "validateRolesToBeCreated()");
            return false;
        }
        if ("all authenticated portal users".equalsIgnoreCase(string) && !"all authenticated portal users".equals(string)) {
            logger.logp(Level.SEVERE, CLASSNAME, "validateRolesToBeCreated()", "Same role '" + string + "' with different alphabetic case is found in the ibm-portal-security.xml, Please check roles in the ibm-portal-security.xml file.");
            return false;
        }
        if (hashSet.contains(string)) {
            logger.logp(Level.SEVERE, CLASSNAME, "validateRolesToBeCreated()", "Duplicate role '" + string + "' is found in the ibm-portal-security.xml, Please check roles in the ibm-portal-security.xml file.");
            logger.exiting(CLASSNAME, "validateRolesToBeCreated()");
            return false;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().toString().equalsIgnoreCase(string)) continue;
            logger.logp(Level.SEVERE, CLASSNAME, "validateRolesToBeCreated()", "Same role '" + string + "' with different alphabetic case is found in the ibm-portal-security.xml, Please check roles in the ibm-portal-security.xml file.");
            logger.exiting(CLASSNAME, "validateRolesToBeCreated()");
            return false;
        }
        logger.exiting(CLASSNAME, "validateRolesToBeCreated()");
        return true;
    }

    private String getWEBINFPathFromDeploy() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("isclite.war").append(File.separatorChar);
        stringBuffer.append("WEB-INF");
        return stringBuffer.toString();
    }

    private String getRelPathToISCDeploy() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cells").append(File.separatorChar);
        stringBuffer.append((String)this.props.get("cell.name")).append(File.separatorChar);
        stringBuffer.append("applications").append(File.separatorChar);
        stringBuffer.append("isclite.ear").append(File.separatorChar);
        stringBuffer.append("deployments").append(File.separatorChar);
        stringBuffer.append("isclite");
        return stringBuffer.toString();
    }

    private void setupWorkSpace() throws IscDeployExtensionException {
        logger.entering(CLASSNAME, "setupWorkSpace()");
        this.ws = this.updateScheduler.getWorkSpace();
        logger.log(Level.FINE, "ws.getPath()" + this.ws.getPath());
        this.rc = this.ws.getRootContext();
        logger.log(Level.FINE, "rc.getPath()" + this.rc.getPath());
        String string = "cells" + File.separatorChar + (String)this.props.get("cell.name") + File.separatorChar + "admin-authz.xml";
        String string2 = this.getRelPathToInstalledWar() + File.separatorChar + "ibm-portal-security.xml";
        this.extractWorkSpace(string2, string);
        this.resSet = new ResourceSetImpl();
        RepositoryContext repositoryContext = null;
        try {
            repositoryContext = this.ws.findContext("cells/" + (String)this.props.get("cell.name"));
        }
        catch (WorkSpaceException workSpaceException) {
            logger.exiting(CLASSNAME, "setupWorkSpace()");
            throw new IscDeployExtensionException("Unable to find the cell context in the workspace", workSpaceException);
        }
        this.pathToAdminAuthzXml = this.rc.getPath() + File.separatorChar + string;
        this.pathToSecurityXml = this.rc.getPath() + File.separatorChar + string2;
        URI uRI = URI.createFileURI((String)this.pathToAdminAuthzXml);
        URI uRI2 = URI.createFileURI((String)this.pathToSecurityXml);
        this.adminAuthzResource = repositoryContext.getResourceSet().createResource(URI.createURI((String)"admin-authz.xml"));
        try {
            this.securityResource = this.resSet.getResource(uRI2, true);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, CLASSNAME + ".setupWorkSpace:  ibm_portal_security.xml does not exist. ");
        }
        if (this.securityResource != null) {
            try {
                this.securityResource.load(new HashMap());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            this.adminAuthzResource.load(new HashMap());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        logger.exiting(CLASSNAME, "setupWorkSpace()");
    }

    private void extractWorkSpace(String string, String string2) throws IscDeployExtensionException {
        logger.entering(CLASSNAME, "extractWorkSpace()");
        try {
            String string3 = this.getRelPathToISCDeploy();
            RepositoryContext repositoryContext = this.ws.findContext(string3);
            this.ws.extract(repositoryContext, string, false);
        }
        catch (WorkSpaceException workSpaceException) {
            logger.log(Level.SEVERE, workSpaceException.getMessage());
            logger.exiting(CLASSNAME, "extractWorkSpace()");
            throw new IscDeployExtensionException("Unable to extract from the config repository", workSpaceException);
        }
        logger.exiting(CLASSNAME, "extractWorkSpace()");
    }

    private String getRelPathToInstalledWar() {
        logger.entering(CLASSNAME, "getRelPathToInstalledWar()");
        logger.exiting(CLASSNAME, "getRelPathToInstalledWar()");
        return "cells" + File.separatorChar + (String)this.props.get("cell.name") + File.separatorChar + "applications" + File.separatorChar + "isclite.ear" + File.separatorChar + "deployments" + File.separatorChar + "isclite" + File.separatorChar + this.war.getName() + File.separatorChar + "WEB-INF";
    }

    public boolean removeExtension(Scheduler scheduler, String string) throws IscDeployExtensionException {
        return true;
    }
}

