/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.deploy.task;

import com.ibm.isclite.datastore.deploy.UpdateNavigationImpl;
import com.ibm.isclite.datastore.deploy.augvalidation.AugmentedValidationException;
import com.ibm.isclite.deploy.extensions.DeploymentExtensionManager;
import com.ibm.isclite.deploy.helper.ComponentAlreadyExistsException;
import com.ibm.isclite.deploy.helper.ComponentRegistryException;
import com.ibm.isclite.deploy.helper.FailedPrereqException;
import com.ibm.isclite.deploy.helper.IscDeployCoreException;
import com.ibm.isclite.deploy.helper.NavTreeUpdateException;
import com.ibm.isclite.deploy.helper.PortletEntityRegistryException;
import com.ibm.isclite.deploy.util.FileUtil;
import com.ibm.isclite.deploy.util.IscSchemaValidationException;
import com.ibm.isclite.deploy.util.XmlSchemaValidator;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;

public abstract class AbstractIscTask
extends AbstractTask {
    protected static String CLASSNAME;
    protected static Logger logger;
    protected ResourceBundle bundle;
    protected Hashtable props;
    protected Scheduler genericScheduler;

    public int decideAppType(WARFile wARFile) {
        if (wARFile == null) {
            return 5;
        }
        logger.logp(Level.INFO, CLASSNAME, "decideAppType", wARFile.getName());
        if (!this.genericScheduler.getAppName().equalsIgnoreCase("isclite")) {
            logger.logp(Level.INFO, CLASSNAME, "decideAppType", "ISC App is not targeted for WSC...skipping.");
            return 1;
        }
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = wARFile.getFiles().iterator();
        while (iterator.hasNext()) {
            org.eclipse.jst.j2ee.commonarchivecore.internal.File file = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)iterator.next();
            if (file.getURI().endsWith("ibm-portal-topology.xml")) {
                bl = true;
            }
            if (!file.getURI().endsWith("portlet.xml")) continue;
            bl2 = true;
        }
        if (!bl) {
            logger.logp(Level.INFO, CLASSNAME, "decideAppType", "This is not an ISC App as there is no ibm-portal-topology.xml");
            return 1;
        }
        if (bl && bl2) {
            logger.logp(Level.INFO, CLASSNAME, "decideAppType", "This is an ISC portlet application as it contains a ibm-portal-topology.xml and portlet.xml");
            return 2;
        }
        if (bl && !bl2) {
            logger.logp(Level.INFO, CLASSNAME, "decideAppType", "This is an ISC Reuse case as it only contains ibm-portal-topology.xml");
            return 4;
        }
        return 5;
    }

    protected String getRelPathToISCApp() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cells").append(File.separatorChar);
        stringBuffer.append((String)this.props.get("cell.name")).append(File.separatorChar);
        stringBuffer.append("applications").append(File.separatorChar);
        stringBuffer.append("isclite.ear").append(File.separatorChar);
        stringBuffer.append("deployments").append(File.separatorChar);
        stringBuffer.append("isclite").append(File.separatorChar);
        stringBuffer.append("isclite.war").append(File.separatorChar);
        stringBuffer.append("WEB-INF");
        return stringBuffer.toString();
    }

    protected String getRelPathToInstalledWar(WARFile wARFile) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cells").append(File.separatorChar);
        stringBuffer.append((String)this.props.get("cell.name")).append(File.separatorChar);
        stringBuffer.append("applications").append(File.separatorChar);
        stringBuffer.append("isclite.ear").append(File.separatorChar);
        stringBuffer.append("deployments").append(File.separatorChar);
        stringBuffer.append("isclite").append(File.separatorChar);
        stringBuffer.append(wARFile.getName()).append(File.separatorChar);
        stringBuffer.append("WEB-INF");
        return stringBuffer.toString();
    }

    protected String getSavingContext(WARFile wARFile) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cells").append(File.separatorChar);
        stringBuffer.append((String)this.props.get("cell.name")).append(File.separatorChar);
        stringBuffer.append("applications").append(File.separatorChar);
        stringBuffer.append("isclite.ear").append(File.separatorChar);
        stringBuffer.append("deployments").append(File.separatorChar);
        stringBuffer.append("isclite").append(File.separatorChar);
        stringBuffer.append(wARFile.getName()).append(File.separatorChar);
        stringBuffer.append("WEB-INF");
        return stringBuffer.toString();
    }

    protected String getWEBINFPathFromDeploy() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("isclite.war").append("/");
        stringBuffer.append("WEB-INF");
        return stringBuffer.toString();
    }

    protected String getWEBINFPathFromDeploy(WARFile wARFile) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(wARFile.getName()).append("/");
        stringBuffer.append("WEB-INF");
        return stringBuffer.toString();
    }

    protected String getRelPathToISCDeploy() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cells").append("/");
        stringBuffer.append((String)this.props.get("cell.name")).append("/");
        stringBuffer.append("applications").append("/");
        stringBuffer.append("isclite.ear").append("/");
        stringBuffer.append("deployments").append("/");
        stringBuffer.append("isclite");
        return stringBuffer.toString();
    }

    protected boolean deployPortlet(WARFile wARFile, boolean bl, boolean bl2) throws IscDeployCoreException, IscSchemaValidationException, AugmentedValidationException {
        logger.entering(CLASSNAME, "deployPortlet()");
        WorkSpace workSpace = this.genericScheduler.getWorkSpace();
        RepositoryContext repositoryContext = workSpace.getRootContext();
        String string = this.getRelPathToISCApp();
        String string2 = this.getRelPathToInstalledWar(wARFile);
        String string3 = this.getWEBINFPathFromDeploy(wARFile) + File.separatorChar + "portlet.xml";
        String string4 = this.getWEBINFPathFromDeploy(wARFile) + File.separatorChar + "ibm-portal-topology.xml";
        String string5 = this.getWEBINFPathFromDeploy() + File.separatorChar + "navigation.xml";
        String string6 = this.getWEBINFPathFromDeploy() + File.separatorChar + "components.xml";
        String string7 = this.getWEBINFPathFromDeploy() + File.separatorChar + "portletEntities.xml";
        String string8 = repositoryContext.getPath() + File.separatorChar + string2;
        String string9 = repositoryContext.getPath() + File.separatorChar + string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("was.install.root")).append(File.separator).append("systemApps").append(File.separator).append("isclite.ear").append(File.separator).append("isclite.war").append(File.separator).append("WEB-INF").append(File.separatorChar).append("ibm-portlet-ext.xmi.template");
        String string10 = stringBuffer.toString();
        String string11 = string8 + File.separatorChar + "ibm-portlet-ext.xmi";
        String string12 = this.getWEBINFPathFromDeploy(wARFile) + File.separatorChar + "ibm-portlet-ext.xmi";
        if (logger.isLoggable(Level.INFO)) {
            logger.logp(Level.INFO, CLASSNAME, "deployPortlet", "war.getName " + wARFile.getName());
            logger.logp(Level.INFO, CLASSNAME, "deployPortlet", "getDirectoryURI " + wARFile.getDirectoryURI());
            logger.logp(Level.INFO, CLASSNAME, "deployPortlet", "ws.getPath()" + workSpace.getPath());
            logger.logp(Level.INFO, CLASSNAME, "deployPortlet", "rc.getPath()" + repositoryContext.getPath());
            logger.logp(Level.INFO, CLASSNAME, "deployPortlet", "pathToInstalledWar :" + string8);
            logger.logp(Level.INFO, CLASSNAME, "deployPortlet", "pathToISCApp :" + string9);
            logger.logp(Level.INFO, CLASSNAME, "deployPortlet", "fromPortletExtXMI:" + string10 + "  toPortletExtXMI:" + string11);
            logger.logp(Level.INFO, CLASSNAME, "deployPortlet", "ibmPortletExtXmiUri: " + string12);
        }
        this.extractWorkSpace(workSpace, repositoryContext, string3, string4, string5, string6, string7);
        try {
            string3 = repositoryContext.getPath() + File.separatorChar + string3;
            logger.logp(Level.INFO, CLASSNAME, "deployPortlet", "portletXmlUri: " + string3);
            this.addPortletExtXmiFile(string10, string11, string3);
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, CLASSNAME, "deployPortlet", "can't copy : " + string10);
            exception.printStackTrace();
        }
        this.updateDepWorkSpace(repositoryContext, string12);
        if (bl2) {
            String string13 = System.getProperty("was.install.root") + File.separator + "properties" + File.separator + "schemas";
            XmlSchemaValidator xmlSchemaValidator = new XmlSchemaValidator("ibm-portal-topology.xml", string13);
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string8 + File.separatorChar + "ibm-portal-topology.xml");
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IscDeployCoreException("Cannot find ibm-portal-topology.xml", fileNotFoundException);
            }
            if (!xmlSchemaValidator.isValid(fileInputStream)) {
                return false;
            }
            XmlSchemaValidator xmlSchemaValidator2 = new XmlSchemaValidator("ibm-portal-security.xml", string13);
            try {
                fileInputStream = new FileInputStream(string8 + File.separatorChar + "ibm-portal-security.xml");
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!this.updateDatastore(wARFile, string9, string8, bl)) {
                    return false;
                }
                this.updateWorkSpace(repositoryContext, string5, string6, string7);
                this.runExtenstions(wARFile);
                return true;
            }
            if (xmlSchemaValidator2.isValid(fileInputStream)) {
                if (!this.updateDatastore(wARFile, string9, string8, bl)) {
                    return false;
                }
                this.updateWorkSpace(repositoryContext, string5, string6, string7);
                this.runExtenstions(wARFile);
                return true;
            }
            return false;
        }
        if (!this.updateDatastore(wARFile, string9, string8, bl)) {
            return false;
        }
        this.updateWorkSpace(repositoryContext, string5, string6, string7);
        this.runExtenstions(wARFile);
        return true;
    }

    protected void extractWorkSpace(WorkSpace workSpace, RepositoryContext repositoryContext, String string, String string2, String string3, String string4, String string5) throws IscDeployCoreException {
        try {
            String string6 = this.getRelPathToISCDeploy();
            RepositoryContext repositoryContext2 = workSpace.findContext(string6);
            workSpace.extract(repositoryContext2, string, false);
            workSpace.extract(repositoryContext2, string2, false);
            workSpace.extract(repositoryContext2, string3, false);
            workSpace.extract(repositoryContext2, string4, false);
            workSpace.extract(repositoryContext2, string5, false);
        }
        catch (WorkSpaceException workSpaceException) {
            logger.logp(Level.SEVERE, CLASSNAME, "extractWorkSpace", workSpaceException.getMessage());
            FFDCFilter.processException((Throwable)workSpaceException, (String)(CLASSNAME + ".extractWorkSpace()"), (String)"1000", (Object)((Object)this));
            throw new IscDeployCoreException("Unable to extract from the config repository", workSpaceException);
        }
    }

    protected boolean deployReusePortlet(WARFile wARFile, boolean bl) throws IscDeployCoreException, IscSchemaValidationException, AugmentedValidationException {
        logger.entering(CLASSNAME, "deployReusePortlet()");
        WorkSpace workSpace = this.genericScheduler.getWorkSpace();
        RepositoryContext repositoryContext = workSpace.getRootContext();
        String string = this.getRelPathToISCApp();
        String string2 = this.getRelPathToInstalledWar(wARFile);
        String string3 = this.getWEBINFPathFromDeploy(wARFile) + File.separatorChar + "ibm-portal-topology.xml";
        String string4 = this.getWEBINFPathFromDeploy() + File.separatorChar + "navigation.xml";
        String string5 = this.getWEBINFPathFromDeploy() + File.separatorChar + "components.xml";
        String string6 = this.getWEBINFPathFromDeploy() + File.separatorChar + "portletEntities.xml";
        String string7 = repositoryContext.getPath() + File.separatorChar + string2;
        String string8 = repositoryContext.getPath() + File.separatorChar + string;
        if (logger.isLoggable(Level.INFO)) {
            logger.logp(Level.INFO, CLASSNAME, "deployReusePortlet", "war.getName " + wARFile.getName());
            logger.logp(Level.INFO, CLASSNAME, "deployReusePortlet", "getDirectoryURI " + wARFile.getDirectoryURI());
            logger.logp(Level.INFO, CLASSNAME, "deployReusePortlet", "ws.getPath()" + workSpace.getPath());
            logger.logp(Level.INFO, CLASSNAME, "deployReusePortlet", "rc.getPath()" + repositoryContext.getPath());
            logger.logp(Level.INFO, CLASSNAME, "deployReusePortlet", "pathToInstalledWar :" + string7);
            logger.logp(Level.INFO, CLASSNAME, "deployReusePortlet", "pathToISCApp :" + string8);
        }
        this.extractReuseWorkSpace(workSpace, repositoryContext, string3, string4, string5, string6);
        String string9 = System.getProperty("was.install.root") + File.separator + "properties" + File.separator + "schemas";
        XmlSchemaValidator xmlSchemaValidator = new XmlSchemaValidator("ibm-portal-topology.xml", string9);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string7 + File.separatorChar + "ibm-portal-topology.xml");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IscDeployCoreException("Cannot find ibm-portal-topology.xml", fileNotFoundException);
        }
        if (xmlSchemaValidator.isValid(fileInputStream)) {
            if (!this.updateDatastore(wARFile, string8, string7, bl)) {
                return false;
            }
            this.updateWorkSpace(repositoryContext, string4, string5, string6);
            this.runExtenstions(wARFile);
            return true;
        }
        return false;
    }

    protected void extractReuseWorkSpace(WorkSpace workSpace, RepositoryContext repositoryContext, String string, String string2, String string3, String string4) throws IscDeployCoreException {
        try {
            String string5 = this.getRelPathToISCDeploy();
            RepositoryContext repositoryContext2 = workSpace.findContext(string5);
            workSpace.extract(repositoryContext2, string, false);
            workSpace.extract(repositoryContext2, string2, false);
            workSpace.extract(repositoryContext2, string3, false);
            workSpace.extract(repositoryContext2, string4, false);
        }
        catch (WorkSpaceException workSpaceException) {
            logger.logp(Level.SEVERE, CLASSNAME, "extractReuseWorkSpace", workSpaceException.getMessage());
            FFDCFilter.processException((Throwable)workSpaceException, (String)(CLASSNAME + ".extractReuseWorkSpace()"), (String)"1000", (Object)((Object)this));
            throw new IscDeployCoreException("Unable to extract from the config repository", workSpaceException);
        }
    }

    protected boolean updateDatastore(WARFile wARFile, String string, String string2, boolean bl) throws IscDeployCoreException, AugmentedValidationException {
        UpdateNavigationImpl updateNavigationImpl = new UpdateNavigationImpl(string);
        updateNavigationImpl.setPAAValidator(bl);
        String string3 = this.getSavingContext(wARFile);
        try {
            if (!updateNavigationImpl.addNode(string2, string3, wARFile.getName())) {
                logger.logp(Level.INFO, CLASSNAME, "updateDatastore", "Error updating the navigation tree");
                return false;
            }
        }
        catch (ComponentRegistryException componentRegistryException) {
            logger.logp(Level.SEVERE, CLASSNAME, "updateDatastore", componentRegistryException.getMessage());
            FFDCFilter.processException((Throwable)componentRegistryException, (String)(CLASSNAME + ".updateDatastore()"), (String)"1001", (Object)((Object)this));
            String string4 = FileUtil.getMessage("deploy.task.failure");
            this.genericScheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", string4, null));
            throw new IscDeployCoreException("Error deploying this ISC Application:" + componentRegistryException.getMessage());
        }
        catch (NavTreeUpdateException navTreeUpdateException) {
            logger.logp(Level.SEVERE, CLASSNAME, "updateDatastore", navTreeUpdateException.getMessage());
            FFDCFilter.processException((Throwable)navTreeUpdateException, (String)(CLASSNAME + ".updateDatastore()"), (String)"1001", (Object)((Object)this));
            String string5 = FileUtil.getMessage("deploy.task.failure");
            this.genericScheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", string5, null));
            throw new IscDeployCoreException("Error deploying this ISC Application:" + navTreeUpdateException.getMessage());
        }
        catch (ComponentAlreadyExistsException componentAlreadyExistsException) {
            logger.logp(Level.SEVERE, CLASSNAME, "updateDatastore", componentAlreadyExistsException.getMessage());
            FFDCFilter.processException((Throwable)componentAlreadyExistsException, (String)(CLASSNAME + ".updateDatastore()"), (String)"1001", (Object)((Object)this));
            String string6 = FileUtil.getMessage("deploy.task.failure");
            this.genericScheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", string6, null));
            throw new IscDeployCoreException("Error deploying this ISC Application:" + componentAlreadyExistsException.getMessage());
        }
        catch (FailedPrereqException failedPrereqException) {
            logger.logp(Level.SEVERE, CLASSNAME, "updateDatastore", failedPrereqException.getMessage());
            FFDCFilter.processException((Throwable)failedPrereqException, (String)(CLASSNAME + ".updateDatastore()"), (String)"1001", (Object)((Object)this));
            String string7 = FileUtil.getMessage("deploy.task.failure");
            this.genericScheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", string7, null));
            throw new IscDeployCoreException("Error deploying this ISC Application:" + failedPrereqException.getMessage());
        }
        catch (AugmentedValidationException augmentedValidationException) {
            augmentedValidationException.printStackTrace();
        }
        catch (PortletEntityRegistryException portletEntityRegistryException) {
            logger.logp(Level.SEVERE, CLASSNAME, "updateDatastore", portletEntityRegistryException.getMessage());
            FFDCFilter.processException((Throwable)portletEntityRegistryException, (String)(CLASSNAME + ".updateDatastore()"), (String)"1001", (Object)((Object)this));
            String string8 = FileUtil.getMessage("deploy.task.failure");
            this.genericScheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", string8, null));
            throw new IscDeployCoreException("Error deploying this ISC Application:" + portletEntityRegistryException.getMessage());
        }
        catch (IscDeployCoreException iscDeployCoreException) {
            iscDeployCoreException.printStackTrace();
        }
        return true;
    }

    protected void updateWorkSpace(RepositoryContext repositoryContext, String string, String string2, String string3) throws IscDeployCoreException {
        String string4 = this.getRelPathToISCDeploy();
        try {
            RepositoryContext repositoryContext2 = repositoryContext.findContext(string4);
            repositoryContext2.notifyChanged(1, string);
            repositoryContext2.notifyChanged(1, string2);
            StringBuffer stringBuffer = new StringBuffer(System.getProperty("was.repository.root")).append(File.separatorChar);
            stringBuffer.append(this.getRelPathToISCApp()).append(File.separatorChar).append("portletEntities.xml");
            logger.logp(Level.FINE, CLASSNAME, "updateWorkSpace", "Absoulte Path to portletEntities.xml to check for file existence, absPathToPortletEntitiesXml= " + stringBuffer.toString());
            if (!new File(stringBuffer.toString()).isFile()) {
                logger.logp(Level.FINE, CLASSNAME, "updateWorkSpace", "Since portletEntities.xml does not exist, we will added a portletEntities.xml");
                repositoryContext2.notifyChanged(0, string3);
            } else {
                repositoryContext2.notifyChanged(1, string3);
            }
        }
        catch (WorkSpaceException workSpaceException) {
            logger.logp(Level.SEVERE, CLASSNAME, "updateWorkSpace", workSpaceException.getMessage());
            FFDCFilter.processException((Throwable)workSpaceException, (String)(CLASSNAME + ".deleteOperation()"), (String)"1003", (Object)((Object)this));
            throw new IscDeployCoreException("Cannot update ibm-portal-topology.xml and navigation.xml", workSpaceException);
        }
    }

    protected void updateDepWorkSpace(RepositoryContext repositoryContext, String string) throws IscDeployCoreException {
        String string2 = this.getRelPathToISCDeploy();
        try {
            RepositoryContext repositoryContext2 = repositoryContext.findContext(string2);
            repositoryContext2.notifyChanged(0, string);
        }
        catch (WorkSpaceException workSpaceException) {
            logger.logp(Level.SEVERE, CLASSNAME, "updateDepWorkSpace", workSpaceException.getMessage());
            FFDCFilter.processException((Throwable)workSpaceException, (String)(CLASSNAME + ".deleteOperation()"), (String)"1003", (Object)((Object)this));
            throw new IscDeployCoreException("Cannot update ibm-portal-topology.xml and navigation.xml", workSpaceException);
        }
    }

    protected void runExtenstions(WARFile wARFile) throws IscDeployCoreException {
        logger.entering(CLASSNAME, "runExtenstions()");
        logger.logp(Level.INFO, CLASSNAME, "runExtenstions", "war.getName " + wARFile.getName());
        DeploymentExtensionManager deploymentExtensionManager = new DeploymentExtensionManager();
        deploymentExtensionManager.execDeployExtensions(this.genericScheduler, wARFile);
    }

    protected void addPortletExtXmiFile(String string, String string2, String string3) throws Exception {
        String string4 = "addPortletExtXmiFile";
        logger.entering(CLASSNAME, string4);
        logger.logp(Level.INFO, CLASSNAME, string4, "srcPortletExtXmi: " + string + ", destPortletExtXmi: " + string2 + ", portletXmlUri: " + string3);
        String string5 = this.readFile(string);
        String string6 = "WEB-INF/portlet.xml#PortletApp_ID";
        logger.logp(Level.INFO, CLASSNAME, string4, "updating href in ibm-portlet.ext.xmi to : " + string6);
        if (string5 != null) {
            string5 = string5.replaceAll("@@PortletApp_ID@@", string6);
        }
        this.writeToFile(string5, string2);
        logger.exiting(CLASSNAME, string4);
    }

    public String readFile(String string) throws Exception {
        String string2 = "";
        BufferedReader bufferedReader = null;
        try {
            String string3;
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string2 + string3 + "\r";
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return string2;
    }

    public void writeToFile(String string, String string2) throws Exception {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string2));
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }
}

