/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.deploy.task;

import com.ibm.etools.commonarchive.EARFile;
import com.ibm.isclite.datastore.deploy.augvalidation.AugmentedValidationException;
import com.ibm.isclite.deploy.helper.IscDeployCoreException;
import com.ibm.isclite.deploy.task.AbstractIscTask;
import com.ibm.isclite.deploy.util.FileUtil;
import com.ibm.isclite.deploy.util.IscSchemaValidationException;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;

public class IscEarDeployTask
extends AbstractIscTask {
    public IscEarDeployTask() {
        CLASSNAME = "IscEarDeployTask";
        logger = Logger.getLogger(IscEarDeployTask.class.getName());
        this.props = null;
    }

    private void log(String string) {
        FileUtil.debug(string);
        logger.logp(Level.INFO, CLASSNAME, "performTask", string);
    }

    public boolean performTask() throws AdminException {
        EARFile eARFile = null;
        WARFile wARFile = null;
        logger.entering(CLASSNAME, "performTask");
        this.genericScheduler = this.scheduler;
        this.props = this.genericScheduler.getProperties();
        eARFile = ((InstallScheduler)this.genericScheduler).getEarFile(false, true);
        this.log("Earfile:" + eARFile.getName());
        try {
            this.log("Path:" + eARFile.getAbsolutePath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log("cant get absolute path:" + fileNotFoundException.getMessage());
        }
        if (eARFile.getName().equals("isclite.ear")) {
            this.log("Iterating through files in ear...");
            Object object = eARFile.getWARFiles().iterator();
            while (object.hasNext()) {
                wARFile = (WARFile)object.next();
                this.log("Ear contains warfile:" + wARFile.getName());
                if (this.decideAppType(wARFile) != 2) continue;
                try {
                    if (!this.deployPortlet(wARFile, false, false)) {
                        String string = FileUtil.getMessage("deploy.task.failure.general");
                        this.genericScheduler.propagateTaskEvent(this.createNotification("Failed", string, null));
                        FileUtil.closedebug();
                        return false;
                    }
                    this.log("Successfully deployed ISC Application:" + wARFile.getName());
                }
                catch (IscDeployCoreException iscDeployCoreException) {
                    this.log(iscDeployCoreException.getMessage());
                    FFDCFilter.processException((Throwable)iscDeployCoreException, (String)(CLASSNAME + ".performTask()"), (String)"1001", (Object)((Object)this));
                    String string = FileUtil.getMessage("deploy.task.failure.general");
                    this.genericScheduler.propagateTaskEvent(this.createNotification("Failed", string, null));
                    throw new AdminException("Error deploying this ISC Application:" + wARFile.getName());
                }
                catch (IscSchemaValidationException iscSchemaValidationException) {
                    this.log(iscSchemaValidationException.getMessage());
                    FFDCFilter.processException((Throwable)iscSchemaValidationException, (String)(CLASSNAME + ".performTask()"), (String)"1001", (Object)((Object)this));
                    String string = FileUtil.getMessage("deploy.task.validation.failure");
                    this.genericScheduler.propagateTaskEvent(this.createNotification("Failed", string, null));
                    throw new AdminException("The ISC PAA instance documents do not validate against the PAA schema");
                }
                catch (AugmentedValidationException augmentedValidationException) {
                    this.log(augmentedValidationException.getMessage());
                    FFDCFilter.processException((Throwable)augmentedValidationException, (String)(CLASSNAME + ".performTask()"), (String)"1001", (Object)((Object)this));
                    String string = FileUtil.getMessage("deploy.task.aug.validation.failure");
                    this.genericScheduler.propagateTaskEvent(this.createNotification("Failed", string, null));
                    throw new AdminException("The ISC PAA instance documents have incomplete information");
                }
            }
            this.log("Ear deploy task completed successfully.");
            object = FileUtil.getMessage("deploy.task.success");
            this.genericScheduler.propagateTaskEvent(this.createNotification("Completed", (String)object, null));
            FileUtil.closedebug();
            return true;
        }
        FileUtil.closedebug();
        return true;
    }
}

