/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.deploy.task;

import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;

public class IscSyncTask
extends AbstractAppSyncTask {
    private static String CLASSNAME = "IscSyncTask";
    private static Logger logger = Logger.getLogger(IscSyncTask.class.getName());
    private List wars = null;
    private WARFile w = null;
    private static String iscstring = "isclite";

    public boolean performTask(AppData appData, AppData appData2, Hashtable hashtable) throws Exception {
        logger.entering(CLASSNAME, "performTask");
        logger.log(Level.FINE, "cacheapp:" + appData.getAppName() + " newapp:" + appData2.getAppName());
        if (!this.appIsDeployedOnNode(appData2.getAppName())) {
            return true;
        }
        if (!iscstring.equals(appData2.getAppName())) {
            return true;
        }
        this.wars = (List)appData2.getPartialUpdateModuleDetails().get("DOCSADDED_KEY");
        if (this.wars.size() == 0) {
            logger.log(Level.FINE, "No modules were added, don't need to unzip ISC WAR module.");
            logger.exiting(CLASSNAME, "performTask");
            return true;
        }
        EARFile eARFile = appData2.getEAR();
        eARFile.close();
        logger.log(Level.FINE, "ISC Wars added" + this.wars);
        Iterator iterator = this.wars.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.w = CommonarchiveFactoryImpl.getActiveFactory().openWARFile(appData2.getBinURL() + File.separator + string);
            int n = this.decideAppType();
            if (n == 2 || n == 4) {
                if (this.isUnzipped()) {
                    logger.log(Level.FINE, "ISC WAR module is already unzipped, skipping unzip.");
                    logger.exiting(CLASSNAME, "performTask");
                    return true;
                }
                logger.log(Level.FINE, "Extracting: " + this.w);
                this.w.extract(2);
            }
            this.w.close();
        }
        eARFile.reopen();
        logger.exiting(CLASSNAME, "performTask");
        return true;
    }

    private boolean isUnzipped() {
        logger.entering(CLASSNAME, "isUnzipped");
        logger.log(Level.FINE, "w,getURI()" + this.w.getURI());
        File file = new File(this.w.getURI());
        if (file.isDirectory()) {
            logger.exiting(CLASSNAME, "isUnzipped");
            return true;
        }
        logger.exiting(CLASSNAME, "isUnzipped");
        return false;
    }

    private int decideAppType() {
        logger.entering(CLASSNAME, "decideAppType()");
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = this.w.getFiles().iterator();
        while (iterator.hasNext()) {
            org.eclipse.jst.j2ee.commonarchivecore.internal.File file = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)iterator.next();
            if (file.getURI().endsWith("ibm-portal-topology.xml") && file.getURI().endsWith("ibm-portal-topology.xml")) {
                bl = true;
            }
            if (!file.getURI().endsWith("portlet.xml")) continue;
            bl2 = true;
        }
        if (!bl) {
            logger.log(Level.FINE, "This is not an ISC App as there is no ibm-portal-topology.xml");
            logger.exiting(CLASSNAME, "decideAppType");
            return 1;
        }
        if (bl && bl2) {
            logger.log(Level.FINE, "This is an ISC portlet application as it contains a ibm-portal-topology.xml and portlet.xml");
            logger.exiting(CLASSNAME, "decideAppType");
            return 2;
        }
        if (bl && !bl2) {
            logger.log(Level.FINE, "This is an ISC Reuse case as it only contains ibm-portal-topology.xml");
            logger.exiting(CLASSNAME, "decideAppType");
            return 4;
        }
        logger.exiting(CLASSNAME, "decideAppType");
        return 5;
    }
}

