/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.deploy.task;

import com.ibm.etools.commonarchive.EARFile;
import com.ibm.isclite.deploy.task.IscEarDeployTask;
import com.ibm.isclite.deploy.task.IscSyncTask;
import com.ibm.isclite.deploy.task.IscWarDeployTask;
import com.ibm.isclite.deploy.task.IscWarRemoveTask;
import com.ibm.websphere.management.application.AppManagementExtensions;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;

public class IscTaskProvider
implements AppManagementExtensions.AppDeploymentTaskProvider,
AppManagementExtensions.AppUpdateTaskProvider,
AppManagementExtensions.AppSyncTaskProvider {
    private static String CLASSNAME = "IscTaskProvider";
    private static Logger logger = Logger.getLogger(IscTaskProvider.class.getName());

    public void provideServerInstallExtensions(Vector vector, InstallScheduler installScheduler) throws AppDeploymentException {
        logger.entering(CLASSNAME, "provideServerInstallExtensions");
        EARFile eARFile = null;
        try {
            eARFile = installScheduler.getEarFile(false, true);
            logger.logp(Level.INFO, CLASSNAME, "provideServerInstallExtentions", "ear.getName " + eARFile.getName());
            vector.addElement(IscEarDeployTask.class.getName());
            logger.logp(Level.INFO, CLASSNAME, "provideServerInstallExtentions", "Added IscEarDeployTask to Vector");
        }
        catch (AdminException adminException) {
            logger.logp(Level.SEVERE, CLASSNAME, "provideServerInstallExtentions", "Error accessing the EAR file");
            FFDCFilter.processException((Throwable)adminException, (String)(CLASSNAME + ".provideServerInstallExtensions()"), (String)"1003", (Object)this);
            throw new AppDeploymentException("Error accessing the EAR file", (Throwable)adminException);
        }
        logger.exiting(CLASSNAME, "provideServerInstallExtensions");
    }

    public void provideServerUninstallExtensions(Vector vector, Scheduler scheduler) throws AppDeploymentException {
        logger.entering(CLASSNAME, "provideServerUninstallExtensions");
        logger.exiting(CLASSNAME, "provideServerUninstallExtensions");
    }

    public void provideClientDeploymentTasks(Vector vector, AppDeploymentInfo appDeploymentInfo, Hashtable hashtable) throws AppDeploymentException {
        logger.entering(CLASSNAME, "provideClientDeploymentTasks");
        logger.exiting(CLASSNAME, "provideClientDeploymentTasks");
    }

    public void provideServerExtensionsForEdit(Vector vector, Scheduler scheduler) throws AppDeploymentException {
    }

    public void provideExtensionsForInstallFailure(Vector vector, InstallScheduler installScheduler) throws AppDeploymentException {
        logger.entering(CLASSNAME, "provideExtensionsForInstallFailure");
        logger.exiting(CLASSNAME, "provideExtensionsForInstallFailure");
    }

    public void provideExtensionsForUninstallFailure(Vector vector, InstallScheduler installScheduler) throws AppDeploymentException {
        logger.entering(CLASSNAME, "provideExtensionsForUninstallFailure");
        logger.exiting(CLASSNAME, "provideExtensionsForUninstallFailure");
    }

    public void provideClientDeploymentTasksForEdit(Vector vector, AppDeploymentInfo appDeploymentInfo, Hashtable hashtable) throws AppDeploymentException {
        logger.entering(CLASSNAME, "provideClientDeploymentTasksForEdit");
        logger.exiting(CLASSNAME, "provideClientDeploymentTasksForEdit");
    }

    public void getAppDeploymentTaskInfoToTaskMapping(Vector vector, Hashtable hashtable) throws AppDeploymentException {
        logger.entering(CLASSNAME, "getAppDeploymentTaskInfoToTaskMapping");
        logger.exiting(CLASSNAME, "getAppDeploymentTaskInfoToTaskMapping");
    }

    public void providePreUpdateTasks(Vector vector, UpdateScheduler updateScheduler) throws AdminException {
        logger.entering(CLASSNAME, "providePreUpdateTasks");
        logger.exiting(CLASSNAME, "providePreUpdateTasks");
    }

    public void provideUpdateTasks(Vector vector, UpdateScheduler updateScheduler) throws AdminException {
        logger.entering(CLASSNAME, "provideUpdateTasks");
        logger.log(Level.FINE, "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        logger.log(Level.FINE, "operation: " + updateScheduler.getOperation());
        if (updateScheduler.getOperation().equals("update") || updateScheduler.getOperation().equals("add")) {
            Archive archive = null;
            WARFile wARFile = null;
            try {
                archive = updateScheduler.getContentAsArchive();
                if (archive instanceof WARFile) {
                    wARFile = (WARFile)archive;
                    logger.log(Level.FINE, "war.getName " + wARFile.getName());
                    vector.addElement(IscWarDeployTask.class.getName());
                    logger.log(Level.FINE, "Added IscWarDeployTask to Vector");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (updateScheduler.getOperation().equals("delete")) {
            logger.log(Level.FINE, "Update Application delete option");
            vector.add(0, IscWarRemoveTask.class.getName());
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.get(i);
                logger.log(Level.FINE, "<" + i + ">" + e.toString());
            }
        }
        logger.exiting(CLASSNAME, "provideUpdateTasks");
    }

    public void provideAppAddedSyncTasks(Vector vector) throws AdminException {
        logger.entering(CLASSNAME, "provideAppAddedSyncTasks");
        logger.exiting(CLASSNAME, "provideAppAddedSyncTasks");
    }

    public void provideAppRemovedSyncTasks(Vector vector) throws AdminException {
        logger.entering(CLASSNAME, "provideAppRemovedSyncTasks");
        logger.exiting(CLASSNAME, "provideAppRemovedSyncTasks");
    }

    public void provideAppModifiedSyncTasks(Vector vector) throws AdminException {
        logger.entering(CLASSNAME, "provideAppModifiedSyncTasks");
        vector.add(3, IscSyncTask.class.getName());
        logger.log(Level.FINE, "Added IscSyncTask to Vector");
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            logger.log(Level.FINE, "<" + i + ">" + e.toString());
        }
        logger.exiting(CLASSNAME, "provideAppModifiedSyncTasks");
    }
}

