/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.deploy.task;

import com.ibm.isclite.datastore.deploy.augvalidation.AugmentedValidationException;
import com.ibm.isclite.deploy.helper.IscDeployCoreException;
import com.ibm.isclite.deploy.task.AbstractIscTask;
import com.ibm.isclite.deploy.util.FileUtil;
import com.ibm.isclite.deploy.util.IscSchemaValidationException;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;

public class IscWarDeployTask
extends AbstractIscTask {
    public IscWarDeployTask() {
        CLASSNAME = "IscWarDeployTask";
        logger = Logger.getLogger(IscWarDeployTask.class.getName());
        this.props = null;
        this.genericScheduler = null;
    }

    private void log(String string) {
        System.out.println(string);
        logger.logp(Level.INFO, CLASSNAME, "performTask", string);
    }

    public boolean performTask() throws AdminException {
        WARFile wARFile = null;
        boolean bl = false;
        logger.entering(CLASSNAME, "performTask");
        this.genericScheduler = this.scheduler;
        this.props = this.genericScheduler.getProperties();
        if (this.props.containsKey("paavalidation")) {
            String string = this.props.get("paavalidation").toString();
            bl = null != string && string.equalsIgnoreCase("true");
        }
        logger.logp(Level.INFO, CLASSNAME, "performTask", "Requested PAA Validation= " + this.props.get("paavalidation") + ", Validation is set to= " + bl);
        wARFile = (WARFile)((UpdateScheduler)this.genericScheduler).getContentAsArchive();
        int n = this.decideAppType(wARFile);
        if (n == 2) {
            try {
                if (!this.deployPortlet(wARFile, bl, true)) {
                    logger.exiting(CLASSNAME, "performTask");
                    String string = FileUtil.getMessage("deploy.task.failure.general");
                    this.genericScheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", string, null));
                    return false;
                }
                logger.exiting(CLASSNAME, "performTask");
                this.log("Successfully deployed ISC Application.");
                String string = FileUtil.getMessage("deploy.task.success");
                this.genericScheduler.propagateTaskEvent(this.createTranslatedNotification("Completed", string, null));
                return true;
            }
            catch (IscDeployCoreException iscDeployCoreException) {
                this.log(iscDeployCoreException.getMessage());
                FFDCFilter.processException((Throwable)iscDeployCoreException, (String)(CLASSNAME + ".performTask()"), (String)"1001", (Object)((Object)this));
                String string = FileUtil.getMessage("deploy.task.failure.general");
                this.genericScheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", string, null));
                throw new AdminException("Error deploying this ISC Application:" + iscDeployCoreException.getMessage());
            }
            catch (IscSchemaValidationException iscSchemaValidationException) {
                this.log(iscSchemaValidationException.getMessage());
                FFDCFilter.processException((Throwable)iscSchemaValidationException, (String)(CLASSNAME + ".performTask()"), (String)"1001", (Object)((Object)this));
                String string = FileUtil.getMessage("deploy.task.validation.failure");
                this.genericScheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", string, null));
                throw new AdminException("The ISC PAA instance documents do not validate against the PAA schema:" + iscSchemaValidationException.getMessage());
            }
            catch (AugmentedValidationException augmentedValidationException) {
                this.log(augmentedValidationException.getMessage());
                FFDCFilter.processException((Throwable)augmentedValidationException, (String)(CLASSNAME + ".performTask()"), (String)"1001", (Object)((Object)this));
                String string = FileUtil.getMessage("deploy.task.aug.validation.failure");
                this.genericScheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", string, null));
                throw new AdminException("The ISC PAA instance documents have incomplete information:" + augmentedValidationException.getMessage());
            }
        }
        if (n == 4) {
            try {
                if (!this.deployReusePortlet(wARFile, bl)) {
                    logger.exiting(CLASSNAME, "performTask");
                    String string = FileUtil.getMessage("deploy.task.failure.general");
                    this.genericScheduler.propagateTaskEvent(this.createNotification("Failed", string, null));
                    return false;
                }
                logger.exiting(CLASSNAME, "performTask");
                this.log("Successfully deployed ISC Application.");
                String string = FileUtil.getMessage("deploy.task.success");
                this.genericScheduler.propagateTaskEvent(this.createNotification("Completed", string, null));
                wARFile.close();
                return true;
            }
            catch (IscDeployCoreException iscDeployCoreException) {
                this.log(iscDeployCoreException.getMessage());
                FFDCFilter.processException((Throwable)iscDeployCoreException, (String)(CLASSNAME + ".performTask()"), (String)"1001", (Object)((Object)this));
                String string = FileUtil.getMessage("deploy.task.failure.general");
                this.genericScheduler.propagateTaskEvent(this.createNotification("Failed", string, null));
                throw new AdminException("Error deploying this ISC Application:" + iscDeployCoreException.getMessage());
            }
            catch (IscSchemaValidationException iscSchemaValidationException) {
                this.log(iscSchemaValidationException.getMessage());
                FFDCFilter.processException((Throwable)iscSchemaValidationException, (String)(CLASSNAME + ".performTask()"), (String)"1001", (Object)((Object)this));
                String string = FileUtil.getMessage("deploy.task.validation.failure");
                this.genericScheduler.propagateTaskEvent(this.createNotification("Failed", string, null));
                throw new AdminException("The ISC PAA instance documents do not validate against the PAA schema:" + iscSchemaValidationException.getMessage());
            }
            catch (AugmentedValidationException augmentedValidationException) {
                this.log(augmentedValidationException.getMessage());
                FFDCFilter.processException((Throwable)augmentedValidationException, (String)(CLASSNAME + ".performTask()"), (String)"1001", (Object)((Object)this));
                String string = FileUtil.getMessage("deploy.task.aug.validation.failure");
                this.genericScheduler.propagateTaskEvent(this.createNotification("Failed", string, null));
                throw new AdminException("The ISC PAA instance documents have incomplete information:" + augmentedValidationException.getMessage());
            }
        }
        wARFile.close();
        return true;
    }
}

