/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.deploy.task;

import com.ibm.isclite.datastore.deploy.UpdateNavigationImpl;
import com.ibm.isclite.deploy.extensions.DeploymentExtensionManager;
import com.ibm.isclite.deploy.helper.IscDeployCoreException;
import com.ibm.isclite.deploy.helper.NavTreeUpdateException;
import com.ibm.isclite.deploy.helper.PortletEntityRegistryException;
import com.ibm.isclite.deploy.util.FileUtil;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.io.File;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IscWarRemoveTask
extends AbstractTask {
    private static String CLASSNAME = "IscWarRemoveTask";
    private static Logger logger = Logger.getLogger(IscWarRemoveTask.class.getName());
    private WorkSpace ws = null;
    private RepositoryContext apprc = null;
    private RepositoryContext iscrc = null;
    private String topologyUri = null;
    private String configPathToInstalledApp = null;
    private String configPathToISCApp = null;
    private Hashtable props = null;
    private Scheduler genericScheduler = null;

    public boolean performTask() throws AdminException {
        logger.entering(CLASSNAME, "performTask");
        this.genericScheduler = this.scheduler;
        this.props = this.genericScheduler.getProperties();
        this.configPathToISCApp = this.getConfigPathToISCApp();
        if (this.isIscApp()) {
            try {
                if (!this.deleteOperation()) {
                    logger.exiting(CLASSNAME, "performTask");
                    String string = FileUtil.getMessage("remove.task.failure");
                    this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", string, null));
                    return false;
                }
                logger.exiting(CLASSNAME, "performTask");
                logger.log(Level.INFO, "Successfully removed ISC portlet module.");
                String string = FileUtil.getMessage("remove.task.success");
                this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Completed", string, null));
                return true;
            }
            catch (IscDeployCoreException iscDeployCoreException) {
                logger.log(Level.SEVERE, iscDeployCoreException.getMessage());
                FFDCFilter.processException((Throwable)iscDeployCoreException, (String)(CLASSNAME + ".performTask()"), (String)"1001", (Object)((Object)this));
                String string = FileUtil.getMessage("remove.task.failure");
                this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", string, null));
                throw new AdminException((Throwable)iscDeployCoreException);
            }
        }
        logger.log(Level.FINE, "Not an ISC App, operation ignored.");
        return true;
    }

    private String getConfigPathToISCApp() throws AdminException {
        String string = null;
        try {
            string = this.scheduler.getCellContext().toString() + File.separatorChar + "applications" + File.separatorChar + "isclite.ear" + File.separatorChar + "deployments" + File.separatorChar + "isclite" + File.separatorChar + "isclite.war" + File.separatorChar + "WEB-INF";
        }
        catch (Exception exception) {
            throw new AdminException((Throwable)exception);
        }
        return string;
    }

    private String getConfigPathToInstalledApp(String string) throws IscDeployCoreException {
        try {
            String string2 = this.scheduler.getCellContext().toString() + File.separatorChar + "applications" + File.separatorChar + "isclite.ear" + File.separatorChar + "deployments" + File.separatorChar + "isclite" + File.separatorChar + string + File.separatorChar + "WEB-INF";
            return string2;
        }
        catch (Exception exception) {
            throw new IscDeployCoreException(exception);
        }
    }

    private String getWEBINFPathFromDeploy() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("isclite.war").append(File.separatorChar);
        stringBuffer.append("WEB-INF");
        return stringBuffer.toString();
    }

    private String getRelPathToISCDeploy() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cells").append(File.separatorChar);
        stringBuffer.append((String)this.props.get("cell.name")).append(File.separatorChar);
        stringBuffer.append("applications").append(File.separatorChar);
        stringBuffer.append("isclite.ear").append(File.separatorChar);
        stringBuffer.append("deployments").append(File.separatorChar);
        stringBuffer.append("isclite");
        return stringBuffer.toString();
    }

    private String getContextRoot(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cells").append(File.separatorChar);
        stringBuffer.append((String)this.props.get("cell.name")).append(File.separatorChar);
        stringBuffer.append("applications").append(File.separatorChar);
        stringBuffer.append("isclite.ear").append(File.separatorChar);
        stringBuffer.append("deployments").append(File.separatorChar);
        stringBuffer.append("isclite").append(File.separatorChar);
        stringBuffer.append(string).append(File.separatorChar);
        stringBuffer.append("WEB-INF");
        return stringBuffer.toString();
    }

    private boolean deleteOperation() throws IscDeployCoreException {
        RepositoryContext repositoryContext;
        logger.entering(CLASSNAME, "deleteOperation()");
        String string = this.iscrc.getPath() + File.separatorChar + this.configPathToISCApp;
        UpdateNavigationImpl updateNavigationImpl = new UpdateNavigationImpl(string);
        this.configPathToInstalledApp = this.getConfigPathToInstalledApp(((UpdateScheduler)this.genericScheduler).getContentURI());
        String string2 = this.apprc.getPath() + File.separatorChar + this.configPathToInstalledApp;
        logger.log(Level.FINE, "pathToInstalledApp :" + string2);
        String string3 = string + File.separatorChar + "navigation.xml";
        String string4 = string + File.separatorChar + "components.xml";
        logger.log(Level.FINE, "navigationXmlUri :" + string3);
        logger.log(Level.FINE, "componentsXmlUri :" + string4);
        String string5 = this.getWEBINFPathFromDeploy() + File.separatorChar + "navigation.xml";
        String string6 = this.getWEBINFPathFromDeploy() + File.separatorChar + "components.xml";
        String string7 = this.configPathToInstalledApp + File.separatorChar + "ibm-portal-topology.xml";
        String string8 = this.getWEBINFPathFromDeploy() + File.separatorChar + "idmap.xml";
        String string9 = this.getWEBINFPathFromDeploy() + File.separatorChar + "portletEntities.xml";
        logger.log(Level.FINE, "configPathToidMapXml :" + string8);
        String string10 = this.getRelPathToISCDeploy();
        try {
            repositoryContext = this.ws.findContext(string10);
            this.ws.extract(repositoryContext, string8, false);
            this.ws.extract(repositoryContext, string7, false);
            this.ws.extract(repositoryContext, string5, false);
            this.ws.extract(repositoryContext, string6, false);
        }
        catch (WorkSpaceException workSpaceException) {
            logger.log(Level.SEVERE, workSpaceException.getMessage());
            FFDCFilter.processException((Throwable)workSpaceException, (String)(CLASSNAME + ".deleteOperation()"), (String)"1000", (Object)((Object)this));
            throw new IscDeployCoreException("Unable to extract from the config repository", workSpaceException);
        }
        try {
            if (!updateNavigationImpl.removeNode(string2)) {
                logger.log(Level.FINE, "Navigation tree was not updated. See previous message.");
                return false;
            }
        }
        catch (NavTreeUpdateException navTreeUpdateException) {
            logger.log(Level.SEVERE, navTreeUpdateException.getMessage());
            FFDCFilter.processException((Throwable)navTreeUpdateException, (String)(CLASSNAME + ".deleteOperation()"), (String)"1003", (Object)((Object)this));
            throw new IscDeployCoreException("Cannot remove application \"" + string2 + "\"", navTreeUpdateException);
        }
        catch (PortletEntityRegistryException portletEntityRegistryException) {
            logger.log(Level.SEVERE, portletEntityRegistryException.getMessage());
            FFDCFilter.processException((Throwable)portletEntityRegistryException, (String)(CLASSNAME + ".deleteOperation()"), (String)"1003", (Object)((Object)this));
            throw new IscDeployCoreException("Cannot remove application \"" + string2 + "\"", portletEntityRegistryException);
        }
        try {
            repositoryContext = this.iscrc.findContext(string10.replace(File.separatorChar, '/'));
            repositoryContext.notifyChanged(1, string5.replace(File.separatorChar, '/'));
            repositoryContext.notifyChanged(1, string6.replace(File.separatorChar, '/'));
            repositoryContext.notifyChanged(1, string8.replace(File.separatorChar, '/'));
            repositoryContext.notifyChanged(1, string9.replace(File.separatorChar, '/'));
        }
        catch (WorkSpaceException workSpaceException) {
            logger.log(Level.SEVERE, workSpaceException.getMessage());
            FFDCFilter.processException((Throwable)workSpaceException, (String)(CLASSNAME + ".deleteOperation()"), (String)"1003", (Object)((Object)this));
            throw new IscDeployCoreException("Cannot update ibm-portal-topology.xml and navigation.xml", workSpaceException);
        }
        this.runExtenstions();
        logger.exiting(CLASSNAME, "deleteOperation");
        return true;
    }

    private boolean isIscApp() {
        logger.entering(CLASSNAME, "isIscApp()");
        if (!this.genericScheduler.getAppName().equalsIgnoreCase("isclite")) {
            logger.logp(Level.INFO, CLASSNAME, "isIscApp", "ISC App is not targeted for WSC...skipping.");
            return false;
        }
        this.ws = this.scheduler.getWorkSpace();
        this.iscrc = this.ws.getRootContext();
        String string = ((UpdateScheduler)this.genericScheduler).getContentURI();
        String string2 = this.getContextRoot(string);
        logger.log(Level.FINE, "Content URI: " + string2);
        this.apprc = this.ws.getRootContext();
        String string3 = this.apprc.getPath() + File.separatorChar + string2 + File.separatorChar + "ibm-portal-topology.xml";
        logger.log(Level.FINE, "checking for existence of " + string3);
        File file = new File(string3);
        return file.exists();
    }

    public void runExtenstions() throws IscDeployCoreException {
        logger.entering(CLASSNAME, "runExtenstions()");
        DeploymentExtensionManager deploymentExtensionManager = new DeploymentExtensionManager();
        deploymentExtensionManager.execRemoveExtensions(this.scheduler, this.configPathToInstalledApp);
        logger.exiting(CLASSNAME, "runExtenstions()");
    }
}

