/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.deploy.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUtil {
    private static String CLASSNAME = "FileUtil";
    private static Logger logger = Logger.getLogger(FileUtil.class.getName());
    private String fileName;
    private JarFile jarfile;
    private String jarEntryToPersist;
    private File file;
    private static HashMap myProps = null;
    static FileOutputStream os = null;
    static PrintStream stream = null;

    public void finalize() {
        FileUtil.closedebug();
    }

    public static void opendebug() {
        String string = System.getProperty("user.install.root") + System.getProperty("file.separator") + "logs" + System.getProperty("file.separator") + "iscinstall.log";
        File file = new File(string);
        try {
            os = new FileOutputStream(file, true);
            stream = new PrintStream(os);
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, CLASSNAME, "processPreprocess()", "exception while printing the request" + exception);
            return;
        }
    }

    public static void debug(String string) {
        if (stream == null) {
            FileUtil.opendebug();
        }
        try {
            stream.println(string);
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, CLASSNAME, "processPreprocess()", "exception while printing the request" + exception);
        }
    }

    public static void closedebug() {
        try {
            stream.close();
            os.close();
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, CLASSNAME, "processPreprocess()", "exception while printing the request" + exception);
        }
    }

    public static void readProperties(InputStream inputStream, HashMap hashMap) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            logger.logp(Level.WARNING, CLASSNAME, "readProperties", "IOException loading properties:" + iOException.getMessage());
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)properties.get(string);
            hashMap.put(string, string2);
        }
    }

    public static String getMessage(String string) {
        if (myProps != null) {
            return (String)myProps.get(string);
        }
        Locale locale = Locale.getDefault();
        String string2 = "com/ibm/isclite/deploy/messages/DeployMessages.properties";
        String string3 = "com/ibm/isclite/deploy/messages/DeployMessages_" + locale.getLanguage() + ".properties";
        String string4 = "com/ibm/isclite/deploy/messages/DeployMessages_" + locale.getLanguage() + "_" + locale.getCountry() + ".properties";
        logger.logp(Level.INFO, CLASSNAME, "getMessage", "Loading internal resources:" + string4);
        InputStream inputStream = null;
        try {
            inputStream = FileUtil.class.getClassLoader().getResourceAsStream(string4);
            if (inputStream == null && (inputStream = FileUtil.class.getClassLoader().getResourceAsStream(string3)) == null) {
                inputStream = FileUtil.class.getClassLoader().getResourceAsStream(string2);
            }
            if (inputStream == null) {
                return string;
            }
            myProps = new HashMap();
            FileUtil.readProperties(inputStream, myProps);
            inputStream.close();
            if (myProps != null) {
                return (String)myProps.get(string);
            }
        }
        catch (IOException iOException) {
            logger.logp(Level.WARNING, CLASSNAME, "getMessage", "IOException: " + iOException.getMessage());
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return FileUtil.getExternalMessage(string);
    }

    public static String getExternalMessage(String string) {
        if (myProps != null) {
            return (String)myProps.get(string);
        }
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("was.install.root"));
        String string2 = System.getProperty("file.separator");
        stringBuffer.append(string2).append("plugins");
        stringBuffer.append(string2).append("com.ibm.ws.webui_1.0.0.jar");
        File file = new File(stringBuffer.toString());
        if (!file.exists()) {
            logger.logp(Level.WARNING, CLASSNAME, "getMessage", stringBuffer.toString() + " not found");
            return string;
        }
        Locale locale = Locale.getDefault();
        String string3 = "com/ibm/isclite/deploy/messages/DeployMessages.properties";
        String string4 = "com/ibm/isclite/deploy/messages/DeployMessages_" + locale.getLanguage() + ".properties";
        String string5 = "com/ibm/isclite/deploy/messages/DeployMessages_" + locale.getLanguage() + "_" + locale.getCountry() + ".properties";
        logger.logp(Level.INFO, CLASSNAME, "getMessage", "Loading external resources:" + string5);
        FileInputStream fileInputStream = null;
        JarInputStream jarInputStream = null;
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        HashMap hashMap3 = null;
        try {
            fileInputStream = new FileInputStream(stringBuffer.toString());
            jarInputStream = new JarInputStream(fileInputStream);
            JarEntry jarEntry = null;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                String string6 = jarEntry.toString();
                logger.logp(Level.INFO, CLASSNAME, "getMessage", "file=" + string6);
                if (string6.equals(string3)) {
                    hashMap3 = new HashMap();
                    FileUtil.readProperties(jarInputStream, hashMap3);
                }
                if (string6.equals(string4)) {
                    hashMap2 = new HashMap();
                    FileUtil.readProperties(jarInputStream, hashMap2);
                }
                if (!string6.equals(string5)) continue;
                hashMap = new HashMap();
                FileUtil.readProperties(jarInputStream, hashMap);
            }
            jarInputStream.close();
            fileInputStream.close();
            if (hashMap != null) {
                myProps = hashMap;
            } else if (hashMap2 != null) {
                myProps = hashMap2;
            } else if (hashMap3 != null) {
                myProps = hashMap3;
            }
            if (myProps != null) {
                return (String)myProps.get(string);
            }
        }
        catch (IOException iOException) {
            logger.logp(Level.WARNING, CLASSNAME, "getMessage", "IOException: " + iOException.getMessage());
        }
        try {
            jarInputStream.close();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean persistFile(InputStream inputStream, String string) {
        logger.entering(CLASSNAME, "persistFile");
        FileOutputStream fileOutputStream = null;
        File file = null;
        try {
            file = new File(string);
            fileOutputStream = new FileOutputStream(file);
            int n = 0;
            byte[] byArray = new byte[8192];
            do {
                fileOutputStream.write(byArray, 0, n);
            } while ((n = inputStream.read(byArray, 0, byArray.length)) != -1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                inputStream.close();
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean persistFile(String string, String string2) {
        logger.entering(CLASSNAME, "persistFile");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return false;
        }
        if (this.persistFile(fileInputStream, string2)) {
            return true;
        }
        System.out.println("Error persisting file " + string);
        return false;
    }

    public boolean removeFile(String string) {
        logger.entering(CLASSNAME, "removeFile");
        return true;
    }
}

