/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.deploy.util;

import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ISCErrorHandler
implements ErrorHandler {
    private static String CLASSNAME = "ISCErrorHandler";
    private static Logger logger = Logger.getLogger(ISCErrorHandler.class.getName());
    private boolean error = false;
    private String xmlFileName;
    private StringBuffer validationInfo = null;
    private String newline = null;

    public ISCErrorHandler(String string) {
        this.xmlFileName = string;
        this.newline = System.getProperty("line.seperator");
        this.validationInfo = new StringBuffer();
        this.validationInfo.append(this.newline);
    }

    public ISCErrorHandler(String string, boolean bl) {
        this(string);
    }

    public String getMessages() {
        logger.entering(CLASSNAME, "getMessages");
        String string = null;
        string = this.validationInfo.toString();
        return string;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        logger.entering(CLASSNAME, "warning");
        String string = "Warning in " + this.xmlFileName + " line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + "." + this.newline;
        String string2 = sAXParseException.getMessage() + this.newline;
        this.validationInfo.append(string);
        this.validationInfo.append(string2);
        logger.exiting(CLASSNAME, "warning");
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        logger.entering(CLASSNAME, "error");
        this.error = true;
        String string = "Error in " + this.xmlFileName + " line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + "." + this.newline;
        String string2 = sAXParseException.getMessage() + this.newline;
        this.validationInfo.append(string);
        this.validationInfo.append(string2);
        logger.exiting(CLASSNAME, "error");
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        logger.entering(CLASSNAME, "fatalError");
        this.error = true;
        String string = "FatalError in " + this.xmlFileName + " line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + "." + this.newline;
        String string2 = sAXParseException.getMessage() + this.newline;
        this.validationInfo.append(string);
        this.validationInfo.append(string2);
        logger.exiting(CLASSNAME, "fatalError");
    }

    public boolean parseError() {
        logger.entering(CLASSNAME, "parseError");
        return this.error;
    }
}

