/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.deploy.util;

import com.ibm.isclite.deploy.util.ISCErrorHandler;
import com.ibm.isclite.deploy.util.IscSchemaValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlSchemaValidator {
    private static String CLASSNAME = "XmlSchemaValidator";
    private static Logger logger = Logger.getLogger(XmlSchemaValidator.class.getName());
    protected static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    protected static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    protected static final String outputEncoding = "UTF-8";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected String baseSchema = null;
    protected String portalSchema = null;
    protected String securitySchema = null;
    protected String[] schemas = new String[3];
    private DocumentBuilder db = null;
    private ISCErrorHandler parserErrorHandler = null;

    public XmlSchemaValidator(String string, String string2) {
        logger.entering(CLASSNAME, "XmlSchemaValidator");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.logp(Level.FINE, CLASSNAME, "XmlSchemaValidator", "Error: JAXP DocumentBuilderFactory attribute not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage");
            illegalArgumentException.printStackTrace();
        }
        this.baseSchema = string2 + "/ibm-portal-base.xsd";
        this.portalSchema = string2 + "/ibm-portal-topology.xsd";
        this.securitySchema = string2 + "/ibm-portal-security.xsd";
        this.schemas[0] = this.baseSchema;
        this.schemas[1] = this.portalSchema;
        this.schemas[2] = this.securitySchema;
        documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, this.schemas);
        try {
            this.db = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        this.parserErrorHandler = new ISCErrorHandler(string);
        this.db.setErrorHandler(this.parserErrorHandler);
        logger.exiting(CLASSNAME, "XmlSchemaValidator");
    }

    public boolean isValid(InputStream inputStream) throws IscSchemaValidationException {
        try {
            this.db.parse(inputStream);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        if (this.parserErrorHandler.parseError()) {
            logger.logp(Level.SEVERE, CLASSNAME, "isValid", "There was a validation error with the PAA XML documents: " + this.parserErrorHandler.getMessages());
            throw new IscSchemaValidationException("Error validating the PAA XML documents. " + this.parserErrorHandler.getMessages());
        }
        return true;
    }

    public Document getValidatedDOM(InputStream inputStream) throws IscSchemaValidationException {
        Document document = null;
        try {
            document = this.db.parse(inputStream);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        if (this.parserErrorHandler.parseError()) {
            logger.logp(Level.SEVERE, CLASSNAME, "getValidatedDOM", "There was a validation error with the PAA XML documents: " + this.parserErrorHandler.getMessages());
            throw new IscSchemaValidationException("Error validating the PAA XML documents. " + this.parserErrorHandler.getMessages());
        }
        return document;
    }
}

