/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.isclite.deploy.util;

import com.ibm.isclite.deploy.util.ISCErrorHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public class XmlUtils {
    private static String CLASSNAME = "XmlUtils";
    private static Logger logger = Logger.getLogger(XmlUtils.class.getName());
    private String fileName;
    private String systemID;
    private File xmlFile = null;
    private InputStream is = null;
    private boolean validating;

    public XmlUtils(String string, String string2) {
        this.fileName = string;
        this.systemID = string2;
        this.validating = true;
        try {
            this.xmlFile = new File(this.fileName);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public XmlUtils(File file, String string) {
        this.systemID = string;
        this.validating = true;
        this.xmlFile = file;
        try {
            this.fileName = this.xmlFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public XmlUtils(InputStream inputStream, String string, String string2) {
        this.is = inputStream;
        this.systemID = string2;
        this.fileName = string;
    }

    public InputStream getInputStream() {
        logger.entering(CLASSNAME, "getInputStream");
        String string = null;
        FileInputStream fileInputStream = null;
        try {
            string = this.xmlFile.getCanonicalPath();
            fileInputStream = new FileInputStream(this.xmlFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.is = fileInputStream;
        return this.is;
    }

    public Document createDOM() {
        logger.entering(CLASSNAME, "createDOM");
        if (this.is != null) {
            Document document = null;
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            ISCErrorHandler iSCErrorHandler = new ISCErrorHandler(this.fileName);
            documentBuilder.setErrorHandler(iSCErrorHandler);
            try {
                String string = null;
                string = this.systemID.startsWith("/") ? "file://" + this.systemID : "file:///" + this.systemID;
                document = documentBuilder.parse(this.is, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return document;
        }
        System.out.println("Input Stream is null - no DOM created");
        return null;
    }

    private DocumentBuilder getDocumentBuilder() {
        logger.entering(CLASSNAME, "getDocumentBuilder");
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute("http://apache.org/xml/features/validation/schema", Boolean.TRUE);
        documentBuilderFactory.setValidating(this.validating);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace(System.err);
        }
        return documentBuilder;
    }
}

