/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws;

import com.ibm.ws.ExtensionPoint;
import com.ibm.ws.PluginDescriptor;
import com.ibm.ws.PluginModelObject;
import com.ibm.ws.PluginPrerequisite;
import com.ibm.wsspi.IConfigurationElement;
import com.ibm.wsspi.IConfigurationElementSelector;
import com.ibm.wsspi.IExtension;
import com.ibm.wsspi.IExtensionPoint;
import com.ibm.wsspi.IPluginDescriptor;
import com.ibm.wsspi.IPluginRegistry;
import com.ibm.wsspi.IProcessMember;
import com.ibm.wsspi.PluginVersionIdentifier;
import com.ibm.wsspi.RegistryResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PluginRegistry
extends PluginModelObject
implements IPluginRegistry,
Serializable {
    private static final long serialVersionUID = 3796286101566769443L;
    protected static final Logger logger = Logger.getLogger(PluginRegistry.class.getName());
    private HashMap registeredPlugins = new HashMap();

    public IExtensionPoint getExtensionPoint(String string, String string2) {
        PluginDescriptor pluginDescriptor = this.getPlugin(string);
        if (pluginDescriptor == null || !pluginDescriptor.isActive()) {
            return null;
        }
        return pluginDescriptor.getExtensionPoint(string2);
    }

    public IExtension getExtension(String string, String string2, String string3) {
        IExtensionPoint iExtensionPoint = this.getExtensionPoint(string, string2);
        if (iExtensionPoint == null) {
            return null;
        }
        return iExtensionPoint.getDeclaredExtension(string3);
    }

    public void removePlugin(String string) {
        PluginDescriptor[] pluginDescriptorArray = this.hasDependency(string);
        if (pluginDescriptorArray.length != 0) {
            this.printDependents(string, pluginDescriptorArray);
        }
        this.registeredPlugins.remove(string);
    }

    public PluginDescriptor getPlugin(String string, String string2) {
        PluginDescriptor[] pluginDescriptorArray = this.getPlugins(string);
        if (pluginDescriptorArray == null || pluginDescriptorArray.length == 0) {
            return null;
        }
        if (string2 == null) {
            return pluginDescriptorArray[0];
        }
        for (int i = 0; i < pluginDescriptorArray.length; ++i) {
            PluginDescriptor pluginDescriptor = pluginDescriptorArray[i];
            if (!pluginDescriptor.getVersion().equals(string2)) continue;
            return pluginDescriptor;
        }
        return null;
    }

    public PluginDescriptor getPlugin(String string) {
        PluginDescriptor[] pluginDescriptorArray = (PluginDescriptor[])this.registeredPlugins.get(string);
        return pluginDescriptorArray == null ? null : pluginDescriptorArray[0];
    }

    public PluginDescriptor[] getPlugins(String string) {
        return (PluginDescriptor[])this.registeredPlugins.get(string);
    }

    public PluginDescriptor[] getPlugins() {
        ArrayList<PluginDescriptor> arrayList = new ArrayList<PluginDescriptor>(this.registeredPlugins.size());
        Iterator iterator = this.registeredPlugins.values().iterator();
        while (iterator.hasNext()) {
            PluginDescriptor[] pluginDescriptorArray = (PluginDescriptor[])iterator.next();
            for (int i = 0; i < pluginDescriptorArray.length; ++i) {
                arrayList.add(pluginDescriptorArray[i]);
            }
        }
        return arrayList.toArray(new PluginDescriptor[arrayList.size()]);
    }

    public void addPlugin(PluginDescriptor pluginDescriptor) {
        RegistryResolver registryResolver = new RegistryResolver();
        boolean bl = registryResolver.requiredPluginDescriptor(pluginDescriptor);
        if (bl) {
            String string = pluginDescriptor.getUniqueIdentifier();
            PluginDescriptor[] pluginDescriptorArray = this.getPlugins(string);
            if (pluginDescriptorArray == null) {
                pluginDescriptorArray = new PluginDescriptor[]{pluginDescriptor};
                this.registeredPlugins.put(string, pluginDescriptorArray);
            } else {
                for (int i = 0; i < pluginDescriptorArray.length; ++i) {
                    if (pluginDescriptorArray[i].getVersion().equals(pluginDescriptor.getVersion())) {
                        logger.logp(Level.CONFIG, PluginRegistry.class.getName(), "addPlugin", "plugin " + string + ", " + pluginDescriptor.getVersion() + " replaced");
                        pluginDescriptorArray[i] = pluginDescriptor;
                        return;
                    }
                    if (pluginDescriptor.getVersionIdentifier().isGreaterOrEqualTo(pluginDescriptorArray[i].getVersionIdentifier())) continue;
                    logger.logp(Level.CONFIG, PluginRegistry.class.getName(), "addPlugin", "plugin " + string + ", " + pluginDescriptor.getVersion() + " incompatible with " + pluginDescriptorArray[i].getUniqueIdentifier() + ", " + pluginDescriptorArray[i].getVersion());
                    return;
                }
                PluginDescriptor[] pluginDescriptorArray2 = new PluginDescriptor[pluginDescriptorArray.length + 1];
                System.arraycopy(pluginDescriptorArray, 0, pluginDescriptorArray2, 0, pluginDescriptorArray.length);
                pluginDescriptorArray2[pluginDescriptorArray.length] = pluginDescriptor;
                this.registeredPlugins.put(string, pluginDescriptorArray2);
            }
        } else {
            logger.logp(Level.CONFIG, PluginRegistry.class.getName(), "addPlugin", "descriptor could not be resolved");
        }
    }

    public IConfigurationElement[] getConfigurationElementsFor(String string) {
        IExtensionPoint iExtensionPoint = this.getExtensionPoint(string);
        if (iExtensionPoint == null) {
            return new IConfigurationElement[0];
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        return iConfigurationElementArray == null ? new IConfigurationElement[]{} : iConfigurationElementArray;
    }

    public IConfigurationElement[] getConfigurationElementsFor(String string, String string2, String string3) {
        IExtension iExtension = this.getExtension(string, string2, string3);
        if (iExtension == null) {
            return new IConfigurationElement[0];
        }
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        return iConfigurationElementArray == null ? new IConfigurationElement[]{} : iConfigurationElementArray;
    }

    public IExtension getExtension(String string, String string2) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return this.getExtension(string.substring(0, n), string.substring(n + 1), string2);
    }

    public IExtensionPoint getExtensionPoint(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return this.getExtensionPoint(string.substring(0, n), string.substring(n + 1));
    }

    public IExtensionPoint[] getExtensionPoints() {
        PluginDescriptor[] pluginDescriptorArray = this.getPlugins();
        if (pluginDescriptorArray == null) {
            return new IExtensionPoint[0];
        }
        ArrayList<ExtensionPoint> arrayList = new ArrayList<ExtensionPoint>();
        for (int i = 0; i < pluginDescriptorArray.length; ++i) {
            ExtensionPoint[] extensionPointArray;
            if (!pluginDescriptorArray[i].isActive() || (extensionPointArray = pluginDescriptorArray[i].getDeclaredExtensionPoints()) == null) continue;
            for (int j = 0; j < extensionPointArray.length; ++j) {
                arrayList.add(extensionPointArray[j]);
            }
        }
        return arrayList.toArray(new IExtensionPoint[arrayList.size()]);
    }

    public IExtension[] getAllExtensions(String string, IConfigurationElementSelector iConfigurationElementSelector) {
        ArrayList arrayList = new ArrayList();
        IExtensionPoint iExtensionPoint = this.getExtensionPoint(string);
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getDeclaredExtensions();
            for (int i = 0; i < iExtensionArray.length; ++i) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[i].getConfigurationElements();
                this.select(arrayList, iConfigurationElementArray, iConfigurationElementSelector, iExtensionArray[i]);
            }
        }
        return arrayList.toArray(new IExtension[arrayList.size()]);
    }

    public IExtension[] getExtensions(String string, IConfigurationElementSelector iConfigurationElementSelector) {
        ArrayList<IExtension> arrayList = new ArrayList<IExtension>();
        IExtensionPoint iExtensionPoint = this.getExtensionPoint(string);
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getDeclaredExtensions();
            for (int i = 0; i < iExtensionArray.length; ++i) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[i].getConfigurationElements();
                for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                    if (!iConfigurationElementSelector.select(iConfigurationElementArray[j])) continue;
                    arrayList.add(iExtensionArray[i]);
                }
            }
        }
        return arrayList.toArray(new IExtension[arrayList.size()]);
    }

    public IPluginDescriptor getPluginDescriptor(String string) {
        PluginDescriptor pluginDescriptor = this.getPlugin(string);
        if (!pluginDescriptor.isActive()) {
            return null;
        }
        return this.getPlugin(string);
    }

    public IPluginDescriptor getPluginDescriptor(String string, PluginVersionIdentifier pluginVersionIdentifier) {
        PluginDescriptor[] pluginDescriptorArray = this.getPlugins(string);
        if (pluginDescriptorArray == null || pluginDescriptorArray.length == 0) {
            return null;
        }
        if (pluginVersionIdentifier == null) {
            return null;
        }
        for (int i = 0; i < pluginDescriptorArray.length; ++i) {
            if (!pluginDescriptorArray[i].isActive() || !pluginDescriptorArray[i].getVersionIdentifier().equals(pluginVersionIdentifier)) continue;
            return pluginDescriptorArray[i];
        }
        return null;
    }

    public IPluginDescriptor[] getPluginDescriptors() {
        PluginDescriptor[] pluginDescriptorArray = this.getPlugins();
        if (pluginDescriptorArray == null) {
            return new IPluginDescriptor[0];
        }
        ArrayList<PluginDescriptor> arrayList = new ArrayList<PluginDescriptor>(pluginDescriptorArray.length);
        for (int i = 0; i < pluginDescriptorArray.length; ++i) {
            if (!pluginDescriptorArray[i].isActive()) continue;
            arrayList.add(pluginDescriptorArray[i]);
        }
        return arrayList.toArray(new IPluginDescriptor[arrayList.size()]);
    }

    public IPluginDescriptor[] getPluginDescriptors(String string) {
        PluginDescriptor[] pluginDescriptorArray = this.getPlugins(string);
        if (pluginDescriptorArray == null) {
            return new IPluginDescriptor[0];
        }
        ArrayList<PluginDescriptor> arrayList = new ArrayList<PluginDescriptor>(pluginDescriptorArray.length);
        for (int i = 0; i < pluginDescriptorArray.length; ++i) {
            if (!pluginDescriptorArray[i].isActive()) continue;
            arrayList.add(pluginDescriptorArray[i]);
        }
        return arrayList.toArray(new IPluginDescriptor[arrayList.size()]);
    }

    public void processAllElements(String string, IProcessMember iProcessMember) {
        IExtensionPoint iExtensionPoint = this.getExtensionPoint(string);
        IExtension[] iExtensionArray = iExtensionPoint.getDeclaredExtensions();
        for (int i = 0; i < iExtensionArray.length; ++i) {
            IExtension iExtension = iExtensionArray[i];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            this.process(iConfigurationElementArray, iExtensionArray[i], iProcessMember);
        }
    }

    public void processElement(String string, IProcessMember iProcessMember) {
        IExtensionPoint iExtensionPoint = this.getExtensionPoint(string);
        IExtension[] iExtensionArray = iExtensionPoint.getDeclaredExtensions();
        for (int i = 0; i < iExtensionArray.length; ++i) {
            IExtension iExtension = iExtensionArray[i];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                iProcessMember.process(iExtensionArray[i], iConfigurationElementArray[j]);
            }
        }
    }

    public void clear() {
        this.registeredPlugins.clear();
    }

    public PluginDescriptor[] hasDependency(String string) {
        PluginDescriptor[] pluginDescriptorArray = this.getPlugins();
        ArrayList<PluginDescriptor> arrayList = new ArrayList<PluginDescriptor>();
        for (int i = 0; i < pluginDescriptorArray.length; ++i) {
            PluginPrerequisite[] pluginPrerequisiteArray;
            if (pluginDescriptorArray[i].getUniqueIdentifier().equals(string) || !pluginDescriptorArray[i].isActive() || (pluginPrerequisiteArray = pluginDescriptorArray[i].getRequires()) == null) continue;
            for (int j = 0; j < pluginPrerequisiteArray.length; ++j) {
                if (!pluginPrerequisiteArray[j].getUniqueIdentifier().equals(string) || arrayList.contains(pluginDescriptorArray[i])) continue;
                arrayList.add(pluginDescriptorArray[i]);
            }
        }
        return arrayList.toArray(new PluginDescriptor[arrayList.size()]);
    }

    public void printDependents(String string, PluginDescriptor[] pluginDescriptorArray) {
        logger.logp(Level.CONFIG, PluginRegistry.class.getName(), "printDependents", "The dependents of " + string);
        for (int i = 0; i < pluginDescriptorArray.length; ++i) {
            logger.logp(Level.CONFIG, (class$com$ibm$ws$PluginRegistry == null ? PluginRegistry.class$("com.ibm.ws.PluginRegistry") : class$com$ibm$ws$PluginRegistry).getName(), "printDependents", pluginDescriptorArray[i].getUniqueIdentifier());
        }
    }
}

