/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.featurereg.impl;

import com.ibm.ws.featurereg.FeatureInfo;
import com.ibm.ws.featurereg.FeatureRegistry;
import com.ibm.ws.featurereg.PluginInfo;
import com.ibm.ws.featurereg.impl.FeatureXmlParser;
import com.ibm.ws.featurereg.impl.XmlFeatureSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

public class FeatureRegistryImpl
implements FeatureRegistry {
    protected static final String className = "FeatureRegistryImpl";
    protected static Logger logger = null;
    protected String registryDir;
    protected FeatureXmlParser featureXMLParser;
    private XmlFeatureSet installedFeatures = new XmlFeatureSet();
    private static final String FEATURE_METADATA_FILENAME = "feature.xml";

    public FeatureRegistryImpl() {
        this(System.getProperty("was.install.root") + File.separator + "features");
    }

    public FeatureRegistryImpl(String string) {
        this.registryDir = string;
        this.featureXMLParser = new FeatureXmlParser();
        this.loadRegistry();
        this.featureXMLParser.releaseParser();
    }

    private void loadRegistry() {
        String string = "loadRegistry()";
        File file = new File(this.registryDir);
        if (!file.exists()) {
            logger.logp(Level.FINER, className, string, "Specified registry directory " + file + " does not exist.");
            return;
        }
        String[] stringArray = file.list();
        File file2 = null;
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            file2 = new File(file, stringArray[i]);
            if (!this.isFeatureDir(file2)) continue;
            try {
                string2 = file2.getAbsolutePath() + File.separator + FEATURE_METADATA_FILENAME;
                this.featureXMLParser.parse(new FileInputStream(string2), this.installedFeatures);
                continue;
            }
            catch (IOException iOException) {
                logger.logp(Level.FINER, className, string, "Error encountered reading file " + string2, iOException);
                continue;
            }
            catch (SAXException sAXException) {
                logger.logp(Level.FINER, className, string, "Error encountered parsing file " + string2, sAXException);
            }
        }
    }

    private boolean isFeatureDir(File file) {
        String[] stringArray = null;
        if (file.isDirectory()) {
            stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(FEATURE_METADATA_FILENAME)) continue;
                return true;
            }
        }
        return false;
    }

    public PluginInfo[] getPluginInfo(String string) {
        Iterator iterator = this.installedFeatures.getFeatures().values().iterator();
        while (iterator.hasNext()) {
            FeatureInfo featureInfo = (FeatureInfo)iterator.next();
            if (!featureInfo.getVersionedId().equals(string)) continue;
            return featureInfo.getProvidedPlugins();
        }
        return new PluginInfo[0];
    }

    public FeatureInfo[] getInstalledFeatures() {
        FeatureInfo[] featureInfoArray = new FeatureInfo[this.installedFeatures.getFeatures().size()];
        Iterator iterator = this.installedFeatures.getFeatures().values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            featureInfoArray[n] = (FeatureInfo)iterator.next();
            ++n;
        }
        return featureInfoArray;
    }

    static {
        logger = Logger.getLogger(FeatureRegistryImpl.class.getName());
    }
}

