/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.featurereg.impl;

import com.ibm.ws.featurereg.impl.XmlFeature;
import com.ibm.ws.featurereg.impl.XmlFeatureSet;
import com.ibm.ws.featurereg.impl.XmlPluginRef;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeatureXmlParser
extends DefaultHandler {
    private static final String feature_tag = "feature";
    private static final String feature_description_tag = "description";
    private static final String plugin_tag = "plugin";
    private static final String feature_id_attribute = "id";
    private static final String feature_image_attribute = "image";
    private static final String feature_label_attribute = "label";
    private static final String feature_providername_attribute = "provider-name";
    private static final String feature_version_attribute = "version";
    private static final String plugin_id_attribute = "id";
    private static final String plugin_version_attribute = "version";
    private static final String plugin_uri_attribute = "uri";
    private boolean processingDesc = false;
    protected SAXParser parser = null;
    protected Stack xmlFeatureStack = new Stack();
    protected XmlFeatureSet features = null;

    private SAXParser getParser() {
        if (this.parser == null) {
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                this.parser = sAXParserFactory.newSAXParser();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
        }
        return this.parser;
    }

    public void releaseParser() {
        this.parser = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource inputSource, XmlFeatureSet xmlFeatureSet) throws SAXException, IOException {
        this.parser = this.getParser();
        this.features = xmlFeatureSet;
        try {
            this.parser.parse(inputSource, (DefaultHandler)this);
        }
        finally {
            if (inputSource.getByteStream() != null) {
                try {
                    inputSource.getByteStream().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream inputStream, XmlFeatureSet xmlFeatureSet) throws SAXException, IOException {
        this.features = xmlFeatureSet;
        this.parser = this.getParser();
        try {
            this.parser.parse(inputStream, (DefaultHandler)this);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals(feature_tag)) {
            String string4;
            String string5;
            String string6;
            XmlFeature xmlFeature = new XmlFeature();
            xmlFeature.setId(attributes.getValue("id"));
            String string7 = attributes.getValue(feature_image_attribute);
            if (string7 != null) {
                xmlFeature.setImage(string7);
            }
            if ((string6 = attributes.getValue(feature_label_attribute)) != null) {
                xmlFeature.setLabel(string6);
            }
            if ((string5 = attributes.getValue(feature_providername_attribute)) != null) {
                xmlFeature.setProviderName(string5);
            }
            if ((string4 = attributes.getValue("version")) != null) {
                xmlFeature.setVersion(string4);
            }
            this.xmlFeatureStack.push(xmlFeature);
        } else if (string3.equals(feature_description_tag)) {
            this.processingDesc = true;
        } else if (string3.equals(plugin_tag)) {
            String string8;
            XmlPluginRef xmlPluginRef = new XmlPluginRef();
            xmlPluginRef.setId(attributes.getValue("id"));
            String string9 = attributes.getValue("version");
            if (string9 != null) {
                xmlPluginRef.setVersion(string9);
            }
            if ((string8 = attributes.getValue(plugin_uri_attribute)) != null) {
                xmlPluginRef.setUri(string8);
            }
            XmlFeature xmlFeature = (XmlFeature)this.xmlFeatureStack.peek();
            xmlFeature.addPluginReference(xmlPluginRef);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.processingDesc) {
            String string = String.copyValueOf(cArray, n, n2);
            XmlFeature xmlFeature = (XmlFeature)this.xmlFeatureStack.peek();
            xmlFeature.setDescriptionKey(string);
            this.processingDesc = false;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals(feature_tag)) {
            XmlFeature xmlFeature = (XmlFeature)this.xmlFeatureStack.pop();
            this.features.putFeature(xmlFeature);
        }
    }

    public InputSource resolveEntity(String string, String string2) {
        InputSource inputSource = null;
        String string3 = "WEB-INF/features-config_1_0.dtd";
        inputSource = new InputSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(string3));
        return inputSource;
    }
}

