/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.featurereg.impl;

import com.ibm.ws.featurereg.FeatureInfo;
import com.ibm.ws.featurereg.FeatureRegistry;
import com.ibm.ws.featurereg.PluginInfo;
import com.ibm.ws.featurereg.impl.XmlFeature;
import com.ibm.ws.featurereg.impl.XmlPluginRef;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ScaffoldFeatureRegistryImpl
implements FeatureRegistry {
    public static final String FEATUREKEY_J2EE = "J2EE";
    public static final String FEATUREKEY_EXPRESS = "EXPRESS";
    public static final String FEATUREKEY_BASE = "BASE";
    public static final String FEATUREKEY_ND = "ND";
    public static final String FEATUREKEY_UDDI = "UDDI";
    public static final String FEATUREKEY_WSGATEWAY = "WSGATEWAY";
    private Map installedFeatures = new HashMap();

    public ScaffoldFeatureRegistryImpl() {
        this(new String[]{FEATUREKEY_J2EE, FEATUREKEY_EXPRESS});
    }

    public ScaffoldFeatureRegistryImpl(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase(FEATUREKEY_J2EE)) {
                this.simulateJ2EERegistry();
            }
            if (stringArray[i].equalsIgnoreCase(FEATUREKEY_EXPRESS)) {
                this.simulateExpressRegistry();
            }
            if (stringArray[i].equalsIgnoreCase(FEATUREKEY_BASE)) {
                this.simulateBaseRegistry();
            }
            if (stringArray[i].equalsIgnoreCase(FEATUREKEY_ND)) {
                this.simulateNDRegistry();
            }
            if (stringArray[i].equalsIgnoreCase(FEATUREKEY_UDDI)) {
                this.simulateUDDIRegistry();
            }
            if (!stringArray[i].equalsIgnoreCase(FEATUREKEY_WSGATEWAY)) continue;
            this.simulateWSGatewayRegistry();
        }
    }

    private void simulateUDDIRegistry() {
        XmlFeature xmlFeature = new XmlFeature();
        xmlFeature.setId("com.ibm.ws.uddi");
        xmlFeature.setVersion("6.0.0.0");
        xmlFeature.setLabel("%featureName");
        xmlFeature.setProviderName("IBM");
        xmlFeature.setDescriptionKey("%description");
        XmlPluginRef xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.webservices.uddimgmt");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.webservices.uddimgmt/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        this.installedFeatures.put(xmlFeature.getVersionedId(), xmlFeature);
    }

    private void simulateWSGatewayRegistry() {
        XmlFeature xmlFeature = new XmlFeature();
        xmlFeature.setId("com.ibm.ws.wsgateway");
        xmlFeature.setVersion("6.0.0.0");
        xmlFeature.setLabel("%featureName");
        xmlFeature.setProviderName("IBM");
        xmlFeature.setDescriptionKey("%description");
        XmlPluginRef xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.wsgateway");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.wsgateway/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        this.installedFeatures.put(xmlFeature.getVersionedId(), xmlFeature);
    }

    private void simulateNDRegistry() {
        XmlFeature xmlFeature = new XmlFeature();
        xmlFeature.setId("com.ibm.ws.nd");
        xmlFeature.setVersion("6.0.0.0");
        xmlFeature.setLabel("%featureName");
        xmlFeature.setProviderName("IBM");
        xmlFeature.setDescriptionKey("%description");
        XmlPluginRef xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.distmanagement");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.distmanagement/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.datareplication");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.datareplication/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        this.installedFeatures.put(xmlFeature.getVersionedId(), xmlFeature);
    }

    private void simulateBaseRegistry() {
        XmlFeature xmlFeature = new XmlFeature();
        xmlFeature.setId("com.ibm.ws.base");
        xmlFeature.setVersion("6.0.0.0");
        xmlFeature.setLabel("%featureName");
        xmlFeature.setProviderName("IBM");
        xmlFeature.setDescriptionKey("%description");
        XmlPluginRef xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.dynacache");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.dynacache/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.environment");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.environment/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.events");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.events/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.perf.monitor");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.perf.monitor/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.perf.pmi");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.perf.pmi/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.perf.tuning");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.perf.tuning/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.pme");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.pme/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.pme.workmanager");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.pme.workmanager/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.pmirm");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.pmirm/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.problemdetermination");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.problemdetermination/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.resourcemanagement");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.resourcemanagement/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.securitycenter");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.securitycenter/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.sibjmsresources");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.sibjmsresources/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.sibservice");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.sibservice/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.sibresources");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.sibresources/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.tpv");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.tpv/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.webservices");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.webservices/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.wssecurity");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.wssecurity/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.zos");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.zos/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        this.installedFeatures.put(xmlFeature.getVersionedId(), xmlFeature);
    }

    private void simulateExpressRegistry() {
        XmlFeature xmlFeature = new XmlFeature();
        xmlFeature.setId("com.ibm.ws.express");
        xmlFeature.setVersion("6.0.0.0");
        xmlFeature.setLabel("%featureName");
        xmlFeature.setProviderName("IBM");
        xmlFeature.setDescriptionKey("%description");
        this.installedFeatures.put(xmlFeature.getVersionedId(), xmlFeature);
    }

    private void simulateJ2EERegistry() {
        XmlFeature xmlFeature = new XmlFeature();
        xmlFeature.setId("com.ibm.ws.base.j2ee");
        xmlFeature.setVersion("6.0.0.0");
        xmlFeature.setLabel("%featureName");
        xmlFeature.setProviderName("IBM");
        xmlFeature.setDescriptionKey("%description");
        XmlPluginRef xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.servermanagement");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.servermanagement/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.appmanagement");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.appmanagement/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        xmlPluginRef = new XmlPluginRef();
        xmlPluginRef.setId("com.ibm.ws.console.deploymentdescriptor");
        xmlPluginRef.setVersion("6.0.0");
        xmlPluginRef.setUri("/adminconsole.war/WEB-INF/com.ibm.ws.console.deploymentdescriptor/plugin.xml");
        xmlFeature.addPluginReference(xmlPluginRef);
        this.installedFeatures.put(xmlFeature.getVersionedId(), xmlFeature);
    }

    public PluginInfo[] getPluginInfo(String string) {
        if (this.installedFeatures.containsKey(string)) {
            return ((FeatureInfo)this.installedFeatures.get(string)).getProvidedPlugins();
        }
        return new PluginInfo[0];
    }

    public FeatureInfo[] getInstalledFeatures() {
        FeatureInfo[] featureInfoArray = new FeatureInfo[this.installedFeatures.size()];
        Iterator iterator = this.installedFeatures.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            featureInfoArray[n] = (FeatureInfo)iterator.next();
            ++n;
        }
        return featureInfoArray;
    }
}

